/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.billlist;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.BgBillTreeTypeEnum;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.io.IOUtils;

public class BillListUtil {
    private static final long MAX_LOCK_TIME = 600000L;
    private static Map<String, String> fieldMap = new LinkedHashMap<String, String>(){};

    /*
     * Could not resolve type clashes
     */
    public DynamicInfoCollection checkFieldRef(List<Long> ids, Long billId, Long appId) {
        QFBuilder qb = new QFBuilder();
        String refedDmr = "refed_dmr";
        String refedCp = "refed_cp";
        String refedNo = "refed_no";
        String writeoffSch = "refed_wo";
        String queryfield = "number";
        DynamicInfoCollection fieldInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5b57\u6bb5\u7684\u4fe1\u606f", (String)"BillListUtil_10", (String)"epm-eb-business", (Object[])new Object[0]), new String[]{"type", queryfield, "id", "name", refedDmr, refedCp, refedNo, writeoffSch});
        if (ids != null && !ids.isEmpty()) {
            qb.add("id", "in", (Object)ids.toArray());
            DynamicObjectCollection fields = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)"isprefab,id,number,name,type", (QFilter[])qb.toArrays());
            if (fields.isEmpty()) {
                return fieldInfo;
            }
            for (DynamicObject field : fields) {
                String number = field.getString(queryfield);
                String id = field.getString("id");
                String name = field.getString("name");
                fieldInfo.addInfo(new Object[]{field.getString("type"), number, id, name, false, false, true, false});
            }
            qb = new QFBuilder();
            StringBuilder sb = new StringBuilder();
            qb.add("entryentity.bill", "=", (Object)billId);
            String processOperateFields = "entryentity.takeoperation,entryentity.takevalue,entryentity.runoperation,entryentity.runvalue,entryentity.returnoperation,entryentity.clearoperation,entryentity.serqfilter";
            DynamicObjectCollection processSettings = QueryServiceHelper.query((String)"eb_bgcontrolprocess", (String)("number," + processOperateFields), (QFilter[])qb.toArrays());
            List controlValueLists = fieldInfo.getValOfAllPropByAnotherProp(queryfield, "type", (Object)BillFieldTypeEmum.CONTROLVALUE.getNumber());
            List regsitfieldLists = fieldInfo.getValOfAllPropByAnotherProp(queryfield, "type", (Object)BillFieldTypeEmum.REGSITFIELD.getNumber());
            List operationFieldLists = fieldInfo.getValues().stream().filter(k -> k.getValueByPropName("type") != null && Arrays.asList(BillFieldTypeEmum.TAKEOPERATION.getNumber(), BillFieldTypeEmum.RUNOPERATION.getNumber(), BillFieldTypeEmum.RETURNOPERATION.getNumber(), BillFieldTypeEmum.CLEAROPERATION.getNumber()).contains(k.getValueByPropName("type").toString())).map(k -> k.getValueByPropName("number")).collect(Collectors.toList());
            DynamicInfoCollection.InfoObject info = null;
            for (DynamicObject setting : processSettings) {
                List filterRow;
                FlexBDValueCondition flexBDValueCondition;
                if (!controlValueLists.isEmpty() || !operationFieldLists.isEmpty()) {
                    for (String key : processOperateFields.split(",")) {
                        String operateVal = Optional.ofNullable(setting.getString(key)).map(k -> k.replaceAll("\uff0c", ",").replaceAll(" ", "")).orElse("checkedfield");
                        if (("checkedfield".equals(operateVal) || !controlValueLists.stream().anyMatch(e -> Arrays.stream(operateVal.split(",")).collect(Collectors.toList()).contains(e.toString()))) && !operationFieldLists.stream().anyMatch(k -> Arrays.stream(operateVal.split(",")).collect(Collectors.toList()).contains(k.toString()))) continue;
                        sb.append(",");
                        sb.append(operateVal);
                    }
                }
                if (StringUtils.isEmpty((String)setting.getString("entryentity.serqfilter")) || regsitfieldLists.isEmpty() || (flexBDValueCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)setting.getString("entryentity.serqfilter"), FlexBDValueCondition.class)) == null || flexBDValueCondition.getFilterCondition() == null || (filterRow = flexBDValueCondition.getFilterCondition().getFilterRow()).isEmpty()) continue;
                for (SimpleFilterRow sfr : filterRow) {
                    for (Object fieldNum : regsitfieldLists) {
                        if (fieldNum == null) continue;
                        String fn = fieldNum.toString();
                        if ((!StringUtils.isNotEmpty((String)sfr.getFieldName()) || !sfr.getFieldName().startsWith(fn + ".")) && !fn.equals(sfr.getFieldName())) continue;
                        sb.append(",").append(fn);
                    }
                }
            }
            if (sb.length() != 0) {
                for (String fieldVal : sb.toString().split(",")) {
                    info = fieldInfo.getInfoByOneProp(queryfield, (Object)fieldVal);
                    if (info == null) continue;
                    info.setValueByPropName(refedCp, (Object)true);
                    info.setValueByPropName(refedNo, (Object)false);
                    info.setValueByPropName(writeoffSch, (Object)false);
                }
            }
            sb = new StringBuilder();
            qb = new QFBuilder();
            qb.add("bill", "=", (Object)billId);
            String checkFieldKeys = "cardentity.entityfield,cardentity.accountfield,cardentity.yearfield,cardentity.currencyfield,cardentity.userdefined1field,cardentity.changetypefield,cardentity.userdefined2field,cardentity.userdefined3field,cardentity.userdefined4field,cardentity.userdefined5field,cardentity.userdefined6field,cardentity.entityfieldext,cardentity.accountfieldext,cardentity.currencyfieldext,cardentity.userdefined1fieldext,cardentity.userdefined2fieldext,cardentity.userdefined3fieldext,cardentity.userdefined4fieldext,cardentity.userdefined5fieldext,cardentity.userdefined6fieldext,cardentity.changetypefieldext,cardentity.serqfilter,cardentity.valuefieldentry.valuefield";
            DynamicObjectCollection dimMapRules = QueryServiceHelper.query((String)"eb_adddimmaterule", (String)(checkFieldKeys + ",isdynamicvalue"), (QFilter[])qb.toArrays());
            String fieldVal = null;
            List fieldIds = fieldInfo.getValues().stream().filter(k -> k.getValueByPropName("type") != null && Arrays.asList(BillFieldTypeEmum.ORG.getNumber(), BillFieldTypeEmum.ACCOUNT.getNumber(), BillFieldTypeEmum.PERIOD.getNumber(), BillFieldTypeEmum.CURRENCY.getNumber(), BillFieldTypeEmum.ASSIST.getNumber()).contains(k.getValueByPropName("type").toString())).map(k -> k.getValueByPropName("id")).collect(Collectors.toList());
            fieldIds.addAll(fieldInfo.getValues().stream().filter(k -> k.getValueByPropName("type") != null && BillFieldTypeEmum.CONTROLVALUE.getNumber().equals(k.getValueByPropName("type").toString())).map(k -> k.getValueByPropName("number")).collect(Collectors.toList()));
            for (DynamicObject dmr : dimMapRules) {
                List filterRow;
                FlexBDValueCondition flexBDValueCondition;
                boolean isDyn = dmr.getBoolean("isdynamicvalue");
                for (Object checkFieldK : checkFieldKeys.split(",")) {
                    fieldVal = dmr.getString(checkFieldK);
                    if (fieldVal == null || !fieldIds.contains(fieldVal)) continue;
                    DynamicInfoCollection.InfoObject infoObject = info = "cardentity.valuefieldentry.valuefield".equals(checkFieldK) ? fieldInfo.getInfoByOneProp("number", (Object)fieldVal) : fieldInfo.getInfoByOneProp("id", (Object)fieldVal);
                    if ("cardentity.valuefieldentry.valuefield".equals(checkFieldK) && !isDyn || info == null) continue;
                    info.setValueByPropName(refedDmr, (Object)true);
                    info.setValueByPropName(refedNo, (Object)false);
                    info.setValueByPropName(writeoffSch, (Object)false);
                }
                String serqfilter = dmr.getString("cardentity.serqfilter");
                if (fieldVal != null && StringUtils.isNotEmpty((String)serqfilter) && serqfilter.startsWith("{") && (flexBDValueCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)serqfilter, FlexBDValueCondition.class)) != null && flexBDValueCondition.getFilterCondition() != null && !(filterRow = flexBDValueCondition.getFilterCondition().getFilterRow()).isEmpty()) {
                    for (SimpleFilterRow sfr : filterRow) {
                        for (Object fieldNum : regsitfieldLists) {
                            String fn = fieldNum.toString();
                            if (fn.indexOf("model.") != -1) {
                                fn = fn.replaceFirst("model.", "");
                            }
                            if ((!StringUtils.isNotEmpty((String)sfr.getFieldName()) || !sfr.getFieldName().startsWith(fn + ".")) && !fn.equals(sfr.getFieldName())) continue;
                            sb.append(",");
                            sb.append(fieldNum);
                        }
                    }
                }
                if (sb.length() == 0) continue;
                for (String f : sb.toString().split(",")) {
                    info = fieldInfo.getInfoByOneProp(queryfield, (Object)f);
                    if (info == null) continue;
                    info.setValueByPropName(refedDmr, (Object)true);
                    info.setValueByPropName(refedNo, (Object)false);
                    info.setValueByPropName(writeoffSch, (Object)false);
                }
            }
            List writeofffieldLists = fieldInfo.getValOfAllPropByAnotherProp("id", "type", (Object)BillFieldTypeEmum.WRITEOFFFIELD.getNumber());
            if (!writeofffieldLists.isEmpty()) {
                qb = new QFBuilder();
                qb.and("bill", "=", (Object)billId);
                qb.or("writeoffinfo.writeoffsourcebillentry.id", "in", ids);
                String checkWriteoffKeys = "writeoffinfo.writeoffsourcebill,writeoffinfo.writeoffentry,writeoffinfo.writeoffvalue,writeoffinfo.writeoffsourcebillentry";
                DynamicObjectCollection writeoffsche = QueryServiceHelper.query((String)"eb_writeoffscheme_pro", (String)checkWriteoffKeys, (QFilter[])qb.toArrays());
                String fieldVal2 = null;
                for (DynamicObject dmr : writeoffsche) {
                    for (String checkFieldK : checkWriteoffKeys.split(",")) {
                        fieldVal2 = dmr.getString(checkFieldK);
                        if (fieldVal2 == null || !writeofffieldLists.contains(fieldVal2) || (info = fieldInfo.getInfoByOneProp("id", (Object)fieldVal2)) == null) continue;
                        info.setValueByPropName(refedDmr, (Object)false);
                        info.setValueByPropName(refedNo, (Object)false);
                        info.setValueByPropName(writeoffSch, (Object)true);
                    }
                }
            }
        }
        return fieldInfo;
    }

    public List<String> getRefedInfo(DynamicInfoCollection checkResult) {
        List refedDmr = checkResult.getAllValOfOnePropByAnotherProp("name", "refed_dmr", (Object)true);
        List refedCpInfo = checkResult.getAllInfoByOneProp("refed_cp", (Object)true);
        List refed_wo = checkResult.getAllValOfOnePropByAnotherProp("name", "refed_wo", (Object)true);
        ArrayList<String> warnInfos = new ArrayList<String>(16);
        if (!refedDmr.isEmpty()) {
            warnInfos.add(ResManager.loadResFormat((String)"\u5b57\u6bb5\u201c%1\u201d\u5728\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u4e2d\u88ab\u5f15\u7528\u3002", (String)"BillListUtil_11", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)"\uff0c", refedDmr.toArray(new String[1]))}));
        }
        if (!refedCpInfo.isEmpty()) {
            List refedCp = checkResult.getAllValOfOnePropByAnotherProp("name", "refed_cp", (Object)true);
            String type = (String)((DynamicInfoCollection.InfoObject)refedCpInfo.get(0)).getValueByPropName("type");
            if (Arrays.asList(BillFieldTypeEmum.TAKEOPERATION.getNumber(), BillFieldTypeEmum.RUNOPERATION.getNumber(), BillFieldTypeEmum.RETURNOPERATION.getNumber(), BillFieldTypeEmum.CLEAROPERATION.getNumber()).contains(type)) {
                warnInfos.add(ResManager.loadResFormat((String)"\u64cd\u4f5c\u201c%1\u201d\u5728\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u4e2d\u88ab\u5f15\u7528", (String)"BillListUtil_35", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)"\uff0c", refedCp.toArray(new String[1]))}));
            } else {
                warnInfos.add(ResManager.loadResFormat((String)"\u5b57\u6bb5\u201c%1\u201d\u5728\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u4e2d\u88ab\u5f15\u7528\u3002", (String)"BillListUtil_12", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)"\uff0c", refedCp.toArray(new String[1]))}));
            }
        }
        if (!refed_wo.isEmpty()) {
            warnInfos.add(ResManager.loadResFormat((String)"\u5b57\u6bb5\u201c%1\u201d\u5df2\u88ab\u51b2\u9500\u65b9\u6848\u5f15\u7528\u3002", (String)"BillListUtil_13", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)"\uff0c", refed_wo.toArray(new String[1]))}));
        }
        return warnInfos;
    }

    public static TreeNode getFirstBillNode(TreeNode currentNode) {
        TreeNode node = null;
        String billTreeType = BillListUtil.getNodeData41Key("billType", currentNode);
        if (!BgBillTreeTypeEnum.BILL.getNumber().equals(billTreeType)) {
            List childs = currentNode.getChildren();
            if (childs != null && !childs.isEmpty()) {
                TreeNode child;
                Iterator iterator = childs.iterator();
                while (iterator.hasNext() && (node = BillListUtil.getFirstBillNode(child = (TreeNode)iterator.next())) == null) {
                }
            }
        } else {
            node = currentNode;
        }
        return node;
    }

    public static String getNodeData41Key(String key, TreeNode node) {
        String value = null;
        Map data = (Map)node.getData();
        if (data != null) {
            value = (String)data.get(key);
        }
        return value;
    }

    public TreeNode getUserBillTree() {
        String parentId;
        DynamicObjectCollection dynamicObjects1 = BillListUtil.queryNodeBySys(null);
        if (dynamicObjects1 == null || dynamicObjects1.isEmpty()) {
            BillListUtil.presetField();
            dynamicObjects1 = BillListUtil.queryNodeBySys(null);
        }
        TreeNode rootNode = new TreeNode(null, "0", "root");
        HashMap<String, String> rootData = new HashMap<String, String>(16);
        rootData.put("billType", "god");
        rootNode.setData(rootData);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        nodeMap.put("0", rootNode);
        for (DynamicObject node : dynamicObjects1) {
            parentId = node.getString("parent");
            if (parentId == null || "0".equals(parentId)) {
                TreeNode leftNode = this.getLeftNode(node);
                nodeMap.put(node.getString("id"), leftNode);
                continue;
            }
            TreeNode childNode = this.getChildNode(node);
            nodeMap.put(node.getString("id"), childNode);
        }
        for (DynamicObject childNode : dynamicObjects1) {
            parentId = childNode.getString("parent");
            if (parentId == null || !nodeMap.containsKey(parentId)) continue;
            TreeNode node = (TreeNode)nodeMap.get(childNode.getString("id"));
            TreeNode parentNode = (TreeNode)nodeMap.get(parentId);
            ArrayList<TreeNode> children = parentNode.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(16);
                children.add(node);
                parentNode.setChildren(children);
                continue;
            }
            children.add(node);
        }
        return rootNode;
    }

    public static DynamicObjectCollection queryNodeBySys(Boolean isFromOuter) {
        QFBuilder qb = new QFBuilder();
        qb.add("enable", "=", (Object)"1");
        if (isFromOuter != null) {
            qb.add("isfromouter", "=", (Object)isFromOuter);
        }
        return QueryServiceHelper.query((String)"eb_structofbill", (String)"id,name,number,parent,fieldtable,level,isfromouter,isleaf,billtype", (QFilter[])qb.toArrays(), (String)"id");
    }

    public DynamicObject queryFieldTableByID(Long selectedNodeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)selectedNodeId);
        return QueryServiceHelper.queryOne((String)"eb_structofbill", (String)"id,name,number,parent,level,fieldtable,billtype", (QFilter[])new QFilter[]{qFilter});
    }

    private TreeNode getChildNode(DynamicObject dynamicObjects) {
        TreeNode node = new TreeNode();
        node.setId(dynamicObjects.getString("id"));
        node.setText(dynamicObjects.getString("name"));
        String parent = dynamicObjects.getString("parent");
        node.setParentid(parent);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("isNew", "1");
        data.put("name", dynamicObjects.getString("name"));
        data.put("number", dynamicObjects.getString("number"));
        data.put("id", dynamicObjects.getString("id"));
        data.put("isFromOuter", dynamicObjects.getString("isfromouter"));
        data.put("billType", dynamicObjects.getString("billtype"));
        String fieldtable = dynamicObjects.getString("fieldtable");
        if (StringUtils.isNotEmpty((String)"fieldtable")) {
            data.put("fieldtable", fieldtable);
        }
        node.setData(data);
        return node;
    }

    private TreeNode getLeftNode(DynamicObject dynamicObjects) {
        TreeNode rootleft = new TreeNode();
        rootleft.setId(dynamicObjects.getString("id"));
        rootleft.setText(dynamicObjects.getString("name"));
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("isNew", "1");
        data.put("name", dynamicObjects.getString("name"));
        data.put("number", dynamicObjects.getString("number"));
        data.put("id", dynamicObjects.getString("id"));
        data.put("billType", dynamicObjects.getString("billtype"));
        data.put("isFromOuter", dynamicObjects.getString("isfromouter"));
        rootleft.setData(data);
        return rootleft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void presetField() {
        block35: {
            try (DLock lock = DLock.create((String)"fi/eb/bill/fieldpreset");){
                if (lock.tryLock(600000L)) {
                    try {
                        DynamicObjectCollection dynamicObjects = BillListUtil.queryNodeBySys(null);
                        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
                            return;
                        }
                        String resources = BillListUtil.getStringFromResources("billandfield/billper.json");
                        JSONObject jsonObject = JSONObject.parseObject((String)resources);
                        ArrayList<DynamicObject> structOfBillOjbect = new ArrayList<DynamicObject>(16);
                        ArrayList<DynamicObject> fieldObject = new ArrayList<DynamicObject>(16);
                        ArrayList<DynamicObject> fieldShowObject = new ArrayList<DynamicObject>(16);
                        BillListUtil.addToList(jsonObject, structOfBillOjbect, fieldObject, fieldShowObject);
                        try (TXHandle tx = TX.required((String)"fi/eb/bill/fieldpreset");){
                            try {
                                SaveServiceHelper.save((DynamicObject[])structOfBillOjbect.toArray(new DynamicObject[structOfBillOjbect.size()]));
                                SaveServiceHelper.save((DynamicObject[])fieldObject.toArray(new DynamicObject[fieldObject.size()]));
                                SaveServiceHelper.save((DynamicObject[])fieldShowObject.toArray(new DynamicObject[fieldShowObject.size()]));
                                break block35;
                            }
                            catch (Exception e) {
                                tx.markRollback();
                                throw e;
                            }
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u4e92\u65a5\uff1a\u5f53\u524d\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u5904\u7406\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BillListUtil_14", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
    }

    public static String getStringFromResources(String path) {
        String var2;
        InputStream in = null;
        try {
            in = BillListUtil.class.getClassLoader().getResourceAsStream(path);
            var2 = IOUtils.toString((InputStream)in, (String)"UTF-8");
        }
        catch (IOException var6) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"BillListUtil_15", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return var2;
    }

    private static void addToList(JSONObject jsonObject, List<DynamicObject> structOfBillOjbect, List<DynamicObject> fieldObject, List<DynamicObject> fieldShowObject) {
        BillListUtil.addStructOfBillOjbect(jsonObject, "root", null, structOfBillOjbect, fieldObject, fieldShowObject);
    }

    private static void addStructOfBillOjbect(JSONObject jsonObject, String billtype, Object parentid, List<DynamicObject> structOfBillOjbect, List<DynamicObject> fieldObject, List<DynamicObject> fieldShowObject) {
        if (jsonObject == null || StringUtils.isEmpty((String)billtype) || structOfBillOjbect == null || fieldObject == null || fieldShowObject == null || jsonObject.get((Object)billtype) == null) {
            return;
        }
        JSONArray rootArray = jsonObject.getJSONArray(billtype);
        for (Object o : rootArray) {
            JSONObject jsonObject1 = (JSONObject)o;
            DynamicObject root = BusinessDataServiceHelper.newDynamicObject((String)"eb_structofbill");
            BillListUtil.createStructOfBill(jsonObject1, root, parentid, billtype);
            structOfBillOjbect.add(root);
            String billTypeAfter = BillListUtil.getBillTypeAfter(billtype);
            if (StringUtils.isEmpty((String)billTypeAfter)) {
                BillListUtil.addFieldObject(jsonObject1, parentid, root.get("id"), root.getString("fieldtable"), fieldObject, fieldShowObject);
                continue;
            }
            BillListUtil.addStructOfBillOjbect(jsonObject1, billTypeAfter, root.get("id"), structOfBillOjbect, fieldObject, fieldShowObject);
        }
    }

    private static void addFieldObject(JSONObject jsonObject, Object bizSysid, Object bizUnitid, String fieldtable, List<DynamicObject> fieldObject, List<DynamicObject> fieldShowObject) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        HashSet<String> set = new HashSet<String>(16);
        MainEntityType dType = MetadataServiceHelper.getDataEntityType((String)fieldtable);
        DataEntityPropertyCollection properties = dType.getProperties();
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)dType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        MainEntity rootEntity = entityMeta.getRootEntity();
        List operations = rootEntity.getOperations();
        BillListUtil.addToMap(map, set, properties, null, null);
        operations.forEach(op -> map.put(op.getKey(), op.getName().getLocaleValue()));
        int i = 1;
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            if (jsonObject.get((Object)entry.getKey()) == null) continue;
            JSONArray array = jsonObject.getJSONArray(entry.getKey());
            DynamicObject showfield = BusinessDataServiceHelper.newDynamicObject((String)"eb_conbizregdata");
            showfield.set("id", (Object)DBServiceHelper.genGlobalLongId());
            showfield.set("fielddimension", (Object)entry.getValue());
            showfield.set("bill", bizUnitid);
            showfield.set("fieldtable", (Object)fieldtable);
            showfield.set("sequence", (Object)i++);
            DynamicObjectCollection entity = showfield.getDynamicObjectCollection("entryentity");
            int j = 1;
            for (Object o : array) {
                String number = (String)o;
                String name = (String)map.get(number);
                if (number == null || name == null) continue;
                DynamicObject field = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolbizreg");
                DynamicObject show = entity.addNew();
                long id = DBServiceHelper.genGlobalLongId();
                show.set("id", (Object)id);
                show.set("number", (Object)number);
                show.set("name", (Object)name);
                show.set("isprefab", (Object)true);
                show.set("seq", (Object)j++);
                field.set("id", (Object)id);
                field.set("name", (Object)name);
                field.set("number", (Object)number);
                field.set("fieldalias", (Object)number);
                field.set("bizsystemid", bizSysid);
                field.set("bizunitid", bizUnitid);
                field.set("fieldtable", (Object)fieldtable);
                field.set("type", (Object)entry.getKey());
                field.set("typename", (Object)entry.getValue());
                field.set("isentryfield", (Object)set.contains(number));
                field.set("isprefab", (Object)true);
                BillListUtil.setDefaultValue(field);
                fieldObject.add(field);
            }
            fieldShowObject.add(showfield);
        }
    }

    private static void addToMap(Map<String, String> map, Set<String> set, DataEntityPropertyCollection properties, String parentName, String parentNumber) {
        for (IDataEntityProperty property : properties) {
            String number = property.getName();
            if (property.getDisplayName() == null) continue;
            String name = property.getDisplayName().getLocaleValue_zh_CN();
            if (name != null) {
                if (parentName != null && parentNumber != null) {
                    set.add(parentNumber + "." + number);
                    map.put(parentNumber + "." + number, parentName + "." + name);
                } else {
                    map.put(number, name);
                }
            }
            if (!(property instanceof EntryProp)) continue;
            IDataEntityType entryType = ((EntryProp)property).getItemType();
            DataEntityPropertyCollection entryTypeProperties = entryType.getProperties();
            BillListUtil.addToMap(map, set, entryTypeProperties, name, number);
        }
    }

    private static String getBillTypeAfter(String billtype) {
        switch (billtype) {
            case "root": {
                return "cloud";
            }
            case "cloud": {
                return "application";
            }
            case "application": {
                return "bill";
            }
        }
        return null;
    }

    public static String getResName(String number) {
        if ("INSIDE_NODE".equals(number)) {
            return ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf", (String)"BillListUtil_16", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("ESC".equals(number)) {
            return ResManager.loadKDString((String)"\u5458\u5de5\u670d\u52a1\u4e91", (String)"BillListUtil_17", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("exp".equals(number)) {
            return ResManager.loadKDString((String)"\u4eba\u4eba\u8d39\u7528", (String)"BillListUtil_18", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_dailyapplybill".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u7533\u8bf7\u5355", (String)"BillListUtil_19", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_dailyloanbill".equals(number)) {
            return ResManager.loadKDString((String)"\u501f\u6b3e\u5355", (String)"BillListUtil_20", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_dailyreimbursebill".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u62a5\u9500\u5355", (String)"BillListUtil_21", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("tra".equals(number)) {
            return ResManager.loadKDString((String)"\u4eba\u4eba\u5dee\u65c5", (String)"BillListUtil_22", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_tripreqbill".equals(number)) {
            return ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355", (String)"BillListUtil_23", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_tripreimbursebill".equals(number)) {
            return ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"BillListUtil_24", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("FI".equals(number)) {
            return ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"BillListUtil_25", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("em".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u6838\u7b97", (String)"BillListUtil_26", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_publicreimbursebill".equals(number)) {
            return ResManager.loadKDString((String)"\u5bf9\u516c\u62a5\u9500\u5355", (String)"BillListUtil_27", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("OUTER_NODE".equals(number)) {
            return ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf", (String)"BillListUtil_28", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_applyprojectbill".equals(number)) {
            return ResManager.loadKDString((String)"\u7acb\u9879\u5355", (String)"BillListUtil_29", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_withholdingbill".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u9884\u63d0\u5355", (String)"BillListUtil_30", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_costestimatebill".equals(number)) {
            return ResManager.loadKDString((String)"\u6682\u4f30\u5355", (String)"BillListUtil_31", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("cal".equals(number)) {
            return ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97", (String)"BillListUtil_32", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_prepaybill".equals(number)) {
            return ResManager.loadKDString((String)"\u9884\u4ed8\u5355", (String)"BillListUtil_33", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        if ("er_expensesharebill".equals(number)) {
            return ResManager.loadKDString((String)"\u8d39\u7528\u5206\u644a\u5355", (String)"BillListUtil_34", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        return "";
    }

    private static void createStructOfBill(JSONObject jsonObject, DynamicObject root, Object parentid, String billtype) {
        Long id = DBServiceHelper.genGlobalLongId();
        root.set("id", (Object)id);
        root.set("name", (Object)BillListUtil.getResName((String)jsonObject.get((Object)"number")));
        root.set("number", jsonObject.get((Object)"number"));
        root.set("status", (Object)"C");
        root.set("enable", (Object)"1");
        boolean isfromouter = jsonObject.get((Object)"isfromouter") == null ? false : jsonObject.getBoolean("isfromouter");
        root.set("isfromouter", (Object)isfromouter);
        root.set("level", jsonObject.get((Object)"level"));
        root.set("billtype", (Object)billtype);
        if (billtype.equals("bill")) {
            root.set("fieldtable", jsonObject.get((Object)"number"));
        }
        if (parentid != null) {
            root.set("parent", parentid);
        }
        BillListUtil.setDefaultValue(root);
    }

    private static void setDefaultValue(DynamicObject root) {
        try {
            Date time = TimeServiceHelper.parseUserTime((String)"2018-08-08 18:08:08", (Long)1L);
            root.set("creator", (Object)111111111111L);
            root.set("modifier", (Object)111111111111L);
            root.set("createtime", (Object)time);
            root.set("modifytime", (Object)time);
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    static {
        fieldMap.put("ORG", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"BillListUtil_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("ACCOUNT", ResManager.loadKDString((String)"\u79d1\u76ee", (String)"BillListUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("ASSIST", ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6", (String)"BillListUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("PERIOD", ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4", (String)"BillListUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("CURRENCY", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BillListUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("CONTROLVALUE", ResManager.loadKDString((String)"\u63a7\u5236\u503c", (String)"BillListUtil_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("TAKEOPERATION", ResManager.loadKDString((String)"\u5360\u7528", (String)"BillListUtil_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("RUNOPERATION", ResManager.loadKDString((String)"\u6267\u884c", (String)"BillListUtil_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("RETURNOPERATION", ResManager.loadKDString((String)"\u8fd4\u8fd8", (String)"BillListUtil_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fieldMap.put("CLEAROPERATION", ResManager.loadKDString((String)"\u5220\u9664", (String)"BillListUtil_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

