/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.epm.eb.business.bizflow.handler.EbFlowEventHandler;
import kd.epm.eb.business.bizflow.handler.HandlerFactory;
import kd.epm.eb.business.bizflow.pojo.EventConsumeContext;
import kd.epm.eb.business.bizflow.pojo.FlowEventResult;
import kd.epm.eb.business.bizflow.pojo.event.EbFlowEvent;
import kd.epm.eb.business.bizflow.pojo.event.EventStatus;
import kd.epm.eb.business.bizflow.util.BizFlowEventUtil;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;

public class BizFlowMesConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(BizFlowMesConsumer.class);
    private static final BizFlowMesConsumer instance = new BizFlowMesConsumer();

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker backer) {
        EbFlowEvent event = BizFlowEventUtil.readMessageObj(body);
        if (event != null) {
            BizFlowEventUtil.addEventLog(event);
            EbFlowEventHandler handler = HandlerFactory.getHandler(event);
            if (handler != null) {
                EventConsumeContext context = new EventConsumeContext();
                Long flowId = event.getFlowId();
                if (flowId != null) {
                    context.setTaskFlowGraph(TaskFlowServiceHelper.getTaskFlowGraph(flowId));
                }
                if (context.getTaskFlowGraph() != null && !context.getTaskFlowGraph().isStatus()) {
                    log.info("BizFlowEvent-passMessage:" + event.getMesId());
                } else {
                    context.setEvent(event);
                    try {
                        log.info("BizFlowEvent-onMessage:" + event.getMesId());
                        FlowEventResult eventResult = handler.handle(context);
                        String resultStr = null;
                        if (eventResult != null) {
                            resultStr = eventResult.toString();
                        }
                        log.info("BizFlowEvent-endMessage:" + event.getMesId() + ":res:" + resultStr);
                        BizFlowEventUtil.updateEventLogStatus(event.getMesId(), EventStatus.FINISH);
                    }
                    catch (Exception e) {
                        log.error("BizFlowMesConsumer:" + e);
                        BizFlowEventUtil.updateEventLogStatus(event.getMesId(), EventStatus.FAILED);
                        throw e;
                    }
                }
            }
        }
        if (backer != null) {
            backer.ack(messageId);
        }
    }

    public static BizFlowMesConsumer getInstance() {
        return instance;
    }
}

