/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.handler;

import java.util.List;
import kd.epm.eb.business.bizflow.handler.EbFlowEventHandler;
import kd.epm.eb.business.bizflow.pojo.EventConsumeContext;
import kd.epm.eb.business.bizflow.pojo.FlowEventResult;
import kd.epm.eb.business.bizflow.pojo.FlowNodeEventResult;
import kd.epm.eb.business.bizflow.pojo.InstanceStatus;
import kd.epm.eb.business.bizflow.pojo.NodeInstance;
import kd.epm.eb.business.bizflow.pojo.event.EventStatus;
import kd.epm.eb.business.bizflow.pojo.event.NodeEvent;
import kd.epm.eb.business.bizflow.util.BizFlowEventUtil;
import kd.epm.eb.business.bizflow.util.NodeInstanceUtil;
import kd.epm.eb.common.taskflow.TaskFlowNodeType;
import kd.epm.eb.common.taskflow.graph.TaskFlowGraph;
import kd.epm.eb.common.taskflow.graph.TaskFlowLine;
import kd.epm.eb.common.taskflow.graph.TaskFlowNode;

public class AbstractNoteHandler
extends EbFlowEventHandler {
    public FlowNodeEventResult onStart(EventConsumeContext eventContext) {
        return this.getDefaultResult();
    }

    public FlowNodeEventResult onRollBack(EventConsumeContext eventContext) {
        FlowNodeEventResult defaultResult = this.getDefaultResult();
        defaultResult.setToNextNode(false);
        return defaultResult;
    }

    public FlowNodeEventResult onFinish(EventConsumeContext eventContext) {
        return this.getDefaultResult();
    }

    protected FlowNodeEventResult getDefaultResult() {
        FlowNodeEventResult result = new FlowNodeEventResult();
        result.setSuccess(true);
        return result;
    }

    @Override
    public FlowEventResult handle(EventConsumeContext context) {
        NodeEvent event = (NodeEvent)context.getRealEvent();
        FlowNodeEventResult result = null;
        EventStatus status = event.getStatus();
        if (status == EventStatus.START) {
            result = this.onStart(context);
        } else if (status == EventStatus.ROLLBACK) {
            result = this.onRollBack(context);
        } else if (status == EventStatus.FINISH) {
            result = this.onFinish(context);
        }
        if (result != null && !result.isCancel() && result.isSuccess()) {
            this.updateNodeStatus(context, result);
            this.toNextNode(context, result);
        }
        return result;
    }

    public void toNextNode(EventConsumeContext context, FlowNodeEventResult result) {
        if (result == null || !result.isToNextNode()) {
            return;
        }
        NodeEvent preEvent = (NodeEvent)context.getRealEvent();
        TaskFlowGraph taskFlowGraph = context.getTaskFlowGraph();
        if (taskFlowGraph != null) {
            String currentNode = preEvent.getCurrentNode();
            if (preEvent.getNodeType() == TaskFlowNodeType.LINE) {
                TaskFlowNode nextNode;
                TaskFlowLine taskFlowLine = taskFlowGraph.getLine(currentNode);
                if (taskFlowLine != null && (nextNode = taskFlowGraph.getNode(taskFlowLine.getTargetNodeNum())) != null) {
                    NodeEvent ebFlowEvent = new NodeEvent();
                    ebFlowEvent.setNodeType(nextNode.getNodeType());
                    ebFlowEvent.setFlowInstanceId(preEvent.getFlowInstanceId());
                    ebFlowEvent.setCurrentNode(nextNode.getNumber());
                    this.prepareNodeParam(preEvent, ebFlowEvent, result);
                    BizFlowEventUtil.sendMessage(ebFlowEvent);
                }
            } else {
                List nextLines = taskFlowGraph.getNextLineByNode(currentNode);
                for (TaskFlowLine line : nextLines) {
                    NodeEvent ebFlowEvent = new NodeEvent();
                    ebFlowEvent.setNodeType(TaskFlowNodeType.LINE);
                    ebFlowEvent.setCurrentNode(line.getNumber());
                    this.prepareNodeParam(preEvent, ebFlowEvent, result);
                    BizFlowEventUtil.sendMessage(ebFlowEvent);
                }
            }
        }
    }

    protected void updateNodeStatus(EventConsumeContext context, FlowNodeEventResult result) {
        NodeEvent event = (NodeEvent)context.getRealEvent();
        TaskFlowNodeType nodeType = event.getNodeType();
        TaskFlowGraph taskFlowGraph = context.getTaskFlowGraph();
        if (nodeType != TaskFlowNodeType.LINE && taskFlowGraph != null) {
            List<NodeInstance> refNodeInstance = event.getRefNodeInstance();
            if (refNodeInstance == null) {
                refNodeInstance = result.getRefNodeInstance();
            }
            if (refNodeInstance != null) {
                EventStatus eventStatus = event.getStatus();
                for (NodeInstance nodeInstance : refNodeInstance) {
                    if (nodeInstance.getNewStatus() != null) continue;
                    if (EventStatus.FINISH == eventStatus || result.isToNextNode()) {
                        nodeInstance.setNewStatus(InstanceStatus.END);
                        continue;
                    }
                    if (EventStatus.START == eventStatus) {
                        nodeInstance.setNewStatus(InstanceStatus.ING);
                        continue;
                    }
                    if (EventStatus.ROLLBACK != eventStatus) continue;
                    nodeInstance.setNewStatus(InstanceStatus.ING);
                }
            }
            NodeInstanceUtil.updateStatus(refNodeInstance, event.getFlowInstanceId(), event.getCurrentNode());
        }
    }

    protected void prepareNodeParam(NodeEvent currentNodeEvent, NodeEvent nextNodeEvent, FlowNodeEventResult result) {
        nextNodeEvent.setFlowInstanceId(currentNodeEvent.getFlowInstanceId());
        nextNodeEvent.setFlowId(currentNodeEvent.getFlowId());
        nextNodeEvent.setUseQueue(false);
        nextNodeEvent.setPreNode(currentNodeEvent.getCurrentNode());
        nextNodeEvent.setStatus(EventStatus.START);
    }
}

