/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.epm.eb.business.bizflow.handler.ReportNodeHandler;
import kd.epm.eb.business.bizflow.pojo.EventConsumeContext;
import kd.epm.eb.business.bizflow.pojo.FlowNodeEventResult;
import kd.epm.eb.business.bizflow.pojo.NodeInstance;
import kd.epm.eb.business.bizflow.pojo.event.NodeEvent;
import kd.epm.eb.business.bizflow.util.NodeInstanceUtil;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.message.MessageUtils;
import kd.epm.eb.common.taskflow.ExecutorGroupDto;
import kd.epm.eb.common.taskflow.graph.TaskFlowGraph;
import kd.epm.eb.common.taskflow.graph.TaskFlowLine;
import kd.epm.eb.common.taskflow.graph.TaskFlowNode;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.UserUtils;

public class ApproveNodeHandler
extends ReportNodeHandler {
    private static final Log log = LogFactory.getLog(ApproveNodeHandler.class);

    @Override
    public FlowNodeEventResult onStart(EventConsumeContext eventContext) {
        List<NodeInstance> updateNodeInstanceList;
        NodeEvent nodeEvent = (NodeEvent)eventContext.getRealEvent();
        Long flowInstId = nodeEvent.getFlowInstanceId();
        String currNodeKey = nodeEvent.getCurrentNode();
        log.info("ApproveNodeHandler#start flowInstId={}, currNodeKey={}", (Object)flowInstId, (Object)currNodeKey);
        List<NodeInstance> nodeInstanceList = nodeEvent.getRefNodeInstance();
        if (CollectionUtils.isEmpty(nodeInstanceList)) {
            nodeInstanceList = NodeInstanceUtil.getNodeInstanceByNode(flowInstId, Collections.singleton(currNodeKey));
        }
        if (CollectionUtils.isEmpty(nodeInstanceList)) {
            log.error("ApproveNodeHandler#start flowInstId={}, currNodeKey={}, nodeInstanceList is empty", (Object)flowInstId, (Object)currNodeKey);
            FlowNodeEventResult result = new FlowNodeEventResult();
            result.setSuccess(true);
            result.setToNextNode(false);
            return result;
        }
        Set<Long> submitOrgIds = nodeInstanceList.stream().map(NodeInstance::getTaskDimMember).collect(Collectors.toSet());
        TaskFlowGraph taskFlowGraph = eventContext.getTaskFlowGraph();
        TaskFlowNode currNode = taskFlowGraph.getNode(currNodeKey);
        TaskFlowLine currTaskFlowLine = taskFlowGraph.getLine(nodeEvent.getPreNode());
        TaskFlowNode preNode = taskFlowGraph.getNode(currTaskFlowLine.getSourceNodeNum());
        if (preNode.isStartNode()) {
            this.sendMessage(currNode.getSubTaskIds(), submitOrgIds, flowInstId);
            updateNodeInstanceList = nodeInstanceList;
        } else {
            Map<String, Object> dataMap = nodeEvent.getCustomData();
            boolean preNodeFinished = (Boolean)dataMap.get("preNodeFinished");
            if (preNodeFinished) {
                this.sendMessage(currNode.getSubTaskIds(), submitOrgIds, flowInstId);
                updateNodeInstanceList = nodeInstanceList;
            } else {
                Set outputOrgIds = (Set)dataMap.get("outputOrgIds");
                this.sendMessage(currNode.getSubTaskIds(), outputOrgIds, flowInstId);
                updateNodeInstanceList = nodeInstanceList.stream().filter(v -> outputOrgIds.contains(v.getTaskDimMember())).collect(Collectors.toList());
            }
        }
        Set<Long> auditPassedReportIds = TaskFlowServiceHelper.getAuditPassedReportIds(flowInstId, currNodeKey, submitOrgIds);
        log.info("ApproveNodeHandler#start flowInstId={}, currNodeKey={}, auditPassedReportIds size={}", new Object[]{flowInstId, currNodeKey, auditPassedReportIds.size()});
        FlowNodeEventResult result = new FlowNodeEventResult();
        result.setSuccess(true);
        if (CollectionUtils.isEmpty(auditPassedReportIds)) {
            result.setToNextNode(false);
            result.setRefNodeInstance(updateNodeInstanceList);
        } else {
            List<NodeInstance> newNodeInstanceList = nodeInstanceList.stream().filter(v -> auditPassedReportIds.contains(v.getRefObj())).collect(Collectors.toList());
            result.setRefNodeInstance(newNodeInstanceList);
        }
        return result;
    }

    @Override
    protected void prepareNodeParam(NodeEvent currentNodeEvent, NodeEvent nextNodeEvent, FlowNodeEventResult result) {
        super.prepareNodeParam(currentNodeEvent, nextNodeEvent, result);
        List<NodeInstance> nodeInstanceList = currentNodeEvent.getRefNodeInstance();
        nextNodeEvent.setRefNodeInstance(nodeInstanceList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(List<Long> taskIds, Set<Long> outputOrgIds, Long flowInstId) {
        Class<ApproveNodeHandler> clazz = ApproveNodeHandler.class;
        synchronized (ApproveNodeHandler.class) {
            Long tempId;
            Long orgId;
            Long taskPackId;
            log.info("ApproveNodeHandler#sendMessage flowInstId={}, taskIds={}, outputOrgIds={} start", new Object[]{flowInstId, taskIds, outputOrgIds});
            if (CollectionUtils.isEmpty(outputOrgIds)) {
                log.error("ApproveNodeHandler#sendMessage flowInstId={}, taskIds={}, outputOrgIds is empty", (Object)flowInstId, taskIds);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            QFilter taskProcessFilter = new QFilter("task", "in", taskIds);
            taskProcessFilter.and("org", "in", outputOrgIds);
            DynamicObjectCollection taskProcessList = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id,task.tasklist.model.id", (QFilter[])taskProcessFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)taskProcessList)) {
                log.error("ApproveNodeHandler#sendMessage flowInstId={}, taskIds={}, taskProcessList is empty", (Object)flowInstId, taskIds);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            Long modelId = 0L;
            HashSet<Long> pkIds = new HashSet<Long>(16);
            for (DynamicObject taskProcess : taskProcessList) {
                modelId = taskProcess.getLong("task.tasklist.model.id");
                pkIds.add(taskProcess.getLong("id"));
            }
            Map taskProcessMap = BusinessDataServiceHelper.loadFromCache((Object[])pkIds.toArray(), (String)"eb_taskprocess");
            HashSet<Long> sourceIds = new HashSet<Long>(16);
            HashSet<Long> orgIds = new HashSet<Long>(16);
            HashSet<Long> tempIds = new HashSet<Long>(16);
            for (DynamicObject taskProcess : taskProcessMap.values()) {
                Long taskPackId2 = taskProcess.getLong("task.tasklist.id");
                Long orgId2 = taskProcess.getLong("org.id");
                Long tempId2 = taskProcess.getLong("template.id");
                sourceIds.add(taskPackId2);
                orgIds.add(orgId2);
                tempIds.add(tempId2);
            }
            QFilter qFilter = new QFilter("flowinstid", "=", (Object)flowInstId);
            qFilter.and("source", "in", sourceIds);
            qFilter.and("org", "in", orgIds);
            qFilter.and("temp", "in", tempIds);
            DynamicObjectCollection sendMsgList = QueryServiceHelper.query((String)"eb_taskflow_msg", (String)"flowinstid,source,org,temp,executor", (QFilter[])qFilter.toArray());
            HashSet<String> msgKeys = new HashSet<String>(16);
            for (DynamicObject sendMsg : sendMsgList) {
                Long instId = sendMsg.getLong("flowinstid");
                taskPackId = sendMsg.getLong("source");
                orgId = sendMsg.getLong("org");
                tempId = sendMsg.getLong("temp");
                Long executorId = sendMsg.getLong("executor");
                msgKeys.add(instId + "!" + taskPackId + "!" + orgId + "!" + tempId + "!" + executorId);
            }
            HashMap<Long, Set<ExecutorGroupDto>> executorGroupMap = new HashMap<Long, Set<ExecutorGroupDto>>(16);
            for (DynamicObject taskProcess : taskProcessMap.values()) {
                taskPackId = taskProcess.getLong("task.tasklist.id");
                orgId = taskProcess.getLong("org.id");
                tempId = taskProcess.getLong("template.id");
                ExecutorGroupDto groupDto = new ExecutorGroupDto();
                groupDto.setTaskPackId(taskPackId);
                groupDto.setEntityId(orgId);
                groupDto.setTempId(tempId);
                DynamicObjectCollection executors = taskProcess.getDynamicObjectCollection("executors");
                for (DynamicObject executor : executors) {
                    Long executorId = executor.getLong("fbasedataid_id");
                    String uniqueKeys = flowInstId + "!" + taskPackId + "!" + orgId + "!" + tempId + "!" + executorId;
                    if (msgKeys.contains(uniqueKeys)) continue;
                    Set group = executorGroupMap.computeIfAbsent(executorId, v -> new HashSet(16));
                    group.add(groupDto);
                }
            }
            if (executorGroupMap.isEmpty()) {
                log.error("ApproveNodeHandler#sendMessage flowInstId={}, taskIds={}, message sent", (Object)flowInstId, taskIds);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            this.sendMessage(modelId, executorGroupMap, flowInstId);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void sendMessage(Long modelId, Map<Long, Set<ExecutorGroupDto>> executorGroupMap, Long flowInstId) {
        this.saveSendMsg(modelId, flowInstId, executorGroupMap);
        String title = ResManager.loadKDString((String)"\u9884\u7b97\u7f16\u5236\u901a\u77e5", (String)"ApproveNodeHandler_1", (String)"epm-eb-business", (Object[])new Object[0]);
        String tag = ResManager.loadKDString((String)"\u6211\u6267\u884c\u7684\u4efb\u52a1", (String)"ApproveNodeHandler_2", (String)"epm-eb-business", (Object[])new Object[0]);
        StringBuilder url = new StringBuilder();
        url.append(UrlService.getDomainContextUrl()).append("/?formId=eb_executetask").append("&model=").append(modelId).append("&isTaskFlow=true");
        for (Map.Entry<Long, Set<ExecutorGroupDto>> entry : executorGroupMap.entrySet()) {
            ArrayList<Long> receivers = new ArrayList<Long>(1);
            receivers.add(entry.getKey());
            Set<ExecutorGroupDto> executorGroup = entry.getValue();
            Set<Long> taskPackIds = executorGroup.stream().map(ExecutorGroupDto::getTaskPackId).collect(Collectors.toSet());
            Set<Long> entityIds = executorGroup.stream().map(ExecutorGroupDto::getEntityId).collect(Collectors.toSet());
            Set<Long> tempIds = executorGroup.stream().map(ExecutorGroupDto::getTempId).collect(Collectors.toSet());
            String content = this.buildMessageContent(taskPackIds, entityIds, tempIds);
            MessageUtils.get().sendMessageWithSender("eb_executetask", title, content, receivers, MessageUtils.MessageType.YUNZHIJIA, UserUtils.getUserId(), tag, url.toString());
        }
    }

    private void saveSendMsg(Long modelId, Long flowInstId, Map<Long, Set<ExecutorGroupDto>> executorGroupMap) {
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> sendMsgList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Long, Set<ExecutorGroupDto>> entry : executorGroupMap.entrySet()) {
            Long executorId = entry.getKey();
            Set<ExecutorGroupDto> groupList = entry.getValue();
            for (ExecutorGroupDto group : groupList) {
                Long taskPackId = group.getTaskPackId();
                Long orgId = group.getEntityId();
                Long tempId = group.getTempId();
                DynamicObject sendMsg = BusinessDataServiceHelper.newDynamicObject((String)"eb_taskflow_msg");
                sendMsg.set("model", (Object)modelId);
                sendMsg.set("flowinstid", (Object)flowInstId);
                sendMsg.set("executor", (Object)executorId);
                sendMsg.set("source", (Object)taskPackId);
                sendMsg.set("org", (Object)orgId);
                sendMsg.set("temp", (Object)tempId);
                sendMsg.set("createdate", (Object)now);
                sendMsgList.add(sendMsg);
            }
        }
        SaveServiceHelper.save((DynamicObject[])sendMsgList.toArray(new DynamicObject[sendMsgList.size()]));
    }

    private String buildMessageContent(Set<Long> taskPackIds, Set<Long> entityIds, Set<Long> tempIds) {
        QFilter qFilter = new QFilter("id", "in", taskPackIds);
        DynamicObjectCollection taskPackList = QueryServiceHelper.query((String)"eb_tasklist", (String)"model,year,datatype,version", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)taskPackList)) {
            return "";
        }
        Long modelId = 0L;
        HashSet<Long> periodIds = new HashSet<Long>(taskPackList.size());
        HashSet<Long> datatypeIds = new HashSet<Long>(taskPackList.size());
        HashSet<Long> versionIds = new HashSet<Long>(taskPackList.size());
        for (DynamicObject taskPack : taskPackList) {
            modelId = taskPack.getLong("model");
            Long periodId = taskPack.getLong("year");
            Long datatypeId = taskPack.getLong("datatype");
            Long versionId = taskPack.getLong("version");
            periodIds.add(periodId);
            datatypeIds.add(datatypeId);
            versionIds.add(versionId);
        }
        QFilter reportFilter = new QFilter("model", "=", (Object)modelId);
        reportFilter.and("period", "in", periodIds);
        reportFilter.and("version", "in", versionIds);
        reportFilter.and("datatype", "in", datatypeIds);
        reportFilter.and("entity", "in", entityIds);
        reportFilter.and("template", "in", tempIds);
        DynamicObjectCollection reportProcessList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,period.id,period.name,version.id,version.name,datatype.id,datatype.name,entity.id,entity.name,template.name", (QFilter[])reportFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)reportProcessList)) {
            return "";
        }
        HashMap<String, Set> reportMap = new HashMap<String, Set>(16);
        StringBuilder rowKeys = new StringBuilder();
        for (DynamicObject reportProcess : reportProcessList) {
            Long entityId = reportProcess.getLong("entity.id");
            String entityName = reportProcess.getString("entity.name");
            Long periodId = reportProcess.getLong("period.id");
            String periodName = reportProcess.getString("period.name");
            Long versionId = reportProcess.getLong("version.id");
            String versionName = reportProcess.getString("version.name");
            Long datatypeId = reportProcess.getLong("datatype.id");
            String datatypeName = reportProcess.getString("datatype.name");
            rowKeys.append(entityId).append("@").append(entityName).append("!!").append(periodId).append("@").append(periodName).append("!!").append(versionId).append("@").append(versionName).append("!!").append(datatypeId).append("@").append(datatypeName);
            String templateName = reportProcess.getString("template.name");
            Set templateNames = reportMap.computeIfAbsent(rowKeys.toString(), v -> new HashSet(16));
            templateNames.add(templateName);
            rowKeys.setLength(0);
        }
        if (reportMap.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u7f16\u5236\u8303\u56f4\uff1a", (String)"ApproveNodeHandler_3", (String)"epm-eb-business", (Object[])new Object[0]));
        for (Map.Entry entry : reportMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] dimArr = key.split("!!");
            String[] entityArr = dimArr[0].split("@");
            String entityName = entityArr[1];
            String[] periodArr = dimArr[1].split("@");
            String periodName = periodArr[1];
            String[] versionArr = dimArr[2].split("@");
            String versionName = versionArr[1];
            String[] datatypeArr = dimArr[3].split("@");
            String datatypeName = datatypeArr[1];
            Set tempNames = (Set)entry.getValue();
            String reportNames = tempNames.stream().collect(Collectors.joining(","));
            message.append(ResManager.loadResFormat((String)"%1-%2-%3-%4;%5", (String)"ApproveNodeHandler_4", (String)"epm-eb-business", (Object[])new Object[]{entityName, periodName, versionName, datatypeName, reportNames}));
            message.append("\n\r");
        }
        return message.toString();
    }
}

