/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.epm.eb.business.bizflow.handler.BizEventHandler;
import kd.epm.eb.business.bizflow.pojo.EventConsumeContext;
import kd.epm.eb.business.bizflow.pojo.FlowEventResult;
import kd.epm.eb.business.bizflow.pojo.InstanceStatus;
import kd.epm.eb.business.bizflow.pojo.NodeInstance;
import kd.epm.eb.business.bizflow.pojo.NodeStatusObj;
import kd.epm.eb.business.bizflow.pojo.event.EventStatus;
import kd.epm.eb.business.bizflow.pojo.event.NodeEvent;
import kd.epm.eb.business.bizflow.pojo.event.NodeUpdateEvent;
import kd.epm.eb.business.bizflow.util.BizFlowEventUtil;
import kd.epm.eb.business.bizflow.util.BizFlowInstanceUtil;
import kd.epm.eb.business.bizflow.util.NodeInstanceUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.taskflow.TaskFlowNodeType;
import kd.epm.eb.common.taskflow.graph.TaskFlowGraph;
import kd.epm.eb.common.taskflow.graph.TaskFlowLine;
import kd.epm.eb.common.utils.CollectionUtils;

public class FLowUpdateHandler
extends BizEventHandler {
    @Override
    public FlowEventResult handle(EventConsumeContext context) {
        NodeUpdateEvent updateEvent = (NodeUpdateEvent)context.getRealEvent();
        if (updateEvent.isDeleteTaskFlow()) {
            this.delFlowDel(updateEvent);
        } else {
            this.delNodeUpdate(context, updateEvent);
        }
        return null;
    }

    private void delFlowDel(NodeUpdateEvent updateEvent) {
        Long flowId = updateEvent.getFlowId();
        List<Long> flowInsIdList = BizFlowInstanceUtil.getFlowInsByFlowId(flowId);
        if (flowInsIdList.size() > 0) {
            try (TXHandle txHandle = TX.required((String)"FLowUpdateHandler-del");){
                try {
                    BizFlowInstanceUtil.delFlowInsById(flowInsIdList);
                    NodeInstanceUtil.delNodeInsByFlowAndNode(flowInsIdList, null);
                    NodeInstanceUtil.delNodeStatusByFlowAndNode(flowInsIdList, null);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    throw e;
                }
            }
        }
    }

    private void delNodeUpdate(EventConsumeContext context, NodeUpdateEvent updateEvent) {
        Map<String, List<NodeInstance>> upNodeInstances = updateEvent.getUpNodeInstances();
        List<String> upLineKeys = updateEvent.getUpLineKeys();
        if (CollectionUtils.isNotEmpty(upNodeInstances) || CollectionUtils.isNotEmpty(upLineKeys)) {
            List<Long> flowInsIds;
            TaskFlowGraph taskFlowGraph = context.getTaskFlowGraph();
            if (updateEvent.isCheckInstance()) {
                BizFlowInstanceUtil.addBizFlowInstance(taskFlowGraph.getId(), 0L, true);
            }
            if (CollectionUtils.isNotEmpty(flowInsIds = BizFlowInstanceUtil.getFlowInsByFlowId(taskFlowGraph.getId()))) {
                HashSet<String> callNodes = new HashSet<String>(16);
                HashSet<String> delNodes = new HashSet<String>(16);
                ArrayList<Pair<Long, String>> delNodeInsPair = new ArrayList<Pair<Long, String>>(16);
                if (CollectionUtils.isNotEmpty(upNodeInstances) || CollectionUtils.isNotEmpty(upLineKeys)) {
                    LinkedList<Long> delStatusObjIdList = new LinkedList<Long>();
                    this.selDelNodeAndPreNode(upLineKeys, delNodes, callNodes, taskFlowGraph, upNodeInstances);
                    ArrayList<NodeInstance> newNodeIns = new ArrayList<NodeInstance>(16);
                    if (CollectionUtils.isNotEmpty(upNodeInstances)) {
                        callNodes.removeAll(upNodeInstances.keySet());
                        this.selData(flowInsIds, upNodeInstances, newNodeIns, delNodeInsPair, delStatusObjIdList);
                    }
                    try (TXHandle txHandle = TX.required((String)"FLowUpdateHandler");){
                        try {
                            this.updateNodeIns(delNodes, flowInsIds, delNodeInsPair, newNodeIns);
                            this.updateNodeStatus(newNodeIns, flowInsIds, delNodes, delStatusObjIdList, updateEvent.isCheckInstance());
                            this.callPreNodes(taskFlowGraph, flowInsIds, callNodes);
                        }
                        catch (Exception e) {
                            txHandle.markRollback();
                            throw e;
                        }
                    }
                }
            }
        }
    }

    private void updateNodeIns(Set<String> delNodes, List<Long> flowInsIds, List<Pair<Long, String>> delNodeInsPair, List<NodeInstance> newNodeIns) {
        if (delNodes.size() > 0) {
            NodeInstanceUtil.delNodeInsByFlowAndNode(flowInsIds, delNodes);
        }
        if (delNodeInsPair.size() > 0) {
            NodeInstanceUtil.delNodeInsByFlowAndNodeBat(delNodeInsPair);
        }
        if (newNodeIns.size() > 0) {
            NodeInstanceUtil.addNodeInstances(newNodeIns);
        }
    }

    private void callPreNodes(TaskFlowGraph taskFlowGraph, List<Long> flowInsIdList, Set<String> targetNodeKeys) {
        if (CollectionUtils.isEmpty(targetNodeKeys)) {
            return;
        }
        Long flowId = taskFlowGraph.getId();
        if (targetNodeKeys.contains("start")) {
            for (Long flowInsId2 : flowInsIdList) {
                NodeEvent nodeEvent = new NodeEvent();
                nodeEvent.setFlowInstanceId(flowInsId2);
                nodeEvent.setCurrentNode("start");
                nodeEvent.setStatus(EventStatus.FINISH);
                nodeEvent.setResend(false);
                nodeEvent.setUseQueue(false);
                nodeEvent.setNodeType(TaskFlowNodeType.START);
                nodeEvent.setFlowId(flowId);
                BizFlowEventUtil.sendMessage(nodeEvent);
            }
        } else {
            Map<Long, Map<String, List<NodeInstance>>> nodeInsByNode = NodeInstanceUtil.getNodeInsByNode(flowInsIdList, targetNodeKeys, InstanceStatus.END);
            if (nodeInsByNode.size() > 0) {
                nodeInsByNode.forEach((flowInsId, nodeInsMap) -> nodeInsMap.forEach((nodeKey, nodeInsList) -> {
                    NodeEvent nodeEvent = new NodeEvent();
                    nodeEvent.setFlowInstanceId((Long)flowInsId);
                    nodeEvent.setCurrentNode((String)nodeKey);
                    nodeEvent.setStatus(EventStatus.FINISH);
                    nodeEvent.setResend(false);
                    nodeEvent.setUseQueue(false);
                    nodeEvent.setNodeType(TaskFlowNodeType.APPROVE);
                    nodeEvent.setRefNodeInstance((List<NodeInstance>)nodeInsList);
                    nodeEvent.setFlowId(flowId);
                    BizFlowEventUtil.sendMessage(nodeEvent);
                }));
            }
        }
    }

    private void selDelNodeAndPreNode(List<String> upLineKeys, Set<String> delNodes, Set<String> callNodes, TaskFlowGraph taskFlowGraph, Map<String, List<NodeInstance>> upNodeInstances) {
        if (CollectionUtils.isNotEmpty(upLineKeys)) {
            for (String lineKey : upLineKeys) {
                String source;
                TaskFlowLine line2 = taskFlowGraph.getLine(lineKey);
                if (line2 == null || (source = line2.getSourceNodeNum()) == null) continue;
                callNodes.add(source);
            }
        }
        if (CollectionUtils.isNotEmpty(upNodeInstances)) {
            Iterator<Map.Entry<String, List<NodeInstance>>> iterator = upNodeInstances.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<NodeInstance>> entry = iterator.next();
                if (entry.getValue() == null) {
                    delNodes.add(entry.getKey());
                    iterator.remove();
                    continue;
                }
                List nodePreRelLine = taskFlowGraph.getNodePreRelLine(entry.getKey());
                if (nodePreRelLine == null) continue;
                nodePreRelLine.forEach(line -> {
                    String source = line.getSourceNodeNum();
                    if (source != null) {
                        callNodes.add(source);
                    }
                });
            }
        }
    }

    private void selData(List<Long> flowInsIds, Map<String, List<NodeInstance>> upNodeInstances, List<NodeInstance> newNodeIns, List<Pair<Long, String>> delNodeInsPair, List<Long> delStatusObjsIds) {
        Map<Long, Map<String, Map<Long, NodeInstance>>> nodeInsRptMap = NodeInstanceUtil.getNodeInsMapByNode(flowInsIds, upNodeInstances.keySet());
        List<NodeStatusObj> oldNodeStatusList = NodeInstanceUtil.selNodeStatusByFlowIns(flowInsIds, upNodeInstances.keySet());
        HashMap oldNodeStatusMap = new HashMap(flowInsIds.size());
        oldNodeStatusList.forEach(statusObj -> oldNodeStatusMap.computeIfAbsent(statusObj.getFlowInsId(), key -> new HashMap(16)).put(statusObj.getNodeKey(), statusObj));
        for (Long flowInsId : flowInsIds) {
            Map allOldNodeInsMap = nodeInsRptMap.getOrDefault(flowInsId, new HashMap(16));
            Map oldStatusObjMap = oldNodeStatusMap.getOrDefault(flowInsId, new HashMap(16));
            upNodeInstances.forEach((nodeKey, nodeInsList) -> {
                NodeStatusObj oldStatusObj = (NodeStatusObj)oldStatusObjMap.get(nodeKey);
                if (oldStatusObj != null) {
                    if (oldStatusObj.getStatus() == InstanceStatus.END) {
                        return;
                    }
                    delStatusObjsIds.add(oldStatusObj.getId());
                }
                Map oldNodeInsMap = allOldNodeInsMap.getOrDefault(nodeKey, new HashMap(16));
                nodeInsList.forEach(nodeIns -> {
                    NodeInstance oldNodeIns = (NodeInstance)oldNodeInsMap.get(nodeIns.getRefObj());
                    if (oldNodeIns == null || oldNodeIns.getStatus() != nodeIns.getStatus()) {
                        if (nodeIns.getId() == null) {
                            nodeIns.setId(0L);
                        } else {
                            nodeIns = nodeIns.clone();
                        }
                        nodeIns.setFlowInstanceId(flowInsId);
                        newNodeIns.add((NodeInstance)nodeIns);
                    } else {
                        newNodeIns.add(oldNodeIns);
                    }
                });
                delNodeInsPair.add(new Pair((Object)flowInsId, nodeKey));
            });
        }
    }

    private void updateNodeStatus(List<NodeInstance> newNodeIns, List<Long> flowInsIdList, Set<String> delNodeKeys, List<Long> delStatusObjIds, boolean addStarNode) {
        HashMap<Long, Map<String, NodeStatusObj>> newRecordsMap = new HashMap<Long, Map<String, NodeStatusObj>>(16);
        for (NodeInstance nodeInstance : newNodeIns) {
            NodeStatusObj nodeStatusObj = newRecordsMap.computeIfAbsent(nodeInstance.getFlowInstanceId(), key -> new HashMap(16)).computeIfAbsent(nodeInstance.getNodeKey(), key -> new NodeStatusObj());
            InstanceStatus status = nodeInstance.getStatus();
            if (status == InstanceStatus.END) {
                nodeStatusObj.setEndInsSum(nodeStatusObj.getEndInsSum() + 1);
                continue;
            }
            if (status == InstanceStatus.ING) {
                nodeStatusObj.setIngInsSum(nodeStatusObj.getIngInsSum() + 1);
                continue;
            }
            if (status != InstanceStatus.PRE) continue;
            nodeStatusObj.setNotStartInsSum(nodeStatusObj.getNotStartInsSum() + 1);
        }
        if (addStarNode) {
            for (Long flowInsId : flowInsIdList) {
                NodeStatusObj statusObj = new NodeStatusObj();
                statusObj.setStatus(InstanceStatus.END);
                statusObj.setFlowInsId(flowInsId);
                statusObj.setNodeKey("start");
                Map statusObjMap = newRecordsMap.computeIfAbsent(flowInsId, key -> new HashMap(16));
                statusObjMap.put(statusObj.getNodeKey(), statusObj);
                NodeStatusObj endObj = new NodeStatusObj();
                endObj.setStatus(InstanceStatus.PRE);
                endObj.setFlowInsId(flowInsId);
                endObj.setNodeKey("end");
                statusObjMap.put(endObj.getNodeKey(), endObj);
            }
            delNodeKeys = new HashSet<String>(delNodeKeys);
            delNodeKeys.add("start");
            delNodeKeys.add("end");
        }
        NodeInstanceUtil.delNodeStatusById(delStatusObjIds);
        NodeInstanceUtil.delNodeStatusByFlowAndNode(flowInsIdList, delNodeKeys);
        NodeInstanceUtil.addNodeStatusRecord(newRecordsMap);
    }
}

