/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.bizflow.handler.AbstractNoteHandler;
import kd.epm.eb.business.bizflow.pojo.EventConsumeContext;
import kd.epm.eb.business.bizflow.pojo.FlowNodeEventResult;
import kd.epm.eb.business.bizflow.pojo.NodeInstance;
import kd.epm.eb.business.bizflow.pojo.event.NodeEvent;
import kd.epm.eb.business.bizflow.util.NodeInstanceUtil;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.taskflow.TaskTransRelation;
import kd.epm.eb.common.taskflow.graph.TaskFlowGraph;
import kd.epm.eb.common.taskflow.graph.TaskFlowLine;
import kd.epm.eb.common.taskflow.graph.TaskFlowNode;
import kd.epm.eb.common.utils.CollectionUtils;

public class FlowLineHandler
extends AbstractNoteHandler {
    private static final Log log = LogFactory.getLog(FlowLineHandler.class);

    @Override
    public FlowNodeEventResult onStart(EventConsumeContext eventContext) {
        FlowNodeEventResult result;
        NodeEvent nodeEvent = (NodeEvent)eventContext.getRealEvent();
        Long flowInstId = nodeEvent.getFlowInstanceId();
        String lineNumber = nodeEvent.getCurrentNode();
        log.info("FlowLineHandler#start flowInstId={}, lineNumber={}", (Object)flowInstId, (Object)lineNumber);
        TaskFlowGraph taskFlowGraph = eventContext.getTaskFlowGraph();
        String preNodeKey = nodeEvent.getPreNode();
        TaskFlowNode preNode = taskFlowGraph.getNode(preNodeKey);
        if (preNode.isStartNode()) {
            log.info("FlowLineHandler#start flowInstId={}, lineNumber={}, preNode is start", (Object)flowInstId, (Object)lineNumber);
            FlowNodeEventResult result2 = new FlowNodeEventResult();
            result2.setSuccess(true);
            return result2;
        }
        boolean isFinished = NodeInstanceUtil.checkNodeAllComplete(nodeEvent.getFlowInstanceId(), Collections.singletonList(preNodeKey));
        if (isFinished) {
            log.info("FlowLineHandler#start flowInstId={}, lineNumber={}, preNode is finished", (Object)flowInstId, (Object)lineNumber);
            FlowNodeEventResult result3 = new FlowNodeEventResult();
            result3.setSuccess(true);
            Map<String, Object> customData = nodeEvent.getCustomData();
            customData.put("preNodeFinished", true);
            result3.setDataMap(customData);
            return result3;
        }
        TaskFlowLine taskFlowLine = taskFlowGraph.getLine(lineNumber);
        TaskTransRelation taskTransRelation = taskFlowLine.getTransRelation();
        List relationDetailList = null;
        if (taskTransRelation != null) {
            relationDetailList = taskTransRelation.getDetailList();
        }
        if (CollectionUtils.isEmpty(relationDetailList)) {
            log.info("FlowLineHandler#start flowInstId={}, lineNumber={}, relation is empty", (Object)flowInstId, (Object)lineNumber);
            FlowNodeEventResult result4 = new FlowNodeEventResult();
            result4.setSuccess(true);
            result4.setToNextNode(false);
            return result4;
        }
        List<NodeInstance> nodeInstanceList = nodeEvent.getRefNodeInstance();
        HashSet<Long> submitOrgIds = new HashSet<Long>(16);
        for (NodeInstance nodeInstance : nodeInstanceList) {
            submitOrgIds.add(nodeInstance.getTaskDimMember());
        }
        Set<Long> outputOrgIds = TaskFlowServiceHelper.getOutputOrgIds(flowInstId, preNodeKey, relationDetailList, submitOrgIds);
        log.info("FlowLineHandler#start flowInstId={}, lineNumber={}, outputOrgIds={}", new Object[]{flowInstId, lineNumber, outputOrgIds});
        if (outputOrgIds.isEmpty()) {
            result = new FlowNodeEventResult();
            result.setSuccess(true);
            result.setToNextNode(false);
            return result;
        }
        result = new FlowNodeEventResult();
        result.setSuccess(true);
        Map<String, Object> customData = nodeEvent.getCustomData();
        customData.put("preNodeFinished", false);
        customData.put("outputOrgIds", outputOrgIds);
        result.setDataMap(customData);
        return result;
    }

    @Override
    protected void prepareNodeParam(NodeEvent currentNodeEvent, NodeEvent nextNodeEvent, FlowNodeEventResult result) {
        super.prepareNodeParam(currentNodeEvent, nextNodeEvent, result);
        Map<String, Object> customData = result.getDataMap();
        nextNodeEvent.setCustomData(customData);
    }
}

