/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.handler;

import kd.epm.eb.business.bizflow.handler.ApproveNodeHandler;
import kd.epm.eb.business.bizflow.handler.CommitNodeHandler;
import kd.epm.eb.business.bizflow.handler.EbFlowEventHandler;
import kd.epm.eb.business.bizflow.handler.FLowUpdateHandler;
import kd.epm.eb.business.bizflow.handler.FlowLineHandler;
import kd.epm.eb.business.bizflow.handler.RptUpdateHandler;
import kd.epm.eb.business.bizflow.handler.StartNodeHandler;
import kd.epm.eb.business.bizflow.pojo.event.EbFlowEvent;
import kd.epm.eb.business.bizflow.pojo.event.NodeEvent;
import kd.epm.eb.business.bizflow.pojo.event.NodeUpdateEvent;
import kd.epm.eb.business.bizflow.pojo.event.ReportUpdateEvent;
import kd.epm.eb.common.taskflow.TaskFlowNodeType;

public class HandlerFactory {
    public static EbFlowEventHandler getHandler(EbFlowEvent event) {
        EbFlowEventHandler handler = null;
        if (event instanceof NodeEvent) {
            NodeEvent nodeEvent = (NodeEvent)event;
            TaskFlowNodeType nodeType = nodeEvent.getNodeType();
            if (nodeType == TaskFlowNodeType.APPROVE) {
                handler = new ApproveNodeHandler();
            } else if (nodeType == TaskFlowNodeType.COMMIT) {
                handler = new CommitNodeHandler();
            } else if (nodeType == TaskFlowNodeType.LINE) {
                handler = new FlowLineHandler();
            } else if (nodeType == TaskFlowNodeType.START) {
                handler = new StartNodeHandler();
            }
        } else if (event instanceof NodeUpdateEvent) {
            handler = new FLowUpdateHandler();
        } else if (event instanceof ReportUpdateEvent) {
            handler = new RptUpdateHandler();
        }
        return handler;
    }
}

