/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.bizflow.handler.BizEventHandler;
import kd.epm.eb.business.bizflow.pojo.EventConsumeContext;
import kd.epm.eb.business.bizflow.pojo.FlowEventResult;
import kd.epm.eb.business.bizflow.pojo.InstanceStatus;
import kd.epm.eb.business.bizflow.pojo.NodeInstance;
import kd.epm.eb.business.bizflow.pojo.event.EventStatus;
import kd.epm.eb.business.bizflow.pojo.event.NodeEvent;
import kd.epm.eb.business.bizflow.pojo.event.ReportUpdateEvent;
import kd.epm.eb.business.bizflow.util.BizFlowEventUtil;
import kd.epm.eb.business.bizflow.util.BizFlowInstanceUtil;
import kd.epm.eb.business.bizflow.util.NodeInstanceUtil;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.taskflow.TaskFlowNodeType;
import kd.epm.eb.common.utils.CollectionUtils;

public class RptUpdateHandler
extends BizEventHandler {
    @Override
    public FlowEventResult handle(EventConsumeContext context) {
        List<Long> rptIdList;
        ReportUpdateEvent updateEvent = (ReportUpdateEvent)context.getRealEvent();
        if (updateEvent.isApproveBill()) {
            rptIdList = new LinkedList<Long>();
            List<Long> sourceObjIds = updateEvent.getRptOrBillIds();
            Map<Long, List<Long>> reportProcessIds = ApproveUtils.getInstance().getReportProcessIdsByBillIds(sourceObjIds, true);
            reportProcessIds.forEach((billId, rptList) -> rptIdList.addAll((Collection<Long>)rptList));
        } else {
            rptIdList = updateEvent.getRptOrBillIds();
        }
        List<NodeInstance> nodeInstances = NodeInstanceUtil.getInsByTarObjs(rptIdList, null);
        HashMap<Long, Map> insNodeBillMap = new HashMap<Long, Map>(16);
        if (CollectionUtils.isNotEmpty(nodeInstances)) {
            for (NodeInstance instance : nodeInstances) {
                if ((instance.getStatus() != InstanceStatus.ING && instance.getStatus() != InstanceStatus.PRE || updateEvent.isRollback()) && (instance.getStatus() != InstanceStatus.END || !updateEvent.isRollback())) continue;
                String nodeKey = instance.getNodeKey();
                Long flowInstanceId = instance.getFlowInstanceId();
                insNodeBillMap.computeIfAbsent(flowInstanceId, key -> new HashMap(16)).computeIfAbsent(nodeKey, key1 -> new LinkedList()).add(instance);
            }
            Map<Long, List<Long>> flowIdMapByInsId = BizFlowInstanceUtil.getFlowIdMapByInsId(insNodeBillMap.keySet());
            Set<Long> enableFlowIds = TaskFlowServiceHelper.getEnableFlowIds(flowIdMapByInsId.keySet());
            flowIdMapByInsId.forEach((flowId, flowInsIdList) -> {
                if (enableFlowIds.contains(flowId)) {
                    flowInsIdList.forEach(flowInsId -> {
                        Map nodeInsMap = (Map)insNodeBillMap.get(flowInsId);
                        if (nodeInsMap != null) {
                            nodeInsMap.forEach((nodeKey, nodeInsList) -> {
                                NodeEvent nodeEvent = new NodeEvent();
                                nodeEvent.setFlowInstanceId((Long)flowInsId);
                                nodeEvent.setCurrentNode((String)nodeKey);
                                nodeEvent.setStatus(updateEvent.isRollback() ? EventStatus.ROLLBACK : EventStatus.FINISH);
                                nodeEvent.setResend(false);
                                nodeEvent.setUseQueue(false);
                                nodeEvent.setNodeType(updateEvent.isApproveBill() ? TaskFlowNodeType.APPROVE : TaskFlowNodeType.COMMIT);
                                nodeEvent.setRefNodeInstance((List<NodeInstance>)nodeInsList);
                                nodeEvent.setFlowId((Long)flowId);
                                BizFlowEventUtil.sendMessage(nodeEvent);
                            });
                        }
                    });
                }
            });
        }
        return null;
    }
}

