/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.util;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bizflow.BizFlowMesConsumer;
import kd.epm.eb.business.bizflow.pojo.event.EbFlowEvent;
import kd.epm.eb.business.bizflow.pojo.event.EventStatus;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;

public class BizFlowEventUtil {
    private static final Log log = LogFactory.getLog(BizFlowEventUtil.class);
    private static final String eventLogForm = "eb_taskfloweventlog";
    private static final String eventLogTable = "t_eb_taskfloweventlog";
    private static final String id_key = "id";
    private static final String flow_key = "taskflow";
    private static final String log_key = "eventinfo";
    private static final String eventKey_key = "eventkey";
    private static final String status_key = "status";
    private static final String modifier_key = "modifier";
    private static final String modifyDate_key = "modifydate";
    private static final String eventLogUpSql = "update t_eb_taskfloweventlog set fstatus = ?,fmodifydate = ?,fmodifier = ? where feventkey = ?";

    public static void sendMessage(EbFlowEvent mesEvent) {
        if (mesEvent.getMesId() == null) {
            mesEvent.setMesId(GlobalIdUtil.genStringId());
        }
        log.info("BizFlowEvent-sendMessage:" + mesEvent.getMesId());
        EpmThreadPools.TASK_FLOW_POOL.execute(() -> BizFlowMesConsumer.getInstance().onMessage(mesEvent, null, false, null));
    }

    public static EbFlowEvent readMessageObj(Object mesObj) {
        EbFlowEvent event = null;
        if (mesObj instanceof String) {
            try {
                event = (EbFlowEvent)SerializationUtils.fromJsonString((String)((String)mesObj), EbFlowEvent.class);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        } else if (mesObj instanceof EbFlowEvent) {
            event = (EbFlowEvent)mesObj;
        }
        return event;
    }

    public static void addEventLog(EbFlowEvent flowEvent) {
        if (flowEvent != null && !flowEvent.isResend()) {
            try {
                Long flowId = flowEvent.getFlowId();
                String mesId = flowEvent.getMesId();
                DynamicObject newLog = BusinessDataServiceHelper.newDynamicObject((String)eventLogForm);
                newLog.set(id_key, (Object)GlobalIdUtil.genGlobalLongId());
                newLog.set(flow_key, (Object)flowId);
                newLog.set(status_key, (Object)EventStatus.START.name());
                newLog.set(eventKey_key, (Object)mesId);
                String logStr = SerializationUtils.toJsonString((Object)flowEvent);
                newLog.set("eventinfo_tag", (Object)logStr);
                if (logStr.length() > 200) {
                    logStr = logStr.substring(0, 200);
                }
                newLog.set(log_key, (Object)logStr);
                try (TXHandle txHandle = TX.requiresNew((String)"addEventLog");){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newLog});
                }
            }
            catch (Exception e) {
                log.error("addEventLog:" + flowEvent.getMesId(), (Throwable)e);
            }
        }
    }

    public static void updateEventLogStatus(String eventKey, EventStatus status) {
        try (TXHandle txHandle = TX.requiresNew((String)"updateEventLogStatus");){
            CommonServiceHelper.executeEpmDB((String)eventLogUpSql, (Object[])new Object[]{status.name(), TimeServiceHelper.now(), UserUtils.getUserId(), eventKey});
        }
        catch (Exception e) {
            log.error("updateEventLogStatus:" + eventKey, (Throwable)e);
        }
    }

    public static void activateEvent(Collection<Long> eventLogIds) {
        DynamicObject[] logObjs;
        for (DynamicObject logObj : logObjs = BusinessDataServiceHelper.load((String)eventLogForm, (String)"status,eventinfo_tag", (QFilter[])new QFilter(id_key, "in", eventLogIds).toArray())) {
            String logStr;
            EbFlowEvent ebFlowEvent;
            String status = logObj.getString(status_key);
            if (EventStatus.FINISH.name().equals(status) || (ebFlowEvent = BizFlowEventUtil.readMessageObj(logStr = logObj.getString("eventinfo_tag"))) == null) continue;
            ebFlowEvent.setResend(true);
            BizFlowEventUtil.sendMessage(ebFlowEvent);
        }
    }
}

