/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.bizflow.pojo.BizFlowInstance;
import kd.epm.eb.business.bizflow.pojo.InstanceStatus;
import kd.epm.eb.business.db.DelSqlBuilder;
import kd.epm.eb.business.db.SelSqlBuilder;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.pojo.SqlObj;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;

public class BizFlowInstanceUtil {
    private static final String table = "t_eb_flowinstance";
    private static final String id_key = "fid";
    private static final String flowId_key = "fflowid";
    private static final String upDate_key = "fmodifydate";
    private static final String upUser_key = "fmodifier";
    private static final String ver_key = "fversion";
    private static final String startDate_key = "fstartdate";
    private static final String startUser_key = "fstartor";
    private static final String status_key = "fstatus";
    private static final String insertSql = "insert into t_eb_flowinstance(fid,fflowid,fstatus,fmodifydate,fstartdate,fmodifier,fstartor,fversion) values(?,?,?,?,?,?,?,?)";

    public static BizFlowInstance getInstanceById(Long id) {
        List<BizFlowInstance> instances = BizFlowInstanceUtil.getInstanceById(Collections.singletonList(id));
        if (CollectionUtils.isNotEmpty(instances)) {
            return instances.get(0);
        }
        return null;
    }

    public static List<BizFlowInstance> getInstanceById(Collection<Long> ids) {
        ArrayList<BizFlowInstance> result = new ArrayList<BizFlowInstance>(ids.size());
        SelSqlBuilder selSqlBuilder = new SelSqlBuilder(table);
        selSqlBuilder.addFieldKeys(id_key, flowId_key, upDate_key, upUser_key, ver_key, startUser_key, startDate_key, status_key);
        selSqlBuilder.addInFilter(id_key, ids);
        CommonServiceHelper.queryDataSetByDB(null, (SqlObj)selSqlBuilder.buildSql(), rowData -> {
            BizFlowInstance instance = new BizFlowInstance();
            instance.setFlowId(rowData.getLong(flowId_key));
            instance.setId(rowData.getLong(id_key));
            instance.setStatus(InstanceStatus.valueOf(rowData.getString(status_key)));
            instance.setBeginTime(rowData.getDate(startDate_key));
            instance.setUpdateTime(rowData.getDate(upDate_key));
            instance.setStartUser(rowData.getLong(startUser_key));
            instance.setUpdateUser(rowData.getLong(upUser_key));
            instance.setVersion(rowData.getLong(ver_key));
            result.add(instance);
        });
        return result;
    }

    public static List<Long> getFlowInsByFlowId(Long flowId) {
        Map<Long, List<Long>> flowInsMapByFlowId = BizFlowInstanceUtil.getFlowInsMapByFlowId(Collections.singletonList(flowId));
        return flowInsMapByFlowId.getOrDefault(flowId, new ArrayList(1));
    }

    public static Map<Long, List<Long>> getFlowInsMapByFlowId(Collection<Long> flowIds) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        SelSqlBuilder sb = new SelSqlBuilder(table);
        sb.addFieldKeys(id_key, flowId_key);
        sb.addInFilter(flowId_key, flowIds);
        CommonServiceHelper.queryDataSetByDB(null, (SqlObj)sb.buildSql(), rowData -> {
            Long insId = rowData.getLong(id_key);
            Long flowId = rowData.getLong(flowId_key);
            result.computeIfAbsent(flowId, key -> new ArrayList(16)).add(insId);
        });
        return result;
    }

    public static Map<Long, Long> getFowIdByInsId(Collection<Long> insIds) {
        Map<Long, List<Long>> flowIdMapByInsId = BizFlowInstanceUtil.getFlowIdMapByInsId(insIds);
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        flowIdMapByInsId.forEach((flowId, flowInsIdList) -> flowInsIdList.forEach(flowInsId -> result.put((Long)flowInsId, (Long)flowId)));
        return result;
    }

    public static Map<Long, List<Long>> getFlowIdMapByInsId(Collection<Long> insIds) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        if (insIds.size() > 0) {
            SelSqlBuilder sb = new SelSqlBuilder(table);
            sb.addFieldKeys(id_key, flowId_key);
            sb.addInFilter(id_key, insIds);
            CommonServiceHelper.queryDataSetByDB(null, (SqlObj)sb.buildSql(), rowData -> {
                Long insId = rowData.getLong(id_key);
                Long flowId = rowData.getLong(flowId_key);
                result.computeIfAbsent(flowId, key -> new ArrayList(16)).add(insId);
            });
        }
        return result;
    }

    public static Long addBizFlowInstance(Long flowId, Long version, boolean unique) {
        List<Long> insId;
        Map<Long, List<Long>> flowInsMapByFlowId;
        if (unique && !(flowInsMapByFlowId = BizFlowInstanceUtil.getFlowInsMapByFlowId(Collections.singletonList(flowId))).isEmpty() && CollectionUtils.isNotEmpty(insId = flowInsMapByFlowId.get(flowId))) {
            return insId.get(0);
        }
        Date now = TimeServiceHelper.now();
        Long user = UserUtils.getUserId();
        Long id = GlobalIdUtil.genGlobalLongId();
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)insertSql, (Object[])new Object[]{id, flowId, InstanceStatus.PRE.name(), now, now, user, user, version});
        return id;
    }

    public static void delFlowInsById(Collection<Long> flowInsIds) {
        if (CollectionUtils.isNotEmpty(flowInsIds)) {
            DelSqlBuilder sqlBuilder = new DelSqlBuilder(table);
            sqlBuilder.addInFilter(id_key, flowInsIds);
            CommonServiceHelper.executeEpmDB((SqlObj)sqlBuilder.buildSql());
        }
    }
}

