/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizflow.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.bizflow.pojo.InstanceStatus;
import kd.epm.eb.business.bizflow.pojo.NodeInstance;
import kd.epm.eb.business.bizflow.pojo.NodeStatusObj;
import kd.epm.eb.business.bizflow.util.BizFlowInstanceUtil;
import kd.epm.eb.business.db.DelSqlBuilder;
import kd.epm.eb.business.db.SelSqlBuilder;
import kd.epm.eb.business.db.UpdateSqlBuilder;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.pojo.SqlObj;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;

public class NodeInstanceUtil {
    private static final String NodeInsTable = "t_eb_flownodeinstance";
    private static final String NI_id_K = "fid";
    private static final String NI_flowInsId_K = "fflowid";
    private static final String NI_status_K = "fstatus";
    private static final String NI_createDate_K = "fcreatedate";
    private static final String NI_creator_K = "fcreator";
    private static final String NI_modifyDate_K = "fmodifydate";
    private static final String NI_modifier_K = "fmodifier";
    private static final String NI_nodeKey_K = "fcurrentnode";
    private static final String NI_refObj_K = "fsource";
    private static final String NI_dimMember_K = "fdimmember";
    private static final String NodeStatusTable = "t_eb_flownodeinsstatus";
    private static final String NS_id_K = "fid";
    private static final String NS_flowInsId_K = "fflowid";
    private static final String NS_status_K = "fstatus";
    private static final String NS_nodeKey_K = "fnodekey";
    private static final String NS_notStartInsSum_K = "fnotstartinssum";
    private static final String NS_ingInsSum_K = "finginssum";
    private static final String NS_endInsSum_K = "fendinssum";
    private static final String NS_modifyDate_K = "fmodifydate";
    private static final String NS_modifier_K = "fmodifier";
    private static final String insertNISql = "insert into t_eb_flownodeinstance (fid,fflowid,fstatus,fcreatedate,fcreator,fmodifydate,fmodifier,fcurrentnode,fsource,fdimmember)values(?,?,?,?,?,?,?,?,?,?)";
    private static final String insertNSSql = "insert into t_eb_flownodeinsstatus(fid,fflowid,fstatus,fnodekey,fnotstartinssum,finginssum,fendinssum,fmodifydate,fmodifier) values(?,?,?,?,?,?,?,?,?)";
    private static final String updateStatusSumSql = "update t_eb_flownodeinsstatus set fnotstartinssum = fnotstartinssum + ?,finginssum = finginssum + ?,fendinssum = fendinssum + ?,fmodifier = ?,fmodifydate = ? where fflowid = ? and fnodekey = ?";
    private static final String delNodeInsBatSql = "delete from  t_eb_flownodeinstance where fflowid = ? and fcurrentnode = ?";

    public static List<NodeInstance> getInsByTarObj(Long targetObj) {
        return NodeInstanceUtil.getInsByTarObjs(Collections.singletonList(targetObj), null);
    }

    public static List<NodeInstance> getInsByTarObjs(Collection<Long> targetObjIds, InstanceStatus targetStatus) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>(16);
        SelSqlBuilder selSqlBuilder = NodeInstanceUtil.getNInsSelSqlBuilder();
        selSqlBuilder.addFieldKeys("fid", "fflowid", "fstatus", NI_creator_K, NI_createDate_K, "fmodifydate", "fmodifier", NI_nodeKey_K, NI_refObj_K, NI_dimMember_K);
        selSqlBuilder.addInFilter(NI_refObj_K, targetObjIds);
        if (targetStatus != null) {
            selSqlBuilder.addEqualsFilter("fstatus", targetStatus.name());
        }
        CommonServiceHelper.queryDataSetByDB((String)"getInsByTarObjs", (SqlObj)selSqlBuilder.buildSql(), rowData -> result.add(NodeInstanceUtil.toNodeIns(rowData)));
        return result;
    }

    public static void updateInstanceStatus(List<NodeInstance> nodeInstanceList) {
        LinkedList<Long> ingNodeInsList = new LinkedList<Long>();
        LinkedList<Long> endNodeInsList = new LinkedList<Long>();
        for (NodeInstance nodeInstance : nodeInstanceList) {
            if (nodeInstance.getNewStatus() == InstanceStatus.END) {
                endNodeInsList.add(nodeInstance.getId());
                continue;
            }
            if (nodeInstance.getNewStatus() != InstanceStatus.ING) continue;
            ingNodeInsList.add(nodeInstance.getId());
        }
        NodeInstanceUtil.updateInsStatusById(ingNodeInsList, InstanceStatus.ING);
        NodeInstanceUtil.updateInsStatusById(endNodeInsList, InstanceStatus.END);
    }

    public static void updateInsStatusById(List<Long> nodInsIds, InstanceStatus targetStatus) {
        if (nodInsIds.size() > 0) {
            UpdateSqlBuilder sqlBuilder = NodeInstanceUtil.getNInsUpSqlBuilder();
            sqlBuilder.addUpdate("fstatus", targetStatus.name());
            sqlBuilder.addUpdate("fmodifier", UserUtils.getUserId());
            sqlBuilder.addUpdate("fmodifydate", TimeServiceHelper.now());
            sqlBuilder.addInFilter("fid", nodInsIds);
            CommonServiceHelper.executeEpmDB((SqlObj)sqlBuilder.buildSql());
        }
    }

    public static void addNodeInstances(Collection<NodeInstance> nodeInstances) {
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)nodeInstances.size());
        int seq = 0;
        ArrayList<Object[]> allValues = new ArrayList<Object[]>(nodeInstances.size());
        for (NodeInstance instance : nodeInstances) {
            instance.setId(ids[seq++]);
            if (instance.getStatus() == null) {
                instance.setStatus(InstanceStatus.PRE);
            }
            if (instance.getStartUser() == null) {
                instance.setStartUser(userId);
            }
            if (instance.getBeginTime() == null) {
                instance.setBeginTime(now);
            }
            instance.setUpdateUser(userId);
            instance.setUpdateTime(now);
            allValues.add(instance.toArray());
        }
        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)insertNISql, allValues);
    }

    public static boolean checkNodeAllComplete(Long flowInsId, Collection<String> nodeKeys) {
        SelSqlBuilder sqlBuilder = NodeInstanceUtil.getNStatusSelSqlBuilder();
        sqlBuilder.addFieldKeys("fid");
        sqlBuilder.addEqualsFilter("fflowid", flowInsId);
        sqlBuilder.addEqualsFilter("fstatus", InstanceStatus.END.name());
        sqlBuilder.addInFilter(NS_nodeKey_K, nodeKeys);
        Counter counter = new Counter();
        CommonServiceHelper.queryDataSetByDB((String)"checkNodeComplete", (SqlObj)sqlBuilder.buildSql(), row -> counter.addOne());
        return nodeKeys.size() == counter.getSize();
    }

    public static void updateStatus(List<NodeInstance> refNodeInstance, Long flowInsId, String targetNode) {
        if (refNodeInstance == null) {
            return;
        }
        LinkedList<NodeInstance> _refNodeInstance = new LinkedList<NodeInstance>();
        for (NodeInstance nodeInstance : refNodeInstance) {
            if (!nodeInstance.getFlowInstanceId().equals(flowInsId) || !targetNode.equals(nodeInstance.getNodeKey())) continue;
            _refNodeInstance.add(nodeInstance);
        }
        if (_refNodeInstance.size() > 0) {
            try (TXHandle txHandle = TX.required((String)"updateNodeStatus");){
                try {
                    NodeInstanceUtil.updateInstanceStatus(_refNodeInstance);
                    NodeInstanceUtil.updateSingleNodeStatus(refNodeInstance, flowInsId, targetNode);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void addNodeStatusRecord(Map<Long, Map<String, NodeStatusObj>> newRecordsMap) {
        if (newRecordsMap.isEmpty()) {
            return;
        }
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        LinkedList paramVal = new LinkedList();
        newRecordsMap.forEach((flowInsId, statusObjMap) -> statusObjMap.forEach((nodeKey, statusObj) -> {
            statusObj.setModifier(userId);
            statusObj.setModifyDate(now);
            statusObj.setFlowInsId((Long)flowInsId);
            statusObj.setNodeKey((String)nodeKey);
            if (statusObj.getStatus() == null) {
                statusObj.setStatus(InstanceStatus.PRE);
            }
            paramVal.add(statusObj.toArrays());
        }));
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)paramVal.size());
        int seq = 0;
        for (Object[] values : paramVal) {
            values[0] = ids[seq++];
        }
        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)insertNSSql, paramVal);
    }

    private static void updateSingleNodeStatus(List<NodeInstance> refNodeInstance, Long flowInsId, String currentNodeKey) {
        int subPreSum = 0;
        int subIngSum = 0;
        int subEndSum = 0;
        for (NodeInstance nodeInstance : refNodeInstance) {
            if (nodeInstance.getStatus() == nodeInstance.getNewStatus()) continue;
            if (nodeInstance.getNewStatus() == InstanceStatus.ING) {
                if (nodeInstance.getStatus() != InstanceStatus.END) {
                    --subPreSum;
                } else {
                    --subEndSum;
                }
                ++subIngSum;
                continue;
            }
            if (nodeInstance.getNewStatus() == InstanceStatus.END) {
                ++subEndSum;
                if (nodeInstance.getStatus() == InstanceStatus.PRE) {
                    --subPreSum;
                    continue;
                }
                --subIngSum;
                continue;
            }
            if (nodeInstance.getNewStatus() != InstanceStatus.PRE) continue;
            ++subPreSum;
            if (nodeInstance.getStatus() == InstanceStatus.END) {
                --subEndSum;
                continue;
            }
            --subIngSum;
        }
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)updateStatusSumSql, (Object[])new Object[]{subPreSum, subIngSum, subEndSum, userId, now, flowInsId, currentNodeKey});
        NodeInstanceUtil.updateNodeStatus(Sets.newHashSet((Object[])new Long[]{flowInsId}), Sets.newHashSet((Object[])new String[]{currentNodeKey}));
    }

    public static Map<Long, Map<String, List<NodeInstance>>> getNodeInsByNode(Collection<Long> flowInsIds, Collection<String> nodeKeys, InstanceStatus instanceStatus) {
        HashMap<Long, Map<String, List<NodeInstance>>> result = new HashMap<Long, Map<String, List<NodeInstance>>>(16);
        SelSqlBuilder selSqlBuilder = NodeInstanceUtil.getNInsSelSqlBuilder();
        selSqlBuilder.addFieldKeys("fid", "fflowid", "fstatus", NI_creator_K, NI_createDate_K, "fmodifydate", "fmodifier", NI_nodeKey_K, NI_refObj_K, NI_dimMember_K);
        selSqlBuilder.addInFilter("fflowid", flowInsIds);
        selSqlBuilder.addInFilter(NI_nodeKey_K, nodeKeys);
        if (instanceStatus != null) {
            selSqlBuilder.addEqualsFilter("fstatus", instanceStatus.name());
        }
        CommonServiceHelper.queryDataSetByDB((String)"getNodeInsByNode", (SqlObj)selSqlBuilder.buildSql(), row -> {
            NodeInstance instance = NodeInstanceUtil.toNodeIns(row);
            result.computeIfAbsent(instance.getFlowInstanceId(), key -> new HashMap(16)).computeIfAbsent(instance.getNodeKey(), key -> new ArrayList(16)).add(instance);
        });
        return result;
    }

    public static Map<Long, Map<String, Map<Long, NodeInstance>>> getNodeInsMapByNode(Collection<Long> flowInsIds, Collection<String> nodeKeys) {
        HashMap<Long, Map<String, Map<Long, NodeInstance>>> nodeInsRptMap = new HashMap<Long, Map<String, Map<Long, NodeInstance>>>(16);
        Map<Long, Map<String, List<NodeInstance>>> nodeInsByNode = NodeInstanceUtil.getNodeInsByNode(flowInsIds, nodeKeys, null);
        nodeInsByNode.forEach((flowInsId, nodeInsListMap) -> {
            HashMap nodeInsMap = new HashMap(nodeInsListMap.size());
            nodeInsListMap.forEach((nodeKey, insList) -> {
                HashMap insRptMap = new HashMap(insList.size());
                insList.forEach(ins -> insRptMap.put(ins.getRefObj(), ins));
                nodeInsMap.put(nodeKey, insRptMap);
            });
            nodeInsRptMap.put((Long)flowInsId, nodeInsMap);
        });
        return nodeInsRptMap;
    }

    public static List<NodeInstance> getNodeInstanceByNode(Long flowInsId, Collection<String> nodeKeys) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>(16);
        SelSqlBuilder selSqlBuilder = NodeInstanceUtil.getNInsSelSqlBuilder();
        selSqlBuilder.addFieldKeys("fid", "fflowid", "fstatus", NI_creator_K, NI_createDate_K, "fmodifydate", "fmodifier", NI_nodeKey_K, NI_refObj_K, NI_dimMember_K);
        selSqlBuilder.addEqualsFilter("fflowid", flowInsId);
        if (nodeKeys != null) {
            selSqlBuilder.addInFilter(NI_nodeKey_K, nodeKeys);
        }
        CommonServiceHelper.queryDataSetByDB((String)"getInsByTarObjs", (SqlObj)selSqlBuilder.buildSql(), rowData -> result.add(NodeInstanceUtil.toNodeIns(rowData)));
        return result;
    }

    public static List<NodeInstance> getNodeInstanceByOrg(Long flowInsId, Set<Long> orgIds, Collection<String> nodeKeys) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>(16);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            SelSqlBuilder selSqlBuilder = NodeInstanceUtil.getNInsSelSqlBuilder();
            selSqlBuilder.addFieldKeys("fid", "fflowid", "fstatus", NI_creator_K, NI_createDate_K, "fmodifydate", "fmodifier", NI_nodeKey_K, NI_refObj_K, NI_dimMember_K);
            selSqlBuilder.addEqualsFilter("fflowid", flowInsId);
            selSqlBuilder.addInFilter(NI_dimMember_K, orgIds);
            if (nodeKeys != null) {
                selSqlBuilder.addInFilter(NI_nodeKey_K, nodeKeys);
            }
            CommonServiceHelper.queryDataSetByDB((String)"getInsByTarObjs", (SqlObj)selSqlBuilder.buildSql(), rowData -> result.add(NodeInstanceUtil.toNodeIns(rowData)));
        }
        return result;
    }

    public static List<NodeStatusObj> selNodeStatusByFlow(Long flowId, List<String> refNodeKeys) {
        Map<Long, List<Long>> flowInsMapByFlowId = BizFlowInstanceUtil.getFlowInsMapByFlowId(Collections.singletonList(flowId));
        List<Long> insIds = flowInsMapByFlowId.get(flowId);
        return NodeInstanceUtil.selNodeStatusByFlowIns(insIds, refNodeKeys);
    }

    public static List<NodeStatusObj> selNodeStatusByFlowIns(Collection<Long> flowInsIds, Collection<String> refNodeKeys) {
        ArrayList<NodeStatusObj> results = new ArrayList<NodeStatusObj>(16);
        if (flowInsIds != null && flowInsIds.size() > 0) {
            SelSqlBuilder sqlBuilder = NodeInstanceUtil.getNStatusSelSqlBuilder();
            sqlBuilder.addFieldKeys("fid", "fflowid", "fstatus", NS_nodeKey_K, NS_notStartInsSum_K, NS_ingInsSum_K, NS_endInsSum_K, "fmodifydate", "fmodifier");
            sqlBuilder.addInFilter("fflowid", flowInsIds);
            if (refNodeKeys != null) {
                sqlBuilder.addInFilter(NS_nodeKey_K, refNodeKeys);
            }
            CommonServiceHelper.queryDataSetByDB((String)"selNodeStatusByFlow", (SqlObj)sqlBuilder.buildSql(), row -> {
                NodeStatusObj statusObj = new NodeStatusObj();
                statusObj.setId(row.getLong("fid"));
                statusObj.setStatus(InstanceStatus.valueOf(row.getString("fstatus")));
                statusObj.setFlowInsId(row.getLong("fflowid"));
                statusObj.setNodeKey(row.getString(NS_nodeKey_K));
                statusObj.setIngInsSum(row.getInteger(NS_ingInsSum_K));
                statusObj.setNotStartInsSum(row.getInteger(NS_notStartInsSum_K));
                statusObj.setEndInsSum(row.getInteger(NS_endInsSum_K));
                results.add(statusObj);
            });
        }
        return results;
    }

    public static void delNodeInsByFlowAndNode(Collection<Long> flowInsIds, Collection<String> nodeKeys) {
        if (CollectionUtils.isEmpty(flowInsIds) && CollectionUtils.isEmpty(nodeKeys)) {
            return;
        }
        DelSqlBuilder sqlBuilder = NodeInstanceUtil.getNInsDelSqlBuilder();
        if (flowInsIds != null) {
            sqlBuilder.addInFilter("fflowid", flowInsIds);
        }
        if (nodeKeys != null) {
            sqlBuilder.addInFilter(NI_nodeKey_K, nodeKeys);
        }
        CommonServiceHelper.executeEpmDB((SqlObj)sqlBuilder.buildSql());
    }

    public static void delNodeInsByFlowAndNodeBat(Collection<Pair<Long, String>> nodeInsPair) {
        if (CollectionUtils.isEmpty(nodeInsPair)) {
            return;
        }
        LinkedList params = new LinkedList();
        nodeInsPair.forEach(pair -> params.add(new Object[]{pair.p1, pair.p2}));
        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)delNodeInsBatSql, params);
    }

    public static void delNodeStatusById(Collection<Long> nodeStatusIds) {
        if (CollectionUtils.isEmpty(nodeStatusIds)) {
            return;
        }
        DelSqlBuilder sqlBuilder = NodeInstanceUtil.getNStatusDelSqlBuilder();
        sqlBuilder.addInFilter("fid", nodeStatusIds);
        CommonServiceHelper.executeEpmDB((SqlObj)sqlBuilder.buildSql());
    }

    public static void delNodeStatusByFlowAndNode(Collection<Long> flowInsIds, Collection<String> nodeKeys) {
        if (CollectionUtils.isEmpty(flowInsIds) && CollectionUtils.isEmpty(nodeKeys)) {
            return;
        }
        DelSqlBuilder sqlBuilder = NodeInstanceUtil.getNStatusDelSqlBuilder();
        if (flowInsIds != null) {
            sqlBuilder.addInFilter("fflowid", flowInsIds);
        }
        if (nodeKeys != null) {
            sqlBuilder.addInFilter(NS_nodeKey_K, nodeKeys);
        }
        CommonServiceHelper.executeEpmDB((SqlObj)sqlBuilder.buildSql());
    }

    public static void updateNodeStatus(Set<Long> flowInsIdSet, Set<String> nodeKeySet) {
        List<NodeStatusObj> statusObjs = NodeInstanceUtil.selNodeStatusByFlowIns(flowInsIdSet, nodeKeySet);
        HashMap<Long, Map> nodeStatusMap = new HashMap<Long, Map>(flowInsIdSet.size());
        for (NodeStatusObj statusObj : statusObjs) {
            nodeStatusMap.computeIfAbsent(statusObj.getFlowInsId(), key -> new HashMap(16)).put(statusObj.getNodeKey(), statusObj);
        }
        HashMap<InstanceStatus, List> updatedObjs = new HashMap<InstanceStatus, List>(16);
        for (Long flowInsId : flowInsIdSet) {
            Map nodeStatusObjMap = (Map)nodeStatusMap.get(flowInsId);
            if (nodeStatusObjMap == null) continue;
            for (String nodeKey : nodeKeySet) {
                InstanceStatus status;
                NodeStatusObj statusObj = (NodeStatusObj)nodeStatusObjMap.get(nodeKey);
                if (statusObj == null || (status = NodeInstanceUtil.switchNewStatus(statusObj)) == null) continue;
                updatedObjs.computeIfAbsent(status, key -> new ArrayList(16)).add(statusObj.getId());
            }
        }
        if (updatedObjs.size() > 0) {
            updatedObjs.forEach((newStatus, ids) -> {
                UpdateSqlBuilder sqlBuilder = NodeInstanceUtil.getNStatusUpSqlBuilder();
                sqlBuilder.addUpdate("fstatus", newStatus.name());
                sqlBuilder.addUpdate("fmodifier", UserUtils.getUserId());
                sqlBuilder.addUpdate("fmodifydate", TimeServiceHelper.now());
                sqlBuilder.addInFilter("fid", ids);
                CommonServiceHelper.executeEpmDB((SqlObj)sqlBuilder.buildSql());
            });
        }
    }

    private static InstanceStatus switchNewStatus(NodeStatusObj statusObj) {
        InstanceStatus newStatus = null;
        if (statusObj != null) {
            int subSum = statusObj.getIngInsSum() + statusObj.getNotStartInsSum();
            if (subSum <= 0) {
                if (statusObj.getStatus() != InstanceStatus.END) {
                    newStatus = InstanceStatus.END;
                }
            } else {
                newStatus = statusObj.getEndInsSum() > 0 || statusObj.getIngInsSum() > 0 ? InstanceStatus.ING : InstanceStatus.PRE;
            }
        }
        return newStatus;
    }

    private static SelSqlBuilder getNInsSelSqlBuilder() {
        return new SelSqlBuilder(NodeInsTable);
    }

    private static DelSqlBuilder getNInsDelSqlBuilder() {
        return new DelSqlBuilder(NodeInsTable);
    }

    private static UpdateSqlBuilder getNInsUpSqlBuilder() {
        return new UpdateSqlBuilder(NodeInsTable);
    }

    private static SelSqlBuilder getNStatusSelSqlBuilder() {
        return new SelSqlBuilder(NodeStatusTable);
    }

    private static DelSqlBuilder getNStatusDelSqlBuilder() {
        return new DelSqlBuilder(NodeStatusTable);
    }

    private static UpdateSqlBuilder getNStatusUpSqlBuilder() {
        return new UpdateSqlBuilder(NodeStatusTable);
    }

    public static NodeInstance toNodeIns(Row rowData) {
        NodeInstance instance = new NodeInstance();
        instance.setFlowInstanceId(rowData.getLong("fflowid"));
        instance.setRefObj(rowData.getLong(NI_refObj_K));
        instance.setNodeKey(rowData.getString(NI_nodeKey_K));
        instance.setTaskDimMember(rowData.getLong(NI_dimMember_K));
        instance.setId(rowData.getLong("fid"));
        instance.setBeginTime(rowData.getDate(NI_createDate_K));
        instance.setStartUser(rowData.getLong(NI_creator_K));
        instance.setUpdateTime(rowData.getDate("fmodifydate"));
        instance.setUpdateUser(rowData.getLong("fmodifier"));
        instance.setStatus(InstanceStatus.valueOf(rowData.getString("fstatus")));
        return instance;
    }
}

