/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizrule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleNodeBo;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import org.apache.commons.lang3.StringUtils;

public class LeafRuleTraceHelper {
    public static MutableGraph<GraphNode> findRuleToGraph(LeafRuleTraceContext ctx) {
        ctx.setBeMatchRules(ctx.getAllRules());
        List<RuleNodeBo> matchRules = LeafRuleTraceHelper.matchRules(ctx, ctx.getLeftScope());
        MutableGraph<RuleNodeBo> execGraph = ctx.getExecGraph();
        for (RuleNodeBo ruleNodeBo : matchRules) {
            execGraph.addNode((Object)ruleNodeBo);
        }
        for (RuleNodeBo ruleNodeBo : matchRules) {
            LeafRuleTraceHelper.findRuleToGraph(ctx, ruleNodeBo);
        }
        HashSet<GraphNode> nodeSet = new HashSet<GraphNode>(16);
        for (RuleNodeBo node : execGraph.nodes()) {
            nodeSet.add(new GraphNode(node.getRuleDto().getId(), node.getRuleDto().getNumber()));
        }
        MutableGraph<GraphNode> mutableGraph = ctx.getGraph();
        return Graphs.inducedSubgraph(mutableGraph, nodeSet);
    }

    private static void findRuleToGraph(LeafRuleTraceContext ctx, RuleNodeBo currRule) {
        List<RuleNodeBo> rightRules = LeafRuleTraceHelper.findRightRules(ctx, currRule);
        if (rightRules.isEmpty()) {
            return;
        }
        MutableGraph<RuleNodeBo> graph = ctx.getExecGraph();
        Set nodes = graph.nodes();
        for (RuleNodeBo rightRule : rightRules) {
            String ruleId = rightRule.getRuleId();
            Set sameRules = nodes.stream().filter(e -> StringUtils.startsWith((CharSequence)e.getRuleId(), (CharSequence)ruleId)).collect(Collectors.toSet());
            if (!sameRules.isEmpty()) continue;
            graph.addNode((Object)rightRule);
            graph.putEdge((Object)currRule, (Object)rightRule);
            LeafRuleTraceHelper.findRuleToGraph(ctx, rightRule);
        }
    }

    private static List<RuleNodeBo> findRightRules(LeafRuleTraceContext ctx, RuleNodeBo currRule) {
        ArrayList rightRules = Lists.newArrayList();
        RuleDto ruleDto = currRule.getRuleDto();
        Map leftScope = ruleDto.getLeftMembers();
        Map leftCalcScope = currRule.getCalcRequest().getMemberInfo();
        IModelCacheHelper modelCache = ctx.getModelCache();
        for (RuleRightItemDto rightItemDto : ruleDto.getRuleRightItemDto()) {
            Map rightMembers = ruleDto.getRightMembers();
            Map refMemberMap = (Map)rightMembers.get(rightItemDto.getMemberKey());
            LinkedHashMap rightRuleScope = Maps.newLinkedHashMap();
            Long rightDataSetId = rightItemDto.getDataSetId();
            List rightDimensionList = modelCache.getDimensionList(rightDataSetId);
            for (Dimension dimension : rightDimensionList) {
                String rDimNumber = dimension.getNumber();
                Set rSet = (Set)refMemberMap.get(rDimNumber);
                Set lSet = (Set)leftScope.get(rDimNumber);
                Set lCSet = (Set)leftCalcScope.get(rDimNumber);
                if (rSet != null) {
                    rightRuleScope.put(rDimNumber, rSet);
                } else if (lCSet != null) {
                    rightRuleScope.put(rDimNumber, lCSet);
                } else if (lSet != null) {
                    rightRuleScope.put(rDimNumber, new HashSet(lSet));
                } else {
                    String noneNumber = modelCache.getDimension(rDimNumber).getNoneNumber();
                    rightRuleScope.put(rDimNumber, Collections.singleton(noneNumber));
                }
                if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(rDimNumber) || rightItemDto.getPeriodOffset() == null || rightItemDto.getPeriodOffset() == 0) continue;
                Set bpSet = (Set)rightRuleScope.get(SysDimensionEnum.BudgetPeriod.getNumber());
                HashSet bpNewSet = Sets.newHashSet();
                for (String bp : bpSet) {
                    Member bpMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), bp, rightItemDto.getPeriodOffset().intValue());
                    if (bpMember == null) continue;
                    bpNewSet.add(bpMember.getNumber());
                }
                rightRuleScope.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpNewSet);
            }
            List<RuleNodeBo> matchRules = LeafRuleTraceHelper.matchRules(ctx, rightRuleScope);
            rightRules.addAll(matchRules);
        }
        return rightRules;
    }

    private static List<RuleNodeBo> matchRules(LeafRuleTraceContext traceRuleContext, Map<String, Set<String>> leftScope) {
        IModelCacheHelper modelCache = traceRuleContext.getModelCache();
        List beMatchRules = traceRuleContext.beMatchRules;
        ArrayList ruleList = Lists.newArrayList();
        HashSet unMatchSet = Sets.newHashSet();
        for (RuleDto rule : beMatchRules) {
            Map leftMembers = rule.getLeftMembers();
            LinkedHashMap exeScope = Maps.newLinkedHashMap();
            for (Map.Entry<String, Set<String>> entry : leftScope.entrySet()) {
                String dimNumber = entry.getKey();
                Set<String> memSet = entry.getValue();
                Set ruleMembers = (Set)leftMembers.get(dimNumber);
                if (ruleMembers == null) {
                    exeScope.put(dimNumber, memSet);
                    continue;
                }
                Set interSet = memSet.stream().filter(ruleMembers::contains).collect(Collectors.toSet());
                if (interSet.isEmpty()) {
                    unMatchSet.add(rule.getId());
                    break;
                }
                exeScope.put(dimNumber, interSet);
            }
            if (unMatchSet.contains(rule.getId())) continue;
            Long dsId = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, (String)((Set)exeScope.get(SysDimensionEnum.Account.getNumber())).iterator().next()).getDatasetId();
            AlgoCalcRequest calcRequest = new AlgoCalcRequest(modelCache.getModelobj().getId(), dsId, (Map)exeScope, Collections.singletonList(rule));
            String ruleId = rule.getId().toString();
            ruleList.add(new RuleNodeBo(ruleId, rule, calcRequest));
        }
        return ruleList;
    }

    public static class LeafRuleTraceContext {
        private Map<String, Set<String>> leftScope;
        private List<RuleDto> allRules;
        MutableGraph<GraphNode> graph;
        private IModelCacheHelper modelCache;
        private List<RuleDto> beMatchRules;
        private MutableGraph<RuleNodeBo> execGraph = GraphBuilder.directed().allowsSelfLoops(false).build();

        public LeafRuleTraceContext(Map<String, Set<String>> leftScope, List<RuleDto> allRules, MutableGraph<GraphNode> graph, IModelCacheHelper modelCache) {
            this.leftScope = leftScope;
            this.allRules = allRules;
            this.graph = graph;
            this.modelCache = modelCache;
        }

        public List<RuleDto> getAllRules() {
            return this.allRules;
        }

        public void setAllRules(List<RuleDto> allRules) {
            this.allRules = allRules;
        }

        public IModelCacheHelper getModelCache() {
            return this.modelCache;
        }

        public void setModelCache(IModelCacheHelper modelCache) {
            this.modelCache = modelCache;
        }

        public MutableGraph<GraphNode> getGraph() {
            return this.graph;
        }

        public void setGraph(MutableGraph<GraphNode> graph) {
            this.graph = graph;
        }

        public MutableGraph<RuleNodeBo> getExecGraph() {
            return this.execGraph;
        }

        public void setExecGraph(MutableGraph<RuleNodeBo> execGraph) {
            this.execGraph = execGraph;
        }

        public Map<String, Set<String>> getLeftScope() {
            return this.leftScope;
        }

        public void setLeftScope(Map<String, Set<String>> leftScope) {
            this.leftScope = leftScope;
        }

        public List<RuleDto> getBeMatchRules() {
            return this.beMatchRules;
        }

        public void setBeMatchRules(List<RuleDto> beMatchRules) {
            this.beMatchRules = beMatchRules;
        }
    }
}

