/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizrule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.business.bizrule.RuleExecutionContext;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.business.bizrule.entity.RuleExecLogDetail;
import kd.epm.eb.business.ebupgrades.utils.PermUpgradesUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.rule.execute.RuleExecuteLogStatusEnum;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.rule.execute.RulePushStatusEnum;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleExecutionCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleTraceHelper;
import kd.epm.eb.olap.impl.bizrule.entity.RuleBo;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleExecutionRequest;
import kd.epm.eb.olap.impl.bizrule.entity.RuleNodeBo;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleTemplateInfo;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.utils.PageUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class RuleExecutionService {
    private static final String LOG_PREFIX = "ruleExecution_";
    private static int delPos = 0;
    private static int delErrorLog = 0;
    private static final Log log = LogFactory.getLog(RuleExecutionService.class);

    public static RuleExecutionService getInstance() {
        return InnerClass.instance;
    }

    public void executeRuleChain(RuleTemplateInfo ruleTemplateInfo, Long datasetId, Long modelId, List<BGCell> cells, String exeType) {
        this.executeRuleChain(ruleTemplateInfo, datasetId, modelId, cells, exeType, new Options());
    }

    public void executeRuleChain(RuleTemplateInfo ruleTemplateInfo, Long datasetId, Long modelId, List<BGCell> cells, String exeType, Options options) {
        if (options != null && options.getAnalysisContext() != null) {
            OlapContext.setAnalysisContext((AnalysisContext)options.getAnalysisContext());
        }
        RuleExecutionRequest request = new RuleExecutionRequest();
        request.setRuleTemplateInfo(ruleTemplateInfo);
        request.setDatasetId(datasetId);
        request.setModelId(modelId);
        request.setCells(cells);
        request.setExeType(exeType);
        this.executeRuleChain(request, options);
    }

    private void executeRuleChain(RuleExecutionRequest request, Options options) {
        Long modelId = request.getModelId();
        RuleExecutionContext ctx = new RuleExecutionContext();
        try {
            MutableGraph<GraphNode> syncGraph;
            boolean skip;
            List cells = request.getCells();
            if (CollectionUtils.isEmpty((Collection)cells)) {
                log.info("ruleExecution_cell\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            String example = JSON.toJSONString(cells.stream().limit(5L).collect(Collectors.toList()));
            log.info("ruleExecution_\u4f20\u5165\u6570\u636e\u91c7\u6837\uff1a" + example);
            List delCells = cells.stream().filter(e -> e.getValue() == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)e.getValue().toString())).collect(Collectors.toList());
            log.info("ruleExecution_\u5355\u5143\u683c\u6570\u91cf:" + cells.size() + ",\u5220\u9664\u6570\u91cf\uff1a" + delCells.size());
            if (!delCells.isEmpty()) {
                log.info("ruleExecution_\u5355\u5143\u683c\u5220\u9664\u91c7\u6837:" + JSON.toJSONString(delCells.get(0)));
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List dimensionList = modelCache.getDimensionList(request.getDatasetId());
            ctx = new RuleExecutionContext(cells, modelId, modelCache);
            ctx.setRuleExecuteTypeEnum(RuleExecuteTypeEnum.getByType((String)request.getExeType()));
            Long datasetId = request.getDatasetId();
            Long bizCtrlId = modelCache.getBusModelByDataSet(datasetId);
            Stopwatch sw = Stopwatch.createStarted();
            List allEnableRuleDto = RuleCacheService.getInstance().listRuleFromLocalCache(bizCtrlId).getRuleDtoList();
            List<RuleBo> allEnableRule = allEnableRuleDto.stream().map(RuleBo::new).collect(Collectors.toList());
            log.info("ruleExecution_\u67e5\u8be2\u53ef\u7528\u89c4\u5219,\u8017\u65f6\uff1a" + sw.elapsed(TimeUnit.MILLISECONDS) + "cellSize:" + cells.size());
            List<BGCell> trustCells = Lists.newArrayList();
            boolean bl = skip = options.getUseAnalysis() != false || options.getSkipTrust() != false;
            if (!skip) {
                List<BGCell> calcCells = this.getTrustCell(datasetId, cells, allEnableRule, modelCache, options.getViewMap());
                Map<String, BGCell> calcCellMap = calcCells.stream().collect(Collectors.toMap(e -> e.getKey2(dimensionList), e -> e, (v1, v2) -> v2));
                for (BGCell cell : cells) {
                    String cellKey = cell.getKey2(dimensionList);
                    BGCell calcCell = calcCellMap.get(cellKey);
                    if (calcCell == null) continue;
                    trustCells.add(calcCell);
                }
                log.info("ruleExecution_\u5148\u7b97\u4e0b\u81ea\u5df1,\u8017\u65f6\uff1a" + sw.elapsed(TimeUnit.MILLISECONDS) + "cellSize:" + trustCells.size());
            } else {
                trustCells = cells;
            }
            this.bindCellToRightItem(trustCells, allEnableRule, modelCache);
            List relationRules = allEnableRule.stream().filter(e -> !e.getRightDataScope().isEmpty()).collect(Collectors.toList());
            log.info("ruleExecution_\u4ececell\u5355\u5143\u683c\u91cc\u53d6\u5230\u5173\u8054\u7684\u4e1a\u52a1\u89c4\u5219" + relationRules + ",\u8017\u65f6:" + sw.elapsed(TimeUnit.MILLISECONDS));
            if (relationRules.isEmpty()) {
                log.info("ruleExecution_\u6ca1\u6709\u5173\u8054\u5230\u4e1a\u52a1\u89c4\u5219");
                return;
            }
            MutableGraph<GraphNode> graph = RuleGraphService.getInstance().getDagGraphByBizmodel(allEnableRuleDto);
            Set<Long> relationRuleIds = relationRules.stream().map(RuleBo::getId).collect(Collectors.toSet());
            HashSet reachableNodes = Sets.newHashSet();
            relationRuleIds.forEach(rid -> reachableNodes.addAll(Graphs.reachableNodes((Graph)graph, (Object)new GraphNode((Long)rid))));
            Set reachableIds = reachableNodes.stream().map(GraphNode::getNodeId).collect(Collectors.toSet());
            reachableIds.addAll(relationRuleIds);
            allEnableRule.stream().filter(r -> reachableIds.contains(r.getId())).forEach(r -> {
                String[] offSetNodes = org.apache.commons.lang3.StringUtils.split((String)r.getOffSuccessors(), (String)",");
                relationRuleIds.addAll(Stream.of(offSetNodes).map(Long::parseLong).collect(Collectors.toSet()));
            });
            Set<GraphNode> relationNodes = graph.nodes().stream().filter(e -> relationRuleIds.contains(e.getNodeId())).collect(Collectors.toSet());
            MutableGraph<GraphNode> exeGraph = RuleGraphService.getInstance().getSubGraphForStarNode((Collection<GraphNode>)relationNodes, (Graph<GraphNode>)graph, allEnableRuleDto);
            Object asyncGraph = Graphs.copyOf(exeGraph);
            RuleTemplateInfo ruleTemplateInfo = request.getRuleTemplateInfo();
            if (ruleTemplateInfo == null) {
                syncGraph = Graphs.copyOf(exeGraph);
                asyncGraph = RuleGraphService.getInstance().initEmptyGraph();
            } else {
                List<Long> templateRuleIds = this.listRelRule(ruleTemplateInfo);
                List<GraphNode> templateNodes = exeGraph.nodes().stream().filter(e -> templateRuleIds.contains(e.getNodeId())).collect(Collectors.toList());
                syncGraph = RuleGraphService.getInstance().getSyncGraph(templateNodes, exeGraph, ruleTemplateInfo, allEnableRuleDto, modelCache);
                if (syncGraph.nodes().size() > 0) {
                    Set syncNodes = syncGraph.nodes();
                    Set asyncNodes = exeGraph.nodes().stream().filter(e -> !syncNodes.contains(e)).collect(Collectors.toSet());
                    asyncGraph = CollectionUtils.isNotEmpty(asyncNodes) ? Graphs.inducedSubgraph(exeGraph, asyncNodes) : RuleGraphService.getInstance().initEmptyGraph();
                }
            }
            log.info("ruleExecution_ruleSize:" + exeGraph.nodes().size() + ",syncSize:" + syncGraph.nodes().size() + ",asyncSize:" + asyncGraph.nodes().size());
            Map<Long, Set<String>> mapTemplateByRule = this.mapTemplateByRule(modelId, exeGraph);
            DynamicObject logInstance = this.addNewLog(request, exeGraph, syncGraph, (MutableGraph<GraphNode>)asyncGraph, mapTemplateByRule, modelCache, example, options.getViewMap());
            ctx.setTotalGraph(graph);
            ctx.setTotalExeGraph(exeGraph);
            ctx.setRuleTemplateInfo(ruleTemplateInfo);
            ctx.setAllEnableRule(allEnableRule);
            ctx.setLogMain(logInstance);
            ctx.setMapTemplateByRule(mapTemplateByRule);
            ctx.setOptions(options);
            List<RuleBo> totalGraphRules = allEnableRule.stream().filter(e -> graph.nodes().contains(new GraphNode(e.getId()))).collect(Collectors.toList());
            HashMap totalGraphOffMap = Maps.newHashMapWithExpectedSize((int)10);
            totalGraphRules.forEach(r -> {
                String[] offSetNodes = org.apache.commons.lang3.StringUtils.split((String)r.getOffSuccessors(), (String)",");
                Set offSet = totalGraphOffMap.computeIfAbsent(r.getId(), v -> Sets.newHashSetWithExpectedSize((int)10));
                offSet.addAll(Stream.of(offSetNodes).map(Long::parseLong).collect(Collectors.toSet()));
            });
            ctx.setTotalGraphOffMap(totalGraphOffMap);
            log.info("ruleExecution_syncGraph:" + syncGraph);
            this.execute(syncGraph, true, ctx);
            log.info("ruleExecution_execute_syncGraph\u8017\u65f6:" + sw.elapsed(TimeUnit.MILLISECONDS));
            if (!asyncGraph.nodes().isEmpty()) {
                log.info("ruleExecution_asyncGraph:" + asyncGraph);
                MutableGraph finalAsyncGraph = asyncGraph;
                String loginIP = RequestContext.getOrCreate().getLoginIP();
                String traceId = RequestContext.getOrCreate().getTraceId();
                RuleExecutionContext finalCtx = ctx;
                EpmThreadPools.RULE_EXECUTION_POOL.execute(() -> {
                    RequestContext.getOrCreate().setLoginIP(loginIP);
                    RequestContext.getOrCreate().setTraceId(traceId);
                    this.execute((MutableGraph<GraphNode>)finalAsyncGraph, false, finalCtx);
                });
                log.info("ruleExecution_execute_asyncGraph\u5f00\u59cb\u5f02\u6b65\u6267\u884c:" + sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }
        catch (Exception e2) {
            log.error("\u89c4\u5219\u4f9d\u8d56\u8ba1\u7b97\u51fa\u9519", (Throwable)e2);
            String title = ResManager.loadKDString((String)"\u89c4\u5219\u4f9d\u8d56\u8ba1\u7b97\u51fa\u9519\u901a\u77e5\u3002", (String)"RuleExecutionService_4", (String)"epm-eb-business", (Object[])new Object[0]);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray());
            String shownumber = "";
            if (dynamicObject != null) {
                shownumber = dynamicObject.getString("shownumber");
            }
            String messageDate = ResManager.loadResFormat((String)"\u4f53\u7cfb\uff1a%1\uff0c\u89c4\u5219\u4f9d\u8d56\u8ba1\u7b97\u51fa\u9519\uff0c\u8bf7\u5347\u7ea7\u89c4\u5219\u4f9d\u8d56\u540e\u91cd\u65b0\u7f16\u6570\u6216\u624b\u5de5\u6267\u884c\u89c4\u5219\u3002", (String)"RuleExecutionService_5", (String)"epm-eb-business", (Object[])new Object[]{shownumber});
            ctx.getErrMsgs().add(ThrowableHelper.printError((Throwable)e2));
            this.sendMessage(ctx, title, messageDate);
            throw e2;
        }
    }

    private List<Long> listRelRule(RuleTemplateInfo ruleTemplateInfo) {
        List<Long> ruleIds = "budget".equals(ruleTemplateInfo.getTemplateType()) ? RuleRelationService.getInstance().listRuleByTemplateId(ruleTemplateInfo.getTemplateId()) : RuleRelationService.getInstance().listRuleByApplyTemplateId(ruleTemplateInfo.getApplyTemplateIds());
        return ruleIds;
    }

    public List<BGCell> getTrustCell(Long datasetId, List<BGCell> bgCells, List<RuleBo> allEnableRule, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        ArrayList<BGCell> realCells = new ArrayList<BGCell>(bgCells.size());
        Map groupViewsMap = modelCache.getViewGroupViewsByDataSet(datasetId);
        HashMap ruleMap = Maps.newHashMap();
        HashMap backCellMap = Maps.newHashMap();
        HashMap ruleScopeMap = Maps.newHashMap();
        List<String> dimNumbers = modelCache.getDimensionList().stream().map(BaseCache::getNumber).collect(Collectors.toList());
        for (BGCell bGCell : bgCells) {
            Map<String, Set<String>> cellScope = bGCell.getMemberMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Sets.newHashSet((Object[])new String[]{(String)e.getValue()})));
            boolean relate = false;
            boolean leafCell = this.isLeafCell(bGCell, groupViewsMap, modelCache);
            for (RuleBo r : allEnableRule) {
                if (LeafFeature.NOTLEAF == r.getLeafFeature() && leafCell || LeafFeature.LEAF == r.getLeafFeature() && !leafCell || !(relate = RuleRelationService.getInstance().checkRelate(cellScope, r.getLeftMembers(), dimNumbers))) continue;
                List backCells = backCellMap.computeIfAbsent(r.getId(), v -> Lists.newArrayList());
                backCells.add(bGCell);
                ruleMap.put(r.getId(), r);
                Set maps = ruleScopeMap.computeIfAbsent(r.getId(), v -> Sets.newHashSet());
                maps.add(cellScope);
                break;
            }
            if (relate) continue;
            realCells.add(bGCell);
        }
        if (MapUtils.isNotEmpty((Map)ruleMap)) {
            for (Map.Entry entry : ruleScopeMap.entrySet()) {
                Long ruleId = (Long)entry.getKey();
                List<BGCell> trustCells = this.calcTrustData(datasetId, Collections.singletonList(ruleMap.get(ruleId)), (Set)ruleScopeMap.get(ruleId), modelCache, (List)backCellMap.get(ruleId), viewMap);
                realCells.addAll(trustCells);
            }
        }
        return realCells;
    }

    private boolean isLeafCell(BGCell cell, Map<String, List<Long>> groupViewsMap, IModelCacheHelper modelCache) {
        for (Map.Entry entry : cell.getMemberMap().entrySet()) {
            Member member;
            String dim = (String)entry.getKey();
            String mem = (String)entry.getValue();
            List<Long> viewIds = groupViewsMap.get(dim);
            if (CollectionUtils.isNotEmpty(viewIds)) {
                Long viewId;
                member = null;
                Iterator<Long> iterator = viewIds.iterator();
                while (iterator.hasNext() && (member = modelCache.getMember(dim, viewId = iterator.next(), mem)) == null) {
                }
                if (member != null && member.isLeaf()) continue;
                return false;
            }
            member = modelCache.getMember(dim, Long.valueOf(0L), mem);
            if (member != null && member.isLeaf()) continue;
            return false;
        }
        return true;
    }

    private List<BGCell> calcTrustData(Long datasetId, List<RuleBo> ruleBoSet, Set<Map<String, Set<String>>> ruleScopeSet, IModelCacheHelper modelCache, List<BGCell> backCells, Map<String, Long> viewMap) {
        Map<String, Set> scope = ruleScopeSet.stream().map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
        List executeRuleDtos = ruleBoSet.stream().map(RuleBo::getRuleDto).collect(Collectors.toList());
        AlgoCalcRequest request = new AlgoCalcRequest(modelCache.getModelobj().getId(), datasetId, scope, executeRuleDtos);
        request.setViewMap(viewMap);
        List dbCells = OlapCommService.getInstance().calcAndSave(request);
        return AlgoCalcUtils.getTrustCell(backCells, (List)dbCells, (List)modelCache.getDimensionList(datasetId));
    }

    public void calcRuleExecutionScope(RuleBo ruleBo, RuleExecutionContext ctx) {
        log.info("\u8ba1\u7b97\u89c4\u5219\u7684\u6267\u884c\u8303\u56f4:" + ruleBo.getNumber());
        if (ruleBo.getRightDataScope().isEmpty()) {
            log.info("ruleExecution_\u53f3\u5f0f\u6ca1\u6709\u6570\u636e\u53d8\u52a8,\u8df3\u8fc7\u89c4\u5219\uff1a" + ruleBo.getNumber());
            return;
        }
        List ruleRightItemDto = ruleBo.getRuleRightItemDto();
        Map ruleExecutionScope = ruleBo.getRuleExecutionScope();
        for (RuleRightItemDto rightItemDto : ruleRightItemDto) {
            Map<String, Set<String>> rightEntryScope = this.getRightEntryScope(rightItemDto, ruleBo, (Map)ruleBo.getRightDataScope().get(rightItemDto.getMemberKey()), ctx.getModelCache());
            this.unionRuleExecutionScope(rightEntryScope, ruleExecutionScope);
        }
        String metricNumber = (String)((Set)ruleBo.getRuleDto().getLeftMembers().get(SysDimensionEnum.Metric.getNumber())).iterator().next();
        if (!ruleExecutionScope.isEmpty()) {
            boolean isPeriodshift = ruleRightItemDto.stream().anyMatch(RuleRightItemDto::isPeriodshift);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ruleBo.getOffSuccessors()) || isPeriodshift || OlapManager.getInstance().haveFinanceFun(ruleBo.getRuleDto())) {
                Set<Object> templateBpMembers;
                Map leftMembers = ruleBo.getLeftMembers();
                if (leftMembers.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
                    templateBpMembers = new HashSet((Collection)leftMembers.get(SysDimensionEnum.BudgetPeriod.getNumber()));
                    log.info("ruleExecution_\u6709\u671f\u95f4\u504f\u79fb\u53d6\u516c\u5f0f\u7684\u671f\u95f4\u8303\u56f4:" + JSON.toJSONString(templateBpMembers));
                } else {
                    templateBpMembers = ctx.getModelCache().getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber).hasAgg() ? ctx.getModelCache().getMembers(null, SysDimensionEnum.BudgetPeriod.getNumber()).stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet()) : ctx.getModelCache().getMembers(null, SysDimensionEnum.BudgetPeriod.getNumber()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    log.info("ruleExecution_\u53d6\u6240\u6709\u671f\u95f4\u8303\u56f4:" + JSON.toJSONString(templateBpMembers));
                }
                ruleExecutionScope.put(SysDimensionEnum.BudgetPeriod.getNumber(), templateBpMembers);
            }
        }
        if (!ctx.getModelCache().getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber).hasAgg()) {
            boolean rightAgg = ruleRightItemDto.stream().anyMatch(e -> {
                Set metSet = (Set)e.getRefMemberMap().get(SysDimensionEnum.Metric.getNumber());
                boolean agg = false;
                if (metSet != null && !metSet.isEmpty()) {
                    String metNum = (String)metSet.iterator().next();
                    agg = ctx.getModelCache().getMember(SysDimensionEnum.Metric.getNumber(), null, metNum).hasAgg();
                }
                return agg;
            });
            if (!rightAgg) {
                return;
            }
            Map ruleMap = ruleBo.getRuleDto().getLeftMembers();
            for (Map.Entry entry : ruleExecutionScope.entrySet()) {
                Set memSet = (Set)entry.getValue();
                String dimNumber = (String)entry.getKey();
                Dimension dimension = ctx.getModelCache().getDimension(dimNumber);
                HashSet newSet = Sets.newHashSet();
                Set ruleMemSet = (Set)ruleMap.get(dimNumber);
                Long viewId = (Long)ruleBo.getRuleDto().getViewMap().get(dimNumber);
                for (String mem : memSet) {
                    Member member = ctx.getModelCache().getMember(dimNumber, viewId, mem);
                    Set parentSet = ctx.getModelCache().getParents(viewId, member, true).stream().filter(e -> {
                        if (dimension.isPreset()) {
                            return e.getLevel() > 1;
                        }
                        return true;
                    }).map(BaseCache::getNumber).collect(Collectors.toSet());
                    if (ruleMemSet != null) {
                        parentSet.retainAll(ruleMemSet);
                    }
                    newSet.addAll(parentSet);
                }
                memSet.clear();
                memSet.addAll(newSet);
            }
        }
    }

    private Map<String, Set<String>> getRightEntryScope(RuleRightItemDto rightItemDto, RuleBo ruleBo, Map<String, Set<String>> rightItemScope, IModelCacheHelper modelCache) {
        Map rightScope = rightItemDto.getRefMemberMap();
        if (MapUtils.isEmpty(rightItemScope)) {
            log.info("ruleExecution_\u6b64\u53f3\u5f0f\u65e0cell\u6570\u636e\u53d8\u52a8\uff0c\u8df3\u8fc7\u5f53\u524d\u53f3\u5f0f");
            return new HashMap<String, Set<String>>(16);
        }
        Long leftDataSetId = ruleBo.getDataSetId();
        Map leftMembers = ruleBo.getLeftMembers();
        Map leftGroupViewsMap = modelCache.getViewGroupViewsByDataSet(leftDataSetId);
        Integer offSet = rightItemDto.getPeriodOffset();
        List functionRefDimList = rightItemDto.getFunctionRefDimList();
        Long rightDataSetId = rightItemDto.getDataSetId();
        Map rightDimensionMap = modelCache.getDimensionMap(rightDataSetId);
        List leftDimensionList = modelCache.getDimensionList(leftDataSetId);
        HashMap rightScopeMap = Maps.newHashMapWithExpectedSize((int)leftDimensionList.size());
        for (Dimension leftDimension : leftDimensionList) {
            Set<String> dataMembers;
            HashSet leftMemberSet;
            String leftDimNumber = leftDimension.getNumber();
            HashSet hashSet = leftMemberSet = leftMembers.get(leftDimNumber) == null ? null : new HashSet((Collection)leftMembers.get(leftDimNumber));
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(leftDimNumber) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ruleBo.getOffSuccessors())) continue;
            if (!rightDimensionMap.containsKey(leftDimNumber)) {
                if (CollectionUtils.isNotEmpty(leftMemberSet)) {
                    rightScopeMap.put(leftDimNumber, leftMemberSet);
                    continue;
                }
                Dimension leftDim = modelCache.getDimension(leftDimNumber);
                String noneNumber = leftDim.getNoneNumber();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)noneNumber)) {
                    rightScopeMap.computeIfAbsent(leftDimNumber, v -> new HashSet(10)).add(noneNumber);
                    continue;
                }
                this.addAllLeftLeafMembers(modelCache, leftGroupViewsMap, rightScopeMap, leftDimNumber);
                continue;
            }
            if (functionRefDimList != null && functionRefDimList.contains(leftDimNumber)) {
                if (CollectionUtils.isNotEmpty(leftMemberSet)) {
                    rightScopeMap.put(leftDimNumber, leftMemberSet);
                    continue;
                }
                this.addAllLeftLeafMembers(modelCache, leftGroupViewsMap, rightScopeMap, leftDimNumber);
                continue;
            }
            Set rightMembers = (Set)rightScope.get(leftDimNumber);
            if (CollectionUtils.isNotEmpty(leftMemberSet)) {
                if (CollectionUtils.isNotEmpty((Collection)rightMembers)) {
                    rightScopeMap.put(leftDimNumber, leftMemberSet);
                    continue;
                }
                dataMembers = rightItemScope.get(leftDimNumber);
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(leftDimNumber) && offSet != null && offSet != 0) {
                    dataMembers = leftMembers.containsKey(SysDimensionEnum.BudgetPeriod.getNumber()) ? (Set<String>)leftMembers.get(SysDimensionEnum.BudgetPeriod.getNumber()) : this.getOffSetDimMembers(dataMembers, modelCache, -offSet.intValue());
                }
                HashSet tmpLeftMembers = new HashSet(leftMemberSet);
                tmpLeftMembers.retainAll(dataMembers);
                if (tmpLeftMembers.isEmpty()) {
                    log.info("ruleExecution_\u6570\u636e\u4e0e\u53f3\u5f0f\u4ea4\u96c6\u4e3a\u7a7a");
                    return Maps.newHashMap();
                }
                rightScopeMap.put(leftDimNumber, tmpLeftMembers);
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)rightMembers)) {
                this.addAllLeftLeafMembers(modelCache, leftGroupViewsMap, rightScopeMap, leftDimNumber);
                continue;
            }
            dataMembers = rightItemScope.get(leftDimNumber);
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(leftDimNumber) && offSet != null && offSet != 0) {
                dataMembers = this.getOffSetDimMembers(dataMembers, modelCache, -offSet.intValue());
            }
            rightScopeMap.put(leftDimNumber, dataMembers);
        }
        return rightScopeMap;
    }

    private void addAllLeftLeafMembers(IModelCacheHelper modelCache, Map<String, List<Long>> leftGroupViewsMap, Map<String, Set<String>> rightScopeMap, String leftDimNumber) {
        HashSet<String> allLeftMembers = new HashSet<String>(16);
        List<Long> viewIds = leftGroupViewsMap.get(leftDimNumber);
        if (CollectionUtils.isNotEmpty(viewIds)) {
            for (Long viewId : viewIds) {
                allLeftMembers.addAll(this.getLeafMembers(leftDimNumber, viewId, modelCache));
            }
        } else {
            allLeftMembers.addAll(this.getLeafMembers(leftDimNumber, 0L, modelCache));
        }
        rightScopeMap.put(leftDimNumber, allLeftMembers);
    }

    private Set<String> getOffSetDimMembers(Set<String> cellMembers, IModelCacheHelper modelCache, int offset) {
        HashSet realMembers = Sets.newHashSet();
        for (String member : cellMembers) {
            Member offsetMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), member, offset);
            if (offsetMember == null) continue;
            realMembers.add(offsetMember.getNumber());
        }
        return realMembers;
    }

    private void unionRuleExecutionScope(Map<String, Set<String>> rightEntryScope, Map<String, Set<String>> ruleExecutionScope) {
        if (rightEntryScope == null || rightEntryScope.isEmpty()) {
            return;
        }
        rightEntryScope.forEach((k, v) -> ruleExecutionScope.merge((String)k, (Set<String>)v, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
    }

    private Set<String> getLeafMembers(String dimNumber, Long viewId, IModelCacheHelper modelCache) {
        List allMembers = modelCache.getMembers(viewId, dimNumber);
        return allMembers.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
    }

    private void execute(MutableGraph<GraphNode> exeGraph, Boolean isSyn, RuleExecutionContext ctx) {
        ArrayList logDetList = Lists.newArrayListWithExpectedSize((int)16);
        if (exeGraph == null || exeGraph.nodes().size() < 1) {
            return;
        }
        MutableGraph originExeGraph = Graphs.copyOf(exeGraph);
        Stopwatch swTotal = Stopwatch.createStarted();
        Stopwatch sw = Stopwatch.createStarted();
        Map<Long, RuleBo> allEnableRuleMap = ctx.getAllEnableRule().stream().collect(Collectors.toMap(RuleBo::getId, e -> e));
        int i = 0;
        while (!exeGraph.nodes().isEmpty()) {
            ++i;
            Set<GraphNode> zeroNodes = RuleGraphService.getInstance().getZeroNodes((Graph<GraphNode>)exeGraph);
            GraphNode zNode = zeroNodes.iterator().next();
            RuleBo exeRule = allEnableRuleMap.get(zNode.getNodeId());
            ctx.getExecutedRules().add(zNode.getNodeId());
            RuleExecLogDetail logDetail = this.getNewLogDetail(exeRule, isSyn, ctx.getTotalExeGraph().predecessors((Object)zNode), ctx.getTotalExeGraph().successors((Object)zNode), ctx);
            logDetail.setSequence(i);
            logDetList.add(logDetail);
            sw.reset().start();
            try {
                Iterator pageIte;
                Map rightDataScope = exeRule.getRightDataScope();
                if (MapUtils.isEmpty((Map)rightDataScope)) {
                    log.info("ruleExecution_\u89c4\u5219\u53f3\u5f0f\u8303\u56f4\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u6b64\u89c4\u5219:" + exeRule.getNumber());
                    logDetail.setExecutelog(ResManager.loadResFormat((String)"\u89c4\u5219\u53f3\u5f0f\u8303\u56f4\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u6b64\u89c4\u5219:%1\u3002", (String)"RuleExecutionService_6", (String)"epm-eb-business", (Object[])new Object[]{exeRule.getNumber()}));
                    exeGraph.removeNode((Object)zNode);
                    this.markPredecessorsStatus(zNode, ctx);
                    continue;
                }
                this.calcRuleExecutionScope(exeRule, ctx);
                if (exeRule.getLeafFeature() == LeafFeature.LEAF) {
                    this.excludeVirtualMember(exeRule, ctx);
                    log.info("ruleExecution_\u4ec5\u660e\u7ec6\u516c\u5f0f,\u6392\u9664\u6389\u865a\u62df\u6210\u5458," + exeRule.getNumber());
                }
                this.excludeCtControlMember(exeRule);
                log.info("ruleExecution_\u8ba1\u7b97\u89c4\u5219\u7684\u6267\u884c\u8303\u56f4,\u8017\u65f6:" + sw.elapsed(TimeUnit.MILLISECONDS));
                Map<String, Set<String>> ruleExecutionScope = exeRule.getRuleExecutionScope();
                log.info("ruleExecution_\u6267\u884c\u89c4\u5219\uff1a" + exeRule.getNumber() + ",scope:" + JSON.toJSONString((Object)ruleExecutionScope));
                if (ruleExecutionScope == null || ruleExecutionScope.isEmpty()) {
                    log.info("ruleExecution_\u89c4\u5219\u6267\u884c\u8303\u56f4\u4e3a\u7a7a\uff1a" + exeRule.getNumber());
                    logDetail.setExecutelog(ResManager.loadResFormat((String)"\u89c4\u5219\u6267\u884c\u8303\u56f4\u4e3a\u7a7a\uff1a%1", (String)"RuleExecutionService_7", (String)"epm-eb-business", (Object[])new Object[]{exeRule.getNumber()}));
                    exeGraph.removeNode((Object)zNode);
                    this.markPredecessorsStatus(zNode, ctx);
                    continue;
                }
                String accountNumber = (String)((Set)ruleExecutionScope.get(SysDimensionEnum.Account.getNumber())).iterator().next();
                Member account = ctx.getModelCache().getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
                Long dataSetId = account.getDatasetId();
                Map<String, Set<String>> leafScope = ruleExecutionScope;
                String metricNumber = (String)((Set)ruleExecutionScope.get(SysDimensionEnum.Metric.getNumber())).iterator().next();
                if (ctx.getModelCache().getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber).hasAgg() && (leafScope = this.filterLeafScope(ruleExecutionScope, dataSetId, ctx)).size() != ruleExecutionScope.size()) {
                    log.info("ruleExecution_\u6267\u884c\u8303\u56f4\u91cc\u5b58\u5728\u6ca1\u6709\u53f6\u5b50\u6210\u5458\u7684\u7ef4\u5ea6\uff0cleafScope:" + JSON.toJSONString(leafScope));
                    logDetail.setExecutelog(ResManager.loadResFormat((String)"%1;\u6267\u884c\u8303\u56f4\u91cc\u5b58\u5728\u6ca1\u6709\u53f6\u5b50\u6210\u5458\u7684\u7ef4\u5ea6\uff0cleafScope:%2", (String)"RuleExecutionService_8", (String)"epm-eb-business", (Object[])new Object[]{logDetail.getExecutelog(), JSON.toJSONString(leafScope)}));
                    exeGraph.removeNode((Object)zNode);
                    this.markPredecessorsStatus(zNode, ctx);
                    continue;
                }
                logDetail.setExescope(JSON.toJSONString((Object)leafScope));
                BigInteger sum = kd.epm.eb.common.utils.MapUtils.calcDescartes(leafScope);
                logDetail.setSum(sum.longValue());
                log.info(LOG_PREFIX + exeRule.getNumber() + "\u7b1b\u5361\u5c14\u79ef\u5927\u5c0f\uff1a" + sum + ",\u8017\u65f6:" + sw.elapsed(TimeUnit.MILLISECONDS));
                if (BigInteger.valueOf(1000000L).compareTo(sum) < 0) {
                    List<Map<String, Set<String>>> partByEntity = this.optimizeByEntity(ctx.getModelCache(), dataSetId, leafScope, exeRule);
                    if (partByEntity.isEmpty()) {
                        log.info(LOG_PREFIX + exeRule.getNumber() + "\u4f18\u5316\u540e\u8303\u56f4\u4e3a\u7a7a");
                        exeGraph.removeNode((Object)zNode);
                        this.markPredecessorsStatus(zNode, ctx);
                        continue;
                    }
                    HashMap unionMap = Maps.newHashMap();
                    for (Map<String, Set<String>> map : partByEntity) {
                        kd.epm.eb.common.utils.MapUtils.mergeMap(map, (Map)unionMap);
                    }
                    sum = kd.epm.eb.common.utils.MapUtils.calcDescartes((Map)unionMap);
                    log.info(LOG_PREFIX + exeRule.getNumber() + "\u7f29\u51cf\u540e\u7684\u7b1b\u5361\u5c14\u79ef\u5927\u5c0f\uff1a" + sum + ",\u8017\u65f6:" + sw.elapsed(TimeUnit.MILLISECONDS));
                    pageIte = PageUtil.getPageMapExcludeBpIterator((Map)unionMap, (int)1000000);
                } else {
                    pageIte = PageUtil.getPageMapExcludeBpIterator(leafScope, (int)1000000);
                }
                int successCnt = 0;
                int delCnt = 0;
                ArrayList resultExample = new ArrayList(5);
                ArrayList delExample = new ArrayList(5);
                ArrayList cells = Lists.newArrayList();
                int exeCnt = 0;
                Set<Long> ruleIds = this.getOffsetRuleId(exeRule, exeGraph, (MutableGraph<GraphNode>)originExeGraph, ctx);
                while (pageIte.hasNext()) {
                    ++exeCnt;
                    Map sub = (Map)pageIte.next();
                    ArrayList executeRules = Lists.newArrayList();
                    if (ruleIds.size() == 1) {
                        RuleNodeBo ruleNodeBo = new RuleNodeBo(exeRule.getId() + "", exeRule.getRuleDto(), new AlgoCalcRequest(Long.valueOf(ctx.getModelId()), dataSetId, sub, Collections.singletonList(exeRule.getRuleDto()), ctx.getOptions()));
                        executeRules.add(ruleNodeBo);
                    } else {
                        List ruleBos = ctx.getAllEnableRule().stream().filter(e -> ruleIds.contains(e.getId())).collect(Collectors.toList());
                        List beMatchRules = ruleBos.stream().map(RuleBo::getRuleDto).collect(Collectors.toList());
                        RuleTraceHelper.RuleTraceContext bizCtx = new RuleTraceHelper.RuleTraceContext(sub, beMatchRules, ctx.getModelCache());
                        bizCtx.setViewMap(exeRule.getRuleDto().getViewMap());
                        RuleTraceHelper.findRuleToGraph((RuleTraceHelper.RuleTraceContext)bizCtx);
                        MutableGraph graph = bizCtx.getGraph();
                        MutableGraph transpose = Graphs.copyOf((Graph)Graphs.transpose((Graph)graph));
                        String traceRuleIds = transpose.nodes().stream().map(RuleNodeBo::getRuleId).collect(Collectors.joining(","));
                        while (!transpose.nodes().isEmpty()) {
                            Set<RuleNodeBo> zeroNodeSet = transpose.nodes().stream().filter(node -> transpose.inDegree(node) == 0).collect(Collectors.toSet());
                            zeroNodeSet.forEach(e -> executeRules.add(e));
                            zeroNodeSet.forEach(arg_0 -> ((MutableGraph)transpose).removeNode(arg_0));
                        }
                        log.info(LOG_PREFIX + exeRule.getNumber() + "\u62c6\u5206\u51fa\u591a\u6761\u89c4\u5219\uff1a" + executeRules.size() + ",:" + traceRuleIds);
                    }
                    HashMap<Long, Set> executedBpMap = new HashMap<Long, Set>(24);
                    for (RuleNodeBo executeRule : executeRules) {
                        List ruleBos = ctx.getAllEnableRule().stream().filter(e -> ruleIds.contains(e.getId())).collect(Collectors.toList());
                        List executeRuleDtos = ruleBos.stream().map(RuleBo::getRuleDto).collect(Collectors.toList());
                        if (executeRuleDtos.stream().anyMatch(e -> !e.getOffsetMap().isEmpty())) {
                            ((Set)sub.get(SysDimensionEnum.BudgetPeriod.getNumber())).removeIf(e -> e.endsWith("._inv"));
                            if (((Set)sub.get(SysDimensionEnum.BudgetPeriod.getNumber())).isEmpty()) {
                                log.info(LOG_PREFIX + exeRule.getNumber() + "\u5206\u9875\u671f\u95f4\u8303\u56f4\u4e3a\u7a7a");
                                continue;
                            }
                        }
                        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.BizRule));
                        AlgoCalcRequest calcRequest = executeRule.getCalcRequest();
                        Map memberInfo = calcRequest.getMemberInfo();
                        Set bpSet = (Set)memberInfo.get(SysDimensionEnum.BudgetPeriod.getNumber());
                        Set executedBpSet = executedBpMap.computeIfAbsent(executeRule.getRuleDto().getId(), v -> new HashSet(24));
                        memberInfo.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpSet.stream().filter(e -> !executedBpSet.contains(e)).collect(Collectors.toSet()));
                        calcRequest.setOptions(ctx.getOptions());
                        cells.addAll(OlapCommService.getInstance().calcAndSave(calcRequest));
                        executedBpSet.addAll((Collection)memberInfo.get(SysDimensionEnum.BudgetPeriod.getNumber()));
                    }
                    successCnt += cells.size();
                    if (CollectionUtils.isNotEmpty((Collection)cells) && resultExample.size() < 5) {
                        resultExample.addAll(cells.stream().limit(5 - resultExample.size()).collect(Collectors.toList()));
                    }
                    List delCells = cells.stream().filter(e -> e.getValue() == null).collect(Collectors.toList());
                    delCnt += delCells.size();
                    if (CollectionUtils.isNotEmpty(delCells) && delExample.size() < 5) {
                        delExample.addAll(delCells.stream().limit(5 - delExample.size()).collect(Collectors.toList()));
                    }
                    this.toSuccessor(cells, ruleIds, allEnableRuleMap, ctx);
                    this.recordResultData(cells, zNode, ctx);
                    cells.clear();
                }
                log.info(LOG_PREFIX + exeRule.getNumber() + ",\u6267\u884c\u6b21\u6570:" + exeCnt + ",\u8017\u65f6:" + sw.elapsed(TimeUnit.MILLISECONDS));
                this.markPredecessorsStatus(zNode, ctx);
                log.info("ruleExecution_\u6267\u884c\u89c4\u5219\uff1a" + exeRule.getNumber() + ",\u5b9e\u9645\u53d8\u52a8cell_size\uff1a" + successCnt + ", \u5220\u9664\u7684size:" + delCnt + ",\u8017\u65f6:" + sw.elapsed(TimeUnit.MILLISECONDS));
                String example = JSON.toJSONString(resultExample);
                log.info("ruleExecution_\u6267\u884c\u89c4\u5219\uff1a" + exeRule.getNumber() + ",\u7ed3\u679c\u91c7\u6837:" + example + ",\u5220\u9664\u91c7\u6837\uff1a" + JSON.toJSONString(delExample));
                logDetail.setAffectrow(successCnt);
                String oldExample = logDetail.getResultexample() + ";";
                logDetail.setResultexample(oldExample + example);
                exeGraph.removeNode((Object)zNode);
            }
            catch (Exception e2) {
                log.warn("ruleExecution_\u6267\u884c\u89c4\u5219\u6267\u884c\u5931\u8d25\uff1a" + exeRule.getNumber(), (Throwable)e2);
                ctx.getExecErrorRules().add(zNode.getNodeNumber());
                ctx.getErrMsgs().add(ThrowableHelper.printError((Throwable)e2));
                exeGraph.removeNode((Object)zNode);
                logDetail.setExecutelog(ThrowableHelper.printError((Throwable)e2));
            }
        }
        this.updateLogDetailPushStatus(logDetList, ctx);
        String traceId = RequestContext.getOrCreate().getTraceId();
        EpmThreadPools.RULE_EXECUTION_POOL.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            RuleExecutionService.getInstance().insertOrUpdateLogDetail(logDetList, ctx);
        });
        GraphNode zeroNode = RuleGraphService.getInstance().getZeroNodes((Graph<GraphNode>)ctx.getTotalExeGraph()).iterator().next();
        if (ctx.getTotalExeGraph().nodes().size() == originExeGraph.nodes().size() || !originExeGraph.nodes().contains(zeroNode)) {
            if (ctx.getExecErrorRules().isEmpty()) {
                ctx.getLogMain().set("executestatus", (Object)RuleExecuteLogStatusEnum.SUCCESS.getCode());
            } else {
                ctx.getLogMain().set("executestatus", (Object)RuleExecuteLogStatusEnum.FAIL.getCode());
                ctx.getLogMain().set("rawcelldata", (Object)JSON.toJSONString(ctx.getRawCells()));
                try {
                    String title = ResManager.loadKDString((String)"\u89c4\u5219\u4f9d\u8d56\u8ba1\u7b97\u51fa\u9519\u901a\u77e5\u3002", (String)"RuleExecutionService_4", (String)"epm-eb-business", (Object[])new Object[0]);
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber", (QFilter[])new QFilter("id", "=", (Object)ctx.getModelId()).toArray());
                    String shownumber = "";
                    if (dynamicObject != null) {
                        shownumber = dynamicObject.getString("shownumber");
                    }
                    String messageDate = ResManager.loadResFormat((String)"\u4f53\u7cfb\uff1a%1\uff0c\u89c4\u5219\u4f9d\u8d56\u8ba1\u7b97\u51fa\u9519\uff0c\u8bf7\u5347\u7ea7\u89c4\u5219\u4f9d\u8d56\u540e\u91cd\u65b0\u7f16\u6570\u6216\u624b\u5de5\u6267\u884c\u89c4\u5219\u3002", (String)"RuleExecutionService_5", (String)"epm-eb-business", (Object[])new Object[]{shownumber});
                    this.sendMessage(ctx, title, messageDate);
                }
                catch (Exception e3) {
                    log.error("\u89c4\u5219\u4f9d\u8d56\u8ba1\u7b97\u51fa\u9519\u901a\u77e5\u5f02\u5e38", (Throwable)e3);
                }
            }
            ctx.getLogMain().set("lasttime", (Object)new Date());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{ctx.getLogMain()});
        }
        log.info("ruleExecution_\u4f9d\u8d56\u89c4\u5219\u6267\u884c\u5b8c\u6210,\u8017\u65f6:" + swTotal.elapsed(TimeUnit.MILLISECONDS));
    }

    private void excludeCtControlMember(RuleBo exeRule) {
        Map ruleExecutionScope = exeRule.getRuleExecutionScope();
        for (Map.Entry scope : ruleExecutionScope.entrySet()) {
            String dimNumber = (String)scope.getKey();
            if (!SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) continue;
            Set memberSet = (Set)scope.getValue();
            RuleFunctionUtils.removeCtControlMem((String)dimNumber, (Set)memberSet);
        }
    }

    private Set<Long> getModelAdminUserId(Long modelId) {
        Map<Long, List<Long>> modelManagers = PermUpgradesUtil.getInstance().getModelManagers(Collections.singletonList(modelId));
        HashSet<Long> ids = new HashSet<Long>(16);
        modelManagers.forEach((mId, users) -> ids.addAll((Collection<Long>)users));
        return ids;
    }

    public void sendMessage(RuleExecutionContext ctx, String title, String msg) {
        this.sendMessage(ctx.getModelId(), ctx.getErrMsgs(), title, msg);
    }

    public void sendMessage(long modelId, List<String> errMsgs, String title, String msg) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"eb_rule_error_log");
        record.set("traceid", (Object)RequestContext.get().getTraceId());
        record.set("model", (Object)modelId);
        record.set("info", (Object)String.join((CharSequence)"|", errMsgs));
        record.set("user", (Object)UserUtils.getUserId());
        record.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        String traceId = RequestContext.getOrCreate().getTraceId();
        EpmThreadPools.CommPools.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            this.delErrorLog();
        });
        HashSet parseId = new HashSet(16);
        MessageInfo message = new MessageInfo();
        message.setTitle(title);
        message.setContent(msg);
        JSONObject paramMap = ParamQueryServiceHelper.getJSON((long)modelId, (ParamEnum)ParamEnum.BG021);
        ArrayList<Long> receivers = new ArrayList<Long>(parseId.size());
        if (Objects.nonNull(paramMap) && Objects.nonNull(paramMap.get((Object)"userid"))) {
            receivers.add(paramMap.getLong("userid"));
        }
        if (receivers.isEmpty()) {
            Set<Long> modelAdminUserId = this.getModelAdminUserId(modelId);
            receivers.add(UserUtils.getUserId());
            receivers.addAll(modelAdminUserId);
        }
        message.setUserIds(receivers);
        message.setSenderId(UserUtils.getUserId());
        message.setType("warning");
        message.setEntityNumber("eb_taskmessageremin");
        boolean smsSwitch = true;
        if (Objects.nonNull(paramMap) && paramMap.get((Object)"smsswitch") != null) {
            smsSwitch = paramMap.getBoolean("smsswitch");
        }
        if (smsSwitch) {
            message.setNotifyType("sms");
        }
        message.setPubaccNumber("systempubacc");
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    private List<Map<String, Set<String>>> optimizeByEntity(IModelCacheHelper modelCache, Long dataSetId, Map<String, Set<String>> queryMemberMap, RuleBo ruleBo) {
        log.info(LOG_PREFIX + ruleBo.getNumber() + "\u8fdb\u5165\u6267\u884c\u8303\u56f4\u4f18\u5316\u903b\u8f91");
        if (MapUtils.isEmpty((Map)ruleBo.getRightPageMembers())) {
            return Collections.emptyList();
        }
        String formulaString = ruleBo.getFormulaString();
        Parse2RPN parse2RPN = new Parse2RPN(formulaString);
        parse2RPN.parse();
        BinaryExpr expr = (BinaryExpr)parse2RPN.getExpr();
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(dataSetId);
        String[] dimensionNums = modelCache.getDimensionNums(dataSetId);
        String partDimension = "Entity";
        Set<String> entitySet = queryMemberMap.get(partDimension);
        RuleDto ruleDto = ruleBo.getRuleDto();
        Long mainDimensionId = ruleDto.getMainDimensionId();
        Dimension dimension = modelCache.getDimension(mainDimensionId);
        int maxSize = 0;
        if (entitySet.size() > 200 || dimension != null && dimension.getNumber().equals(partDimension)) {
            log.info(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u91cf\u8d85\u8fc7200\u4e2a\uff0c\u8bf7\u4ee5\u53e6\u4e00\u4e2a\u7ef4\u5ea6\u4f5c\u4e3a\u57fa\u51c6\u3002", (String)"ExecuteRuleServiceImpl_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (Map.Entry<String, Set<String>> entry : queryMemberMap.entrySet()) {
                String dimNumber = entry.getKey();
                int size = entry.getValue().size();
                if (size > 200 || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || dimension != null && dimension.getNumber().equals(dimNumber) || size <= maxSize) continue;
                maxSize = size;
                partDimension = dimNumber;
                entitySet = entry.getValue();
            }
        }
        Evaluator evaluator = new Evaluator(partDimension, ruleDto, modelCache, dimensionNums, dataSet);
        ArrayList returnCollection = Lists.newArrayListWithExpectedSize((int)entitySet.size());
        for (String entity : entitySet) {
            evaluator.clearCollect();
            HashMap partEntityMap = Maps.newHashMap(queryMemberMap);
            partEntityMap.put(partDimension, Sets.newHashSet((Object[])new String[]{entity}));
            Map hasTrimMap = expr.getRight().analyzeRange((Map)partEntityMap, evaluator);
            if (hasTrimMap == null) {
                returnCollection.add(partEntityMap);
                continue;
            }
            if (hasTrimMap.isEmpty() || hasTrimMap.size() == 1 && "ignore".equals(hasTrimMap.entrySet().iterator().next().getKey())) continue;
            Set ctMembers = (Set)hasTrimMap.get(SysDimensionEnum.ChangeType.getNumber());
            RuleFunctionUtils.removeCtControlMem((String)SysDimensionEnum.ChangeType.getNumber(), (Set)ctMembers);
            returnCollection.add(hasTrimMap);
        }
        return returnCollection;
    }

    private void toSuccessor(List<BGCell> cells, Set<Long> ruleIds, Map<Long, RuleBo> allEnableRuleMap, RuleExecutionContext ctx) {
        if (CollectionUtils.isNotEmpty(cells)) {
            for (Long ruleId : ruleIds) {
                Set successors = ctx.getTotalGraph().successors((Object)new GraphNode(ruleId));
                if (CollectionUtils.isEmpty((Collection)successors)) continue;
                for (GraphNode successor : successors) {
                    RuleBo successorNode = allEnableRuleMap.get(successor.getNodeId());
                    this.bindCellToRightItem(cells, successorNode, ctx.getModelCache());
                }
            }
        }
    }

    private void recordResultData(List<BGCell> cells, GraphNode curNode, RuleExecutionContext ctx) {
        boolean hasSuccessor = ctx.getTotalExeGraph().successors((Object)curNode).isEmpty();
        if (CollectionUtils.isNotEmpty(cells) || hasSuccessor) {
            Long ruleId = curNode.getNodeId();
            RuleExecutionContext.RuleDetailInfo ruleDetailInfo = ctx.getRuleStashMap().computeIfAbsent(ruleId, v -> new RuleExecutionContext.RuleDetailInfo(ruleId));
            Map<String, Set<String>> resultDataMap = ruleDetailInfo.getResultDataMap();
            for (BGCell cell : cells) {
                cell.getMemberMap().forEach((dim, mem) -> resultDataMap.computeIfAbsent((String)dim, v -> Sets.newHashSet()).add(mem));
            }
        }
    }

    private void markPredecessorsStatus(GraphNode curNode, RuleExecutionContext ctx) {
        RuleExecutionContext.RuleDetailInfo ruleStashInfo;
        Long curRuleId = curNode.getNodeId();
        MutableGraph<GraphNode> totalExeGraph = ctx.getTotalExeGraph();
        Set<Long> executedRules = ctx.getExecutedRules();
        Set predecessors = totalExeGraph.predecessors((Object)new GraphNode(curRuleId));
        for (GraphNode predecessor : predecessors) {
            RuleExecutionContext.RuleDetailInfo ruleStashInfo2;
            Set successors = totalExeGraph.successors((Object)predecessor);
            Set suRuleSet = successors.stream().map(GraphNode::getNodeId).collect(Collectors.toSet());
            Set inSet = executedRules.stream().filter(suRuleSet::contains).collect(Collectors.toSet());
            if (inSet.size() != suRuleSet.size() || (ruleStashInfo2 = ctx.getRuleStashMap().get(predecessor.getNodeId())) == null) continue;
            ruleStashInfo2.setSuccessorDone(true);
            ruleStashInfo2.getResultDataMap().clear();
        }
        Set successors = totalExeGraph.successors((Object)new GraphNode(curRuleId));
        if (successors.isEmpty() && (ruleStashInfo = ctx.getRuleStashMap().get(curRuleId)) != null) {
            ruleStashInfo.setSuccessorDone(true);
            ruleStashInfo.getResultDataMap().clear();
        }
    }

    private void updateLogDetailPushStatus(List<RuleExecLogDetail> logDetList, RuleExecutionContext ctx) {
        ConcurrentHashMap<Long, RuleExecutionContext.RuleDetailInfo> ruleStashMap = ctx.getRuleStashMap();
        for (RuleExecLogDetail detail : logDetList) {
            RuleExecutionContext.RuleDetailInfo ruleStashInfo = ruleStashMap.get(detail.getRuleId());
            if (ruleStashInfo != null && !ruleStashInfo.isSuccessorDone()) {
                detail.setPushstatus(RulePushStatusEnum.FAIL.getCode());
                detail.setDatascope(JSON.toJSONString(ruleStashInfo.getResultDataMap()));
                continue;
            }
            detail.setPushstatus(RulePushStatusEnum.SUCCESS.getCode());
        }
    }

    private void excludeVirtualMember(RuleBo exeRule, RuleExecutionContext ctx) {
        Map ruleExecutionScope = exeRule.getRuleExecutionScope();
        for (Map.Entry entry : ruleExecutionScope.entrySet()) {
            String dimNumber = (String)entry.getKey();
            Set memberSet = (Set)entry.getValue();
            Dimension dimension = ctx.getModelCache().getDimension(dimNumber);
            Set virtualSet = dimension.getViewMember().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            memberSet = memberSet.stream().filter(e -> !virtualSet.contains(e)).collect(Collectors.toSet());
            entry.setValue(memberSet);
        }
    }

    public void unionOffsetLeft(Set<Long> offsetRuleIds, Map<String, Set<String>> executeScope, RuleBo exeRule, Map<Long, RuleBo> allRuleMap, IModelCacheHelper modelCache) {
        Set<Long> zeroNodes;
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        for (Long offsetRuleId : offsetRuleIds) {
            if (graph.nodes().contains(offsetRuleId)) continue;
            graph.addNode((Object)offsetRuleId);
        }
        for (Long offsetRuleId : offsetRuleIds) {
            String[] offSuccessors;
            RuleBo rule = allRuleMap.get(offsetRuleId);
            for (String offSuccessor : offSuccessors = org.apache.commons.lang3.StringUtils.split((String)rule.getOffSuccessors(), (String)",")) {
                long nodeId = Long.parseLong(offSuccessor);
                if (!graph.nodes().contains(nodeId) || offsetRuleId.equals(nodeId)) continue;
                graph.putEdge((Object)offsetRuleId, (Object)nodeId);
            }
        }
        HashMap nodeScopeMap = Maps.newHashMap();
        while (!graph.nodes().isEmpty() && !(zeroNodes = graph.nodes().stream().filter(node -> graph.inDegree(node) == 0).collect(Collectors.toSet())).isEmpty()) {
            for (Long zeroNode : zeroNodes) {
                RuleBo nodeRule = allRuleMap.get(zeroNode);
                if (!exeRule.getDataSetId().equals(nodeRule.getDataSetId())) {
                    log.info("\u6570\u636e\u96c6\u4e0d\u4e00\u6837\uff0c\u76f4\u63a5\u8df3\u8fc7\uff0c\u4e14\u540e\u7ee7\u7684\u4e5f\u8df3\u8fc7");
                    Set zeroReachNodes = Graphs.reachableNodes((Graph)graph, (Object)zeroNode);
                    zeroReachNodes.forEach(arg_0 -> ((MutableGraph)graph).removeNode(arg_0));
                    continue;
                }
                Map<String, Set<String>> dataScope = (Map<String, Set<String>>)nodeScopeMap.get(zeroNode);
                if (dataScope == null || dataScope.isEmpty()) {
                    dataScope = executeScope;
                }
                Map<String, Set<String>> nodeScope = this.calcLeftScope(dataScope, nodeRule, modelCache);
                Set successors = graph.successors((Object)zeroNode);
                successors.forEach(nextNode -> {
                    Map nextScope = nodeScopeMap.computeIfAbsent(nextNode, v -> Maps.newHashMap());
                    this.unionRuleExecutionScope(nodeScope, nextScope);
                });
                this.unionRuleExecutionScope(nodeScope, executeScope);
            }
            zeroNodes.forEach(arg_0 -> ((MutableGraph)graph).removeNode(arg_0));
        }
        Set<Object> periodMembers = new HashSet();
        for (Long offsetRuleId : offsetRuleIds) {
            RuleBo ruleBo = allRuleMap.get(offsetRuleId);
            Map leftMembers = ruleBo.getLeftMembers();
            Set strings = (Set)leftMembers.get(SysDimensionEnum.BudgetPeriod.getNumber());
            if (strings == null) {
                periodMembers = modelCache.getMembers(null, SysDimensionEnum.BudgetPeriod.getNumber()).stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
                break;
            }
            periodMembers.addAll(strings);
        }
        executeScope.get(SysDimensionEnum.BudgetPeriod.getNumber()).addAll(periodMembers);
    }

    private Map<String, Set<String>> filterLeafScope(Map<String, Set<String>> ruleScope, Long dataSetId, RuleExecutionContext ctx) {
        HashMap<String, Set<String>> leafScope = new HashMap<String, Set<String>>(16);
        IModelCacheHelper modelCache = ctx.getModelCache();
        Map groupViewsMap = modelCache.getViewGroupViewsByDataSet(dataSetId);
        for (Map.Entry<String, Set<String>> entry : ruleScope.entrySet()) {
            Member member;
            String dimNumber = entry.getKey();
            Set<String> members = entry.getValue();
            HashSet<String> leafMembers = new HashSet<String>(members.size());
            List viewIds = (List)groupViewsMap.get(dimNumber);
            if (CollectionUtils.isNotEmpty((Collection)viewIds)) {
                for (String memberNumber : members) {
                    Long viewId;
                    member = null;
                    Iterator iterator = viewIds.iterator();
                    while (iterator.hasNext() && (member = modelCache.getMember(dimNumber, viewId = (Long)iterator.next(), memberNumber)) == null) {
                    }
                    if (member == null || !member.isLeaf()) continue;
                    leafMembers.add(memberNumber);
                }
            } else {
                for (String memberNumber : members) {
                    member = modelCache.getMember(dimNumber, Long.valueOf(0L), memberNumber);
                    if (member == null || !member.isLeaf()) continue;
                    leafMembers.add(memberNumber);
                }
            }
            if (leafMembers.isEmpty()) continue;
            leafScope.put(dimNumber, leafMembers);
        }
        return leafScope;
    }

    public Set<Long> getOffsetRuleId(RuleBo exeRule, MutableGraph<GraphNode> exeGraph, MutableGraph<GraphNode> originExeGraph, RuleExecutionContext ctx) {
        HashSet ruleIds = Sets.newHashSet((Object[])new Long[]{exeRule.getId()});
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)exeRule.getOffSuccessors())) {
            HashSet<GraphNode> newNodes = new HashSet<GraphNode>(16);
            for (String offset : org.apache.commons.lang3.StringUtils.split((String)exeRule.getOffSuccessors(), (String)",")) {
                GraphNode offNode = new GraphNode(Long.parseLong(offset));
                newNodes.add(offNode);
            }
            newNodes.add(new GraphNode(exeRule.getId()));
            MutableGraph subgraph = Graphs.inducedSubgraph(ctx.getTotalGraph(), newNodes);
            ruleIds.addAll(subgraph.nodes().stream().map(GraphNode::getNodeId).collect(Collectors.toSet()));
        }
        ctx.getTotalGraphOffMap().forEach((ruleId, offSet) -> {
            if (offSet.contains(exeRule.getId())) {
                ruleIds.add(ruleId);
            }
        });
        return ruleIds;
    }

    private void bindCellToRightItem(List<BGCell> cells, List<RuleBo> allEnableRule, IModelCacheHelper modelCache) {
        if (CollectionUtils.isEmpty(cells) || CollectionUtils.isEmpty(allEnableRule)) {
            return;
        }
        List pageList = Lists.partition(allEnableRule, (int)3);
        for (List sub : pageList) {
            CountDownLatch latch = new CountDownLatch(sub.size());
            for (RuleBo rule : sub) {
                EpmThreadPools.RULE_HANDLE_POOL.execute(() -> {
                    try {
                        this.bindCellToRightItem(cells, rule, modelCache);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u591a\u7ebf\u7a0b\u5904\u7406\u540e\u7ee7\u51fa\u9519\u3002", (String)"RuleGraphService_41", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
    }

    private void bindCellToRightItem(List<BGCell> cells, RuleBo ruleBo, IModelCacheHelper modelCache) {
        Map leftMembers = ruleBo.getLeftMembers();
        Map rightMembers = ruleBo.getRightMembers();
        List ruleRightItemDtoList = ruleBo.getRuleRightItemDto();
        Map<String, RuleRightItemDto> collect = ruleRightItemDtoList.stream().collect(Collectors.toMap(RuleRightItemDto::getMemberKey, v -> v));
        String ruleMet = (String)((Set)leftMembers.get(SysDimensionEnum.Metric.getNumber())).iterator().next();
        Member ruleMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, ruleMet);
        Map ruleLeftMap = (Map)RuleExecutionCacheService.getInstance().listRuleScopeFromLocalCache(ruleBo.getBizCtrlRangeId()).getRuleExecutionLeftMap().get(ruleBo.getId());
        for (Map.Entry rightEntry : rightMembers.entrySet()) {
            Map rightItemMap;
            String rightMemberKey = (String)rightEntry.getKey();
            RuleRightItemDto ruleRightItemDto = collect.get(rightMemberKey);
            List skipDimList = ruleRightItemDto.getSkipDimList();
            Map rightMemberScope = (Map)rightEntry.getValue();
            Set rMetSet = (Set)rightMemberScope.get(SysDimensionEnum.Metric.getNumber());
            String rMet = ruleMet;
            if (rMetSet != null && !rMetSet.isEmpty()) {
                rMet = (String)rMetSet.iterator().next();
            }
            HashMap newRightMemberScope = Maps.newHashMapWithExpectedSize((int)rightMemberScope.size());
            newRightMemberScope.putAll(rightMemberScope);
            Member rMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, rMet);
            if (!ruleMetMember.hasAgg() && rMetMember.hasAgg()) {
                leftMembers.forEach((k, v) -> {
                    if (!rightMemberScope.containsKey(k)) {
                        newRightMemberScope.put(k, ruleLeftMap.get(k));
                    }
                });
            }
            Integer offset = (Integer)ruleBo.getOffsetMap().get(rightMemberKey);
            for (BGCell cell : cells) {
                boolean hasFormulaRelate = this.hasFormulaRelate(leftMembers, newRightMemberScope, skipDimList, cell, offset, modelCache);
                if (!hasFormulaRelate) continue;
                Map rightDataScope = ruleBo.getRightDataScope().computeIfAbsent(rightMemberKey, v -> Maps.newHashMap());
                cell.getMemberMap().forEach((dim, mem) -> rightDataScope.computeIfAbsent(dim, v -> Sets.newHashSet()).add(mem));
            }
            if (ruleMetMember.hasAgg() || !rMetMember.hasAgg() || !MapUtils.isNotEmpty((Map)(rightItemMap = (Map)ruleBo.getRightDataScope().get(rightMemberKey)))) continue;
            for (Map.Entry entry : rightItemMap.entrySet()) {
                Set memSet = (Set)entry.getValue();
                String dimNumber = (String)entry.getKey();
                Long viewId = (Long)ruleBo.getRuleDto().getViewMap().get(dimNumber);
                HashSet newSet = Sets.newHashSetWithExpectedSize((int)memSet.size());
                for (String mem2 : memSet) {
                    Member member = modelCache.getMember(dimNumber, viewId, mem2);
                    Set parentSet = modelCache.getParents(viewId, member, true).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    newSet.addAll(parentSet);
                }
                memSet.clear();
                memSet.addAll(newSet);
            }
        }
    }

    private Map<String, Set<String>> calcLeftScope(Map<String, Set<String>> exeScope, RuleBo ruleBo, IModelCacheHelper modelCache) {
        List ruleRightItemDto = ruleBo.getRuleRightItemDto();
        HashMap leftScope = Maps.newHashMap();
        for (RuleRightItemDto rightItemDto : ruleRightItemDto) {
            Map<String, Set<String>> rightEntryScope = this.getRightEntryScope(rightItemDto, ruleBo, exeScope, modelCache);
            this.unionRuleExecutionScope(rightEntryScope, leftScope);
        }
        if (!leftScope.isEmpty() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ruleBo.getOffSuccessors())) {
            Set<Object> templateBpMembers;
            Map leftMembers = ruleBo.getLeftMembers();
            if (leftMembers.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
                templateBpMembers = new HashSet((Collection)leftMembers.get(SysDimensionEnum.BudgetPeriod.getNumber()));
                log.info("ruleExecution_\u6709\u671f\u95f4\u504f\u79fb\u53d6\u516c\u5f0f\u7684\u671f\u95f4\u8303\u56f4:" + JSON.toJSONString(templateBpMembers));
            } else {
                templateBpMembers = modelCache.getMembers(null, SysDimensionEnum.BudgetPeriod.getNumber()).stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
                log.info("ruleExecution_\u53d6\u6240\u6709\u671f\u95f4\u8303\u56f4:" + JSON.toJSONString(templateBpMembers));
            }
            leftScope.put(SysDimensionEnum.BudgetPeriod.getNumber(), templateBpMembers);
        }
        return leftScope;
    }

    private boolean hasFormulaRelate(Map<String, Set<String>> leftScope, Map<String, Set<String>> rightScope, List<String> skipDimList, BGCell cell, Integer offset, IModelCacheHelper modelCache) {
        for (Map.Entry entry : cell.getMemberMap().entrySet()) {
            Member offsetMember;
            String dimNumber = (String)entry.getKey();
            String memberNumber = (String)entry.getValue();
            if (skipDimList != null && skipDimList.contains(dimNumber)) continue;
            Set<String> formulaMembers = rightScope.get(dimNumber);
            if (CollectionUtils.isEmpty(formulaMembers)) {
                formulaMembers = leftScope.get(dimNumber);
            }
            if (CollectionUtils.isEmpty(formulaMembers)) continue;
            String realMemberNumber = memberNumber;
            if (offset != null && offset != 0 && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && (offsetMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), memberNumber, -offset.intValue())) != null) {
                realMemberNumber = offsetMember.getNumber();
            }
            if (formulaMembers.contains(realMemberNumber)) continue;
            return false;
        }
        return true;
    }

    private DynamicObject addNewLog(RuleExecutionRequest request, MutableGraph<GraphNode> exeGraph, MutableGraph<GraphNode> syncGraph, MutableGraph<GraphNode> asyncGraph, Map<Long, Set<String>> mapTemplateByRule, IModelCacheHelper modelCache, String sample, Map<String, Long> viewMap) {
        DynamicObject dymLog = BusinessDataServiceHelper.newDynamicObject((String)"eb_rule_instance");
        dymLog.set("model", (Object)request.getModelId());
        dymLog.set("exetype", (Object)(StringUtils.isNotEmpty((String)request.getExeType()) ? request.getExeType() : "1"));
        RuleTemplateInfo ruleTemplateInfo = request.getRuleTemplateInfo();
        if (ruleTemplateInfo != null) {
            Member orgMember;
            Set entities;
            Member orgMember2;
            Long currentEntityId;
            if (viewMap == null) {
                viewMap = modelCache.getViewsByDataSet(request.getDatasetId());
            }
            dymLog.set("template", (Object)ruleTemplateInfo.getTemplateId());
            if (ruleTemplateInfo.getTemplateScope() != null) {
                dymLog.set("templatescope", (Object)JSON.toJSONString((Object)ruleTemplateInfo.getTemplateScope()));
            }
            if ((currentEntityId = ruleTemplateInfo.getCurrentEntityId()) != null && (orgMember2 = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewMap.get(SysDimensionEnum.Entity.getNumber()), currentEntityId)) != null) {
                dymLog.set("curentorg", (Object)(orgMember2.getNumber() + "-" + orgMember2.getName()));
            }
            if (CollectionUtils.isNotEmpty((Collection)(entities = (Set)ruleTemplateInfo.getTemplateScope().get(SysDimensionEnum.Entity.getNumber()))) && (orgMember = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewMap.get(SysDimensionEnum.Entity.getNumber()), (String)entities.iterator().next())) != null) {
                dymLog.set("submitorg", (Object)(orgMember.getNumber() + "-" + orgMember.getName()));
            }
        }
        dymLog.set("bizmodel", (Object)request.getDatasetId());
        dymLog.set("sample", (Object)sample);
        dymLog.set("creator", (Object)UserUtils.getUserId());
        dymLog.set("createtime", (Object)new Date());
        dymLog.set("exegraph", (Object)exeGraph.toString());
        dymLog.set("rulecount", (Object)exeGraph.nodes().size());
        dymLog.set("synccount", (Object)syncGraph.nodes().size());
        dymLog.set("syncrule", (Object)syncGraph.nodes().toString());
        dymLog.set("asynccount", (Object)asyncGraph.nodes().size());
        dymLog.set("asyncrule", (Object)asyncGraph.nodes().toString());
        dymLog.set("executestatus", (Object)RuleExecuteLogStatusEnum.EXECUTING.getCode());
        dymLog.set("traceid", (Object)RequestContext.get().getTraceId());
        String reltemplate = mapTemplateByRule.values().stream().flatMap(Collection::stream).collect(Collectors.joining(","));
        dymLog.set("reltemplate", (Object)reltemplate);
        String traceId = RequestContext.getOrCreate().getTraceId();
        EpmThreadPools.CommPools.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            this.delLog();
        });
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getRetrySrcTraceid())) {
            dymLog.set("retrysrctraceid", (Object)request.getRetrySrcTraceid());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dymLog});
        return dymLog;
    }

    private void delLog() {
        if (delPos % 200 == 0) {
            LocalDateTime preDays = LocalDateTime.now().minusDays(15L);
            Date delDate = Date.from(preDays.atZone(ZoneId.systemDefault()).toInstant());
            String sqlMain = "delete from t_eb_rule_instance where fcreatetime < ?";
            String sqldetail = "delete from t_eb_rule_instance_detail where fcreatetime < ?";
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sqlMain, (Object[])new Object[]{delDate});
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sqldetail, (Object[])new Object[]{delDate});
            delPos = 0;
        }
        ++delPos;
    }

    private void delErrorLog() {
        if (delErrorLog % 100 == 0) {
            LocalDateTime preDays = LocalDateTime.now().minusDays(30L);
            Date delDate = Date.from(preDays.atZone(ZoneId.systemDefault()).toInstant());
            String sqlMain = "delete from t_eb_rule_error_log where fcreatetime < ?";
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sqlMain, (Object[])new Object[]{delDate});
            delErrorLog = 0;
        }
        ++delErrorLog;
    }

    public RuleExecLogDetail getNewLogDetail(RuleBo exeRule, Boolean isSyn, Set<GraphNode> predecessors, Set<GraphNode> successors, RuleExecutionContext ctx) {
        Long ruleId = exeRule.getId();
        RuleExecLogDetail detail = new RuleExecLogDetail();
        detail.setLogId(ctx.getLogMain().getLong("id"));
        detail.setRuleId(ruleId);
        detail.setPredecessors(predecessors.stream().map(GraphNode::getNodeNumber).collect(Collectors.joining(",")));
        detail.setSuccessors(successors.stream().map(GraphNode::getNodeNumber).collect(Collectors.joining(",")));
        detail.setCreatetime(new Date());
        if (ctx.getMapTemplateByRule().containsKey(ruleId)) {
            Set<String> templates = ctx.getMapTemplateByRule().get(ruleId);
            detail.setReltemplate(String.join((CharSequence)",", templates));
        }
        if (isSyn.booleanValue()) {
            detail.setIssyn("1");
        } else {
            detail.setIssyn("2");
        }
        return detail;
    }

    private Map<Long, Set<String>> mapTemplateByRule(long modelId, MutableGraph<GraphNode> exeGraph) {
        Set ruleIds = exeGraph.nodes().stream().map(GraphNode::getNodeId).collect(Collectors.toSet());
        SqlBuilder sql = new SqlBuilder();
        sql.append("select d.fbizrule as ruleid, t.fnumber as templatenumber from t_eb_leafbizruletempdis d", new Object[0]).append(" inner join t_eb_template t on t.fid=d.ftemplate", new Object[0]).append(" where", new Object[0]).append(" t.fmodelid = ? ", new Object[]{modelId}).append(" and", new Object[0]).appendIn("d.fbizrule", ruleIds.toArray());
        HashMap templateMap = Maps.newHashMap();
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : ds) {
                Set tempSet = templateMap.computeIfAbsent(row.getLong("ruleid"), v -> Sets.newHashSet());
                tempSet.add(row.getString("templatenumber"));
            }
        }
        return templateMap;
    }

    public void insertOrUpdateLogDetail(List<RuleExecLogDetail> logDetList, RuleExecutionContext ctx) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (RuleExecLogDetail det : logDetList) {
            DynamicObject logDetail = BusinessDataServiceHelper.newDynamicObject((String)"eb_rule_instance_detail");
            logDetail.set("logid", (Object)det.getLogId());
            logDetail.set("rule", (Object)det.getRuleId());
            logDetail.set("predecessors", (Object)det.getPredecessors());
            logDetail.set("successors", (Object)det.getSuccessors());
            logDetail.set("createtime", (Object)det.getCreatetime());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)det.getReltemplate())) {
                logDetail.set("reltemplate", (Object)det.getReltemplate());
            }
            logDetail.set("issyn", (Object)det.getIssyn());
            logDetail.set("sequence", (Object)det.getSequence());
            logDetail.set("executelog", (Object)det.getExecutelog());
            logDetail.set("exescope", (Object)det.getExescope());
            logDetail.set("sum", (Object)det.getSum());
            logDetail.set("affectrow", (Object)det.getAffectrow());
            logDetail.set("resultexample", (Object)det.getResultexample());
            logDetail.set("pushstatus", (Object)det.getPushstatus());
            logDetail.set("datascope", (Object)det.getDatascope());
            list.add(logDetail);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
        Set<Long> executedRules = ctx.getExecutedRules();
        Map<Long, String> ruleMap = ctx.getTotalExeGraph().nodes().stream().collect(Collectors.toMap(GraphNode::getNodeId, GraphNode::getNodeNumber));
        HashSet errPreSet = Sets.newHashSet();
        executedRules.forEach(executedRuleId -> {
            Set predecessors;
            String executedRuleNumber = (String)ruleMap.get(executedRuleId);
            if (ctx.getExecErrorRules().contains(executedRuleNumber) && !(predecessors = ctx.getTotalExeGraph().predecessors((Object)new GraphNode((Long)executedRuleId))).isEmpty()) {
                errPreSet.addAll(predecessors.stream().map(GraphNode::getNodeId).collect(Collectors.toSet()));
            }
        });
        long mainLogId = ctx.getLogMain().getLong("id");
        ArrayList updateParameters = Lists.newArrayList();
        for (Long executedRuleId2 : executedRules) {
            RuleExecutionContext.RuleDetailInfo ruleStashInfo = ctx.getRuleStashMap().get(executedRuleId2);
            if (ruleStashInfo != null && (!ruleStashInfo.isSuccessorDone() || errPreSet.contains(executedRuleId2))) continue;
            Object[] obj = new Object[]{RulePushStatusEnum.SUCCESS.getCode(), executedRuleId2, mainLogId};
            updateParameters.add(obj);
        }
        if (!updateParameters.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_rule_instance_detail set fpushstatus = ? where frule = ? and flogid=?", (List)updateParameters);
        }
    }

    private static class InnerClass {
        private static RuleExecutionService instance = new RuleExecutionService();

        private InnerClass() {
        }
    }
}

