/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizrule;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.lang3.BooleanUtils;

public class RuleFindService {
    private RuleFindService() {
    }

    public static RuleFindService getInstance() {
        return SingleTon.INSTANCE.instance;
    }

    @Deprecated
    public boolean checkCellDetailHasRule(long modelId, Long datasetId, Map<String, String> cell) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Map viewMap = modelCache.getViewsByDataSet(datasetId);
        return this.checkCellDetailHasRule(modelId, datasetId, cell, viewMap);
    }

    public boolean checkCellDetailHasRule(long modelId, Long datasetId, Map<String, String> cell, Map<String, Long> viewMap) {
        RuleDto rule = this.findRuleByCell(modelId, datasetId, viewMap, cell);
        return rule != null;
    }

    public boolean checkRelate(Map<String, String> dataScope, Map<String, Set<String>> ruleScope) {
        for (Map.Entry<String, String> entry : dataScope.entrySet()) {
            String dimNumber = entry.getKey();
            String dataMember = entry.getValue();
            Set<String> ruleMembers = ruleScope.get(dimNumber);
            if (ruleMembers == null || ruleMembers.contains(dataMember)) continue;
            return false;
        }
        return true;
    }

    public RuleDto findRuleByCell(long modelId, long datasetId, Map<String, Long> viewMap, Map<String, String> cell) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long busModelId = modelCache.getBusModelByDataSet(Long.valueOf(datasetId));
        List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
        if (viewMap == null || viewMap.isEmpty()) {
            viewMap = modelCache.getViewsByDataSet(Long.valueOf(datasetId));
        }
        Member cellMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, cell.get(SysDimensionEnum.Metric.getNumber()));
        List bizRules = RuleCacheService.getInstance().listRuleFromLocalCache(busModelId).getRuleDtoList().stream().filter(rule -> busModelId.equals(rule.getBizCtrlRangeId())).collect(Collectors.toList());
        if (!cellMetMember.hasAgg()) {
            for (RuleDto rule2 : bizRules) {
                if (!this.checkRelate(cell, rule2.getLeftMembers()) || !BooleanUtils.isFalse((Boolean)rule2.isIfHasNotParam())) continue;
                return rule2;
            }
        } else {
            bizRules = bizRules.stream().filter(e -> e.getLeafFeature() != LeafFeature.NOTLEAF).collect(Collectors.toList());
            HashMap cellScope = Maps.newHashMap();
            Map finalViewMap = viewMap;
            cell.forEach((dimNum, memb) -> {
                List detailMemberList = modelCache.getMember(dimNum, (Long)finalViewMap.get(dimNum), memb, RangeEnum.ALL_DETAIL.getIndex());
                Set members = detailMemberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                cellScope.put(dimNum, members);
            });
            List<String> dimNumbers = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            for (RuleDto rule3 : bizRules) {
                if (!RuleRelationService.getInstance().checkRelate(cellScope, rule3.getLeftMembers(), dimNumbers) || !BooleanUtils.isFalse((Boolean)rule3.isIfHasNotParam())) continue;
                return rule3;
            }
        }
        return null;
    }

    private static enum SingleTon {
        INSTANCE;

        private RuleFindService instance = new RuleFindService();
    }
}

