/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizrule;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.business.template.TemplateTaskService;
import kd.epm.eb.business.template.entity.TemplateTaskDto;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.AggType;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.f7.FormulaCondition;
import kd.epm.eb.common.pojo.MemberPojo;
import kd.epm.eb.common.rule.edit.FormulaMembPojo;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.RuleBatchPlanFormulaPojo;
import kd.epm.eb.common.rule.edit.RuleBatchPlanRowPojo;
import kd.epm.eb.common.rule.edit.RuleBatchPlanScopePojo;
import kd.epm.eb.common.rule.edit.RuleManageRowPojo;
import kd.epm.eb.common.rule.edit.RuleRangMemberPojo;
import kd.epm.eb.common.rule.edit.RuleRangePojo;
import kd.epm.eb.common.rule.relation.pojo.TemplateTaskMemberDto;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.DbUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.FormulaMemberDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleCacheContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.service.LeafFeature;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

public class RuleRelationService {
    private static final Log log = LogFactory.getLog(RuleRelationService.class);
    private Map<Long, Long> accGroupMap = new ConcurrentHashMap<Long, Long>(16);
    private Map<Long, Integer> indexMap = new ConcurrentHashMap<Long, Integer>(16);

    public static RuleRelationService getInstance() {
        return InnerClass.instance;
    }

    private RuleRelationService() {
    }

    public void reassignRuleToApplyTemplate(long bizModelId, long modelId) {
        log.info("\u89c4\u5219\u91cd\u65b0\u5206\u914d\u5230\u7533\u62a5\u6a21\u677fstart");
        List datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(Long.valueOf(bizModelId));
        String field = "id,number,name,dataset.id,model.id,cachedata_tag,entrycfgjson_tag";
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("dataset", "in", (Object)datasetIds);
        filter.and("templatestatus", "=", (Object)"1");
        DynamicObjectCollection templateList = QueryServiceHelper.query((String)"eb_applytemplate", (String)field, (QFilter[])filter.toArray());
        if (templateList.isEmpty()) {
            return;
        }
        this.bindRuleToApplyTemplate((List<DynamicObject>)templateList, bizModelId);
        log.info("\u89c4\u5219\u91cd\u65b0\u5206\u914d\u5230\u7533\u62a5\u6a21\u677fend");
    }

    public void bindRuleToApplyTemplate(List<DynamicObject> templateList, long bizModelId) {
        if (CollectionUtils.isEmpty(templateList)) {
            return;
        }
        this.setBindRuleToTemplateCache("CACHE_BIND_RULE_TO_APPLY_TEMPLATE" + bizModelId);
        List<TemplateTaskDto> templateTaskDtos = TemplateTaskService.getInstance().getApplyTemplateScope(templateList);
        List ruleDtos = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bizModelId)).getRuleDtoList();
        long modelId = templateList.get(0).getLong("model.id");
        this.updateRuleApplyTemplateRelation(templateTaskDtos, ruleDtos, modelId);
        this.removeBindRuleToTemplateCache("CACHE_BIND_RULE_TO_APPLY_TEMPLATE" + bizModelId);
    }

    private void updateRuleApplyTemplateRelation(List<TemplateTaskDto> templateTaskDtos, List<RuleDto> ruleDtoList, long modelId) {
        if (CollectionUtils.isEmpty(templateTaskDtos)) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List<String> dimNumbers = modelCacheHelper.getDimensionList().stream().map(BaseCache::getNumber).collect(Collectors.toList());
        for (TemplateTaskDto dto : templateTaskDtos) {
            try {
                for (RuleDto ruleDto : ruleDtoList) {
                    boolean relate = this.checkRelate(dto.getDimScope(), ruleDto.getLeftMembers(), dimNumbers);
                    if (!relate) continue;
                    dto.getRuleIds().add(ruleDto.getId());
                }
            }
            catch (Exception igr) {
                log.warn("\u7533\u62a5\u6a21\u677f\u7ed1\u5b9a\u89c4\u5219\u62a5\u9519\uff1a" + JSON.toJSONString((Object)dto), (Throwable)igr);
            }
        }
        Set templateIds = templateTaskDtos.stream().map(TemplateTaskDto::getTemplateId).collect(Collectors.toSet());
        String inSql = templateIds.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
        String delSql = "delete from t_eb_applytemplaterule where ftemplate in " + inSql;
        DB.execute((DBRoute)BgBaseConstant.epm, (String)delSql);
        List ruleTplList = templateTaskDtos.stream().filter(e -> !e.getRuleIds().isEmpty()).collect(Collectors.toList());
        String templateSql = "insert into t_eb_applytemplaterule(fid,ftemplate,fbizrule) values(?,?,?)";
        ArrayList<Object[]> templateParams = new ArrayList<Object[]>(10);
        for (TemplateTaskDto dto : ruleTplList) {
            for (Long ruleId : dto.getRuleIds()) {
                templateParams.add(new Object[]{DBServiceHelper.genGlobalLongId(), dto.getTemplateId(), ruleId});
            }
        }
        if (!templateParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)templateSql, templateParams);
        }
    }

    public void reassignRuleToTemplateByBizctrlrange(long bizctrlrangeid, Set<Long> ruleIdLongSet) {
        log.info("\u89c4\u5219\u91cd\u65b0\u5206\u914d\u5230\u9884\u7b97\u6a21\u677fstart:" + bizctrlrangeid);
        List datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(Long.valueOf(bizctrlrangeid));
        List templateList = DatasetServiceHelper.getInstance().getTemplate((Collection)datasetIds);
        if (templateList.isEmpty()) {
            return;
        }
        this.bindRuleToTemplate(templateList, bizctrlrangeid, ruleIdLongSet);
        log.info("\u89c4\u5219\u91cd\u65b0\u5206\u914d\u5230\u9884\u7b97\u6a21\u677fend:" + bizctrlrangeid);
    }

    public void reassignRuleToTemplateByTasklist(long modelId, long tasklistId, long bizmodelId) {
        QFilter qf = new QFilter("tasklist.id", "=", (Object)tasklistId);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"eb_task", (String)"id", (QFilter[])new QFilter[]{qf});
        if (tasks.isEmpty()) {
            return;
        }
        Set taskIds = tasks.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        String sql = "select ftemplateid  from t_eb_taskreftemplate where fid in (" + taskIds.stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
        HashSet<Long> templateIds = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                Row r = ds.next();
                templateIds.add(r.getLong("ftemplateid"));
            }
        }
        this.reassignRuleToTemplateIds(modelId, templateIds, bizmodelId);
    }

    public void reassignRuleToTemplateIds(Long modelId, Set<Long> templateIds, long bizmodelId) {
        try {
            List templateList = DatasetServiceHelper.getInstance().getTemplateByIds(templateIds);
            this.bindRuleToTemplate(templateList, bizmodelId, null);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u4e0b\u8fbe\u53ca\u7f16\u5236\u65b9\u6848\u89c4\u5219\u91cd\u65b0\u5206\u914d\u5230\u6a21\u677f\u51fa\u9519", (Throwable)e);
            String title = ResManager.loadKDString((String)"\u89c4\u5219\u91cd\u65b0\u5206\u914d\u5230\u6a21\u677f\u51fa\u9519\u901a\u77e5", (String)"RuleExecutionService_11", (String)"epm-eb-business", (Object[])new Object[0]);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray());
            String shownumber = "";
            if (dynamicObject != null) {
                shownumber = dynamicObject.getString("shownumber");
            }
            String messageDate = ResManager.loadResFormat((String)"\u4f53\u7cfb\uff1a%1,\u89c4\u5219\u91cd\u65b0\u5206\u914d\u5230\u6a21\u677f\u51fa\u9519,\u8bf7\u91cd\u65b0\u4fdd\u5b58\u89c4\u5219\u6216\u5347\u7ea7\u89c4\u5219\u4f9d\u8d56", (String)"RuleRelationService_0", (String)"epm-eb-business", (Object[])new Object[]{shownumber});
            RuleExecutionService.getInstance().sendMessage(modelId, Collections.singletonList(ThrowableHelper.printError((Throwable)e)), title, messageDate);
        }
    }

    public void bindRuleToTemplate(long templateId) {
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"eb_templateentity");
        this.$bindRuleToTemplate(template);
    }

    public void asycBindRuleToTemplate(long templateId) {
        EpmThreadPools.CommPools.execute(() -> {
            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"eb_templateentity");
            this.$bindRuleToTemplate(template);
        });
    }

    public List<Long> getTemplateRelationRuleWithNoVar(long templateId, Map<Long, Set<String>> assignTemplateAndEntityNumberMap) {
        List<TemplateTaskDto> templateTaskDtos;
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"eb_templateentity");
        DynamicObject dataset = template.getDynamicObject("dataset");
        long bizmodelId = dataset.getLong("businessmodel.id");
        if (assignTemplateAndEntityNumberMap != null && !assignTemplateAndEntityNumberMap.isEmpty() && CollectionUtils.isNotEmpty((Collection)assignTemplateAndEntityNumberMap.get(templateId))) {
            templateTaskDtos = TemplateTaskService.getInstance().getTemplateOrTaskScope(Collections.singleton(template), bizmodelId, true);
        } else {
            templateTaskDtos = TemplateTaskService.getInstance().getTemplateOrTaskScope(Collections.singleton(template), bizmodelId, false);
            List<Map<String, Set<TemplateTaskMemberDto>>> dimScopeList = templateTaskDtos.get(0).getDimScopeList();
            for (Map<String, Set<TemplateTaskMemberDto>> map : dimScopeList) {
                Set<TemplateTaskMemberDto> entityNumbers = map.get(SysDimensionEnum.Entity.getNumber());
                if (entityNumbers == null || !entityNumbers.isEmpty()) continue;
                map.remove(SysDimensionEnum.Entity.getNumber());
            }
        }
        RuleCacheContext ruleCacheContext = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bizmodelId));
        List ruleDtoList = ruleCacheContext.getRuleDtoList();
        DynamicObject model = template.getDynamicObject("model");
        long modelId = 0L;
        if (model != null) {
            modelId = model.getLong("id");
        }
        List<TemplateTaskDto> bindRuleTemplateTaskDtos = this.getBindRuleTemplateTaskDtos(templateTaskDtos, ruleDtoList, modelId);
        LinkedList relationRuleId = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty(bindRuleTemplateTaskDtos)) {
            for (TemplateTaskDto bindRuleTemplateTaskDto : bindRuleTemplateTaskDtos) {
                relationRuleId.addAll(bindRuleTemplateTaskDto.getRuleIds());
            }
        }
        return relationRuleId;
    }

    private void $bindRuleToTemplate(@NotNull DynamicObject template) {
        DynamicObject dataset = template.getDynamicObject("dataset");
        long bizmodelId = dataset.getLong("businessmodel.id");
        this.setBindRuleToTemplateCache("CACHE_BIND_RULE_TO_TEMPLATE" + bizmodelId);
        List<TemplateTaskDto> templateTaskDtos = TemplateTaskService.getInstance().getTemplateOrTaskScope(Collections.singleton(template), bizmodelId, true);
        List ruleDtos = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bizmodelId)).getRuleDtoList();
        long modelId = 0L;
        DynamicObject model = template.getDynamicObject("model");
        if (model != null) {
            modelId = model.getLong("id");
        }
        this.updateRuleTemplateRelation(templateTaskDtos, ruleDtos, modelId);
        this.removeBindRuleToTemplateCache("CACHE_BIND_RULE_TO_TEMPLATE" + bizmodelId);
    }

    public void bindRuleToTemplate(List<DynamicObject> templateList, long bizmodelId, Set<Long> ruleIdLongSet) {
        String delSql;
        if (CollectionUtils.isEmpty(templateList)) {
            return;
        }
        this.setBindRuleToTemplateCache("CACHE_BIND_RULE_TO_TEMPLATE" + bizmodelId);
        List<RuleDto> ruleDtos = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bizmodelId)).getRuleDtoList();
        if (CollectionUtils.isNotEmpty(ruleIdLongSet)) {
            ruleDtos = ruleDtos.stream().filter(e -> ruleIdLongSet.contains(e.getId())).collect(Collectors.toList());
        }
        List pageList = Lists.partition(templateList, (int)3);
        ArrayList<Object[]> templateParams = new ArrayList<Object[]>(10);
        ArrayList<Object[]> taskParams = new ArrayList<Object[]>(10);
        for (List sub : pageList) {
            List<TemplateTaskDto> templateTaskDtos = TemplateTaskService.getInstance().getTemplateOrTaskScope(sub, bizmodelId, true);
            long modelId = 0L;
            if (CollectionUtils.isNotEmpty((Collection)sub)) {
                modelId = ((DynamicObject)sub.get(0)).getLong("model.id");
            }
            templateTaskDtos = this.getBindRuleTemplateTaskDtos(templateTaskDtos, ruleDtos, modelId);
            for (TemplateTaskDto dto : templateTaskDtos) {
                for (Long ruleId : dto.getRuleIds()) {
                    Long tasklistId = dto.getTasklistId();
                    if (tasklistId == null) {
                        templateParams.add(new Object[]{DBServiceHelper.genGlobalLongId(), dto.getTemplateId(), ruleId});
                        continue;
                    }
                    taskParams.add(new Object[]{DBServiceHelper.genGlobalLongId(), dto.getTemplateId(), ruleId, tasklistId});
                }
            }
        }
        String inSql = templateList.stream().map(e -> e.getLong("id") + "").collect(Collectors.joining(",", "(", ")"));
        if (CollectionUtils.isNotEmpty(ruleIdLongSet)) {
            String inSqlRule = ruleIdLongSet.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
            delSql = "delete from t_eb_leafbizruletempdis where ftemplate in " + inSql + " and fbizrule in " + inSqlRule;
        } else {
            delSql = "delete from t_eb_leafbizruletempdis where ftemplate in " + inSql;
        }
        DB.execute((DBRoute)BgBaseConstant.epm, (String)delSql);
        String templateSql = "insert into t_eb_leafbizruletempdis(fid,ftemplate,fbizrule) values(?,?,?)";
        String tasklistSql = "insert into t_eb_leafbizruletempdis(fid,ftemplate,fbizrule,ftasklist) values(?,?,?,?)";
        if (!templateParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)templateSql, templateParams);
        }
        if (!taskParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)tasklistSql, taskParams);
        }
        this.removeBindRuleToTemplateCache("CACHE_BIND_RULE_TO_TEMPLATE" + bizmodelId);
    }

    public void bindRuleToOneTemplate(TemplateTaskDto templateTaskDto, long datasetId, boolean containsLeaf, Long modelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            log.warn("\u5355\u6a21\u677f\u7ed1\u5b9a\u89c4\u5219\u65e0\u4f53\u7cfbid");
            return;
        }
        Long bizModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId);
        List ruleDtoList = RuleCacheService.getInstance().listRuleFromLocalCache(bizModelId).getRuleDtoList();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List<String> dimNumbers = modelCacheHelper.getDimensionList().stream().map(BaseCache::getNumber).collect(Collectors.toList());
        for (RuleDto ruleDto : ruleDtoList) {
            boolean relate;
            if (!containsLeaf && ruleDto.getNewLeafFeature() == LeafFeature.LEAF || !(relate = this.checkRelate(templateTaskDto.getDimScope(), ruleDto.getLeftMembers(), dimNumbers))) continue;
            templateTaskDto.getRuleIds().add(ruleDto.getId());
        }
    }

    private void updateRuleTemplateRelation(List<TemplateTaskDto> templateTaskDtos, List<RuleDto> ruleDtoList, long modelId) {
        if (CollectionUtils.isEmpty(templateTaskDtos) || CollectionUtils.isEmpty(ruleDtoList) || IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        List<TemplateTaskDto> ruleDtos = this.getBindRuleTemplateTaskDtos(templateTaskDtos, ruleDtoList, modelId);
        Set templateIds = templateTaskDtos.stream().map(TemplateTaskDto::getTemplateId).collect(Collectors.toSet());
        String inSql = templateIds.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
        Set ruleIds = ruleDtoList.stream().map(RuleDto::getId).collect(Collectors.toSet());
        String inSqlRule = ruleIds.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
        String delSql = "delete from t_eb_leafbizruletempdis where ftemplate in " + inSql + " and fbizrule in " + inSqlRule;
        DB.execute((DBRoute)BgBaseConstant.epm, (String)delSql);
        String templateSql = "insert into t_eb_leafbizruletempdis(fid,ftemplate,fbizrule) values(?,?,?)";
        String tasklistSql = "insert into t_eb_leafbizruletempdis(fid,ftemplate,fbizrule,ftasklist) values(?,?,?,?)";
        ArrayList<Object[]> templateParams = new ArrayList<Object[]>(10);
        ArrayList<Object[]> taskParams = new ArrayList<Object[]>(10);
        for (TemplateTaskDto dto : ruleDtos) {
            for (Long ruleId : dto.getRuleIds()) {
                Long tasklistId = dto.getTasklistId();
                if (tasklistId == null) {
                    templateParams.add(new Object[]{DBServiceHelper.genGlobalLongId(), dto.getTemplateId(), ruleId});
                    continue;
                }
                taskParams.add(new Object[]{DBServiceHelper.genGlobalLongId(), dto.getTemplateId(), ruleId, tasklistId});
            }
        }
        if (!templateParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)templateSql, templateParams);
        }
        if (!taskParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)tasklistSql, taskParams);
        }
    }

    private List<TemplateTaskDto> getBindRuleTemplateTaskDtos(List<TemplateTaskDto> templateTaskDtos, List<RuleDto> ruleDtoList, long modelId) {
        if (CollectionUtils.isEmpty(templateTaskDtos) || CollectionUtils.isEmpty(ruleDtoList) || IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return Collections.emptyList();
        }
        List notEmpList = templateTaskDtos.stream().filter(e -> CollectionUtils.isNotEmpty(e.getDimScopeList())).collect(Collectors.toList());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimNumbers = modelCache.getDimensionList().stream().map(BaseCache::getNumber).collect(Collectors.toList());
        CountDownLatch latch = new CountDownLatch(notEmpList.size());
        for (TemplateTaskDto dto : notEmpList) {
            EpmThreadPools.HALF_CORE_POOL.execute(() -> {
                try {
                    Set<TemplateTaskMemberDto> entityInPageMemberSet = dto.getEntityInPageMemberSet();
                    Set<Object> entityPageMemberSet = new HashSet(16);
                    if (CollectionUtils.isNotEmpty(entityInPageMemberSet)) {
                        entityPageMemberSet = entityInPageMemberSet.stream().map(TemplateTaskMemberDto::getMemberNumber).collect(Collectors.toSet());
                    }
                    for (Map<String, Set<TemplateTaskMemberDto>> map : dto.getDimScopeList()) {
                        boolean isEmptyEntity;
                        HashMap<String, Set<String>> dataScope = new HashMap<String, Set<String>>(16);
                        for (Map.Entry<String, Set<TemplateTaskMemberDto>> entry : map.entrySet()) {
                            Set collect = entry.getValue().stream().map(TemplateTaskMemberDto::getMemberNumber).collect(Collectors.toSet());
                            dataScope.put(entry.getKey(), collect);
                        }
                        String entityNumber = SysDimensionEnum.Entity.getNumber();
                        boolean bl = isEmptyEntity = !dataScope.containsKey(entityNumber) || ((Set)dataScope.get(entityNumber)).isEmpty();
                        if (isEmptyEntity && CollectionUtils.isNotEmpty(entityPageMemberSet)) {
                            dataScope.put(entityNumber, entityPageMemberSet);
                        }
                        for (RuleDto ruleDto : ruleDtoList) {
                            boolean relate = this.checkRelate(dataScope, ruleDto.getLeftMembers(), dimNumbers);
                            if (ruleDto.getLeafFeature() == kd.epm.eb.algo.olap.LeafFeature.NOTLEAF && relate) {
                                boolean scopeIsLeaf = true;
                                for (Map.Entry<String, Set<TemplateTaskMemberDto>> entry : map.entrySet()) {
                                    String dimNumber = entry.getKey();
                                    Set<TemplateTaskMemberDto> memberSet = entry.getValue();
                                    for (TemplateTaskMemberDto memberDto : memberSet) {
                                        Member member = modelCache.getMember(dimNumber, memberDto.getViewId(), memberDto.getMemberNumber());
                                        if (member.isLeaf()) continue;
                                        scopeIsLeaf = false;
                                        break;
                                    }
                                    if (scopeIsLeaf) continue;
                                    break;
                                }
                                boolean bl2 = relate = !scopeIsLeaf;
                            }
                            if (!relate) continue;
                            dto.getRuleIds().add(ruleDto.getId());
                        }
                    }
                }
                catch (Exception igr) {
                    log.warn("\u6a21\u677f\u7ed1\u5b9a\u89c4\u5219\u62a5\u9519\uff1a" + JSON.toJSONString((Object)dto), (Throwable)igr);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e2) {
            log.error((Throwable)e2);
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u7ed1\u5b9a\u6a21\u677f\u591a\u7ebf\u7a0b\u5904\u7406\u51fa\u9519\u3002", (String)"RuleRelationService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        List<TemplateTaskDto> ruleDtos = notEmpList.stream().filter(e -> !e.getRuleIds().isEmpty()).collect(Collectors.toList());
        return ruleDtos;
    }

    public List<Long> listRuleByTemplateId(Long templateId) {
        ArrayList<Long> ruleIds = new ArrayList<Long>(10);
        String sql = "select fid from t_eb_bizruleset where fstatus = '1' and fid in (select fbizrule from t_eb_leafbizruletempdis where ftemplate = ?)";
        DB.query((DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{templateId}, rs -> {
            while (rs.next()) {
                Long ruleId = rs.getLong("fid");
                ruleIds.add(ruleId);
            }
            return ruleIds;
        });
        return ruleIds;
    }

    public List<Long> listRuleByApplyTemplateId(Collection<Long> templateIds) {
        List<Object> ruleIds = Lists.newArrayList();
        if (CollectionUtils.isEmpty(templateIds)) {
            return ruleIds;
        }
        QFilter filter = new QFilter("template", "in", templateIds);
        DynamicObjectCollection ruleList = QueryServiceHelper.query((String)"eb_applytemplaterule", (String)"bizrule.id", (QFilter[])filter.toArray());
        ruleIds = ruleList.stream().map(e -> e.getLong("bizrule.id")).collect(Collectors.toList());
        return ruleIds;
    }

    public Set<Long> listTemplateByTemplateId(Collection<Long> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.emptySet();
        }
        HashSet<Long> templateIdList = new HashSet<Long>(10);
        String str = templateIds.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
        String sql = "select ftemplate from t_eb_leafbizruletempdis where ftemplate in " + str;
        DB.query((DBRoute)BgBaseConstant.epm, (String)sql, rs -> {
            while (rs.next()) {
                Long templateId = rs.getLong("ftemplate");
                templateIdList.add(templateId);
            }
            return templateIdList;
        });
        return templateIdList;
    }

    public Set<Long> listApplyTemplateByTemplateId(Collection<Long> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.emptySet();
        }
        HashSet<Long> templateIdList = new HashSet<Long>(10);
        String str = templateIds.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
        String sql = "select ftemplate from t_eb_applytemplaterule where ftemplate in " + str;
        DB.query((DBRoute)BgBaseConstant.epm, (String)sql, rs -> {
            while (rs.next()) {
                Long templateId = rs.getLong("ftemplate");
                templateIdList.add(templateId);
            }
            return templateIdList;
        });
        return templateIdList;
    }

    public int isRuleSuccessor(RuleDto preNode, RuleDto nextNode, List<String> dimNumbers, Map<Long, Map<String, Boolean>> ruleRightMemberNotLeafMap) {
        boolean handleLeafAndNotLeaf = preNode.getLeafFeature() == kd.epm.eb.algo.olap.LeafFeature.NOTLEAF && nextNode.getLeafFeature() == kd.epm.eb.algo.olap.LeafFeature.LEAF;
        Map nextOffSetMap = nextNode.getOffsetMap();
        Map nextRightMembers = nextNode.getRightMembers();
        Map oriRightMembers = nextNode.getOriRightMembers();
        Map preLeftMembers = preNode.getLeftMembers();
        Map<String, Boolean> rightMemberNotLeafMap = ruleRightMemberNotLeafMap.get(nextNode.getId());
        int markOffset = 0;
        for (Map.Entry entry : nextRightMembers.entrySet()) {
            Boolean isNotLeaf;
            boolean relate;
            String memberKey = (String)entry.getKey();
            Integer nextOffset = 0;
            if (nextOffSetMap != null && nextOffSetMap.containsKey(memberKey)) {
                nextOffset = (Integer)nextOffSetMap.get(memberKey);
            }
            Map nextRightMember = (Map)entry.getValue();
            if (oriRightMembers.containsKey(memberKey)) {
                nextRightMember = (Map)oriRightMembers.get(memberKey);
            }
            if ((relate = this.checkRelate(preLeftMembers, nextRightMember, dimNumbers)) && handleLeafAndNotLeaf && rightMemberNotLeafMap != null && BooleanUtils.isFalse((Boolean)(isNotLeaf = rightMemberNotLeafMap.get(memberKey)))) {
                relate = false;
            }
            if (!relate) continue;
            if (nextOffset == 0) {
                return nextOffset;
            }
            markOffset = nextOffset;
        }
        if (markOffset != 0) {
            return markOffset;
        }
        return Integer.MAX_VALUE;
    }

    public List<RuleDto> rebuildRightMember(List<RuleDto> rules, IModelCacheHelper modelCache) {
        for (RuleDto rule : rules) {
            Map offsetMap = rule.getOffsetMap();
            List ruleFunctions = rule.getFunctions();
            HashMap<String, Set> ruleFunctionRefDimNumMemKeyMap = new HashMap<String, Set>(16);
            if (CollectionUtils.isNotEmpty((Collection)ruleFunctions)) {
                for (RuleFunction ruleFunction : ruleFunctions) {
                    Map allValues = ruleFunction.getAllValues();
                    if (!allValues.containsKey(FunctionItemEnum.DIMENSIONLIST.getKey()) || !allValues.containsKey("refMemKey")) continue;
                    String refMemKey = (String)allValues.get("refMemKey");
                    String dimNum = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
                    Set ruleFunctionRefDimNumSet = ruleFunctionRefDimNumMemKeyMap.computeIfAbsent(refMemKey, k -> new HashSet(16));
                    ruleFunctionRefDimNumSet.add(dimNum);
                }
            }
            for (Map.Entry entry : rule.getRightMembers().entrySet()) {
                String memberKey = (String)entry.getKey();
                Map rightMemberScope = (Map)entry.getValue();
                Integer offset = 0;
                if (offsetMap != null && offsetMap.containsKey(memberKey)) {
                    offset = (Integer)offsetMap.get(memberKey);
                }
                Integer finalOffset = offset;
                HashSet movDimSet = Sets.newHashSetWithExpectedSize((int)10);
                HashSet bgMembers = new HashSet(16);
                rule.getLeftMembers().forEach((k, v) -> {
                    if (!rightMemberScope.containsKey(k)) {
                        if (ruleFunctionRefDimNumMemKeyMap.containsKey(memberKey) && ((Set)ruleFunctionRefDimNumMemKeyMap.get(memberKey)).contains(k)) {
                            rightMemberScope.put(k, new HashSet(16));
                        } else {
                            movDimSet.add(k);
                            if (finalOffset != 0 && SysDimensionEnum.BudgetPeriod.getNumber().equals(k)) {
                                bgMembers.clear();
                                for (String memberNumber : v) {
                                    Member memberOffset = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), memberNumber, finalOffset.intValue());
                                    if (memberOffset == null) continue;
                                    bgMembers.add(memberOffset.getNumber());
                                }
                                rightMemberScope.put(SysDimensionEnum.BudgetPeriod.getNumber(), bgMembers);
                            } else {
                                rightMemberScope.put(k, v);
                            }
                        }
                    }
                });
                String metNumber = (String)((Set)rightMemberScope.get(SysDimensionEnum.Metric.getNumber())).iterator().next();
                Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metNumber);
                if (rule.getLeafFeature() == kd.epm.eb.algo.olap.LeafFeature.LEAF || !metMember.hasAgg()) continue;
                for (Map.Entry entry2 : rightMemberScope.entrySet()) {
                    Set rMemSet = (Set)entry2.getValue();
                    String dimNumber = (String)entry2.getKey();
                    if (!movDimSet.contains(dimNumber)) continue;
                    HashSet newSet = Sets.newHashSetWithExpectedSize((int)10);
                    for (String rMem : rMemSet) {
                        if (modelCache.getMember(dimNumber, (Long)rule.getViewMap().get(dimNumber), rMem).isLeaf()) {
                            newSet.add(rMem);
                            continue;
                        }
                        newSet.addAll(modelCache.getMember(dimNumber, (Long)rule.getViewMap().get(dimNumber), rMem, RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                    }
                    rightMemberScope.put(dimNumber, newSet);
                }
            }
        }
        return rules;
    }

    public boolean checkRelate(Map<String, Set<String>> dataScope, Map<String, Set<String>> ruleScope, List<String> dimNumbers) {
        for (String dimNumber : dimNumbers) {
            Set<String> ruleCurrentDimMembers;
            Set<String> dataCurrentDimMembers = dataScope.get(dimNumber);
            boolean intersect = RuleRelationService.checkIntersect(dataCurrentDimMembers, ruleCurrentDimMembers = ruleScope.get(dimNumber));
            if (intersect) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIntersect(Set<String> dataCurrentDimMembers, Set<String> ruleCurrentDimMembers) {
        if (dataCurrentDimMembers == null) {
            if (ruleCurrentDimMembers == null) {
                return true;
            }
            return !ruleCurrentDimMembers.isEmpty();
        }
        if (ruleCurrentDimMembers == null) {
            return !dataCurrentDimMembers.isEmpty();
        }
        return RuleRelationService.checkIntersection(dataCurrentDimMembers, ruleCurrentDimMembers);
    }

    private static boolean checkIntersection(Set<String> smallerSet, Set<String> largerSet) {
        if (smallerSet.size() > largerSet.size()) {
            Set<String> temp = smallerSet;
            smallerSet = largerSet;
            largerSet = temp;
        }
        for (String element : smallerSet) {
            if (!largerSet.contains(element)) continue;
            return true;
        }
        return false;
    }

    public void updateOldData(long modelId, boolean hasModelTrans) {
        String errMsg = "";
        try (TXHandle tx = TX.requiresNew((String)this.getClass().getName());){
            try {
                this.upMainTable(modelId);
                this.upMembTable(modelId);
                this.upFunctionTable(modelId);
                this.updateYearValueFun(modelId);
                this.updateShowRuleFuncAggType(modelId);
                this.updatePeriodShiftAggType(modelId);
            }
            catch (Exception e) {
                log.error("updateRuleOldDataError:", (Throwable)e);
                tx.markRollback();
                errMsg = ExceptionUtils.getStackTrace((Throwable)e);
            }
        }
        tx = TX.requiresNew((String)this.getClass().getName());
        var6_5 = null;
        try {
            try {
                this.updateRuleView(modelId, hasModelTrans);
            }
            catch (Exception e) {
                log.error("updateRuleView:", (Throwable)e);
                tx.markRollback();
                errMsg = ExceptionUtils.getStackTrace((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errMsg)) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    public boolean updateRuleView(long modelId, boolean hasModelTrans) {
        List ruleBatchMapList;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        QFilter Qf1 = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection businessModels = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{Qf1});
        if (businessModels.isEmpty()) {
            return true;
        }
        boolean updateSuccess = true;
        HashMap<Long, Map<String, View>> businessDefaultViewMap = new HashMap<Long, Map<String, View>>(16);
        HashMap<Long, Map<String, Map<String, View>>> businessDimViewsMap = new HashMap<Long, Map<String, Map<String, View>>>(16);
        this.getBusinessModelView(modelCacheHelper, businessModels, businessDefaultViewMap, businessDimViewsMap);
        HashMap<String, Long> ctMemberNumViewMap = new HashMap<String, Long>(16);
        HashMap<Long, Long> ctMemberIdViewMap = new HashMap<Long, Long>(16);
        this.getCtMemberViewMap(modelCacheHelper, ctMemberNumViewMap, ctMemberIdViewMap);
        List ruleMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fmodel,fbizctrlrangeid,fusescope,fmaindimensionid,fnumber,fruleview from t_eb_bizruleset where fmodel = ?", (Object[])new Object[]{modelId});
        if (CollectionUtils.isNotEmpty((Collection)ruleMapList)) {
            String sql;
            Map<Long, Map> ruleMap = ruleMapList.stream().collect(Collectors.toMap(e -> (Long)e.get("fid"), v -> v, (v1, v2) -> v1));
            List ruleFuncMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fruleid,ffunctiontype,ffunctioninfostr from t_eb_rulefunction where fruleid in (select fid from t_eb_bizruleset where fmodel = ?)", (Object[])new Object[]{modelId});
            Map<Long, List<Map>> ruleFuncMapGroupRuleId = ruleFuncMapList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("fruleid")));
            List ruleAccFuncMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fpkid,fruleid,fdimenstionjsonfix,fisleft from t_eb_bizruleformulaacc where fruleid in (select fid from t_eb_bizruleset where fmodel = ?)", (Object[])new Object[]{modelId});
            Map<Long, List<Map>> ruleAccMapGroupRuleId = ruleAccFuncMapList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("fruleid")));
            ArrayList<Object[]> allRuleFuncValues = new ArrayList<Object[]>(16);
            ArrayList<Object[]> allRuleValues = new ArrayList<Object[]>(16);
            ArrayList allRuleAccValues = new ArrayList(16);
            ArrayList arrayList = new ArrayList(16);
            for (Map.Entry<Long, Map> entry : ruleMap.entrySet()) {
                ArrayList<Object[]> ruleFuncValues = new ArrayList<Object[]>(16);
                ArrayList<Object[]> ruleValues = new ArrayList<Object[]>(16);
                ArrayList<Object[]> ruleAccValues = new ArrayList<Object[]>(16);
                ArrayList<Object[]> ruleViewValues = new ArrayList<Object[]>(16);
                Long ruleId = entry.getKey();
                Map rule = entry.getValue();
                String number = (String)rule.get("fnumber");
                try {
                    Long bizModel = (Long)rule.get("fbizctrlrangeid");
                    Long mainDimId = (Long)rule.get("fmaindimensionid");
                    if (IDUtils.isEmptyLong((Long)bizModel).booleanValue() || IDUtils.isEmptyLong((Long)mainDimId).booleanValue()) continue;
                    HashMap<String, String> ruleViewMap = new HashMap<String, String>(16);
                    String mainDimNumber = modelCacheHelper.getDimension(mainDimId).getNumber();
                    Map defaultViewMap = (Map)businessDefaultViewMap.get(bizModel);
                    Map tempDimViewMap = (Map)businessDimViewsMap.get(bizModel);
                    List<Map<String, Object>> ruleFuncList = ruleFuncMapGroupRuleId.get(ruleId);
                    this.handleRuleFunctionViewUpdate(hasModelTrans, ruleFuncValues, mainDimNumber, defaultViewMap, tempDimViewMap, ruleFuncList, ruleViewMap, ctMemberNumViewMap, ctMemberIdViewMap);
                    allRuleFuncValues.addAll(ruleFuncValues);
                    List<Map<String, Object>> ruleAccList = ruleAccMapGroupRuleId.get(ruleId);
                    FormulaMemberDto firstFormulaMember = this.getFirstFormulaMemberByRule(ruleAccList, mainDimNumber);
                    this.handleRuleRangeViewUpdate(hasModelTrans, ruleValues, ruleId, rule, defaultViewMap, tempDimViewMap, modelCacheHelper, firstFormulaMember, ruleViewMap, mainDimNumber, ctMemberNumViewMap);
                    allRuleValues.addAll(ruleValues);
                    this.handleRuleAccViewUpdate(hasModelTrans, ruleAccValues, defaultViewMap, tempDimViewMap, ruleAccList, ruleViewMap, ctMemberNumViewMap);
                    allRuleAccValues.addAll(ruleAccValues);
                    if (ruleViewMap.isEmpty()) continue;
                    Object[] oneRowRuleViewVal = new Object[2];
                    oneRowRuleViewVal[1] = ruleId;
                    oneRowRuleViewVal[0] = JSON.toJSONString(ruleViewMap);
                    ruleViewValues.add(oneRowRuleViewVal);
                    arrayList.addAll(ruleViewValues);
                }
                catch (Exception e2) {
                    log.error("updateRuleViewFail_" + number + ":", (Throwable)e2);
                    updateSuccess = false;
                }
            }
            if (allRuleFuncValues.size() > 0) {
                sql = "update t_eb_rulefunction set ffunctioninfostr = ? where fid = ?";
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, allRuleFuncValues);
            }
            if (allRuleValues.size() > 0) {
                sql = "update t_eb_bizruleset set fusescope = ? where fid = ?";
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, allRuleValues);
            }
            if (allRuleAccValues.size() > 0) {
                sql = "update t_eb_bizruleformulaacc set fdimenstionjsonfix = ? where fpkid = ?";
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, (List)allRuleAccValues);
            }
            if (arrayList.size() > 0) {
                sql = "update t_eb_bizruleset set fruleview = ? where fid = ?";
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, arrayList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(ruleBatchMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fmodel,fbizctrlrange,fruletemplate,fnumber,fruleview,fdataset from t_eb_rulebatch where fmodel = ?", (Object[])new Object[]{modelId})))) {
            String sql;
            Map<Long, Map> ruleBatchMap = ruleBatchMapList.stream().collect(Collectors.toMap(e -> (Long)e.get("fid"), v -> v, (v1, v2) -> v1));
            List ruleBatchRelationMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,frulebatch,fscope from t_eb_rulebatchrelation where frulebatch in (select fid from t_eb_rulebatch where fmodel = ?)", (Object[])new Object[]{modelId});
            ArrayList allRuleBatchValues = new ArrayList(16);
            ArrayList allRuleBatchViewValues = new ArrayList(16);
            ArrayList allRuleBatchRelationValues = new ArrayList(16);
            Map<Long, List<Map>> ruleBatchRelationMapGroupRuleId = ruleBatchRelationMapList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("frulebatch")));
            for (Map.Entry entry : ruleBatchMap.entrySet()) {
                ArrayList<Object[]> ruleBatchValues = new ArrayList<Object[]>(16);
                ArrayList<Object[]> ruleBatchViewValues = new ArrayList<Object[]>(16);
                ArrayList<Object[]> ruleBatchRelationValues = new ArrayList<Object[]>(16);
                Map ruleBatch = (Map)entry.getValue();
                String number = (String)ruleBatch.get("fnumber");
                HashMap<String, String> ruleViewMap = new HashMap<String, String>(16);
                try {
                    List<Map> ruleBatchRelations;
                    Long ruleBatchId = (Long)entry.getKey();
                    Long bizModel = (Long)ruleBatch.get("fbizctrlrange");
                    Long dataSet = (Long)ruleBatch.get("fdataset");
                    Long batchId = (Long)ruleBatch.get("fid");
                    Map defaultViewMap = (Map)businessDefaultViewMap.get(bizModel);
                    Map tempDimViewMap = (Map)businessDimViewsMap.get(bizModel);
                    String ruleTemplate = (String)ruleBatch.get("fruletemplate");
                    boolean batchHasSetView = false;
                    RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)JsonUtils.readValue((String)ruleTemplate, RuleManageRowPojo.class);
                    String mainDimNumber = ruleManageRowPojo.getDimensionNumberString();
                    View mainDimDefaultView = (View)defaultViewMap.get(mainDimNumber);
                    Map mainViewMapByNumber = (Map)tempDimViewMap.get(mainDimNumber);
                    boolean mainDimHasView = !View.NoViewDimNums.contains(mainDimNumber);
                    batchHasSetView = this.handleRuleBatchMainViewUpdate(hasModelTrans, batchHasSetView, ruleManageRowPojo, mainDimDefaultView, mainViewMapByNumber, mainDimHasView, mainDimNumber, ruleViewMap);
                    batchHasSetView = this.handleRuleBatchFormulaPojoListViewUpdate(hasModelTrans, modelCacheHelper, defaultViewMap, tempDimViewMap, batchHasSetView, ruleManageRowPojo, mainDimNumber, mainDimDefaultView, mainViewMapByNumber, mainDimHasView, ruleViewMap, ctMemberNumViewMap, ctMemberIdViewMap);
                    batchHasSetView = this.handleRuleBatchRuleRangeViewUpdate(hasModelTrans, defaultViewMap, tempDimViewMap, batchHasSetView, ruleManageRowPojo, modelCacheHelper, ruleViewMap, ctMemberNumViewMap, dataSet);
                    if (batchHasSetView) {
                        Object[] oneRowRuleBatchVal = new Object[2];
                        oneRowRuleBatchVal[1] = batchId;
                        oneRowRuleBatchVal[0] = SerializationUtils.toJsonString((Object)ruleManageRowPojo);
                        ruleBatchValues.add(oneRowRuleBatchVal);
                        allRuleBatchValues.addAll(ruleBatchValues);
                    }
                    if (CollectionUtils.isNotEmpty(ruleBatchRelations = ruleBatchRelationMapGroupRuleId.get(ruleBatchId))) {
                        for (Map ruleBatchRelation : ruleBatchRelations) {
                            boolean batchRelationHasSetView = false;
                            String scope = (String)ruleBatchRelation.get("fscope");
                            RuleBatchPlanRowPojo ruleBatchPlanRowPojo = (RuleBatchPlanRowPojo)JsonUtils.readValue((String)scope, RuleBatchPlanRowPojo.class);
                            batchRelationHasSetView = this.handleRuleBatchRelationLeftRangeViewUpdate(hasModelTrans, defaultViewMap, tempDimViewMap, batchRelationHasSetView, ruleBatchPlanRowPojo, ruleManageRowPojo, modelCacheHelper, ruleViewMap, ctMemberNumViewMap);
                            if (!(batchRelationHasSetView = this.handleRuleBatchRelationRightRangeViewUpdate(hasModelTrans, defaultViewMap, tempDimViewMap, batchRelationHasSetView, ruleBatchPlanRowPojo, ruleViewMap, ctMemberNumViewMap))) continue;
                            Object[] oneRowRuleBatchRelationVal = new Object[2];
                            oneRowRuleBatchRelationVal[1] = (Long)ruleBatchRelation.get("fid");
                            oneRowRuleBatchRelationVal[0] = JsonUtils.getJsonString((Object)ruleBatchPlanRowPojo);
                            ruleBatchRelationValues.add(oneRowRuleBatchRelationVal);
                        }
                        allRuleBatchRelationValues.addAll(ruleBatchRelationValues);
                    }
                    if (ruleViewMap.isEmpty()) continue;
                    Object[] oneRowRuleBatchViewVal = new Object[2];
                    oneRowRuleBatchViewVal[1] = ruleBatchId;
                    oneRowRuleBatchViewVal[0] = JSON.toJSONString(ruleViewMap);
                    ruleBatchViewValues.add(oneRowRuleBatchViewVal);
                    allRuleBatchViewValues.addAll(ruleBatchViewValues);
                }
                catch (Exception e3) {
                    log.error("updateRuleViewFailBatch_" + number + ":", (Throwable)e3);
                    updateSuccess = false;
                }
            }
            if (allRuleBatchValues.size() > 0) {
                sql = "update t_eb_rulebatch set fruletemplate = ? where fid = ?";
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, allRuleBatchValues);
            }
            if (allRuleBatchViewValues.size() > 0) {
                sql = "update t_eb_rulebatch set fruleview = ? where fid = ?";
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, allRuleBatchViewValues);
            }
            if (allRuleBatchRelationValues.size() > 0) {
                sql = "update t_eb_rulebatchrelation set fscope = ? where fid = ?";
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, allRuleBatchRelationValues);
            }
        }
        return updateSuccess;
    }

    private void getCtMemberViewMap(IModelCacheHelper modelCacheHelper, Map<String, Long> ctMemberNumViewMap, Map<Long, Long> ctMemberIdViewMap) {
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.ChangeType.getNumber());
        List viewList = dimension.getViewList();
        for (Long viewId : viewList) {
            View view = dimension.getView(viewId);
            if (view == null) continue;
            List allMembers = view.getAllMembers();
            for (Member member : allMembers) {
                if (member.getSource().equals(ViewMemberSourceEnum.INNER_REF.getIndex()) || member.getSource().equals(ViewMemberSourceEnum.OUTER_REF.getIndex()) || !(member instanceof ViewMember)) continue;
                Long _viewId = ((ViewMember)member).getViewId();
                ctMemberNumViewMap.put(member.getNumber(), _viewId);
                ctMemberIdViewMap.put(member.getId(), _viewId);
            }
        }
    }

    private boolean handleRuleBatchRelationRightRangeViewUpdate(boolean hasModelTrans, Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, boolean batchRelationHasSetView, RuleBatchPlanRowPojo ruleBatchPlanRowPojo, Map<String, String> ruleViewMap, Map<String, Long> ctMemberNumViewMap) {
        List rightRuleBatchPlanFormulaPojoList = ruleBatchPlanRowPojo.getRightRuleBatchPlanFormulaPojoList();
        if (CollectionUtils.isNotEmpty((Collection)rightRuleBatchPlanFormulaPojoList)) {
            for (RuleBatchPlanFormulaPojo ruleBatchPlanFormulaPojo : rightRuleBatchPlanFormulaPojoList) {
                for (RuleBatchPlanScopePojo ruleBatchPlanScopePojo : ruleBatchPlanFormulaPojo.getRuleBatchPlanScopePojoList()) {
                    String scopeDimensionNumberStr = ruleBatchPlanScopePojo.getDimensionNumberString();
                    if (View.NoViewDimNums.contains(scopeDimensionNumberStr)) continue;
                    for (MemberPojo memberPojo : ruleBatchPlanScopePojo.getMemberPojoList()) {
                        Long viewId = IDUtils.toLong((Object)memberPojo.getViewIdString());
                        String viewNumberString = memberPojo.getViewNumberString();
                        String viewNameString = memberPojo.getViewNameString();
                        View defaultView = defaultViewMap.get(scopeDimensionNumberStr);
                        Map<String, View> viewMapByNumber = tempDimViewMap.get(scopeDimensionNumberStr);
                        HashSet<Long> viewIdSet = new HashSet<Long>(16);
                        if (defaultView != null) {
                            viewIdSet.add(defaultView.getId());
                        }
                        if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                            Set collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                            viewIdSet.addAll(collect);
                        }
                        if (this.isCtDim(scopeDimensionNumberStr)) {
                            Long ctViewId = ctMemberNumViewMap.get(memberPojo.getMemberNumberString());
                            if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                            memberPojo.setViewIdString(IDUtils.toString((Object)ctViewId));
                            viewNameString = this.getViewNameByBusinessAndDim(ctViewId, viewNameString, viewMapByNumber);
                            memberPojo.setViewNameString(viewNameString);
                            viewNumberString = this.getViewNumberByBusinessAndDim(ctViewId, viewNumberString, viewMapByNumber);
                            memberPojo.setViewNumberString(viewNumberString);
                            batchRelationHasSetView = true;
                            this.putRuleViewMap(scopeDimensionNumberStr, ruleViewMap, viewNumberString);
                            continue;
                        }
                        if (hasModelTrans) {
                            if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                                if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumberString)) {
                                    View view = viewMapByNumber.get(viewNumberString);
                                    memberPojo.setViewIdString(IDUtils.toString((Object)view.getId()));
                                    batchRelationHasSetView = true;
                                    this.putRuleViewMap(scopeDimensionNumberStr, ruleViewMap, view.getNumber());
                                    continue;
                                }
                                if (defaultView == null) continue;
                                memberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                                memberPojo.setViewNameString(defaultView.getName());
                                memberPojo.setViewNumberString(defaultView.getNumber());
                                batchRelationHasSetView = true;
                                this.putRuleViewMap(scopeDimensionNumberStr, ruleViewMap, defaultView.getNumber());
                                continue;
                            }
                            if (defaultView == null) continue;
                            memberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                            memberPojo.setViewNameString(defaultView.getName());
                            memberPojo.setViewNumberString(defaultView.getNumber());
                            batchRelationHasSetView = true;
                            this.putRuleViewMap(scopeDimensionNumberStr, ruleViewMap, defaultView.getNumber());
                            continue;
                        }
                        if (defaultView != null && (IDUtils.isEmptyLong((Long)viewId).booleanValue() || !viewIdSet.contains(viewId))) {
                            memberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                            memberPojo.setViewNameString(defaultView.getName());
                            memberPojo.setViewNumberString(defaultView.getNumber());
                            batchRelationHasSetView = true;
                            this.putRuleViewMap(scopeDimensionNumberStr, ruleViewMap, defaultView.getNumber());
                            continue;
                        }
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumberString)) {
                            viewNumberString = this.getViewNumberByBusinessAndDim(viewId, viewNumberString, viewMapByNumber);
                            memberPojo.setViewNumberString(viewNumberString);
                            batchRelationHasSetView = true;
                        }
                        this.putRuleViewMap(scopeDimensionNumberStr, ruleViewMap, viewNumberString);
                    }
                }
            }
        }
        return batchRelationHasSetView;
    }

    private String getViewNumberByBusinessAndDim(Long viewId, String viewNumberString, Map<String, View> viewMapByNumber) {
        if (viewMapByNumber == null) {
            return "";
        }
        for (Map.Entry<String, View> entry : viewMapByNumber.entrySet()) {
            View view = entry.getValue();
            if (!view.getId().equals(viewId)) continue;
            viewNumberString = view.getNumber();
            break;
        }
        return viewNumberString;
    }

    private String getViewNameByBusinessAndDim(Long viewId, String viewNameString, Map<String, View> viewMapByNumber) {
        if (viewMapByNumber == null) {
            return "";
        }
        for (Map.Entry<String, View> entry : viewMapByNumber.entrySet()) {
            View view = entry.getValue();
            if (!view.getId().equals(viewId)) continue;
            viewNameString = view.getName();
            break;
        }
        return viewNameString;
    }

    private boolean handleRuleBatchRelationLeftRangeViewUpdate(boolean hasModelTrans, Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, boolean batchRelationHasSetView, RuleBatchPlanRowPojo ruleBatchPlanRowPojo, RuleManageRowPojo ruleManageRowPojo, IModelCacheHelper modelCacheHelper, Map<String, String> ruleViewMap, Map<String, Long> ctMemberNumViewMap) {
        Set<Object> individualRuleRangeDimSet = new HashSet(16);
        List individualRuleRangePojoList = ruleManageRowPojo.getIndividualRuleRangePojoList();
        if (CollectionUtils.isNotEmpty((Collection)individualRuleRangePojoList)) {
            individualRuleRangeDimSet = individualRuleRangePojoList.stream().map(RuleRangePojo::getNumberString).collect(Collectors.toSet());
        }
        HashSet<String> leftIndividualRuleRangeHasMemDimSet = new HashSet<String>(16);
        RuleBatchPlanFormulaPojo leftRuleBatchPlanFormulaPojo = ruleBatchPlanRowPojo.getLeftRuleBatchPlanFormulaPojo();
        List<RuleBatchPlanScopePojo> ruleBatchPlanScopePojoList = new ArrayList(16);
        if (leftRuleBatchPlanFormulaPojo != null) {
            ruleBatchPlanScopePojoList = leftRuleBatchPlanFormulaPojo.getRuleBatchPlanScopePojoList();
            for (RuleBatchPlanScopePojo ruleBatchPlanScopePojo : ruleBatchPlanScopePojoList) {
                String string = ruleBatchPlanScopePojo.getDimensionNumberString();
                leftIndividualRuleRangeHasMemDimSet.add(string);
                if (View.NoViewDimNums.contains(string)) continue;
                View defaultView = defaultViewMap.get(string);
                Map<String, View> viewMapByNumber = tempDimViewMap.get(string);
                HashSet<Long> viewIdSet = new HashSet<Long>(16);
                if (defaultView != null) {
                    viewIdSet.add(defaultView.getId());
                }
                if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                    Set collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                    viewIdSet.addAll(collect);
                }
                for (MemberPojo memberPojo : ruleBatchPlanScopePojo.getMemberPojoList()) {
                    Long viewId = IDUtils.toLong((Object)memberPojo.getViewIdString());
                    String viewNumberString = memberPojo.getViewNumberString();
                    String viewNameString = memberPojo.getViewNameString();
                    if (this.isCtDim(string)) {
                        Long ctViewId = ctMemberNumViewMap.get(memberPojo.getMemberNumberString());
                        if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                        memberPojo.setViewIdString(IDUtils.toString((Object)ctViewId));
                        viewNameString = this.getViewNameByBusinessAndDim(ctViewId, viewNameString, viewMapByNumber);
                        memberPojo.setViewNameString(viewNameString);
                        viewNumberString = this.getViewNumberByBusinessAndDim(ctViewId, viewNumberString, viewMapByNumber);
                        memberPojo.setViewNumberString(viewNumberString);
                        batchRelationHasSetView = true;
                        this.putRuleViewMap(string, ruleViewMap, viewNumberString);
                        continue;
                    }
                    if (hasModelTrans) {
                        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                            if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumberString)) {
                                View view = viewMapByNumber.get(viewNumberString);
                                memberPojo.setViewIdString(IDUtils.toString((Object)view.getId()));
                                batchRelationHasSetView = true;
                                this.putRuleViewMap(string, ruleViewMap, view.getNumber());
                                continue;
                            }
                            if (defaultView == null) continue;
                            memberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                            memberPojo.setViewNameString(defaultView.getName());
                            memberPojo.setViewNumberString(defaultView.getNumber());
                            batchRelationHasSetView = true;
                            this.putRuleViewMap(string, ruleViewMap, defaultView.getNumber());
                            continue;
                        }
                        if (defaultView == null) continue;
                        memberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                        memberPojo.setViewNameString(defaultView.getName());
                        memberPojo.setViewNumberString(defaultView.getNumber());
                        batchRelationHasSetView = true;
                        this.putRuleViewMap(string, ruleViewMap, defaultView.getNumber());
                        continue;
                    }
                    if (defaultView != null && (IDUtils.isEmptyLong((Long)viewId).booleanValue() || !viewIdSet.contains(viewId))) {
                        memberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                        memberPojo.setViewNameString(defaultView.getName());
                        memberPojo.setViewNumberString(defaultView.getNumber());
                        batchRelationHasSetView = true;
                        this.putRuleViewMap(string, ruleViewMap, defaultView.getNumber());
                        continue;
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumberString)) {
                        viewNumberString = this.getViewNumberByBusinessAndDim(viewId, viewNumberString, viewMapByNumber);
                        memberPojo.setViewNumberString(viewNumberString);
                        batchRelationHasSetView = true;
                    }
                    this.putRuleViewMap(string, ruleViewMap, viewNumberString);
                }
            }
        } else {
            leftRuleBatchPlanFormulaPojo = new RuleBatchPlanFormulaPojo();
        }
        individualRuleRangeDimSet.removeAll(leftIndividualRuleRangeHasMemDimSet);
        if (CollectionUtils.isNotEmpty(individualRuleRangeDimSet)) {
            HashSet cannotSelDimRootSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.InternalCompany.getNumber()});
            for (String string : individualRuleRangeDimSet) {
                if (View.NoViewDimNums.contains(string)) continue;
                batchRelationHasSetView = true;
                Long viewId = 0L;
                View view = defaultViewMap.get(string);
                if (view != null) {
                    viewId = view.getId();
                    this.putRuleViewMap(string, ruleViewMap, view.getNumber());
                }
                Dimension dimension = modelCacheHelper.getDimension(string);
                Member rootMember = modelCacheHelper.getRootMember(string, viewId);
                RuleBatchPlanScopePojo ruleBatchPlanScopePojo = new RuleBatchPlanScopePojo();
                ruleBatchPlanScopePojo.setDimensionNumberString(dimension.getNumber());
                ruleBatchPlanScopePojoList.add(ruleBatchPlanScopePojo);
                ArrayList<MemberPojo> memberPojoList = new ArrayList<MemberPojo>(16);
                ruleBatchPlanScopePojo.setMemberPojoList(memberPojoList);
                if (cannotSelDimRootSet.contains(string)) {
                    List members = modelCacheHelper.getMember(string, viewId, rootMember.getNumber(), 20);
                    if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                    for (Member member : members) {
                        this.addRuleBatchLeftIndMemberPojo2Scope(view, memberPojoList, member);
                    }
                    continue;
                }
                this.addRuleBatchLeftIndMemberPojo2Scope(view, memberPojoList, rootMember);
            }
            leftRuleBatchPlanFormulaPojo.setRuleBatchPlanScopePojoList(ruleBatchPlanScopePojoList);
            ruleBatchPlanRowPojo.setLeftRuleBatchPlanFormulaPojo(leftRuleBatchPlanFormulaPojo);
        }
        return batchRelationHasSetView;
    }

    private void addRuleBatchLeftIndMemberPojo2Scope(View view, List<MemberPojo> memberPojoList, Member member) {
        MemberPojo memberPojo = new MemberPojo();
        memberPojo.setMemberIdLong(member.getId());
        memberPojo.setMemberNameString(member.getName());
        memberPojo.setMemberNumberString(member.getNumber());
        memberPojo.setRangeString("ALL");
        memberPojo.setPropBoolean(Boolean.valueOf(false));
        memberPojo.setVariableBoolean(Boolean.valueOf(false));
        if (view != null) {
            memberPojo.setViewIdString(IDUtils.toString((Object)view.getId()));
            memberPojo.setViewNumberString(view.getNumber());
            memberPojo.setViewNameString(view.getName());
        }
        memberPojoList.add(memberPojo);
    }

    private boolean handleRuleBatchRuleRangeViewUpdate(boolean hasModelTrans, Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, boolean batchHasSetView, RuleManageRowPojo ruleManageRowPojo, IModelCacheHelper modelCacheHelper, Map<String, String> ruleViewMap, Map<String, Long> ctMemberNumViewMap, Long dataSet) {
        List individualRuleRangePojoList;
        Long viewId;
        List<RuleRangePojo> ruleRangePojoList = new ArrayList(16);
        Set<Object> useScopeDimNumSet = new HashSet(16);
        RuleRangMemberPojo accRuleRangeMember = null;
        if (CollectionUtils.isNotEmpty((Collection)ruleManageRowPojo.getRuleRangePojoList())) {
            ruleRangePojoList = ruleManageRowPojo.getRuleRangePojoList();
            useScopeDimNumSet = ruleRangePojoList.stream().map(RuleRangePojo::getNumberString).collect(Collectors.toSet());
            for (RuleRangePojo ruleRangePojo : ruleRangePojoList) {
                List removeRuleRangMemberPojoList;
                String dimNumStr = ruleRangePojo.getNumberString();
                List ruleRangMemberPojoList = ruleRangePojo.getRuleRangMemberPojoList();
                if (SysDimensionEnum.Account.getNumber().equals(dimNumStr) && CollectionUtils.isNotEmpty((Collection)ruleRangMemberPojoList)) {
                    accRuleRangeMember = (RuleRangMemberPojo)ruleRangMemberPojoList.get(0);
                }
                if (View.NoViewDimNums.contains(dimNumStr)) continue;
                View defaultView = defaultViewMap.get(dimNumStr);
                Map<String, View> viewMapByNumber = tempDimViewMap.get(dimNumStr);
                HashSet<Long> viewIdSet = new HashSet<Long>(16);
                if (defaultView != null) {
                    viewIdSet.add(defaultView.getId());
                }
                if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                    Set collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                    viewIdSet.addAll(collect);
                }
                if (CollectionUtils.isNotEmpty((Collection)ruleRangMemberPojoList)) {
                    for (RuleRangMemberPojo ruleRangMemberPojo : ruleRangMemberPojoList) {
                        Long viewId2 = IDUtils.toLong((Object)ruleRangMemberPojo.getViewIdString());
                        String viewNumberString = ruleRangMemberPojo.getViewNumberString();
                        String viewNameString = ruleRangMemberPojo.getViewNameString();
                        if (this.isCtDim(dimNumStr)) {
                            Long ctViewId = ctMemberNumViewMap.get(ruleRangMemberPojo.getNumberString());
                            if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                            ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)ctViewId));
                            viewNameString = this.getViewNameByBusinessAndDim(ctViewId, viewNameString, viewMapByNumber);
                            ruleRangMemberPojo.setViewNameString(viewNameString);
                            viewNumberString = this.getViewNumberByBusinessAndDim(ctViewId, viewNumberString, viewMapByNumber);
                            ruleRangMemberPojo.setViewNumberString(viewNumberString);
                            batchHasSetView = true;
                            this.putRuleViewMap(dimNumStr, ruleViewMap, viewNumberString);
                            continue;
                        }
                        if (hasModelTrans) {
                            if (IDUtils.isNotEmptyLong((Long)viewId2).booleanValue()) {
                                if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumberString)) {
                                    View view1 = viewMapByNumber.get(viewNumberString);
                                    ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)view1.getId()));
                                    ruleRangMemberPojo.setViewNameString(view1.getName());
                                    ruleRangMemberPojo.setViewNumberString(view1.getNumber());
                                    batchHasSetView = true;
                                    this.putRuleViewMap(dimNumStr, ruleViewMap, view1.getNumber());
                                    continue;
                                }
                                if (defaultView == null) continue;
                                ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                                ruleRangMemberPojo.setViewNameString(defaultView.getName());
                                ruleRangMemberPojo.setViewNumberString(defaultView.getNumber());
                                batchHasSetView = true;
                                this.putRuleViewMap(dimNumStr, ruleViewMap, defaultView.getNumber());
                                continue;
                            }
                            if (defaultView == null) continue;
                            ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                            ruleRangMemberPojo.setViewNameString(defaultView.getName());
                            ruleRangMemberPojo.setViewNumberString(defaultView.getNumber());
                            batchHasSetView = true;
                            this.putRuleViewMap(dimNumStr, ruleViewMap, defaultView.getNumber());
                            continue;
                        }
                        if (defaultView != null && (IDUtils.isEmptyLong((Long)viewId2).booleanValue() || !viewIdSet.contains(viewId2))) {
                            ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                            ruleRangMemberPojo.setViewNameString(defaultView.getName());
                            ruleRangMemberPojo.setViewNumberString(defaultView.getNumber());
                            batchHasSetView = true;
                            this.putRuleViewMap(dimNumStr, ruleViewMap, defaultView.getNumber());
                            continue;
                        }
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumberString)) {
                            viewNumberString = this.getViewNumberByBusinessAndDim(viewId2, viewNumberString, viewMapByNumber);
                            ruleRangMemberPojo.setViewNumberString(viewNumberString);
                            batchHasSetView = true;
                        }
                        this.putRuleViewMap(dimNumStr, ruleViewMap, viewNumberString);
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)(removeRuleRangMemberPojoList = ruleRangePojo.getRemoveRuleRangMemberPojoList()))) continue;
                for (RuleRangMemberPojo ruleRangMemberPojo : removeRuleRangMemberPojoList) {
                    viewId = IDUtils.toLong((Object)ruleRangMemberPojo.getViewIdString());
                    String viewNumberString = ruleRangMemberPojo.getViewNumberString();
                    String viewNameString = ruleRangMemberPojo.getViewNameString();
                    if (this.isCtDim(dimNumStr)) {
                        Long ctViewId = ctMemberNumViewMap.get(ruleRangMemberPojo.getNumberString());
                        if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                        ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)ctViewId));
                        viewNameString = this.getViewNameByBusinessAndDim(ctViewId, viewNameString, viewMapByNumber);
                        ruleRangMemberPojo.setViewNameString(viewNameString);
                        viewNumberString = this.getViewNumberByBusinessAndDim(ctViewId, viewNumberString, viewMapByNumber);
                        ruleRangMemberPojo.setViewNumberString(viewNumberString);
                        batchHasSetView = true;
                        this.putRuleViewMap(dimNumStr, ruleViewMap, viewNumberString);
                        continue;
                    }
                    if (hasModelTrans) {
                        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                            if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumberString)) {
                                View view1 = viewMapByNumber.get(viewNumberString);
                                ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)view1.getId()));
                                ruleRangMemberPojo.setViewNumberString(view1.getNumber());
                                ruleRangMemberPojo.setViewNameString(view1.getNumber());
                                batchHasSetView = true;
                                this.putRuleViewMap(dimNumStr, ruleViewMap, view1.getNumber());
                                continue;
                            }
                            if (defaultView == null) continue;
                            ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                            ruleRangMemberPojo.setViewNameString(defaultView.getName());
                            ruleRangMemberPojo.setViewNumberString(defaultView.getNumber());
                            batchHasSetView = true;
                            this.putRuleViewMap(dimNumStr, ruleViewMap, defaultView.getNumber());
                            continue;
                        }
                        if (defaultView == null) continue;
                        ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                        ruleRangMemberPojo.setViewNameString(defaultView.getName());
                        ruleRangMemberPojo.setViewNumberString(defaultView.getNumber());
                        batchHasSetView = true;
                        this.putRuleViewMap(dimNumStr, ruleViewMap, defaultView.getNumber());
                        continue;
                    }
                    if (defaultView != null && (IDUtils.isEmptyLong((Long)viewId).booleanValue() || !viewIdSet.contains(viewId))) {
                        ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)defaultView.getId()));
                        ruleRangMemberPojo.setViewNameString(defaultView.getName());
                        ruleRangMemberPojo.setViewNumberString(defaultView.getNumber());
                        batchHasSetView = true;
                        this.putRuleViewMap(dimNumStr, ruleViewMap, defaultView.getNumber());
                        continue;
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumberString)) {
                        viewNumberString = this.getViewNumberByBusinessAndDim(viewId, viewNumberString, viewMapByNumber);
                        ruleRangMemberPojo.setViewNumberString(viewNumberString);
                        batchHasSetView = true;
                    }
                    this.putRuleViewMap(dimNumStr, ruleViewMap, viewNumberString);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(individualRuleRangePojoList = ruleManageRowPojo.getIndividualRuleRangePojoList()))) {
            useScopeDimNumSet.addAll(individualRuleRangePojoList.stream().map(RuleRangePojo::getNumberString).collect(Collectors.toSet()));
        }
        FormulaPojo firstFormulaPojo = this.getFirstFormulaPojoByBatchRule(ruleManageRowPojo);
        String accountNumber = "";
        if (accRuleRangeMember != null) {
            accountNumber = accRuleRangeMember.getNumberString();
        } else if (firstFormulaPojo != null) {
            accountNumber = firstFormulaPojo.getNumberString();
        }
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
        Long datasetId = dataSet;
        if (accountMember != null) {
            datasetId = accountMember.getDatasetId();
        }
        String dimensionNumberString = ruleManageRowPojo.getDimensionNumberString();
        Set dimNumSet = modelCacheHelper.getDimensionList(datasetId).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        HashSet cannotSelDimRootSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.InternalCompany.getNumber()});
        for (String dimNum : dimNumSet) {
            if (dimensionNumberString.equals(dimNum) || useScopeDimNumSet.contains(dimNum) || View.NoViewDimNums.contains(dimNum)) continue;
            batchHasSetView = true;
            viewId = 0L;
            View view = defaultViewMap.get(dimNum);
            if (view != null) {
                viewId = view.getId();
                this.putRuleViewMap(dimNum, ruleViewMap, view.getNumber());
            }
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            Member rootMember = modelCacheHelper.getRootMember(dimNum, viewId);
            RuleRangePojo ruleRangePojo = new RuleRangePojo();
            ruleRangePojo.setIdString(dimension.getId().toString());
            ruleRangePojo.setNameString(dimension.getName());
            ruleRangePojo.setNumberString(dimension.getNumber());
            ruleRangePojoList.add(ruleRangePojo);
            ArrayList<RuleRangMemberPojo> ruleRangMemberPojoList = new ArrayList<RuleRangMemberPojo>(16);
            ruleRangePojo.setRuleRangMemberPojoList(ruleRangMemberPojoList);
            if (cannotSelDimRootSet.contains(dimNum)) {
                List members = modelCacheHelper.getMember(dimNum, viewId, rootMember.getNumber(), 20);
                if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                for (int i = 0; i < members.size(); ++i) {
                    Member member = (Member)members.get(i);
                    boolean hasViewName = i == 0;
                    this.addRangMemberPojo2Scope(view, ruleRangMemberPojoList, member, hasViewName);
                }
                continue;
            }
            this.addRangMemberPojo2Scope(view, ruleRangMemberPojoList, rootMember, true);
        }
        ruleManageRowPojo.setRuleRangePojoList(ruleRangePojoList);
        return batchHasSetView;
    }

    private void addRangMemberPojo2Scope(View view, List<RuleRangMemberPojo> ruleRangMemberPojoList, Member member, boolean hasViewName) {
        RuleRangMemberPojo ruleRangMemberPojo = new RuleRangMemberPojo();
        ruleRangMemberPojo.setIdString(ObjUtils.getString((Object)member.getId()));
        ruleRangMemberPojo.setNameString(member.getName());
        ruleRangMemberPojo.setNumberString(member.getNumber());
        ruleRangMemberPojo.setShowNumberString(member.getShowNumber());
        RangeEnum allRangeEnum = RangeEnum.ALL;
        ruleRangMemberPojo.setScopeString(String.valueOf(allRangeEnum.getIndex()));
        ruleRangMemberPojo.setRangEnumNumberString(allRangeEnum.getNumber());
        ruleRangMemberPojo.setRangEnumNameString(allRangeEnum.getName());
        ruleRangMemberPojo.setHasAggBoolean(Boolean.valueOf(member.hasAgg()));
        if (view != null) {
            ruleRangMemberPojo.setViewIdString(IDUtils.toString((Object)view.getId()));
            ruleRangMemberPojo.setViewNumberString(view.getNumber());
            if (hasViewName) {
                ruleRangMemberPojo.setViewNameString(view.getName());
            }
        }
        ruleRangMemberPojoList.add(ruleRangMemberPojo);
    }

    private boolean handleRuleBatchFormulaPojoListViewUpdate(boolean hasModelTrans, IModelCacheHelper modelCacheHelper, Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, boolean batchHasSetView, RuleManageRowPojo ruleManageRowPojo, String mainDimNumber, View mainDimDefaultView, Map<String, View> mainViewMapByNumber, boolean mainDimHasView, Map<String, String> ruleViewMap, Map<String, Long> ctMemberNumViewMap, Map<Long, Long> ctMemberIdViewMap) {
        HashMap<Integer, FormulaPojo> replaceRuleFuncMap = new HashMap<Integer, FormulaPojo>(16);
        List formulaPojoList = ruleManageRowPojo.getFormulaPojoList();
        if (CollectionUtils.isNotEmpty((Collection)formulaPojoList)) {
            HashSet<Long> mainViewIdSet = new HashSet<Long>(16);
            if (mainDimDefaultView != null) {
                mainViewIdSet.add(mainDimDefaultView.getId());
            }
            if (mainViewMapByNumber != null && !mainViewMapByNumber.isEmpty()) {
                Set collect = mainViewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                mainViewIdSet.addAll(collect);
            }
            for (int i = 0; i < formulaPojoList.size(); ++i) {
                Set collect;
                FormulaPojo formulaPojo = (FormulaPojo)formulaPojoList.get(i);
                String typeString = formulaPojo.getTypeString();
                Long viewId = IDUtils.toLong((Object)formulaPojo.getViewIdString());
                String viewNumberString = formulaPojo.getViewNumberString();
                if (typeString.equals("member")) {
                    if (this.isCtDim(mainDimNumber)) {
                        String numberString = formulaPojo.getNumberString();
                        Long ctViewId = ctMemberNumViewMap.get(numberString);
                        if (IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) {
                            formulaPojo.setViewIdString(IDUtils.toString((Object)ctViewId));
                            viewNumberString = this.getViewNumberByBusinessAndDim(ctViewId, viewNumberString, mainViewMapByNumber);
                            formulaPojo.setViewNumberString(viewNumberString);
                            batchHasSetView = true;
                            this.putRuleViewMap(mainDimNumber, ruleViewMap, viewNumberString);
                        }
                    } else if (hasModelTrans) {
                        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                            if (mainViewMapByNumber != null && mainViewMapByNumber.containsKey(viewNumberString)) {
                                View view = mainViewMapByNumber.get(viewNumberString);
                                formulaPojo.setViewIdString(IDUtils.toString((Object)view.getId()));
                                batchHasSetView = true;
                                this.putRuleViewMap(mainDimNumber, ruleViewMap, view.getNumber());
                            } else if (mainDimDefaultView != null) {
                                formulaPojo.setViewIdString(IDUtils.toString((Object)mainDimDefaultView.getId()));
                                formulaPojo.setViewNumberString(mainDimDefaultView.getNumber());
                                batchHasSetView = true;
                                this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
                            }
                        } else if (mainDimDefaultView != null) {
                            formulaPojo.setViewIdString(IDUtils.toString((Object)mainDimDefaultView.getId()));
                            formulaPojo.setViewNumberString(mainDimDefaultView.getNumber());
                            batchHasSetView = true;
                            this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
                        }
                    } else if (mainDimHasView && mainDimDefaultView != null && (IDUtils.isEmptyLong((Long)viewId).booleanValue() || !mainViewIdSet.contains(viewId))) {
                        formulaPojo.setViewIdString(IDUtils.toString((Object)mainDimDefaultView.getId()));
                        formulaPojo.setViewNumberString(mainDimDefaultView.getNumber());
                        batchHasSetView = true;
                        this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
                    } else if (!View.NoViewDimNums.contains(mainDimNumber)) {
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumberString)) {
                            viewNumberString = this.getViewNumberByBusinessAndDim(viewId, viewNumberString, mainViewMapByNumber);
                            formulaPojo.setViewNumberString(viewNumberString);
                            batchHasSetView = true;
                        }
                        this.putRuleViewMap(mainDimNumber, ruleViewMap, viewNumberString);
                    }
                    List notMainMemberList = formulaPojo.getNotMainMemberList();
                    if (!CollectionUtils.isNotEmpty((Collection)notMainMemberList)) continue;
                    for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                        String dimNumber = formulaMembPojo.getDimNumber();
                        if (View.NoViewDimNums.contains(dimNumber)) continue;
                        View view = defaultViewMap.get(dimNumber);
                        Map<String, View> viewMapByNumber = tempDimViewMap.get(dimNumber);
                        HashSet<Long> viewIdSet = new HashSet<Long>(16);
                        if (view != null) {
                            viewIdSet.add(view.getId());
                        }
                        if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                            collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                            viewIdSet.addAll(collect);
                        }
                        Long notMainViewId = IDUtils.toLong((Object)formulaMembPojo.getViewIdString());
                        Object _viewNumberString = formulaMembPojo.getViewNumberString();
                        String _viewNameString = formulaMembPojo.getViewNameString();
                        if (this.isCtDim(dimNumber)) {
                            Long ctViewId = ctMemberNumViewMap.get(formulaMembPojo.getNumberString());
                            if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                            formulaMembPojo.setViewIdString(IDUtils.toString((Object)ctViewId));
                            _viewNumberString = this.getViewNumberByBusinessAndDim(ctViewId, (String)_viewNumberString, viewMapByNumber);
                            _viewNameString = this.getViewNameByBusinessAndDim(ctViewId, _viewNameString, viewMapByNumber);
                            formulaMembPojo.setViewNumberString((String)_viewNumberString);
                            formulaMembPojo.setViewNameString(_viewNameString);
                            batchHasSetView = true;
                            this.putRuleViewMap(dimNumber, ruleViewMap, (String)_viewNumberString);
                            continue;
                        }
                        if (hasModelTrans) {
                            if (IDUtils.isNotEmptyLong((Long)notMainViewId).booleanValue()) {
                                if (viewMapByNumber != null && viewMapByNumber.containsKey(_viewNumberString)) {
                                    View view1 = viewMapByNumber.get(_viewNumberString);
                                    formulaMembPojo.setViewIdString(IDUtils.toString((Object)view1.getId()));
                                    formulaMembPojo.setViewNameString(view1.getName());
                                    batchHasSetView = true;
                                    this.putRuleViewMap(dimNumber, ruleViewMap, view1.getNumber());
                                    continue;
                                }
                                if (view == null) continue;
                                formulaMembPojo.setViewIdString(IDUtils.toString((Object)view.getId()));
                                formulaMembPojo.setViewNumberString(view.getNumber());
                                formulaMembPojo.setViewNameString(view.getName());
                                batchHasSetView = true;
                                this.putRuleViewMap(dimNumber, ruleViewMap, view.getNumber());
                                continue;
                            }
                            if (view == null) continue;
                            formulaMembPojo.setViewIdString(IDUtils.toString((Object)view.getId()));
                            formulaMembPojo.setViewNumberString(view.getNumber());
                            formulaMembPojo.setViewNameString(view.getName());
                            batchHasSetView = true;
                            this.putRuleViewMap(dimNumber, ruleViewMap, view.getNumber());
                            continue;
                        }
                        if ((IDUtils.isEmptyLong((Long)notMainViewId).booleanValue() || !viewIdSet.contains(notMainViewId)) && view != null) {
                            formulaMembPojo.setViewIdString(IDUtils.toString((Object)view.getId()));
                            formulaMembPojo.setViewNumberString(view.getNumber());
                            formulaMembPojo.setViewNameString(view.getName());
                            batchHasSetView = true;
                            this.putRuleViewMap(dimNumber, ruleViewMap, view.getNumber());
                            continue;
                        }
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)_viewNumberString)) {
                            _viewNumberString = this.getViewNumberByBusinessAndDim(notMainViewId, (String)_viewNumberString, viewMapByNumber);
                            formulaMembPojo.setViewNumberString((String)_viewNumberString);
                            batchHasSetView = true;
                        }
                        this.putRuleViewMap(dimNumber, ruleViewMap, (String)_viewNumberString);
                    }
                    continue;
                }
                if (!typeString.equals("function")) continue;
                IRuleFunction ruleFunction = RuleRelationService.functionFormulaPojoToRuleFunction(modelCacheHelper, formulaPojo);
                String functionName = ruleFunction.getFunctionName();
                Map allValues = ruleFunction.getAllValues();
                if (RuleFunctionEnum.isYearValueFunction((String)functionName) || RuleFunctionEnum.isFIFunction((String)functionName)) {
                    if (allValues.containsKey(FunctionItemEnum.ACCOUNT.getKey())) {
                        String accountStr = (String)allValues.get(FunctionItemEnum.ACCOUNT.getKey());
                        FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)SerializationUtils.fromJsonString((String)accountStr, FormulaMemberPojo.class);
                        Long mainViewId = formulaMemberPojo.getMainViewId();
                        String mainViewNumber = formulaMemberPojo.getMainViewNumber();
                        if (this.isCtDim(mainDimNumber)) {
                            Long ctViewId = ctMemberIdViewMap.get(formulaMemberPojo.getMainDimMemberId());
                            if (IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) {
                                formulaMemberPojo.setMainViewId(ctViewId);
                                mainViewNumber = this.getViewNumberByBusinessAndDim(ctViewId, mainViewNumber, mainViewMapByNumber);
                                formulaMemberPojo.setMainViewNumber(mainViewNumber);
                                batchHasSetView = true;
                                this.putRuleViewMap(mainDimNumber, ruleViewMap, mainViewNumber);
                            }
                        } else if (hasModelTrans) {
                            if (IDUtils.isNotEmptyLong((Long)mainViewId).booleanValue()) {
                                if (mainViewMapByNumber != null && mainViewMapByNumber.containsKey(mainViewNumber)) {
                                    View view = mainViewMapByNumber.get(mainViewNumber);
                                    formulaMemberPojo.setMainViewId(view.getId());
                                    batchHasSetView = true;
                                    this.putRuleViewMap(mainDimNumber, ruleViewMap, view.getNumber());
                                } else if (mainDimDefaultView != null) {
                                    formulaMemberPojo.setMainViewId(mainDimDefaultView.getId());
                                    formulaMemberPojo.setMainViewNumber(mainDimDefaultView.getNumber());
                                    batchHasSetView = true;
                                    this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
                                }
                            } else if (mainDimDefaultView != null) {
                                formulaMemberPojo.setMainViewId(mainDimDefaultView.getId());
                                formulaMemberPojo.setMainViewNumber(mainDimDefaultView.getNumber());
                                batchHasSetView = true;
                                this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
                            }
                        } else if (!(View.NoViewDimNums.contains(mainDimNumber) || mainDimDefaultView == null || !IDUtils.isEmptyLong((Long)mainViewId).booleanValue() && mainViewIdSet.contains(mainViewId))) {
                            formulaMemberPojo.setMainViewId(mainDimDefaultView.getId());
                            formulaMemberPojo.setMainViewNumber(mainDimDefaultView.getNumber());
                            batchHasSetView = true;
                            this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
                        } else if (!View.NoViewDimNums.contains(mainDimNumber)) {
                            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mainViewNumber)) {
                                mainViewNumber = this.getViewNumberByBusinessAndDim(mainViewId, mainViewNumber, mainViewMapByNumber);
                                formulaMemberPojo.setMainViewNumber(mainViewNumber);
                                batchHasSetView = true;
                            }
                            this.putRuleViewMap(mainDimNumber, ruleViewMap, mainViewNumber);
                        }
                        List refDimMembers = formulaMemberPojo.getRefDimMembers();
                        if (CollectionUtils.isNotEmpty((Collection)refDimMembers)) {
                            for (DimMemberPojo refDimMember : refDimMembers) {
                                String refDimNumber = refDimMember.getDimNumber();
                                Long refDimViewId = refDimMember.getViewId();
                                String viewNumber = refDimMember.getViewNumber();
                                View refDefaultView = defaultViewMap.get(refDimNumber);
                                Map<String, View> viewMapByNumber = tempDimViewMap.get(refDimNumber);
                                HashSet<Long> refViewIdSet = new HashSet<Long>(16);
                                if (refDefaultView != null) {
                                    refViewIdSet.add(refDefaultView.getId());
                                }
                                if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                                    Set collect2 = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                                    refViewIdSet.addAll(collect2);
                                }
                                if (this.isCtDim(refDimNumber)) {
                                    Long ctViewId = ctMemberNumViewMap.get(refDimMember.getNumber());
                                    if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                                    refDimMember.setViewId(ctViewId);
                                    viewNumber = this.getViewNumberByBusinessAndDim(ctViewId, viewNumber, viewMapByNumber);
                                    refDimMember.setViewNumber(viewNumber);
                                    batchHasSetView = true;
                                    this.putRuleViewMap(refDimNumber, ruleViewMap, viewNumber);
                                    continue;
                                }
                                if (hasModelTrans) {
                                    if (IDUtils.isNotEmptyLong((Long)refDimViewId).booleanValue()) {
                                        if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumber)) {
                                            View view = viewMapByNumber.get(viewNumber);
                                            refDimMember.setViewId(view.getId());
                                            batchHasSetView = true;
                                            this.putRuleViewMap(refDimNumber, ruleViewMap, view.getNumber());
                                            continue;
                                        }
                                        if (refDefaultView == null) continue;
                                        refDimMember.setViewId(refDefaultView.getId());
                                        refDimMember.setViewNumber(refDefaultView.getNumber());
                                        batchHasSetView = true;
                                        this.putRuleViewMap(refDimNumber, ruleViewMap, refDefaultView.getNumber());
                                        continue;
                                    }
                                    if (refDefaultView == null) continue;
                                    refDimMember.setViewId(refDefaultView.getId());
                                    refDimMember.setViewNumber(refDefaultView.getNumber());
                                    batchHasSetView = true;
                                    this.putRuleViewMap(refDimNumber, ruleViewMap, refDefaultView.getNumber());
                                    continue;
                                }
                                if (!(View.NoViewDimNums.contains(refDimNumber) || refDefaultView == null || !IDUtils.isEmptyLong((Long)refDimViewId).booleanValue() && refViewIdSet.contains(refDimViewId))) {
                                    refDimMember.setViewId(refDefaultView.getId());
                                    refDimMember.setViewNumber(refDefaultView.getNumber());
                                    batchHasSetView = true;
                                    this.putRuleViewMap(refDimNumber, ruleViewMap, refDefaultView.getNumber());
                                    continue;
                                }
                                if (View.NoViewDimNums.contains(refDimNumber)) continue;
                                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumber)) {
                                    viewNumber = this.getViewNumberByBusinessAndDim(refDimViewId, viewNumber, viewMapByNumber);
                                    refDimMember.setViewNumber(viewNumber);
                                    batchHasSetView = true;
                                }
                                this.putRuleViewMap(refDimNumber, ruleViewMap, viewNumber);
                            }
                        }
                        allValues.put(FunctionItemEnum.ACCOUNT.getKey(), SerializationUtils.toJsonString((Object)formulaMemberPojo));
                    }
                    if (allValues.containsKey(FunctionItemEnum.RELATIONFUN.getKey())) {
                        String relationStr = (String)allValues.get(FunctionItemEnum.RELATIONFUN.getKey());
                        RuleFunction relFunction = RuleFunctionFactory.fromJsonString((String)relationStr);
                        Map relAllValues = relFunction.getAllValues();
                        String relDimNum = (String)relAllValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
                        if (!View.NoViewDimNums.contains(relDimNum)) {
                            String funcItemKey = FunctionItemEnum.RELATIONFUN.getKey();
                            batchHasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, allValues, funcItemKey, relAllValues, relDimNum, relFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
                        }
                        allValues.put(FunctionItemEnum.RELATIONFUN.getKey(), SerializationUtils.toJsonString((Object)relFunction));
                    }
                } else {
                    Map childAllValues;
                    RuleFunction childRelFunction;
                    String dimNum = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dimNum) || View.NoViewDimNums.contains(dimNum)) continue;
                    if (!allValues.containsKey("childIsFun")) {
                        HashSet<Long> viewIdSet = new HashSet<Long>(16);
                        View funcDefaultView = defaultViewMap.get(dimNum);
                        Map<String, View> viewMapByNumber = tempDimViewMap.get(dimNum);
                        if (funcDefaultView != null) {
                            viewIdSet.add(funcDefaultView.getId());
                        }
                        if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                            collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                            viewIdSet.addAll(collect);
                        }
                        Long allValViewId = IDUtils.toLong(allValues.get("allvals_view_id"));
                        String viewNumber = (String)allValues.get("allvals_view_number");
                        Long resultViewId = allValViewId;
                        String resultViewNum = "";
                        if (this.isCtDim(dimNum)) {
                            Long ctViewId;
                            String dimMemberRange;
                            List memberConditionList;
                            String memberNum = "";
                            if (allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey())) {
                                String dimMember;
                                memberNum = dimMember = (String)allValues.get(FunctionItemEnum.DIMEMBER.getKey());
                                if (dimMember.contains(",")) {
                                    String[] split = dimMember.split(",");
                                    memberNum = split[0];
                                }
                            }
                            if (allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey()) && CollectionUtils.isNotEmpty((Collection)(memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)(dimMemberRange = (String)allValues.get(FunctionItemEnum.DIMEMBERRANGE.getKey())))))) {
                                memberNum = ((MemberCondition)memberConditionList.get(0)).getNumber();
                            }
                            if (IDUtils.isNotEmptyLong((Long)(ctViewId = ctMemberNumViewMap.get(memberNum))).booleanValue()) {
                                resultViewId = ctViewId;
                                resultViewNum = this.getViewNumberByBusinessAndDim(ctViewId, resultViewNum, viewMapByNumber);
                                allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                                allValues.put("allvals_view_number", resultViewNum);
                                batchHasSetView = true;
                                this.putRuleViewMap(dimNum, ruleViewMap, resultViewNum);
                            }
                        } else if (hasModelTrans) {
                            if (allValues.containsKey("allvals_view_id") && IDUtils.isNotEmptyLong((Long)allValViewId).booleanValue()) {
                                if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumber)) {
                                    View view = viewMapByNumber.get(viewNumber);
                                    resultViewId = view.getId();
                                    resultViewNum = view.getNumber();
                                    allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                                    batchHasSetView = true;
                                    this.putRuleViewMap(dimNum, ruleViewMap, view.getNumber());
                                } else if (funcDefaultView != null) {
                                    resultViewId = funcDefaultView.getId();
                                    resultViewNum = funcDefaultView.getNumber();
                                    allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                                    allValues.put("allvals_view_number", funcDefaultView.getNumber());
                                    batchHasSetView = true;
                                    this.putRuleViewMap(dimNum, ruleViewMap, funcDefaultView.getNumber());
                                }
                            } else if (funcDefaultView != null) {
                                resultViewId = funcDefaultView.getId();
                                resultViewNum = funcDefaultView.getNumber();
                                allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                                allValues.put("allvals_view_number", funcDefaultView.getNumber());
                                batchHasSetView = true;
                                this.putRuleViewMap(dimNum, ruleViewMap, funcDefaultView.getNumber());
                            }
                        } else if (!(allValues.containsKey("allvals_view_id") && !IDUtils.isEmptyLong((Long)allValViewId).booleanValue() && viewIdSet.contains(allValViewId) || funcDefaultView == null)) {
                            resultViewId = funcDefaultView.getId();
                            resultViewNum = funcDefaultView.getNumber();
                            allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                            allValues.put("allvals_view_number", funcDefaultView.getNumber());
                            batchHasSetView = true;
                            this.putRuleViewMap(dimNum, ruleViewMap, funcDefaultView.getNumber());
                        }
                        batchHasSetView = this.checkFuncDimMemRangeView(batchHasSetView, allValues, resultViewId);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)resultViewNum)) {
                            this.putRuleViewMap(dimNum, ruleViewMap, resultViewNum);
                        }
                    } else if (allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey())) {
                        String dimMemberStr = (String)allValues.get(FunctionItemEnum.DIMEMBER.getKey());
                        childRelFunction = RuleFunctionFactory.fromJsonString((String)dimMemberStr);
                        childAllValues = childRelFunction.getAllValues();
                        batchHasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, allValues, FunctionItemEnum.DIMEMBER.getKey(), childAllValues, dimNum, childRelFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
                        allValues.put(FunctionItemEnum.DIMEMBER.getKey(), SerializationUtils.toJsonString((Object)childRelFunction));
                    } else if (allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey())) {
                        String dimMemberRangeStr = (String)allValues.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
                        childRelFunction = RuleFunctionFactory.fromJsonString((String)dimMemberRangeStr);
                        childAllValues = childRelFunction.getAllValues();
                        batchHasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, allValues, FunctionItemEnum.DIMEMBERRANGE.getKey(), childAllValues, dimNum, childRelFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
                        allValues.put(FunctionItemEnum.DIMEMBERRANGE.getKey(), SerializationUtils.toJsonString((Object)childRelFunction));
                    }
                    if (allValues.containsKey("childIsFunByAttributeVal") && allValues.containsKey(FunctionItemEnum.ATTRIBUTEVAL.getKey())) {
                        String attributeValStr = (String)allValues.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
                        childRelFunction = RuleFunctionFactory.fromJsonString((String)attributeValStr);
                        childAllValues = childRelFunction.getAllValues();
                        batchHasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, allValues, FunctionItemEnum.ATTRIBUTEVAL.getKey(), childAllValues, dimNum, childRelFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
                        allValues.put(FunctionItemEnum.ATTRIBUTEVAL.getKey(), SerializationUtils.toJsonString((Object)childRelFunction));
                    }
                }
                replaceRuleFuncMap.put(i, RuleRelationService.ruleFunctionToFunctionFormulaPojo(modelCacheHelper, ruleFunction));
            }
        }
        for (Map.Entry formulaPojoEntry : replaceRuleFuncMap.entrySet()) {
            formulaPojoList.set((Integer)formulaPojoEntry.getKey(), formulaPojoEntry.getValue());
        }
        return batchHasSetView;
    }

    private FormulaPojo getFirstFormulaPojoByBatchRule(RuleManageRowPojo ruleManageRowPojo) {
        if (!ruleManageRowPojo.getDimensionNumberString().equals(SysDimensionEnum.Account.getNumber())) {
            return null;
        }
        FormulaPojo firstFormulaPojo = new FormulaPojo();
        List formulaPojoList = ruleManageRowPojo.getFormulaPojoList();
        if (CollectionUtils.isNotEmpty((Collection)formulaPojoList)) {
            firstFormulaPojo = (FormulaPojo)formulaPojoList.get(0);
        }
        return firstFormulaPojo;
    }

    private boolean handleRuleBatchMainViewUpdate(boolean hasModelTrans, boolean batchHasSetView, RuleManageRowPojo ruleManageRowPojo, View mainDimDefaultView, Map<String, View> mainViewMapByNumber, boolean mainDimHasView, String mainDimNumber, Map<String, String> ruleViewMap) {
        HashSet<Long> viewIdSet = new HashSet<Long>(16);
        if (mainDimDefaultView != null) {
            viewIdSet.add(mainDimDefaultView.getId());
        }
        if (mainViewMapByNumber != null && !mainViewMapByNumber.isEmpty()) {
            Set collect = mainViewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
            viewIdSet.addAll(collect);
        }
        Long mainDimView = IDUtils.toLong((Object)ruleManageRowPojo.getMainDimViewIdString());
        String mainDimViewNumberString = ruleManageRowPojo.getMainDimViewNumberString();
        if (hasModelTrans) {
            if (IDUtils.isNotEmptyLong((Long)mainDimView).booleanValue()) {
                if (mainViewMapByNumber != null && mainViewMapByNumber.containsKey(mainDimViewNumberString)) {
                    View view = mainViewMapByNumber.get(mainDimViewNumberString);
                    ruleManageRowPojo.setMainDimViewIdString(IDUtils.toString((Object)view.getId()));
                    batchHasSetView = true;
                    this.putRuleViewMap(mainDimNumber, ruleViewMap, view.getNumber());
                } else if (mainDimDefaultView != null) {
                    ruleManageRowPojo.setMainDimViewIdString(IDUtils.toString((Object)mainDimDefaultView.getId()));
                    ruleManageRowPojo.setMainDimViewNumberString(mainDimDefaultView.getNumber());
                    batchHasSetView = true;
                    this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
                }
            } else if (mainDimDefaultView != null) {
                ruleManageRowPojo.setMainDimViewIdString(IDUtils.toString((Object)mainDimDefaultView.getId()));
                ruleManageRowPojo.setMainDimViewNumberString(mainDimDefaultView.getNumber());
                batchHasSetView = true;
                this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
            }
        } else if (mainDimHasView && mainDimDefaultView != null && (IDUtils.isEmptyLong((Long)mainDimView).booleanValue() || !viewIdSet.contains(mainDimView))) {
            ruleManageRowPojo.setMainDimViewIdString(IDUtils.toString((Object)mainDimDefaultView.getId()));
            ruleManageRowPojo.setMainDimViewNumberString(mainDimDefaultView.getNumber());
            batchHasSetView = true;
            this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
        } else if (!View.NoViewDimNums.contains(mainDimNumber)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mainDimViewNumberString)) {
                mainDimViewNumberString = this.getViewNumberByBusinessAndDim(mainDimView, mainDimViewNumberString, mainViewMapByNumber);
                ruleManageRowPojo.setMainDimViewNumberString(mainDimViewNumberString);
                batchHasSetView = true;
            }
            this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimViewNumberString);
        }
        return batchHasSetView;
    }

    private void handleRuleAccViewUpdate(boolean hasModelTrans, List<Object[]> ruleAccValues, Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, List<Map<String, Object>> ruleAccList, Map<String, String> ruleViewMap, Map<String, Long> ctMemberNumViewMap) {
        boolean accHasSetView = false;
        if (CollectionUtils.isNotEmpty(ruleAccList)) {
            for (Map<String, Object> ruleAcc : ruleAccList) {
                String dimensionJsonFix = (String)ruleAcc.get("fdimenstionjsonfix");
                List formulaMemberDtoList = JSON.parseArray((String)dimensionJsonFix, FormulaMemberDto.class);
                for (FormulaMemberDto formulaMemberDto : formulaMemberDtoList) {
                    String dimNumber = formulaMemberDto.getDimNumber();
                    if (View.NoViewDimNums.contains(dimNumber) || formulaMemberDto.getVariable().booleanValue()) continue;
                    Long viewIdLong = formulaMemberDto.getViewId();
                    String viewNumber = formulaMemberDto.getViewNumber();
                    View defaultView = defaultViewMap.get(dimNumber);
                    Map<String, View> viewMapByNumber = tempDimViewMap.get(dimNumber);
                    HashSet<Long> viewIdSet = new HashSet<Long>(16);
                    if (defaultView != null) {
                        viewIdSet.add(defaultView.getId());
                    }
                    if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                        Set collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                        viewIdSet.addAll(collect);
                    }
                    if (this.isCtDim(dimNumber)) {
                        String number = formulaMemberDto.getNumber();
                        Long ctViewId = ctMemberNumViewMap.get(number);
                        if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                        formulaMemberDto.setViewId(ctViewId);
                        viewNumber = this.getViewNumberByBusinessAndDim(ctViewId, viewNumber, viewMapByNumber);
                        formulaMemberDto.setViewNumber(viewNumber);
                        accHasSetView = true;
                        this.putRuleViewMap(dimNumber, ruleViewMap, viewNumber);
                        continue;
                    }
                    if (hasModelTrans) {
                        if (IDUtils.isNotEmptyLong((Long)viewIdLong).booleanValue()) {
                            if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumber)) {
                                View view = viewMapByNumber.get(viewNumber);
                                formulaMemberDto.setViewId(view.getId());
                                accHasSetView = true;
                                this.putRuleViewMap(dimNumber, ruleViewMap, view.getNumber());
                                continue;
                            }
                            if (defaultView == null) continue;
                            formulaMemberDto.setViewId(defaultView.getId());
                            formulaMemberDto.setViewNumber(defaultView.getNumber());
                            accHasSetView = true;
                            this.putRuleViewMap(dimNumber, ruleViewMap, defaultView.getNumber());
                            continue;
                        }
                        if (defaultView == null) continue;
                        formulaMemberDto.setViewId(defaultView.getId());
                        formulaMemberDto.setViewNumber(defaultView.getNumber());
                        accHasSetView = true;
                        this.putRuleViewMap(dimNumber, ruleViewMap, defaultView.getNumber());
                        continue;
                    }
                    if ((IDUtils.isEmptyLong((Long)viewIdLong).booleanValue() || !viewIdSet.contains(viewIdLong)) && defaultView != null) {
                        formulaMemberDto.setViewId(defaultView.getId());
                        formulaMemberDto.setViewNumber(defaultView.getNumber());
                        accHasSetView = true;
                        this.putRuleViewMap(dimNumber, ruleViewMap, defaultView.getNumber());
                        continue;
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumber)) {
                        viewNumber = this.getViewNumberByBusinessAndDim(viewIdLong, viewNumber, viewMapByNumber);
                        formulaMemberDto.setViewNumber(viewNumber);
                        accHasSetView = true;
                    }
                    this.putRuleViewMap(dimNumber, ruleViewMap, viewNumber);
                }
                if (!accHasSetView) continue;
                Object[] oneRowRuleAccVal = new Object[2];
                oneRowRuleAccVal[1] = (Long)ruleAcc.get("fpkid");
                oneRowRuleAccVal[0] = JSON.toJSONString((Object)formulaMemberDtoList);
                ruleAccValues.add(oneRowRuleAccVal);
            }
        }
    }

    private FormulaMemberDto getFirstFormulaMemberByRule(List<Map<String, Object>> ruleAccList, String mainDimNumber) {
        FormulaMemberDto firstFormulaMemberDto = new FormulaMemberDto();
        if (CollectionUtils.isNotEmpty(ruleAccList)) {
            block0: for (Map<String, Object> ruleAcc : ruleAccList) {
                String dimensionJsonFix = (String)ruleAcc.get("fdimenstionjsonfix");
                String isLeft = (String)ruleAcc.get("fisleft");
                boolean isLeftFlag = "1".equals(isLeft);
                List formulaMemberDtoList = JSON.parseArray((String)dimensionJsonFix, FormulaMemberDto.class);
                for (FormulaMemberDto formulaMemberDto : formulaMemberDtoList) {
                    String dimNumber = formulaMemberDto.getDimNumber();
                    if (!isLeftFlag || !dimNumber.equals(mainDimNumber)) continue;
                    firstFormulaMemberDto = formulaMemberDto;
                    continue block0;
                }
            }
        }
        return firstFormulaMemberDto;
    }

    private void handleRuleRangeViewUpdate(boolean hasModelTrans, List<Object[]> ruleValues, Long ruleId, Map<String, Object> rule, Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, IModelCacheHelper modelCacheHelper, FormulaMemberDto firstFormulaMember, Map<String, String> ruleViewMap, String mainDimNumber, Map<String, Long> ctMemberNumViewMap) {
        String useScope = (String)rule.get("fusescope");
        ArrayList<FormulaCondition> useScopeList = JSON.parseArray((String)useScope, FormulaCondition.class);
        Set<Object> useScopeDimNumSet = new HashSet(16);
        boolean scopeHasSetView = false;
        FormulaCondition accFormulaCondition = null;
        if (CollectionUtils.isNotEmpty((Collection)useScopeList)) {
            useScopeDimNumSet = useScopeList.stream().map(FormulaCondition::getDimensionNumber).collect(Collectors.toSet());
            for (FormulaCondition formulaCondition : useScopeList) {
                Map<String, View> viewMapByNumber;
                String dimensionNumber = formulaCondition.getDimensionNumber();
                if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                    accFormulaCondition = formulaCondition;
                }
                if (View.NoViewDimNums.contains(dimensionNumber)) continue;
                List memberList = formulaCondition.getMemberList();
                HashSet<Long> viewIdSet = new HashSet<Long>(16);
                View view = defaultViewMap.get(dimensionNumber);
                if (view != null) {
                    viewIdSet.add(view.getId());
                }
                if ((viewMapByNumber = tempDimViewMap.get(dimensionNumber)) != null && !viewMapByNumber.isEmpty()) {
                    Set collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                    viewIdSet.addAll(collect);
                }
                if (!CollectionUtils.isNotEmpty((Collection)memberList)) continue;
                for (kd.epm.eb.common.f7.MemberCondition memberCondition : memberList) {
                    if (memberCondition.isVariable()) continue;
                    Long viewIdLong = IDUtils.toLong((Object)memberCondition.getViewIdLong());
                    String viewNumber = memberCondition.getViewNumber();
                    if (this.isCtDim(dimensionNumber)) {
                        String number = memberCondition.getNumber();
                        Long ctViewId = ctMemberNumViewMap.get(number);
                        if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                        memberCondition.setViewIdLong(ctViewId);
                        viewNumber = this.getViewNumberByBusinessAndDim(ctViewId, viewNumber, viewMapByNumber);
                        memberCondition.setViewNumber(viewNumber);
                        scopeHasSetView = true;
                        this.putRuleViewMap(dimensionNumber, ruleViewMap, viewNumber);
                        continue;
                    }
                    if (hasModelTrans) {
                        if (IDUtils.isNotEmptyLong((Long)viewIdLong).booleanValue()) {
                            if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumber)) {
                                View view1 = viewMapByNumber.get(viewNumber);
                                memberCondition.setViewIdLong(view1.getId());
                                scopeHasSetView = true;
                                this.putRuleViewMap(dimensionNumber, ruleViewMap, view1.getNumber());
                                continue;
                            }
                            if (view == null) continue;
                            memberCondition.setViewIdLong(view.getId());
                            memberCondition.setViewNumber(view.getNumber());
                            scopeHasSetView = true;
                            this.putRuleViewMap(dimensionNumber, ruleViewMap, view.getNumber());
                            continue;
                        }
                        if (view == null) continue;
                        memberCondition.setViewIdLong(view.getId());
                        memberCondition.setViewNumber(view.getNumber());
                        scopeHasSetView = true;
                        this.putRuleViewMap(dimensionNumber, ruleViewMap, view.getNumber());
                        continue;
                    }
                    if (view != null && (IDUtils.isEmptyLong((Long)viewIdLong).booleanValue() || !viewIdSet.contains(viewIdLong))) {
                        memberCondition.setViewIdLong(view.getId());
                        memberCondition.setViewNumber(view.getNumber());
                        scopeHasSetView = true;
                        this.putRuleViewMap(dimensionNumber, ruleViewMap, view.getNumber());
                        continue;
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumber)) {
                        viewNumber = this.getViewNumberByBusinessAndDim(viewIdLong, viewNumber, viewMapByNumber);
                        memberCondition.setViewNumber(viewNumber);
                        scopeHasSetView = true;
                    }
                    this.putRuleViewMap(dimensionNumber, ruleViewMap, viewNumber);
                }
            }
        } else {
            useScopeList = new ArrayList<FormulaCondition>(16);
        }
        String accountNumber = "";
        if (accFormulaCondition != null) {
            kd.epm.eb.common.f7.MemberCondition memberCondition = (kd.epm.eb.common.f7.MemberCondition)accFormulaCondition.getMemberList().get(0);
            accountNumber = memberCondition.getNumber();
        } else if (firstFormulaMember != null) {
            accountNumber = firstFormulaMember.getNumber();
        }
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
        if (accountMember != null) {
            Set dimNumSet = modelCacheHelper.getDimensionList(accountMember.getDatasetId()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            HashSet cannotSelDimRootSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.InternalCompany.getNumber()});
            for (String dimNum : dimNumSet) {
                if (mainDimNumber.equals(dimNum) || useScopeDimNumSet.contains(dimNum) || View.NoViewDimNums.contains(dimNum)) continue;
                scopeHasSetView = true;
                Long viewId = 0L;
                View view = defaultViewMap.get(dimNum);
                if (view != null) {
                    viewId = view.getId();
                    this.putRuleViewMap(dimNum, ruleViewMap, view.getNumber());
                }
                Dimension dimension = modelCacheHelper.getDimension(dimNum);
                Member rootMember = modelCacheHelper.getRootMember(dimNum, viewId);
                FormulaCondition formulaCondition = new FormulaCondition();
                useScopeList.add(formulaCondition);
                formulaCondition.setDimension(dimension.getId());
                formulaCondition.setDimensionNumber(dimension.getNumber());
                formulaCondition.setDimShortNumber(dimension.getShortNumber());
                ArrayList<kd.epm.eb.common.f7.MemberCondition> memberConditionList = new ArrayList<kd.epm.eb.common.f7.MemberCondition>(16);
                formulaCondition.setMemberList(memberConditionList);
                if (cannotSelDimRootSet.contains(dimNum)) {
                    List members = modelCacheHelper.getMember(dimNum, viewId, rootMember.getNumber(), 20);
                    if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                    for (Member member : members) {
                        this.addMemberCondition2Scope(view, memberConditionList, member);
                    }
                    continue;
                }
                this.addMemberCondition2Scope(view, memberConditionList, rootMember);
            }
        }
        if (scopeHasSetView) {
            Object[] oneRowRuleVal = new Object[2];
            oneRowRuleVal[1] = ruleId;
            oneRowRuleVal[0] = JSON.toJSONString(useScopeList);
            ruleValues.add(oneRowRuleVal);
        }
    }

    private boolean isCtDim(String dimensionNumber) {
        return SysDimensionEnum.ChangeType.getNumber().equals(dimensionNumber);
    }

    private void addMemberCondition2Scope(View view, List<kd.epm.eb.common.f7.MemberCondition> memberConditionList, Member member) {
        kd.epm.eb.common.f7.MemberCondition memberCondition = new kd.epm.eb.common.f7.MemberCondition();
        memberConditionList.add(memberCondition);
        memberCondition.setId(member.getId());
        memberCondition.setNumber(member.getNumber());
        memberCondition.setName(member.getName());
        memberCondition.setLongnumber(member.getLongNumber());
        memberCondition.setRange(RangeEnum.ALL.getIndex() + "");
        if (view != null) {
            memberCondition.setViewIdLong(view.getId());
            memberCondition.setViewNumber(view.getNumber());
        }
    }

    private void handleRuleFunctionViewUpdate(boolean hasModelTrans, List<Object[]> ruleFuncValues, String mainDimNumber, Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, List<Map<String, Object>> ruleFuncList, Map<String, String> ruleViewMap, Map<String, Long> ctMemberNumViewMap, Map<Long, Long> ctMemberIdViewMap) {
        View mainDimDefaultView = defaultViewMap.get(mainDimNumber);
        Map<String, View> mainDimViewMapByNumber = tempDimViewMap.get(mainDimNumber);
        HashSet<Long> mainViewIdSet = new HashSet<Long>(16);
        if (mainDimDefaultView != null) {
            mainViewIdSet.add(mainDimDefaultView.getId());
        }
        if (mainDimViewMapByNumber != null && !mainDimViewMapByNumber.isEmpty()) {
            Set collect = mainDimViewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
            mainViewIdSet.addAll(collect);
        }
        if (CollectionUtils.isNotEmpty(ruleFuncList)) {
            for (Map<String, Object> ruleFunc : ruleFuncList) {
                boolean funcHasSetView = false;
                String functionType = (String)ruleFunc.get("ffunctiontype");
                String functionInfoStr = (String)ruleFunc.get("ffunctioninfostr");
                Map allValues = (Map)SerializationUtils.fromJsonString((String)functionInfoStr, Map.class);
                if (RuleFunctionEnum.isYearValueFunction((String)functionType) || RuleFunctionEnum.isFIFunction((String)functionType)) {
                    String returnPeriodKey;
                    String accountKey = FunctionItemEnum.ACCOUNT.getKey();
                    if (allValues.containsKey(accountKey)) {
                        funcHasSetView = this.handleAccountOrReturnPeriodKey(hasModelTrans, mainDimNumber, defaultViewMap, tempDimViewMap, ruleViewMap, ctMemberNumViewMap, ctMemberIdViewMap, mainDimDefaultView, mainDimViewMapByNumber, mainViewIdSet, funcHasSetView, allValues, accountKey);
                    }
                    if (allValues.containsKey(returnPeriodKey = FunctionItemEnum.RETURNPERIOD.getKey())) {
                        funcHasSetView = this.handleAccountOrReturnPeriodKey(hasModelTrans, mainDimNumber, defaultViewMap, tempDimViewMap, ruleViewMap, ctMemberNumViewMap, ctMemberIdViewMap, mainDimDefaultView, mainDimViewMapByNumber, mainViewIdSet, funcHasSetView, allValues, returnPeriodKey);
                    }
                    if (allValues.containsKey(FunctionItemEnum.RELATIONFUN.getKey())) {
                        String relationStr = (String)allValues.get(FunctionItemEnum.RELATIONFUN.getKey());
                        RuleFunction relFunction = RuleFunctionFactory.fromJsonString((String)relationStr);
                        Map relAllValues = relFunction.getAllValues();
                        String relDimNum = (String)relAllValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
                        if (!View.NoViewDimNums.contains(relDimNum)) {
                            String funcItemKey = FunctionItemEnum.RELATIONFUN.getKey();
                            funcHasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, allValues, funcItemKey, relAllValues, relDimNum, relFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
                        }
                        allValues.put(FunctionItemEnum.RELATIONFUN.getKey(), SerializationUtils.toJsonString((Object)relFunction));
                    }
                } else {
                    Map childAllValues;
                    RuleFunction childRelFunction;
                    String dimNum = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dimNum) || View.NoViewDimNums.contains(dimNum)) continue;
                    if (!allValues.containsKey("childIsFun")) {
                        Long allValViewId;
                        View funcDefaultView = defaultViewMap.get(dimNum);
                        Map<String, View> viewMapByNumber = tempDimViewMap.get(dimNum);
                        HashSet<Long> funcViewIdSet = new HashSet<Long>(16);
                        if (funcDefaultView != null) {
                            funcViewIdSet.add(funcDefaultView.getId());
                        }
                        if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                            Set collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                            funcViewIdSet.addAll(collect);
                        }
                        Long resultViewId = allValViewId = IDUtils.toLong(allValues.get("allvals_view_id"));
                        String resultViewNum = "";
                        String viewNumber = (String)allValues.get("allvals_view_number");
                        if (this.isCtDim(dimNum)) {
                            Long ctViewId;
                            String dimMemberRange;
                            List memberConditionList;
                            String memberNum = "";
                            if (allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey())) {
                                String dimMember;
                                memberNum = dimMember = (String)allValues.get(FunctionItemEnum.DIMEMBER.getKey());
                                if (dimMember.contains(",")) {
                                    String[] split = dimMember.split(",");
                                    memberNum = split[0];
                                }
                            }
                            if (allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey()) && CollectionUtils.isNotEmpty((Collection)(memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)(dimMemberRange = (String)allValues.get(FunctionItemEnum.DIMEMBERRANGE.getKey())))))) {
                                memberNum = ((MemberCondition)memberConditionList.get(0)).getNumber();
                            }
                            if (IDUtils.isNotEmptyLong((Long)(ctViewId = ctMemberNumViewMap.get(memberNum))).booleanValue()) {
                                resultViewId = ctViewId;
                                resultViewNum = this.getViewNumberByBusinessAndDim(ctViewId, resultViewNum, viewMapByNumber);
                                allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                                allValues.put("allvals_view_number", resultViewNum);
                                funcHasSetView = true;
                                this.putRuleViewMap(dimNum, ruleViewMap, resultViewNum);
                            }
                        } else if (hasModelTrans) {
                            if (allValues.containsKey("allvals_view_id") && IDUtils.isNotEmptyLong((Long)allValViewId).booleanValue()) {
                                if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumber)) {
                                    View view = viewMapByNumber.get(viewNumber);
                                    resultViewId = view.getId();
                                    resultViewNum = view.getNumber();
                                    allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                                    funcHasSetView = true;
                                    this.putRuleViewMap(dimNum, ruleViewMap, viewNumber);
                                } else if (funcDefaultView != null) {
                                    resultViewId = funcDefaultView.getId();
                                    resultViewNum = funcDefaultView.getNumber();
                                    allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                                    allValues.put("allvals_view_number", funcDefaultView.getNumber());
                                    funcHasSetView = true;
                                    this.putRuleViewMap(dimNum, ruleViewMap, funcDefaultView.getNumber());
                                }
                            } else if (funcDefaultView != null) {
                                resultViewId = funcDefaultView.getId();
                                resultViewNum = funcDefaultView.getNumber();
                                allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                                allValues.put("allvals_view_number", funcDefaultView.getNumber());
                                funcHasSetView = true;
                                this.putRuleViewMap(dimNum, ruleViewMap, funcDefaultView.getNumber());
                            }
                        } else if (!(allValues.containsKey("allvals_view_id") && !IDUtils.isEmptyLong((Long)allValViewId).booleanValue() && funcViewIdSet.contains(allValViewId) || funcDefaultView == null)) {
                            resultViewId = funcDefaultView.getId();
                            resultViewNum = funcDefaultView.getNumber();
                            allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                            allValues.put("allvals_view_number", funcDefaultView.getNumber());
                            funcHasSetView = true;
                            this.putRuleViewMap(dimNum, ruleViewMap, funcDefaultView.getNumber());
                        } else {
                            this.putRuleViewMap(dimNum, ruleViewMap, viewNumber);
                        }
                        funcHasSetView = this.checkFuncDimMemRangeView(funcHasSetView, allValues, resultViewId);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)resultViewNum)) {
                            this.putRuleViewMap(dimNum, ruleViewMap, resultViewNum);
                        }
                    } else if (allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey())) {
                        String dimMemberStr = (String)allValues.get(FunctionItemEnum.DIMEMBER.getKey());
                        childRelFunction = RuleFunctionFactory.fromJsonString((String)dimMemberStr);
                        childAllValues = childRelFunction.getAllValues();
                        funcHasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, allValues, FunctionItemEnum.DIMEMBER.getKey(), childAllValues, dimNum, childRelFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
                        allValues.put(FunctionItemEnum.DIMEMBER.getKey(), SerializationUtils.toJsonString((Object)childRelFunction));
                    } else if (allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey())) {
                        String dimMemberRangeStr = (String)allValues.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
                        childRelFunction = RuleFunctionFactory.fromJsonString((String)dimMemberRangeStr);
                        childAllValues = childRelFunction.getAllValues();
                        funcHasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, allValues, FunctionItemEnum.DIMEMBERRANGE.getKey(), childAllValues, dimNum, childRelFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
                        allValues.put(FunctionItemEnum.DIMEMBERRANGE.getKey(), SerializationUtils.toJsonString((Object)childRelFunction));
                    }
                    if (allValues.containsKey("childIsFunByAttributeVal") && allValues.containsKey(FunctionItemEnum.ATTRIBUTEVAL.getKey())) {
                        String attributeStr = (String)allValues.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
                        childRelFunction = RuleFunctionFactory.fromJsonString((String)attributeStr);
                        childAllValues = childRelFunction.getAllValues();
                        funcHasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, allValues, FunctionItemEnum.ATTRIBUTEVAL.getKey(), childAllValues, dimNum, childRelFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
                        allValues.put(FunctionItemEnum.ATTRIBUTEVAL.getKey(), SerializationUtils.toJsonString((Object)childRelFunction));
                    }
                }
                if (!funcHasSetView) continue;
                Object[] oneRowRuleFuncVal = new Object[2];
                oneRowRuleFuncVal[1] = (Long)ruleFunc.get("fid");
                oneRowRuleFuncVal[0] = JsonUtils.getJsonString((Object)allValues);
                ruleFuncValues.add(oneRowRuleFuncVal);
            }
        }
    }

    private boolean handleAccountOrReturnPeriodKey(boolean hasModelTrans, String mainDimNumber, Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, Map<String, String> ruleViewMap, Map<String, Long> ctMemberNumViewMap, Map<Long, Long> ctMemberIdViewMap, View mainDimDefaultView, Map<String, View> mainDimViewMapByNumber, Set<Long> mainViewIdSet, boolean funcHasSetView, Map<String, Object> allValues, String accountKey) {
        String accountStr = (String)allValues.get(accountKey);
        FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)SerializationUtils.fromJsonString((String)accountStr, FormulaMemberPojo.class);
        Long mainViewId = formulaMemberPojo.getMainViewId();
        String mainViewNumber = formulaMemberPojo.getMainViewNumber();
        if (this.isCtDim(mainDimNumber)) {
            Long mainDimMemberId = formulaMemberPojo.getMainDimMemberId();
            Long ctViewId = ctMemberIdViewMap.get(mainDimMemberId);
            if (IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) {
                mainViewNumber = this.getViewNumberByBusinessAndDim(ctViewId, mainViewNumber, mainDimViewMapByNumber);
                formulaMemberPojo.setMainViewId(ctViewId);
                formulaMemberPojo.setMainViewNumber(mainViewNumber);
                funcHasSetView = true;
                this.putRuleViewMap(mainDimNumber, ruleViewMap, mainViewNumber);
            }
        } else if (hasModelTrans) {
            if (IDUtils.isNotEmptyLong((Long)mainViewId).booleanValue()) {
                if (mainDimViewMapByNumber != null && mainDimViewMapByNumber.containsKey(mainViewNumber)) {
                    View view = mainDimViewMapByNumber.get(mainViewNumber);
                    formulaMemberPojo.setMainViewId(view.getId());
                    funcHasSetView = true;
                    this.putRuleViewMap(mainDimNumber, ruleViewMap, view.getNumber());
                } else if (mainDimDefaultView != null) {
                    formulaMemberPojo.setMainViewId(mainDimDefaultView.getId());
                    formulaMemberPojo.setMainViewNumber(mainDimDefaultView.getNumber());
                    funcHasSetView = true;
                    this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
                }
            } else if (mainDimDefaultView != null) {
                formulaMemberPojo.setMainViewId(mainDimDefaultView.getId());
                formulaMemberPojo.setMainViewNumber(mainDimDefaultView.getNumber());
                funcHasSetView = true;
                this.putRuleViewMap(mainDimNumber, ruleViewMap, mainDimDefaultView.getNumber());
            }
        } else if (!(View.NoViewDimNums.contains(mainDimNumber) || mainDimDefaultView == null || !IDUtils.isEmptyLong((Long)mainViewId).booleanValue() && mainViewIdSet.contains(mainViewId))) {
            formulaMemberPojo.setMainViewId(mainDimDefaultView.getId());
            formulaMemberPojo.setMainViewNumber(mainDimDefaultView.getNumber());
            funcHasSetView = true;
            ruleViewMap.put(mainDimNumber, mainDimDefaultView.getNumber());
        } else if (!View.NoViewDimNums.contains(mainDimNumber)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mainViewNumber)) {
                mainViewNumber = this.getViewNumberByBusinessAndDim(mainViewId, mainViewNumber, mainDimViewMapByNumber);
                formulaMemberPojo.setMainViewNumber(mainViewNumber);
                funcHasSetView = true;
            }
            this.putRuleViewMap(mainDimNumber, ruleViewMap, mainViewNumber);
        }
        List refDimMembers = formulaMemberPojo.getRefDimMembers();
        if (CollectionUtils.isNotEmpty((Collection)refDimMembers)) {
            for (DimMemberPojo refDimMember : refDimMembers) {
                String refDimNumber = refDimMember.getDimNumber();
                Long viewId = refDimMember.getViewId();
                String viewNumber = refDimMember.getViewNumber();
                View refDefaultView = defaultViewMap.get(refDimNumber);
                Map<String, View> viewMapByNumber = tempDimViewMap.get(refDimNumber);
                HashSet<Long> refViewIdSet = new HashSet<Long>(16);
                if (refDefaultView != null) {
                    refViewIdSet.add(refDefaultView.getId());
                }
                if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                    Set collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                    refViewIdSet.addAll(collect);
                }
                if (this.isCtDim(refDimNumber)) {
                    Long ctViewId = ctMemberNumViewMap.get(refDimMember.getNumber());
                    if (!IDUtils.isNotEmptyLong((Long)ctViewId).booleanValue()) continue;
                    viewNumber = this.getViewNumberByBusinessAndDim(ctViewId, viewNumber, viewMapByNumber);
                    refDimMember.setViewNumber(viewNumber);
                    refDimMember.setViewId(ctViewId);
                    funcHasSetView = true;
                    this.putRuleViewMap(refDimNumber, ruleViewMap, viewNumber);
                    continue;
                }
                if (hasModelTrans) {
                    if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
                        if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumber)) {
                            View view = viewMapByNumber.get(viewNumber);
                            refDimMember.setViewId(view.getId());
                            funcHasSetView = true;
                            this.putRuleViewMap(refDimNumber, ruleViewMap, view.getNumber());
                            continue;
                        }
                        if (refDefaultView == null) continue;
                        refDimMember.setViewId(refDefaultView.getId());
                        refDimMember.setViewNumber(refDefaultView.getNumber());
                        funcHasSetView = true;
                        this.putRuleViewMap(refDimNumber, ruleViewMap, refDefaultView.getNumber());
                        continue;
                    }
                    if (refDefaultView == null) continue;
                    refDimMember.setViewId(refDefaultView.getId());
                    refDimMember.setViewNumber(refDefaultView.getNumber());
                    funcHasSetView = true;
                    this.putRuleViewMap(refDimNumber, ruleViewMap, refDefaultView.getNumber());
                    continue;
                }
                if (!(View.NoViewDimNums.contains(refDimNumber) || refDefaultView == null || !IDUtils.isEmptyLong((Long)viewId).booleanValue() && refViewIdSet.contains(viewId))) {
                    refDimMember.setViewId(refDefaultView.getId());
                    refDimMember.setViewNumber(refDefaultView.getNumber());
                    funcHasSetView = true;
                    continue;
                }
                if (View.NoViewDimNums.contains(viewNumber)) continue;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)viewNumber)) {
                    viewNumber = this.getViewNumberByBusinessAndDim(viewId, viewNumber, viewMapByNumber);
                    refDimMember.setViewNumber(viewNumber);
                    funcHasSetView = true;
                }
                this.putRuleViewMap(refDimNumber, ruleViewMap, viewNumber);
            }
        }
        allValues.put(accountKey, SerializationUtils.toJsonString((Object)formulaMemberPojo));
        return funcHasSetView;
    }

    private void putRuleViewMap(String dimNum, Map<String, String> ruleViewMap, String viewNum) {
        ruleViewMap.put(dimNum, viewNum);
    }

    private boolean checkFuncDimMemRangeView(boolean funcHasSetView, Map<String, Object> allValues, Long resultViewId) {
        String dimMemberStr;
        if (allValues == null || allValues.isEmpty()) {
            return funcHasSetView;
        }
        if (allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(dimMemberStr = (String)allValues.get(FunctionItemEnum.DIMEMBERRANGE.getKey())))) {
            List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)dimMemberStr);
            if (CollectionUtils.isNotEmpty((Collection)memberConditionList)) {
                for (MemberCondition memberCondition : memberConditionList) {
                    Long viewId = IDUtils.toLong((Object)memberCondition.getViewId());
                    if (viewId.equals(resultViewId)) continue;
                    memberCondition.setViewId(IDUtils.toString((Object)resultViewId));
                    funcHasSetView = true;
                }
            }
            allValues.put(FunctionItemEnum.DIMEMBERRANGE.getKey(), SerializationUtils.serializeToBase64((Object)memberConditionList));
        }
        return funcHasSetView;
    }

    private void getBusinessModelView(IModelCacheHelper modelCacheHelper, DynamicObjectCollection businessModels, Map<Long, Map<String, View>> businessDefaultViewMap, Map<Long, Map<String, Map<String, View>>> businessDimViewsMap) {
        for (DynamicObject businessModel : businessModels) {
            long businessModelLong = businessModel.getLong("id");
            Map views = modelCacheHelper.getViewGroupViewsByBusModel(Long.valueOf(businessModelLong));
            List dimensionList = modelCacheHelper.getDimensionListByBusModel(Long.valueOf(businessModelLong));
            for (Dimension dimension : dimensionList) {
                List viewList;
                Map viewMap;
                View view;
                Long defaultViewId = modelCacheHelper.getViewByBusModelAndDimNumber(Long.valueOf(businessModelLong), dimension.getNumber());
                if (IDUtils.isNotEmptyLong((Long)defaultViewId).booleanValue() && (view = dimension.getView(defaultViewId)) != null) {
                    viewMap = businessDefaultViewMap.computeIfAbsent(businessModelLong, k -> Maps.newHashMapWithExpectedSize((int)16));
                    viewMap.put(dimension.getNumber(), view);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(viewList = (List)views.get(dimension.getNumber())))) continue;
                for (Long viewId : viewList) {
                    View view2 = dimension.getView(viewId);
                    if (view2 == null) continue;
                    Map dimViewMap = businessDimViewsMap.computeIfAbsent(businessModelLong, k -> Maps.newHashMapWithExpectedSize((int)16));
                    viewMap = dimViewMap.computeIfAbsent(dimension.getNumber(), k -> Maps.newHashMapWithExpectedSize((int)16));
                    viewMap.put(view2.getNumber(), view2);
                }
            }
        }
    }

    private boolean checkChildFuncView(Map<String, View> defaultViewMap, Map<String, Map<String, View>> tempDimViewMap, Map<String, Object> values, String funcItemKey, Map<String, Object> allValues, String funcDimNum, RuleFunction relFunction, boolean hasModelTrans, Map<String, String> ruleViewMap, Map<String, Long> ctMemberNumViewMap) {
        boolean hasSetView = false;
        String relDimNum = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)relDimNum) || View.NoViewDimNums.contains(relDimNum)) {
            return false;
        }
        if (!allValues.containsKey("childIsFun")) {
            Long allValViewId;
            View funcDefaultView = defaultViewMap.get(funcDimNum);
            Map<String, View> viewMapByNumber = tempDimViewMap.get(relDimNum);
            HashSet<Long> viewIdSet = new HashSet<Long>(16);
            if (funcDefaultView != null) {
                viewIdSet.add(funcDefaultView.getId());
            }
            if (viewMapByNumber != null && !viewMapByNumber.isEmpty()) {
                Set collect = viewMapByNumber.values().stream().map(BaseCache::getId).collect(Collectors.toSet());
                viewIdSet.addAll(collect);
            }
            Long resultViewId = allValViewId = IDUtils.toLong((Object)allValues.get("allvals_view_id"));
            String resultViewNumber = "";
            String viewNumber = (String)allValues.get("allvals_view_number");
            if (this.isCtDim(relDimNum)) {
                Long ctViewId;
                String dimMemberRange;
                List memberConditionList;
                String memberNum = "";
                if (allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey())) {
                    String dimMember;
                    memberNum = dimMember = (String)allValues.get(FunctionItemEnum.DIMEMBER.getKey());
                    if (dimMember.contains(",")) {
                        String[] split = dimMember.split(",");
                        memberNum = split[0];
                    }
                }
                if (allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey()) && CollectionUtils.isNotEmpty((Collection)(memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)(dimMemberRange = (String)allValues.get(FunctionItemEnum.DIMEMBERRANGE.getKey())))))) {
                    memberNum = ((MemberCondition)memberConditionList.get(0)).getNumber();
                }
                if (IDUtils.isNotEmptyLong((Long)(ctViewId = ctMemberNumViewMap.get(memberNum))).booleanValue()) {
                    resultViewId = ctViewId;
                    resultViewNumber = this.getViewNumberByBusinessAndDim(ctViewId, resultViewNumber, viewMapByNumber);
                    allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                    allValues.put("allvals_view_number", resultViewNumber);
                    hasSetView = true;
                    this.putRuleViewMap(relDimNum, ruleViewMap, resultViewNumber);
                    values.put(funcItemKey, JsonUtils.getJsonString((Object)relFunction));
                }
            } else if (hasModelTrans) {
                if (allValues.containsKey("allvals_view_id") && IDUtils.isNotEmptyLong((Long)allValViewId).booleanValue()) {
                    if (viewMapByNumber != null && viewMapByNumber.containsKey(viewNumber)) {
                        View view = viewMapByNumber.get(viewNumber);
                        resultViewId = view.getId();
                        resultViewNumber = view.getNumber();
                        allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                        hasSetView = true;
                        this.putRuleViewMap(relDimNum, ruleViewMap, viewNumber);
                    } else if (funcDefaultView != null) {
                        resultViewId = funcDefaultView.getId();
                        resultViewNumber = funcDefaultView.getNumber();
                        allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                        allValues.put("allvals_view_number", funcDefaultView.getNumber());
                        hasSetView = true;
                        this.putRuleViewMap(relDimNum, ruleViewMap, funcDefaultView.getNumber());
                    }
                } else if (funcDefaultView != null) {
                    resultViewId = funcDefaultView.getId();
                    resultViewNumber = funcDefaultView.getNumber();
                    allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                    allValues.put("allvals_view_number", funcDefaultView.getNumber());
                    hasSetView = true;
                    this.putRuleViewMap(relDimNum, ruleViewMap, funcDefaultView.getNumber());
                }
                values.put(funcItemKey, JsonUtils.getJsonString((Object)relFunction));
            } else if (!(allValues.containsKey("allvals_view_id") && !IDUtils.isEmptyLong((Long)allValViewId).booleanValue() && viewIdSet.contains(allValViewId) || funcDefaultView == null)) {
                resultViewId = funcDefaultView.getId();
                resultViewNumber = funcDefaultView.getNumber();
                allValues.put("allvals_view_id", IDUtils.toString((Object)resultViewId));
                allValues.put("allvals_view_number", funcDefaultView.getNumber());
                values.put(funcItemKey, JsonUtils.getJsonString((Object)relFunction));
                hasSetView = true;
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)viewNumber)) {
                this.putRuleViewMap(relDimNum, ruleViewMap, viewNumber);
            }
            hasSetView = this.checkFuncDimMemRangeView(hasSetView, allValues, resultViewId);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)resultViewNumber)) {
                this.putRuleViewMap(relDimNum, ruleViewMap, resultViewNumber);
            }
        } else if (allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey())) {
            String dimMemberStr = (String)allValues.get(FunctionItemEnum.DIMEMBER.getKey());
            RuleFunction childRelFunction = RuleFunctionFactory.fromJsonString((String)dimMemberStr);
            Map childAllValues = childRelFunction.getAllValues();
            hasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, relFunction.getAllValues(), FunctionItemEnum.DIMEMBER.getKey(), childAllValues, relDimNum, childRelFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
            allValues.put(FunctionItemEnum.DIMEMBER.getKey(), SerializationUtils.toJsonString((Object)childRelFunction));
        } else if (allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey())) {
            String dimMemberRangeStr = (String)allValues.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
            RuleFunction childRelFunction = RuleFunctionFactory.fromJsonString((String)dimMemberRangeStr);
            Map childAllValues = childRelFunction.getAllValues();
            hasSetView = this.checkChildFuncView(defaultViewMap, tempDimViewMap, relFunction.getAllValues(), FunctionItemEnum.DIMEMBERRANGE.getKey(), childAllValues, relDimNum, childRelFunction, hasModelTrans, ruleViewMap, ctMemberNumViewMap);
            allValues.put(FunctionItemEnum.DIMEMBERRANGE.getKey(), SerializationUtils.toJsonString((Object)childRelFunction));
        }
        return hasSetView;
    }

    public static FormulaPojo ruleFunctionToFunctionFormulaPojo(IModelCacheHelper modelCache, IRuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        RuleFunctionEnum functionEunm = RuleFunctionEnum.getFunctionEnumByName((String)functionName);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("kd.epm.eb.formplugin.rulemanage.functionEdit.convert." + functionEunm.getShortName() + "FunctionConvert");
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod("convertToFormulaPojo", IModelCacheHelper.class, IRuleFunction.class);
            Object returnz = method.invoke(instance, modelCache, ruleFunction);
            return (FormulaPojo)returnz;
        }
        catch (Exception e) {
            log.error("convertToFormulaPojo:", (Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleJsUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[]{functionEunm.getName()}));
        }
    }

    public static IRuleFunction functionFormulaPojoToRuleFunction(IModelCacheHelper modelCache, FormulaPojo formulaPojo) {
        String functionName = formulaPojo.getToolEnumKeyString();
        RuleFunctionEnum functionEunm = RuleFunctionEnum.getFunctionEnumByName((String)functionName);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("kd.epm.eb.formplugin.rulemanage.functionEdit.convert." + functionEunm.getShortName() + "FunctionConvert");
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod("convertToFunction", IModelCacheHelper.class, FormulaPojo.class);
            Object returnz = method.invoke(instance, modelCache, formulaPojo);
            return (IRuleFunction)returnz;
        }
        catch (Exception e) {
            log.error("convertToFunctionError:", (Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u51fd\u6570\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleJsUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[]{functionEunm.getName()}));
        }
    }

    private void updatePeriodShiftAggType(long modelId) {
        List ruleAccMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fpkid,faggtype,fperiodshift from t_eb_bizruleformulaacc where fruleid in (select fid from t_eb_bizruleset where fmodel = ?) and fperiodshift = ?", (Object[])new Object[]{modelId, true});
        if (CollectionUtils.isEmpty((Collection)ruleAccMapList)) {
            return;
        }
        Map ruleAcc = (Map)ruleAccMapList.get(0);
        Object obj = ruleAcc.get("faggtype");
        int aggType = 0;
        if (obj instanceof Number) {
            Number number = (Number)obj;
            aggType = number.intValue();
        }
        if (AggType.SUM.getIndex() != aggType) {
            return;
        }
        List pkIds = ruleAccMapList.stream().map(e -> e.get("fpkid")).collect(Collectors.toList());
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_eb_bizruleformulaacc set faggtype = ?", new Object[]{IDUtils.toLong((Object)AggType.PERIODSHIFT.getIndex())});
        sql.append(" where ", new Object[0]);
        sql.appendIn("fpkid", pkIds);
        DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
    }

    private void updateShowRuleFuncAggType(long modelId) {
        ArrayList<Object[]> ruleAccValues = new ArrayList<Object[]>(16);
        List ruleFunctionMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,ffunctioninfostr,fruleid,ffunctiontype from t_eb_rulefunction where fruleid in (select fid from t_eb_bizruleset where fmodel = ?) and ffunctiontype in ('YearValue','RecognitionP','RecognitionSP','RecognitionPC')", (Object[])new Object[]{modelId});
        if (CollectionUtils.isEmpty((Collection)ruleFunctionMapList)) {
            return;
        }
        Map<Long, List<Map>> ruleFuncMapGroupRuleId = ruleFunctionMapList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("fruleid")));
        HashSet<Long> ruleIdSet = new HashSet<Long>(ruleFuncMapGroupRuleId.keySet());
        List ruleAccMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)StrUtils.format((String)"select fpkid,fmemberkey,fruleid,faggtype from t_eb_bizruleformulaacc where fruleid in {}", (Object[])new Object[]{DbUtils.getInValueString(ruleIdSet)}), null);
        Map<Long, List<Map>> ruleAccMapGroupRuleId = ruleAccMapList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("fruleid")));
        boolean hasUpgrade = false;
        block0: for (Map.Entry<Long, List<Map>> entry : ruleFuncMapGroupRuleId.entrySet()) {
            if (hasUpgrade) break;
            Long ruleId = entry.getKey();
            List<Map> ruleFuncList = entry.getValue();
            List<Map> ruleAccList = ruleAccMapGroupRuleId.get(ruleId);
            Map<String, List<Map>> ruleAccMemberKeyMap = ruleAccList.stream().collect(Collectors.groupingBy(e -> (String)e.get("fmemberkey")));
            for (Map ruleFunc : ruleFuncList) {
                Object accountMemberKey;
                String functionInfoStr = (String)ruleFunc.get("ffunctioninfostr");
                String functionType = (String)ruleFunc.get("ffunctiontype");
                Map allValues = (Map)SerializationUtils.fromJsonString((String)functionInfoStr, Map.class);
                if (allValues == null || (accountMemberKey = allValues.get("accountmemberkey")) == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)accountMemberKey.toString()) || !accountMemberKey.toString().startsWith("formult")) continue;
                Object[] oneRowRuleAccVal = new Object[2];
                List<Map> detailRuleAccList = ruleAccMemberKeyMap.get(accountMemberKey.toString());
                if (CollectionUtils.isEmpty(detailRuleAccList)) continue;
                Map stringObjectMap = detailRuleAccList.get(0);
                oneRowRuleAccVal[1] = (Long)stringObjectMap.get("fpkid");
                Object obj = stringObjectMap.get("faggtype");
                int aggType = 0;
                if (obj instanceof Number) {
                    Number number = (Number)obj;
                    aggType = number.intValue();
                    if (AggType.SUM.getIndex() != aggType) {
                        hasUpgrade = true;
                        continue block0;
                    }
                }
                oneRowRuleAccVal[0] = RuleFunctionEnum.YearValue.getName().equals(functionType) ? IDUtils.toLong((Object)AggType.YEARVALUE.getIndex()) : (RuleFunctionEnum.RecognitionP.getName().equals(functionType) || RuleFunctionEnum.RecognitionSP.getName().equals(functionType) || RuleFunctionEnum.RecognitionPC.getName().equals(functionType) ? IDUtils.toLong((Object)AggType.FINANCE.getIndex()) : IDUtils.toLong((Object)AggType.SUM.getIndex()));
                ruleAccValues.add(oneRowRuleAccVal);
            }
        }
        if (ruleAccValues.size() > 0) {
            String sql = "update t_eb_bizruleformulaacc set faggtype = ? where fpkid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, ruleAccValues);
        }
    }

    private void updateYearValueFun(long modelId) {
        this.updateYearValueRuleRelationTable(modelId);
        this.updateRuleBatchTable(modelId);
    }

    private void updateRuleBatchTable(long modelId) {
        ArrayList<Object[]> ruleBatchValues = new ArrayList<Object[]>(16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List ruleBatchList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fruletemplate from t_eb_rulebatch where fmodel = ?", (Object[])new Object[]{modelId});
        if (CollectionUtils.isEmpty((Collection)ruleBatchList)) {
            return;
        }
        for (Map detailRuleBatchMap : ruleBatchList) {
            Object[] oneRowVal = new Object[2];
            oneRowVal[1] = detailRuleBatchMap.get("fid");
            String ruleTemplateStr = (String)detailRuleBatchMap.get("fruletemplate");
            RuleManageRowPojo ruleManageRowPojo = (RuleManageRowPojo)JsonUtils.readValue((String)ruleTemplateStr, RuleManageRowPojo.class);
            List formulaPojoList = ruleManageRowPojo.getFormulaPojoList();
            FormulaPojo formulaPojo = (FormulaPojo)formulaPojoList.get(0);
            String dimensionNumberString = ruleManageRowPojo.getDimensionNumberString();
            for (FormulaPojo pojo : formulaPojoList) {
                Long datasetId;
                FormulaPojo accountFormulaPojo;
                List subFormulaPojoList;
                block22: {
                    block20: {
                        Member rightAccount;
                        block21: {
                            if (!pojo.getTypeString().equals("function") || !pojo.getToolEnumKeyString().equals(RuleFunctionEnum.YearValue.getName())) continue;
                            subFormulaPojoList = pojo.getSubFormulaPojoList();
                            accountFormulaPojo = (FormulaPojo)subFormulaPojoList.get(2);
                            datasetId = 0L;
                            if (!SysDimensionEnum.Account.getNumber().equals(dimensionNumberString)) break block20;
                            rightAccount = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, IDUtils.toLong((Object)accountFormulaPojo.getMainMemberIdString()));
                            if (rightAccount == null) break block21;
                            datasetId = rightAccount.getDatasetId();
                            break block22;
                        }
                        String[] split = accountFormulaPojo.getNumberString().split("\\|");
                        if (split == null || split.length <= 0) break block22;
                        String number = split[0];
                        rightAccount = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, number);
                        if (rightAccount != null) {
                            datasetId = rightAccount.getDatasetId();
                        }
                        break block22;
                    }
                    List notMainMemberList = accountFormulaPojo.getNotMainMemberList();
                    Object accFormulaMembPojo = null;
                    for (Object formulaMembPojo : notMainMemberList) {
                        if (!SysDimensionEnum.Account.getNumber().equals(formulaMembPojo.getDimNumber())) continue;
                        accFormulaMembPojo = formulaMembPojo;
                        break;
                    }
                    if (accFormulaMembPojo == null) {
                        Object formulaMembPojo;
                        List ruleRangePojoList = ruleManageRowPojo.getRuleRangePojoList();
                        formulaMembPojo = ruleRangePojoList.iterator();
                        while (formulaMembPojo.hasNext()) {
                            RuleRangePojo ruleRangePojo = (RuleRangePojo)formulaMembPojo.next();
                            if (!SysDimensionEnum.Account.getNumber().equals(ruleRangePojo.getNumberString())) continue;
                            RuleRangMemberPojo ruleRangMemberPojo = (RuleRangMemberPojo)ruleRangePojo.getRuleRangMemberPojoList().get(0);
                            Member rightAccount = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, IDUtils.toLong((Object)ruleRangMemberPojo.getNumberString()));
                            if (rightAccount == null) continue;
                            datasetId = rightAccount.getDatasetId();
                            break;
                        }
                    }
                }
                List dimensionList = modelCache.getDimensionList(datasetId);
                Map viewsByDataSet = modelCache.getViewsByDataSet(datasetId);
                List notMainMemberList = accountFormulaPojo.getNotMainMemberList();
                ArrayList<FormulaMembPojo> newNotMainMemberList = new ArrayList<FormulaMembPojo>(notMainMemberList.size());
                Map<String, FormulaMembPojo> notMainMemberMap = notMainMemberList.stream().collect(Collectors.toMap(FormulaMembPojo::getDimNumber, v -> v, (v1, v2) -> v1));
                accountFormulaPojo.setMainDimNumber(dimensionNumberString);
                StringBuilder nameSb = new StringBuilder();
                StringBuilder numberSb = new StringBuilder();
                StringBuilder showNumberSb = new StringBuilder();
                if (SysDimensionEnum.Account.getNumber().equals(dimensionNumberString)) {
                    Object split;
                    Member rightAccount = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, IDUtils.toLong((Object)accountFormulaPojo.getMainMemberIdString()));
                    if (rightAccount == null && (split = accountFormulaPojo.getNumberString().split("\\|")) != null && ((String[])split).length > 0) {
                        String number = split[0];
                        rightAccount = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, number);
                    }
                    if (rightAccount == null) continue;
                    accountFormulaPojo.setMainMemberIdString(IDUtils.toString((Object)rightAccount.getId()));
                    nameSb.append(rightAccount.getName()).append("|");
                    numberSb.append(rightAccount.getNumber()).append("|");
                    showNumberSb.append(rightAccount.getShowNumber()).append("|");
                    split = dimensionList.iterator();
                    while (split.hasNext()) {
                        FormulaMembPojo formulaMembPojo2;
                        Dimension dimension = (Dimension)split.next();
                        String dimensionNumber = dimension.getNumber();
                        if (dimensionNumber.equals(dimensionNumberString) || (formulaMembPojo2 = notMainMemberMap.get(dimensionNumber)) == null) continue;
                        Member member = modelCache.getMember(dimensionNumber, IDUtils.toLong((Object)formulaMembPojo2.getViewIdString()), formulaMembPojo2.getNumberString());
                        nameSb.append(formulaMembPojo2.getNameString()).append("|");
                        numberSb.append(formulaMembPojo2.getNumberString()).append("|");
                        if (member != null) {
                            formulaMembPojo2.setShowNumberString(member.getShowNumber());
                            showNumberSb.append(formulaMembPojo2.getShowNumberString()).append("|");
                        }
                        newNotMainMemberList.add(formulaMembPojo2);
                    }
                } else {
                    FormulaMembPojo formulaMembPojo;
                    if (notMainMemberMap.containsKey(dimensionNumberString)) {
                        formulaMembPojo = notMainMemberMap.get(dimensionNumberString);
                    } else {
                        formulaMembPojo = new FormulaMembPojo();
                        formulaMembPojo.setMemberIdString(formulaPojo.getIdString());
                        formulaMembPojo.setNumberString(formulaPojo.getNumberString());
                        formulaMembPojo.setNameString(formulaPojo.getValueString());
                        formulaMembPojo.setDimNumber(dimensionNumberString);
                        formulaMembPojo.setVariable(false);
                    }
                    Member mainMember = modelCache.getMember(dimensionNumberString, (Long)viewsByDataSet.get(dimensionNumberString), formulaMembPojo.getNumberString());
                    if (mainMember == null) continue;
                    accountFormulaPojo.setMainMemberIdString(IDUtils.toString((Object)mainMember.getId()));
                    nameSb.append(formulaMembPojo.getNameString()).append("|");
                    numberSb.append(formulaMembPojo.getNumberString()).append("|");
                    formulaMembPojo.setShowNumberString(mainMember.getShowNumber());
                    showNumberSb.append(formulaMembPojo.getShowNumberString()).append("|");
                    for (Dimension dimension : dimensionList) {
                        String dimensionNumber = dimension.getNumber();
                        if (dimensionNumber.equals(dimensionNumberString)) continue;
                        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                            FormulaMembPojo formulaMembPojo1 = new FormulaMembPojo();
                            Member rightAccount = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, IDUtils.toLong((Object)accountFormulaPojo.getMainMemberIdString()));
                            if (rightAccount == null) {
                                String[] split = accountFormulaPojo.getNumberString().split("\\|");
                                if (split != null && split.length > 0) {
                                    String number = split[0];
                                    rightAccount = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, number);
                                }
                                if (rightAccount == null) continue;
                            }
                            formulaMembPojo1.setMemberIdString(IDUtils.toString((Object)rightAccount.getId()));
                            formulaMembPojo1.setNumberString(rightAccount.getNumber());
                            formulaMembPojo1.setShowNumberString(rightAccount.getShowNumber());
                            formulaMembPojo1.setNameString(rightAccount.getName());
                            formulaMembPojo1.setDimNumber(SysDimensionEnum.Account.getNumber());
                            formulaMembPojo1.setVariable(false);
                            nameSb.append(formulaMembPojo1.getNameString()).append("|");
                            numberSb.append(formulaMembPojo1.getNumberString()).append("|");
                            showNumberSb.append(formulaMembPojo1.getShowNumberString()).append("|");
                            newNotMainMemberList.add(formulaMembPojo1);
                            continue;
                        }
                        FormulaMembPojo formulaMembPojo2 = notMainMemberMap.get(dimensionNumber);
                        if (formulaMembPojo2 == null) continue;
                        Member member = modelCache.getMember(dimensionNumber, IDUtils.toLong((Object)formulaMembPojo2.getViewIdString()), formulaMembPojo2.getNumberString());
                        nameSb.append(formulaMembPojo2.getNameString()).append("|");
                        numberSb.append(formulaMembPojo2.getNumberString()).append("|");
                        if (member != null) {
                            formulaMembPojo2.setShowNumberString(member.getShowNumber());
                            showNumberSb.append(formulaMembPojo2.getShowNumberString()).append("|");
                        }
                        newNotMainMemberList.add(formulaMembPojo2);
                    }
                }
                nameSb.setLength(nameSb.length() - 1);
                numberSb.setLength(numberSb.length() - 1);
                showNumberSb.setLength(showNumberSb.length() - 1);
                accountFormulaPojo.setValueString(nameSb.toString());
                accountFormulaPojo.setNumberString(numberSb.toString());
                accountFormulaPojo.setShowNumberString(showNumberSb.toString());
                accountFormulaPojo.setNotMainMemberList(newNotMainMemberList);
                FormulaPojo formulaPojo1 = (FormulaPojo)subFormulaPojoList.get(subFormulaPojoList.size() - 2);
                if (pojo.getChildFormulaPojo() != null || formulaPojo1.getValueString().equals(",")) continue;
                FormulaPojo formulaPojo3 = new FormulaPojo();
                formulaPojo3.setTypeString("text");
                formulaPojo3.setValueString(",");
                subFormulaPojoList.add(subFormulaPojoList.size() - 1, formulaPojo3);
            }
            oneRowVal[0] = SerializationUtils.toJsonString((Object)ruleManageRowPojo);
            ruleBatchValues.add(oneRowVal);
        }
        if (ruleBatchValues.size() > 0) {
            String sql = "update t_eb_rulebatch set fruletemplate = ? where fid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, ruleBatchValues);
        }
    }

    private void updateYearValueRuleRelationTable(long modelId) {
        String sql;
        ArrayList ruleFuncValues = new ArrayList(16);
        ArrayList ruleAccValues = new ArrayList(16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List ruleFunctionMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,ffunctioninfostr,fruleid from t_eb_rulefunction where fruleid in (select fid from t_eb_bizruleset where fmodel = ?) and ffunctiontype = 'YearValue'", (Object[])new Object[]{modelId});
        if (CollectionUtils.isEmpty((Collection)ruleFunctionMapList)) {
            return;
        }
        Map<Long, List<Map>> ruleFuncMapGroupRuleId = ruleFunctionMapList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("fruleid")));
        HashSet<Long> ruleIdSet = new HashSet<Long>(ruleFuncMapGroupRuleId.keySet());
        List ruleMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)StrUtils.format((String)"select fid,fnumber,fusescope from t_eb_bizruleset where fid in {}", (Object[])new Object[]{DbUtils.getInValueString(ruleIdSet)}), null);
        Map<Long, List<Map>> ruleMapGroupRuleId = ruleMapList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("fid")));
        List ruleAccMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fpkid,fmemberkey,fruleid,fdimenstionjsonfix,fisleft,fmemberid from t_eb_bizruleformulaacc where fruleid in (select fid from t_eb_bizruleset where fmodel = ?)", (Object[])new Object[]{modelId});
        Map<Long, List<Map>> ruleAccMapGroupRuleId = ruleAccMapList.stream().collect(Collectors.groupingBy(e -> (Long)e.get("fruleid")));
        ruleFuncMapGroupRuleId.forEach((ruleId, ruleFuncList) -> {
            List ruleAccList = (List)ruleAccMapGroupRuleId.get(ruleId);
            List ruleList = (List)ruleMapGroupRuleId.get(ruleId);
            HashMap<String, Object> leftRuleAccMap = new HashMap(16);
            for (Map ruleAcc : ruleAccList) {
                String isLeft = (String)ruleAcc.get("fisleft");
                if (!isLeft.equals("1")) continue;
                leftRuleAccMap = ruleAcc;
                break;
            }
            Map<String, List<Map>> ruleAccMemberKeyMap = ruleAccList.stream().collect(Collectors.groupingBy(e -> (String)e.get("fmemberkey")));
            for (Map ruleFunc : ruleFuncList) {
                Object accountMemberKey;
                Object[] oneRowRuleFuncVal = new Object[2];
                Object[] oneRowRuleAccVal = new Object[2];
                oneRowRuleFuncVal[1] = (Long)ruleFunc.get("fid");
                String functionInfoStr = (String)ruleFunc.get("ffunctioninfostr");
                Map allValues = (Map)SerializationUtils.fromJsonString((String)functionInfoStr, Map.class);
                if (allValues != null && (accountMemberKey = allValues.get("accountmemberkey")) != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)accountMemberKey.toString()) && accountMemberKey.toString().startsWith("formult")) {
                    List<Map> detailRuleAccList = ruleAccMemberKeyMap.get(accountMemberKey.toString());
                    Map stringObjectMap = detailRuleAccList.get(0);
                    oneRowRuleAccVal[1] = (Long)stringObjectMap.get("fpkid");
                    ArrayList<FormulaMemberDto> newFormulaMemberDtoList = new ArrayList<FormulaMemberDto>(16);
                    Map ruleMap = (Map)ruleList.get(0);
                    FormulaMemberPojo accountMemberPojo = this.toFormulaMemberPojoByYearValue(modelCache, stringObjectMap, leftRuleAccMap, newFormulaMemberDtoList, ruleMap);
                    oneRowRuleAccVal[0] = JsonUtils.getJsonString(newFormulaMemberDtoList);
                    allValues.put("account", JsonUtils.getJsonString((Object)accountMemberPojo));
                }
                oneRowRuleFuncVal[0] = JsonUtils.getJsonString((Object)allValues);
                ruleFuncValues.add(oneRowRuleFuncVal);
                ruleAccValues.add(oneRowRuleAccVal);
            }
        });
        if (ruleFuncValues.size() > 0) {
            sql = "update t_eb_rulefunction set ffunctioninfostr = ? where fid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, ruleFuncValues);
        }
        if (ruleAccValues.size() > 0) {
            sql = "update t_eb_bizruleformulaacc set fdimenstionjsonfix = ? where fpkid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, ruleAccValues);
        }
    }

    private FormulaMemberPojo toFormulaMemberPojoByYearValue(IModelCacheHelper modelCache, Map<String, Object> stringObjectMap, Map<String, Object> leftRuleAccMap, List<FormulaMemberDto> newFormulaMemberDtoList, Map<String, Object> ruleMap) {
        Long datasetId;
        String mainDimNumber;
        List formulaMemberDtoList;
        FormulaMemberPojo accountMemberPojo;
        FormulaMemberDto leftFormulaMemberDto;
        RuleRelationService ruleRelationService;
        block7: {
            block8: {
                Member accountMem;
                block6: {
                    ruleRelationService = RuleRelationService.getInstance();
                    String leftDimFixJsonString = ObjUtils.getString((Object)leftRuleAccMap.get("fdimenstionjsonfix"));
                    if (!leftDimFixJsonString.startsWith("[{")) {
                        leftDimFixJsonString = ruleRelationService.changeStr(leftDimFixJsonString);
                    }
                    List leftFormulaMemberDtoList = JSON.parseArray((String)leftDimFixJsonString, FormulaMemberDto.class);
                    leftFormulaMemberDto = (FormulaMemberDto)leftFormulaMemberDtoList.get(0);
                    accountMemberPojo = new FormulaMemberPojo();
                    accountMemberPojo.setMemberKey(Convert.toStr((Object)stringObjectMap.get("fmemberkey")));
                    accountMemberPojo.setRuleId(Convert.toLong((Object)stringObjectMap.get("fruleid")));
                    String dimJsonFixString = ObjUtils.getString((Object)stringObjectMap.get("fdimenstionjsonfix"));
                    if (!dimJsonFixString.startsWith("[{")) {
                        dimJsonFixString = ruleRelationService.changeStr(dimJsonFixString);
                    }
                    formulaMemberDtoList = JSON.parseArray((String)dimJsonFixString, FormulaMemberDto.class);
                    mainDimNumber = leftFormulaMemberDto.getDimNumber();
                    datasetId = 0L;
                    FormulaMemberDto rightAcc = null;
                    for (FormulaMemberDto formulaMemberDto : formulaMemberDtoList) {
                        if (!SysDimensionEnum.Account.getNumber().equals(formulaMemberDto.getDimNumber())) continue;
                        rightAcc = formulaMemberDto;
                        break;
                    }
                    if (rightAcc == null) break block6;
                    accountMem = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, rightAcc.getNumber());
                    if (accountMem == null) break block7;
                    datasetId = accountMem.getDatasetId();
                    break block7;
                }
                if (!SysDimensionEnum.Account.getNumber().equals(mainDimNumber)) break block8;
                accountMem = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, leftFormulaMemberDto.getNumber());
                if (accountMem == null) break block7;
                datasetId = accountMem.getDatasetId();
                break block7;
            }
            String useScopeStr = ObjUtils.getString((Object)ruleMap.get("fusescope"));
            List formulaConditionList = (List)JsonUtils.readValue((String)useScopeStr, (TypeReference)new TypeReference<List<FormulaCondition>>(){});
            for (FormulaCondition formulaCondition : formulaConditionList) {
                if (!SysDimensionEnum.Account.getNumber().equals(formulaCondition.getDimensionNumber())) continue;
                kd.epm.eb.common.f7.MemberCondition memberCondition = (kd.epm.eb.common.f7.MemberCondition)formulaCondition.getMemberList().get(0);
                Member accountMem = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, memberCondition.getNumber());
                if (accountMem == null) continue;
                datasetId = accountMem.getDatasetId();
                break;
            }
        }
        List dimensionList = modelCache.getDimensionList(datasetId);
        Map viewsByDataSet = modelCache.getViewsByDataSet(datasetId);
        Map<String, FormulaMemberDto> formulaMemberMap = formulaMemberDtoList.stream().collect(Collectors.toMap(FormulaMemberDto::getDimNumber, v -> v, (v1, v2) -> v1));
        FormulaMemberDto mainFormulaMemberDto = formulaMemberMap.get(mainDimNumber);
        if (mainFormulaMemberDto == null) {
            mainFormulaMemberDto = leftFormulaMemberDto;
        }
        Member member = modelCache.getMember(mainDimNumber, (Long)viewsByDataSet.get(mainDimNumber), mainFormulaMemberDto.getNumber());
        accountMemberPojo.setMainDimMemberId(member.getId());
        ArrayList<DimMemberPojo> refDimMembers = new ArrayList<DimMemberPojo>(16);
        newFormulaMemberDtoList.add(mainFormulaMemberDto);
        DimMemberPojo mainDimMemberPojo = ruleRelationService.getDimMemberPojo(modelCache, mainFormulaMemberDto);
        refDimMembers.add(mainDimMemberPojo);
        for (Dimension dimension : dimensionList) {
            FormulaMemberDto formulaMemberDto;
            if (dimension.getNumber().equals(mainDimNumber) || (formulaMemberDto = formulaMemberMap.get(dimension.getNumber())) == null) continue;
            newFormulaMemberDtoList.add(formulaMemberDto);
            DimMemberPojo dimMemberPojo = ruleRelationService.getDimMemberPojo(modelCache, formulaMemberDto);
            refDimMembers.add(dimMemberPojo);
        }
        accountMemberPojo.setRefDimMembers(refDimMembers);
        return accountMemberPojo;
    }

    public DimMemberPojo getDimMemberPojo(IModelCacheHelper modelCache, FormulaMemberDto formulaMemberDto) {
        DimMemberPojo dimMemberPojo = new DimMemberPojo();
        if (formulaMemberDto == null) {
            return dimMemberPojo;
        }
        dimMemberPojo.setId(formulaMemberDto.getId());
        dimMemberPojo.setNumber(formulaMemberDto.getNumber());
        dimMemberPojo.setName(formulaMemberDto.getName());
        dimMemberPojo.setDimNumber(formulaMemberDto.getDimNumber());
        dimMemberPojo.setDimShortNumber(formulaMemberDto.getDimShortNumber());
        dimMemberPojo.setLongNumber(formulaMemberDto.getLongNumber());
        dimMemberPojo.setViewId(formulaMemberDto.getViewId());
        dimMemberPojo.setViewNumber(formulaMemberDto.getViewNumber());
        if (SysDimensionEnum.Account.getNumber().equalsIgnoreCase(formulaMemberDto.getDimNumber())) {
            Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, formulaMemberDto.getNumber());
            Long datasetId = member.getDatasetId();
            DynamicObject dynamicObject = DatasetServiceHelper.loadDatasets((Long)datasetId);
            String dataModelNumber = dynamicObject.getString("number");
            dimMemberPojo.setDataModelNumber(dataModelNumber);
        }
        return dimMemberPojo;
    }

    private void upMainTable(long modelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Map<Long, Long> allDataSetId = this.getDataSetAndBizModel(modelId);
        Map<Long, Long> allAccountDimId = this.getAccountDimIdAndModel(modelId);
        if (allAccountDimId.isEmpty() || allDataSetId.isEmpty()) {
            return;
        }
        ArrayList<Object[]> valuse = new ArrayList<Object[]>(16);
        Long groupId = null;
        String leftNumber = "";
        String accountDimNum = SysDimensionEnum.Account.getNumber() + ":";
        int index = 0;
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)BgFormConstant.DBROUTE, (String)"select fmodel,fid,fdatasetid,faccountid,fname,fnumber,fbizctrlrangeid,fmetricid,fusescope,fformulastring from t_eb_bizruleset where FMODEL=? and fruletype <> '1' ", (Object[])new Object[]{modelId});){
            for (Row row : dataSet) {
                String fformulastring;
                Object[] oneRowVal = new Object[11];
                Long dataSetId = row.getLong("fdatasetid");
                Long id = row.getLong("fid");
                Long accountId = row.getLong("faccountid");
                String number = row.getString("fnumber");
                String fname = row.getString("fname");
                Long oldBizModelId = row.getLong("fbizctrlrangeid");
                Long metricid = row.getLong("fmetricid");
                String usescope = row.getString("fusescope");
                if (oldBizModelId != null && oldBizModelId != 0L) continue;
                groupId = this.accGroupMap.computeIfAbsent(accountId, v -> GlobalIdUtil.genGlobalLongId());
                index = this.indexMap.computeIfAbsent(groupId, v -> 1);
                String currentLeftNumber = number.substring(0, number.lastIndexOf(":"));
                oneRowVal[10] = id;
                oneRowVal[0] = String.valueOf(dataSetId);
                Long bizModelId = allDataSetId.get(dataSetId);
                if (bizModelId == null) {
                    bizModelId = 0L;
                }
                oneRowVal[1] = bizModelId;
                oneRowVal[2] = accountId;
                Long accountDimId = allAccountDimId.get(modelId);
                if (accountDimId == null) {
                    accountDimId = 0L;
                }
                oneRowVal[3] = accountDimId;
                oneRowVal[4] = index;
                this.indexMap.put(groupId, ++index);
                oneRowVal[5] = groupId;
                oneRowVal[6] = number.startsWith(SysDimensionEnum.Account.getNumber()) ? number : accountDimNum + number;
                List useScopeList = JSON.parseArray((String)usescope, FormulaCondition.class);
                oneRowVal[7] = usescope;
                boolean hasMetric = useScopeList.stream().anyMatch(e -> SysDimensionEnum.Metric.getNumber().equals(e.getDimensionNumber()));
                if (!hasMetric) {
                    Member metricMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricid);
                    kd.epm.eb.common.f7.MemberCondition newMember = (kd.epm.eb.common.f7.MemberCondition)Builder.of(kd.epm.eb.common.f7.MemberCondition::new).with(kd.epm.eb.common.f7.MemberCondition::setNumber, (Object)metricMember.getNumber()).with(kd.epm.eb.common.f7.MemberCondition::setName, (Object)metricMember.getName()).with(kd.epm.eb.common.f7.MemberCondition::setRange, (Object)(RangeEnum.ONLY.getIndex() + "")).with(kd.epm.eb.common.f7.MemberCondition::setId, (Object)metricMember.getId()).with(kd.epm.eb.common.f7.MemberCondition::setLongnumber, (Object)metricMember.getLongNumber()).with(kd.epm.eb.common.f7.MemberCondition::setProp, (Object)false).build();
                    Dimension metricDim = modelCache.getDimension(SysDimensionEnum.Metric.getNumber());
                    FormulaCondition newScope = (FormulaCondition)Builder.of(FormulaCondition::new).with(FormulaCondition::setDimension, (Object)metricDim.getId()).with(FormulaCondition::setDimensionNumber, (Object)metricDim.getNumber()).with(FormulaCondition::setDimShortNumber, (Object)metricDim.getShortNumber()).with(FormulaCondition::setMemberList, Collections.singletonList(newMember)).build();
                    useScopeList.add(newScope);
                    oneRowVal[7] = JSON.toJSONString((Object)useScopeList);
                }
                if ((fformulastring = row.getString("fformulastring")).contains("F`")) {
                    String[] splits = fformulastring.split("MBR:\\[F`");
                    StringBuilder stringBuilder = new StringBuilder(splits[0]);
                    stringBuilder.append("MBR:[F`");
                    for (int i = 1; i < splits.length; ++i) {
                        String split = splits[i];
                        int i1 = split.indexOf(96);
                        String substring = split.substring(0, i1);
                        if (RuleFunctionEnum.getFunctionEnumByName((String)substring).isCut()) {
                            String afterString = split.substring(i1 + 1);
                            stringBuilder.append(substring);
                            stringBuilder.append('`');
                            int i2 = afterString.indexOf(93);
                            String afterSubString = afterString.substring(0, i2 + 1);
                            stringBuilder.append(afterSubString);
                            int i3 = afterString.indexOf(41);
                            String afterSubString2 = afterString.substring(i3 + 1);
                            stringBuilder.append(afterSubString2);
                            continue;
                        }
                        stringBuilder.append(split);
                    }
                    fformulastring = stringBuilder.toString();
                }
                oneRowVal[8] = fformulastring;
                oneRowVal[9] = fname;
                valuse.add(oneRowVal);
            }
        }
        if (valuse.size() > 0) {
            String sql = "update t_eb_bizruleset set fbizmodels = ?,fbizctrlrangeid = ? ,fleftmemberid = ? ,fmaindimensionid = ? ,findex = ? ,fgroupid = ? ,fnumber = ? , fusescope=? , fformulastring = ? ,fdescription = ? where fid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, valuse);
        }
    }

    private void upFunctionTable(long modelId) {
        ArrayList<Object[]> valuse = new ArrayList<Object[]>(16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        try (DataSet dataSet = DB.queryDataSet((String)"getBizRuleAcctInfo", (DBRoute)BgFormConstant.DBROUTE, (String)"select fid,ffunctioninfostr from t_eb_rulefunction where fruleid in (select fid from t_eb_bizruleset where fmodel = ?)", (Object[])new Object[]{modelId});){
            for (Row row : dataSet) {
                Object[] oneRowVal = new Object[2];
                oneRowVal[1] = row.getLong("fid");
                String ffunctioninfostr = row.getString("ffunctioninfostr");
                Map allValues = (Map)SerializationUtils.fromJsonString((String)ffunctioninfostr, Map.class);
                if (allValues != null) {
                    Object periodMemberKey;
                    Object accountMemberKey = allValues.get("account");
                    if (accountMemberKey != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)accountMemberKey.toString()) && accountMemberKey.toString().startsWith("formult")) {
                        List bizruleformulaaccMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fpkid,fmemberkey,fruleid,fdimenstionjsonfix,fisleft,fmemberid from t_eb_bizruleformulaacc where fmemberkey = ?", (Object[])new Object[]{accountMemberKey.toString()});
                        Map stringObjectMap = (Map)bizruleformulaaccMapList.get(0);
                        FormulaMemberPojo accountMemberPojo = this.toFormulaMemberPojo(modelCache, stringObjectMap);
                        allValues.put("account", JsonUtils.getJsonString((Object)accountMemberPojo));
                        allValues.put("accountmemberkey", accountMemberPojo.getMemberKey());
                    }
                    if ((periodMemberKey = allValues.get("returnperiod")) != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)periodMemberKey.toString()) && periodMemberKey.toString().startsWith("formult")) {
                        List bizruleformulaaccMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fpkid,fmemberkey,fruleid,fdimenstionjsonfix,fisleft,fmemberid from t_eb_bizruleformulaacc where fmemberkey = ?", (Object[])new Object[]{periodMemberKey.toString()});
                        Map stringObjectMap = (Map)bizruleformulaaccMapList.get(0);
                        FormulaMemberPojo periodMemberPojo = this.toFormulaMemberPojo(modelCache, stringObjectMap);
                        allValues.put("returnperiod", JsonUtils.getJsonString((Object)periodMemberPojo));
                        allValues.put("returnperiodmemberkey", periodMemberPojo.getMemberKey());
                    }
                }
                oneRowVal[0] = JsonUtils.getJsonString((Object)allValues);
                valuse.add(oneRowVal);
            }
            if (valuse.size() > 0) {
                String sql = "update t_eb_rulefunction set ffunctioninfostr = ? where fid = ?";
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, valuse);
            }
        }
    }

    private FormulaMemberPojo toFormulaMemberPojo(IModelCacheHelper modelCache, Map<String, Object> stringObjectMap) {
        List formulaMemberDtoList;
        FormulaMemberPojo accountMemberPojo = new FormulaMemberPojo();
        accountMemberPojo.setMemberKey(Convert.toStr((Object)stringObjectMap.get("fmemberkey")));
        accountMemberPojo.setMainDimMemberId(Convert.toLong((Object)stringObjectMap.get("fmemberid")));
        accountMemberPojo.setRuleId(Convert.toLong((Object)stringObjectMap.get("fruleid")));
        ArrayList<DimMemberPojo> refDimMembers = new ArrayList<DimMemberPojo>(16);
        String fdimenstionjsonfixString = ObjUtils.getString((Object)stringObjectMap.get("fdimenstionjsonfix"));
        if (!fdimenstionjsonfixString.startsWith("[{")) {
            fdimenstionjsonfixString = this.changeStr(fdimenstionjsonfixString);
        }
        if (CollectionUtils.isNotEmpty((Collection)(formulaMemberDtoList = JSON.parseArray((String)fdimenstionjsonfixString, FormulaMemberDto.class)))) {
            for (FormulaMemberDto formulaMemberDto : formulaMemberDtoList) {
                DimMemberPojo dimMemberPojo = this.getDimMemberPojo(modelCache, formulaMemberDto);
                refDimMembers.add(dimMemberPojo);
            }
        }
        accountMemberPojo.setRefDimMembers(refDimMembers);
        return accountMemberPojo;
    }

    private void upMembTable(long modelId) {
        List bizrulesetRowMapList = DbUtils.getRowMapList((String)"getBizRuleAcctInfo", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fmaindimensionid from t_eb_bizruleset where FMODEL = ?", (Object[])ObjUtils.getObjectArray((Object[])new Object[]{modelId}));
        if (CollectionUtils.isEmpty((Collection)bizrulesetRowMapList)) {
            return;
        }
        ArrayList<Object[]> valuse = new ArrayList<Object[]>(16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<Long, Dimension> bizruleIdDimensionMap = new HashMap<Long, Dimension>(16);
        for (Map bizrulesetRowMap : bizrulesetRowMapList) {
            Long bizruleIdLong = ObjUtils.getLong(bizrulesetRowMap.get("fid"));
            Long fmaindimensionidLong = ObjUtils.getLong(bizrulesetRowMap.get("fmaindimensionid"));
            Dimension dimension = null;
            if (fmaindimensionidLong != null && fmaindimensionidLong != 0L) {
                dimension = modelCache.getDimension(fmaindimensionidLong);
            }
            bizruleIdDimensionMap.put(bizruleIdLong, dimension);
        }
        List rowMapList = DbUtils.getRowMapList((String)"getBizRuleAcctInfo", (DBRoute)DBRoute.of((String)"epm"), (String)"select fpkid,fruleid,faccountid,fdimenstionjsonfix from t_eb_bizruleformulaacc where FRULEID in (select fid from t_eb_bizruleset where FMODEL = ?)", (Object[])ObjUtils.getObjectArray((Object[])new Object[]{modelId}));
        for (Map map : rowMapList) {
            Object[] oneRowVal = new Object[3];
            oneRowVal[2] = ObjUtils.getLong(map.get("fpkid"));
            oneRowVal[0] = ObjUtils.getLong(map.get("faccountid"));
            String dimensionjsonfix = ObjUtils.getString(map.get("fdimenstionjsonfix"));
            if (StringUtils.isNotEmpty((String)dimensionjsonfix)) {
                Long dimMemberPojoIdLong;
                DimMemberPojo[] dimMemberPojoArray;
                Optional<DimMemberPojo> dimMemberPojoOptional;
                Long fruleidLong;
                Dimension dimension;
                if (!dimensionjsonfix.startsWith("[{")) {
                    dimensionjsonfix = this.changeStr(dimensionjsonfix);
                }
                if ((dimension = (Dimension)bizruleIdDimensionMap.get(fruleidLong = ObjUtils.getLong(map.get("fruleid")))) == null) continue;
                if (dimensionjsonfix.endsWith("`")) {
                    dimensionjsonfix = dimensionjsonfix.substring(0, dimensionjsonfix.length() - 1);
                }
                if ((dimMemberPojoOptional = Arrays.stream(dimMemberPojoArray = (DimMemberPojo[])JsonUtils.readValue((String)dimensionjsonfix, DimMemberPojo[].class)).filter(dimMemberPojo -> dimMemberPojo != null && dimension.getNumber().equals(dimMemberPojo.getDimNumber())).findFirst()).isPresent() && (dimMemberPojoIdLong = dimMemberPojoOptional.get().getId()) != null && dimMemberPojoIdLong != 0L) {
                    oneRowVal[0] = dimMemberPojoIdLong;
                }
            }
            oneRowVal[1] = dimensionjsonfix;
            valuse.add(oneRowVal);
        }
        if (valuse.size() > 0) {
            String sql = "update t_eb_bizruleformulaacc set fmemberid = ?,fdimenstionjsonfix = ? where fpkid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, valuse);
        }
    }

    public String changeStr(String s) {
        String[] split = s.split("`");
        ArrayList<DimMemberPojo> memberPojos = new ArrayList<DimMemberPojo>(16);
        String dataSetNum = null;
        for (String s1 : split) {
            String substring = s1.substring(1, s1.length() - 1).replace(" ", "");
            String[] values = substring.split(",");
            Long id = Long.valueOf(values[0]);
            String number = values[1];
            String longNumber = values[2];
            String name = values[3];
            String dimNum = values[4];
            String shortDimNum = values[5];
            if (values.length > 6) {
                dataSetNum = values[6];
            }
            DimMemberPojo memberPojo = new DimMemberPojo(id, number, longNumber, name, dimNum, shortDimNum, dataSetNum);
            memberPojos.add(memberPojo);
        }
        return SerializationUtils.toJsonString(memberPojos);
    }

    private Map<Long, Long> getDataSetAndBizModel(long modelId) {
        HashMap<Long, Long> allDataSetId = new HashMap<Long, Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"getDataSetAndBizModel", (DBRoute)BgFormConstant.DBROUTE, (String)"select fid,fbizmodelid from t_eb_dataset where fmodel=?", (Object[])new Object[]{modelId});){
            for (Row row : dataSet) {
                Long bizModelId = row.getLong("fbizmodelid");
                Long dataSetId = row.getLong("fid");
                allDataSetId.put(dataSetId, bizModelId);
            }
        }
        return allDataSetId;
    }

    private Map<Long, Long> getAccountDimIdAndModel(long modelId) {
        HashMap<Long, Long> allAccountDimId = new HashMap<Long, Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"getAccountDimInfo", (DBRoute)BgFormConstant.DBROUTE, (String)"select fmodelid,fid from t_eb_dimension where fmodelid =? and fnumber = 'Account'", (Object[])new Object[]{modelId});){
            for (Row row : dataSet) {
                modelId = row.getLong("fmodelid");
                Long dimId = row.getLong("fid");
                allAccountDimId.put(modelId, dimId);
            }
        }
        return allAccountDimId;
    }

    public Set<Long> getRuleMatchedTemplateTaskDtoList(RuleDto ruleDto) {
        List datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(ruleDto.getBizCtrlRangeId());
        List templateList = DatasetServiceHelper.getInstance().getTemplate((Collection)datasetIds);
        List pageList = Lists.partition((List)templateList, (int)3);
        HashSet templateIdSet = Sets.newHashSetWithExpectedSize((int)templateList.size());
        ArrayList ruleDtoList = Lists.newArrayList((Object[])new RuleDto[]{ruleDto});
        for (List sub : pageList) {
            List<TemplateTaskDto> templateTaskDtos = TemplateTaskService.getInstance().getTemplateOrTaskScope(sub, ruleDto.getBizCtrlRangeId(), true);
            long modelId = 0L;
            if (CollectionUtils.isNotEmpty((Collection)sub)) {
                modelId = ((DynamicObject)sub.get(0)).getLong("model.id");
            }
            List<TemplateTaskDto> dtos = this.getBindRuleTemplateTaskDtos(templateTaskDtos, ruleDtoList, modelId);
            templateIdSet.addAll(dtos.stream().map(TemplateTaskDto::getTemplateId).filter(xva$0 -> ObjUtils.notNullOrZero((Long[])new Long[]{xva$0})).collect(Collectors.toSet()));
        }
        return templateIdSet;
    }

    public void disableRules(Long bizModelId, Set<Long> delIds) {
        if (CollectionUtils.isEmpty(delIds)) {
            return;
        }
        String fields = "id,number,successors,offsetsuccessors";
        QFilter qFilter = new QFilter("ruletype", "!=", (Object)"1");
        qFilter.and("bizctrlrange", "=", (Object)bizModelId);
        DynamicObjectCollection ruleDtos = QueryServiceHelper.query((String)"eb_bizruleset", (String)fields, (QFilter[])qFilter.toArray());
        ArrayList updateRules = Lists.newArrayList();
        try (TXHandle tx = TX.required();){
            DynamicObject currRule = null;
            try {
                Iterator iterator = ruleDtos.iterator();
                while (iterator.hasNext()) {
                    DynamicObject rule;
                    currRule = rule = (DynamicObject)iterator.next();
                    String successors = rule.getString("successors");
                    successors = successors == null ? "" : successors;
                    String offsetsuccessors = rule.getString("offsetsuccessors");
                    String string = offsetsuccessors = offsetsuccessors == null ? "" : offsetsuccessors;
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)successors)) continue;
                    String[] suSplit = org.apache.commons.lang3.StringUtils.split((String)successors, (String)",");
                    Set successorSet = Arrays.stream(suSplit).map(Long::parseLong).collect(Collectors.toSet());
                    Set suInterSet = successorSet.stream().filter(delIds::contains).collect(Collectors.toSet());
                    String[] offsuSplit = org.apache.commons.lang3.StringUtils.split((String)offsetsuccessors, (String)",");
                    Set offsuccessorSet = Arrays.stream(offsuSplit).map(Long::parseLong).collect(Collectors.toSet());
                    Set offsuInterSet = offsuccessorSet.stream().filter(delIds::contains).collect(Collectors.toSet());
                    if (suInterSet.isEmpty() && offsuInterSet.isEmpty()) continue;
                    Set suSaveSet = successorSet.stream().filter(e -> !suInterSet.contains(e)).collect(Collectors.toSet());
                    Set offsuSaveSet = offsuccessorSet.stream().filter(e -> !offsuInterSet.contains(e)).collect(Collectors.toSet());
                    RuleDto updateRule = (RuleDto)Builder.of(RuleDto::new).with(RuleDto::setId, (Object)rule.getLong("id")).build();
                    updateRule.setSuccessors(suSaveSet.stream().map(e -> e + "").collect(Collectors.joining(",")));
                    updateRule.setOffSuccessors(offsuSaveSet.stream().map(e -> e + "").collect(Collectors.joining(",")));
                    updateRules.add(updateRule);
                }
                if (!updateRules.isEmpty()) {
                    String sql = "update t_eb_bizruleset set fsuccessors=? , foffsetsuccessors=? where fid=?";
                    ArrayList<Object[]> adjObjs = new ArrayList<Object[]>(10);
                    for (RuleDto rule : updateRules) {
                        adjObjs.add(new Object[]{rule.getSuccessors(), rule.getOffSuccessors(), rule.getId()});
                    }
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, adjObjs);
                }
            }
            catch (Throwable ex) {
                if (currRule != null) {
                    log.error("disableRules error:" + currRule.getString("number"), ex);
                }
                tx.markRollback();
                throw ex;
            }
        }
        String inSql = delIds.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
        String delSql = "delete from t_eb_leafbizruletempdis where fbizrule in " + inSql;
        DB.execute((DBRoute)BgBaseConstant.epm, (String)delSql);
        String delApplySql = "delete from t_eb_applytemplaterule where fbizrule in " + inSql;
        DB.execute((DBRoute)BgBaseConstant.epm, (String)delApplySql);
        RuleCacheService.getInstance().clearCache(bizModelId);
    }

    private void setBindRuleToTemplateCache(String cacheKey) {
        Cache.get().set(cacheKey, cacheKey, 5, TimeUnit.MINUTES);
    }

    private void removeBindRuleToTemplateCache(String cacheKey) {
        Cache.get().remove(cacheKey);
    }

    private static class InnerClass {
        private static RuleRelationService instance = new RuleRelationService();

        private InnerClass() {
        }
    }
}

