/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizrule.entity;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GraphNode {
    private Long nodeId;
    private String nodeNumber;
    private String nodeName;
    private Set<Long> successors = new HashSet<Long>(16);
    private Set<Long> offsetSuccessors = new HashSet<Long>(16);
    private Integer exeSeq;

    public GraphNode() {
    }

    public GraphNode(Long nodeId) {
        this.nodeId = nodeId;
    }

    public GraphNode(Long nodeId, String nodeNumber) {
        this.nodeId = nodeId;
        this.nodeNumber = nodeNumber;
    }

    public GraphNode(Long nodeId, String nodeNumber, String nodeName) {
        this.nodeId = nodeId;
        this.nodeNumber = nodeNumber;
        this.nodeName = nodeName;
    }

    public GraphNode(Long nodeId, Integer exeSeq) {
        this.nodeId = nodeId;
        this.exeSeq = exeSeq;
    }

    public GraphNode addSuccessor(Long successorId) {
        this.successors.add(successorId);
        return this;
    }

    public GraphNode addOffsetSuccessor(Long successorId) {
        this.offsetSuccessors.add(successorId);
        return this;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeNumber() {
        return this.nodeNumber;
    }

    public void setNodeNumber(String nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Set<Long> getSuccessors() {
        return this.successors;
    }

    public void setSuccessors(Set<Long> successors) {
        this.successors = successors;
    }

    public Set<Long> getOffsetSuccessors() {
        return this.offsetSuccessors;
    }

    public void setOffsetSuccessors(Set<Long> offsetSuccessors) {
        this.offsetSuccessors = offsetSuccessors;
    }

    public Integer getExeSeq() {
        return this.exeSeq;
    }

    public void setExeSeq(Integer exeSeq) {
        this.exeSeq = exeSeq;
    }

    public String toString() {
        return this.nodeNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GraphNode node = (GraphNode)obj;
        return Objects.equals(this.nodeId, node.nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId);
    }
}

