/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.centralapproval.ApprovePlanUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillEntry;
import kd.epm.eb.common.centralapproval.ApprovePlan;
import kd.epm.eb.common.centralapproval.ApproverTypeEnum;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.centralapproval.CentralScheme;
import kd.epm.eb.common.centralapproval.entity.ApproverDto;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.UserUtils;

public class AppBillDataFilterService {
    private static final Log log = LogFactory.getLog(AppBillDataFilterService.class);

    public static AppBillDataFilterService getInstance() {
        return new AppBillDataFilterService();
    }

    public Long getBizModelFromScheme(Long scheme) {
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"bizrange", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)scheme)});
        if (query == null) {
            return 0L;
        }
        return query.getLong("bizrange");
    }

    public Set<Long> getAccountInPerm(Long model, Long bizModel, DimMembPermType perm, Long usrId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)model);
        HashSet<Long> accountSet = new HashSet<Long>(16);
        if (CentralAppBillService.getInstance().isModelAdmin(model, usrId)) {
            accountSet.addAll(this.getAllAccounts(modelCache, Collections.singleton(bizModel)));
        } else {
            Set<Long> dimMemInPerm = this.getDimMemInPerm(SysDimensionEnum.Account.getNumber(), Collections.singleton(bizModel), model, perm, usrId);
            if (dimMemInPerm != null) {
                accountSet.addAll(dimMemInPerm);
            } else {
                accountSet.addAll(this.getAllAccounts(modelCache, Collections.singleton(bizModel)));
            }
        }
        return accountSet;
    }

    public Set<Long> getAllAccounts(IModelCacheHelper modelCache, Set<Long> bizModels) {
        HashSet<Long> dataSetIds = new HashSet<Long>(16);
        HashSet<Long> accounts = new HashSet<Long>(16);
        bizModels.forEach(e -> dataSetIds.addAll(BusinessModelServiceHelper.getInstance().queryDataSetIds(e)));
        if (dataSetIds.size() == 0) {
            return accounts;
        }
        accounts.addAll(this.getAccountByDatasets(modelCache, dataSetIds));
        return accounts;
    }

    private Set<Long> getAccountByDatasets(IModelCacheHelper modelCache, Set<Long> dataSetIds) {
        Set<Long> memList = new HashSet<Long>(16);
        if (CollectionUtils.isEmpty(dataSetIds)) {
            return memList;
        }
        memList = modelCache.getMembers(null, SysDimensionEnum.Account.getNumber()).stream().filter(Member::isLeaf).map(BaseCache::getId).collect(Collectors.toSet());
        return memList;
    }

    public Set<Long> getDimMemInPerm(String dimNum, Set<Long> bizModels, Long model, DimMembPermType perm, Long usrId) {
        HashSet<Long> dimMem = new HashSet<Long>(16);
        for (Long bizModel : bizModels) {
            Set permMemIds = DimMembPermHelper.getPermMembIds((String)dimNum, (Long)model, (Long)bizModel, (Long)0L, (DimMembPermType)perm, (boolean)true);
            if (permMemIds == null) {
                return null;
            }
            if (permMemIds.size() == 0) continue;
            dimMem.addAll(permMemIds);
        }
        return dimMem;
    }

    public void filterByPlans(ApproveBill approveBill, List<ApprovePlan> plans, CentralAppShowInfo showInfo) {
        boolean needAccount = true;
        HashSet accounts = new HashSet(16);
        HashSet templateSet = new HashSet(16);
        HashSet preEntitySet = new HashSet(16);
        Set curPlans = showInfo.getCurPlans();
        Set curCentralScheme = showInfo.getCurCentralScheme();
        Long usrId = UserUtils.getUserId();
        ApprovePlanUtil instance = ApprovePlanUtil.getInstance();
        for (ApprovePlan plan : plans) {
            boolean isApprover = false;
            if (plan.isCenApprove().booleanValue()) {
                List centralPlans = plan.getCentralPlans();
                List<CentralScheme> centralSchemes = instance.getCentralSchemesById(centralPlans, true);
                for (CentralScheme centralScheme : centralSchemes) {
                    Set approvers = centralScheme.getApprovers();
                    if (!approvers.contains(usrId)) continue;
                    preEntitySet.addAll(centralScheme.getEntities());
                    accounts.addAll(centralScheme.getAccounts());
                    curCentralScheme.add(centralScheme.getId());
                    isApprover = true;
                }
            } else {
                HashSet approverIds = new HashSet(16);
                Map approvers = plan.getApprovers();
                approvers.forEach((key, value) -> approverIds.addAll(instance.getApprovers((ApproverTypeEnum)key, (List<ApproverDto>)value, approveBill)));
                if (approverIds.contains(usrId)) {
                    isApprover = true;
                }
                needAccount = false;
            }
            if (!isApprover) continue;
            curPlans.add(plan.getNumber());
            templateSet.addAll(plan.getTemplates());
        }
        if (preEntitySet.size() != 0) {
            Set orgSet = showInfo.getEntitySet();
            orgSet.retainAll(preEntitySet);
            showInfo.setEntitySet(orgSet);
        }
        if (templateSet.size() != 0) {
            Set templates = showInfo.getTemplates();
            templates.retainAll(templateSet);
            showInfo.setTemplates(templates);
        }
        if (curPlans.size() != 0 && needAccount) {
            showInfo.setAccountSet(accounts);
        }
    }

    public void getEntryInfos(List<ApproveBillEntry> entity, Set<String> billNos, Set<Long> templates, Set<Long> orgSet, Long modelId) {
        if (entity == null || entity.size() == 0) {
            return;
        }
        HashSet centralOrg = new HashSet(16);
        entity.forEach(e -> {
            billNos.add(e.getReportBillNo());
            templates.add(e.getTemplate());
            orgSet.add(e.getEntity());
            Long centralEntity = e.getCentralEntity();
            if (centralEntity != 0L) {
                centralOrg.add(centralEntity);
            }
        });
        if (centralOrg.size() != 1 || !centralOrg.contains(0L)) {
            centralOrg.forEach(e -> orgSet.addAll(CentralAppBillService.getInstance().getEntities((Long)e, 0L, modelId, RangeEnum.ALL_DETAIL_INCLUDE.getIndex())));
        }
    }
}

