/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.centralapproval.CentralApprovePlanService;
import kd.epm.eb.business.centralapproval.GetUsersUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillEntry;
import kd.epm.eb.common.centralapproval.ApprovePlan;
import kd.epm.eb.common.centralapproval.ApproverRelationEnum;
import kd.epm.eb.common.centralapproval.ApproverTypeEnum;
import kd.epm.eb.common.centralapproval.CentralScheme;
import kd.epm.eb.common.centralapproval.CentralSchemeMutexInfo;
import kd.epm.eb.common.centralapproval.entity.ApproverDto;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections.CollectionUtils;

public class ApprovePlanUtil {
    private static final Log log = LogFactory.getLog(ApprovePlanUtil.class);
    private static final ApprovePlanUtil instance = new ApprovePlanUtil();

    public static ApprovePlanUtil getInstance() {
        return instance;
    }

    public List<ApprovePlan> getApprovePlansByNumber(Set<String> numbers, Long modelId) {
        if (numbers == null || numbers.size() == 0) {
            return new ArrayList<ApprovePlan>(16);
        }
        return CentralApprovePlanService.getInstance().getApprovePlanCfgByNumbers(numbers, modelId);
    }

    public List<CentralScheme> getCentralSchemesById(List<Long> cenSchemes, Boolean isAllDetail) {
        QFilter qFilter = new QFilter("id", "in", cenSchemes);
        return this.getCentralSchemes(qFilter, isAllDetail);
    }

    public List<CentralScheme> getCentralSchemes(QFilter qFilter, Boolean isAllDetail) {
        Map load;
        ArrayList<CentralScheme> centralScheme = new ArrayList<CentralScheme>(16);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "eb_centralscheme", null);
        log.info("ApprovePlanUtil.getIdList: " + idList.toString());
        if (idList.size() != 0 && (load = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(), (String)"eb_centralscheme")) != null) {
            for (DynamicObject dynamicObject : load.values()) {
                centralScheme.add(this.packageCentralSchemeObject(dynamicObject, isAllDetail));
            }
        }
        return centralScheme;
    }

    public CentralScheme packageCentralSchemeObject(DynamicObject object, Boolean isAllDetail) {
        IModelCacheHelper modelCacheHelper;
        if (object == null) {
            return null;
        }
        Long id = object.getLong("id");
        String name = object.getString("name");
        String number = object.getString("number");
        Boolean status = object.getBoolean("status");
        Long centralEntity = object.getLong("entitynumber.id");
        Long modelId = object.getLong("model.id");
        Long modifier = object.getLong("modifier.id");
        Date modifyDate = object.getDate("modifydate");
        Long bizModelId = object.getLong("bizrange.id");
        DynamicObjectCollection entryEntity1 = object.getDynamicObjectCollection("entryentity1");
        HashSet accountSet = new HashSet(16);
        if (entryEntity1 != null && entryEntity1.size() > 0) {
            for (DynamicObject k : entryEntity1) {
                String accountNumber = k.getString("accountnumber.number");
                int accountRange = k.getInt("accountscope");
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                List members = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber, accountRange);
                if (members == null || members.size() <= 0) continue;
                members.forEach(h -> accountSet.add(h.getId()));
            }
        }
        HashSet<Long> approver = new HashSet<Long>(16);
        Long collectEntity = null;
        DynamicObjectCollection entryentity2 = object.getDynamicObjectCollection("entryentity2");
        HashSet orgSet = new HashSet(16);
        if (entryentity2 != null && entryentity2.size() > 0) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Long orgView = modelCacheHelper.getViewByBusModelAndDimNumber(bizModelId, SysDimensionEnum.Entity.getNumber());
            for (DynamicObject k : entryentity2) {
                DynamicObjectCollection dynamicObjectCollection;
                String orgNumber = k.getString("entitynumber1.number");
                int orgScope = k.getInt("orgscope");
                List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgView, orgNumber, orgScope);
                if (members != null && members.size() > 0) {
                    members.forEach(h -> {
                        if (!isAllDetail.booleanValue()) {
                            orgSet.add(h.getId());
                        } else if (h.isLeaf()) {
                            orgSet.add(h.getId());
                        } else {
                            List leafMembers = h.getLeaf();
                            leafMembers.forEach(m -> orgSet.add(m.getId()));
                        }
                    });
                }
                if (approver.size() == 0 && (dynamicObjectCollection = k.getDynamicObjectCollection("checker")) != null && dynamicObjectCollection.size() != 0) {
                    for (DynamicObject checkerObject : dynamicObjectCollection) {
                        approver.add((Long)checkerObject.get("fbasedataid.id"));
                    }
                }
                if (collectEntity != null) continue;
                DynamicObject collectOrgObject = k.getDynamicObject("collectorg");
                collectEntity = collectOrgObject.getLong("id");
            }
        }
        CentralScheme centralScheme = new CentralScheme(id, name, number, status, modifier, modifyDate, accountSet, orgSet, centralEntity, collectEntity, approver);
        centralScheme.setBizRangeId(bizModelId);
        return centralScheme;
    }

    public boolean exist(Long modelId, String field, String expectStr, Long schemeId) {
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter(field, "=", (Object)expectStr);
        if (schemeId != null && schemeId != 0L) {
            qf2.and(new QFilter("id", "!=", (Object)schemeId));
        }
        return QueryServiceHelper.exists((String)"eb_centralscheme", (QFilter[])new QFilter[]{qf1, qf2});
    }

    public void updateStatus(boolean status, List<Long> schemeIds) {
        DynamicObject[] objs;
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"eb_centralscheme", (String)"id,status,modifier,modifydate", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)})) {
            obj.set("status", (Object)status);
            obj.set("modifier", (Object)userId);
            obj.set("modifydate", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public void deleteSchemes(List<Long> schemeIds) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"eb_centralscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)});
            }
            catch (Throwable e) {
                log.error(e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public Set<Long> getApprovers(ApproverTypeEnum type, List<ApproverDto> approvers, ApproveBill approveBill) {
        HashSet<Long> approverIds = new HashSet<Long>(16);
        approvers.forEach(e -> {
            String auditorType = e.getAuditortype();
            if (type.getValue().equals(auditorType)) {
                switch (type) {
                    case PERSON: {
                        Long person = e.getPerson();
                        if (person == null || person == 0L) break;
                        approverIds.add(person);
                        break;
                    }
                    case RELATE: {
                        ApproverRelationEnum relation = e.getRelation();
                        String referField = e.getReferenceperson();
                        approverIds.addAll(this.getRelationApprovers(relation, referField, approveBill));
                        break;
                    }
                    case WORKFLOW_ROLE: {
                        Long role = e.getWfrole();
                        approverIds.addAll(this.getApproversByWorkFlowRole(role, approveBill));
                        break;
                    }
                }
            }
        });
        return approverIds;
    }

    private Set<Long> getApproversByWorkFlowRole(Long role, ApproveBill approveBill) {
        HashSet<Long> approvers = new HashSet<Long>(16);
        DynamicObject wf_role = BusinessDataServiceHelper.loadSingle((Object)role, (String)"wf_role");
        if (wf_role == null) {
            return approvers;
        }
        HashMap<Long, Long> orgApproverMap = new HashMap<Long, Long>(16);
        DynamicObjectCollection roleEntries = wf_role.getDynamicObjectCollection("roleentry");
        for (DynamicObject roleEntry : roleEntries) {
            DynamicObject org = roleEntry.getDynamicObject("org");
            if (org == null) continue;
            Long orgId = org.getLong("id");
            DynamicObject user = roleEntry.getDynamicObject("user");
            if (user == null) {
                String alternateType = roleEntry.getString("alternatetype");
                if ("superior".equals(alternateType)) {
                    orgApproverMap.put(orgId, -1L);
                    continue;
                }
                DynamicObject alternateUser = roleEntry.getDynamicObject("alternateuser");
                if (alternateUser == null) continue;
                orgApproverMap.put(orgId, alternateUser.getLong("id"));
                continue;
            }
            String enable = user.getString("enable");
            if ("0".equalsIgnoreCase(enable)) continue;
            orgApproverMap.put(orgId, user.getLong("id"));
        }
        Set<Long> reporters = this.getReporters(approveBill);
        reporters.forEach(e -> {
            Long approver;
            long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)e);
            if (userMainOrgId != 0L && (approver = this.getSuperApprover((Map<Long, Long>)orgApproverMap, userMainOrgId, (Long)e)) != 0L) {
                approvers.add(approver);
            }
        });
        return approvers;
    }

    private Long getSuperApprover(Map<Long, Long> orgApproverMap, Long userMainOrgId, Long userId) {
        Long approver = 0L;
        Long approverInfo = orgApproverMap.get(userMainOrgId);
        if (approverInfo == null || approverInfo == 0L) {
            Map superOrgIdMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", Collections.singletonList(userMainOrgId));
            if (superOrgIdMap.size() != 0) {
                approver = this.getSuperApprover(orgApproverMap, (Long)superOrgIdMap.get(userMainOrgId), userId);
            }
        } else {
            Set<Long> superiors;
            approver = approverInfo;
            if (approver == -1L && (superiors = GetUsersUtil.getInstance().getUsersByType(Collections.singleton(userId), ApproverRelationEnum.DIRECT_SUPERIOR, false)).size() != 0) {
                approver = superiors.iterator().next();
            }
        }
        return approver;
    }

    private Set<Long> getRelationApprovers(ApproverRelationEnum relation, String referField, ApproveBill approveBill) {
        if (StringUtils.isEmpty((String)referField)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5ba1\u6279\u5355\u4e2d\u7684\u53c2\u7167\u4eba\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"CentralWorkflowApprover_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Set<Long> reporter = this.getReportersByReferField(referField, approveBill);
        if (reporter.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5ba1\u6279\u5355\u4e2d\u7684\u53c2\u7167\u4eba\u4fe1\u606f\u3002", (String)"CentralWorkflowApprover_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (relation == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u65b9\u6848\u4e2d\u7684\u884c\u653f\u5ba1\u6279\u5173\u7cfb\u3002", (String)"CentralWorkflowApprover_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return GetUsersUtil.getInstance().getUsersByType(reporter, relation, false);
    }

    private Set<Long> getReportersByReferField(String referField, ApproveBill approveBill) {
        HashSet<Long> reporters = new HashSet<Long>(16);
        switch (referField) {
            case "creater": {
                reporters.add(approveBill.getCreator());
                break;
            }
            case "modifier": {
                reporters.add(approveBill.getModifier());
                break;
            }
            case "auditor": {
                reporters.add(approveBill.getAuditor());
                break;
            }
            case "reporter": {
                reporters.addAll(this.getReporters(approveBill));
                break;
            }
            default: {
                reporters.addAll(this.getOtherBaseDataFieldInBill(referField, approveBill));
            }
        }
        return reporters;
    }

    private Set<Long> getReporters(ApproveBill approveBill) {
        List approveBillEntries = approveBill.getApproveBillEntries();
        return approveBillEntries.stream().map(ApproveBillEntry::getReporter).collect(Collectors.toSet());
    }

    public Set<Long> getOtherBaseDataFieldInBill(String referField, ApproveBill approveBill) {
        HashSet<Long> fieldData = new HashSet<Long>(16);
        Long id = approveBill.getId();
        if (approveBill.getParentId() != null && approveBill.getParentId() > 0L) {
            id = approveBill.getParentId();
        }
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_centralappbill");
        DynamicObjectType dataEntityType = bill.getDynamicObjectType();
        fieldData.addAll(this.getBaseDataFieldInDynamicObject(referField, dataEntityType, bill, null));
        if (fieldData.size() == 0) {
            DynamicObjectCollection centralAppRptEntity = bill.getDynamicObjectCollection("centralapprptentity");
            DynamicObjectType dynamicObjectType = centralAppRptEntity.getDynamicObjectType();
            fieldData.addAll(this.getBaseDataFieldInDynamicObject(referField, dynamicObjectType, null, centralAppRptEntity));
        }
        return fieldData;
    }

    private Set<Long> getBaseDataFieldInDynamicObject(String referField, DynamicObjectType dataEntityType, DynamicObject bill, DynamicObjectCollection entryEntity) {
        HashSet<Long> reporters = new HashSet<Long>(16);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            Class propertyType;
            String typeName;
            String name = property.getName();
            if (!referField.equals(name) || !(typeName = (propertyType = property.getPropertyType()).getName()).contains("DynamicObject")) continue;
            if (bill != null) {
                DynamicObject dynamicObject = bill.getDynamicObject(referField);
                if (dynamicObject == null) continue;
                reporters.add(bill.getDynamicObject(referField).getLong("id"));
                continue;
            }
            reporters.addAll(entryEntity.stream().map(e -> e.getLong(referField + ".id")).collect(Collectors.toSet()));
        }
        return reporters;
    }

    public Map<Long, CentralSchemeMutexInfo> getCentralSchemeMutexInfo(final Set<Long> curCentralSchemeIds, final Set<Long> othersCentralSchemeIds) {
        HashMap<Long, CentralSchemeMutexInfo> map = new HashMap<Long, CentralSchemeMutexInfo>(16);
        HashSet<Long> allSchemeIds = new HashSet<Long>(16){
            {
                super(x0);
                this.addAll(curCentralSchemeIds);
                this.addAll(othersCentralSchemeIds);
            }
        };
        List<CentralScheme> centralSchemes = this.getCentralSchemesById(new ArrayList<Long>(allSchemeIds), true);
        if (centralSchemes == null) {
            return map;
        }
        Map<Long, CentralScheme> centralSchemeMap = centralSchemes.stream().collect(Collectors.toMap(CentralScheme::getId, u -> u));
        HashSet entities = new HashSet(16);
        HashSet accounts = new HashSet(16);
        for (Long curSchemeId : curCentralSchemeIds) {
            if (centralSchemeMap.get(curSchemeId) == null) continue;
            entities.addAll(centralSchemeMap.get(curSchemeId).getEntities());
            accounts.addAll(centralSchemeMap.get(curSchemeId).getAccounts());
        }
        for (Long otherSchemeId : othersCentralSchemeIds) {
            if (centralSchemeMap.get(otherSchemeId) == null) continue;
            HashSet mutexEntities = new HashSet(CollectionUtils.retainAll(entities, (Collection)centralSchemeMap.get(otherSchemeId).getEntities()));
            HashSet mutexAccounts = new HashSet(CollectionUtils.retainAll(accounts, (Collection)centralSchemeMap.get(otherSchemeId).getAccounts()));
            if (!CollectionUtils.isNotEmpty(mutexEntities) || !CollectionUtils.isNotEmpty(mutexAccounts)) continue;
            CentralSchemeMutexInfo centralSchemeMutexInfo = new CentralSchemeMutexInfo(centralSchemeMap.get(otherSchemeId).getId(), centralSchemeMap.get(otherSchemeId).getNumber(), centralSchemeMap.get(otherSchemeId).getName(), mutexAccounts, mutexEntities);
            map.put(otherSchemeId, centralSchemeMutexInfo);
        }
        return map;
    }
}

