/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.AuditRecordObj;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.centralapproval.AdjustRecordColInfo;
import kd.epm.eb.common.centralapproval.AppAdjustRecord;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.AppRecordColType;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillConfig;
import kd.epm.eb.common.centralapproval.ApproveBillEntry;
import kd.epm.eb.common.centralapproval.ApproveRecord;
import kd.epm.eb.common.centralapproval.ApproveRecordEntry;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.centralapproval.RecordSearchEntry;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;

public class ApproveRecordUtil {
    private static final ApproveRecordUtil instance = new ApproveRecordUtil();
    private static final Log log = LogFactory.getLog(ApproveRecordUtil.class);

    public static ApproveRecordUtil getInstance() {
        return instance;
    }

    public void saveAdjustRecord(List<AuditRecordObj> recordList, Map<Long, Map<String, Long>> hideDimMap, Map<String, Map<String, Long>> colDimMap, Set<String> approvePlans, Set<Long> centralSchemes, Long modelId, String billNumber, String adjustType, String rejectBillNo, String nodeNumber, String nodeName) {
        if (recordList == null || recordList.size() == 0) {
            return;
        }
        ApproveBill approve = this.getApproveBill(billNumber, modelId);
        ArrayList<AppAdjustRecord> records = new ArrayList<AppAdjustRecord>(16);
        String curPlan = String.join((CharSequence)",", approvePlans);
        String curScheme = centralSchemes.stream().map(String::valueOf).collect(Collectors.joining(","));
        long usrId = UserUtils.getUserId();
        Date time = TimeServiceHelper.now();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (AuditRecordObj row : recordList) {
            this.addNewRowToApproveBill(approve, row, usrId, time);
            AppAdjustRecord record = new AppAdjustRecord(billNumber, modelId, curPlan, curScheme, adjustType, rejectBillNo);
            record.setNodeName(nodeName);
            record.setNodeNumber(nodeNumber);
            this.fillRecordInfo(record, row, hideDimMap, colDimMap, modelCacheHelper, usrId, time);
            records.add(record);
        }
        try (TXHandle tx = TX.required((String)"insertAdjustRecord");){
            try {
                if (records.size() != 0) {
                    this.saveAdjRecords(records);
                    if (approve != null) {
                        ApproveBillUtil.getInstance().save(Collections.singletonList(approve));
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ResManager.loadResFormat((String)"\u4fdd\u5b58\u5ba1\u6279\u8c03\u6574\u8bb0\u5f55\u5931\u8d25\uff1a%1", (String)"CentralAppBillService_9", (String)"epm-eb-business", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void saveAdjRecords(List<AppAdjustRecord> recordInfos) {
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(16);
        for (AppAdjustRecord recordInfo : recordInfos) {
            DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralappadjrecord");
            record.set("approvebillno", (Object)recordInfo.getApproveBill());
            record.set("model", (Object)recordInfo.getModel());
            record.set("template", (Object)recordInfo.getTemplate());
            List dimMembers = recordInfo.getDimMembers();
            for (int i = 0; i < dimMembers.size(); ++i) {
                record.set("dim" + (i + 1), dimMembers.get(i));
            }
            record.set("approveplans", (Object)recordInfo.getCurPlans());
            record.set("centralschemes", (Object)recordInfo.getCurCentralScheme());
            record.set("approver", (Object)recordInfo.getApprover());
            record.set("org", (Object)recordInfo.getOrg());
            record.set("approvedate", (Object)recordInfo.getApproveTime());
            record.set("adjusttype", (Object)recordInfo.getAdjustType());
            String rejectBillNo = recordInfo.getRejectBillNo();
            record.set("rejectbillno", (Object)(StringUtils.isEmpty((String)rejectBillNo) ? "" : rejectBillNo));
            record.set("nodenumber", (Object)recordInfo.getNodeNumber());
            record.set("nodename", (Object)recordInfo.getNodeName());
            DynamicObjectCollection entryEntity = record.getDynamicObjectCollection("entryentity");
            this.fillRecordEntityData(entryEntity, recordInfo.getColDataInfos());
            records.add(record);
        }
        SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
    }

    private void fillRecordEntityData(DynamicObjectCollection entryEntity, List<AdjustRecordColInfo> colDataInfos) {
        if (colDataInfos == null) {
            return;
        }
        for (AdjustRecordColInfo colDataInfo : colDataInfos) {
            DynamicObject entry = entryEntity.addNew();
            entry.set("colkey", (Object)colDataInfo.getKey());
            entry.set("coltype", (Object)colDataInfo.getType().getValue());
            entry.set("dimrange", (Object)String.join((CharSequence)";", colDataInfo.getDimMembers()));
            entry.set("preadjust", (Object)(colDataInfo.getPreAdjust() == null ? "" : colDataInfo.getPreAdjust().toString()));
            entry.set("afteradjust", (Object)(colDataInfo.getAfterAdjust() == null ? "" : colDataInfo.getAfterAdjust().toString()));
            entry.set("dimrangehash", (Object)String.valueOf(colDataInfo.getMemberHashCode()));
        }
    }

    private void fillRecordInfo(AppAdjustRecord record, AuditRecordObj row, Map<Long, Map<String, Long>> hideDimMap, Map<String, Map<String, Long>> colDimMap, IModelCacheHelper modelCacheHelper, Long usrId, Date time) {
        Long templateId = row.getTemplateId();
        record.setTemplate(templateId);
        Long dataSetId = row.getDataSetId();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(dataSetId);
        List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
        Map rowDimGroup = row.getRowDimGroup();
        rowDimGroup.putAll(hideDimMap.get(templateId));
        HashMap<String, String> dimRange = new HashMap<String, String>(16);
        List<String> dimMembers = this.dealDimGroup(dimensionList, dimRange, rowDimGroup, modelCacheHelper, dimViewMap);
        record.setDimMembers(dimMembers);
        List changeDataInfos = row.getChangeDataInfos();
        for (AdjustRecordColInfo changeDataInfo : changeDataInfos) {
            AppRecordColType type = changeDataInfo.getType();
            if (AppRecordColType.MEASURE == type) {
                String key = changeDataInfo.getKey();
                Map<String, Long> colDimGroup = colDimMap.get(key);
                List<String> members = this.dealDimGroup(dimensionList, dimRange, colDimGroup, modelCacheHelper, dimViewMap);
                changeDataInfo.setDimMembers(members);
            }
            MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimRange, dimensionList);
            int hashCode = membersKey.hashCode();
            changeDataInfo.setMemberHashCode(Integer.valueOf(hashCode));
        }
        record.setColDataInfos(changeDataInfos);
        record.setApprover(usrId);
        long org = UserServiceHelper.getUserMainOrgId((long)usrId);
        record.setOrg(Long.valueOf(org));
        record.setApproveTime(time);
    }

    private List<String> dealDimGroup(List<Dimension> dimensionList, Map<String, String> dimRange, Map<String, Long> dimGroup, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap) {
        ArrayList<String> dimMembers = new ArrayList<String>(16);
        for (Dimension dimension : dimensionList) {
            String number = dimension.getNumber();
            Long memberId = dimGroup.get(number);
            if (memberId == null) continue;
            Member member = modelCacheHelper.getMember(number, dimViewMap.get(number), memberId);
            if (member == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u4fdd\u5b58\u5ba1\u6279\u8c03\u6574\u8bb0\u5f55\u5931\u8d25\uff0c\u7ef4\u5ea6%1\u7684\u6210\u5458%2\u4e0d\u5b58\u5728\u3002", (String)"ApproveRecordUtil_0", (String)"epm-eb-business", (Object[])new Object[]{number}));
            }
            dimRange.put(number, member.getNumber());
            dimMembers.add(number + "!" + memberId);
        }
        return dimMembers;
    }

    public void addNewRowToApproveBill(ApproveBill approveBill, AuditRecordObj row, long usrId, Date time) {
        Set centralEntities;
        if (approveBill == null || !row.isNew()) {
            return;
        }
        List approveBillEntries = approveBill.getApproveBillEntries();
        ApproveBillEntry billEntry = new ApproveBillEntry();
        billEntry.setReportBillNo("0");
        billEntry.setReportType("0");
        billEntry.setTemplate(row.getTemplateId());
        Map dimGroup = row.getRowDimGroup();
        if (dimGroup == null) {
            return;
        }
        long entity = (Long)dimGroup.get(SysDimensionEnum.Entity.getNumber());
        billEntry.setEntity(Long.valueOf(entity));
        if (!(entity == 0L || (centralEntities = approveBillEntries.stream().map(ApproveBillEntry::getCentralEntity).collect(Collectors.toSet())).size() == 1 && centralEntities.contains(0L))) {
            for (Long centralEntity : centralEntities) {
                Set<Long> entities = CentralAppBillService.getInstance().getEntities(centralEntity, 0L, approveBill.getModel(), RangeEnum.ALL_DETAIL.getIndex());
                if (!entities.contains(entity)) continue;
                billEntry.setCentralEntity(centralEntity);
                break;
            }
        }
        billEntry.setReporter(Long.valueOf(usrId));
        billEntry.setReportDate(time);
        approveBillEntries.add(billEntry);
    }

    private ApproveBill getApproveBill(String billNo, Long modelId) {
        if (StringUtils.isEmpty((String)billNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u636e\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ApproveRecordUtil_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
        qFilter.and(new QFilter("model", "=", (Object)modelId));
        return ApproveBillUtil.getInstance().getApproveBill(qFilter);
    }

    public List<AppAdjustRecord> getAppAdjustRecords(QFilter qFilter) {
        DynamicObject[] records;
        ArrayList<AppAdjustRecord> recordToSave = new ArrayList<AppAdjustRecord>(16);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "eb_centralappadjrecord", null);
        if (idList != null && idList.size() != 0 && (records = (DynamicObject[])BusinessDataServiceHelper.load((Object[])idList.toArray(), (IDataEntityType)ORM.create().getDataEntityType("eb_centralappadjrecord"))) != null && records.length != 0) {
            for (DynamicObject record : records) {
                recordToSave.add(this.createAppAdjustRecord(record));
            }
        }
        return recordToSave;
    }

    public List<AppAdjustRecord> getAppAdjustRecordNew(QFilter qFilter) {
        DynamicObject[] records;
        ArrayList<AppAdjustRecord> recordToSave = new ArrayList<AppAdjustRecord>(16);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "eb_centralappadjrecord", null);
        if (idList != null && idList.size() != 0 && (records = (DynamicObject[])BusinessDataServiceHelper.load((Object[])idList.toArray(), (IDataEntityType)ORM.create().getDataEntityType("eb_centralappadjrecord"))) != null && records.length != 0) {
            for (DynamicObject record : records) {
                recordToSave.add(this.createAppAdjustRecord(record));
            }
        }
        return recordToSave;
    }

    private AppAdjustRecord createAppAdjustRecord(DynamicObject record) {
        String billNo = record.getString("approvebillno");
        Long model = record.getLong("model.id");
        AppAdjustRecord appAdjustRecord = new AppAdjustRecord(billNo, model);
        appAdjustRecord.setTemplate(Long.valueOf(record.getLong("template.id")));
        HashMap<String, Long> dimMemberMap = new HashMap<String, Long>(16);
        for (int i = 1; i < 19; ++i) {
            String dimMem = record.getString("dim" + i);
            if (StringUtils.isEmpty((String)dimMem)) continue;
            String[] split = dimMem.split("!");
            dimMemberMap.put(split[0], IDUtils.toLong((Object)split[1]));
        }
        appAdjustRecord.setDimMemberMap(dimMemberMap);
        appAdjustRecord.setCurPlans(record.getString("approveplans"));
        appAdjustRecord.setCurCentralScheme(record.getString("centralschemes"));
        appAdjustRecord.setApprover(Long.valueOf(record.getLong("approver.id")));
        appAdjustRecord.setOrg(Long.valueOf(record.getLong("org.id")));
        appAdjustRecord.setApproveTime(record.getDate("approvedate"));
        appAdjustRecord.setAdjustType(record.getString("adjusttype"));
        appAdjustRecord.setRejectBillNo(record.getString("rejectbillno"));
        appAdjustRecord.setNodeName(record.getString("nodename"));
        appAdjustRecord.setNodeNumber(record.getString("nodenumber"));
        DynamicObjectCollection entryEntity = record.getDynamicObjectCollection("entryentity");
        appAdjustRecord.setColDataInfos(this.createColDataInfos(entryEntity));
        return appAdjustRecord;
    }

    private List<AdjustRecordColInfo> createColDataInfos(DynamicObjectCollection entryEntity) {
        ArrayList<AdjustRecordColInfo> colInfos = new ArrayList<AdjustRecordColInfo>(16);
        for (DynamicObject entry : entryEntity) {
            AdjustRecordColInfo colInfo = new AdjustRecordColInfo();
            colInfo.setKey(entry.getString("colkey"));
            colInfo.setType(AppRecordColType.getTypeByValue((String)entry.getString("coltype")));
            colInfo.setPreAdjust((Object)entry.getString("preadjust"));
            colInfo.setAfterAdjust((Object)entry.getString("afteradjust"));
            colInfo.setMemberHashCode(Integer.valueOf(Integer.parseInt(entry.getString("dimrangehash"))));
            colInfo.setPkId(Long.valueOf(entry.getLong("id")));
            colInfos.add(colInfo);
        }
        return colInfos;
    }

    public List<AppAdjustRecord> getAppAdjustRecords(Map<String, Set<Long>> memberMap, Long templateId, Long dataSetId, Long modelId, Map<String, Map<String, String>> varInfo) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("template", "=", (Object)templateId));
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
        DynamicObject template = QueryServiceHelper.queryOne((String)"eb_applytemplate", (String)"cachedata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        Map<String, Long> hiddenDimMemMap = BgApplyBillUtils.getInstance().getHiddenDimMemMap(template.getString("cachedata_tag"), dataSetId, modelCacheHelper, varInfo);
        int index = 1;
        for (Dimension dimension : dimensionList) {
            String number = dimension.getNumber();
            if (hiddenDimMemMap.containsKey(number)) {
                ++index;
                continue;
            }
            Set<Long> members = memberMap.get(number);
            if (members == null || members.size() == 0) continue;
            HashSet dimMembers = new HashSet(16);
            members.forEach(e -> dimMembers.add(number + "!" + e));
            String field = "dim" + index;
            qFilter.and(new QFilter(field, "in", dimMembers));
            ++index;
        }
        return this.getAppAdjustRecords(qFilter);
    }

    public List<AppAdjustRecord> getAppAdjustRecords(RecordSearchEntry recordSearchEntry) {
        Long model = recordSearchEntry.getModel();
        Long template = recordSearchEntry.getTemplate();
        QFilter qFilter = new QFilter("model", "=", (Object)model);
        AdjustShowTypeEnum type = recordSearchEntry.getType();
        if (AdjustShowTypeEnum.Adjust == type) {
            Long dataSetId = recordSearchEntry.getDataSetId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(model, recordSearchEntry.getReportSchemeId(), recordSearchEntry.getYearId(), recordSearchEntry.getVersionId(), recordSearchEntry.getDataTypeId());
            Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
            List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
            Map viewIds = modelCacheHelper.getViewsByDataSet(dataSetId);
            Map rowDimMembers = recordSearchEntry.getRowDimMembers();
            QFilter qFilter1 = this.getQFilterByRowDims(dimensionList, viewIds, rowDimMembers, modelCacheHelper, template, varInfo);
            qFilter.and(qFilter1);
        } else {
            qFilter.and(new QFilter("approvebillno", "=", (Object)recordSearchEntry.getBillNo()));
            log.info("getRecords: " + qFilter.toString());
        }
        return this.getAppAdjustRecords(qFilter);
    }

    public List<AppAdjustRecord> getAppAdjustRecordNew(RecordSearchEntry recordSearchEntry, List<String> billnos) {
        Long model = recordSearchEntry.getModel();
        Long template = recordSearchEntry.getTemplate();
        QFilter qFilter = new QFilter("model", "=", (Object)model);
        AdjustShowTypeEnum type = recordSearchEntry.getType();
        if (AdjustShowTypeEnum.Adjust == type) {
            Long dataSetId = recordSearchEntry.getDataSetId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(model, recordSearchEntry.getReportSchemeId(), recordSearchEntry.getYearId(), recordSearchEntry.getVersionId(), recordSearchEntry.getDataTypeId());
            Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
            List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
            Map viewIds = modelCacheHelper.getViewsByDataSet(dataSetId);
            Map rowDimMembers = recordSearchEntry.getRowDimMembers();
            QFilter qFilter1 = this.getQFilterByRowDims(dimensionList, viewIds, rowDimMembers, modelCacheHelper, template, varInfo);
            qFilter.and(qFilter1);
        } else {
            qFilter.and(new QFilter("approvebillno", "in", billnos));
            log.info("getRecords: " + qFilter.toString());
        }
        return this.getAppAdjustRecordNew(qFilter);
    }

    private QFilter getQFilterByRowDims(List<Dimension> dimensionList, Map<String, Long> viewIds, Map<String, String> rowDimMembers, IModelCacheHelper modelCacheHelper, Long templateId, Map<String, Map<String, String>> varInfo) {
        QFilter qFilter = new QFilter("template", "=", (Object)templateId);
        DynamicObject template = QueryServiceHelper.queryOne((String)"eb_applytemplate", (String)"cachedata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        Map<String, Long> hiddenDimMemMap = BgApplyBillUtils.getInstance().getHiddenDimMemMap(template.getString("cachedata_tag"), viewIds, modelCacheHelper, varInfo);
        int index = 1;
        for (Dimension dimension : dimensionList) {
            String number = dimension.getNumber();
            if (hiddenDimMemMap.containsKey(number)) {
                ++index;
                continue;
            }
            String memberNumber = rowDimMembers.get(number);
            if (!StringUtils.isNotEmpty((String)memberNumber)) continue;
            Member member = modelCacheHelper.getMember(number, viewIds.get(number), memberNumber);
            if (member == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u83b7\u53d6\u5230%1\u7ef4\u5ea6\u7684%2\u6210\u5458\u3002", (String)"ApproveRecordUtil_2", (String)"epm-eb-business", (Object[])new Object[]{number, memberNumber}));
            }
            String dimMember = number + "!" + member.getId();
            String field = "dim" + index;
            qFilter.and(new QFilter(field, "=", (Object)dimMember));
            ++index;
        }
        return qFilter;
    }

    public ApproveRecord getApproveRecord(String billNo) {
        QFilter qFilter = new QFilter("approvebillno", "=", (Object)billNo);
        Object pkId = CentralAppBillService.getInstance().getIdSingle(qFilter, "eb_centralapprecord");
        if (pkId == null) {
            return null;
        }
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"eb_centralapprecord");
        return this.createApproveRecord(record);
    }

    public Set<ApproveRecord> getApproveRecord(String billNo, Long modelId) {
        HashSet<ApproveRecord> records = new HashSet<ApproveRecord>(16);
        HashSet<String> billNos = new HashSet<String>(16);
        CentralAppBillService instance = CentralAppBillService.getInstance();
        CentralAppChain centralAppChain = instance.getCentralAppChainByBills(billNo, modelId);
        billNos.addAll(instance.getCentralAppChainsBillSet(centralAppChain));
        billNos.add(billNo);
        Map<String, ApproveRecord> approveRecords = this.getApproveRecords(billNos);
        if (approveRecords == null || approveRecords.size() == 0) {
            return records;
        }
        records.addAll(approveRecords.values());
        return records;
    }

    public Set<ApproveRecord> getAllApproveRecord(String billNo, Long modelId, List<Map<String, String>> rejectDataList, IModelCacheHelper modelCacheHelper, Set<String> billNos, EntryTemplateConfig entryTemplateConfig) {
        CentralAppBillService instance = CentralAppBillService.getInstance();
        HashSet<ApproveRecord> records = new HashSet<ApproveRecord>(16);
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
        qFilter.and(new QFilter("model", "=", (Object)modelId));
        ApproveBill approveBill = ApproveBillUtil.getInstance().getApproveBill(qFilter);
        if (approveBill == null) {
            return records;
        }
        Long parentId = approveBill.getParentId();
        HashSet reportBills = new HashSet(16);
        approveBill.getApproveBillEntries().forEach(s -> reportBills.add(s.getReportBillNo()));
        String mainBillno = "";
        if (parentId != null && parentId > 0L) {
            DynamicObject mainbill = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)"eb_centralappbill");
            if (mainbill != null) {
                mainBillno = mainbill.getString("billno");
                CentralAppChain centralAppChain = instance.getCentralAppChainByBills(mainBillno, modelId);
                billNos.addAll(instance.getCentralAppChainsBillSet(centralAppChain));
                DynamicObjectCollection centRalAppRptEntity = mainbill.getDynamicObjectCollection("centralapprptentity");
                if (centRalAppRptEntity != null && !centRalAppRptEntity.isEmpty()) {
                    centRalAppRptEntity.forEach(s -> reportBills.add(s.getString("reportbillno")));
                }
            }
        } else {
            CentralAppChain centralAppChain = instance.getCentralAppChainByBills(billNo, modelId);
            billNos.addAll(instance.getCentralAppChainsBillSet(centralAppChain));
        }
        billNos.addAll(reportBills);
        billNos.add(billNo);
        if (StringUtils.isNotEmpty((String)mainBillno)) {
            billNos.remove(mainBillno);
        }
        QFilter removeCancleQf = new QFilter("billno", "in", billNos);
        removeCancleQf.and(new QFilter("billstatus", "=", (Object)AppBillStatusEnum.CANCEL));
        DynamicObjectCollection cancleBills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"billno", (QFilter[])removeCancleQf.toArray());
        if (cancleBills != null && !cancleBills.isEmpty()) {
            List cancelBillnos = cancleBills.stream().map(s -> s.getString("billno")).collect(Collectors.toList());
            billNos.removeIf(s -> cancelBillnos.contains(s));
        }
        QFilter filter = new QFilter("billno", "in", billNos);
        ArrayList<Long> pkids = new ArrayList<Long>(16);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id", (QFilter[])filter.toArray());
        if (datas != null && !datas.isEmpty()) {
            for (DynamicObject data : datas) {
                pkids.add(data.getLong("id"));
            }
        }
        QFilter filter1 = new QFilter("parentid", "in", pkids);
        filter1.and(new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL));
        DynamicObjectCollection datas1 = QueryServiceHelper.query((String)"eb_centralappbill", (String)"billno", (QFilter[])filter1.toArray());
        if (datas1 != null && !datas1.isEmpty()) {
            for (Object data : datas1) {
                billNos.add(data.getString("billno"));
            }
        }
        billNos.removeIf(s -> s.equals("") || s.equals("0"));
        log.info("ApproveRecordUtil#getAllApproveRecord.billnos:" + SerializationUtils.toJsonString(billNos));
        HashSet<String> copyBillNos = new HashSet<String>(billNos);
        for (Map map : rejectDataList) {
            log.info("ApproveRecordUtil#getAllApproveRecord.billnos2start:" + SerializationUtils.toJsonString((Object)map) + SerializationUtils.toJsonString(billNos));
            List<String> finalMatchBillNo = this.getFinalMatchBillNo(approveBill.getReportEntity(), map, copyBillNos, entryTemplateConfig);
            billNos.retainAll(finalMatchBillNo);
            log.info("ApproveRecordUtil#getAllApproveRecord.billnos2end:" + SerializationUtils.toJsonString((Object)map) + SerializationUtils.toJsonString(billNos));
        }
        Map<String, ApproveRecord> approveRecords = this.getApproveRecords(billNos);
        if (approveRecords == null || approveRecords.isEmpty()) {
            return records;
        }
        QFilter qFilter2 = new QFilter("billno", "in", billNos);
        qFilter2.and(new QFilter("model", "=", (Object)modelId));
        List<ApproveBill> approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter2);
        if (approveBills != null && !approveBills.isEmpty()) {
            for (ApproveBill bill : approveBills) {
                List finds;
                List approveconfig = bill.getApproveconfig();
                boolean mainbill = bill.isMainbill();
                if (approveconfig == null || mainbill || !CollectionUtils.isNotEmpty(finds = approveconfig.stream().filter(s -> !s.getMatchMemberIds().isEmpty()).collect(Collectors.toList()))) continue;
                ArrayList filterdatas = new ArrayList(16);
                for (ApproveBillConfig find : finds) {
                    filterdatas.addAll(find.getMatchMemberIds());
                }
                ArrayList<Boolean> isContainbillno = new ArrayList<Boolean>(16);
                for (Map<String, String> rejectRow : rejectDataList) {
                    boolean allcontain = false;
                    for (Map filterdata : filterdatas) {
                        ArrayList<Boolean> isMatchs = new ArrayList<Boolean>(16);
                        for (Map.Entry<String, String> stringStringEntry : rejectRow.entrySet()) {
                            String rejectDimNumber = stringStringEntry.getKey();
                            Set centralDims = filterdata.keySet();
                            if (!centralDims.contains(rejectDimNumber)) continue;
                            Set centralMembers = (Set)filterdata.get(rejectDimNumber);
                            if (centralMembers == null || centralMembers.isEmpty()) {
                                isMatchs.add(true);
                                continue;
                            }
                            String rejectValues = stringStringEntry.getValue();
                            if (!StringUtils.isNotEmpty((String)rejectValues)) continue;
                            String[] arrvalues = rejectValues.split(",");
                            boolean ischildcontain = false;
                            for (String arrvalue : arrvalues) {
                                Member member = modelCacheHelper.getMember(rejectDimNumber, null, arrvalue);
                                if (member == null || !centralMembers.contains(member.getId())) continue;
                                ischildcontain = true;
                                break;
                            }
                            isMatchs.add(ischildcontain);
                        }
                        if (!isMatchs.isEmpty() && !isMatchs.stream().allMatch(s -> s)) continue;
                        allcontain = true;
                        break;
                    }
                    isContainbillno.add(allcontain);
                }
                if (isContainbillno.stream().allMatch(s -> s)) continue;
                billNos.remove(bill.getBillNo());
                log.info("ApproveRecordUtil#getAllApproveRecord.removebillno:" + bill.getBillNo());
            }
        }
        for (Map.Entry<String, ApproveRecord> stringApproveRecordEntry : approveRecords.entrySet()) {
            String key = stringApproveRecordEntry.getKey();
            ApproveRecord value = stringApproveRecordEntry.getValue();
            if (!billNos.contains(key)) continue;
            records.add(value);
        }
        log.info("ApproveRecordUtil#getAllApproveRecord.records:" + SerializationUtils.toJsonString(records));
        return records;
    }

    private List<String> getFinalMatchBillNo(long spOrg, Map<String, String> rejectData, Set<String> frombillnos, EntryTemplateConfig entryTemplateConfig) {
        List<Object[]> batchBillDataWhere;
        HashSet<String> billnos = new HashSet<String>(16);
        billnos.addAll(frombillnos);
        ArrayList<String> result = new ArrayList<String>(16);
        String wheresql = "";
        long modelId = entryTemplateConfig.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        log.info("ApproveRecordUtil.getFinalMatchBillNo.start.billnos" + SerializationUtils.toJsonString(billnos));
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(entryTemplateConfig.getDatasetId()));
        Map columnMapDimNum = entryTemplateConfig.selectColumnMapDimNum();
        Map<String, String> dimNumberMapkey = columnMapDimNum.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        ArrayList<String> sqls = new ArrayList<String>(16);
        for (Map.Entry<String, String> map : rejectData.entrySet()) {
            String fiedkey;
            String rejectDimNumber = map.getKey();
            String memberNumbers = map.getValue();
            Member member = modelCacheHelper.getMember(rejectDimNumber, (Long)dimViewMap.get(rejectDimNumber), memberNumbers);
            if (member == null || (fiedkey = dimNumberMapkey.get(rejectDimNumber)) == null) continue;
            String sql = " f" + fiedkey + "=" + member.getId();
            sqls.add(sql);
        }
        if (!sqls.isEmpty()) {
            wheresql = String.join((CharSequence)" and ", sqls);
        }
        if (!(batchBillDataWhere = ApplyTemplateUtils.getBatchBillDataWhere(entryTemplateConfig.getEntryTable(), billnos, entryTemplateConfig.getEntryColumns(), wheresql)).isEmpty()) {
            log.info("ApproveRecordUtil.getFinalMatchBillNo.batchBillDataWhere" + SerializationUtils.toJsonString(batchBillDataWhere));
            Object[] objects = batchBillDataWhere.get(0);
            Object billNubmer = objects[2];
            Object billType = objects[1];
            if (billNubmer != null && billType != null) {
                QFilter appFilter;
                if (billType.toString().contains("audit")) {
                    appFilter = new QFilter("billno", "=", (Object)billNubmer.toString());
                    appFilter.and(new QFilter("model", "=", (Object)modelId));
                    DynamicObject auditData = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"id,reportentity,billno,parentid", (QFilter[])appFilter.toArray());
                    if (auditData != null) {
                        long org = auditData.getLong("reportentity");
                        long id = auditData.getLong("id");
                        List<Long> fromToOrgs = this.getFromToOrgs(modelCacheHelper, spOrg, org, dimViewMap);
                        log.info("ApproveRecordUtil#getFinalMatchBillNo.audit:" + SerializationUtils.toJsonString(fromToOrgs));
                        long parentid = auditData.getLong("parentid");
                        if (parentid > 0L) {
                            QFilter otherSubbill = new QFilter("parentid", "=", (Object)parentid);
                            otherSubbill.and(new QFilter("billno", "!=", (Object)billNubmer.toString()));
                            DynamicObjectCollection auditOtherData = QueryServiceHelper.query((String)"eb_centralappbill", (String)"billno", (QFilter[])otherSubbill.toArray());
                            if (auditOtherData != null && !auditOtherData.isEmpty()) {
                                List otherSubbillnos = auditOtherData.stream().map(s -> s.getString("billno")).collect(Collectors.toList());
                                log.info("ApproveRecordUtil#getFinalMatchBillNo.audit.otherSubbillnos.start:" + SerializationUtils.toJsonString(otherSubbillnos));
                                billnos.removeIf(s -> otherSubbillnos.contains(s));
                                log.info("ApproveRecordUtil#getFinalMatchBillNo.audit.otherSubbillnos.end:" + SerializationUtils.toJsonString(billnos));
                            }
                        } else {
                            QFilter allSubbill = new QFilter("parentid", "=", (Object)id);
                            DynamicObjectCollection auditOtherData = QueryServiceHelper.query((String)"eb_centralappbill", (String)"billno", (QFilter[])allSubbill.toArray());
                            if (auditOtherData != null && !auditOtherData.isEmpty()) {
                                List otherSubbillnos = auditOtherData.stream().map(s -> s.getString("billno")).collect(Collectors.toList());
                                log.info("ApproveRecordUtil#getFinalMatchBillNo.audit.allSubbillnos.start:" + SerializationUtils.toJsonString(otherSubbillnos));
                                billnos.removeIf(s -> otherSubbillnos.contains(s));
                                log.info("ApproveRecordUtil#getFinalMatchBillNo.audit.allSubbillnos.end:" + SerializationUtils.toJsonString(billnos));
                            }
                        }
                        List<String> billnoss = this.filterBillnosFromOrg(billnos, fromToOrgs);
                        result.addAll(billnoss);
                    }
                } else {
                    appFilter = new QFilter("billnumber", "=", (Object)billNubmer.toString());
                    appFilter.and(new QFilter("model", "=", (Object)modelId));
                    DynamicObject applyData = QueryServiceHelper.queryOne((String)"eb_bgapplybill", (String)"org,billnumber", (QFilter[])appFilter.toArray());
                    if (applyData != null) {
                        long org = applyData.getLong("org");
                        List<Long> fromToOrgs = this.getFromToOrgs(modelCacheHelper, spOrg, org, dimViewMap);
                        log.info("ApproveRecordUtil#getFinalMatchBillNo.apply:" + SerializationUtils.toJsonString(fromToOrgs));
                        List<String> billnoss = this.filterBillnosFromOrg(billnos, fromToOrgs);
                        if (!billType.toString().contains("collect")) {
                            List<String> otherBillnoFromApply = this.getOtherBillnoFromApply(billNubmer.toString(), modelId);
                            log.info("ApproveRecordUtil#getFinalMatchBillNo.apply.same:" + SerializationUtils.toJsonString(otherBillnoFromApply));
                            if (!otherBillnoFromApply.isEmpty()) {
                                billnoss.removeIf(s -> otherBillnoFromApply.contains(s));
                            }
                        }
                        result.addAll(billnoss);
                    }
                }
            }
        }
        log.info("ApproveRecordUtil#getFinalMatchBillNo.result:" + SerializationUtils.toJsonString(result));
        return result;
    }

    private List<String> filterBillnosFromOrg(Set<String> billNos, List<Long> orgs) {
        QFilter allfilter = new QFilter("billno", "in", billNos);
        allfilter.and(new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL));
        allfilter.and(new QFilter("reportentity", "in", orgs));
        DynamicObjectCollection centralbills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,billno,reportentity", (QFilter[])allfilter.toArray());
        List<String> matchbillnos = centralbills.stream().map(s -> s.getString("billno")).collect(Collectors.toList());
        return matchbillnos;
    }

    private List<String> getOtherBillnoFromApply(String applyNo, long modelId) {
        ArrayList<String> others = new ArrayList<String>(16);
        QFilter filter = new QFilter("centralapprptentity.reportbillno", "in", (Object)applyNo);
        filter.and(new QFilter("centralapprptentity.sumbillno", "=", (Object)""));
        filter.and(new QFilter("model", "=", (Object)modelId));
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_centralappbill", (QFilter[])filter.toArray());
        if (data != null) {
            long year = data.getLong("year.id");
            long version = data.getLong("version.id");
            long datatype = data.getLong("datatype.id");
            long reportscheme = data.getLong("reportscheme.id");
            long reportentity = data.getLong("reportentity.id");
            String sbillno = data.getString("billno");
            QFilter filter2 = new QFilter("year", "in", (Object)year);
            filter2.and(new QFilter("version", "=", (Object)version));
            filter2.and(new QFilter("datatype", "=", (Object)datatype));
            filter2.and(new QFilter("reportscheme", "=", (Object)reportscheme));
            filter2.and(new QFilter("reportentity", "=", (Object)reportentity));
            filter2.and(new QFilter("model", "=", (Object)modelId));
            filter2.and(new QFilter("billno", "!=", (Object)sbillno));
            DynamicObject[] data2 = BusinessDataServiceHelper.load((String)"eb_centralappbill", (String)"billno", (QFilter[])filter2.toArray());
            if (data2 != null && data2.length > 0) {
                others.addAll(Arrays.stream(data2).map(s -> s.getString("billno")).collect(Collectors.toList()));
            }
        }
        return others;
    }

    private List<Long> getFromToOrgs(IModelCacheHelper modelCacheHelper, long fromReportEntity, long toReportEntity, Map<String, Long> dimViewMap) {
        Long viewId = dimViewMap.get(SysDimensionEnum.Entity.getNumber());
        Member fromEntity = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, Long.valueOf(fromReportEntity));
        Member toEntity = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, Long.valueOf(toReportEntity));
        List allMembers = fromEntity.getAllMembers();
        List parents = modelCacheHelper.getParents(viewId, toEntity, true);
        List<Long> allids = allMembers.stream().map(s -> s.getId()).collect(Collectors.toList());
        List parentids = parents.stream().map(s -> s.getId()).collect(Collectors.toList());
        allids.retainAll(parentids);
        return allids;
    }

    public Map<String, ApproveRecord> getApproveRecords(Set<String> billNos) {
        DynamicObject[] records;
        HashMap<String, ApproveRecord> approveRecords = new HashMap<String, ApproveRecord>(16);
        QFilter qFilter = new QFilter("approvebillno", "in", billNos);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "eb_centralapprecord", null);
        if (idList != null && idList.size() != 0 && (records = (DynamicObject[])BusinessDataServiceHelper.load((Object[])idList.toArray(), (IDataEntityType)ORM.create().getDataEntityType("eb_centralapprecord"))) != null && records.length != 0) {
            for (DynamicObject record : records) {
                ApproveRecord approveRecord = this.createApproveRecord(record);
                if (approveRecord == null) continue;
                String billNo = approveRecord.getBillNo();
                approveRecords.put(billNo, approveRecord);
            }
        }
        return approveRecords;
    }

    private ApproveRecord createApproveRecord(DynamicObject record) {
        if (record == null) {
            return null;
        }
        String approveBillNo = record.getString("approvebillno");
        Long model = record.getLong("model.id");
        ApproveRecord approveRecord = new ApproveRecord(approveBillNo, model);
        approveRecord.setId(Long.valueOf(record.getLong("id")));
        DynamicObjectCollection centralAppRecEntity = record.getDynamicObjectCollection("centralapprecentity");
        approveRecord.setApproveRecordEntries(this.createApproveRecordEntry(centralAppRecEntity));
        return approveRecord;
    }

    private List<ApproveRecordEntry> createApproveRecordEntry(DynamicObjectCollection centralAppRecEntity) {
        ArrayList<ApproveRecordEntry> approveRecordEntries = new ArrayList<ApproveRecordEntry>(16);
        if (centralAppRecEntity == null || centralAppRecEntity.size() == 0) {
            return approveRecordEntries;
        }
        for (DynamicObject centralAppRecEntry : centralAppRecEntity) {
            ApproveRecordEntry approveRecordEntry = new ApproveRecordEntry();
            approveRecordEntry.setId(Long.valueOf(centralAppRecEntry.getLong("id")));
            approveRecordEntry.setPlans(centralAppRecEntry.getString("approveplans"));
            approveRecordEntry.setApprover(Long.valueOf(centralAppRecEntry.getLong("approver.id")));
            approveRecordEntry.setAdminOrg(Long.valueOf(centralAppRecEntry.getLong("org.id")));
            approveRecordEntry.setApproveNode(centralAppRecEntry.getString("order"));
            approveRecordEntry.setApproveNodeNumber(centralAppRecEntry.getString("order_number"));
            approveRecordEntry.setAmdinOrgName(centralAppRecEntry.getString("org.name"));
            approveRecordEntry.setApproveStatus(centralAppRecEntry.getString("status"));
            approveRecordEntry.setApproveDate(centralAppRecEntry.getDate("approvedate"));
            approveRecordEntries.add(approveRecordEntry);
        }
        return approveRecordEntries;
    }

    public void saveApproveRecord(Collection<ApproveRecord> approveRecords) {
        DynamicObject[] records = this.toDynamicObjects(approveRecords);
        Object[] result = SaveServiceHelper.save((DynamicObject[])records);
        if (result == null || result.length == 0) {
            SaveServiceHelper.saveOperate((String)"eb_centralapprecord", (DynamicObject[])records);
        }
    }

    private DynamicObject[] toDynamicObjects(Collection<ApproveRecord> approveRecords) {
        ArrayList records = new ArrayList(16);
        approveRecords.forEach(e -> records.add(this.toDynamicObject((ApproveRecord)e)));
        return records.toArray(new DynamicObject[0]);
    }

    private DynamicObject toDynamicObject(ApproveRecord approveRecord) {
        Long id = approveRecord.getId();
        DynamicObject record = null;
        if (id == 0L) {
            record = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralapprecord");
            record.set("approvebillno", (Object)approveRecord.getBillNo());
            record.set("model", (Object)approveRecord.getModel());
        } else {
            record = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_centralapprecord");
        }
        DynamicObjectCollection centralAppRecEntity = record.getDynamicObjectCollection("centralapprecentity");
        List approveRecordEntries = approveRecord.getApproveRecordEntries();
        approveRecordEntries.stream().filter(e -> e.getId() == 0L).forEach(e -> {
            DynamicObject entry = centralAppRecEntity.addNew();
            entry.set("approveplans", (Object)e.getPlans());
            entry.set("approver", (Object)e.getApprover());
            entry.set("org", (Object)e.getAdminOrg());
            entry.set("order", (Object)e.getApproveNode());
            entry.set("order_number", (Object)e.getApproveNodeNumber());
            entry.set("status", (Object)e.getApproveStatus());
            entry.set("approvedate", (Object)e.getApproveDate());
        });
        record.set("centralapprecentity", (Object)centralAppRecEntity);
        return record;
    }
}

