/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.form.operate.flowchart.AbstractViewFlowchart;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.epm.eb.business.applybill.util.ApplyBillAttachmentHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.business.centralapproval.AppBillDataFilterService;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApprovePlanUtil;
import kd.epm.eb.business.centralapproval.ShowInfoCreateUtil;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.business.utils.CodeRuleUtil;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropTypeEnum;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.RevokeReportBillTipEnum;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillConfig;
import kd.epm.eb.common.centralapproval.ApproveBillEntry;
import kd.epm.eb.common.centralapproval.ApprovePlan;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.centralapproval.CentralScheme;
import kd.epm.eb.common.centralapproval.CustomSelectGroup;
import kd.epm.eb.common.centralapproval.CustomSelectItem;
import kd.epm.eb.common.centralapproval.CustomSelectItemSetting;
import kd.epm.eb.common.centralapproval.RecordSearchEntry;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.permission.MemberPermHelper;

public class CentralAppBillService {
    private static final Log log = LogFactory.getLog(CentralAppBillService.class);

    public static CentralAppBillService getInstance() {
        return new CentralAppBillService();
    }

    public String centralAppBillCreateOrAdd(String billNo, String billType, Pair<Long, Pair<String, String>> reportPlan, Map<Long, Map<String, Set<Long>>> entities, Map<String, Long> pageDimInfos, Long centralOrg, Long reportEntity, Long modelId, Set<Long> tempIds) {
        List<ApproveBill> cenAppBillByRptOrColBill = this.getCenAppBillByRptOrColBill(billNo, billType);
        if (!cenAppBillByRptOrColBill.isEmpty()) {
            this.updateApproveBill(billNo, cenAppBillByRptOrColBill.get(0), entities, centralOrg);
        } else {
            if (billType.equals(ApplyBillType.APPLY.getNumber())) {
                billNo = null;
            }
            this.createNewApproveBill(billNo, entities, pageDimInfos, centralOrg, modelId, reportPlan, reportEntity, tempIds);
        }
        return null;
    }

    private void createNewApproveBill(String billNo, Map<Long, Map<String, Set<Long>>> entities, Map<String, Long> pageDimInfos, Long centralOrg, Long modelId, Pair<Long, Pair<String, String>> reportPlan, Long reportEntity, Set<Long> tempIds) {
        Long id = GlobalIdUtil.genGlobalLongId();
        String curBillNo = this.getBillNo((String)((Pair)reportPlan.p2).p1);
        String name = this.getBillName((String)((Pair)reportPlan.p2).p2, billNo);
        ApproveBill approveBill = new ApproveBill(id, name, curBillNo);
        Long usrId = this.getUserId();
        Date date = TimeServiceHelper.now();
        approveBill.setModel(modelId);
        Long adminOrg = this.getAdminOrgByReportOrg(reportEntity, modelId);
        approveBill.setBailadminorg(adminOrg);
        Set<Long> approvetyeps = this.getApproveTypsBytemplateIds(tempIds);
        approveBill.setApprovetypes(approvetyeps);
        approveBill.setMainbill(true);
        QFilter qFilter = new QFilter("billno", "=", (Object)curBillNo);
        qFilter.and("model", "=", (Object)modelId);
        if (NumberCheckUtils.checkNumberExist((String)"eb_centralappbill", (QFilter[])new QFilter[]{qFilter}, null)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u81ea\u52a8\u751f\u6210\u7684\u5ba1\u6279\u5355%1\uff0c\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"CentralAppBillService_21", (String)"epm-eb-business", (Object[])new Object[]{curBillNo}));
        }
        approveBill.setYear(pageDimInfos.get(SysDimensionEnum.Year.getNumber()));
        approveBill.setVersion(pageDimInfos.get(SysDimensionEnum.Version.getNumber()));
        approveBill.setDatatype(pageDimInfos.get(SysDimensionEnum.DataType.getNumber()));
        approveBill.setReportScheme((Long)reportPlan.p1);
        approveBill.setReportEntity(reportEntity);
        approveBill.setBillStatus(AppBillStatusEnum.STORAGE);
        approveBill.setCreator(usrId);
        approveBill.setCreateDate(date);
        approveBill.setModifier(usrId);
        approveBill.setModifyDate(date);
        ArrayList<ApproveBillEntry> entries = new ArrayList<ApproveBillEntry>(16);
        for (Map.Entry<Long, Map<String, Set<Long>>> info : entities.entrySet()) {
            Long template = info.getKey();
            Map<String, Set<Long>> value = info.getValue();
            if (value.size() == 0) {
                value.put("0", new HashSet(16));
            }
            for (Map.Entry<String, Set<Long>> entity : value.entrySet()) {
                String reportBill = entity.getKey();
                Set<Long> entityIds = entity.getValue();
                if (entityIds.size() == 0) {
                    entityIds.add(0L);
                }
                for (Long entityId : entityIds) {
                    ApproveBillEntry row = new ApproveBillEntry();
                    row.setReportBillNo(reportBill);
                    row.setSumBillNo(billNo);
                    row.setReportType("0");
                    row.setTemplate(template);
                    row.setEntity(entityId);
                    row.setCentralEntity(centralOrg);
                    row.setReporter(usrId);
                    row.setReportDate(date);
                    entries.add(row);
                }
            }
        }
        approveBill.setApproveBillEntries(entries);
        try (TXHandle tx = TX.required((String)"autoCreateApproveBill");){
            try {
                ApproveBillUtil.getInstance().save(Collections.singletonList(approveBill));
                log.info("CentralAppBillService.createNewApproveBill -----> " + approveBill.toString());
                this.submitApproveBill(id);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private Set<Long> getApproveTypsBytemplateIds(Set<Long> templateIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        QFilter filter = new QFilter("status", "=", (Object)"1");
        filter.and(new QFilter("entryentity.applytemplate", "in", templateIds));
        filter.and(new QFilter("entryentity.templatetype", "=", (Object)"1"));
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"eb_approvaltypeentity", (String)"id", (QFilter[])filter.toArray());
        if (datas != null && !datas.isEmpty()) {
            for (DynamicObject data : datas) {
                result.add(data.getLong("id"));
            }
        }
        return result;
    }

    private Long getAdminOrgByReportOrg(Long org, Long modelId) {
        String number = "";
        DynamicObject epmEntitymembertree = BusinessDataServiceHelper.loadSingleFromCache((Object)org, (String)"epm_entitymembertree");
        if (epmEntitymembertree != null) {
            number = epmEntitymembertree.getString("number");
            BailOrgRelation bailOrgRelation = BailOrgService.getInstance().getBailOrgRelation(modelId, number);
            if (bailOrgRelation != null) {
                return bailOrgRelation.getDefaultBailId();
            }
        }
        return 0L;
    }

    private void submitApproveBill(Long id) {
        OperateOption op = OperateOption.create();
        op.setVariableValue("currbizappid", "bgmd");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"eb_centralappbill", (Object[])new Object[]{id}, (OperateOption)op);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279\u5355\u5931\u8d25\u3002", (String)"CentralAppBillService_6", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        log.info("CentralAppBillService.submitApproveBill: successful");
    }

    private void submitApproveBill(DynamicObject[] datas) {
        OperateOption op = OperateOption.create();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"eb_centralappbill", (DynamicObject[])datas, (OperateOption)op);
        if (operationResult.isSuccess()) {
            log.info("CentralAppBillService.submitApproveBill: successful");
        } else {
            log.info("CentralAppBillService.submitApproveBill: error" + SerializationUtils.toJsonString((Object)operationResult.getAllErrorOrValidateInfo()));
        }
    }

    private void updateApproveBill(String billNo, ApproveBill approveBill, Map<Long, Map<String, Set<Long>>> entries, Long centralOrg) {
        Long usrId = this.getUserId();
        Date date = TimeServiceHelper.now();
        DynamicObject updata = BusinessDataServiceHelper.loadSingle((Object)approveBill.getId(), (String)"eb_centralappbill");
        DynamicObjectCollection entrys = updata.getDynamicObjectCollection("centralapprptentity");
        entrys.clear();
        updata.set("modifier", (Object)usrId);
        updata.set("modifydate", (Object)date);
        for (Map.Entry<Long, Map<String, Set<Long>>> info : entries.entrySet()) {
            Long template = info.getKey();
            Map<String, Set<Long>> value = info.getValue();
            if (value.size() == 0) {
                value.put("0", new HashSet(16));
            }
            for (Map.Entry<String, Set<Long>> entry : value.entrySet()) {
                String reportBill = entry.getKey();
                Set<Long> entitySet = entry.getValue();
                if (entitySet.size() == 0) {
                    entitySet.add(0L);
                }
                for (Long entityId : entitySet) {
                    DynamicObject row = entrys.addNew();
                    row.set("reportbillno", (Object)reportBill);
                    row.set("sumbillno", (Object)billNo);
                    row.set("reporttype", (Object)"0");
                    row.set("template", (Object)template);
                    row.set("entity", (Object)entityId);
                    row.set("centralentity", (Object)centralOrg);
                    row.set("reporter", (Object)usrId);
                    row.set("reportdate", (Object)date);
                }
            }
        }
        try (TXHandle tx = TX.required((String)"autoAddApproveBill");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updata});
                this.submitApproveBill(new DynamicObject[]{updata});
                log.info("CentralAppBillService.updateApproveBill -----> " + approveBill.toString());
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void addToApproveBill(String centralAppBillId, String billNo, Map<Long, Map<String, Set<Long>>> entries, Long centralOrg) {
        if (this.checkSame(centralAppBillId, entries).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u636e\u6269\u5145\u5931\u8d25\uff0c\u5ba1\u6279\u5355\u636e\u4e2d\u5df2\u5b58\u5728\u8be5\u7533\u62a5\u5355\u636e\u3002", (String)"CentralAppBillService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        Long usrId = this.getUserId();
        Date date = TimeServiceHelper.now();
        ApproveBillUtil instance = ApproveBillUtil.getInstance();
        ApproveBill approveBill = instance.getApproveBill(new QFilter("id", "=", (Object)IDUtils.toLong((Object)centralAppBillId)));
        approveBill.setModifier(usrId);
        approveBill.setModifyDate(date);
        List approveBillEntries = approveBill.getApproveBillEntries();
        int preSize = approveBillEntries.size();
        for (Map.Entry<Long, Map<String, Set<Long>>> info : entries.entrySet()) {
            Long template = info.getKey();
            Map<String, Set<Long>> value = info.getValue();
            if (value.size() == 0) {
                value.put("0", new HashSet(16));
            }
            for (Map.Entry<String, Set<Long>> entry : value.entrySet()) {
                String reportBill = entry.getKey();
                Set<Long> entitySet = entry.getValue();
                for (Long entityId : entitySet) {
                    ApproveBillEntry approveBillEntry = new ApproveBillEntry();
                    approveBillEntry.setReportBillNo(reportBill);
                    approveBillEntry.setSumBillNo(billNo);
                    approveBillEntry.setReportType("0");
                    approveBillEntry.setTemplate(template);
                    approveBillEntry.setEntity(entityId);
                    approveBillEntry.setCentralEntity(centralOrg);
                    approveBillEntry.setReporter(usrId);
                    approveBillEntry.setReportDate(date);
                    approveBillEntries.add(approveBillEntry);
                }
            }
        }
        approveBill.setApproveBillEntries(approveBillEntries);
        try (TXHandle tx = TX.required((String)"autoAddApproveBill");){
            try {
                if (approveBillEntries.size() != preSize) {
                    instance.save(Collections.singletonList(approveBill));
                } else if (!QueryServiceHelper.exists((String)"eb_centralappadjrecord", (QFilter[])new QFilter[]{new QFilter("approvebillno", "=", (Object)approveBill.getBillNo())})) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u6269\u5145\u7a7a\u7684\u5355\u636e\u3002", (String)"CentralAppBillService_17", (String)"epm-eb-business", (Object[])new Object[0]));
                }
                log.info("CentralAppBillService.addToApproveBill -----> " + approveBill.toString());
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private Boolean checkSame(String centralAppBillId, Map<Long, Map<String, Set<Long>>> map) {
        HashSet billNo = new HashSet(16);
        map.values().forEach(e -> billNo.addAll(e.keySet()));
        log.info("CentralAppBillService.checkSame -----> " + ((Object)billNo).toString());
        String sql = "select fseq, freportbillno from t_eb_centralappbillentry where fid = " + centralAppBillId;
        DataSet dataSet = DB.queryDataSet((String)"queryApproveBillInfo", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet == null || dataSet.isEmpty()) {
            return true;
        }
        Row row = null;
        while (dataSet.hasNext()) {
            row = dataSet.next();
            String reportBillNo = row.getString("freportbillno");
            if ("0".equals(reportBillNo) || !billNo.contains(reportBillNo)) continue;
            return true;
        }
        return false;
    }

    private String getBillName(String planName, String billNo) {
        String billName = ResManager.loadKDString((String)"\u7533\u62a5\u5ba1\u6279\u5355", (String)"CentralAppBillService_10", (String)"epm-eb-business", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)billNo)) {
            billName = ResManager.loadKDString((String)"\u6c47\u603b\u5ba1\u6279\u5355", (String)"CentralAppBillService_11", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        return planName + "-" + billName;
    }

    private String getBillNo(String planNumber) {
        return planNumber + "-" + CodeRuleUtil.getCodeRuleNumber("eb_centralappbill", BusinessDataServiceHelper.newDynamicObject((String)"eb_centralappbill"));
    }

    public Map<String, Map<String, Collection<Long>>> getPlanInfoByNum(List<ApprovePlan> plans) {
        HashMap<String, Map<String, Collection<Long>>> planInfos = new HashMap<String, Map<String, Collection<Long>>>(16);
        for (ApprovePlan plan : plans) {
            HashMap<String, Collection<Object>> planDetail = new HashMap<String, Collection<Object>>(16);
            planDetail.put("preTemplate", plan.getTemplates());
            planDetail.put("centralOrg", this.getAppOrgArea(plan));
            planInfos.put(plan.getNumber(), planDetail);
        }
        return planInfos;
    }

    public Map<String, Set<String>> getPlansInApproveBill(List<ApproveBill> centralAppBills) {
        HashMap<String, Set<String>> planInfo = new HashMap<String, Set<String>>(16);
        ArrayList<ApproveBill> removeBills = new ArrayList<ApproveBill>(16);
        if (centralAppBills == null || centralAppBills.size() == 0) {
            return planInfo;
        }
        for (ApproveBill entry : centralAppBills) {
            Set centralWaitPlan = entry.getCentralWaitPlan();
            if (centralWaitPlan.size() == 0) {
                removeBills.add(entry);
                continue;
            }
            planInfo.put(String.valueOf(entry.getId()), centralWaitPlan);
        }
        centralAppBills.removeAll(removeBills);
        return planInfo;
    }

    public List<ApproveBill> getAllApproveBills(Long modelId, Map<String, Long> pageDimInfos) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("billstatus", "=", (Object)AppBillStatusEnum.SUBMITTED.getNumber());
        qFilter.and("version.id", "=", (Object)pageDimInfos.get(SysDimensionEnum.Version.getNumber()));
        qFilter.and("datatype.id", "=", (Object)pageDimInfos.get(SysDimensionEnum.DataType.getNumber()));
        qFilter.and("year.id", "=", (Object)pageDimInfos.get(SysDimensionEnum.Year.getNumber()));
        return ApproveBillUtil.getInstance().getApproveBills(qFilter);
    }

    public CentralAppShowInfo getCenAppInfosByEntity2(DynamicObject billObj, Long entityId, List<Long> templates, Long modelId, Long bizModel, Boolean isApprovePassed, Set<Long> appBillIds, Long schemeId, boolean isNeedChain) {
        CentralAppShowInfo showInfo = new CentralAppShowInfo();
        String billNumber = billObj.getString("billno");
        HashSet<String> reportBills = new HashSet<String>(16);
        HashSet<Long> juniorEntity = new HashSet<Long>(16);
        Map<String, Set<String>> centralAppBills = this.getCentralAppBillInfoByEntity(entityId, templates, reportBills, juniorEntity, bizModel, modelId, isApprovePassed, appBillIds, schemeId);
        log.info("CollectBill.getBillNosFromApproveBill: " + centralAppBills.keySet().toString());
        CentralAppChain chain = null;
        chain = isNeedChain ? this.getCentralAppChainByBills(centralAppBills, modelId) : BgApplyBillUtils.getInstance().getChainFromCollectBill(billObj);
        showInfo.setEntitySet(juniorEntity);
        showInfo.setReportBillNos(reportBills);
        showInfo.setCentralAppChain(chain);
        Set<String> refedBillNums = StringUtils.isNotEmpty((String)billNumber) ? this.getRefedBillNums(billNumber, modelId) : new HashSet<String>(16);
        showInfo.setTemplates(new HashSet<Long>(templates));
        showInfo.setRefedBillNos(refedBillNums);
        return showInfo;
    }

    public CentralAppShowInfo getCenAppInfosByEntity(DynamicObject billObj, Long entityId, List<Long> templates, Long modelId, Long bizModel, Boolean isApprovePassed, Set<Long> appBillIds, Long schemeId, boolean isNeedChain) {
        CentralAppShowInfo showInfo = new CentralAppShowInfo();
        String billNumber = billObj.getString("billnumber");
        Date modifyDate = billObj.getDate("modifydate");
        HashSet<String> reportBills = new HashSet<String>(16);
        HashSet<Long> juniorEntity = new HashSet<Long>(16);
        Map<String, Set<String>> centralAppBills = this.getCentralAppBillInfoByEntity(entityId, templates, reportBills, juniorEntity, bizModel, modelId, isApprovePassed, appBillIds, schemeId, modifyDate);
        log.info("CollectBill.getBillNosFromApproveBill: " + centralAppBills.keySet().toString());
        CentralAppChain chain = null;
        chain = isNeedChain ? this.getCentralAppChainByBills(centralAppBills, modelId) : BgApplyBillUtils.getInstance().getChainFromCollectBill(billObj);
        showInfo.setEntitySet(juniorEntity);
        showInfo.setReportBillNos(reportBills);
        showInfo.setCentralAppChain(chain);
        Set<String> refedBillNums = StringUtils.isNotEmpty((String)billNumber) ? this.getRefedBillNums(billNumber, modelId) : new HashSet<String>(16);
        showInfo.setTemplates(new HashSet<Long>(templates));
        showInfo.setRefedBillNos(refedBillNums);
        return showInfo;
    }

    private Map<String, Set<String>> getCentralAppBillInfoByEntity(Long entityId, List<Long> templates, Set<String> reportBills, Set<Long> juniorEntity, Long bizModel, Long modelId, Boolean isApprovePassed, Set<Long> appBillIds, Long schemeId) {
        List<ApproveBill> billInfos;
        HashMap<String, Set<String>> centralAppBills = new HashMap<String, Set<String>>(16);
        if (juniorEntity != null) {
            juniorEntity.addAll(this.getEntities(entityId, bizModel, modelId, RangeEnum.ALL_DETAIL_INCLUDE.getIndex()));
        }
        if ((billInfos = this.getApproveBillsByChildEntity(entityId, templates, bizModel, modelId, isApprovePassed, appBillIds, schemeId)).size() == 0) {
            return centralAppBills;
        }
        for (ApproveBill billInfo : billInfos) {
            String appBillNo = billInfo.getBillNo();
            if (centralAppBills.containsKey(appBillNo)) continue;
            HashSet<String> sumBillNo = new HashSet<String>(16);
            List approveBillEntries = billInfo.getApproveBillEntries();
            if (approveBillEntries == null || approveBillEntries.size() == 0) continue;
            for (ApproveBillEntry cenAppReport : approveBillEntries) {
                String sumBill;
                String reportBillNo;
                if (reportBills != null && !"0".equals(reportBillNo = cenAppReport.getReportBillNo())) {
                    reportBills.add(reportBillNo);
                }
                if (StringUtils.isNotEmpty((String)(sumBill = cenAppReport.getSumBillNo()))) {
                    sumBillNo.add(sumBill);
                }
                centralAppBills.put(appBillNo, sumBillNo);
            }
        }
        return centralAppBills;
    }

    private Map<String, Set<String>> getCentralAppBillInfoByEntity(Long entityId, List<Long> templates, Set<String> reportBills, Set<Long> juniorEntity, Long bizModel, Long modelId, Boolean isApprovePassed, Set<Long> appBillIds, Long schemeId, Date modifyDate) {
        List<ApproveBill> billInfos;
        HashMap<String, Set<String>> centralAppBills = new HashMap<String, Set<String>>(16);
        if (juniorEntity != null) {
            juniorEntity.addAll(this.getEntities(entityId, bizModel, modelId, RangeEnum.ALL_DETAIL_INCLUDE.getIndex()));
        }
        if ((billInfos = this.getApproveBillsByChildEntity(entityId, templates, bizModel, modelId, isApprovePassed, appBillIds, schemeId)).size() == 0) {
            return centralAppBills;
        }
        for (ApproveBill billInfo : billInfos) {
            String appBillNo = billInfo.getBillNo();
            if (centralAppBills.containsKey(appBillNo)) continue;
            HashSet<String> sumBillNo = new HashSet<String>(16);
            List approveBillEntries = billInfo.getApproveBillEntries();
            if (approveBillEntries == null || approveBillEntries.size() == 0) continue;
            for (ApproveBillEntry cenAppReport : approveBillEntries) {
                String sumBill;
                if (reportBills != null) {
                    String reportBillNo = cenAppReport.getReportBillNo();
                    Date reportDate = cenAppReport.getReportDate();
                    int result = reportDate == null && modifyDate == null ? 0 : (reportDate == null ? 1 : (modifyDate == null ? -1 : reportDate.compareTo(modifyDate)));
                    if (!"0".equals(reportBillNo) && result < 0) {
                        reportBills.add(reportBillNo);
                    }
                }
                if (StringUtils.isNotEmpty((String)(sumBill = cenAppReport.getSumBillNo()))) {
                    sumBillNo.add(sumBill);
                }
                centralAppBills.put(appBillNo, sumBillNo);
            }
        }
        return centralAppBills;
    }

    private Set<String> getCentralAppBillsByChildEntity(Long entityId, Long bizModel, Long modelId, Long schemeId) {
        HashSet<String> reportBillNos = new HashSet<String>(16);
        Set<Long> noLeafEntities = this.getEntities(entityId, bizModel, modelId, RangeEnum.ALL_NOTDETAIL.getIndex());
        Set<Long> leafEntities = this.getEntities(entityId, bizModel, modelId, RangeEnum.ALL_DETAIL_INCLUDE.getIndex());
        noLeafEntities.add(entityId);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("billstatus", "=", (Object)"A");
        ArrayList<String> billTypes = new ArrayList<String>(16);
        billTypes.add(ApplyBillType.COLLECY.getNumber());
        billTypes.add(ApplyBillType.APPLY.getNumber());
        qFilter.and("billtype", "in", billTypes);
        if (schemeId != null && schemeId != 0L) {
            qFilter.and("applyscheme.id", "=", (Object)schemeId);
        }
        QFilter qFilter1 = new QFilter("collectorg", "in", noLeafEntities);
        QFilter qFilter2 = new QFilter("org", "in", leafEntities);
        qFilter2.and(new QFilter("collectorg", "=", (Object)0));
        Map reportBillMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (String)"billnumber,billstatus", (QFilter[])qFilter1.and(qFilter).toArray());
        Map reportBillMap2 = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (String)"billnumber,billstatus", (QFilter[])qFilter2.and(qFilter).toArray());
        log.info("reportBillNos.filterQFilter1: " + qFilter1.toString());
        log.info("reportBillNos.filterQFilter2: " + qFilter2.toString());
        Collection values = reportBillMap.values();
        Collection values1 = reportBillMap2.values();
        for (DynamicObject value : values) {
            reportBillNos.add(value.getString("billnumber"));
        }
        for (DynamicObject value : values1) {
            reportBillNos.add(value.getString("billnumber"));
        }
        log.info("reportBillNos: " + StringUtils.join(reportBillNos, (String)","));
        return reportBillNos;
    }

    private List<ApproveBill> getApproveBillsByChildEntity(Long entityId, List<Long> templates, Long bizModel, Long modelId, boolean isApprovePassed, Set<Long> appBillIds, Long schemeId) {
        ArrayList<ApproveBill> bills = new ArrayList<ApproveBill>(16);
        Set<Long> noLeafEntities = this.getEntities(entityId, bizModel, modelId, RangeEnum.ALL_NOTDETAIL.getIndex());
        Set<Long> leafEntities = this.getEntities(entityId, bizModel, modelId, RangeEnum.ALL_DETAIL_INCLUDE.getIndex());
        noLeafEntities.add(entityId);
        ApproveBillUtil instance = ApproveBillUtil.getInstance();
        QFilter qFilter = new QFilter("centralapprptentity.template", "in", templates);
        qFilter.and("model", "=", (Object)modelId);
        qFilter.and("billstatus", "!=", (Object)"F");
        if (isApprovePassed) {
            qFilter.and("billstatus", "=", (Object)"D");
        }
        if (appBillIds != null && appBillIds.size() > 0) {
            qFilter.and("id", "in", appBillIds);
        }
        if (schemeId != null && schemeId != 0L) {
            qFilter.and("reportscheme", "=", (Object)schemeId);
        }
        QFilter qFilter1 = new QFilter("centralapprptentity.centralentity", "in", noLeafEntities);
        QFilter qFilter2 = new QFilter("centralapprptentity.entity", "in", leafEntities);
        qFilter2.and(new QFilter("centralapprptentity.centralentity", "=", (Object)0));
        bills.addAll(instance.getApproveBills(qFilter1.and(qFilter)));
        log.info("CollectBill.filterQFilter1: " + qFilter1.toString());
        bills.addAll(instance.getApproveBills(qFilter2.and(qFilter)));
        log.info("CollectBill.filterQFilter2: " + qFilter2.toString());
        return bills;
    }

    public Set<Long> getEntities(Long entity, Long bizModel, Long model, int range) {
        HashSet<Long> entities = new HashSet<Long>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModel);
        String dimNumber = SysDimensionEnum.Entity.getNumber();
        Member member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), entity);
        if (member == null) {
            return entities;
        }
        ArrayList members = new ArrayList(16);
        if (bizModel != 0L) {
            Long viewId = BusinessModelServiceHelper.getInstance().getViewId(bizModel, dimNumber, model, true);
            if (viewId == null) {
                return entities;
            }
            members.addAll(modelCacheHelper.getMember(dimNumber, viewId, member.getNumber(), range));
        } else {
            members.addAll(modelCacheHelper.getMember(dimNumber, Long.valueOf(0L), member.getNumber(), range));
        }
        if (members.size() == 0) {
            return entities;
        }
        return members.stream().map(BaseCache::getId).collect(Collectors.toSet());
    }

    private CentralAppChain getCentralAppChainByBills(Map<String, Set<String>> centralAppBills, Long modelId) {
        CentralAppChain chain = new CentralAppChain();
        HashSet<String> elements = new HashSet<String>(16);
        HashSet<String> sumBills = new HashSet<String>(16);
        HashMap<String, Set<String>> elementRelation = new HashMap<String, Set<String>>(16);
        for (Map.Entry<String, Set<String>> centralAppBill : centralAppBills.entrySet()) {
            Set<String> sumBills_tmp = centralAppBill.getValue();
            elements.add(centralAppBill.getKey());
            if (sumBills_tmp == null || sumBills_tmp.size() == 0) continue;
            elementRelation.put(centralAppBill.getKey(), sumBills_tmp);
            sumBills.addAll(sumBills_tmp);
        }
        Map<String, CentralAppChain> sumBillChains = this.getCentralAppChainInSumBills(sumBills, modelId);
        if (sumBillChains != null && sumBillChains.size() != 0) {
            sumBillChains.forEach((key, value) -> {
                elementRelation.putAll(value.getElementRelation());
                elementRelation.put((String)key, value.getHeadElements());
            });
        }
        chain.setHeadElements(elements);
        chain.setElementRelation(elementRelation);
        return chain;
    }

    private Map<String, CentralAppChain> getCentralAppChainInSumBills(Set<String> sumBills, Long modelId) {
        HashMap<String, CentralAppChain> chains = new HashMap<String, CentralAppChain>(16);
        Map query = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (String)"billnumber, auditpath", (QFilter[])new QFilter[]{new QFilter("billnumber", "in", sumBills), new QFilter("model", "=", (Object)modelId)});
        if (query == null || query.size() == 0) {
            return null;
        }
        for (DynamicObject info : query.values()) {
            String auditPath = info.getString("auditpath");
            if (StringUtils.isEmpty((String)auditPath)) continue;
            CentralAppChain chain = (CentralAppChain)SerializationUtils.fromJsonString((String)auditPath, CentralAppChain.class);
            chains.put(info.getString("billnumber"), chain);
        }
        return chains;
    }

    public CentralAppChain getCentralAppChainByBills(Set<String> centralAppBills, Long modelId) {
        HashMap<String, Set<String>> billMap = new HashMap<String, Set<String>>(16);
        QFilter qFilter = new QFilter("billno", "in", centralAppBills);
        qFilter.and(new QFilter("model", "=", (Object)modelId));
        List<ApproveBill> approveBill = ApproveBillUtil.getInstance().getApproveBills(qFilter);
        if (approveBill == null || approveBill.size() == 0) {
            return null;
        }
        approveBill.forEach(e -> {
            String billNo = e.getBillNo();
            Set sumBills = billMap.computeIfAbsent(billNo, k -> new HashSet(16));
            e.getApproveBillEntries().forEach(h -> sumBills.add(h.getSumBillNo()));
        });
        return this.getCentralAppChainByBills(billMap, modelId);
    }

    public Set<String> getRefedBillNums(String billNumber, Long modelId) {
        HashSet<String> result = new HashSet<String>(16);
        QFilter qModel = new QFilter("model", "=", (Object)modelId);
        QFilter qBillType = new QFilter("billtype", "=", (Object)ApplyBillType.COLLECY.getNumber());
        Map collectBillObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (String)"id,billnumber,auditpath", (QFilter[])new QFilter[]{qModel, qBillType});
        if (collectBillObjs.isEmpty()) {
            return result;
        }
        result.add(billNumber);
        for (DynamicObject collectBill : collectBillObjs.values()) {
            String auditPath = collectBill.getString("auditpath");
            String billNum = collectBill.getString("billnumber");
            if (StringUtils.isEmpty((String)auditPath)) continue;
            CentralAppChain chain = (CentralAppChain)SerializationUtils.fromJsonString((String)auditPath, CentralAppChain.class);
            Set<String> pathBillNums = CentralAppBillService.getInstance().getCentralAppChainsBillSet(chain);
            if (!pathBillNums.contains(billNumber)) continue;
            result.add(billNum);
        }
        if (!result.isEmpty()) {
            HashSet<Long> mainBillIds = new HashSet<Long>(16);
            Map auditBillObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_centralappbill", (String)"id,billno,centralapprptentity.sumbillno,ismainbill", (QFilter[])new QFilter[]{qModel});
            block1: for (DynamicObject auditBill : auditBillObjs.values()) {
                DynamicObjectCollection refBillObjs = auditBill.getDynamicObjectCollection("centralapprptentity");
                for (DynamicObject refBill : refBillObjs) {
                    String billNum = refBill.getString("sumbillno");
                    if (!result.contains(billNum)) continue;
                    result.add(auditBill.getString("billno"));
                    if (!((Boolean)auditBill.get("ismainbill")).booleanValue()) continue block1;
                    mainBillIds.add(auditBill.getLong("id"));
                    continue block1;
                }
            }
            List<ApproveBill> subApproveBillList = ApproveBillUtil.getInstance().getApproveBills(new QFilter("parentid", "in", mainBillIds));
            subApproveBillList.forEach(subApproveBill -> {
                if (AppBillStatusEnum.AUDITED == subApproveBill.getBillStatus()) {
                    result.add(subApproveBill.getBillNo());
                }
            });
        }
        return result;
    }

    public CentralAppChain getCentralAppChainByBills(String bill, Long modelId) {
        Map<String, CentralAppChain> sumInfo = this.getCentralAppChainInSumBills(new HashSet<String>(Collections.singletonList(bill)), modelId);
        if (sumInfo != null && sumInfo.size() != 0) {
            return sumInfo.get(bill);
        }
        return this.getCentralAppChainByBills(new HashSet<String>(Collections.singleton(bill)), modelId);
    }

    public List<List<String>> getCentralAppChains(CentralAppChain chain) {
        ArrayList<List<String>> chains = new ArrayList<List<String>>(16);
        Set heads = chain.getHeadElements();
        Map relations = chain.getElementRelation();
        if (heads == null || heads.size() == 0) {
            return chains;
        }
        heads.forEach(e -> this.addChains((List<List<String>>)chains, relations, (String)e, (List<String>)new ArrayList<String>(16)));
        return chains;
    }

    public Set<String> getCentralAppChainsBillSet(CentralAppChain chain) {
        HashSet<String> result = new HashSet<String>(16);
        if (chain != null) {
            Set heads = chain.getHeadElements();
            Map relations = chain.getElementRelation();
            if (heads != null && heads.size() > 0) {
                result.addAll(heads);
                heads.forEach(e -> this.addChains((Set<String>)result, relations, (String)e));
            }
        }
        return result;
    }

    private void addChains(Set<String> chains, Map<String, Set<String>> relations, String element) {
        Set<String> nextElements = relations.get(element);
        if (nextElements != null && nextElements.size() > 0) {
            chains.addAll(nextElements);
            nextElements.forEach(e -> this.addChains(chains, relations, (String)e));
        }
    }

    private void addChains(List<List<String>> chains, Map<String, Set<String>> relations, String element, List<String> chainList) {
        ArrayList<String> currentChain = new ArrayList<String>(chainList);
        currentChain.add(element);
        Set<String> nextElements = relations.get(element);
        if (nextElements == null || nextElements.size() == 0) {
            chains.add(currentChain);
            return;
        }
        nextElements.forEach(e -> this.addChains(chains, relations, (String)e, (List<String>)currentChain));
    }

    public List<ApprovePlan> getPlanByCenApproveBill(ApproveBill centralBill, String planObj) {
        if (planObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8282\u70b9\u65b9\u6848\u7f16\u7801\u5931\u8d25\u3002", (String)"CentralAppBillService_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (centralBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba1\u6279\u5355\u636e\u5931\u8d25\u3002", (String)"CentralAppBillService_7", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        HashSet<Long> templates = new HashSet<Long>(16);
        HashSet<Long> entities = new HashSet<Long>(16);
        this.getFilterFieldInfo(centralBill, templates, entities);
        return this.getPlanByCenApproveBill(templates, entities, planObj, centralBill.getModel());
    }

    private void getFilterFieldInfo(ApproveBill centralBill, Set<Long> preTemplate, Set<Long> orgs) {
        List approveBillEntries = centralBill.getApproveBillEntries();
        if (approveBillEntries == null || approveBillEntries.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u636e\u5355\u636e\u4f53\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"CentralAppBillService_8", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        for (ApproveBillEntry approveBillEntry : approveBillEntries) {
            long org;
            long template = approveBillEntry.getTemplate();
            if (template != 0L) {
                preTemplate.add(template);
            }
            if ((org = approveBillEntry.getCentralEntity().longValue()) == 0L) {
                org = approveBillEntry.getEntity();
            }
            if (org == 0L) continue;
            orgs.add(org);
        }
    }

    public List<ApprovePlan> getPlanByCenApproveBill(Set<Long> templates, Set<Long> entities, String planObj, Long modelId) {
        HashSet<String> plans = new HashSet<String>(Arrays.asList(planObj.trim().split(",")));
        List<ApprovePlan> approvePlans = ApprovePlanUtil.getInstance().getApprovePlansByNumber(plans, modelId);
        return this.getPlanByCenApproveBill(templates, entities, approvePlans);
    }

    private List<ApprovePlan> getPlanByCenApproveBill(Set<Long> templates, Set<Long> entities, List<ApprovePlan> approvePlans) {
        ArrayList<ApprovePlan> retPlans = new ArrayList<ApprovePlan>(16);
        log.info("CentralAppBillService.getFilterPlan: " + templates.toString() + "; " + entities.toString() + "; " + approvePlans);
        for (ApprovePlan approvePlan : approvePlans) {
            List preTemplates = approvePlan.getTemplates();
            Set<Long> preEntities = this.getAppOrgArea(approvePlan);
            if (!templates.containsAll(preTemplates) || !entities.containsAll(preEntities)) continue;
            retPlans.add(approvePlan);
        }
        log.info("CentralAppBillService.getFilterPlan: " + ((Object)retPlans).toString());
        return retPlans;
    }

    public Set<Long> getAppOrgArea(ApprovePlan approvePlan) {
        HashSet<Long> entities = new HashSet<Long>(16);
        List centralPlans = approvePlan.getCentralPlans();
        List<CentralScheme> centralSchemes = ApprovePlanUtil.getInstance().getCentralSchemesById(centralPlans, false);
        centralSchemes.forEach(e -> entities.addAll(e.getEntities()));
        return entities;
    }

    public FormShowParameter getAdjustShowPage(String approveBill, Long centralEntity, Map<String, String> dims, Long template, AdjustShowTypeEnum displayType, ApplyBillType applyBillType, Long dataSetId, Long modelId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (this.isOldData(applyBillType)) {
            formShowParameter.setFormId("eb_oldapprecordlist");
        } else if (AdjustShowTypeEnum.Adjust == displayType) {
            formShowParameter.setFormId("eb_adjustrecordlist");
        } else {
            formShowParameter.setFormId("eb_centralapprecordlist");
        }
        RecordSearchEntry recordSearchEntry = new RecordSearchEntry();
        recordSearchEntry.setBillNo(approveBill);
        recordSearchEntry.setType(displayType);
        recordSearchEntry.setModel(modelId);
        recordSearchEntry.setDataSetId(dataSetId);
        recordSearchEntry.setApplyBillType(applyBillType);
        if (displayType == AdjustShowTypeEnum.Adjust) {
            if (this.isOldData(applyBillType)) {
                StyleCss css = new StyleCss();
                css.setHeight("530px");
                formShowParameter.getOpenStyle().setInlineStyleCss(css);
            }
            recordSearchEntry.setTemplate(template);
            recordSearchEntry.setEntity(centralEntity);
            recordSearchEntry.setRowDimMembers(dims);
        }
        this.settReportSchemeAssignInfo(approveBill, applyBillType.getNumber(), recordSearchEntry);
        String recordEntry = SerializationUtils.toJsonString((Object)recordSearchEntry);
        formShowParameter.setCustomParam("recordSearchEntry", (Object)recordEntry);
        return formShowParameter;
    }

    private void settReportSchemeAssignInfo(String billNumber, String billType, RecordSearchEntry recordSearchEntry) {
        SchemeAssignDimGroup assignDimGroup = ApplyBillPluginUitl.getReportSchemeAssignDimGroupByBill(billNumber, billType);
        recordSearchEntry.setReportSchemeId(assignDimGroup.getSchemeId());
        recordSearchEntry.setYearId(assignDimGroup.getYearId());
        recordSearchEntry.setVersionId(assignDimGroup.getVersionId());
        recordSearchEntry.setDataTypeId(assignDimGroup.getDataTypeId());
    }

    private boolean isOldData(ApplyBillType applyBillType) {
        return ApplyBillType.OLDAPPLYAUDIT == applyBillType || ApplyBillType.OLDCOLLECYAUDIT == applyBillType;
    }

    public void getApproveBillStatusShowPage(Long entityId, List<Long> templates, Long bizModel, Long modelId, FormShowParameter formShowParameter, Long schemeId) {
        HashSet<Long> pkIds = new HashSet<Long>(16);
        List<ApproveBill> approveBillByChildEntity = this.getApproveBillsByChildEntity(entityId, templates, bizModel, modelId, false, null, schemeId);
        if (approveBillByChildEntity.size() != 0) {
            for (ApproveBill approveBill : approveBillByChildEntity) {
                pkIds.add(approveBill.getId());
            }
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("eb_cenappbillshowlist");
        formShowParameter.setCustomParam("id", (Object)SerializationUtils.serializeToBase64(pkIds));
    }

    public void getApproveBillSelShowPage(Long entityId, List<Long> templates, Long bizModel, Long modelId, FormShowParameter formShowParameter, Long schemeId) {
        HashSet<Long> pkIds = new HashSet<Long>(16);
        List<ApproveBill> approveBillByChildEntity = this.getApproveBillsByChildEntity(entityId, templates, bizModel, modelId, false, null, schemeId);
        if (approveBillByChildEntity.size() != 0) {
            for (ApproveBill approveBill : approveBillByChildEntity) {
                pkIds.add(approveBill.getId());
            }
        }
        Set<String> centralAppBillsByChildEntity = this.getCentralAppBillsByChildEntity(entityId, bizModel, modelId, schemeId);
        formShowParameter.setCustomParam("org", (Object)entityId);
        formShowParameter.setCustomParam("model", (Object)modelId);
        formShowParameter.setCustomParam("bizModel", (Object)bizModel);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("eb_cenappbillsellist");
        formShowParameter.setCustomParam("id", (Object)SerializationUtils.serializeToBase64(pkIds));
        formShowParameter.setCustomParam("reportBillNos", (Object)SerializationUtils.serializeToBase64(centralAppBillsByChildEntity));
    }

    public String getRevokeCheckInfo(String billNo, String applyBillType) {
        List<ApproveBill> query = this.getCenAppBillByRptOrColBill(billNo, applyBillType);
        if (query == null || query.size() == 0) {
            return RevokeReportBillTipEnum.noApproveBill.getKey();
        }
        if (query.size() == 1) {
            ApproveBill bill = query.get(0);
            List approveBillEntries = bill.getApproveBillEntries();
            HashSet billNoSet = new HashSet(16);
            approveBillEntries.forEach(e -> {
                String billNo_tmp;
                String string = billNo_tmp = applyBillType.equals(ApplyBillType.APPLY.getNumber()) ? e.getReportBillNo() : e.getSumBillNo();
                if (!"0".equals(billNo_tmp)) {
                    billNoSet.add(billNo_tmp);
                }
            });
            if (billNoSet.size() != 1) {
                return RevokeReportBillTipEnum.multiCentralOrg.getKey();
            }
            String centralBillNo = bill.getBillNo();
            if (QueryServiceHelper.exists((String)"eb_centralapprecord", (QFilter[])new QFilter[]{new QFilter("approvebillno", "=", (Object)centralBillNo)})) {
                return RevokeReportBillTipEnum.inApprove.getKey();
            }
            return centralBillNo;
        }
        return RevokeReportBillTipEnum.multiApproveBill.getKey();
    }

    public String checkBeforeRevoke(Map<String, String> bills) {
        StringBuilder showConfirmMessage = new StringBuilder();
        if (bills == null || bills.size() == 0) {
            return showConfirmMessage.toString();
        }
        for (Map.Entry<String, String> bill : bills.entrySet()) {
            String type;
            String billNo = bill.getKey();
            String revokeCheckKey = this.getRevokeCheckInfo(billNo, type = bill.getValue());
            RevokeReportBillTipEnum enumByKey = RevokeReportBillTipEnum.getEnumByKey((String)revokeCheckKey);
            if (enumByKey != null) continue;
            ArrayList<String> billList = new ArrayList<String>(16);
            billList.add(revokeCheckKey);
            List<ApproveBill> query = this.getCenAppBillByRptOrColBill(billNo, type);
            ApproveBill approveBill = null;
            if (query.size() > 0 && (approveBill = query.get(0)).isMainbill() && approveBill.isHasSubitems()) {
                QFilter qFilter = new QFilter("parentid", "=", (Object)approveBill.getId());
                qFilter.and("billstatus", "!=", (Object)"F");
                List<ApproveBill> approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter);
                approveBills.forEach(e -> billList.add(e.getBillNo()));
            }
            for (String billNumber : billList) {
                if (!QueryServiceHelper.exists((String)"eb_centralappadjrecord", (QFilter[])new QFilter[]{new QFilter("approvebillno", "=", (Object)billNumber)})) continue;
                showConfirmMessage.append(ResManager.loadResFormat((String)"\u5355\u636e%1\u7684\u5ba1\u6279\u5355\u636e%2\u5b58\u5728\u5ba1\u6279\u8c03\u6574\u6570\u636e\uff0c", (String)"CentralAppBillService_19", (String)"epm-eb-business", (Object[])new Object[]{billNo, billNumber}));
            }
        }
        if (StringUtils.isNotEmpty((String)showConfirmMessage.toString())) {
            showConfirmMessage.append(ResManager.loadKDString((String)"\u662f\u5426\u64a4\u9500\uff1f", (String)"CentralAppBillService_20", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return showConfirmMessage.toString();
    }

    public Set<String> revokeReportBill(String billNo, String applyBillType) {
        HashSet<String> centeralBillnos = new HashSet<String>(16);
        List<ApproveBill> query = this.getCenAppBillByRptOrColBill(billNo, applyBillType);
        if (query != null && query.size() == 1) {
            ApproveBill mainbill = query.get(0);
            ArrayList<ApproveBill> allbills = new ArrayList<ApproveBill>(16);
            allbills.add(mainbill);
            QFilter filter = new QFilter("parentid", "=", (Object)mainbill.getId());
            filter.and(new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL.getNumber()));
            List<ApproveBill> subbills = ApproveBillUtil.getInstance().getApproveBills(filter);
            if (subbills != null && !subbills.isEmpty()) {
                allbills.addAll(subbills);
            }
            if (!allbills.isEmpty()) {
                try (TXHandle tx = TX.requiresNew((String)(this.getClass().getName() + ":revokeReportBill"));){
                    try {
                        for (ApproveBill bill : allbills) {
                            this.stopWorkFlowProcess(Collections.singletonList(String.valueOf(bill.getId())));
                        }
                    }
                    catch (Exception ex) {
                        tx.markRollback();
                        log.error((Throwable)ex);
                        throw new KDBizException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u505c\u6b62\u5931\u8d25\u3002", (String)"CentralAppBillService_22", (String)"epm-eb-business", (Object[])new Object[0]));
                    }
                }
                for (ApproveBill bill : allbills) {
                    String centralBillNo = bill.getBillNo();
                    centeralBillnos.add(centralBillNo);
                    CentralAppShowInfo showInfo = null;
                    if (!bill.isMainbill() && bill.getParentId() != 0L && bill.getParentId() != null) {
                        Long parentId = bill.getParentId();
                        Optional<ApproveBill> first = allbills.stream().filter(e -> e.getId().equals(parentId)).findFirst();
                        ApproveBill parentApproveBill = first.get();
                        showInfo = this.createShowInfo(parentApproveBill);
                    } else {
                        showInfo = this.createShowInfo(bill);
                    }
                    Set<String> refBillNumbs = RejectBillService.getInstance().getBhNumbersBySpNumber(bill.getBillNo());
                    SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(bill.getModel(), bill.getReportScheme(), bill.getYear(), bill.getVersion(), bill.getDatatype());
                    ApplyBillPluginUitl.rollbackBillData(bill.getBillNo(), schemeAssignDimGroup, refBillNumbs, bill.getModel(), applyBillType, showInfo);
                    this.deleteBillAndReferences(Collections.singleton(bill.getId()), Collections.singleton(centralBillNo), refBillNumbs, bill.getModel(), true);
                }
            }
        }
        return centeralBillnos;
    }

    public String getAuditBillType(List<ApproveBillEntry> approveBillEntries) {
        if (approveBillEntries == null || approveBillEntries.size() == 0) {
            return ApplyBillType.APPLYAUDIT.getNumber();
        }
        if (ApproveBillUtil.getInstance().isCollectAudit(approveBillEntries)) {
            return ApplyBillType.COLLECYAUDIT.getNumber();
        }
        return ApplyBillType.APPLYAUDIT.getNumber();
    }

    public CentralAppShowInfo createShowInfo(ApproveBill billObj) {
        return ShowInfoCreateUtil.getInstance().createShowInfo(billObj);
    }

    public void deleteBillAndReferences(Set<Long> centralBillIds, Set<String> centralBillNos, Set<String> refBillNums, Long model, boolean needDelBill) {
        BgApplyBillUtils instance = BgApplyBillUtils.getInstance();
        refBillNums.addAll(centralBillNos);
        instance.deleteDimQuote(centralBillIds);
        DeleteServiceHelper.delete((String)"eb_centralappadjrecord", (QFilter[])new QFilter[]{new QFilter("approvebillno", "in", refBillNums)});
        DeleteServiceHelper.delete((String)"eb_centralapprecord", (QFilter[])new QFilter[]{new QFilter("approvebillno", "in", refBillNums)});
        if (needDelBill) {
            DeleteServiceHelper.delete((String)"eb_centralappbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", centralBillNos)});
        }
    }

    public boolean isModelAdmin(Long modelId) {
        return MemberPermHelper.ifUserHasRootPermByModel(this.getUserId(), modelId);
    }

    public boolean isModelAdmin(Long modelId, Long usrId) {
        if (usrId == null || usrId == 0L) {
            return this.isModelAdmin(modelId);
        }
        return MemberPermHelper.ifUserHasRootPermByModel(usrId, modelId);
    }

    public Long getUserId() {
        return UserUtils.getUserId();
    }

    public List<String> getDealer(List<BizProcessStatus> bizProcessStatuses, String businessKey) {
        String[] nodes;
        ArrayList<String> dealerList = new ArrayList<String>(16);
        if (bizProcessStatuses == null || bizProcessStatuses.size() == 0) {
            return dealerList;
        }
        Set<String> nodeNames = this.getCurrentNodeNameOrId(dealerList, businessKey, null, true);
        for (String node : nodes = bizProcessStatuses.get(0).getCurrentNodeName().split(",")) {
            if (nodeNames.contains(node)) continue;
            dealerList.add(node);
        }
        return dealerList;
    }

    public Set<String> getCurrentNodeNameOrId(List<String> dealerList, String businessKey, String curNode, boolean isName) {
        HashSet<String> nodeInfo = new HashSet<String>(16);
        List<IApprovalRecordGroup> allApprovalRecord = WorkFlowUtil.getAllApprovalRecord(businessKey);
        for (IApprovalRecordGroup iApprovalRecordGroup : allApprovalRecord) {
            List children = iApprovalRecordGroup.getChildren();
            for (IApprovalRecordItem child : children) {
                String result = child.getResult();
                if (!ResManager.loadKDString((String)"\u5f85\u5ba1\u6838", (String)"CentralAppBillService_12", (String)"epm-eb-business", (Object[])new Object[0]).equals(result)) continue;
                String assignee = child.getAssignee();
                String activityInfo = null;
                if (isName) {
                    if (StringUtils.isNotEmpty((String)curNode) && !curNode.equals(this.filterNodeNumber(child.getActivityId()))) continue;
                    activityInfo = child.getActivityName();
                } else {
                    activityInfo = child.getActivityId();
                }
                if (dealerList != null) {
                    dealerList.add(activityInfo + "/" + assignee.trim().split("\\|")[0]);
                    nodeInfo.add(activityInfo);
                    continue;
                }
                if (!child.getUserStr().equals(String.valueOf(this.getUserId()))) continue;
                nodeInfo.add(activityInfo);
            }
        }
        return nodeInfo;
    }

    public List<Long> getBillDealerIds(List<BizProcessStatus> bizProcessStatuses, String businessKey) {
        ArrayList<Long> dealerList = new ArrayList<Long>(16);
        if (bizProcessStatuses == null || bizProcessStatuses.size() == 0) {
            return dealerList;
        }
        List<IApprovalRecordGroup> allApprovalRecord = WorkFlowUtil.getAllApprovalRecord(businessKey);
        for (IApprovalRecordGroup iApprovalRecordGroup : allApprovalRecord) {
            List children = iApprovalRecordGroup.getChildren();
            for (IApprovalRecordItem child : children) {
                String result = child.getResult();
                if (!ResManager.loadKDString((String)"\u5f85\u5ba1\u6838", (String)"CentralAppBillService_12", (String)"epm-eb-business", (Object[])new Object[0]).equals(result.trim())) continue;
                dealerList.add(child.getUserId());
            }
        }
        return dealerList;
    }

    private String filterNodeNumber(String activityName) {
        String nodeNumber = null;
        String[] split = activityName.split("_");
        if (split.length != 0) {
            nodeNumber = split[split.length - 1];
        }
        return nodeNumber;
    }

    public Map<String, Map<String, Object>> getCentralAppBillShowText(List<ApproveBill> approveBills) {
        HashMap<String, Map<String, Object>> retInfo = new HashMap<String, Map<String, Object>>(16);
        if (approveBills == null || approveBills.size() == 0) {
            return retInfo;
        }
        for (ApproveBill appBill : approveBills) {
            Long model = appBill.getModel();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
            Map dimViewMap = modelCacheHelper.getViewsByBusModel(appBill.getBizModelId());
            String id = String.valueOf(appBill.getId());
            Map entityMap = retInfo.computeIfAbsent(id, k -> new HashMap(16));
            entityMap.put("billno", appBill.getBillNo());
            entityMap.put("name", appBill.getName());
            entityMap.put("billstatus", appBill.getBillStatus());
            entityMap.put("modifydate", appBill.getModifyDate());
            List approveBillEntries = appBill.getApproveBillEntries();
            HashSet centralEntities = new HashSet(16);
            HashSet entities = new HashSet(16);
            HashSet sumBillNos = new HashSet(16);
            HashSet reportBillNos = new HashSet(16);
            approveBillEntries.forEach(e -> {
                this.setEntryEntityField((ApproveBillEntry)e, centralEntities, modelCacheHelper, true, dimViewMap);
                this.setEntryEntityField((ApproveBillEntry)e, entities, modelCacheHelper, false, dimViewMap);
                this.setBillNo((ApproveBillEntry)e, sumBillNos, true);
                this.setBillNo((ApproveBillEntry)e, reportBillNos, false);
            });
            entityMap.put("centralentity", centralEntities);
            entityMap.put("entity", entities);
            entityMap.put("sumbillno", sumBillNos);
            entityMap.put("reportbillno", reportBillNos);
        }
        return retInfo;
    }

    public void setBillNo(ApproveBillEntry entryEntity, Set<String> billNos, Boolean isSumBill) {
        String billNo;
        if (entryEntity == null) {
            return;
        }
        String string = billNo = isSumBill != false ? entryEntity.getSumBillNo() : entryEntity.getReportBillNo();
        if (StringUtils.isNotEmpty((String)billNo) && !"0".equals(billNo)) {
            billNos.add(billNo);
        }
    }

    public void setEntryEntityField(ApproveBillEntry entryEntity, Set<String> entities, IModelCacheHelper modelCacheHelper, Boolean isCentralEntity, Map<String, Long> dimViewMap) {
        if (entryEntity == null) {
            return;
        }
        Long entityId = isCentralEntity != false ? entryEntity.getCentralEntity() : entryEntity.getEntity();
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewMap.get(SysDimensionEnum.Entity.getNumber()), entityId);
        if (member != null) {
            entities.add(member.getName());
        }
    }

    public FormShowParameter createApproverPage(String billId) {
        TaskInfo taskInfo;
        Long userId;
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Long taskId = wfService.getTaskIdByBusinessKeyAndUserId(billId, userId = Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        if (taskId != null && taskId != 0L && (taskInfo = wfService.findTaskById(taskId)) != null) {
            FormShowParameter parameter = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("taskId", taskId);
            customParams.put("type", "toHandle");
            parameter.setCustomParams(customParams);
            parameter.setFormId(taskInfo.getProcessingPage());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            return parameter;
        }
        return null;
    }

    public void viewWorkFlow(String billNo, String billType, IFormView view) {
        if (StringUtils.isEmpty((String)billNo)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u5931\u8d25\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"CentralAppBillService_13", (String)"epm-eb-business", (Object[])new Object[0]));
            return;
        }
        List<ApproveBill> centralAppBill = this.getCenAppBillByRptOrColBill(billNo, billType);
        if (centralAppBill == null || centralAppBill.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe\u67e5\u770b\u5931\u8d25\u3002\u672a\u5339\u914d\u5230\u5ba1\u6279\u5355\u636e\u3002", (String)"CentralAppBillService_14", (String)"epm-eb-business", (Object[])new Object[0]));
            return;
        }
        if (centralAppBill.size() != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe\u67e5\u770b\u5931\u8d25\uff0c\u5339\u914d\u5230\u591a\u5f20\u5ba1\u6279\u5355\u636e\u3002", (String)"CentralAppBillService_15", (String)"epm-eb-business", (Object[])new Object[0]));
            return;
        }
        AbstractViewFlowchart chart = new AbstractViewFlowchart();
        String pkId = String.valueOf(centralAppBill.get(0).getId());
        if (StringUtils.isEmpty((String)pkId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba1\u6279\u5355\u636eid\u5931\u8d25\u3002", (String)"CentralAppBillService_16", (String)"epm-eb-business", (Object[])new Object[0]));
            return;
        }
        log.info("CentralAppBillService.viewWorkFlow ----> " + centralAppBill);
        chart.setBillId((Object)pkId);
        chart.showFlowchart(view);
    }

    private List<ApproveBill> getCenAppBillByRptOrColBill(String billNo, String billType) {
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL.getNumber());
        String billNoField = "sumbillno";
        if (billType.equals(ApplyBillType.APPLY.getNumber())) {
            billNoField = "reportbillno";
            qFilter.and(new QFilter("centralapprptentity.sumbillno", "=", (Object)""));
        }
        qFilter.and(new QFilter("centralapprptentity." + billNoField, "=", (Object)billNo));
        return ApproveBillUtil.getInstance().getApproveBills(qFilter);
    }

    public void stopWorkFlowProcess(List<String> businessKeys) {
        WorkFlowUtil.stopWorkFlowProcess(businessKeys);
    }

    public List<Object> getIdList(QFilter qFilter, String entityName, String orderBy) {
        ArrayList<Object> idList = new ArrayList<Object>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)orderBy);
        if (query != null && query.size() != 0) {
            query.forEach(e -> idList.add(e.get("id")));
        }
        return idList;
    }

    public Object getIdSingle(QFilter qFilter, String entityName) {
        Object pkId = null;
        DynamicObject query = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (query != null) {
            pkId = query.get("id");
        }
        return pkId;
    }

    public String checkHasSplitBill(String billNo, Long modelId) {
        CentralAppChain appChainByBills = CentralAppBillService.getInstance().getCentralAppChainByBills(billNo, modelId);
        Set<String> refedBillNums = CentralAppBillService.getInstance().getRefedBillNums(billNo, modelId);
        Set<String> centralAppChainsBillSet = this.getCentralAppChainsBillSet(appChainByBills);
        HashSet<String> allBillNums = new HashSet<String>(16);
        allBillNums.addAll(refedBillNums);
        allBillNums.addAll(centralAppChainsBillSet);
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", allBillNums)});
        Map<String, String> allBillIds = billObjs.stream().collect(Collectors.toMap(billObj -> billObj.getString("id"), billObj -> billObj.getString("billno")));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgdecompose", (String)"billnumber,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", allBillIds.keySet())});
        if (query.size() > 0) {
            String billId = ((DynamicObject)query.get(0)).getString("sourcebillid");
            return allBillIds.get(billId);
        }
        return null;
    }

    public boolean checkExist(String tableName, String propertyKey, Object value) {
        return QueryServiceHelper.exists((String)tableName, (QFilter[])new QFilter[]{new QFilter(propertyKey, "=", value)});
    }

    public Set<String> getAllApplyBillNumbers(Set<String> billNumbers) {
        HashSet<String> billNos = new HashSet<String>(16);
        if (billNumbers.size() != 0) {
            List<ApproveBill> approveBills = ApproveBillUtil.getInstance().getApproveBills(new QFilter("billno", "in", billNumbers));
            approveBills.forEach(e -> e.getApproveBillEntries().forEach(h -> billNos.add(h.getReportBillNo())));
        }
        return billNos;
    }

    public void dealRetEntity(Map<String, Object> retMap, Set<Long> schemeIds, Set<Long> templates, Long modelId) {
        if (retMap.size() == 0) {
            return;
        }
        HashSet<String> plans = new HashSet<String>(16);
        HashSet schemes = new HashSet(16);
        Object retValue = retMap.entrySet().iterator().next().getValue();
        if (retValue instanceof ArrayList) {
            ArrayList items = (ArrayList)retValue;
            items.forEach(e -> {
                String[] split = e.toString().split("_");
                if (split.length == 2) {
                    plans.add(split[0]);
                    schemes.add(split[1]);
                }
            });
        }
        ApprovePlanUtil instance = ApprovePlanUtil.getInstance();
        QFilter qFilter = new QFilter("number", "in", schemes);
        qFilter.and("model", "=", (Object)modelId);
        List<CentralScheme> centralSchemes = instance.getCentralSchemes(qFilter, false);
        centralSchemes.forEach(e -> schemeIds.add(e.getId()));
        List<ApprovePlan> approvePlans = instance.getApprovePlansByNumber(plans, modelId);
        approvePlans.forEach(e -> templates.addAll(e.getTemplates()));
    }

    public void filterGroupItems(CustomSelectGroup group, Set<String> approvePlans, Long modelId) {
        ApprovePlanUtil instance = ApprovePlanUtil.getInstance();
        List<ApprovePlan> plans = instance.getApprovePlansByNumber(approvePlans, modelId);
        Map<String, List> planSchemeMap = plans.stream().filter(ApprovePlan::isCenApprove).collect(Collectors.toMap(ApprovePlan::getNumber, ApprovePlan::getCentralPlans, (oldVal, newVal) -> newVal));
        ArrayList<Long> schemeIds = new ArrayList<Long>(16);
        planSchemeMap.values().forEach(schemeIds::addAll);
        List<CentralScheme> schemes = instance.getCentralSchemesById(schemeIds, false);
        Long userId = this.getUserId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<CustomSelectItem> items = new ArrayList<CustomSelectItem>(16);
        block0: for (CentralScheme scheme : schemes) {
            Set approvers = scheme.getApprovers();
            if (!approvers.contains(userId)) continue;
            Long orgViewId = modelCacheHelper.getViewByBusModelAndDimNumber(scheme.getBizRangeId(), SysDimensionEnum.Entity.getNumber());
            for (Map.Entry<String, List> entry : planSchemeMap.entrySet()) {
                if (!entry.getValue().contains(scheme.getId())) continue;
                String key = entry.getKey() + "_" + scheme.getNumber();
                Long centralEntity = scheme.getCentralEntity();
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, centralEntity);
                if (member == null) continue;
                String name = member.getName();
                CustomSelectItem item = new CustomSelectItem(key, name);
                items.add(item);
                continue block0;
            }
        }
        group.setKey("selectentity");
        group.setSetting(new CustomSelectItemSetting());
        group.setCustomSelectItems(items);
    }

    public List<String> getConfigCols(Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>> colTypes, ColCfgPropEnum type) {
        ArrayList<ColCfgPropEnum> types = new ArrayList<ColCfgPropEnum>(16);
        types.add(type);
        return this.getConfigCols(colTypes, types);
    }

    public List<String> getConfigCols(Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>> colTypes, List<ColCfgPropEnum> types) {
        ArrayList<String> configCols = new ArrayList<String>(16);
        if (colTypes == null || colTypes.size() == 0) {
            return configCols;
        }
        Map<String, ColCfgPropEnum> colEditTypes = colTypes.get(ColCfgPropTypeEnum.EDIT_TYPE);
        if (colEditTypes == null || colEditTypes.size() == 0) {
            return configCols;
        }
        configCols.addAll(colEditTypes.entrySet().stream().filter(e -> this.isTypeContain(types, (ColCfgPropEnum)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()));
        return configCols;
    }

    private boolean isTypeContain(List<ColCfgPropEnum> types, ColCfgPropEnum type) {
        boolean isContain = false;
        for (ColCfgPropEnum colCfgPropType : types) {
            if (colCfgPropType != type) continue;
            isContain = true;
            break;
        }
        return isContain;
    }

    public void showOperationResult(String operateName, Map<String, Set<String>> successInfos, Map<String, String> errInfos, IFormView view, String pluginName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_operationresult");
        showParameter.setCloseCallBack(new CloseCallBack(pluginName, "OperationResult"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int successSize = successInfos.values().stream().mapToInt(Set::size).sum();
        int errSize = errInfos.size();
        String title = ResManager.loadResFormat((String)"\u5171%1\u6761\u8bb0\u5f55\uff0c%2\u6210\u529f%3\u6761\uff0c\u5931\u8d25%4\u6761\u3002", (String)"ApproveBillListNew_25", (String)"epm-eb-formplugin", (Object[])new Object[]{successSize + errSize, operateName, successSize, errSize});
        showParameter.setCustomParam("title", (Object)title);
        StringBuilder message = new StringBuilder();
        if (successInfos.size() != 0) {
            message.append(ResManager.loadKDString((String)"\u6210\u529f\u4fe1\u606f:", (String)"ApproveBillListNew_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            message.append("\n");
            successInfos.forEach((key, value) -> message.append((String)key).append(":").append(String.join((CharSequence)"\u3001", value)).append("\n"));
        }
        if (errInfos.size() != 0) {
            message.append(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f:", (String)"ApproveBillListNew_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            message.append("\n");
            errInfos.forEach((key, value) -> message.append((String)key).append(":").append((String)value).append("\n"));
        }
        showParameter.setCustomParam("errorMsg", (Object)message.toString());
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        view.showForm(showParameter);
    }

    public void splitBillHandle(ApproveBill approveBill, Set<Long> centralSchemaIds, String auditNode) {
        try (TXHandle tx = TX.required((String)"autoCreateSubApproveBill");){
            try {
                this.splitBill(approveBill, centralSchemaIds, auditNode);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void splitBill(ApproveBill approveBill, Set<Long> centralSchemaIds, String auditNode) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)approveBill.getModel());
        Set<Long> tempIds = BgApplyBillUtils.getInstance().getTemplateByOrg(approveBill.getReportEntity(), approveBill.getReportScheme(), approveBill.getModel());
        String mainBillNo = approveBill.getBillNo();
        Long modelId = approveBill.getModel();
        Map templateDataMap = BusinessDataServiceHelper.loadFromCache((Object[])tempIds.toArray(), (String)"eb_applytemplate");
        ArrayList templateDatas = new ArrayList(templateDataMap.values());
        if (templateDatas.isEmpty()) {
            log.error(this.getClass().getName() + "splitBill==>" + mainBillNo + "\u6a21\u677f\u4e3a\u7a7a");
            return;
        }
        ArrayList<ApproveBillConfig> allcfgs = new ArrayList<ApproveBillConfig>(16);
        Set approvetypes = approveBill.getApprovetypes();
        Map approveTypes = BusinessDataServiceHelper.loadFromCache((Object[])approvetypes.toArray(), (String)"eb_approvaltypeentity");
        if (approveTypes == null || approveTypes.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6ca1\u6709\u627e\u5230\u5ba1\u6279\u7c7b\u578b\u3002", (String)"CentralAppBillService_24", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> approveTypeDatas = new ArrayList<DynamicObject>(approveTypes.values());
        Map<Long, Set<Long>> approveIdMapcentralSchemaIds = this.getCentralSchemaIds(approveTypeDatas, approveBill.getReportEntity(), modelCacheHelper);
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        for (Set<Long> value : approveIdMapcentralSchemaIds.values()) {
            schemeIds.addAll(value);
        }
        log.info(this.getClass().getName() + "splitBill==>\u6240\u6709\u5ba1\u6279\u7c7b\u578b\u5bf9\u5e94\u7684\u65b9\u6848id\uff1a" + ((Object)schemeIds).toString());
        if (centralSchemaIds != null && !centralSchemaIds.isEmpty()) {
            schemeIds.retainAll(centralSchemaIds);
            log.info(this.getClass().getName() + "splitBill==>\u4ea4\u96c6\u7684\u65b9\u6848id\uff1a" + ((Object)schemeIds).toString());
        }
        QFilter qFilter = new QFilter("scheme", "in", schemeIds);
        qFilter.and("status", "=", (Object)"1");
        DynamicObjectCollection allrelations = QueryServiceHelper.query((String)"eb_centralrelation", (String)"scheme,entity,meminfojson,enabledate,disabledate,entryseq", (QFilter[])qFilter.toArray(), (String)"scheme,entryseq");
        HashMap<Long, String> templateMapTableName = new HashMap<Long, String>(16);
        Map<Long, Map<String, String>> temlateDimonColumn = this.getTemlateDimonColumn(tempIds, templateMapTableName);
        for (Long tempId : tempIds) {
            ApproveBillConfig config = new ApproveBillConfig();
            config.setTemplateId(tempId);
            Optional<DynamicObject> findTemplate = templateDatas.stream().filter(s -> s.getLong("id") == tempId.longValue()).findFirst();
            if (findTemplate.isPresent()) {
                config.setTemplateNumber(findTemplate.get().getString("number"));
            }
            DynamicObject currentApproveType = null;
            block2: for (DynamicObject approveTypeData : approveTypeDatas) {
                DynamicObjectCollection entrys = approveTypeData.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    Long applytemplate = entry.getLong("applytemplate.id");
                    if (!applytemplate.equals(tempId)) continue;
                    currentApproveType = approveTypeData;
                    continue block2;
                }
            }
            if (currentApproveType != null) {
                DynamicObject data = currentApproveType;
                Set<Long> curentSchemaIds = approveIdMapcentralSchemaIds.get(data.getLong("id"));
                if (curentSchemaIds == null) {
                    curentSchemaIds = new HashSet<Long>(16);
                }
                Set<Long> finalCurentSchemaIds = curentSchemaIds;
                List<DynamicObject> currentRelations = allrelations.stream().filter(s -> finalCurentSchemaIds.contains(s.getLong("scheme"))).collect(Collectors.toList());
                config.setCentralSchemaIds(finalCurentSchemaIds);
                config.setApproveType(Long.valueOf(data.getLong("id")));
                config.setApproveTypeNumber(data.getString("number"));
                boolean centralsplit = data.getBoolean("centralsplit");
                config.setSplitCentral(centralsplit);
                if (centralsplit) {
                    Map<String, String> dimonKeyMap = temlateDimonColumn.get(tempId);
                    String tableName = (String)templateMapTableName.get(tempId);
                    List<ApproveBillConfig> appBillConfigs = this.getAppBillConfigs(approveBill, config, tempId, currentRelations, dimonKeyMap, tableName, modelCacheHelper);
                    allcfgs.addAll(appBillConfigs);
                    continue;
                }
                log.info(this.getClass().getName() + "splitBill==>" + mainBillNo + "\u6a21\u677f:" + tempId + "\u5ba1\u6279\u7c7b\u578b\uff1a" + data.getString("number") + "\u6ca1\u6709\u62c6\u5206\u5f52\u53e3");
                continue;
            }
            log.info(this.getClass().getName() + "splitBill==>" + mainBillNo + "\u6a21\u677f" + tempId + "\u6ca1\u6709\u627e\u5230\u5ba1\u6279\u7c7b\u578b");
        }
        Long creatorId = approveBill.getCreator();
        Date date = TimeServiceHelper.now();
        ArrayList<DynamicObject> fcancledatas = new ArrayList<DynamicObject>(16);
        if (!allcfgs.isEmpty()) {
            approveBill.setApproveconfig(allcfgs);
            QFilter filter = new QFilter("parentid", "=", (Object)approveBill.getId());
            filter.and(new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL.getNumber()));
            DynamicObject[] allupdates = BusinessDataServiceHelper.load((String)"eb_centralappbill", (String)"billno,approveconfig_tag,billstatus,creater,createdate,modifier,modifydate,centralorg,splitnode", (QFilter[])filter.toArray());
            DynamicObject[] updates = Arrays.stream(allupdates).filter(s -> s.getString("splitnode").equals(auditNode)).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            List<ApproveBillConfig> findsplitcfgs = allcfgs.stream().filter(s -> s.getCentralOrg() != null && s.getCentralOrg() != 0L && !s.getMatchMemberIds().isEmpty()).collect(Collectors.toList());
            if (findsplitcfgs != null && !findsplitcfgs.isEmpty()) {
                if (updates.length > 0) {
                    List<Long> currentcentralorgs = findsplitcfgs.stream().map(s -> s.getCentralOrg()).collect(Collectors.toList());
                    List centralorgs = Arrays.stream(updates).map(s -> s.getLong("centralorg.id")).collect(Collectors.toList());
                    this.updateSubbill(findsplitcfgs, updates, currentcentralorgs, fcancledatas, creatorId);
                    List<ApproveBillConfig> adds = findsplitcfgs.stream().filter(s -> !centralorgs.contains(s.getCentralOrg())).collect(Collectors.toList());
                    if (adds != null && !adds.isEmpty()) {
                        List<String> billnos = Arrays.stream(allupdates).map(s -> s.getString("billno")).collect(Collectors.toList());
                        int j = this.getMaxIndex(billnos);
                        this.createSubApproveBill(approveBill, adds, j, auditNode);
                    }
                } else {
                    List<String> billnos = Arrays.stream(allupdates).map(s -> s.getString("billno")).collect(Collectors.toList());
                    int j = this.getMaxIndex(billnos);
                    this.createSubApproveBill(approveBill, findsplitcfgs, j, auditNode);
                }
            } else {
                if (updates.length > 0) {
                    for (DynamicObject update : updates) {
                        update.set("billstatus", (Object)"F");
                        update.set("modifier", (Object)creatorId);
                        update.set("modifydate", (Object)date);
                        fcancledatas.add(update);
                    }
                    SaveServiceHelper.save((DynamicObject[])updates);
                }
                approveBill.setHasSubitems(false);
                approveBill.setParentId(Long.valueOf(0L));
                ApproveBillUtil.getInstance().save(Collections.singletonList(approveBill));
                log.info(this.getClass().getName() + "splitBill==>" + mainBillNo + "\u6240\u6709\u914d\u7f6e\u9879\uff1a" + ((Object)allcfgs).toString() + " \u6ca1\u6709\u7b26\u5408\u62c6\u5206\u7684\u914d\u7f6e\u3002");
            }
        } else {
            approveBill.setHasSubitems(false);
            approveBill.setParentId(Long.valueOf(0L));
            ApproveBillUtil.getInstance().save(Collections.singletonList(approveBill));
            log.info(this.getClass().getName() + "splitBill==>" + mainBillNo + "\u6240\u6709\u7684\u5ba1\u6279\u7c7b\u578b\u90fd\u6ca1\u6709\u6253\u5f00\u62c6\u5206\u5f52\u53e3\u6807\u8bc6");
        }
        if (!fcancledatas.isEmpty()) {
            HashSet<Long> pkids = new HashSet<Long>(16);
            HashSet<String> billnos = new HashSet<String>(16);
            for (DynamicObject fcancledata : fcancledatas) {
                pkids.add(fcancledata.getLong("id"));
                billnos.add(fcancledata.getString("billno"));
            }
            this.cancleSubBills(pkids, billnos, modelId);
        }
        log.info(this.getClass().getName() + "splitBill==>finished, mainBillNo={}", (Object)mainBillNo);
    }

    private int getMaxIndex(List<String> billnos) {
        int j = 0;
        for (String billno : billnos) {
            String[] arrs = billno.split("-");
            String lastNum = arrs[arrs.length - 1];
            int i = Integer.parseInt(lastNum);
            if (i <= j) continue;
            j = i;
        }
        return ++j;
    }

    private void updateSubbill(List<ApproveBillConfig> findsplitcfgs, DynamicObject[] oldSubBill, List<Long> currentcentralorgs, List<DynamicObject> fcancledatas, Long creator) {
        Date date = TimeServiceHelper.now();
        ArrayList<DynamicObject> udatas = new ArrayList<DynamicObject>(16);
        for (DynamicObject update : oldSubBill) {
            Long corg = update.getLong("centralorg.id");
            if (currentcentralorgs.contains(corg)) {
                List finds = findsplitcfgs.stream().filter(s -> s.getCentralOrg().equals(corg)).collect(Collectors.toList());
                if (finds != null && !finds.isEmpty()) {
                    update.set("approveconfig_tag", (Object)SerializationUtils.toJsonString(finds));
                    update.set("billstatus", (Object)AppBillStatusEnum.STORAGE.getNumber());
                    udatas.add(update);
                }
            } else {
                fcancledatas.add(update);
                update.set("billstatus", (Object)AppBillStatusEnum.CANCEL.getNumber());
            }
            update.set("modifier", (Object)creator);
            update.set("modifydate", (Object)date);
        }
        SaveServiceHelper.save((DynamicObject[])oldSubBill);
        if (!udatas.isEmpty()) {
            for (DynamicObject udata : udatas) {
                this.submitApproveBill(new DynamicObject[]{udata});
            }
        }
    }

    private void cancleSubBills(Set<Long> pkIds, Set<String> billNos, Long modelId) {
        this.stopWorkFlowProcess(pkIds.stream().map(s -> s.toString()).collect(Collectors.toList()));
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("billno", "in", billNos));
        List<ApproveBill> approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter);
        Map<String, ApproveBill> approveBillMap = approveBills.stream().collect(Collectors.toMap(ApproveBill::getBillNo, e -> e));
        for (String billNum : billNos) {
            ApproveBill approveBill = approveBillMap.get(billNum);
            CentralAppShowInfo showInfo = this.createShowInfo(approveBill);
            Set<String> refBillNumbs = RejectBillService.getInstance().getBhNumbersBySpNumber(billNum);
            String billType = this.getAuditBillType(approveBill.getApproveBillEntries());
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(modelId, approveBill.getReportScheme(), approveBill.getYear(), approveBill.getVersion(), approveBill.getDatatype());
            ApplyBillPluginUitl.rollbackBillData(billNum, schemeAssignDimGroup, refBillNumbs, modelId, billType, showInfo);
        }
        Map<String, Set<String>> refBillNumMap = RejectBillService.getInstance().getBhNumbersBySpNumbers(billNos);
        HashSet<String> refBillNums = new HashSet<String>(16);
        refBillNumMap.values().forEach(refBillNums::addAll);
        this.deleteBillAndReferences(pkIds, billNos, refBillNums, modelId, false);
        RejectBillService.getInstance().deleteRejectDataBySpNumbers(billNos, modelId);
        ApplyBillAttachmentHelper.removeApproveBillAttachments(billNos, modelId);
    }

    public Map<Long, Map<String, String>> getTemlateDimonColumn(Set<Long> templateIds, Map<Long, String> temlateMapTableName) {
        HashMap<Long, Map<String, String>> templateIdMapdimkeys = new HashMap<Long, Map<String, String>>(16);
        Map temlateDatas = BusinessDataServiceHelper.loadFromCache((Object[])templateIds.toArray(), (String)"eb_applytemplate");
        for (DynamicObject templateObj : temlateDatas.values()) {
            ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate(templateObj);
            temlateMapTableName.put(templateObj.getLong("id"), (String)columnList.getEntityinfomap().get("mainentryentity"));
            List main_collect = columnList.getColumns().stream().filter(ee -> ee.getCategory().equals("h") && (ee.getType() == ColumnEnum.Dimension || ee.getType() == ColumnEnum.RowDimension)).collect(Collectors.toList());
            HashMap<String, String> dimkeyMapfieldKey = new HashMap<String, String>(16);
            for (BaseColumn baseColumn : main_collect) {
                String dimNumber;
                DimensionColumn ncolumn;
                if (baseColumn instanceof DimensionColumn) {
                    ncolumn = (DimensionColumn)baseColumn;
                    dimNumber = ncolumn.getDimNumber();
                    dimkeyMapfieldKey.put(dimNumber, ncolumn.getKey());
                    continue;
                }
                if (!(baseColumn instanceof RowDimensionColumn)) continue;
                ncolumn = (RowDimensionColumn)baseColumn;
                dimNumber = ncolumn.getDimNumber();
                dimkeyMapfieldKey.put(dimNumber, ncolumn.getKey());
            }
            templateIdMapdimkeys.put(templateObj.getLong("id"), dimkeyMapfieldKey);
        }
        return templateIdMapdimkeys;
    }

    private List<ApproveBillConfig> getAppBillConfigs(ApproveBill mainBill, ApproveBillConfig config, Long tempId, List<DynamicObject> currentRelations, Map<String, String> dimkeyMapfieldKey, String tableName, IModelCacheHelper modelCacheHelper) {
        ArrayList<ApproveBillConfig> approveBillConfigs = new ArrayList<ApproveBillConfig>(16);
        DynamicObject templateData = BusinessDataServiceHelper.loadSingleFromCache((Object)tempId, (String)"eb_applytemplate");
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate(templateData);
        List<BaseColumn> main_collect = columnList.getColumns().stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
        List<String> dimKeyList = ApplyTemplateUtils.getDimKeyList(main_collect);
        Map<String, Integer> columnIndexMap = ApplyTemplateUtils.getColumnIndexMap(main_collect);
        if (!currentRelations.isEmpty()) {
            HashSet<String> centralDims = new HashSet<String>(16);
            Map<Long, List<Map<String, Set<Long>>>> centralRelations = this.getCentralRelations(currentRelations, modelCacheHelper, centralDims);
            if (centralRelations != null && !centralRelations.isEmpty()) {
                List<Object[]> rows = this.queryDataFromDb(mainBill, tempId, "", tableName, columnList);
                for (Map.Entry<Long, List<Map<String, Set<Long>>>> entry : centralRelations.entrySet()) {
                    Map dimvalue;
                    boolean bl;
                    Object dimnumber2;
                    Long centralOrgId = entry.getKey();
                    List<Map<String, Set<Long>>> dimvalues = entry.getValue();
                    if (dimvalues.isEmpty()) continue;
                    boolean isContainRowDim = false;
                    for (String string : centralDims) {
                        if (!dimkeyMapfieldKey.containsKey(string)) continue;
                        isContainRowDim = true;
                        break;
                    }
                    if (!isContainRowDim) {
                        ApproveBillConfig config1 = new ApproveBillConfig();
                        config1.setTemplateId(config.getTemplateId());
                        config1.setTemplateNumber(config.getTemplateNumber());
                        config1.setApproveTypeNumber(config.getApproveTypeNumber());
                        config1.setApproveType(config.getApproveType());
                        config1.setCentralOrg(centralOrgId);
                        config1.setCentralSchemaIds(config.getCentralSchemaIds());
                        config1.setMatchMemberIds(dimvalues);
                        approveBillConfigs.add(config1);
                        continue;
                    }
                    HashMap<String, Integer> dimNumberMapIndex = new HashMap<String, Integer>(16);
                    for (Object dimnumber2 : centralDims) {
                        String fieldKey = dimkeyMapfieldKey.get(dimnumber2);
                        if (fieldKey == null) continue;
                        Integer index = columnIndexMap.get(fieldKey);
                        dimNumberMapIndex.put((String)dimnumber2, index);
                    }
                    boolean bl2 = false;
                    dimnumber2 = dimvalues.iterator();
                    while (dimnumber2.hasNext() && !(bl = this.filterRows(rows, dimvalue = (Map)dimnumber2.next(), dimNumberMapIndex))) {
                    }
                    if (!bl) continue;
                    ApproveBillConfig config1 = new ApproveBillConfig();
                    config1.setTemplateId(config.getTemplateId());
                    config1.setTemplateNumber(config.getTemplateNumber());
                    config1.setApproveTypeNumber(config.getApproveTypeNumber());
                    config1.setApproveType(config.getApproveType());
                    config1.setCentralOrg(centralOrgId);
                    config1.setCentralSchemaIds(config.getCentralSchemaIds());
                    config1.setMatchMemberIds(dimvalues);
                    approveBillConfigs.add(config1);
                }
            } else {
                approveBillConfigs.add(config);
            }
        } else {
            approveBillConfigs.add(config);
        }
        return approveBillConfigs;
    }

    public boolean filterRows(List<Object[]> rows, Map<String, Set<Long>> filter, Map<String, Integer> indexMap) {
        for (Object[] row : rows) {
            ArrayList<Boolean> isContain = new ArrayList<Boolean>(16);
            for (Map.Entry<String, Integer> stringIntegerEntry : indexMap.entrySet()) {
                String dimNumber = stringIntegerEntry.getKey();
                Integer colindex = stringIntegerEntry.getValue();
                Set<Long> memberIds = filter.get(dimNumber);
                if (memberIds == null || memberIds.isEmpty()) {
                    isContain.add(true);
                    continue;
                }
                Object o = row[colindex];
                isContain.add(memberIds.contains(o));
            }
            if (!isContain.stream().allMatch(x -> x)) continue;
            return true;
        }
        return false;
    }

    public List<Object[]> queryDataFromDb(ApproveBill approveBill, Long templateId, String wheresql, String tableName, ColumnList columnList) {
        CentralAppShowInfo showInfo = new CentralAppShowInfo();
        HashSet<String> reportBillNos = new HashSet<String>(16);
        LinkedHashSet<Long> templateIds = new LinkedHashSet<Long>(16);
        templateIds.add(templateId);
        HashSet<Long> orgSet = new HashSet<Long>(16);
        AppBillDataFilterService.getInstance().getEntryInfos(approveBill.getApproveBillEntries(), reportBillNos, templateIds, orgSet, approveBill.getModel());
        reportBillNos.remove("0");
        showInfo.setReportBillNos(reportBillNos);
        showInfo.setTemplates(templateIds);
        showInfo.setEntitySet(orgSet);
        ShowInfoCreateUtil.getInstance().initShowInfoBaseData(showInfo, approveBill);
        Collection columns = columnList.getColumns();
        List<BaseColumn> main_collect = columns.stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
        List<String> dimKeyList = ApplyTemplateUtils.getDimKeyList(main_collect);
        String orgOrAccountColumnKey = ApplyTemplateUtils.getOrgOrAccountColumnKey(main_collect, dimKeyList, false);
        if (!orgSet.isEmpty() && StringUtils.isNotEmpty((String)orgOrAccountColumnKey)) {
            List orgids = orgSet.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((String)wheresql)) {
                wheresql = wheresql + " and ";
            }
            wheresql = wheresql + " f" + orgOrAccountColumnKey + " in (" + String.join((CharSequence)",", orgids) + ")";
        }
        List<Object[]> auditBillData = this.getAuditBillData(showInfo.getCentralAppChain(), showInfo.getReportBillNos(), showInfo.getRefedBillNos(), approveBill.getBillNo(), showInfo.getEntitySet(), showInfo.getAccountSet(), tableName, wheresql, main_collect);
        return auditBillData;
    }

    private List<Object[]> getAuditBillData(CentralAppChain chain, Set<String> applyBillNumbers, Set<String> refedBillNumbers, String currentBillNumber, Set<Long> orgIds, Set<Long> accountIds, String tableName, String wheresql, List<BaseColumn> main_collect) {
        Set<String> centralAppChainsBillSet = CentralAppBillService.getInstance().getCentralAppChainsBillSet(chain);
        centralAppChainsBillSet.addAll(applyBillNumbers);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)currentBillNumber)) {
            centralAppChainsBillSet.add(currentBillNumber);
        }
        centralAppChainsBillSet.addAll(refedBillNumbers);
        log.info("getCollectData ---- centralAppChainsBillSet: " + centralAppChainsBillSet + " applyBillNumbers: " + applyBillNumbers + " currentBillNumber:" + currentBillNumber + " refedBillNumbers: " + refedBillNumbers);
        Long applyBillId = 0L;
        centralAppChainsBillSet.remove("");
        List<Object[]> batchBillDataWhere = ApplyTemplateUtils.getBatchBillDataWhere(tableName, centralAppChainsBillSet, main_collect, wheresql);
        return batchBillDataWhere;
    }

    private void createSubApproveBill(ApproveBill mainApproveBill, List<ApproveBillConfig> approveBillConfigs, int maxSeq, String auditNode) {
        Map centralOrgMap = approveBillConfigs.stream().collect(Collectors.groupingBy(s -> s.getCentralOrg(), Collectors.toList()));
        ArrayList<ApproveBill> subApproveBillList = new ArrayList<ApproveBill>(16);
        int index = maxSeq;
        for (Map.Entry map : centralOrgMap.entrySet()) {
            Long centralOrg = map.getKey();
            List config = map.getValue();
            Long id = GlobalIdUtil.genGlobalLongId();
            String mainbillno = mainApproveBill.getBillNo();
            String mainName = mainApproveBill.getName();
            String format = String.format("%04d", index);
            String curBillNo = mainbillno + "-" + format;
            String sbname = ResManager.loadKDString((String)"\u7533\u62a5\u5ba1\u6279\u5355", (String)"CentralAppBillService_10", (String)"epm-eb-business", (Object[])new Object[0]);
            String centralname = ResManager.loadKDString((String)"\u5f52\u53e3\u5ba1\u6279\u5355", (String)"CentralAppBillService_25", (String)"epm-eb-business", (Object[])new Object[0]);
            String hzname = ResManager.loadKDString((String)"\u6c47\u603b\u5ba1\u6279\u5355", (String)"CentralAppBillService_11", (String)"epm-eb-business", (Object[])new Object[0]);
            String name = mainName.replace(sbname, centralname).replace(hzname, centralname);
            ApproveBill approveBill = new ApproveBill(id, name, curBillNo);
            Long usrId = this.getUserId();
            Date date = TimeServiceHelper.now();
            approveBill.setModel(mainApproveBill.getModel());
            Long adminOrg = this.getAdminOrgByReportOrg(centralOrg, mainApproveBill.getModel());
            approveBill.setBailadminorg(adminOrg);
            approveBill.setApprovetypes(mainApproveBill.getApprovetypes());
            approveBill.setParentId(mainApproveBill.getId());
            approveBill.setMainbill(false);
            approveBill.setApproveconfig(config);
            approveBill.setYear(mainApproveBill.getYear());
            approveBill.setVersion(mainApproveBill.getVersion());
            approveBill.setDatatype(mainApproveBill.getDatatype());
            approveBill.setReportScheme(mainApproveBill.getReportScheme());
            approveBill.setReportEntity(mainApproveBill.getReportEntity());
            approveBill.setBillStatus(AppBillStatusEnum.STORAGE);
            approveBill.setCreator(mainApproveBill.getCreator());
            approveBill.setCreateDate(date);
            approveBill.setModifier(mainApproveBill.getCreator());
            approveBill.setModifyDate(date);
            approveBill.setCentralorg(centralOrg);
            approveBill.setSplitnode(auditNode);
            ++index;
            subApproveBillList.add(approveBill);
        }
        try (TXHandle tx = TX.required((String)"autoCreateSubApproveBillinner");){
            try {
                mainApproveBill.setHasSubitems(true);
                ApproveBillUtil.getInstance().save(Collections.singletonList(mainApproveBill));
                log.info("CentralAppBillService.createSubApproveBill -----> " + mainApproveBill.getApproveconfig().toString());
                ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(16);
                for (ApproveBill approveBill : subApproveBillList) {
                    datas.add(ApproveBillUtil.getInstance().toNewDynamicObject2(approveBill));
                }
                this.submitApproveBill(datas.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public Map<Long, List<Map<String, Set<Long>>>> getCentralRelations(List<DynamicObject> currentRelations, IModelCacheHelper modelCacheHelper, Set<String> centralDims) {
        if (CollectionUtils.isEmpty(currentRelations)) {
            return new HashMap<Long, List<Map<String, Set<Long>>>>(16);
        }
        LinkedHashMap<Long, List<Map<String, Set<Long>>>> centralRelationMap = new LinkedHashMap<Long, List<Map<String, Set<Long>>>>(16);
        Date now = TimeServiceHelper.now();
        for (DynamicObject object : currentRelations) {
            Date enableDate = object.getDate("enabledate");
            Date disableDate = object.getDate("disabledate");
            if (enableDate != null && (now.compareTo(enableDate) < 0 || disableDate != null && now.compareTo(disableDate) > 0)) continue;
            Long centralOrg = object.getLong("entity");
            String json = object.getString("meminfojson");
            Map innerMap = (Map)JSONObject.parseObject((String)json, Map.class);
            List maps = centralRelationMap.computeIfAbsent(centralOrg, s -> new ArrayList(16));
            HashMap row = new HashMap(16);
            for (Map.Entry o : innerMap.entrySet()) {
                String key = (String)o.getKey();
                Map value = (Map)o.getValue();
                String number = (String)value.get("number");
                String range = (String)value.get("range");
                String viewId = (String)value.get("viewId");
                List members = modelCacheHelper.getMemberSort(key, Long.valueOf(Long.parseLong(viewId)), number, Integer.parseInt(range));
                Set mapMemberIds = members.stream().map(s -> s.getId()).collect(Collectors.toSet());
                centralDims.add(key);
                row.put(key, mapMemberIds);
            }
            maps.add(row);
        }
        return centralRelationMap;
    }

    public Map<Long, Set<Long>> getCentralSchemaIds(List<DynamicObject> approveTypes, Long submitOrgId, IModelCacheHelper modelCacheHelper) {
        HashMap<Long, Set<Long>> appprveIdMapSchemeaIds = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject approveType : approveTypes) {
            Long bizModelId = approveType.getLong("bizmodel.id");
            Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
            DynamicObjectCollection centralRelationColl = approveType.getDynamicObjectCollection("entryentity_relation");
            if (CollectionUtils.isEmpty((Collection)centralRelationColl)) continue;
            HashMap<Long, Set> budgetOrgSchemaMap = new HashMap<Long, Set>(centralRelationColl.size());
            HashSet<Long> centralSchemaIds = new HashSet<Long>(centralRelationColl.size());
            for (DynamicObject centralRelation : centralRelationColl) {
                Long budgetOrgId = centralRelation.getLong("budgetorg.id");
                Long schemaId = centralRelation.getLong("centralschema.id");
                Set schemaIds = budgetOrgSchemaMap.computeIfAbsent(budgetOrgId, v -> new HashSet(16));
                schemaIds.add(schemaId);
                if (!submitOrgId.equals(budgetOrgId)) continue;
                centralSchemaIds.add(schemaId);
            }
            if (CollectionUtils.isEmpty(centralSchemaIds)) {
                Long viewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, submitOrgId);
                List parentOrgList = modelCacheHelper.getParents(viewId, member, false);
                for (Member parentOrg : parentOrgList) {
                    Long parentOrgId = parentOrg.getId();
                    if (!budgetOrgSchemaMap.containsKey(parentOrgId)) continue;
                    centralSchemaIds.addAll((Collection)budgetOrgSchemaMap.get(parentOrgId));
                    break;
                }
            }
            appprveIdMapSchemeaIds.put(approveType.getLong("id"), centralSchemaIds);
        }
        return appprveIdMapSchemeaIds;
    }

    public void showOperationResultForUnAudit(String operateName, String successInfo, Map<String, String> errInfos, IFormView view, String pluginName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_operationresult");
        showParameter.setCloseCallBack(new CloseCallBack(pluginName, "OperationResult"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int errSize = errInfos.size();
        int successSize = 1 - errSize;
        String title = ResManager.loadResFormat((String)"\u5171%1\u6761\u8bb0\u5f55\uff0c%2\u6210\u529f%3\u6761\uff0c\u5931\u8d25%4\u6761\u3002", (String)"ApproveBillListNew_25", (String)"epm-eb-formplugin", (Object[])new Object[]{1, operateName, successSize, errSize});
        showParameter.setCustomParam("title", (Object)title);
        StringBuilder message = new StringBuilder();
        if (errInfos.size() != 0) {
            message.append(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f:", (String)"ApproveBillListNew_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            message.append("\n");
            errInfos.forEach((key, value) -> message.append((String)key).append(":").append((String)value).append("\n"));
        } else {
            message.append(ResManager.loadKDString((String)"\u6210\u529f\u4fe1\u606f:", (String)"ApproveBillListNew_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            message.append("\n");
            message.append(successInfo);
        }
        showParameter.setCustomParam("errorMsg", (Object)message.toString());
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        view.showForm(showParameter);
    }
}

