/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.centralapproval.ApproveAdjDimTypeEnum;
import kd.epm.eb.common.centralapproval.ApproveAdjustDimEntry;
import kd.epm.eb.common.centralapproval.ApprovePlan;
import kd.epm.eb.common.centralapproval.ApproverRelationEnum;
import kd.epm.eb.common.centralapproval.ApproverTypeEnum;
import kd.epm.eb.common.centralapproval.CenClassifyTypeEnum;
import kd.epm.eb.common.centralapproval.SimpleMemberDto;
import kd.epm.eb.common.centralapproval.entity.ApprovePlanClassifyEntity;
import kd.epm.eb.common.centralapproval.entity.ApprovePlanDto;
import kd.epm.eb.common.centralapproval.entity.ApproverDto;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CentralApprovePlanService {
    private static Log log = LogFactory.getLog(CentralApprovePlanService.class);

    public static CentralApprovePlanService getInstance() {
        return new CentralApprovePlanService();
    }

    private CentralApprovePlanService() {
    }

    public List<ApprovePlanDto> getApprovePlanByCentralPlanIds(Long centralPlanId, Long modelId) {
        ArrayList<ApprovePlanDto> result = new ArrayList<ApprovePlanDto>(16);
        if (IDUtils.isEmptyLong((Long)centralPlanId).booleanValue() || IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return result;
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("effectstatus", "=", (Object)Boolean.TRUE);
        Map approvePlanCollection = BusinessDataServiceHelper.loadFromCache((String)"eb_centralappplanentity", (QFilter[])filter.toArray());
        block0: for (Map.Entry entry : approvePlanCollection.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            Long id = value.getLong("id");
            String name = value.getString("name");
            String number = value.getString("number");
            DynamicObjectCollection centralizedentryentity = value.getDynamicObjectCollection("centralizedentryentity");
            ApprovePlanDto dto = new ApprovePlanDto();
            for (DynamicObject dynamicObject : centralizedentryentity) {
                long centralSchemeId;
                DynamicObject centralizedscheme = dynamicObject.getDynamicObject("centralizedscheme");
                if (centralizedscheme == null || !centralPlanId.equals(centralSchemeId = centralizedscheme.getLong("id"))) continue;
                dto.setId(id);
                dto.setName(name);
                dto.setNumber(number);
                result.add(dto);
                continue block0;
            }
        }
        return result;
    }

    public List<ApprovePlan> getApprovePlanCfgByNumbers(Set<String> numbers, Long modelId) {
        ArrayList<ApprovePlan> result = new ArrayList<ApprovePlan>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (numbers != null) {
            filter.and("number", "in", numbers);
        }
        filter.and("effectstatus", "=", (Object)Boolean.TRUE);
        Map approvePlanObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_centralappplanentity", (QFilter[])filter.toArray());
        for (Map.Entry entry : approvePlanObjs.entrySet()) {
            ApprovePlan approvePlan = new ApprovePlan();
            DynamicObject value = (DynamicObject)entry.getValue();
            Long id = (Long)entry.getKey();
            String name = value.getString("name");
            String number = value.getString("number");
            String classify = value.getString("classify");
            DynamicObject approveclassify = value.getDynamicObject("approveclassify");
            if (approveclassify != null) {
                ApprovePlanClassifyEntity approvePlanClassifyEntity = new ApprovePlanClassifyEntity();
                approvePlanClassifyEntity.setId(Long.valueOf(approveclassify.getLong("id")));
                approvePlanClassifyEntity.setParentId(Long.valueOf(approveclassify.getLong("parentid")));
                approvePlanClassifyEntity.setNumber(approveclassify.getString("number"));
                approvePlanClassifyEntity.setName(approveclassify.getString("name"));
                approvePlan.setApprovePlanClassifyEntity(approvePlanClassifyEntity);
            }
            boolean centralizedstatus = value.getBoolean("centralizedstatus");
            approvePlan.setId(id);
            approvePlan.setName(name);
            approvePlan.setNumber(number);
            approvePlan.setTypeEnum(CenClassifyTypeEnum.getTypeByNumber((String)classify));
            approvePlan.setCenApprove(Boolean.valueOf(centralizedstatus));
            ArrayList<Long> templateIds = new ArrayList<Long>(16);
            DynamicObjectCollection entryentity = value.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
                for (DynamicObject dynamicObject : entryentity) {
                    DynamicObject billTemplate = dynamicObject.getDynamicObject("billtemplate");
                    if (billTemplate == null) continue;
                    long templateId = billTemplate.getLong("id");
                    templateIds.add(templateId);
                }
            }
            approvePlan.setTemplates(templateIds);
            ArrayList<Long> centralPlans = new ArrayList<Long>(16);
            DynamicObjectCollection centralizedentryentity = value.getDynamicObjectCollection("centralizedentryentity");
            if (CollectionUtils.isNotEmpty((Collection)centralizedentryentity)) {
                for (DynamicObject dynamicObject : centralizedentryentity) {
                    long centralizedschemeId = dynamicObject.getDynamicObject("centralizedscheme").getLong("id");
                    centralPlans.add(centralizedschemeId);
                }
            }
            approvePlan.setCentralPlans(centralPlans);
            HashMap<ApproverTypeEnum, List> approvers = new HashMap<ApproverTypeEnum, List>(16);
            DynamicObjectCollection auditorentryentity = value.getDynamicObjectCollection("auditorentryentity");
            if (CollectionUtils.isNotEmpty((Collection)auditorentryentity)) {
                for (DynamicObject dynamicObject : auditorentryentity) {
                    String auditortype = dynamicObject.getString("auditortype");
                    ApproverTypeEnum approverEnumByValue = ApproverTypeEnum.getApproverEnumByValue((String)auditortype);
                    List approverDtos = approvers.computeIfAbsent(approverEnumByValue, t -> new ArrayList(16));
                    ApproverDto approverDto = new ApproverDto();
                    approverDto.setAuditortype(auditortype);
                    String auditorrange = dynamicObject.getString("auditorrange");
                    String billorgkey = dynamicObject.getString("billorgkey");
                    DynamicObject wfrole = dynamicObject.getDynamicObject("wfrole");
                    if (wfrole != null) {
                        approverDto.setWfrole(Long.valueOf(wfrole.getLong("id")));
                    }
                    String relationtype = dynamicObject.getString("relationtype");
                    String referenceperson = dynamicObject.getString("referenceperson");
                    int relation = dynamicObject.getInt("relation");
                    DynamicObject person = dynamicObject.getDynamicObject("person");
                    if (person != null) {
                        approverDto.setPerson(Long.valueOf(person.getLong("id")));
                    }
                    approverDto.setAuditorrange(auditorrange);
                    approverDto.setBillorgkey(billorgkey);
                    approverDto.setRelationtype(relationtype);
                    approverDto.setReferenceperson(referenceperson);
                    approverDto.setRelation(ApproverRelationEnum.getByValue((int)relation));
                    approverDtos.add(approverDto);
                }
            }
            approvePlan.setApprovers(approvers);
            ArrayList<ApproveAdjustDimEntry> appDimMemLevel = new ArrayList<ApproveAdjustDimEntry>(16);
            DynamicObjectCollection adjdimentryentity = value.getDynamicObjectCollection("adjdimentryentity");
            DynamicObjectCollection adjmemberentryentity = value.getDynamicObjectCollection("adjmemberentryentity");
            if (CollectionUtils.isNotEmpty((Collection)adjdimentryentity)) {
                for (DynamicObject dynamicObject : adjdimentryentity) {
                    ApproveAdjustDimEntry approveAdjustDimEntry = new ApproveAdjustDimEntry();
                    DynamicObject dimensionid = dynamicObject.getDynamicObject("dimensionid");
                    if (dimensionid != null) {
                        String dimNum = dimensionid.getString("number");
                        approveAdjustDimEntry.setDimNumber(dimNum);
                    }
                    String rowid = dynamicObject.getString("rowid");
                    String dimmemlevel = dynamicObject.getString("dimmemlevel");
                    String rangetype = dynamicObject.getString("rangetype");
                    ApproveAdjDimTypeEnum.RangeTypeEnum typeByValue = ApproveAdjDimTypeEnum.RangeTypeEnum.getTypeByValue((String)rangetype);
                    String orgreferencefield = dynamicObject.getString("orgreferencefield");
                    approveAdjustDimEntry.setLevel(dimmemlevel);
                    approveAdjustDimEntry.setEntityField(orgreferencefield);
                    approveAdjustDimEntry.setType(typeByValue);
                    if (CollectionUtils.isNotEmpty((Collection)adjmemberentryentity) && StringUtils.isEmpty((String)orgreferencefield)) {
                        HashSet<Long> members = new HashSet<Long>(16);
                        for (DynamicObject object : adjmemberentryentity) {
                            long memberId = object.getDynamicObject("memberid").getLong("id");
                            String relationrowid = object.getString("relationrowid");
                            if (!StringUtils.equals((String)relationrowid, (String)rowid)) continue;
                            members.add(memberId);
                        }
                        approveAdjustDimEntry.setMembers(members);
                    }
                    appDimMemLevel.add(approveAdjustDimEntry);
                }
            }
            approvePlan.setAppDimMemLevel(appDimMemLevel);
            result.add(approvePlan);
        }
        return result;
    }

    public Set<Long> getApprovePlanTemplatesByNumbers(Set<String> numbers, Long modelId) {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("number", "in", numbers);
        filter.and("effectstatus", "=", (Object)Boolean.TRUE);
        Map approvePlanObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_centralappplanentity", (QFilter[])filter.toArray());
        for (Map.Entry entry : approvePlanObjs.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            DynamicObjectCollection entryentity = value.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isNotEmpty((Collection)entryentity)) continue;
            for (DynamicObject dynamicObject : entryentity) {
                long templateId = dynamicObject.getDynamicObject("billtemplate").getLong("id");
                templateIds.add(templateId);
            }
        }
        return templateIds;
    }

    public Map<String, Map<String, Object>> getApprovePlanInfoByNumbers(Set<String> numbers, Long modelId) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(16);
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || numbers.size() == 0) {
            return result;
        }
        HashMap<String, Map<String, Object>> noCentralSchemeMap = new HashMap<String, Map<String, Object>>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("number", "in", numbers);
        filter.and("effectstatus", "=", (Object)Boolean.TRUE);
        Map approvePlanObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_centralappplanentity", (QFilter[])filter.toArray());
        for (Map.Entry entry : approvePlanObjs.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            Long approveSchemeId = IDUtils.toLong(entry.getKey());
            String name = value.getString("name");
            String number = value.getString("number");
            boolean centralizedStatus = value.getBoolean("centralizedstatus");
            if (centralizedStatus) {
                DynamicObjectCollection centralizedentryentity = value.getDynamicObjectCollection("centralizedentryentity");
                for (DynamicObject dynamicObject : centralizedentryentity) {
                    Long centralizePlanId = dynamicObject.getLong("centralizedscheme.id");
                    String centralizeApproveOrgName = dynamicObject.getDynamicObject("centralizedscheme").getString("entitynumber.name");
                    String centralizeApproveOrgNumber = dynamicObject.getDynamicObject("centralizedscheme").getString("entitynumber.number");
                    HashMap<String, Object> objectMap = new HashMap<String, Object>(16);
                    objectMap.put("approveSchemeName", name);
                    objectMap.put("approveSchemeNumber", number);
                    objectMap.put("approveSchemeId", approveSchemeId);
                    objectMap.put("centralizePlanId", centralizePlanId);
                    objectMap.put("centralizeApproveOrgName", centralizeApproveOrgName);
                    objectMap.put("centralizeApproveOrgNumber", centralizeApproveOrgNumber);
                    objectMap.put("centralizedstatus", centralizedStatus);
                    result.put(centralizeApproveOrgNumber, objectMap);
                }
                continue;
            }
            HashMap<String, Object> objectMap = new HashMap<String, Object>(16);
            objectMap.put("approveSchemeName", name);
            objectMap.put("approveSchemeNumber", number);
            objectMap.put("approveSchemeId", approveSchemeId);
            objectMap.put("centralizedstatus", centralizedStatus);
            noCentralSchemeMap.put(number, objectMap);
        }
        if (result.size() == 0) {
            return noCentralSchemeMap;
        }
        return result;
    }

    public Map<String, Set<String>> getQuotedCentralSchemeNumbers(Long modelId) {
        HashMap<String, Set<String>> centralSchemeQuoteInfo = new HashMap<String, Set<String>>(16);
        Map<String, Set<SimpleMemberDto>> approveQuoteCentralScheme = this.getQuotedCentralSchemes(modelId);
        if (approveQuoteCentralScheme.size() > 0) {
            for (Map.Entry<String, Set<SimpleMemberDto>> entry : approveQuoteCentralScheme.entrySet()) {
                String approveSchemeName = entry.getKey();
                Set<SimpleMemberDto> centralSchemes = entry.getValue();
                for (SimpleMemberDto centralScheme : centralSchemes) {
                    Set approveSchemeNames = centralSchemeQuoteInfo.computeIfAbsent(centralScheme.getNumber(), e -> new HashSet());
                    approveSchemeNames.add(approveSchemeName);
                }
            }
        }
        return centralSchemeQuoteInfo;
    }

    public Map<Long, Set<String>> getQuotedCentralSchemeIds(Long modelId) {
        HashMap<Long, Set<String>> centralSchemeQuoteInfo = new HashMap<Long, Set<String>>(16);
        Map<String, Set<SimpleMemberDto>> approveQuoteCentralScheme = this.getQuotedCentralSchemes(modelId);
        if (approveQuoteCentralScheme.size() > 0) {
            for (Map.Entry<String, Set<SimpleMemberDto>> entry : approveQuoteCentralScheme.entrySet()) {
                String approveSchemeName = entry.getKey();
                Set<SimpleMemberDto> centralSchemes = entry.getValue();
                for (SimpleMemberDto centralScheme : centralSchemes) {
                    Set approveSchemeNames = centralSchemeQuoteInfo.computeIfAbsent(centralScheme.getId(), e -> new HashSet());
                    approveSchemeNames.add(approveSchemeName);
                }
            }
        }
        return centralSchemeQuoteInfo;
    }

    public Map<String, Set<SimpleMemberDto>> getQuotedCentralSchemes(Long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("effectstatus", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_centralappplanentity", (String)"name,centralizedentryentity.centralizedscheme.id,centralizedentryentity.centralizedscheme.number,centralizedentryentity.centralizedscheme.name", (QFilter[])filter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            HashMap<String, Set<SimpleMemberDto>> approveQuoteCentralScheme = new HashMap<String, Set<SimpleMemberDto>>(dynamicObjectCollection.size());
            for (DynamicObject object : dynamicObjectCollection) {
                Set curApproveQuoteCentralScheme = approveQuoteCentralScheme.computeIfAbsent(object.getString("name"), e -> new HashSet());
                curApproveQuoteCentralScheme.add(new SimpleMemberDto(Long.valueOf(object.getLong("centralizedentryentity.centralizedscheme.id")), object.getString("centralizedentryentity.centralizedscheme.name"), object.getString("centralizedentryentity.centralizedscheme.number")));
            }
            return approveQuoteCentralScheme;
        }
        return new HashMap<String, Set<SimpleMemberDto>>(0);
    }
}

