/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.approvetype.ApproveTypeUtils;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.business.bailorg.pojo.BailOrgRelation;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.business.centralrelation.CentralRelationShotService;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.enums.AuditTypeEnum;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.lang3.StringUtils;

public class CentralSplitBillService {
    private static final Log log = LogFactory.getLog(CentralSplitBillService.class);
    private String mainBillNo;

    public static CentralSplitBillService getInstance() {
        return new CentralSplitBillService();
    }

    public void splitBill(DynamicObject mainApproveBill, Map<Long, Long> centralSchemaMap, boolean allowMultiSplit) {
        this.mainBillNo = mainApproveBill.getString("billno");
        log.info("splitBill==>mainBillNo={},start", (Object)this.mainBillNo);
        String centralBillType = mainApproveBill.getString("centralbilltype");
        if (CentralBillType.Child.getNumber().equals(centralBillType) && !allowMultiSplit) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u62c6\u5206\u8fc7\u7684\u5b50\u5355\u4e0d\u80fd\u518d\u6b21\u62c6\u5206\uff0c\u8bf7\u68c0\u67e5\u4e3b\u5355\u7684\u5de5\u4f5c\u6d41\u542f\u52a8\u6761\u4ef6\u914d\u7f6e\u3002", (String)"CentralSplitBillService_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        Long approveTypeId = mainApproveBill.getLong("approvetype.id");
        if (!this.isCentralSplit(approveTypeId)) {
            this.updateCentralAuditPass(mainApproveBill);
            log.error("splitBill==>mainBillNo={},central split switch is closed", (Object)this.mainBillNo);
            return;
        }
        Long modelId = mainApproveBill.getLong("modelid.id");
        Long bizModelId = mainApproveBill.getLong("bizmodelid.id");
        Long submitOrgId = mainApproveBill.getLong("eborgid.id");
        Map<String, Long> centralDimViewMap = this.getCentralDimViewMap(bizModelId);
        if (CollectionUtils.isEmpty(centralDimViewMap)) {
            this.updateCentralAuditPass(mainApproveBill);
            log.error("splitBill==>mainBillNo={},centralDimViewMap is empty", (Object)this.mainBillNo);
            return;
        }
        log.info("splitBill==>mainBillNo={},centralDimViewMap: {}", (Object)this.mainBillNo, (Object)SerializationUtils.toJsonString(centralDimViewMap));
        Long orgViewId = centralDimViewMap.get(SysDimensionEnum.Entity.getNumber());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Set<Long> centralSchemaIds = CollectionUtils.isEmpty(centralSchemaMap) ? ApproveTypeUtils.getInstance().getCentralSchemaIds(modelCacheHelper, approveTypeId, submitOrgId, orgViewId) : this.getAppointedCentralSchemaIds(modelCacheHelper, centralSchemaMap, submitOrgId, orgViewId);
        if (CollectionUtils.isEmpty(centralSchemaIds)) {
            this.updateCentralAuditPass(mainApproveBill);
            log.error("splitBill==>mainBillNo={},centralSchemaIds is empty", (Object)this.mainBillNo);
            return;
        }
        log.info("splitBill==>mainBillNo={},centralSchemaIds: {}", (Object)this.mainBillNo, (Object)SerializationUtils.toJsonString(centralSchemaIds));
        List<Dimension> customDimList = this.getCustomDimList(modelCacheHelper, bizModelId);
        Map<Long, Set<String>> centralDimMap = this.getCentralDimMap(modelId, centralSchemaIds, customDimList);
        if (CollectionUtils.isEmpty(centralDimMap)) {
            this.updateCentralAuditPass(mainApproveBill);
            log.error("splitBill==>mainBillNo={},centralDimMap is empty", (Object)this.mainBillNo);
            return;
        }
        log.info("splitBill==>mainBillNo={},centralDimMap: {}", (Object)this.mainBillNo, (Object)SerializationUtils.toJsonString(centralDimMap));
        Map<String, List<Map<String, Set<String>>>> templateWithDimMap = this.getTemplateWithDimMap(modelCacheHelper, mainApproveBill);
        if (CollectionUtils.isEmpty(templateWithDimMap)) {
            this.updateCentralAuditPass(mainApproveBill);
            log.error("splitBill==>mainBillNo={},templateWithDimMap is empty", (Object)this.mainBillNo);
            return;
        }
        log.info("splitBill==>mainBillNo={},templateWithDimMap: {}", (Object)this.mainBillNo, (Object)SerializationUtils.toJsonString(templateWithDimMap));
        Map<Long, Set<Long>> centralOrgTempMap = this.getCentralOrgTempMap(modelCacheHelper, modelId, centralDimMap, templateWithDimMap, centralDimViewMap);
        if (CollectionUtils.isEmpty(centralOrgTempMap)) {
            this.updateCentralAuditPass(mainApproveBill);
            log.error("splitBill==>mainBillNo={},centralOrgTempMap is empty", (Object)this.mainBillNo);
            return;
        }
        log.info("splitBill==>mainBillNo={},centralOrgTempMap: {}", (Object)this.mainBillNo, (Object)SerializationUtils.toJsonString(centralOrgTempMap));
        Map<Long, Set<Long>> centralOrgSchemaMap = CentralRelationService.getInstance().getCentralOrgSchemaMap(centralSchemaIds);
        log.info("splitBill==>mainBillNo={},centralOrgSchemaMap: {}", (Object)this.mainBillNo, (Object)SerializationUtils.toJsonString(centralOrgSchemaMap));
        DynamicObject[] subApproveBills = this.createSubApproveBill(mainApproveBill, centralOrgTempMap, centralOrgSchemaMap);
        this.saveCentralDimSnapshot(subApproveBills, centralSchemaIds);
        log.info("splitBill==>mainBillNo={},finished", (Object)this.mainBillNo);
    }

    private Set<Long> getAppointedCentralSchemaIds(IModelCacheHelper modelCacheHelper, Map<Long, Long> centralSchemaMap, Long submitOrgId, Long orgViewId) {
        kd.epm.eb.common.cache.impl.Member entityMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, submitOrgId);
        List memberList = modelCacheHelper.getParents(orgViewId, entityMember, true);
        List memberIds = memberList.stream().map(member -> member.getId()).collect(Collectors.toList());
        HashSet<Long> centralSchemaIds = new HashSet<Long>(centralSchemaMap.size());
        for (Map.Entry<Long, Long> entry : centralSchemaMap.entrySet()) {
            Long centralSchemaId = entry.getKey();
            Long budgetOrgId = entry.getValue();
            if (!memberIds.contains(budgetOrgId)) continue;
            centralSchemaIds.add(centralSchemaId);
        }
        return centralSchemaIds;
    }

    private Map<String, List<Map<String, Set<String>>>> getTemplateWithDimMap(IModelCacheHelper modelCacheHelper, DynamicObject mainApproveBill) {
        Map<String, Map<String, String>> varValues = this.getVarValueMap(mainApproveBill);
        DynamicObjectCollection templateEntity = mainApproveBill.getDynamicObjectCollection("entryentity");
        HashSet templateIds = new HashSet(templateEntity.size());
        templateEntity.forEach(e -> {
            long templateId = e.getLong("tempid.id");
            templateIds.add(templateId);
        });
        HashMap<String, List<Map<String, Set<String>>>> templateWithDimMap = new HashMap<String, List<Map<String, Set<String>>>>(templateIds.size());
        Map templateObjArr = BusinessDataServiceHelper.loadFromCache((Object[])templateIds.toArray(), (String)"eb_templateentity");
        for (DynamicObject templateObj : templateObjArr.values()) {
            List<Object> templateDimMemList;
            ITemplateModel templateModel;
            Long templateId = templateObj.getLong("id");
            Long datasetId = templateObj.getLong("dataset.id");
            String data = templateObj.getString("data");
            if (StringUtils.isEmpty((CharSequence)data) || (templateModel = TemplateModelJSONUtil.parseITemplateModel((String)data)) == null) continue;
            Map dimensionView = templateModel.getDimensionView();
            if (this.isFixTemplate(templateModel, templateObj.getInt("templatetype"))) {
                String submitOrgNum = mainApproveBill.getString("eborgid.number");
                templateDimMemList = this.getFixTemplateDimMemList(modelCacheHelper, templateModel, submitOrgNum);
            } else {
                templateDimMemList = new ArrayList(1);
                Map quoteMemberMap = templateModel.retrieveQuoteMembersWithScope();
                if (CollectionUtils.isNotEmpty((Map)quoteMemberMap)) {
                    templateDimMemList.add(quoteMemberMap);
                }
            }
            ArrayList<HashMap<String, Set<String>>> dimMemMapList = new ArrayList<HashMap<String, Set<String>>>(16);
            for (Map map : templateDimMemList) {
                HashMap<String, Set<String>> dimMemMap = new HashMap<String, Set<String>>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    HashSet<String> members;
                    String dimNumber = (String)entry.getKey();
                    Collection dimMemberColl = (Collection)entry.getValue();
                    if (CollectionUtils.isEmpty((Collection)dimMemberColl)) {
                        if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber)) continue;
                        members = new HashSet(1);
                        String submitOrgNum = mainApproveBill.getString("eborgid.number");
                        members.add(submitOrgNum);
                        dimMemMap.put(dimNumber, members);
                        continue;
                    }
                    members = new HashSet<String>(dimMemberColl.size());
                    Long dimViewId = 0L;
                    if (CollectionUtils.isNotEmpty((Map)dimensionView)) {
                        dimViewId = (Long)dimensionView.get(dimNumber);
                    }
                    for (Member member : dimMemberColl) {
                        String memberNum = member.getNumber();
                        if (memberNum.contains("@")) {
                            Long modelId = mainApproveBill.getLong("modelid.id");
                            memberNum = ReportVarUtil.getRealDimByVar((Long)modelId, (String)memberNum, (String)dimNumber, varValues);
                        }
                        List memberList = modelCacheHelper.getMember(dimNumber, dimViewId, memberNum, member.getRange());
                        members.addAll(memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                    }
                    dimMemMap.put(dimNumber, members);
                }
                this.syncCustomDimMem(modelCacheHelper, datasetId, dimMemMap);
                dimMemMapList.add(dimMemMap);
            }
            templateWithDimMap.put(templateId + "!" + datasetId, dimMemMapList);
        }
        return templateWithDimMap;
    }

    private Map<Long, Set<Long>> getCentralOrgTempMap(IModelCacheHelper modelCacheHelper, Long modelId, Map<Long, Set<String>> centralDimMap, Map<String, List<Map<String, Set<String>>>> templateWithDimMap, Map<String, Long> centralDimViewMap) {
        HashMap<Long, Set<Long>> centralOrgTempMap = new HashMap<Long, Set<Long>>(centralDimMap.size());
        for (Map.Entry<Long, Set<String>> centralDimEntry : centralDimMap.entrySet()) {
            Long centralOrgId = centralDimEntry.getKey();
            Set<String> centralDimSet = centralDimEntry.getValue();
            if (CollectionUtils.isEmpty(centralDimSet)) {
                Set<String> idKeys = templateWithDimMap.keySet();
                HashSet<Long> templateIds = new HashSet<Long>(templateWithDimMap.size());
                for (String idKey : idKeys) {
                    Long templateId = IDUtils.toLong((Object)idKey.split("!")[0]);
                    templateIds.add(templateId);
                }
                centralOrgTempMap.put(centralOrgId, templateIds);
                continue;
            }
            for (String centralDimStr : centralDimSet) {
                Set templateIdSet = (Set)centralOrgTempMap.get(centralOrgId);
                if (CollectionUtils.isNotEmpty((Collection)templateIdSet) && templateIdSet.size() == templateWithDimMap.size()) continue;
                String[] centralDimArr = centralDimStr.split("!");
                int dimCount = centralDimArr.length;
                block3: for (Map.Entry<String, List<Map<String, Set<String>>>> templateEntry : templateWithDimMap.entrySet()) {
                    String[] idKeys = templateEntry.getKey().split("!");
                    Long templateId = IDUtils.toLong((Object)idKeys[0]);
                    Long datasetId = IDUtils.toLong((Object)idKeys[1]);
                    List<Map<String, Set<String>>> templateAreaDimList = templateEntry.getValue();
                    boolean isSplit = false;
                    for (Map<String, Set<String>> templateDimMap : templateAreaDimList) {
                        List<Dimension> customDimList;
                        if (isSplit) continue block3;
                        HashMap<String, Set<String>> intersectionMap = new HashMap<String, Set<String>>(dimCount);
                        for (String centralDim : centralDimArr) {
                            Set intersection;
                            String dimNumber = centralDim.split("@")[0];
                            String dimMemNumber = centralDim.split("@")[1];
                            Long dimViewId = centralDimViewMap.get(dimNumber);
                            List centralMemberList = modelCacheHelper.getMember(dimNumber, dimViewId, dimMemNumber, RangeEnum.ALL.getIndex());
                            Set centralDimMemberList = centralMemberList.stream().map(member -> member.getNumber()).collect(Collectors.toSet());
                            Set<String> templateDimMemberSet = templateDimMap.get(dimNumber);
                            if (CollectionUtils.isEmpty(templateDimMemberSet) || !CollectionUtils.isNotEmpty(intersection = centralDimMemberList.stream().filter(item -> templateDimMemberSet.contains(item)).collect(Collectors.toSet()))) continue;
                            intersectionMap.put(dimNumber, intersection);
                        }
                        if (dimCount != intersectionMap.size() || !this.isExistOlapData(modelId, datasetId, customDimList = this.getCustomDimListByDataset(modelCacheHelper, datasetId), intersectionMap, templateDimMap)) continue;
                        Set templateIds = centralOrgTempMap.computeIfAbsent(centralOrgId, v -> new HashSet(16));
                        templateIds.add(templateId);
                        isSplit = true;
                    }
                }
            }
        }
        return centralOrgTempMap;
    }

    private boolean isExistOlapData(Long modelId, Long datasetId, List<Dimension> customDimList, Map<String, Set<String>> intersectionMap, Map<String, Set<String>> templateDimMap) {
        Set<String> dimMemberSet;
        String dimNumber;
        List customDimMemList = customDimList.stream().map(dimension -> dimension.getNumber()).collect(Collectors.toList());
        HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
        for (Map.Entry<String, Set<String>> templateDimEntry : templateDimMap.entrySet()) {
            dimNumber = templateDimEntry.getKey();
            dimMemberSet = templateDimEntry.getValue();
            memberInfo.put(dimNumber, dimMemberSet);
        }
        for (Map.Entry<String, Set<String>> entry : intersectionMap.entrySet()) {
            dimNumber = entry.getKey();
            dimMemberSet = entry.getValue();
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                memberInfo.put(dimNumber, dimMemberSet);
            }
            if (!customDimMemList.contains(dimNumber)) continue;
            memberInfo.put(dimNumber, dimMemberSet);
        }
        log.info("splitBill==>isExistOlapData mainBillNo={}, memberInfo={}", (Object)this.mainBillNo, (Object)SerializationUtils.toJsonString(memberInfo));
        boolean isExistOlapData = false;
        QueryRequest queryRequest = new QueryRequest(modelId, datasetId, memberInfo);
        List bgCells = OlapCommService.getInstance().queryList(queryRequest);
        for (BGCell bgCell : bgCells) {
            Object value = bgCell.getValue();
            if (value == null) continue;
            isExistOlapData = true;
            break;
        }
        log.info("splitBill==>isExistOlapData mainBillNo={},intersectionMap={},isExistOlapData={}", new Object[]{this.mainBillNo, SerializationUtils.toJsonString(intersectionMap), isExistOlapData});
        return isExistOlapData;
    }

    private Map<Long, Set<String>> getCentralDimMap(Long modelId, Set<Long> centralSchemaIds, List<Dimension> customDimList) {
        List<Map<String, kd.epm.eb.common.cache.impl.Member>> dimMemberList = CentralRelationService.getInstance().getCentralRelDimMemberInfo(modelId, centralSchemaIds);
        LinkedHashMap<Long, Set<String>> centralDimMap = new LinkedHashMap<Long, Set<String>>(16);
        StringBuilder dimStr = new StringBuilder();
        for (Map<String, kd.epm.eb.common.cache.impl.Member> dimMemberMap : dimMemberList) {
            kd.epm.eb.common.cache.impl.Member entityMember = dimMemberMap.get(SysDimensionEnum.Entity.getNumber());
            kd.epm.eb.common.cache.impl.Member accountObj = dimMemberMap.get(SysDimensionEnum.Account.getNumber());
            if (accountObj != null) {
                kd.epm.eb.common.cache.impl.Member accountMember = accountObj;
                dimStr.append(SysDimensionEnum.Account.getNumber()).append("@").append(accountMember.getNumber()).append("!");
            }
            for (Dimension customDim : customDimList) {
                String dimNumber = customDim.getNumber();
                kd.epm.eb.common.cache.impl.Member customDimObj = dimMemberMap.get(dimNumber);
                if (customDimObj == null) continue;
                kd.epm.eb.common.cache.impl.Member customDimMember = customDimObj;
                dimStr.append(dimNumber).append("@").append(customDimMember.getNumber()).append("!");
            }
            Set dims = centralDimMap.computeIfAbsent(entityMember.getId(), k -> new HashSet(16));
            if (dimStr.length() <= 0) continue;
            dimStr.deleteCharAt(dimStr.length() - 1);
            dims.add(dimStr.toString());
            dimStr.setLength(0);
        }
        return centralDimMap;
    }

    private List<Dimension> getCustomDimList(IModelCacheHelper modelCacheHelper, Long bizModelId) {
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
        return dimensionList.stream().filter(dimension -> !dimension.isPreset()).collect(Collectors.toList());
    }

    private List<Dimension> getCustomDimListByDataset(IModelCacheHelper modelCacheHelper, Long datasetId) {
        List dimensionList = modelCacheHelper.getDimensionList(datasetId);
        return dimensionList.stream().filter(dimension -> !dimension.isPreset()).collect(Collectors.toList());
    }

    private DynamicObject[] createSubApproveBill(DynamicObject mainApproveBill, Map<Long, Set<Long>> centralOrgTempMap, Map<Long, Set<Long>> centralOrgSchemaMap) {
        QFilter qFilter = new QFilter("parentbillid", "=", mainApproveBill.getPkValue());
        DynamicObjectCollection subApproveBillColl = QueryServiceHelper.query((String)"eb_approvebill", (String)"id", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> hisSubApproveBillList = new ArrayList<DynamicObject>(16);
        if (CollectionUtils.isNotEmpty((Collection)subApproveBillColl)) {
            DynamicObject[] subApproveBills;
            Object[] pkIds = subApproveBillColl.stream().map(bill -> bill.getLong("id")).toArray();
            for (DynamicObject subApproveBill : subApproveBills = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"))) {
                hisSubApproveBillList.add(subApproveBill);
            }
        }
        int splitVersion = mainApproveBill.getInt("splitversion");
        String auditNode = mainApproveBill.getString("auditnode");
        AtomicInteger index = new AtomicInteger(hisSubApproveBillList.size());
        ArrayList<DynamicObject> subApproveBillList = new ArrayList<DynamicObject>(centralOrgTempMap.size());
        for (Map.Entry<Long, Set<Long>> entry : centralOrgTempMap.entrySet()) {
            Long centralOrgId = entry.getKey();
            Set<Long> templateIds = entry.getValue();
            boolean isMatch = false;
            for (DynamicObject subApproveBill : hisSubApproveBillList) {
                Long subCentralOrgId = subApproveBill.getLong("centralorg.id");
                String subAuditNode = subApproveBill.getString("auditnode");
                if (!centralOrgId.equals(subCentralOrgId) || !auditNode.equals(subAuditNode)) continue;
                subApproveBill.set("billstatus", (Object)AppBillStatusEnum.STORAGE.getNumber());
                subApproveBill.set("splitversion", (Object)(splitVersion + 1));
                subApproveBillList.add(subApproveBill);
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            index.getAndIncrement();
            DynamicObject newSubApproveBill = this.createCentralBillObj(mainApproveBill, centralOrgId, templateIds, centralOrgSchemaMap.get(centralOrgId), index.get());
            subApproveBillList.add(newSubApproveBill);
        }
        DynamicObject[] subApproveBills = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])subApproveBillList.toArray(new DynamicObject[0]));
        if (subApproveBills != null && subApproveBills.length > 0) {
            OperateOption op = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"eb_approvebill", (Object[])Arrays.stream(subApproveBills).map(bill -> bill.get("id")).toArray(), (OperateOption)op);
            if (operationResult.isSuccess()) {
                log.info("splitBill==>mainBillNo={},subApproveBill submit success, size={}", (Object)this.mainBillNo, (Object)operationResult.getBillCount());
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5b50\u5ba1\u6279\u5355\u63d0\u4ea4\u5931\u8d25: %1", (String)"CentralSplitBillService_1", (String)"epm-eb-business", (Object[])new Object[]{operationResult.getMessage()}));
            }
        }
        mainApproveBill.set("splitversion", (Object)(splitVersion + 1));
        mainApproveBill.set("centralbilltype", (Object)CentralBillType.Main.getNumber());
        mainApproveBill.set("splitbilltype", (Object)CentralBillType.Main.getNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainApproveBill});
        ApproveBillHelper.upSortVal4CentralBill((DynamicObject)mainApproveBill);
        return subApproveBills;
    }

    public DynamicObject createCentralBillObj(DynamicObject mainApproveBill, Long centralOrgId, Set<Long> templateIds, Set<Long> centralOrgSchema, int index) {
        DynamicObject newSubApproveBill = BusinessDataServiceHelper.newDynamicObject((String)"eb_approvebill");
        this.setBillHeadValue(mainApproveBill, newSubApproveBill, centralOrgId, index);
        this.setBillEntryValue(mainApproveBill, newSubApproveBill, templateIds, centralOrgSchema);
        return newSubApproveBill;
    }

    private void setBillEntryValue(DynamicObject mainApproveBill, DynamicObject subApproveBill, Set<Long> templateIds, Set<Long> centralSchemaIds) {
        DynamicObjectCollection entryColl = subApproveBill.getDynamicObjectCollection("entryentity");
        for (Long templateId : templateIds) {
            DynamicObject entry = entryColl.addNew();
            entry.set("tempid", (Object)templateId);
        }
        DynamicObjectCollection bailOrgColl = subApproveBill.getDynamicObjectCollection("entryentity_bailorg");
        DynamicObjectCollection mainBailOrgs = mainApproveBill.getDynamicObjectCollection("entryentity_bailorg");
        for (DynamicObject mainBailOrg : mainBailOrgs) {
            DynamicObject bailOrg = bailOrgColl.addNew();
            bailOrg.set("bail_org", mainBailOrg.get("bail_org.id"));
        }
        DynamicObjectCollection centralSchemaColl = subApproveBill.getDynamicObjectCollection("entryentity_centralschema");
        for (Long centralSchemaId : centralSchemaIds) {
            DynamicObject entry = centralSchemaColl.addNew();
            entry.set("centralschema", (Object)centralSchemaId);
        }
    }

    private void setBillHeadValue(DynamicObject mainApproveBill, DynamicObject subApproveBill, Long centralOrgId, int index) {
        subApproveBill.set("modelid", (Object)mainApproveBill.getLong("modelid.id"));
        subApproveBill.set("eborgid", (Object)mainApproveBill.getLong("eborgid.id"));
        subApproveBill.set("createrid", (Object)mainApproveBill.getLong("createrid.id"));
        subApproveBill.set("createorgid", (Object)mainApproveBill.getLong("createorgid.id"));
        subApproveBill.set("department", (Object)mainApproveBill.getLong("department.id"));
        subApproveBill.set("position", (Object)mainApproveBill.getString("position"));
        subApproveBill.set("eborgmasterid", (Object)mainApproveBill.getLong("eborgmasterid"));
        subApproveBill.set("source", (Object)mainApproveBill.getLong("source_id"));
        subApproveBill.set("bizmodelid", (Object)mainApproveBill.getLong("bizmodelid.id"));
        subApproveBill.set("committype", (Object)mainApproveBill.getString("committype"));
        subApproveBill.set("selectorg", (Object)mainApproveBill.getString("selectorg"));
        subApproveBill.set("approvaltype", (Object)mainApproveBill.getLong("approvaltype.id"));
        subApproveBill.set("approvetype", (Object)mainApproveBill.getLong("approvetype.id"));
        subApproveBill.set("approvetypeversion", (Object)mainApproveBill.getLong("approvetypeversion"));
        subApproveBill.set("orgviewid", (Object)mainApproveBill.getLong("orgviewid.id"));
        subApproveBill.set("rptprocesstype", (Object)mainApproveBill.getString("rptprocesstype"));
        subApproveBill.set("dim_period", (Object)mainApproveBill.getLong("dim_period.id"));
        subApproveBill.set("dim_datatype", (Object)mainApproveBill.getLong("dim_datatype.id"));
        subApproveBill.set("dim_version", (Object)mainApproveBill.getLong("dim_version.id"));
        subApproveBill.set("billtype", (Object)"2");
        subApproveBill.set("billstatus", (Object)AppBillStatusEnum.STORAGE.getNumber());
        subApproveBill.set("createdate", (Object)TimeServiceHelper.now());
        subApproveBill.set("centralorg", (Object)centralOrgId);
        subApproveBill.set("centralbailorg", (Object)this.getBailOrgId(mainApproveBill.getLong("modelid.id"), centralOrgId, mainApproveBill.getLong("orgviewid.id")));
        subApproveBill.set("auditnode", (Object)mainApproveBill.getString("auditnode"));
        subApproveBill.set("parentbillid", mainApproveBill.getPkValue());
        subApproveBill.set("centralbilltype", (Object)CentralBillType.Child.getNumber());
        subApproveBill.set("audittype", (Object)AuditTypeEnum.WORKFLOW.getType());
        String number = this.mainBillNo + "-" + (index < 10 ? "00" + index : "0" + index);
        subApproveBill.set("billno", (Object)number);
        subApproveBill.set("splitversion", (Object)(mainApproveBill.getInt("splitversion") + 1));
        subApproveBill.set("splitbilltype", (Object)CentralBillType.Child.getNumber());
    }

    private void saveCentralDimSnapshot(DynamicObject[] subApproveBills, Set<Long> centralSchemaIds) {
        HashSet<Long> subApproveBillIds = new HashSet<Long>(subApproveBills.length);
        for (DynamicObject subApproveBill : subApproveBills) {
            Long billId = subApproveBill.getLong("id");
            subApproveBillIds.add(billId);
        }
        CentralRelationShotService.getInstance().saveCentralRelationShot(centralSchemaIds, subApproveBillIds);
    }

    private void updateCentralAuditPass(DynamicObject mainApproveBill) {
        mainApproveBill.set("centralbilltype", (Object)CentralBillType.Normal.getNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainApproveBill});
    }

    private Long getBailOrgId(Long modelId, Long centralOrgId, Long orgViewId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        kd.epm.eb.common.cache.impl.Member centralOrg = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, centralOrgId);
        if (centralOrg == null) {
            return 0L;
        }
        Long bailOrgId = 0L;
        String centralOrgNumber = centralOrg.getNumber();
        BailOrgRelation bailOrgRelation = BailOrgService.getInstance().getBailOrgRelation(modelId, centralOrgNumber);
        if (bailOrgRelation != null) {
            bailOrgId = bailOrgRelation.getDefaultBailId();
        }
        return bailOrgId;
    }

    private boolean isCentralSplit(Long approveTypeId) {
        DynamicObject approveType = BusinessDataServiceHelper.loadSingleFromCache((Object)approveTypeId, (String)"eb_approvaltypeentity");
        if (approveType == null) {
            return false;
        }
        return approveType.getBoolean("centralsplit");
    }

    private Map<String, Long> getCentralDimViewMap(Long bizModelId) {
        QFilter qFilter = new QFilter("bizmodel", "=", (Object)bizModelId);
        qFilter.and(new QFilter("status", "=", (Object)true));
        DynamicObject centralRelRange = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_centralrelrange", (QFilter[])qFilter.toArray());
        if (centralRelRange == null) {
            return Maps.newHashMap();
        }
        Long rangeId = centralRelRange.getLong("id");
        return CentralRelationService.getInstance().getCentralRangeDimView(rangeId);
    }

    private List<Map<String, Collection<Member>>> getFixTemplateDimMemList(IModelCacheHelper modelCacheHelper, ITemplateModel templateModel, String submitOrgNum) {
        ArrayList<Map<String, Collection<Member>>> dimMemMapList = new ArrayList<Map<String, Collection<Member>>>(16);
        Map<String, Collection<Member>> hideAndPageDimMemMap = this.getTemplateHideAndPageDimMem(templateModel);
        List multiAreaSettings = templateModel.getAreaRanges();
        for (IMultiAreaSetting multiAreaSetting : multiAreaSettings) {
            HashMap<String, Collection<Member>> dimMemMap = new HashMap<String, Collection<Member>>(16);
            dimMemMap.putAll(hideAndPageDimMemMap);
            for (IViewPointDimensionEntry entry : multiAreaSetting.getAreaViewpointmembentry()) {
                String dimNumber = entry.getDimension().getNumber();
                String memNumber = entry.getMember().getNumber();
                Collection members = dimMemMap.computeIfAbsent(dimNumber, value -> new HashSet(1));
                kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension();
                dimension.setNumber(memNumber);
                Member mem = new Member(dimension);
                mem.setNumber(memNumber);
                mem.setRange(RangeEnum.ONLY.getIndex());
                members.add(mem);
            }
            multiAreaSetting.getAreaSheet().iteratorECells(cell -> {
                Object _dimNumber = cell.getUserObject("dimnumber");
                Object _memNumber = cell.getUserObject("number");
                if (_dimNumber != null && _memNumber != null) {
                    String dimNumber = String.valueOf(_dimNumber);
                    String memNumber = String.valueOf(_memNumber);
                    Collection members = dimMemMap.computeIfAbsent(dimNumber, value -> new HashSet(1));
                    kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension();
                    dimension.setNumber(dimNumber);
                    Member mem = new Member(dimension);
                    mem.setNumber(memNumber);
                    mem.setRange(RangeEnum.ONLY.getIndex());
                    members.add(mem);
                }
            });
            this.setAreaFloatDimMem(modelCacheHelper, templateModel.getDimensionView(), submitOrgNum, multiAreaSetting, dimMemMap);
            dimMemMapList.add(dimMemMap);
        }
        return dimMemMapList;
    }

    private void setAreaFloatDimMem(IModelCacheHelper modelCacheHelper, Map<String, Long> dimensionView, String submitOrgNum, IMultiAreaSetting multiAreaSetting, Map<String, Collection<Member>> dimMemMap) {
        if (multiAreaSetting.getFloatOnWhere() != -1) {
            multiAreaSetting.getFloatInfos().forEach(floatInfo -> {
                Collection members;
                String dimNumber;
                RowColPartition rowColPartition = floatInfo.getPartition();
                for (IRowColDimensionEntry entry : rowColPartition.getRowColDimensionEntries()) {
                    dimNumber = entry.getDimension().getNumber();
                    kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension();
                    dimension.setNumber(dimNumber);
                    members = dimMemMap.computeIfAbsent(dimNumber, value -> new HashSet(entry.getMembers().size()));
                    for (IDimensionMember member : entry.getMembers()) {
                        Member mem = new Member(dimension);
                        mem.setNumber(member.getNumber());
                        mem.setRange(member.getScope());
                        members.add(mem);
                    }
                    if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber) || !entry.isFloat()) continue;
                    Long dimViewId = 0L;
                    if (CollectionUtils.isNotEmpty((Map)dimensionView)) {
                        dimViewId = (Long)dimensionView.get(dimNumber);
                    }
                    List submitOrgMembers = modelCacheHelper.getMember(dimNumber, dimViewId, submitOrgNum, RangeEnum.ALL.getIndex());
                    Set orgNumbers = submitOrgMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    Collection entityMembers = (Collection)dimMemMap.get(dimNumber);
                    HashSet<Member> queryOlapMembers = new HashSet<Member>(entityMembers.size());
                    for (Member entityMember : entityMembers) {
                        if (!orgNumbers.contains(entityMember.getNumber())) continue;
                        queryOlapMembers.add(entityMember);
                    }
                    dimMemMap.put(dimNumber, queryOlapMembers);
                }
                for (IRowColDimensionEntry rowColDimensionEntry : floatInfo.getPartition().getRowColDimensionEntries()) {
                    if (rowColDimensionEntry == null || !rowColDimensionEntry.isQuickAddNew() || rowColDimensionEntry.getDimension() == null || !StringUtils.isNotEmpty((CharSequence)rowColDimensionEntry.getDefaultParentNum())) continue;
                    dimNumber = rowColDimensionEntry.getDimension().getNumber();
                    String memNumber = rowColDimensionEntry.getDefaultParentNum();
                    members = dimMemMap.computeIfAbsent(dimNumber, value -> new HashSet(16));
                    kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension();
                    dimension.setNumber(dimNumber);
                    Member mem = new Member(dimension);
                    mem.setNumber(memNumber);
                    mem.setRange(RangeEnum.ONLY.getIndex());
                    members.add(mem);
                }
            });
        }
    }

    private Map<String, Collection<Member>> getTemplateHideAndPageDimMem(ITemplateModel templateModel) {
        HashMap<String, Collection<Member>> dimMemMap = new HashMap<String, Collection<Member>>(16);
        for (IViewPointDimensionEntry entry : templateModel.getViewpointmembentry()) {
            String dimNumber = entry.getDimension().getNumber();
            String memNumber = entry.getMember().getNumber();
            Collection members = dimMemMap.computeIfAbsent(dimNumber, value -> new HashSet(1));
            kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension();
            dimension.setNumber(memNumber);
            Member mem = new Member(dimension);
            mem.setNumber(memNumber);
            mem.setRange(RangeEnum.ONLY.getIndex());
            members.add(mem);
        }
        List pageDimensionEntryList = templateModel.getPagemembentry();
        for (IPageDimensionEntry entry : pageDimensionEntryList) {
            String dimNumber = entry.getDimension().getNumber();
            kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension();
            dimension.setNumber(dimNumber);
            Collection members = dimMemMap.computeIfAbsent(dimNumber, value -> new HashSet(entry.getMembers().size()));
            for (IDimensionMember iDimensionMember : entry.getMembers()) {
                Member mem = new Member(dimension);
                mem.setNumber(iDimensionMember.getNumber());
                mem.setRange(iDimensionMember.getScope());
                members.add(mem);
            }
        }
        return dimMemMap;
    }

    private void syncCustomDimMem(IModelCacheHelper modelCacheHelper, Long datasetId, Map<String, Set<String>> dimMemMap) {
        List dimensionList = modelCacheHelper.getDimensionList(datasetId);
        for (Dimension dimension : dimensionList) {
            String dimNumber = dimension.getNumber();
            Set<String> members = dimMemMap.get(dimNumber);
            if (!SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber) && dimension.isPreset() || !CollectionUtils.isEmpty(members)) continue;
            members = new HashSet<String>(1);
            members.add(dimension.getNoneNumber());
            dimMemMap.put(dimNumber, members);
        }
    }

    private Map<String, Map<String, String>> getVarValueMap(DynamicObject mainApproveBill) {
        Long modelId = mainApproveBill.getLong("modelid.id");
        Long sourceId = mainApproveBill.getLong("source_id");
        String processType = mainApproveBill.getString("rptprocesstype");
        Map varValues = null;
        if (ProcessTypeEnum.TASK.getIndex() == Integer.parseInt(processType)) {
            varValues = ReportVarUtil.getVarValues((Integer)ProcessTypeEnum.TASK.getIndex(), (Long)modelId, (Long)sourceId);
        } else {
            QFilter qFilter = new QFilter("scheme", "=", (Object)sourceId);
            qFilter.and("year", "=", (Object)mainApproveBill.getLong("dim_period.id"));
            qFilter.and("version", "=", (Object)mainApproveBill.getLong("dim_version.id"));
            qFilter.and("datatype", "=", (Object)mainApproveBill.getLong("dim_datatype.id"));
            DynamicObject assign = QueryServiceHelper.queryOne((String)"eb_schemeassign", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (assign != null) {
                varValues = ReportVarUtil.getVarValues((Integer)ProcessTypeEnum.REPORT.getIndex(), (Long)modelId, (Long)assign.getLong("id"));
            }
        }
        return varValues;
    }

    private boolean isFixTemplate(ITemplateModel templateModel, int defaultValue) {
        BgTemplate template = templateModel.getTemplateBaseInfo();
        int templateType = template != null ? template.getTemplatetype() : defaultValue;
        return Integer.parseInt(BgTemplateTypeEnum.EBFIX.getNumber()) == templateType;
    }
}

