/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.epm.eb.common.centralapproval.ApproverRelationEnum;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;

public class GetUsersUtil {
    private static Log log = LogFactory.getLog(GetUsersUtil.class);
    public static final String CON_LOG = "GetUserRelation:";

    public static GetUsersUtil getInstance() {
        return InnerClass.instance;
    }

    private GetUsersUtil() {
    }

    public Set<Long> getUsersByType(Set<Long> userIds, ApproverRelationEnum selType, boolean needLog) {
        this.doLog("getUsersByType:begin do userRelation: ", log, needLog);
        if (userIds == null || userIds.size() == 0) {
            return new HashSet<Long>(16);
        }
        Set<Long> returns = new HashSet<Long>(16);
        switch (selType) {
            case ONESELF: {
                returns = userIds;
                break;
            }
            case DIRECT_SUPERIOR: {
                this.doLog("getUsersByType:begin getSupperUsers." + userIds.toString(), log, needLog);
                returns = this.getSupperUsers(userIds, needLog);
                break;
            }
            case INDIRECT_SUPERIOR: {
                this.doLog("getUsersByType:begin getSecondSupperUsers." + userIds.toString(), log, needLog);
                returns = this.getSecondSupperUsers(userIds, needLog);
                break;
            }
            case SIDE_WAY: {
                this.doLog("getUsersByType:begin getLeverUsers." + userIds.toString(), log, needLog);
                returns = this.getLeverUsers(userIds, needLog);
                break;
            }
            case DIRECT_SUBORDINATES: {
                this.doLog("getUsersByType:begin getLowerUsers." + userIds.toString(), log, needLog);
                returns = this.getLowerUsers(userIds, needLog);
            }
        }
        return returns;
    }

    private Set<Long> getLowerUsersByUser(Set<Long> userIds, boolean needLog) {
        HashSet<Long> returns = new HashSet<Long>(16);
        if (userIds == null || userIds.size() == 0) {
            this.doLog("getLowerUsersByUser : userIds is null or 0.", log, needLog);
            return returns;
        }
        QFBuilder qb = new QFBuilder();
        qb.add("entryentity.superior.id", "in", userIds);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bos_user", (String)"id ", (QFilter[])qb.toArray());
        if (dys == null) {
            this.doLog("getLowerUsersByUser : dys is null." + userIds.toString(), log, needLog);
            return returns;
        }
        for (DynamicObject dy : dys) {
            returns.add(dy.getLong("id"));
        }
        this.doLog("getLowerUsersByUser : returns.size:" + returns.size() + "||" + ((Object)returns).toString(), log, needLog);
        return returns;
    }

    private Set<Long> getLowerUsersDeptByMaster(Set<Long> userIds, boolean needLog) {
        HashSet<Long> returns = new HashSet<Long>(16);
        if (userIds == null || userIds.size() == 0) {
            this.doLog("getLowerUsersDeptByMaster : userIds is null or 0.", log, needLog);
            return returns;
        }
        QFBuilder qb = new QFBuilder();
        qb.add("id", "in", userIds);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,dpt,isincharge,entryentity ", (QFilter[])qb.toArray());
        if (dys == null) {
            this.doLog("getLowerUsersDeptByMaster : dys is null." + userIds.toString(), log, needLog);
            return returns;
        }
        for (DynamicObject dy : dys) {
            DynamicObjectCollection companyInfos = dy.getDynamicObjectCollection("entryentity");
            if (companyInfos == null || companyInfos.size() == 0) {
                this.doLog("getLowerUsersDeptByMaster : companyInfos is null or 0." + userIds.toString(), log, needLog);
                continue;
            }
            for (DynamicObject companyInfo : companyInfos) {
                if (!companyInfo.getBoolean("isincharge") || companyInfo.get("dpt") == null) continue;
                returns.add(companyInfo.getDynamicObject("dpt").getLong("id"));
            }
        }
        this.doLog("getLowerUsersDeptByMaster : returns.size:" + returns.size() + "||" + ((Object)returns).toString(), log, needLog);
        return returns;
    }

    private Set<Long> getLowerUsers(Set<Long> userIds, boolean needLog) {
        Set<Long> returns = new HashSet<Long>(16);
        if (userIds == null || userIds.size() == 0) {
            this.doLog("getLowerUsers : userIds is null or 0.", log, needLog);
            return returns;
        }
        returns = this.getLowerUsersByUser(userIds, needLog);
        Set<Long> masterDepIds = this.getLowerUsersDeptByMaster(userIds, needLog);
        if (masterDepIds.size() > 0) {
            this.doLog("getLowerUsers : begin getUsersByDepts.", log, needLog);
            QFBuilder masterDepQf = new QFBuilder("entryentity.isincharge", "=", (Object)Character.valueOf('0'));
            returns.addAll(this.getUsersByDepts(masterDepIds, masterDepQf, needLog));
        }
        this.doLog("getLowerUsers : returns.size:" + returns.size() + "||" + returns.toString(), log, needLog);
        return returns;
    }

    private Set<Long> getSupperUsers(Set<Long> userIds, boolean needLog) {
        HashSet<Long> returns = new HashSet<Long>(16);
        if (userIds == null || userIds.size() == 0) {
            this.doLog("getSupperUsers: userIds is null or 0.", log, needLog);
            return returns;
        }
        QFBuilder qb = new QFBuilder();
        qb.add("id", "in", userIds);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,dpt,superior,isincharge,entryentity.orgstructure ", (QFilter[])qb.toArray());
        if (dys == null) {
            this.doLog("getSupperUsers: dys is null." + userIds.toString(), log, needLog);
            return returns;
        }
        HashSet<Long> depIds = new HashSet<Long>(16);
        HashSet<Long> depIdsByBase = new HashSet<Long>(16);
        for (DynamicObject dy : dys) {
            DynamicObjectCollection companyInfos = dy.getDynamicObjectCollection("entryentity");
            if (companyInfos == null || companyInfos.size() == 0) {
                this.doLog("getSupperUsers: companyInfos is null or 0." + userIds.toString(), log, needLog);
                continue;
            }
            for (DynamicObject companyInfo : companyInfos) {
                if (companyInfo.get("superior") != null) {
                    returns.add(companyInfo.getDynamicObject("superior").getLong("id"));
                    continue;
                }
                if (companyInfo.get("dpt") != null && !companyInfo.getBoolean("isincharge")) {
                    this.doLog("getSupperUsers: isinCharge:" + companyInfo.get("dpt.number") + "||" + companyInfo.get("dpt.name"), log, needLog);
                    depIds.add(companyInfo.getDynamicObject("dpt").getLong("id"));
                    continue;
                }
                if (companyInfo.get("dpt") != null && companyInfo.getBoolean("isincharge")) {
                    this.doLog("getSupperUsers: begin getSupperDepts." + companyInfo.get("dpt.number") + "||" + companyInfo.get("dpt.name"), log, needLog);
                    depIdsByBase.add(companyInfo.getDynamicObject("dpt").getLong("id"));
                    continue;
                }
                this.doLog("getSupperUsers: no match if condition." + userIds.toString(), log, needLog);
            }
        }
        this.doLog("getSupperUsers: getSupperDeptsByBase:||userIds:" + userIds.toString(), log, needLog);
        Set<Long> superDepIdsByBase = this.getSupperDeptsByBase(depIdsByBase);
        this.doLog("getSupperUsers: superDepIdsByBase.size:" + superDepIdsByBase.size() + "||userIds:" + userIds.toString(), log, needLog);
        this.doLog("getSupperUsers: superDepIdsByBase:" + superDepIdsByBase.toString() + "||userIds:" + userIds.toString(), log, needLog);
        this.doLog("getSupperUsers: depIds.size:" + depIds.size() + "||userIds:" + userIds.toString(), log, needLog);
        this.doLog("getSupperUsers: depIds:" + ((Object)depIds).toString() + "||userIds:" + userIds.toString(), log, needLog);
        depIds.addAll(superDepIdsByBase);
        if (depIds.size() > 0) {
            QFBuilder masterDepQf = new QFBuilder("entryentity.isincharge", "=", (Object)"1");
            returns.addAll(this.getUsersByDepts(depIds, masterDepQf, needLog));
        }
        this.doLog("getSupperUsers:returns.size()" + returns.size() + "||" + ((Object)returns).toString(), log, needLog);
        return returns;
    }

    private Set<Long> getSupperDeptsByBase(Set<Long> depIds) {
        HashSet<Long> returns = new HashSet<Long>();
        if (depIds == null || depIds.size() == 0) {
            return returns;
        }
        Map orgParentMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", new ArrayList<Long>(depIds));
        orgParentMap.values().forEach(e -> returns.add((Long)e));
        return returns;
    }

    private Set<Long> getLeverUsers(Set<Long> userIds, boolean needLog) {
        HashSet<Long> returns = new HashSet<Long>(16);
        if (userIds == null || userIds.size() == 0) {
            return returns;
        }
        QFBuilder qb = new QFBuilder();
        qb.add("id", "in", userIds);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,dpt ", (QFilter[])qb.toArray());
        if (dys == null) {
            return returns;
        }
        HashSet<Long> depIds = new HashSet<Long>(16);
        for (DynamicObject dy : dys) {
            DynamicObjectCollection companyInfos = dy.getDynamicObjectCollection("entryentity");
            if (companyInfos == null || companyInfos.size() == 0) continue;
            for (DynamicObject companyInfo : companyInfos) {
                if (companyInfo.get("dpt") == null) continue;
                depIds.add(companyInfo.getDynamicObject("dpt").getLong("id"));
            }
        }
        return this.getUsersByDepts(depIds, null, needLog);
    }

    private Set<Long> getUsersByDepts(Set<Long> depIds, QFBuilder filterDptMaster, boolean needLog) {
        DynamicObject[] dys;
        HashSet<Long> returns = new HashSet<Long>(16);
        if (depIds == null || depIds.size() == 0) {
            this.doLog("getUsersByDepts: depIds is null or 0.", log, needLog);
            return returns;
        }
        QFBuilder qb = new QFBuilder();
        qb.add("entryentity.dpt.id", "in", depIds);
        if (filterDptMaster != null) {
            qb.and(filterDptMaster);
        }
        if ((dys = BusinessDataServiceHelper.load((String)"bos_user", (String)"id ", (QFilter[])qb.toArray())) == null) {
            this.doLog("getUsersByDepts: dys is null." + depIds.toString(), log, needLog);
            return returns;
        }
        for (DynamicObject dy : dys) {
            returns.add(dy.getLong("id"));
        }
        this.doLog("getUsersByDepts: returns.size:" + returns.size() + "||" + ((Object)returns).toString(), log, needLog);
        return returns;
    }

    public void doLog(String info, Log log, boolean isLog) {
        if (isLog) {
            log.info(CON_LOG + info);
        }
    }

    private Set<Long> getSecondSupperUsers(Set<Long> userIds, boolean needLog) {
        Set<Long> returns = new HashSet<Long>(16);
        Set<Object> directUsers = new HashSet(16);
        if (userIds == null || userIds.size() == 0) {
            this.doLog("getSecondSupperUsers : userIds is null or 0.", log, needLog);
            return returns;
        }
        this.doLog("getSecondSupperUsers : begin getSupperUsers one.", log, needLog);
        directUsers = this.getSupperUsers(userIds, needLog);
        this.doLog("getSecondSupperUsers : one.size:" + directUsers.toString() + "||" + directUsers.toString(), log, needLog);
        this.doLog("getSecondSupperUsers : begin getSupperUsers two.", log, needLog);
        returns = this.getSupperUsers(directUsers, needLog);
        this.doLog("getSecondSupperUsers : two.size:" + returns.toString() + "||" + returns.toString(), log, needLog);
        return returns;
    }

    private static class InnerClass {
        private static GetUsersUtil instance = new GetUsersUtil();

        private InnerClass() {
        }
    }
}

