/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.centralapproval.AppBillDataFilterService;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApprovePlanUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveAdjDimTypeEnum;
import kd.epm.eb.common.centralapproval.ApproveAdjustDimEntry;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApprovePlan;
import kd.epm.eb.common.centralapproval.CentralAppBillApproveInfo;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class ShowInfoCreateUtil {
    private static final Log log = LogFactory.getLog(ShowInfoCreateUtil.class);
    private static final ShowInfoCreateUtil instance = new ShowInfoCreateUtil();

    public void addLog(String logKey, Object logValue) {
        Set logSignsFromForm = LogSignHelper.getLogSignByGropNum((String)"ShowInfoCreateUtil");
        if (logSignsFromForm.contains(logKey)) {
            CommonServiceHelper.handleLog((Log)log, (String)logKey, (String)SerializationUtils.toJsonString((Object)logValue));
        }
    }

    public static ShowInfoCreateUtil getInstance() {
        return instance;
    }

    public CentralAppShowInfo createShowInfo(ApproveBill approveBill) {
        CentralAppShowInfo showInfo = new CentralAppShowInfo();
        HashSet<String> reportBillNos = new HashSet<String>(16);
        HashSet<Long> templates = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        Long model = approveBill.getModel();
        AppBillDataFilterService.getInstance().getEntryInfos(approveBill.getApproveBillEntries(), reportBillNos, templates, orgIds, model);
        showInfo.setEntitySet(orgIds);
        showInfo.setTemplates(templates);
        showInfo.setReportBillNos(reportBillNos);
        String billNo = approveBill.getBillNo();
        showInfo.setCentralBillNo(billNo);
        showInfo.setCentralAppChain(CentralAppBillService.getInstance().getCentralAppChainByBills(billNo, model));
        showInfo.setRefedBillNos(CentralAppBillService.getInstance().getRefedBillNums(billNo, model));
        Long reportScheme = approveBill.getReportScheme();
        Long bizModel = AppBillDataFilterService.getInstance().getBizModelFromScheme(reportScheme);
        showInfo.setBizModel(bizModel);
        this.initApproveInfo(approveBill, showInfo);
        return showInfo;
    }

    public void initApproveInfo(ApproveBill approveBill, CentralAppShowInfo showInfo) {
        CentralAppBillApproveInfo approveInfo = new CentralAppBillApproveInfo();
        approveInfo.setCreator(approveBill.getCreator());
        approveInfo.setCreateDate(approveBill.getCreateDate());
        approveInfo.setModifier(approveBill.getModifier());
        approveInfo.setModifyDate(approveBill.getModifyDate());
        approveInfo.setApprover(approveBill.getAuditor());
        approveInfo.setApproveDate(approveBill.getAuditDate());
        showInfo.setApproveInfo(approveInfo);
    }

    public CentralAppShowInfo createShowInfo(ApproveBill approveBill, Set<String> planNumberSet, Set<Long> templates, DimMembPermType permType) {
        CentralAppShowInfo showInfo = new CentralAppShowInfo();
        this.initBaseShowInfo(showInfo, approveBill, templates);
        this.filterData(showInfo, approveBill, planNumberSet, permType);
        this.initShowInfoBaseData(showInfo, approveBill);
        if (DimMembPermType.WRITE == permType) {
            showInfo.setBillShowStatus("inApprove");
        } else {
            showInfo.setBillShowStatus("notApprove");
        }
        return showInfo;
    }

    public void initShowInfoBaseData(CentralAppShowInfo showInfo, ApproveBill approveBill) {
        DynamicObject data;
        showInfo.setBillId(approveBill.getId());
        String billNo = approveBill.getBillNo();
        showInfo.setCentralBillNo(billNo);
        showInfo.setStatus(approveBill.getBillStatus().getNumber());
        Long modelId = approveBill.getModel();
        Long parentId = approveBill.getParentId();
        if (parentId != null && parentId != 0L && (data = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)"eb_centralappbill")) != null) {
            billNo = data.getString("billno");
        }
        showInfo.setCentralAppChain(CentralAppBillService.getInstance().getCentralAppChainByBills(billNo, modelId));
        Set<String> refedBillNums = CentralAppBillService.getInstance().getRefedBillNums(billNo, modelId);
        refedBillNums.add(approveBill.getBillNo());
        if (approveBill.isMainbill()) {
            List<ApproveBill> subApproveBillList = ApproveBillUtil.getInstance().getApproveBills(new QFilter("parentid", "=", (Object)IDUtils.toLong((Object)approveBill.getId())));
            subApproveBillList.forEach(subApproveBill -> refedBillNums.add(subApproveBill.getBillNo()));
        }
        showInfo.setRefedBillNos(refedBillNums);
    }

    private void filterData(CentralAppShowInfo showInfo, ApproveBill approveBill, Set<String> planNumberSet, DimMembPermType permType) {
        this.filterDataByPlan(showInfo, approveBill, planNumberSet);
        this.addLog("filterDataByPlan:showInfo", showInfo);
        this.filterDataByPerm(showInfo, approveBill.getModel(), permType);
        this.addLog("filterDataByPerm:showInfo", showInfo);
    }

    private void filterDataByPlan(CentralAppShowInfo showInfo, ApproveBill approveBill, Set<String> planNumberSet) {
        Long model = approveBill.getModel();
        List<ApprovePlan> plans = ApprovePlanUtil.getInstance().getApprovePlansByNumber(planNumberSet, model);
        this.addLog("filterDataByPlan:plans", plans);
        this.filterDataByPlan(showInfo, approveBill, plans);
    }

    public void filterDataByPlan(CentralAppShowInfo showInfo, ApproveBill approveBill, List<ApprovePlan> plans) {
        HashMap appDimMemLevel = new HashMap(16);
        Long model = approveBill.getModel();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        Map views = modelCacheHelper.getViewsByBusModel(showInfo.getBizModel());
        AppBillDataFilterService.getInstance().filterByPlans(approveBill, plans, showInfo);
        Set curPlans = showInfo.getCurPlans();
        plans.forEach(e -> {
            if (curPlans.contains(e.getNumber())) {
                this.merge(approveBill, appDimMemLevel, e.getAppDimMemLevel(), modelCacheHelper, views);
            }
        });
        showInfo.setAppDimMemLevel(appDimMemLevel);
    }

    public Map<String, Set<Long>> getAppDimMemLevel(CentralAppShowInfo showInfo, ApproveBill approveBill, List<ApprovePlan> plans) {
        HashMap<String, Set<Long>> appDimMemLevel = new HashMap<String, Set<Long>>(16);
        Long model = approveBill.getModel();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        Map views = modelCacheHelper.getViewsByBusModel(showInfo.getBizModel());
        plans.forEach(e -> this.merge(approveBill, appDimMemLevel, e.getAppDimMemLevel(), modelCacheHelper, views));
        return appDimMemLevel;
    }

    private void merge(ApproveBill approveBill, Map<String, Set<Long>> appDimMemLevel, List<ApproveAdjustDimEntry> dimMemLevels, IModelCacheHelper modelCacheHelper, Map<String, Long> views) {
        for (ApproveAdjustDimEntry dimMemLevel : dimMemLevels) {
            String dimNumber = dimMemLevel.getDimNumber();
            Long view = views.get(dimNumber);
            Set appMembers = appDimMemLevel.computeIfAbsent(dimNumber, k -> new HashSet(16));
            ApproveAdjDimTypeEnum.RangeTypeEnum type = dimMemLevel.getType();
            if (ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_MEMBER == type) {
                Set members = dimMemLevel.getMembers();
                appMembers.addAll(members);
                continue;
            }
            String level = dimMemLevel.getLevel();
            ApproveAdjDimTypeEnum dimType = ApproveAdjDimTypeEnum.getTypeByDimNumber((String)dimNumber);
            if (ApproveAdjDimTypeEnum.TYPE_TWO == dimType) {
                String entityField = dimMemLevel.getEntityField();
                ApproveAdjDimTypeEnum.TypeTwoLevelEnum range = ApproveAdjDimTypeEnum.TypeTwoLevelEnum.getLevelByValue((String)level);
                if (range == null) continue;
                Set<Long> dimMembers = this.getEntityMembersRange(approveBill, entityField, range, view, modelCacheHelper);
                appMembers.addAll(dimMembers);
                continue;
            }
            int levelIndex = Integer.parseInt(level);
            List dimMembers = modelCacheHelper.getMembers(view, dimNumber);
            if (dimMembers == null) continue;
            Set members = null;
            members = levelIndex == -1 ? dimMembers.stream().filter(Member::isLeaf).map(BaseCache::getId).collect(Collectors.toSet()) : dimMembers.stream().filter(e -> levelIndex <= e.getLevel()).map(BaseCache::getId).collect(Collectors.toSet());
            appMembers.addAll(members);
        }
    }

    private Set<Long> getEntityMembersRange(ApproveBill approveBill, String entityField, ApproveAdjDimTypeEnum.TypeTwoLevelEnum range, Long view, IModelCacheHelper modelCacheHelper) {
        Set<Long> dimMembers = new HashSet<Long>(16);
        if (StringUtils.isEmpty((String)entityField)) {
            return dimMembers;
        }
        Set<Long> entities = this.getEntitiesInApproveBill(approveBill, entityField);
        if (ApproveAdjDimTypeEnum.TypeTwoLevelEnum.THREE == range) {
            dimMembers = entities;
        } else if ("entity".equals(entityField)) {
            if (ApproveAdjDimTypeEnum.TypeTwoLevelEnum.FOUR == range) {
                dimMembers = entities;
            }
        } else {
            String number = SysDimensionEnum.Entity.getNumber();
            HashSet dimMembers_tmp = new HashSet(16);
            if (ApproveAdjDimTypeEnum.TypeTwoLevelEnum.TWO == range) {
                entities.forEach(e -> {
                    Member member = modelCacheHelper.getMember(number, view, e);
                    if (member != null) {
                        List children = member.getChildren();
                        children.forEach(h -> {
                            List children_second = h.getChildren();
                            if (children_second != null) {
                                children_second.forEach(k -> dimMembers_tmp.add(k.getId()));
                            }
                        });
                    }
                });
            } else {
                int rangeIndex = ApproveAdjDimTypeEnum.TypeTwoLevelEnum.ONE == range ? RangeEnum.DIRECTSUB_EXCLUDE.getIndex() : RangeEnum.ALL_DETAIL_INCLUDE.getIndex();
                entities.forEach(e -> {
                    List memberSort;
                    Member member = modelCacheHelper.getMember(number, view, e);
                    if (member != null && (memberSort = modelCacheHelper.getMemberSort(number, view, member.getNumber(), rangeIndex)) != null) {
                        Set members = memberSort.stream().map(BaseCache::getId).collect(Collectors.toSet());
                        dimMembers_tmp.addAll(members);
                    }
                });
            }
            dimMembers.addAll(dimMembers_tmp);
        }
        return dimMembers;
    }

    private Set<Long> getEntitiesInApproveBill(ApproveBill approveBill, String entityField) {
        ApproveBill approveBillTwo;
        HashSet<Long> entities = new HashSet<Long>(16);
        List approveBillEntries = approveBill.getApproveBillEntries();
        if (approveBill.getParentId() != null && approveBill.getParentId() > 0L && (approveBillTwo = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)approveBill.getParentId()))) != null) {
            approveBillEntries = approveBillTwo.getApproveBillEntries();
        }
        switch (entityField) {
            case "entity": {
                if (approveBillEntries == null) break;
                approveBillEntries.forEach(e -> entities.add(e.getEntity()));
                break;
            }
            case "centralentity": {
                if (approveBillEntries == null) break;
                approveBillEntries.forEach(e -> entities.add(e.getCentralEntity()));
                break;
            }
            case "reportentity": {
                entities.add(approveBill.getReportEntity());
                break;
            }
            default: {
                entities.addAll(ApprovePlanUtil.getInstance().getOtherBaseDataFieldInBill(entityField, approveBill));
            }
        }
        return entities;
    }

    public void filterDataByPerm(CentralAppShowInfo showInfo, Long modelId, DimMembPermType permType) {
        Set entitySet = showInfo.getEntitySet();
        Long bizModel = showInfo.getBizModel();
        Long userId = UserUtils.getUserId();
        if (!CentralAppBillService.getInstance().isModelAdmin(modelId)) {
            Set<Long> dimMemInPerm = AppBillDataFilterService.getInstance().getDimMemInPerm(SysDimensionEnum.Entity.getNumber(), Collections.singleton(bizModel), modelId, permType, userId);
            this.addLog("filterDataByPerm:getDimMemInPerm", dimMemInPerm);
            entitySet.retainAll(dimMemInPerm);
        }
        this.addLog("filterDataByPerm:entitySet", entitySet);
        Set<Long> accountInPerm = AppBillDataFilterService.getInstance().getAccountInPerm(modelId, bizModel, permType, userId);
        this.addLog("filterDataByPerm:accountInPerm", accountInPerm);
        Set accountSet = showInfo.getAccountSet();
        this.addLog("filterDataByPerm:accountSet", accountSet);
        if (accountSet != null) {
            accountInPerm.retainAll(accountSet);
        }
        showInfo.setAccountSet(accountInPerm);
    }

    public void initBaseShowInfo(CentralAppShowInfo showInfo, ApproveBill approveBill, Set<Long> templates) {
        this.getEntryInfos(showInfo, approveBill, templates);
        Long reportScheme = approveBill.getReportScheme();
        Long bizModel = AppBillDataFilterService.getInstance().getBizModelFromScheme(reportScheme);
        showInfo.setBizModel(bizModel);
    }

    private void getEntryInfos(CentralAppShowInfo showInfo, ApproveBill approveBill, Set<Long> templates) {
        ApproveBill parentbill;
        HashSet<String> reportBillNos = new HashSet<String>(16);
        LinkedHashSet<Long> templateIds = new LinkedHashSet<Long>(16);
        HashSet<Long> orgSet = new HashSet<Long>(16);
        Long parentId = approveBill.getParentId();
        if (parentId != null && parentId != 0L && (parentbill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)parentId))) != null) {
            approveBill = parentbill;
        }
        AppBillDataFilterService.getInstance().getEntryInfos(approveBill.getApproveBillEntries(), reportBillNos, templateIds, orgSet, approveBill.getModel());
        reportBillNos.remove("0");
        showInfo.setReportBillNos(reportBillNos);
        if (templates != null) {
            templateIds.retainAll(templates);
        }
        showInfo.setTemplates(templateIds);
        showInfo.setEntitySet(orgSet);
    }
}

