/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralizedcontrol.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.centralizedcontrol.constants.ImportHeaderConstants;
import kd.epm.eb.business.centralizedcontrol.context.CentralizedImportContext;
import kd.epm.eb.business.centralizedcontrol.context.ContextParams;
import kd.epm.eb.business.centralizedcontrol.entity.DimInfoEntity;
import kd.epm.eb.business.centralizedcontrol.service.impl.CentralizedFileServiceImpl;
import kd.epm.eb.business.control.domain.BgmdControlParam;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.central.CentralizedServiceImpl;
import kd.epm.eb.common.central.ContralCell;
import kd.epm.eb.common.central.ContralVO;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.pojo.DimMembPermTreeNode;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class CetralizedFileServiceBase {
    private static final Log log = LogFactory.getLog(CetralizedFileServiceBase.class);
    private static final CentralizedServiceImpl centralizedService = CentralizedServiceImpl.getInstance();

    public void importData(List<XSSFWorkbook> xssfWorkbooks, IFormView view) {
        for (XSSFWorkbook xssfWorkbook : xssfWorkbooks) {
            try {
                this.checkExcel(xssfWorkbook);
                List<ContralVO> saveData = this.parseXssfWorkBook(xssfWorkbook);
                this.checkExcelData(saveData);
                this.saveImportData(saveData);
                if (view.getParentView() != null) {
                    view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"CentralizedFileServiceImpl_13", (String)"epm-eb-business", (Object[])new Object[0]));
                } else {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"CentralizedFileServiceImpl_13", (String)"epm-eb-business", (Object[])new Object[0]));
                }
                view.close();
            }
            catch (KDBizException exception) {
                log.error((Throwable)exception);
                view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"CentralizedFileServiceImpl_9", (String)"epm-eb-business", (Object[])new Object[0]));
                this.downloadErrorInfos(xssfWorkbook, view);
            }
            catch (Exception exp) {
                log.error((Throwable)exp);
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0b\u8f7d\u6b63\u786e\u6a21\u677f\u3002", (String)"CentralizedFileServiceImpl_38", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
    }

    public void createDimRangeSheet(XSSFWorkbook excelBook, IPageCache pageCache, long modelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        boolean modelByEB = modelCacheHelper.getModelobj().isModelByEB();
        boolean bgmdModel = ModelServiceHelper.isBGMDModel((Long)modelId);
        String sheetName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458", (String)"CentralizedFileServiceImpl_58", (String)"epm-eb-business", (Object[])new Object[0]);
        if (modelByEB) {
            Map<String, DimInfoEntity> allDimInfo = this.getAllDimInfo(pageCache, modelId);
            this.createDimRangeSheet(excelBook, allDimInfo, sheetName, bgmdModel, null);
        } else {
            String controlParam = pageCache.get("controlparam");
            if (bgmdModel && StringUtils.isNotEmpty((String)controlParam)) {
                Map controlParamMap = (Map)SerializationUtils.deSerializeFromBase64((String)controlParam);
                List<String> businessModelNumbers = controlParamMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
                String[] businessModelNumberArray = businessModelNumbers.toArray(new String[0]);
                FileImportUtils fileImportUtils = FileImportUtils.getInstance();
                XSSFSheet xssfSheet = excelBook.getSheetAt(0);
                fileImportUtils.setColumnFormatAsCombo((Sheet)xssfSheet, 2, businessModelNumberArray);
            }
            Map<String, Map<String, DimInfoEntity>> allDimInfoByControlDim = this.getAllDimInfoByControlDim(pageCache, modelId);
            List businessModelIds = allDimInfoByControlDim.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", (Object)IDUtils.toLongs(businessModelIds));
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_businessmodel", (QFilter[])qFilter.toArray());
            for (Map.Entry<String, Map<String, DimInfoEntity>> entry : allDimInfoByControlDim.entrySet()) {
                String businessModelId = entry.getKey();
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectMap.get(IDUtils.toLong((Object)businessModelId));
                if (bgmdModel) {
                    sheetName = ResManager.loadResFormat((String)"%1\u4e1a\u52a1\u6a21\u578b\u7ef4\u5ea6\u6210\u5458", (String)"CentralizedFileServiceImpl_59", (String)"epm-eb-business", (Object[])new Object[]{dynamicObject.getString("name")});
                }
                Map<String, DimInfoEntity> dimInfoEntityMap = entry.getValue();
                this.createDimRangeSheet(excelBook, dimInfoEntityMap, sheetName, bgmdModel, dynamicObject);
            }
        }
    }

    private void createDimRangeSheet(XSSFWorkbook excelBook, Map<String, DimInfoEntity> allDimInfo, String sheetName, boolean bgmdModel, DynamicObject businessModel) {
        XSSFRow row;
        if (allDimInfo == null || allDimInfo.size() == 0) {
            return;
        }
        XSSFSheet dimRangeSheet = excelBook.createSheet(sheetName);
        int columnIndex = 0;
        for (DimInfoEntity dimEntity : allDimInfo.values()) {
            int rowIndex = 0;
            if (bgmdModel) {
                rowIndex = 3;
            }
            int outputCol = columnIndex * 3 + 1;
            XSSFRow row2 = this.getRow(dimRangeSheet, rowIndex++);
            XSSFCell cellNumber = row2.createCell(outputCol);
            this.setCellTypeColor(excelBook, (Cell)cellNumber, IndexedColors.RED.index, null);
            this.setCellStringValue((Cell)cellNumber, ResManager.loadKDString((String)"\u7f16\u7801", (String)"CentralizedFileServiceImpl_14", (String)"epm-eb-business", (Object[])new Object[0]));
            XSSFCell cellName = row2.createCell(outputCol + 1);
            this.setCellTypeColor(excelBook, (Cell)cellName, IndexedColors.RED.index, null);
            this.setCellStringValue((Cell)cellName, ResManager.loadKDString((String)"\u540d\u79f0", (String)"CentralizedFileServiceImpl_15", (String)"epm-eb-business", (Object[])new Object[0]));
            row2 = this.getRow(dimRangeSheet, rowIndex++);
            this.setCellStringValue((Cell)row2.createCell(outputCol), dimEntity.getNumber());
            this.setCellStringValue((Cell)row2.createCell(outputCol + 1), dimEntity.getName());
            for (DimInfoEntity member : dimEntity.getMembers().values()) {
                row2 = this.getRow(dimRangeSheet, rowIndex);
                this.setCellStringValue((Cell)row2.createCell(outputCol), member.getNumber());
                this.setCellStringValue((Cell)row2.createCell(outputCol + 1), member.getName());
                ++rowIndex;
            }
            ++columnIndex;
        }
        int rowIndex = 0;
        if (bgmdModel && businessModel != null) {
            row = this.getRow(dimRangeSheet, rowIndex++);
            String businessModelNameTitle = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u540d\u79f0", (String)"CentralizedFileServiceImpl_60", (String)"epm-eb-business", (Object[])new Object[0]);
            this.setCellStringValue((Cell)row.createCell(0), businessModelNameTitle);
            String businessModelNumberTitle = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801", (String)"CentralizedFileServiceImpl_61", (String)"epm-eb-business", (Object[])new Object[0]);
            this.setCellStringValue((Cell)row.createCell(1), businessModelNumberTitle);
            XSSFRow row2 = this.getRow(dimRangeSheet, rowIndex++);
            this.setCellStringValue((Cell)row2.createCell(0), businessModel.getString("name"));
            this.setCellStringValue((Cell)row2.createCell(1), businessModel.getString("number"));
        }
        int n = ++rowIndex;
        row = this.getRow(dimRangeSheet, n);
        String title = ResManager.loadKDString((String)"\u7ef4\u5ea6\u8303\u56f4\u5bf9\u7167\u8868", (String)"CentralizedFileServiceImpl_11", (String)"epm-eb-business", (Object[])new Object[0]);
        this.setCellStringValue((Cell)row.createCell(0), title);
        dimRangeSheet.setColumnWidth(0, title.getBytes().length * 256);
        this.setCellStringValue(this.getCell((Row)this.getRow(dimRangeSheet, ++rowIndex), 0), ResManager.loadKDString((String)"(\u5df2\u8fc7\u6ee4\u65e0\u6743\u6210\u5458)", (String)"CentralizedFileServiceImpl_12", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    public void setCellTypeColor(XSSFWorkbook excelBook, Cell cell, Short fontColor, Short backgroundColor) {
        XSSFCellStyle cellStyle = excelBook.createCellStyle();
        if (fontColor != null) {
            XSSFFont font = excelBook.createFont();
            font.setColor(fontColor.shortValue());
            cellStyle.setFont((Font)font);
        }
        if (backgroundColor != null) {
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setFillForegroundColor(backgroundColor.shortValue());
        }
        cell.setCellStyle((CellStyle)cellStyle);
    }

    public Map<String, DimInfoEntity> getAllDimInfo(IPageCache pageCache, long modelId) {
        String allDimInfo = pageCache.get("dimInfo");
        if (allDimInfo != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)allDimInfo);
        }
        DynamicObjectCollection query = this.getDimensionByModelId(modelId);
        if (query == null || query.isEmpty()) {
            return null;
        }
        Map<String, DimInfoEntity> dimInfo = this.getDimInfoByBusinessModel(modelId, query, 0L);
        pageCache.put("dimInfo", SerializationUtils.serializeToBase64(dimInfo));
        return dimInfo;
    }

    public Map<String, Map<String, DimInfoEntity>> getAllDimInfoByControlDim(IPageCache pageCache, long modelId) {
        String allDimInfo = pageCache.get("dimInfoByControlDim");
        if (allDimInfo != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)allDimInfo);
        }
        DynamicObjectCollection query = this.getDimensionByModelId(modelId);
        if (query == null || query.isEmpty()) {
            return null;
        }
        DynamicObjectCollection queryByControl = new DynamicObjectCollection();
        String controlParam = pageCache.get("controlparam");
        if (StringUtils.isNotEmpty((String)controlParam)) {
            Map controlParamMap = (Map)SerializationUtils.deSerializeFromBase64((String)controlParam);
            LinkedHashMap<String, Map<String, DimInfoEntity>> allDimInfoBybusinessModel = new LinkedHashMap<String, Map<String, DimInfoEntity>>(controlParamMap.size());
            for (Map.Entry paramEntry : controlParamMap.entrySet()) {
                BgmdControlParam bgmdControlParam = (BgmdControlParam)paramEntry.getValue();
                List<Long> controlDimension = bgmdControlParam.getControlDimension();
                long businessModelId = bgmdControlParam.getBusinessmodelid();
                for (DynamicObject dynamicObject : query) {
                    if (!SysDimensionEnum.Entity.getNumber().equals(dynamicObject.getString("number")) && !SysDimensionEnum.Account.getNumber().equals(dynamicObject.getString("number")) && (!"epm_userdefinedmembertree".equals(dynamicObject.getString("membermodel")) || !controlDimension.contains(dynamicObject.getLong("id")))) continue;
                    queryByControl.add((Object)dynamicObject);
                }
                Map<String, DimInfoEntity> dimInfo = this.getDimInfoByBusinessModel(modelId, queryByControl, businessModelId);
                allDimInfoBybusinessModel.put(IDUtils.toString((Object)businessModelId), dimInfo);
            }
            pageCache.put("dimInfoByControlDim", SerializationUtils.serializeToBase64(allDimInfoBybusinessModel));
            return allDimInfoBybusinessModel;
        }
        return null;
    }

    @NotNull
    private Map<String, DimInfoEntity> getDimInfoByBusinessModel(long modelId, DynamicObjectCollection query, long businessModelId) {
        LinkedHashMap<String, DimInfoEntity> dimInfo = new LinkedHashMap<String, DimInfoEntity>(16);
        DimInfoEntity dim = null;
        for (DynamicObject object : query) {
            String number = object.getString("number");
            dim = new DimInfoEntity(object.getString("id"), number, object.getString("name"), object.getString("membermodel"));
            dimInfo.put(number, dim);
        }
        Long userId = UserUtils.getUserId();
        for (Map.Entry entry : dimInfo.entrySet()) {
            List children;
            HashMap<String, DimInfoEntity> dimMembers = new HashMap<String, DimInfoEntity>(16);
            DimInfoEntity dimEntity = (DimInfoEntity)entry.getValue();
            dimEntity.setMembers(dimMembers);
            DimMembPermTreeNode permTree = DimMembPermUtil.getMembTreeNodeWithDataPerm((Long)modelId, (Long)businessModelId, (Long)userId, (String)dimEntity.getNumber(), null);
            if (permTree == null || (children = permTree.getChildren()).size() <= 0) continue;
            for (DimMembPermTreeNode child : children) {
                this.prasePermTree(dimMembers, child);
            }
        }
        return dimInfo;
    }

    private DynamicObjectCollection getDimensionByModelId(long modelId) {
        List<String> dimNumbers = Arrays.asList("Entity", "Account");
        QFilter qfNumbers = new QFilter("number", "in", dimNumbers);
        qfNumbers.or(new QFilter("issysdimension", "=", (Object)Boolean.FALSE));
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        QFilter[] qFilters = new QFilter[]{qfModel, qfNumbers};
        String selectFileds = "id,number,name,membermodel";
        return QueryServiceHelper.query((String)"epm_dimension", (String)selectFileds, (QFilter[])qFilters, (String)"dseq");
    }

    public void prasePermTree(Map<String, DimInfoEntity> dimMembers, DimMembPermTreeNode child) {
        List children = child.getChildren();
        if (children.size() > 0) {
            for (DimMembPermTreeNode child1 : children) {
                this.prasePermTree(dimMembers, child1);
            }
        } else {
            dimMembers.put(child.getMembNumber(), new DimInfoEntity(child.getMembId().toString(), child.getMembNumber(), child.getMembName(), null));
        }
    }

    public List<ContralVO> parseXssfWorkBook(XSSFWorkbook xssfWorkbook) {
        ArrayList<ContralVO> saveData = new ArrayList<ContralVO>(16);
        XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
        ContralVO contralVO = null;
        for (int i = ImportHeaderConstants.DATA_ROW_INDEX.intValue(); i <= sheet.getLastRowNum(); ++i) {
            XSSFRow row = this.getRow(sheet, i);
            if (this.isEmptyRow((Row)row) || (contralVO = this.createContralVoBySheet((Row)row, contralVO)) == null) continue;
            this.setContralVoBySheet((Row)row, contralVO);
            if (saveData.contains(contralVO)) continue;
            saveData.add(contralVO);
        }
        return saveData;
    }

    public ContralVO createContralVoBySheet(Row row, ContralVO contralVO) {
        int rowNum = row.getRowNum();
        Set<String> numberSet = CentralizedImportContext.get().getNumberSet();
        List<String> numberList = CentralizedImportContext.get().getNumberList();
        Map<String, List<ContralCell>> entityFromCache = CentralizedImportContext.get().getEntityFromCache();
        ContextParams contextParams = CentralizedImportContext.get();
        long modelId = contextParams.getModelId();
        boolean bgmd = contextParams.isBgmd();
        boolean newEb = contextParams.isNewEb();
        Map<String, BgmdControlParam> controlDims = contextParams.getControlDims();
        int columnIndex = 0;
        String number = this.getCellStringValue(this.getCell(row, columnIndex));
        if (StringUtils.isNotEmpty((String)number)) {
            String errorInfo;
            entityFromCache.clear();
            contralVO = new ContralVO();
            contralVO.setNumber(number);
            contralVO.setId(Long.valueOf(0L));
            contralVO.setEnable(false);
            contralVO.setModelId(Long.valueOf(modelId));
            numberSet.add(number);
            numberList.add(number);
            if (bgmd) {
                String businessModel = this.getCellStringValue(this.getCell(row, columnIndex += 2));
                if (StringUtils.isEmpty((String)businessModel)) {
                    errorInfo = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CentralizedFileServiceImpl_56", (String)"epm-eb-business", (Object[])new Object[0]);
                    this.collectErrorInfos(errorInfo, rowNum);
                } else if (controlDims.get(businessModel) != null) {
                    BgmdControlParam bgmdControlParam = controlDims.get(businessModel);
                    contralVO.setBussinessModelId(bgmdControlParam.getBusinessmodelid());
                    contralVO.setControlDimIds(bgmdControlParam.getControlDimension());
                } else {
                    errorInfo = ResManager.loadResFormat((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728: %1", (String)"CentralizedFileServiceImpl_63", (String)"epm-eb-business", (Object[])new Object[]{businessModel});
                    this.collectErrorInfos(errorInfo, rowNum);
                }
            } else if (newEb) {
                if (controlDims.get("AunnalBudget") != null) {
                    BgmdControlParam newEbControlParam = controlDims.get("AunnalBudget");
                    contralVO.setBussinessModelId(newEbControlParam.getBusinessmodelid());
                    contralVO.setControlDimIds(newEbControlParam.getControlDimension());
                }
            } else {
                contralVO.setBussinessModelId(0L);
            }
            columnIndex += 2;
            String account = this.getCellStringValue(this.getCell(row, columnIndex++));
            String desc = this.getCellStringValue(this.getCell(row, columnIndex++));
            String dimensionNumber = this.getCellStringValue(this.getCell(row, columnIndex));
            contralVO.setDescription((ILocaleString)new LocaleString());
            contralVO.getDescription().setLocaleValue(desc);
            if (StringUtils.isEmpty((String)account)) {
                errorInfo = ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CentralizedFileServiceImpl_29", (String)"epm-eb-business", (Object[])new Object[0]);
                this.collectErrorInfos(errorInfo, rowNum);
            } else {
                HashSet<String> notPermMembers = new HashSet<String>(16);
                List<kd.epm.eb.common.model.Member> accountMembers = this.queryMembersByNumbersAndModelCache(account, SysDimensionEnum.Account.getNumber(), modelId, contralVO.getBussinessModelId(), notPermMembers);
                if (CollectionUtils.isEmpty(accountMembers)) {
                    errorInfo = ResManager.loadResFormat((String)"\u79d1\u76ee\u7f16\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u201c%1\u201d\u3002", (String)"CentralizedFileServiceImpl_31", (String)"epm-eb-business", (Object[])new Object[]{account});
                    this.collectErrorInfos(errorInfo, rowNum);
                } else if (accountMembers.size() != account.split(",").length) {
                    List<String> different = this.getDifferent(account, accountMembers);
                    errorInfo = ResManager.loadResFormat((String)"\u79d1\u76ee\u7f16\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u201c%1\u201d\u3002", (String)"CentralizedFileServiceImpl_31", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)",", different)});
                    this.collectErrorInfos(errorInfo, rowNum);
                } else {
                    contralVO.setAccountMembers(accountMembers);
                }
            }
            if (StringUtils.isEmpty((String)dimensionNumber)) {
                errorInfo = ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CentralizedFileServiceImpl_30", (String)"epm-eb-business", (Object[])new Object[0]);
                this.collectErrorInfos(errorInfo, rowNum);
            } else {
                DynamicObject dimensionObj = this.queryMemberByNumberAndModel(dimensionNumber, modelId, contralVO.getControlDimIds());
                if (dimensionObj == null) {
                    errorInfo = ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u7f16\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"CentralizedFileServiceImpl_32", (String)"epm-eb-business", (Object[])new Object[0]);
                    this.collectErrorInfos(errorInfo, rowNum);
                } else {
                    kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension(Long.valueOf(dimensionObj.getLong("id")), dimensionObj.getString("name"), dimensionObj.getString("number"));
                    CentralizedImportContext.get().setIssysdimension(dimensionObj.getBoolean("issysdimension"));
                    contralVO.setControlDimension(dimension);
                }
            }
        }
        return contralVO;
    }

    public void setContralVoBySheet(Row row, ContralVO contralVO) {
        String errorInfo;
        ContralCell cell;
        boolean issysdimension;
        Map<String, List<ContralCell>> entityFromCache;
        int rowNum;
        block35: {
            String orgRangeStr;
            rowNum = row.getRowNum();
            entityFromCache = CentralizedImportContext.get().getEntityFromCache();
            issysdimension = CentralizedImportContext.get().isIssysdimension();
            long modelId = CentralizedImportContext.get().getModelId();
            boolean bgmd = CentralizedImportContext.get().isBgmd();
            boolean newEb = CentralizedImportContext.get().isNewEb();
            cell = new ContralCell();
            int columnIndex = 7;
            if (bgmd) {
                columnIndex = 9;
            }
            String targetEntityStr = this.getCellStringValue(this.getCell(row, columnIndex));
            String sourceRangeStr = this.getCellStringValue(this.getCell(row, columnIndex += 2));
            HashSet<String> notPermMembers = new HashSet<String>(16);
            if (StringUtils.isEmpty((String)targetEntityStr)) {
                errorInfo = ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7\u7f16\u7801\u4e3a\u5fc5\u586b\u9879, \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CentralizedFileServiceImpl_33", (String)"epm-eb-business", (Object[])new Object[0]);
                this.collectErrorInfos(errorInfo, rowNum);
            } else if (contralVO.getControlDimension() != null) {
                if (targetEntityStr.split(",").length != 1) {
                    errorInfo = ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u4e00\u4e2a\u5f52\u53e3\u7ec4\u7ec7", (String)"CentralizedFileServiceImpl_65", (String)"epm-eb-business", (Object[])new Object[0]);
                    this.collectErrorInfos(errorInfo, rowNum);
                } else {
                    List<kd.epm.eb.common.model.Member> targetEntityMembers = this.queryMembersByNumbersAndModelCache(targetEntityStr, SysDimensionEnum.Entity.getNumber(), modelId, contralVO.getBussinessModelId(), notPermMembers);
                    if (CollectionUtils.isEmpty(targetEntityMembers)) {
                        errorInfo = ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7\u7f16\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"CentralizedFileServiceImpl_35", (String)"epm-eb-business", (Object[])new Object[0]);
                        this.collectErrorInfos(errorInfo, rowNum);
                    } else {
                        List<String> noLeafNumbers = this.getNoLeafNumbers(targetEntityMembers);
                        if (noLeafNumbers.size() > 0) {
                            errorInfo = ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7\u7f16\u7801\u5fc5\u987b\u662f\u660e\u7ec6\u6210\u5458\u3002", (String)"CentralizedFileServiceImpl_28", (String)"epm-eb-business", (Object[])new Object[0]);
                            this.collectErrorInfos(errorInfo, rowNum);
                        } else {
                            cell.setTargetEntity(targetEntityMembers.get(0).getId());
                        }
                    }
                }
            }
            if (StringUtils.isEmpty((String)sourceRangeStr)) {
                String propVal;
                if (bgmd && row.getLastCellNum() > 13 && StringUtils.isEmpty((String)(propVal = this.getCellStringValue(this.getCell(row, columnIndex + 4))))) {
                    errorInfo = ResManager.loadKDString((String)"\u7ba1\u63a7\u8303\u56f4\u7f16\u7801\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CentralizedFileServiceImpl_34", (String)"epm-eb-business", (Object[])new Object[0]);
                    this.collectErrorInfos(errorInfo, rowNum);
                }
            } else if (contralVO.getControlDimension() != null) {
                List<kd.epm.eb.common.model.Member> members = this.queryMembersByNumbersAndModelCache(sourceRangeStr, contralVO.getControlDimension().getNumber(), modelId, contralVO.getBussinessModelId(), notPermMembers);
                if (CollectionUtils.isEmpty(members)) {
                    errorInfo = ResManager.loadResFormat((String)"\u7ba1\u63a7\u8303\u56f4\u7f16\u7801\u5728\u5f53\u524d\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u4e0b\u4e0d\u5b58\u5728:%1", (String)"CentralizedFileServiceImpl_36", (String)"epm-eb-business", (Object[])new Object[]{sourceRangeStr});
                    this.collectErrorInfos(errorInfo, rowNum);
                } else if (members.size() != sourceRangeStr.split(",").length) {
                    List<String> different = this.getDifferent(sourceRangeStr, members);
                    errorInfo = ResManager.loadResFormat((String)"\u7ba1\u63a7\u8303\u56f4\u7f16\u7801\u5728\u5f53\u524d\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u4e0b\u4e0d\u5b58\u5728:%1", (String)"CentralizedFileServiceImpl_36", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)",", different)});
                    this.collectErrorInfos(errorInfo, rowNum);
                } else {
                    cell.setMembers(members);
                }
            }
            if (!issysdimension && row.getLastCellNum() > 10 && StringUtils.isNotEmpty((String)(orgRangeStr = this.getCellStringValue(this.getCell(row, columnIndex + 2)))) && contralVO.getControlDimension() != null) {
                List<kd.epm.eb.common.model.Member> orgMembers = this.queryMembersByNumbersAndModelCache(orgRangeStr, SysDimensionEnum.Entity.getNumber(), modelId, contralVO.getBussinessModelId(), notPermMembers);
                if (CollectionUtils.isEmpty(orgMembers)) {
                    errorInfo = ResManager.loadResFormat((String)"\u7ec4\u7ec7\u8303\u56f4\u7f16\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u201c%1\u201d\u3002", (String)"CentralizedFileServiceImpl_37", (String)"epm-eb-business", (Object[])new Object[]{orgRangeStr});
                    this.collectErrorInfos(errorInfo, rowNum);
                } else if (orgMembers.size() != orgRangeStr.split(",").length) {
                    List<String> different = this.getDifferent(orgRangeStr, orgMembers);
                    errorInfo = ResManager.loadResFormat((String)"\u7ec4\u7ec7\u8303\u56f4\u7f16\u7801\u5728\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u201c%1\u201d\u3002", (String)"CentralizedFileServiceImpl_37", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)",", different)});
                    this.collectErrorInfos(errorInfo, rowNum);
                } else {
                    cell.setOrgMembers(orgMembers);
                }
            }
            if (CollectionUtils.isNotEmpty(notPermMembers)) {
                this.collectErrorInfos(ResManager.loadResFormat((String)"%1\u7ec4\u7ec7\u6ca1\u6709\u6743\u9650", (String)"CentralizedFileServiceImpl_64", (String)"epm-eb-business", (Object[])new Object[]{StringUtils.join(notPermMembers, (String)"\u3001")}), rowNum);
            }
            if ((!bgmd || row.getLastCellNum() <= 13) && (!newEb || row.getLastCellNum() <= 11)) break block35;
            ArrayList<kd.epm.eb.common.model.Member> orgMemberDtos = new ArrayList<kd.epm.eb.common.model.Member>(16);
            String propVal = this.getCellStringValue(this.getCell(row, columnIndex + 4));
            if (!StringUtils.isNotEmpty((String)propVal)) break block35;
            HashSet<Long> propIds = new HashSet<Long>();
            MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)modelId);
            Set props = Arrays.stream(propVal.split(",")).collect(Collectors.toSet());
            ArrayList<String> notFoundPro = new ArrayList<String>(16);
            for (String pro : props) {
                Boolean hasProp;
                block37: {
                    block36: {
                        hasProp = false;
                        if (!pro.contains("!")) break block36;
                        CustomPropertyValue propValue = propCache.getPropertyValue(SysDimensionEnum.Entity.getNumber(), pro.split("!")[0], pro.split("!")[1]);
                        if (propValue == null) break block37;
                        hasProp = true;
                        if (propIds.contains(propValue.getId())) break block37;
                        propIds.add(propValue.getId());
                        orgMemberDtos.add(new kd.epm.eb.common.model.Member(propValue.getId(), propValue.getName(), propValue.getNumber(), Boolean.valueOf(true)));
                        break block37;
                    }
                    List propertiesDim = propCache.getPropertiesByDim(SysDimensionEnum.Entity.getNumber());
                    for (CustomProperty customProperty : propertiesDim) {
                        CustomPropertyValue propValue = propCache.getPropertyValue(SysDimensionEnum.Entity.getNumber(), customProperty.getNumber(), pro);
                        if (propValue == null) continue;
                        hasProp = true;
                        if (propIds.contains(propValue.getId())) continue;
                        propIds.add(propValue.getId());
                        orgMemberDtos.add(new kd.epm.eb.common.model.Member(propValue.getId(), propValue.getName(), propValue.getNumber(), Boolean.valueOf(true)));
                    }
                }
                if (hasProp.booleanValue()) continue;
                notFoundPro.add(pro);
            }
            if (!notFoundPro.isEmpty()) {
                this.collectErrorInfos(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u5c5e\u6027\uff1a%s\u3002", (String)"RuleControlImportPlugin_80", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join(notFoundPro, (String)"\u3001")}), rowNum);
            }
            if (!orgMemberDtos.isEmpty()) {
                if (issysdimension) {
                    if (cell.getMembers() == null || cell.getMembers().isEmpty()) {
                        cell.setMembers(orgMemberDtos);
                    } else {
                        cell.getMembers().addAll(orgMemberDtos);
                    }
                } else if (cell.getOrgMembers() == null || cell.getOrgMembers().isEmpty()) {
                    cell.setOrgMembers(orgMemberDtos);
                } else {
                    cell.getOrgMembers().addAll(orgMemberDtos);
                }
            }
        }
        if (!issysdimension && cell.getOrgMembers().isEmpty()) {
            errorInfo = ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u4e3a\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u65f6\uff0c\u7ec4\u7ec7\u8303\u56f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CentralizedFileServiceImpl_71", (String)"epm-eb-business", (Object[])new Object[0]);
            this.collectErrorInfos(errorInfo, rowNum);
        }
        List cells = entityFromCache.computeIfAbsent(contralVO.getNumber(), k -> new ArrayList(16));
        cells.add(cell);
        contralVO.setCells(cells);
    }

    private List<String> getDifferent(String excelFieldStr, List<kd.epm.eb.common.model.Member> dimentionMembers) {
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(excelFieldStr.split(",")));
        ArrayList<String> numbers = new ArrayList<String>(dimentionMembers.size());
        for (kd.epm.eb.common.model.Member member : dimentionMembers) {
            numbers.add(member.getNumber());
        }
        strings.removeAll(numbers);
        return strings;
    }

    private List<String> getNoLeafNumbers(List<kd.epm.eb.common.model.Member> members) {
        ArrayList<String> noLeafs = new ArrayList<String>(16);
        for (kd.epm.eb.common.model.Member member : members) {
            if (member.isLeaf()) continue;
            noLeafs.add(member.getNumber());
        }
        return noLeafs;
    }

    public DynamicObject queryMemberByNumberAndModel(String numbersStr, Long modelId, List<Long> controlDimIds) {
        QFilter qf = new QFilter("number", "=", (Object)numbersStr);
        qf.and("model", "=", (Object)modelId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id, name, number, issysdimension", (QFilter[])qf.toArray());
        if (dynamicObject == null) {
            return null;
        }
        long id = dynamicObject.getLong("id");
        if (CollectionUtils.isEmpty(controlDimIds) || controlDimIds.contains(id)) {
            return dynamicObject;
        }
        return null;
    }

    public List<kd.epm.eb.common.model.Member> queryMembersByNumbersAndModelCache(String numbersStr, String dimNumber, Long modelId, Long busModelId, Set<String> notPermMembers) {
        ArrayList<kd.epm.eb.common.model.Member> members = new ArrayList<kd.epm.eb.common.model.Member>(16);
        List<Object> cacheHelperMembers = new ArrayList(16);
        Object[] split = numbersStr.split(",");
        ArrayList numbers = Lists.newArrayList((Object[])split);
        if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            numbers.remove(SysDimensionEnum.Entity.getNumber());
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
        Long viewId = null;
        if (dimNumber.equals(SysDimensionEnum.Account.getNumber())) {
            List dataSetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(busModelId);
            if (CollectionUtils.isNotEmpty((Collection)dataSetIds)) {
                for (Long dataSetId : dataSetIds) {
                    cacheHelperMembers.addAll(dimension.getAllMembersByDataSetId(dataSetId));
                    cacheHelperMembers = cacheHelperMembers.stream().filter(e -> numbers.contains(e.getNumber())).collect(Collectors.toList());
                }
            } else {
                cacheHelperMembers = modelCacheHelper.getMembers(dimNumber, null, (Collection)numbers);
            }
        } else {
            viewId = modelCacheHelper.getViewByBusModelAndDimNumber(busModelId, dimNumber);
            cacheHelperMembers = modelCacheHelper.getMembers(dimension, viewId, (Collection)numbers);
        }
        if (CollectionUtils.isNotEmpty(cacheHelperMembers)) {
            Sets.SetView notPermMemberSet = new HashSet(cacheHelperMembers.size());
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                Set memberIdSet = cacheHelperMembers.stream().map(BaseCache::getId).collect(Collectors.toSet());
                Set permDimensionMemIdSet = DimMembPermHelper.getPermMembIds((String)dimNumber, (Long)modelId, (Long)busModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                if (permDimensionMemIdSet != null) {
                    notPermMemberSet = Sets.difference(memberIdSet, (Set)permDimensionMemIdSet);
                }
            }
            for (Member cacheHelperMember : cacheHelperMembers) {
                if (notPermMemberSet.contains(cacheHelperMember.getId())) {
                    notPermMembers.add(cacheHelperMember.getNumber());
                }
                kd.epm.eb.common.model.Member member = new kd.epm.eb.common.model.Member(cacheHelperMember.getId());
                member.setName(cacheHelperMember.getName());
                member.setNumber(cacheHelperMember.getNumber());
                member.setLeaf(cacheHelperMember.isLeaf());
                members.add(member);
            }
        }
        return members;
    }

    public void checkExcel(XSSFWorkbook xssfWorkbook) throws Exception {
        XSSFRow row = xssfWorkbook.getSheetAt(0).getRow(ImportHeaderConstants.DATA_ROW_INDEX - 1);
        int lastCellNum = row.getLastCellNum();
        List<String> header = this.getHeaderList();
        for (int i = 0; i < lastCellNum; ++i) {
            String stringCellValue = this.getCell((Row)row, i).getStringCellValue();
            if (header.get(i).equals(stringCellValue)) continue;
            throw new Exception(ResManager.loadKDString((String)"\u8bf7\u4e0b\u8f7d\u6b63\u786e\u6a21\u677f\u3002", (String)"CentralizedFileServiceImpl_38", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public void checkExcelData(List<ContralVO> saveData) {
        Set<String> numberSet = CentralizedImportContext.get().getNumberSet();
        List<String> numberList = CentralizedImportContext.get().getNumberList();
        Map<Integer, String> errorInfoMap = CentralizedImportContext.get().getErrorInfoMap();
        if (CollectionUtils.isEmpty(saveData)) {
            this.collectErrorInfos(ResManager.loadKDString((String)"excel\u6587\u4ef6\u4e2d\u5f52\u53e3\u65b9\u6848\u6570\u636e\u4e3a\u7a7a\u3002", (String)"CetralizedFileServiceBase_17", (String)"epm-eb-business", (Object[])new Object[0]), ImportHeaderConstants.DATA_ROW_INDEX);
        }
        ArrayList<String> repeatNumberList = new ArrayList<String>(16);
        for (String number : numberSet) {
            if (numberList.indexOf(number) >= numberList.lastIndexOf(number)) continue;
            repeatNumberList.add(number);
        }
        if (repeatNumberList.size() > 0) {
            String numberStr = String.join((CharSequence)",", repeatNumberList);
            this.collectErrorInfos(ResManager.loadResFormat((String)"Excel\u6587\u4ef6\u4e2d\u5b58\u5728\u76f8\u540c\u7f16\u7801\u201c%1\u201d\u3002", (String)"CentralizedFileServiceImpl_42", (String)"epm-eb-business", (Object[])new Object[]{numberStr}), ImportHeaderConstants.DATA_ROW_INDEX);
        }
        Set<String> sysNumbers = null;
        int index = ImportHeaderConstants.DATA_ROW_INDEX;
        int size = saveData.size();
        for (int i = 0; i < size; ++i) {
            ContralVO contralVO = saveData.get(i);
            String number = contralVO.getNumber();
            String tips = NumberCheckUtils.checkNumberRule((String)number);
            if (StringUtils.isNotEmpty((String)tips)) {
                this.collectErrorInfos(tips, index);
            } else if (number.length() > 50) {
                this.collectErrorInfos(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u3002", (String)"CentralizedFileServiceImpl_39", (String)"epm-eb-business", (Object[])new Object[0]), index);
            } else {
                if (sysNumbers == null) {
                    sysNumbers = this.getAllSysNumbers(contralVO.getModelId());
                }
                if (sysNumbers.contains(number)) {
                    this.collectErrorInfos(ResManager.loadKDString((String)"\u7f16\u7801\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91", (String)"CentralizedFileServiceImpl_45", (String)"epm-eb-business", (Object[])new Object[0]), index);
                }
            }
            index += contralVO.getCells().size();
        }
        if (errorInfoMap.size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"CentralizedFileServiceImpl_9", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public void saveImportData(List<ContralVO> saveData) {
        try (TXHandle h = TX.required((String)"eb_centralized_template_save");){
            try {
                centralizedService.saveImportContral(saveData);
            }
            catch (Throwable e) {
                h.markRollback();
                log.error(e);
                this.collectErrorInfos(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4fdd\u5b58\u6570\u636e\u53d1\u751f\u5f02\u5e38\u3002", (String)"CentralizedFileServiceImpl_47", (String)"epm-eb-business", (Object[])new Object[0]), ImportHeaderConstants.DATA_ROW_INDEX - 1);
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"CentralizedFileServiceImpl_9", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
    }

    public void collectErrorInfos(String errorInfo, Integer rowIndex) {
        ContextParams contextParams = CentralizedImportContext.get();
        Map<Integer, String> errorInfoMap = contextParams.getErrorInfoMap();
        if (errorInfoMap.containsKey(rowIndex)) {
            String s = errorInfoMap.get(rowIndex);
            errorInfoMap.put(rowIndex, s + ";" + errorInfo);
        } else {
            errorInfoMap.put(rowIndex, errorInfo);
        }
    }

    public void downloadErrorInfos(XSSFWorkbook workbook, IFormView view) {
        try {
            XSSFSheet sheet = workbook.getSheetAt(0);
            this.insertColumn(sheet, workbook);
            this.writeErrorInfo(sheet, workbook);
            this.downLoad(workbook, ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u63a7\u65b9\u6848\u5bfc\u5165\u9519\u8bef\u65e5\u5fd7", (String)"CentralizedFileServiceImpl_49", (String)"epm-eb-business", (Object[])new Object[0]), view);
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u9519\u8bef\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CentralizedFileServiceImpl_10", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public void insertColumn(XSSFSheet sheet, XSSFWorkbook xssfWorkbook) {
        Map<Integer, String> errorInfoMap = CentralizedImportContext.get().getErrorInfoMap();
        if (sheet == null) {
            return;
        }
        XSSFRow row = this.getRow(sheet, ImportHeaderConstants.DATA_ROW_INDEX - 1);
        short columnNum = row.getLastCellNum();
        int lastRowNum = sheet.getLastRowNum();
        for (int i = 0; i <= lastRowNum; ++i) {
            for (int j = columnNum - 1; j >= 0; --j) {
                XSSFRow row1 = this.getRow(sheet, i);
                Cell preCell = this.getCell((Row)row1, j);
                Cell nextCell = this.getCell((Row)row1, j + 1);
                String cellValue = this.getCellStringValue(preCell);
                this.setCellStringValue(nextCell, cellValue);
                nextCell.setCellStyle(preCell.getCellStyle());
                if (i == ImportHeaderConstants.DATA_ROW_INDEX - 1) {
                    nextCell.setCellComment(preCell.getCellComment());
                }
                if (j != 0) continue;
                this.setCellStringValue(preCell, "");
            }
        }
        XSSFRow row1 = this.getRow(sheet, ImportHeaderConstants.DATA_ROW_INDEX - 1);
        if (errorInfoMap != null && errorInfoMap.size() > 0 && errorInfoMap.get(ImportHeaderConstants.DATA_ROW_INDEX - 1) != null) {
            row1 = this.getRow(sheet, ImportHeaderConstants.DATA_ROW_INDEX - 2);
        }
        Cell cell = this.getCell((Row)row1, 0);
        this.setCellTypeColor(xssfWorkbook, cell, IndexedColors.RED.index, null);
        String cellValue = ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5\u5982\u4e0b", (String)"CentralizedFileServiceImpl_50", (String)"epm-eb-business", (Object[])new Object[0]);
        this.setCellStringValue(cell, cellValue);
        sheet.setColumnWidth(0, cellValue.getBytes().length * 5 * 256);
    }

    public void writeErrorInfo(XSSFSheet sheet, XSSFWorkbook xssfWorkbook) {
        ContextParams contextParams = CentralizedImportContext.get();
        Map<Integer, String> error = contextParams.getErrorInfoMap();
        for (Map.Entry<Integer, String> entry : error.entrySet()) {
            Integer key = entry.getKey();
            String errorInfo = entry.getValue();
            Cell cell = this.getCell((Row)this.getRow(sheet, key), 0);
            this.setCellTypeColor(xssfWorkbook, cell, IndexedColors.RED.index, null);
            this.setCellStringValue(cell, errorInfo);
        }
    }

    public XSSFRow getRow(XSSFSheet sheet, int rowIndex) {
        XSSFRow row = sheet.getRow(rowIndex);
        if (row != null) {
            return row;
        }
        return sheet.createRow(rowIndex);
    }

    public Cell getCell(Row row, int columeIndex) {
        Cell cell = row.getCell(columeIndex);
        if (cell != null) {
            return cell;
        }
        return row.createCell(columeIndex);
    }

    public boolean isEmptyRow(Row row) {
        int size = this.getHeaderList().size();
        ArrayList<Integer> noEmptyIndex = new ArrayList<Integer>(size);
        if (row == null) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            String stringCellValue = this.getCellStringValue(row.getCell(i));
            if (!StringUtils.isNotEmpty((String)stringCellValue)) continue;
            noEmptyIndex.add(i);
        }
        return noEmptyIndex.size() == 0;
    }

    public void setCellStringValue(Cell cell, String value) {
        cell.setCellType(CellType.STRING);
        cell.setCellValue(value);
    }

    public String getCellStringValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (CellType.STRING.equals((Object)cell.getCellType())) {
            return cell.getStringCellValue().trim();
        }
        if (CellType.NUMERIC.equals((Object)cell.getCellType())) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue()).trim();
        }
        return "";
    }

    public String arrayToString(String[] arrays, String prop, Boolean isProp) {
        ArrayList<String> array = new ArrayList<String>(16);
        for (String s : arrays) {
            if (StringUtils.isEmpty((String)s)) continue;
            JSONObject jsonObject = JSONObject.parseObject((String)s);
            String string = jsonObject.getString(prop);
            if (isProp.booleanValue()) {
                if (!"1".equals(jsonObject.getString("pro"))) continue;
                array.add(string);
                continue;
            }
            if ("1".equals(jsonObject.getString("pro"))) continue;
            array.add(string);
        }
        return String.join((CharSequence)",", array);
    }

    public List<InputStream> getImportStreamFromCache(IPageCache pageCache) {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String fileUrl = pageCache.get("file_url");
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(16);
        if (fileUrl != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
            try {
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    inputStreams.add(inputStream);
                }
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CentralizedFileServiceImpl_4", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
        if (inputStreams.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"CentralizedFileServiceImpl_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (inputStreams.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u4e0a\u4f20\u4e00\u4e2a\u6587\u4ef6\u3002", (String)"CentralizedFileServiceImpl_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return inputStreams;
    }

    public List<XSSFWorkbook> getXssFWorkBook(List<InputStream> inputStreams) {
        ArrayList<XSSFWorkbook> xssfWorkbooks = new ArrayList<XSSFWorkbook>(16);
        try {
            for (InputStream importStream : inputStreams) {
                XSSFWorkbook xssFWorkbook = new XSSFWorkbook(importStream);
                xssfWorkbooks.add(xssFWorkbook);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"CentralizedFileServiceImpl_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return xssfWorkbooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoad(XSSFWorkbook excelBook, String fileName, IFormView view) throws Exception {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            excelBook.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    protected List<String> getHeaderList() {
        if (CentralizedImportContext.get().isBgmd()) {
            return Arrays.asList(new CentralizedFileServiceImpl().bgmdtemplatehead());
        }
        if (CentralizedImportContext.get().isNewEb()) {
            return Arrays.asList(new CentralizedFileServiceImpl().bgtemplatehead());
        }
        return Arrays.asList(new CentralizedFileServiceImpl().ebtemplatehead());
    }

    protected Set<String> getAllSysNumbers(long modelid) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"eb_centralized_entity", (String)"id,number", (QFilter[])qFilter.toArray());
        return map.values().stream().map(m -> m.getString("number")).collect(Collectors.toSet());
    }
}

