/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralrelation;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralrelation.CentralRelation;
import kd.epm.eb.common.centralrelation.CentralRelationRecord;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections.CollectionUtils;

public class CentralRelationService {
    private static final Log log = LogFactory.getLog(CentralRelationService.class);

    public static CentralRelationService getInstance() {
        return new CentralRelationService();
    }

    public List<CentralRelationRecord> getCentralRelationRecord(Long centralSchemeId, boolean onlyValid) {
        Map<Long, List<CentralRelationRecord>> centralRelationMap = this.getCentralRelationRecords(Sets.newHashSet((Object[])new Long[]{centralSchemeId}), onlyValid);
        return centralRelationMap.computeIfAbsent(centralSchemeId, e -> new ArrayList(0));
    }

    public Map<Long, List<CentralRelationRecord>> getCentralRelationByManageEntity(Long centralRangeId, Long centralManageEntityId) {
        QFilter qFilter = new QFilter("centralrange", "=", (Object)centralRangeId).and("entity", "=", (Object)centralManageEntityId);
        DynamicObjectCollection centralRelSchemes = QueryServiceHelper.query((String)"eb_centralrelscheme", (String)"id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)centralRelSchemes)) {
            Set<Long> schemeIds = centralRelSchemes.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            return this.getCentralRelationRecords(schemeIds, false);
        }
        return new HashMap<Long, List<CentralRelationRecord>>(0);
    }

    public Map<Long, List<CentralRelationRecord>> getCentralRelationRecords(Set<Long> centralSchemeIds, boolean onlyValid) {
        DynamicObjectCollection query;
        QFilter qFilter = new QFilter("scheme", "in", centralSchemeIds);
        if (onlyValid) {
            qFilter.and("status", "=", (Object)"1");
        }
        if (CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_centralrelation", (String)"scheme,entity,meminfojson,status,enabledate,disabledate,modifier,modifydate,entryseq", (QFilter[])qFilter.toArray(), (String)"scheme,entryseq")))) {
            return new HashMap<Long, List<CentralRelationRecord>>(0);
        }
        LinkedHashMap<Long, List<CentralRelationRecord>> centralRelationMap = new LinkedHashMap<Long, List<CentralRelationRecord>>(query.size());
        Date now = TimeServiceHelper.now();
        for (DynamicObject object : query) {
            Long schemeId = object.getLong("scheme");
            Date enableDate = object.getDate("enabledate");
            Date disableDate = object.getDate("disabledate");
            if (onlyValid && enableDate != null && (now.compareTo(enableDate) < 0 || disableDate != null && now.compareTo(disableDate) > 0)) continue;
            CentralRelationRecord record = new CentralRelationRecord();
            record.setSchemeId(schemeId);
            record.setEntityId(Long.valueOf(object.getLong("entity")));
            record.setStatus(object.getBoolean("status"));
            record.setEnableDate(enableDate);
            record.setDisableDate(disableDate);
            record.setSeq(object.getInt("entryseq"));
            record.setModifier(Long.valueOf(object.getLong("modifier")));
            record.setModifyDate(object.getDate("modifydate"));
            record.setCentralDimMemberInfo(CentralRelationRecord.parseDimMemberInfoJson((String)object.getString("meminfojson")));
            List records = centralRelationMap.computeIfAbsent(schemeId, e -> new ArrayList(10));
            records.add(record);
        }
        return centralRelationMap;
    }

    public Map<Long, List<CentralRelation>> getCentralRelations(Set<Long> centralSchemeIds) {
        QFilter qFilter = new QFilter("scheme", "in", centralSchemeIds);
        qFilter.and("status", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_centralrelation", (String)"scheme,entity,meminfojson,enabledate,disabledate,entryseq", (QFilter[])qFilter.toArray(), (String)"scheme,entryseq");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, List<CentralRelation>>(0);
        }
        LinkedHashMap<Long, List<CentralRelation>> centralRelationMap = new LinkedHashMap<Long, List<CentralRelation>>(query.size());
        Date now = TimeServiceHelper.now();
        for (DynamicObject object : query) {
            Long schemeId = object.getLong("scheme");
            Date enableDate = object.getDate("enabledate");
            Date disableDate = object.getDate("disabledate");
            if (enableDate != null && (now.compareTo(enableDate) < 0 || disableDate != null && now.compareTo(disableDate) > 0)) continue;
            CentralRelation relation = new CentralRelation();
            relation.setSchemeId(schemeId);
            relation.setEntityId(Long.valueOf(object.getLong("entity")));
            relation.setSeq(object.getInt("entryseq"));
            relation.setCentralDimMemberInfo(CentralRelation.parseDimMemberInfoJson((String)object.getString("meminfojson")));
            List relations = centralRelationMap.computeIfAbsent(schemeId, e -> new ArrayList(10));
            relations.add(relation);
        }
        return centralRelationMap;
    }

    public void saveCentralRelationRecord(List<CentralRelationRecord> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(records.size());
        for (CentralRelationRecord record : records) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralrelation");
            object.set("scheme", (Object)record.getSchemeId());
            object.set("entity", (Object)record.getEntityId());
            object.set("status", (Object)record.isStatus());
            object.set("enabledate", (Object)record.getEnableDate());
            object.set("disabledate", (Object)record.getDisableDate());
            object.set("entryseq", (Object)record.getSeq());
            object.set("modifier", (Object)record.getModifier());
            object.set("modifydate", (Object)record.getModifyDate());
            object.set("meminfojson", (Object)record.getCentralDimMemberInfoJson());
            objects.add(object);
        }
        SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
    }

    public void delCentralRelationRelationMemberQuote(List<Long> centralSchemeIds) {
        if (CollectionUtils.isEmpty(centralSchemeIds)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.CentralRelScheme.getType(), centralSchemeIds});
    }

    public void addCentralRelationRecordQuote(Long modelId, Long bizModelId, List<CentralRelationRecord> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        for (CentralRelationRecord record : records) {
            Map centralDimMemberInfo;
            Long entityId = record.getEntityId();
            Dimension entity = orCreate.getDimension("Entity");
            if (entity != null) {
                quotes.add(new MemberQuoteDao(modelId, bizModelId, entity.getId(), entityId, MemberQuoteResourceEnum.CentralRelScheme, record.getSchemeId()));
            }
            if ((centralDimMemberInfo = record.getCentralDimMemberInfo()) == null || centralDimMemberInfo.size() <= 0) continue;
            for (Map.Entry entry : centralDimMemberInfo.entrySet()) {
                MemberCondition condition;
                String dimNumber = (String)entry.getKey();
                Member member = orCreate.getMember(dimNumber, IDUtils.toLong((Object)(condition = (MemberCondition)entry.getValue()).getViewId()), condition.getNumber());
                if (member == null) continue;
                quotes.add(new MemberQuoteDao(modelId, bizModelId, member.getDimension().getId(), member.getId(), MemberQuoteResourceEnum.CentralRelScheme, record.getSchemeId()));
            }
        }
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    public void delCentralRelation(Set<Long> centralSchemeIds) {
        DeleteServiceHelper.delete((String)"eb_centralrelation", (QFilter[])new QFilter("scheme", "in", centralSchemeIds).toArray());
    }

    public Map<Long, Set<Member>> getCentralRelationEntities(Long modelId, Set<Long> schemeIds) {
        if (CollectionUtils.isEmpty(schemeIds) || IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return new HashMap<Long, Set<Member>>(0);
        }
        log.info("CentralRelationService#getCentralRelationEntities: modelId:{};schemeIds:{}", (Object)modelId, (Object)SerializationUtils.toJsonString(schemeIds));
        QFilter qFilter = new QFilter("scheme", "in", schemeIds);
        qFilter.and("status", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_centralrelation", (String)"scheme,entity,enabledate,disabledate,scheme.centralrange", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, Set<Member>>(0);
        }
        HashMap<Long, Set<Member>> centralRelationEntities = new HashMap<Long, Set<Member>>(query.size());
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        Date now = TimeServiceHelper.now();
        for (DynamicObject object : query) {
            Long centralRangeId;
            Map<String, Long> centralRangeDimView;
            Member member;
            Date enableDate = object.getDate("enabledate");
            Date disableDate = object.getDate("disabledate");
            if (enableDate != null && (now.compareTo(enableDate) < 0 || disableDate != null && now.compareTo(disableDate) > 0) || (member = orCreate.getMember("Entity", (centralRangeDimView = this.getCentralRangeDimView(centralRangeId = Long.valueOf(object.getLong("scheme.centralrange")))).get("Entity"), Long.valueOf(object.getLong("entity")))) == null) continue;
            Long schemeId = object.getLong("scheme");
            Set members = centralRelationEntities.computeIfAbsent(schemeId, e -> new LinkedHashSet(16));
            members.add(member);
        }
        StringBuilder logInfo = new StringBuilder();
        for (Map.Entry entry : centralRelationEntities.entrySet()) {
            Long schemeId = (Long)entry.getKey();
            Set members = (Set)entry.getValue();
            logInfo.append(schemeId).append(":");
            for (Member member : members) {
                logInfo.append(member.getNumber()).append(",");
            }
            logInfo.append(";");
        }
        log.info("CentralRelationService#getCentralRelationEntities: return:{}", (Object)logInfo.toString());
        return centralRelationEntities;
    }

    public List<Map<String, Member>> getCentralRelDimMemberInfo(Long modelId, Set<Long> schemeIds) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || CollectionUtils.isEmpty(schemeIds)) {
            return new ArrayList<Map<String, Member>>(0);
        }
        log.info("CentralRelationService#getCentralRelDimMemberInfo: modelId:{};schemeIds:{}", (Object)modelId, (Object)SerializationUtils.toJsonString(schemeIds));
        Map<Long, List<CentralRelation>> centralRelations = this.getCentralRelations(schemeIds);
        if (centralRelations == null || centralRelations.size() == 0) {
            return new ArrayList<Map<String, Member>>(0);
        }
        QFilter qFilter = new QFilter("id", "in", schemeIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_centralrelscheme", (String)"id,centralrange", (QFilter[])qFilter.toArray());
        Map<Long, Long> schemeRangeMap = query.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("centralrange"), (v1, v2) -> v1));
        log.info("schemeRangeMap:{};", (Object)SerializationUtils.toJsonString(schemeRangeMap));
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<Map<String, Member>> centralRelDimMemberInfo = new ArrayList<Map<String, Member>>(10);
        for (Map.Entry<Long, List<CentralRelation>> entry : centralRelations.entrySet()) {
            List<CentralRelation> list = entry.getValue();
            Map<Object, Object> centralRangeDimView = new HashMap(16);
            Long centralRangeId = schemeRangeMap.get(entry.getKey());
            if (centralRangeId != null) {
                centralRangeDimView = this.getCentralRangeDimView(centralRangeId);
            }
            for (CentralRelation relation : list) {
                HashMap<String, Member> relDimMemberInfo = new HashMap<String, Member>(10);
                centralRelDimMemberInfo.add(relDimMemberInfo);
                relDimMemberInfo.put("Entity", orCreate.getMember("Entity", (Long)centralRangeDimView.get("Entity"), relation.getEntityId()));
                Map centralDimMemberInfo = relation.getCentralDimMemberInfo();
                if (centralDimMemberInfo == null || centralDimMemberInfo.size() == 0) continue;
                for (Map.Entry memberInfo : centralDimMemberInfo.entrySet()) {
                    MemberCondition condition;
                    String dimNumber = (String)memberInfo.getKey();
                    Member member = orCreate.getMember(dimNumber, IDUtils.toLong((Object)(condition = (MemberCondition)memberInfo.getValue()).getViewId()), condition.getNumber());
                    if (member == null) continue;
                    relDimMemberInfo.put(dimNumber, member);
                }
            }
        }
        StringBuilder logInfo = new StringBuilder();
        for (Map map : centralRelDimMemberInfo) {
            for (Map.Entry entry : map.entrySet()) {
                String dimNum = (String)entry.getKey();
                Member mem = (Member)entry.getValue();
                logInfo.append(dimNum).append("-").append(mem.getNumber()).append(",");
            }
            logInfo.append(";");
        }
        log.info("CentralRelationService#getCentralRelDimMemberInfo: return:{}", (Object)logInfo);
        return centralRelDimMemberInfo;
    }

    public Map<Long, Set<Long>> getCentralOrgSchemaMap(Set<Long> schemeIds) {
        HashMap<Long, Set<Long>> centralOrgSchemaMap = new HashMap<Long, Set<Long>>(16);
        Map<Long, List<CentralRelation>> centralRelations = this.getCentralRelations(schemeIds);
        for (Map.Entry<Long, List<CentralRelation>> entry : centralRelations.entrySet()) {
            Long schemaId = entry.getKey();
            List<CentralRelation> relations = entry.getValue();
            if (CollectionUtils.isEmpty(relations)) continue;
            for (CentralRelation relation : relations) {
                Long entityId = relation.getEntityId();
                Set schemaIds = centralOrgSchemaMap.computeIfAbsent(entityId, v -> new HashSet(16));
                schemaIds.add(schemaId);
            }
        }
        log.info("CentralRelationService#getCentralOrgSchemaMap: return:{}", (Object)SerializationUtils.toJsonString(centralOrgSchemaMap));
        return centralOrgSchemaMap;
    }

    public Map<String, Set<String>> getPermMemNums(Set<String> dimNums, Long modeId, Long bizModelId, Map<String, Long> centralRangeDimView) {
        if (CollectionUtils.isEmpty(dimNums)) {
            return new HashMap<String, Set<String>>(0);
        }
        HashMap<String, Set<String>> permMemberNums = new HashMap<String, Set<String>>(dimNums.size());
        for (String dimNumber : dimNums) {
            Set numbers = DimMembPermHelper.getPermMembNumbers((String)dimNumber, (Long)modeId, (Long)bizModelId, (Long)centralRangeDimView.get(dimNumber), (DimMembPermType)DimMembPermType.READ, (boolean)true);
            permMemberNums.put(dimNumber, numbers);
        }
        return permMemberNums;
    }

    public TreeNode buildTreeNode(DynamicObject rangeObj, boolean rootDisable, boolean needBuildRelScheme, boolean verifyPermission) {
        Set readPermMembIds;
        TreeNode treeNode = new TreeNode();
        long id = rangeObj.getLong("id");
        long modelId = rangeObj.getLong("model.id");
        String bizModelNumber = rangeObj.getString("bizmodel.number");
        String bizModelName = rangeObj.getString("bizmodel.name");
        if (ModelUtil.isBGModel(modelId)) {
            bizModelNumber = "root";
            bizModelName = ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u7406\u8303\u56f4", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        Map<Long, Set<DynamicObject>> relSchemeByRangeId = this.queryRelSchemeByRangeId(id);
        Map<String, Long> centralRangeDimView = this.getCentralRangeDimView(id);
        treeNode.setId(id + "_1");
        treeNode.setDisabled(rootDisable);
        long bizModelId = rangeObj.getLong("bizmodel.id");
        treeNode.setText(bizModelNumber + "    " + bizModelName);
        treeNode.setLongNumber(bizModelNumber);
        HashMap<String, String> data = new HashMap<String, String>(1);
        data.put("name", bizModelName);
        data.put("number", bizModelNumber);
        data.put("rangeId", String.valueOf(id));
        data.put("leafCounts", "0");
        treeNode.setData(data);
        DynamicObjectCollection entryentity = rangeObj.getDynamicObjectCollection("entryentity");
        DynamicObject entityDimensionObj = (DynamicObject)entryentity.get(0);
        long entityView = entityDimensionObj.getLong("dimensionview.id");
        DynamicObjectCollection entityrange = rangeObj.getDynamicObjectCollection("entityrange");
        List entityList = entityrange.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        if (verifyPermission && (readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)entityView, (boolean)true)) != null) {
            entityList.removeIf(dynamicObject -> !readPermMembIds.contains(dynamicObject.getLong("id")));
        }
        List memberNumbers = entityList.stream().map(dynamicObject1 -> dynamicObject1.getString("number")).collect(Collectors.toList());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List members = modelCacheHelper.getMembers(SysDimensionEnum.Entity.getNumber(), Long.valueOf(entityView), memberNumbers);
        List<Member> collect = members.stream().sorted((o1, o2) -> {
            if (o1.getLevel() == o2.getLevel()) {
                return o1.getSeq() - o2.getSeq();
            }
            return o1.getLevel() - o2.getLevel();
        }).collect(Collectors.toList());
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        for (Member member : collect) {
            if (needBuildRelScheme && !relSchemeByRangeId.containsKey(member.getId())) continue;
            this.doBuildRangeTreeNode(member, member, collect, id, dimension, treeNode, needBuildRelScheme, relSchemeByRangeId, entityView);
        }
        return treeNode;
    }

    private void doBuildRangeTreeNode(Member sourceMember, Member pMember, List<Member> members, long id, Dimension dimension, TreeNode treeNode, boolean needBuildRelScheme, Map<Long, Set<DynamicObject>> relSchemeByRangeId, long entityView) {
        String number = sourceMember.getNumber();
        String name = sourceMember.getName();
        if (members.get(0).getLevel() > pMember.getLevel()) {
            Set<DynamicObject> dynamicObjects;
            TreeNode childNode = new TreeNode();
            childNode.setId(id + "_" + sourceMember.getId());
            HashMap<String, String> data = new HashMap<String, String>(3);
            data.put("name", name);
            data.put("number", number);
            data.put("rangeId", String.valueOf(id));
            childNode.setData(data);
            childNode.setParentid(treeNode.getId());
            childNode.setText(number + "    " + name);
            childNode.setLongNumber(number);
            if (needBuildRelScheme && CollectionUtils.isNotEmpty(dynamicObjects = relSchemeByRangeId.get(sourceMember.getId()))) {
                this.addSchemeTreeNode(sourceMember.getId(), childNode, dynamicObjects);
                this.sumLeafNodeCounts(treeNode, dynamicObjects.size());
            }
            treeNode.addChild(childNode);
            return;
        }
        Long parentId = pMember.getId();
        List children = treeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            TreeNode parentNode = treeNode.getTreeNode(id + "_" + parentId);
            if (parentNode != null) {
                Set<DynamicObject> dynamicObjects;
                TreeNode childNode = new TreeNode();
                childNode.setId(id + "_" + sourceMember.getId());
                HashMap<String, String> data = new HashMap<String, String>(3);
                data.put("name", name);
                data.put("number", number);
                data.put("rangeId", String.valueOf(id));
                childNode.setData(data);
                childNode.setParentid(parentNode.getId());
                childNode.setText(number + "    " + name);
                childNode.setLongNumber(number);
                if (needBuildRelScheme && CollectionUtils.isNotEmpty(dynamicObjects = relSchemeByRangeId.get(sourceMember.getId()))) {
                    this.addSchemeTreeNode(sourceMember.getId(), childNode, dynamicObjects);
                    this.sumLeafNodeCounts(treeNode, dynamicObjects.size());
                }
                parentNode.addChild(childNode);
            } else {
                Long memberParentId = pMember.getParentId();
                Member dimensionMember = dimension.getMember(Long.valueOf(entityView), memberParentId);
                if (dimensionMember != null) {
                    this.doBuildRangeTreeNode(sourceMember, dimensionMember, members, id, dimension, treeNode, needBuildRelScheme, relSchemeByRangeId, entityView);
                } else {
                    Set<DynamicObject> dynamicObjects;
                    TreeNode childNode = new TreeNode();
                    childNode.setId(id + "_" + sourceMember.getId());
                    HashMap<String, String> data = new HashMap<String, String>(3);
                    data.put("name", name);
                    data.put("number", number);
                    data.put("rangeId", String.valueOf(id));
                    childNode.setData(data);
                    childNode.setParentid(treeNode.getId());
                    childNode.setText(number + "    " + name);
                    childNode.setLongNumber(number);
                    if (needBuildRelScheme && CollectionUtils.isNotEmpty(dynamicObjects = relSchemeByRangeId.get(sourceMember.getId()))) {
                        this.addSchemeTreeNode(sourceMember.getId(), childNode, dynamicObjects);
                        this.sumLeafNodeCounts(treeNode, dynamicObjects.size());
                    }
                    treeNode.addChild(childNode);
                }
            }
        } else {
            Set<DynamicObject> dynamicObjects;
            TreeNode childNode = new TreeNode();
            childNode.setId(id + "_" + sourceMember.getId());
            HashMap<String, String> data = new HashMap<String, String>(3);
            data.put("name", name);
            data.put("number", number);
            data.put("rangeId", String.valueOf(id));
            childNode.setData(data);
            childNode.setParentid(treeNode.getId());
            childNode.setText(number + "    " + name);
            childNode.setLongNumber(number);
            if (needBuildRelScheme && CollectionUtils.isNotEmpty(dynamicObjects = relSchemeByRangeId.get(sourceMember.getId()))) {
                this.addSchemeTreeNode(sourceMember.getId(), childNode, dynamicObjects);
                this.sumLeafNodeCounts(treeNode, dynamicObjects.size());
            }
            treeNode.addChild(childNode);
        }
    }

    public void addSchemeTreeNode(long entityId, TreeNode childNode, Set<DynamicObject> dynamicObjects) {
        String parentId = childNode.getId();
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            node.setId(entityId + "_" + dynamicObject.getLong("id"));
            String number = dynamicObject.getString("number");
            node.setLongNumber(number);
            node.setText(number + "    " + dynamicObject.getString("name"));
            node.setParentid(parentId);
            childNode.addChild(node);
        }
    }

    public Map<String, Long> getCentralRangeDimView(Long centralRangeId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)centralRangeId, (String)"eb_centralrelrange");
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        LinkedHashMap<String, Long> dimensionViewMap = new LinkedHashMap<String, Long>(entryEntity.size());
        for (DynamicObject object : entryEntity) {
            String dimensionNumber = object.getString("dimension.number");
            DynamicObject dimensionView = object.getDynamicObject("dimensionview");
            long viewId = 0L;
            if (dimensionView != null) {
                viewId = dimensionView.getLong("id");
            }
            dimensionViewMap.put(dimensionNumber, viewId);
        }
        return dimensionViewMap;
    }

    public Set<String> getCentralRangeDim(Long centralRangeId) {
        return this.getCentralRangeDimView(centralRangeId).keySet();
    }

    public Map<Long, Set<DynamicObject>> queryRelSchemeByRangeId(Long centralRangeId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_centralrelscheme", (String)"id,entity,name,number", (QFilter[])new QFilter("centralrange", "=", (Object)centralRangeId).toArray());
        HashMap<Long, Set<DynamicObject>> entitySchemeMap = new HashMap<Long, Set<DynamicObject>>(query.size());
        for (DynamicObject dynamicObject : query) {
            long entity = dynamicObject.getLong("entity");
            Set longs = entitySchemeMap.computeIfAbsent(entity, v -> new HashSet(16));
            longs.add(dynamicObject);
        }
        return entitySchemeMap;
    }

    public boolean existRelScheme(Long relSchemeId) {
        return QueryServiceHelper.exists((String)"eb_centralrelscheme", (Object)relSchemeId);
    }

    public Long getCentralRangeBizModelId(Long centralRangeId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)centralRangeId, (String)"eb_centralrelrange");
        return dynamicObject.getLong("bizmodel.id");
    }

    private void sumLeafNodeCounts(TreeNode treeNode, int schemaCounts) {
        Map rootData = (Map)treeNode.getData();
        int leafCounts = Integer.parseInt((String)rootData.get("leafCounts")) + schemaCounts;
        rootData.put("leafCounts", String.valueOf(leafCounts));
    }

    public boolean queryRelationByScheme(Set<Long> schemeIds) {
        return QueryServiceHelper.exists((String)"eb_centralrelation", (QFilter[])new QFilter("scheme", "in", schemeIds).toArray());
    }

    public void updateCentralRelationStatus(long centralRangeId) {
        QFilter qFilter = new QFilter("scheme.centralrange", "=", (Object)centralRangeId);
        qFilter.and("status", "=", (Object)"1");
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"eb_centralrelation", (String)"status", (QFilter[])qFilter.toArray());
        if (query != null && query.length > 0) {
            for (DynamicObject object : query) {
                object.set("status", (Object)0);
            }
            SaveServiceHelper.save((DynamicObject[])query);
        }
    }

    public boolean getCentralRangeStatus(Long centralRangeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)centralRangeId);
        qFilter.and("status", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"eb_centralrelrange", (QFilter[])qFilter.toArray());
    }

    public String getDefaultRelSchemeNumber(Long model, Long entity, Long centralRange) {
        Map<String, Long> centralRangeDimView = CentralRelationService.getInstance().getCentralRangeDimView(centralRange);
        Long viewId = centralRangeDimView.getOrDefault(SysDimensionEnum.Entity.getNumber(), 0L);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, entity);
        String defaultNumber = "default_" + member.getNumber() + "_1";
        QFilter qFilter = new QFilter("entity", "=", (Object)entity).and("centralrange.model", "=", (Object)model).and("number", "like", (Object)("%default_" + member.getNumber() + "%"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_centralrelscheme", (String)"entity,number,centralrange.model", (QFilter[])qFilter.toArray(), (String)"number desc");
        if (load.length > 0) {
            int order = 1;
            for (DynamicObject dynamicObject : load) {
                int index;
                String number = dynamicObject.getString("number");
                String substring = number.substring((index = number.lastIndexOf("_")) + 1);
                boolean isNumber = StringUtils.isNumeric((String)substring);
                if (!isNumber) continue;
                order = Integer.parseInt(substring) + 1;
                break;
            }
            defaultNumber = "default_" + member.getNumber() + "_" + order;
        }
        return defaultNumber;
    }

    public Map<Long, String> getCentralSchemeNames(Set<Long> schemeIds) {
        QFilter qFilter = new QFilter("id", "in", schemeIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_centralrelscheme", (String)"id,name", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            HashMap<Long, String> namesMap = new HashMap<Long, String>(query.size());
            for (DynamicObject object : query) {
                namesMap.put(object.getLong("id"), object.getString("name"));
            }
            return namesMap;
        }
        return new HashMap<Long, String>(0);
    }
}

