/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralrelation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.common.centralrelation.CentralRelation;
import kd.epm.eb.common.centralrelation.CentralRelationRecord;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.lang.StringUtils;

public class CentralRelationShotService {
    private static final Log log = LogFactory.getLog(CentralRelationShotService.class);

    public static CentralRelationShotService getInstance() {
        return new CentralRelationShotService();
    }

    public void saveCentralRelationShot(Set<Long> centralSchemeIds, Set<Long> subApproveBillIds) {
        if (CollectionUtils.isEmpty(centralSchemeIds) || CollectionUtils.isEmpty(subApproveBillIds)) {
            return;
        }
        log.info("CentralRelationService#saveCentralRelationShot: centralSchemeIds:{};subApproveBillIds:{}", (Object)SerializationUtils.toJsonString(centralSchemeIds), (Object)SerializationUtils.toJsonString(subApproveBillIds));
        Map<Long, List<CentralRelation>> centralRelationMap = CentralRelationService.getInstance().getCentralRelations(centralSchemeIds);
        if (centralRelationMap.isEmpty()) {
            return;
        }
        int toSaveRelationShotHashCode = centralRelationMap.hashCode();
        String toSaveRelationJson = SerializationUtils.toJsonString(centralRelationMap);
        Map<Long, List<CentralRelation>> centralRelationShot = this.getCentralRelationShotByHashCode(toSaveRelationShotHashCode);
        if (centralRelationShot.isEmpty()) {
            this.saveCentralRelationShotMappingAndInfo(subApproveBillIds, centralRelationMap, toSaveRelationShotHashCode);
        } else {
            String relationShotInfoJson = SerializationUtils.toJsonString(centralRelationShot);
            if (StringUtils.equals((String)toSaveRelationJson, (String)relationShotInfoJson)) {
                this.saveCentralRelationMapping(subApproveBillIds, toSaveRelationShotHashCode);
            } else {
                while (!centralRelationShot.isEmpty() && !StringUtils.equals((String)toSaveRelationJson, (String)relationShotInfoJson)) {
                    centralRelationShot = this.getCentralRelationShotByHashCode(++toSaveRelationShotHashCode);
                    relationShotInfoJson = SerializationUtils.toJsonString(centralRelationShot);
                }
                this.saveCentralRelationShotMappingAndInfo(subApproveBillIds, centralRelationMap, toSaveRelationShotHashCode);
            }
        }
        log.info("CentralRelationService#saveCentralRelationShot: toSaveRelationJson:{}", (Object)toSaveRelationJson);
    }

    public List<Map<String, List<MemberCondition>>> getCentralRelShotDimMemberInfo(Long subApproveBillId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"modelid,centralorg.id", (QFilter[])new QFilter("id", "=", (Object)subApproveBillId).toArray());
        if (object == null) {
            return new ArrayList<Map<String, List<MemberCondition>>>(0);
        }
        Map<Long, List<CentralRelation>> relationsMap = this.getCentralRelationShot(subApproveBillId);
        log.info("CentralRelationService#getCentralRelShotDimMemberInfo: relationsMap:{}", (Object)SerializationUtils.toJsonString(relationsMap));
        if (CollectionUtils.isEmpty(relationsMap)) {
            return new ArrayList<Map<String, List<MemberCondition>>>(0);
        }
        Long centralOrgId = object.getLong("centralorg.id");
        ArrayList<Map<String, List<MemberCondition>>> filters = new ArrayList<Map<String, List<MemberCondition>>>(0);
        for (Map.Entry<Long, List<CentralRelation>> relationEntry : relationsMap.entrySet()) {
            List<CentralRelation> relations = relationEntry.getValue();
            if (CollectionUtils.isEmpty(relations)) continue;
            for (CentralRelation relation : relations) {
                if (!IDUtils.equals((Object)relation.getEntityId(), (Object)centralOrgId)) continue;
                Map centralDimMemberInfo = relation.getCentralDimMemberInfo();
                if (centralDimMemberInfo == null || centralDimMemberInfo.size() == 0) {
                    filters.add(new HashMap(0));
                    continue;
                }
                HashMap condition = new HashMap(centralDimMemberInfo.size());
                for (Map.Entry entry : centralDimMemberInfo.entrySet()) {
                    condition.put(entry.getKey(), Collections.singletonList(entry.getValue()));
                }
                filters.add(condition);
            }
        }
        log.info("CentralRelationService#getCentralRelShotDimMemberInfo: return:{}", (Object)SerializationUtils.toJsonString(filters));
        return filters;
    }

    public Map<Long, List<CentralRelation>> getCentralRelationShot(Long subApproveBillId) {
        DynamicObject mapping = QueryServiceHelper.queryOne((String)"eb_centralshothashrel", (String)"shothashcode", (QFilter[])new QFilter("subapprovebill", "=", (Object)subApproveBillId).toArray());
        if (mapping == null) {
            return new HashMap<Long, List<CentralRelation>>(0);
        }
        return this.getCentralRelationShotByHashCode(mapping.getInt("shothashcode"));
    }

    private Map<Long, List<CentralRelation>> getCentralRelationShotByHashCode(int shotHashCode) {
        QFilter qFilter = new QFilter("shothashcode", "=", (Object)shotHashCode);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_centralrelation_shot", (String)"scheme,entity,meminfojson,entryseq", (QFilter[])qFilter.toArray(), (String)"scheme,entryseq");
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new HashMap<Long, List<CentralRelation>>();
        }
        HashMap<Long, List<CentralRelation>> relationsMap = new HashMap<Long, List<CentralRelation>>(query.size());
        for (DynamicObject object : query) {
            CentralRelation relation = new CentralRelation();
            Long scheme = object.getLong("scheme");
            relation.setSchemeId(scheme);
            relation.setEntityId(Long.valueOf(object.getLong("entity")));
            relation.setSeq(object.getInt("entryseq"));
            relation.setCentralDimMemberInfo(CentralRelationRecord.parseDimMemberInfoJson((String)object.getString("meminfojson")));
            List relations = relationsMap.computeIfAbsent(scheme, e -> new ArrayList());
            relations.add(relation);
        }
        return relationsMap;
    }

    private void saveCentralRelationShotMappingAndInfo(Set<Long> subApproveBillIds, Map<Long, List<CentralRelation>> centralRelationMap, int shotHashCode) {
        if (centralRelationMap.isEmpty()) {
            return;
        }
        this.saveCentralRelationMapping(subApproveBillIds, shotHashCode);
        this.saveCentralRelationShot(centralRelationMap, shotHashCode);
    }

    private void saveCentralRelationShot(Map<Long, List<CentralRelation>> centralRelationMap, int shotHashCode) {
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, List<CentralRelation>> entry : centralRelationMap.entrySet()) {
            List<CentralRelation> centralRelations = entry.getValue();
            if (CollectionUtils.isEmpty(centralRelations)) continue;
            for (CentralRelation relation : centralRelations) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralrelation_shot");
                object.set("shothashcode", (Object)shotHashCode);
                object.set("scheme", (Object)relation.getSchemeId());
                object.set("entity", (Object)relation.getEntityId());
                object.set("entryseq", (Object)relation.getSeq());
                object.set("meminfojson", (Object)relation.getCentralDimMemberInfoJson());
                relations.add(object);
            }
        }
        if (relations.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])relations.toArray(new DynamicObject[0]));
        }
    }

    private void saveCentralRelationMapping(Set<Long> subApproveBillIds, int shotHashCode) {
        if (CollectionUtils.isEmpty(subApproveBillIds)) {
            return;
        }
        DeleteServiceHelper.delete((String)"eb_centralshothashrel", (QFilter[])new QFilter("subapprovebill", "in", subApproveBillIds).toArray());
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(subApproveBillIds.size());
        Long userId = UserUtils.getUserId();
        for (Long subApproveBillId : subApproveBillIds) {
            DynamicObject shotMapping = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralshothashrel");
            shotMapping.set("subapprovebill", (Object)subApproveBillId);
            shotMapping.set("shothashcode", (Object)shotHashCode);
            shotMapping.set("creater", (Object)userId);
            objects.add(shotMapping);
        }
        SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
    }

    public Set<String> getCentralRelDimInfo(Long subApproveBillId) {
        List<Map<String, List<MemberCondition>>> centralRelShotDimMemberInfo = this.getCentralRelShotDimMemberInfo(subApproveBillId);
        HashSet<String> dimNumberSet = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(centralRelShotDimMemberInfo)) {
            return dimNumberSet;
        }
        for (Map<String, List<MemberCondition>> dimMap : centralRelShotDimMemberInfo) {
            for (Map.Entry<String, List<MemberCondition>> entry : dimMap.entrySet()) {
                if (!CollectionUtils.isNotEmpty((Collection)entry.getValue())) continue;
                dimNumberSet.add(entry.getKey());
            }
        }
        return dimNumberSet;
    }
}

