/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.check;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.ebupgrades.utils.PermUpgradesUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.eventbus.event.FactoryChangeEvent;
import kd.epm.eb.common.message.MessageUtils;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.impl.ShrekMember;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;

public class BudgetMemFactoryCheckListener {
    private static final Log log = LogFactory.getLog(BudgetMemFactoryCheckListener.class);

    public static BudgetMemFactoryCheckListener getInstance() {
        return new BudgetMemFactoryCheckListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void memberChangeListener(FactoryChangeEvent event) {
        LogStats stats = new LogStats("budget-factory-check-log:");
        stats.addInfo("begin-memberChangeListener.");
        if (StringUtils.isNotEmpty((String)event.getTraceId())) {
            stats.addInfo("traceId=" + event.getTraceId());
        }
        try {
            this.$memberChangeListener(event, stats);
        }
        catch (Exception ex) {
            log.error("memberChangeListener", (Throwable)ex);
        }
        finally {
            ModelCacheContext.remove();
            MemberPropCacheService.remove();
            stats.addInfo("end-memberChangeListener.");
            log.info(stats.toString());
        }
    }

    private void $memberChangeListener(FactoryChangeEvent event, LogStats stats) {
        if (event.getMemberIds() == null || event.getMemberIds().isEmpty()) {
            stats.addInfo("memberIds is null.");
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)event.getModelId());
        if (modelCacheHelper.getModelobj().isModelByEB()) {
            stats.addInfo("model is eb type.");
            return;
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)event.getModelId(), (String)"epm_model");
        if (model == null) {
            stats.addInfo("model is null. please check.");
            return;
        }
        Dimension dimension = modelCacheHelper.getDimension(event.getDimensionId());
        if (dimension == null) {
            stats.addInfo("dimension is null. please check.");
            return;
        }
        HashSet<String> members = new HashSet<String>(event.getMemberIds().size());
        for (Long _memberId : event.getMemberIds()) {
            if (IDUtils.isNull((Long)_memberId)) {
                stats.addInfo("memberIds is null.");
                continue;
            }
            Member member = dimension.getMember(event.getViewId(), _memberId);
            if (member == null) {
                stats.addInfo("member or parent is null. please check. memberId=" + _memberId);
                return;
            }
            members.add(member.getNumber());
        }
        if (members.isEmpty()) {
            stats.addInfo("member Number is null.");
            return;
        }
        List datasets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)dimension.getNumber());
        if (datasets.isEmpty()) {
            stats.addInfo("datasets is null.");
            return;
        }
        ShrekMember shrekMember = new ShrekMember();
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)modelCacheHelper.getModelobj());
        Map dimErrors = shrekMember.verifyMemberFactors(modelCacheHelper, datasets, dimension.getNumber(), members, true, config);
        if (dimErrors != null && !dimErrors.isEmpty()) {
            Map<Long, List<Long>> manageUserIds;
            List<Long> manages;
            String errorInfo = JSON.toJSONString((Object)dimErrors);
            log.warn(errorInfo);
            HashSet receivers = Sets.newHashSetWithExpectedSize((int)16);
            Long creator = modelCacheHelper.getModelobj().getCreator();
            if (IDUtils.isNotNull((Long)creator)) {
                receivers.add(creator);
            }
            if ((manages = (manageUserIds = PermUpgradesUtil.getInstance().getModelManagers(Collections.singletonList(event.getModelId()))).get(event.getModelId())) != null && !manages.isEmpty()) {
                receivers.addAll(manages);
            }
            if (!receivers.isEmpty()) {
                String title = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u68c0\u67e5\u901a\u77e5", (String)"BudgetMemFactoryCheckListener_0", (String)"epm-eb-business", (Object[])new Object[0]);
                ArrayList contexts = Lists.newArrayListWithExpectedSize((int)dimErrors.size());
                String modelStr = modelCacheHelper.getModelobj().getNumber() + '-' + modelCacheHelper.getModelobj().getName();
                String dimStr = dimension.getNumber() + '-' + dimension.getName();
                Map<String, Dataset> datasetMap = datasets.stream().collect(Collectors.toMap(Dataset::getNumber, Dataset2 -> Dataset2));
                for (Map.Entry _dataset : dimErrors.entrySet()) {
                    Dataset dataset = datasetMap.get(_dataset.getKey());
                    DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)dataset.getId(), (String)"eb_dataset", (String)"id,number,name");
                    String datasetStr = object != null ? object.getString("number") + '-' + object.getString("name") : (String)_dataset.getKey();
                    String context = ResManager.loadResFormat((String)"\u5728(%1)\u4f53\u7cfb (%2)\u6570\u636e\u96c6 (%3)\u7ef4\u5ea6\u4e0b\u68c0\u6d4b\u5230\u7f16\u7801\u4e3a(%4)\u7ef4\u5ea6\u6210\u5458\u7684\u8ba1\u7b97\u56e0\u5b50\u4e0d\u6b63\u786e", (String)"BudgetMemFactoryCheckListener_1", (String)"epm-eb-business", (Object[])new Object[]{modelStr, datasetStr, dimStr, JSON.toJSONString(_dataset.getValue())});
                    contexts.add(context);
                }
                contexts.add(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u3002", (String)"BudgetMemFactoryCheckListener_2", (String)"epm-eb-business", (Object[])new Object[0]));
                MessageUtils.get().sendMessage(dimension.getMemberModel(), title, StringUtils.join((Collection)contexts, (char)'\uff0c'), new ArrayList(receivers), MessageUtils.MessageType.YUNZHIJIA);
            }
        }
    }
}

