/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.combinoffset;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.combinoffset.AmountWithDC;
import kd.epm.eb.business.combinoffset.OffsetRule;
import kd.epm.eb.common.cache.impl.AccountMember;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.ebcommon.common.enums.AccountDirectionEnum;
import kd.epm.eb.common.enums.OffsetSourceEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.VarhandleEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.jetbrains.annotations.NotNull;

public class OffsetEntry {
    private Long id;
    private String number;
    private String status;
    private Long modelid;
    private Long busmodelid;
    private Long versionid;
    private Long datatypeid;
    private Long periodid;
    private Long audittrailid;
    private Long currencyid;
    private Long metricid = 0L;
    private Long metricqtyid = 0L;
    private Long changetypeid;
    private Long offsetruleid;
    private Long cslorgid;
    private Long offsetorgid;
    private String offsetcatalog;
    private VarhandleEnum varhandle = null;
    private AccountMember varaccount = null;
    private Long selfdim1id = 0L;
    private Long selfdim2id = 0L;
    private Long selfdim3id = 0L;
    private Long selfdim4id = 0L;
    private Long selfdim5id = 0L;
    private Long selfdim6id = 0L;
    private Long creatorid;
    private Date createtime;
    private Long modifierid;
    private Date modifytime;
    Map<Long, Integer> accountDCMap = null;
    Map<String, String> fieldMap = null;
    private List<Detail> details = new ArrayList<Detail>(16);
    protected static final Log log = LogFactory.getLog(OffsetEntry.class);
    private OffsetRule offsetRule;
    private boolean unilateral = false;

    public OffsetRule getOffsetRule() {
        return this.offsetRule;
    }

    public OffsetEntry(@NotNull OffsetRule offsetRule) {
        this.offsetRule = offsetRule;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCslorgid() {
        return this.cslorgid;
    }

    public void setCslorgid(Long cslorgid) {
        this.cslorgid = cslorgid;
    }

    public Long getOffsetorgid() {
        return this.offsetorgid;
    }

    public void setOffsetorgid(Long offsetorgid) {
        this.offsetorgid = offsetorgid;
    }

    public String getOffsetcatalog() {
        return this.offsetcatalog;
    }

    public void setOffsetcatalog(String offsetcatalog) {
        this.offsetcatalog = offsetcatalog;
    }

    public Long getOffsetruleid() {
        return this.offsetruleid;
    }

    public void setOffsetruleid(Long offsetruleid) {
        this.offsetruleid = offsetruleid;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getModelid() {
        return this.modelid;
    }

    public void setModelid(Long modelid) {
        this.modelid = modelid;
    }

    public Long getBusmodelid() {
        return this.busmodelid;
    }

    public void setBusmodelid(Long busmodelid) {
        this.busmodelid = busmodelid;
    }

    public Long getVersionid() {
        return this.versionid;
    }

    public void setVersionid(Long versionid) {
        this.versionid = versionid;
    }

    public Long getDatatypeid() {
        return this.datatypeid;
    }

    public void setDatatypeid(Long datatypeid) {
        this.datatypeid = datatypeid;
    }

    public Long getPeriodid() {
        return this.periodid;
    }

    public void setPeriodid(Long periodid) {
        this.periodid = periodid;
    }

    public Long getAudittrailid() {
        return this.audittrailid;
    }

    public void setAudittrailid(Long audittrailid) {
        this.audittrailid = audittrailid;
    }

    public Long getCurrencyid() {
        return this.currencyid;
    }

    public void setCurrencyid(Long currencyid) {
        this.currencyid = currencyid;
    }

    public Long getMetricid() {
        return this.metricid;
    }

    public void setMetricid(Long metricid) {
        this.metricid = metricid;
    }

    public Long getMetricqtyid() {
        return this.metricqtyid;
    }

    public void setMetricqtyid(Long metricqtyid) {
        this.metricqtyid = metricqtyid;
    }

    public Long getChangetypeid() {
        return this.changetypeid;
    }

    public void setChangetypeid(Long changetypeid) {
        this.changetypeid = changetypeid;
    }

    public Long getSelfdim1id() {
        return this.selfdim1id;
    }

    public void setSelfdim1id(Long selfdim1id) {
        this.selfdim1id = selfdim1id;
    }

    public Long getSelfdim2id() {
        return this.selfdim2id;
    }

    public void setSelfdim2id(Long selfdim2id) {
        this.selfdim2id = selfdim2id;
    }

    public Long getSelfdim3id() {
        return this.selfdim3id;
    }

    public void setSelfdim3id(Long selfdim3id) {
        this.selfdim3id = selfdim3id;
    }

    public Long getSelfdim4id() {
        return this.selfdim4id;
    }

    public void setSelfdim4id(Long selfdim4id) {
        this.selfdim4id = selfdim4id;
    }

    public Long getSelfdim5id() {
        return this.selfdim5id;
    }

    public void setSelfdim5id(Long selfdim5id) {
        this.selfdim5id = selfdim5id;
    }

    public Long getSelfdim6id() {
        return this.selfdim6id;
    }

    public void setSelfdim6id(Long selfdim6id) {
        this.selfdim6id = selfdim6id;
    }

    public Long getCreatorid() {
        return this.creatorid;
    }

    public void setCreatorid(Long creatorid) {
        this.creatorid = creatorid;
    }

    public Date getCreatetime() {
        return this.createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    public Long getModifierid() {
        return this.modifierid;
    }

    public void setModifierid(Long modifierid) {
        this.modifierid = modifierid;
    }

    public Date getModifytime() {
        return this.modifytime;
    }

    public void setModifytime(Date modifytime) {
        this.modifytime = modifytime;
    }

    public List<Detail> getDetails() {
        return this.details;
    }

    public void setDetails(List<Detail> details) {
        this.details = details;
    }

    public Detail addOrUpdateDetail(Long myorgid, Long interorgid, Long accountid, Long datasetid, OffsetSourceEnum source, BigDecimal amount, BigDecimal amoutqty) {
        if (myorgid == null || interorgid == null || accountid == null || source == null) {
            return null;
        }
        if (amount == null && amoutqty == null) {
            return null;
        }
        Detail detail = null;
        for (Detail d : this.getDetails()) {
            if (d.getSource() != source || !accountid.equals(d.accountid) || !myorgid.equals(d.myorgid) || !interorgid.equals(d.interorgid)) continue;
            detail = d;
            break;
        }
        if (detail == null || this.getDetails().stream().noneMatch(e -> e.getMyorgid().equals(myorgid) && e.getInterorgid().equals(interorgid))) {
            detail = new Detail();
            detail.setMyorgid(myorgid);
            detail.setInterorgid(interorgid);
            detail.setAccountid(accountid);
            detail.setDatasetid(datasetid);
            detail.setSource(source);
            this.getDetails().add(detail);
        }
        if (amount != null) {
            detail.setAmount(detail.getAmount().add(amount));
        }
        if (amoutqty != null) {
            detail.setAmountqty(detail.getAmountqty().add(amoutqty));
        }
        return detail;
    }

    public void addDetail(Long myorgid, Long interorgid, Long accountid, Long datasetid, OffsetSourceEnum source, BigDecimal amount, BigDecimal amoutqty) {
        if (myorgid == null || interorgid == null || accountid == null || source == null) {
            return;
        }
        if (amount == null && amoutqty == null) {
            return;
        }
        Detail detail = new Detail();
        detail.setMyorgid(myorgid);
        detail.setInterorgid(interorgid);
        detail.setAccountid(accountid);
        detail.setDatasetid(datasetid);
        detail.setSource(source);
        this.getDetails().add(detail);
        if (amount != null) {
            detail.setAmount(detail.getAmount().add(amount));
        }
        if (amoutqty != null) {
            detail.setAmountqty(detail.getAmountqty().add(amoutqty));
        }
    }

    public AmountWithDC sumSenderAmount() {
        return this.sumAmount(OffsetSourceEnum.SENDER);
    }

    public AmountWithDC sumRecvAmount() {
        return this.sumAmount(OffsetSourceEnum.RECEIVER);
    }

    public AmountWithDC sumAmount(OffsetSourceEnum source) {
        AmountWithDC sumAmount = null;
        if (this.getDetails() != null) {
            for (Detail detail : this.getDetails()) {
                if (detail.getSource() != source) continue;
                if (sumAmount == null) {
                    sumAmount = new AmountWithDC(AccountDirectionEnum.getEnum((int)this.getAccountDC(detail.getAccountid())), detail.getAmount());
                    continue;
                }
                sumAmount = sumAmount.add(new AmountWithDC(AccountDirectionEnum.getEnum((int)this.getAccountDC(detail.getAccountid())), detail.getAmount()));
            }
        }
        if (sumAmount == null && this.getOffsetRule().isUnilateral()) {
            AccountDirectionEnum driection = null;
            for (Detail detail : this.getDetails()) {
                if (detail.getSource() == source) continue;
                driection = AccountDirectionEnum.getEnum((int)this.getAccountDC(detail.getAccountid()));
                break;
            }
            if (driection == AccountDirectionEnum.DEBIT) {
                sumAmount = new AmountWithDC(AccountDirectionEnum.CREDIT, BigDecimal.ZERO);
            } else if (driection == AccountDirectionEnum.CREDIT) {
                sumAmount = new AmountWithDC(AccountDirectionEnum.DEBIT, BigDecimal.ZERO);
            }
        }
        return sumAmount;
    }

    public BigDecimal sumSenderAmountQty() {
        BigDecimal sumQty = BigDecimal.ZERO;
        if (this.getDetails() != null) {
            for (Detail detail : this.getDetails()) {
                if (OffsetSourceEnum.SENDER != detail.getSource()) continue;
                sumQty = sumQty.add(detail.getAmountqty());
            }
        }
        return sumQty;
    }

    public BigDecimal sumRecvAmountQty() {
        BigDecimal sumQty = BigDecimal.ZERO;
        if (this.getDetails() != null) {
            for (Detail detail : this.getDetails()) {
                if (OffsetSourceEnum.RECEIVER != detail.getSource()) continue;
                sumQty = sumQty.add(detail.getAmountqty());
            }
        }
        return sumQty;
    }

    public boolean checkAmountBalance() {
        boolean hasDiff = false;
        if (this.getDetails() != null) {
            BigDecimal senderSum = BigDecimal.ZERO;
            BigDecimal recvSum = BigDecimal.ZERO;
            BigDecimal balance = null;
            for (Detail detail : this.getDetails()) {
                if (OffsetSourceEnum.SENDER == detail.getSource()) {
                    if (this.getAccountDC(detail.getAccountid()) == 6) {
                        senderSum = senderSum.subtract(detail.getAmount());
                        continue;
                    }
                    senderSum = senderSum.add(detail.getAmount());
                    continue;
                }
                if (this.getAccountDC(detail.getAccountid()) == 6) {
                    recvSum = recvSum.subtract(detail.getAmount());
                    continue;
                }
                recvSum = recvSum.add(detail.getAmount());
            }
            balance = senderSum.add(recvSum);
            return balance.compareTo(BigDecimal.ZERO) == 0;
        }
        return hasDiff;
    }

    public void handleDiff() {
        if (this.getDetails() == null || this.getDetails().isEmpty() || this.varhandle == null) {
            return;
        }
        log.info("\u5dee\u5f02\u5904\u7406:" + this.getVarhandle());
        if (VarhandleEnum.SPECIFYACCOUNT == this.getVarhandle()) {
            this.handleDiffSpecifyAccount();
            return;
        }
        AmountWithDC sumSenderAmount = this.sumSenderAmount();
        AmountWithDC sumRecvAmount = this.sumRecvAmount();
        BigDecimal sumSenderAmountQty = this.sumSenderAmountQty();
        BigDecimal sumRecvAmountQty = this.sumRecvAmountQty();
        BigDecimal diffAmount = BigDecimal.ZERO;
        BigDecimal diffAmountQty = BigDecimal.ZERO;
        boolean diffAmountAddToSender = false;
        boolean diffQtyAddToSender = false;
        if (sumSenderAmount != null && sumRecvAmount != null) {
            if (VarhandleEnum.USEBIG == this.getVarhandle()) {
                if (sumSenderAmount.getAmount().compareTo(sumRecvAmount.getAmount()) < 0) {
                    diffAmount = sumRecvAmount.getAmount().subtract(sumSenderAmount.getAmount());
                    diffAmountAddToSender = true;
                } else {
                    diffAmount = sumSenderAmount.getAmount().subtract(sumRecvAmount.getAmount());
                }
            } else if (sumSenderAmount.getAmount().compareTo(sumRecvAmount.getAmount()) > 0) {
                diffAmount = sumRecvAmount.getAmount().subtract(sumSenderAmount.getAmount());
                diffAmountAddToSender = true;
            } else {
                diffAmount = sumSenderAmount.getAmount().subtract(sumRecvAmount.getAmount());
            }
        }
        if (sumSenderAmountQty != null && sumRecvAmountQty != null) {
            if (VarhandleEnum.USEBIG == this.getVarhandle()) {
                if (sumSenderAmountQty.compareTo(sumRecvAmountQty) < 0) {
                    diffAmountQty = sumRecvAmountQty.subtract(sumSenderAmountQty);
                    diffQtyAddToSender = true;
                } else {
                    diffAmountQty = sumSenderAmountQty.subtract(sumRecvAmountQty);
                }
            } else if (sumSenderAmountQty.compareTo(sumRecvAmountQty) > 0) {
                diffAmountQty = sumRecvAmountQty.subtract(sumSenderAmountQty);
                diffQtyAddToSender = true;
            } else {
                diffAmountQty = sumSenderAmountQty.subtract(sumRecvAmountQty);
            }
        }
        boolean amountHandled = IDUtils.isNull((Long)this.metricid);
        boolean qtyHandled = IDUtils.isNull((Long)this.metricqtyid);
        for (Detail e : this.getDetails()) {
            if (diffAmountAddToSender && OffsetSourceEnum.SENDER == e.getSource() && !amountHandled) {
                e.setAmount(e.getAmount().add(diffAmount));
                amountHandled = true;
            }
            if (diffQtyAddToSender && OffsetSourceEnum.SENDER == e.getSource() && !qtyHandled) {
                e.setAmountqty(e.getAmountqty().add(diffAmountQty));
                qtyHandled = true;
            }
            if (!diffAmountAddToSender && OffsetSourceEnum.RECEIVER == e.getSource() && !amountHandled) {
                e.setAmount(e.getAmount().add(diffAmount));
                amountHandled = true;
            }
            if (!diffQtyAddToSender && OffsetSourceEnum.RECEIVER == e.getSource() && !qtyHandled) {
                e.setAmountqty(e.getAmountqty().add(diffAmountQty));
                qtyHandled = true;
            }
            if (!amountHandled || !qtyHandled) continue;
            break;
        }
    }

    public void handleDiffSpecifyAccount() {
        Detail detail;
        if (this.getDetails() == null || this.getDetails().isEmpty()) {
            return;
        }
        AmountWithDC sumSenderAmount = this.sumSenderAmount();
        AmountWithDC sumRecvAmount = this.sumRecvAmount();
        BigDecimal sumSenderAmountQty = this.sumSenderAmountQty();
        BigDecimal sumRecvAmountQty = this.sumRecvAmountQty();
        BigDecimal diffAmount = BigDecimal.ZERO;
        BigDecimal diffAmountQty = BigDecimal.ZERO;
        boolean diffAmountAddToSender = false;
        boolean diffQtyAddToSender = false;
        AccountMember varAccount = this.getVaraccount();
        if (varAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9519\u8bef\uff0c\u672a\u6307\u5b9a\u5dee\u989d\u9879\u79d1\u76ee\u3002", (String)"OffsetExecutor_20", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        boolean hasAmount = IDUtils.isNotNull((Long)this.metricid);
        boolean hasQty = IDUtils.isNotNull((Long)this.metricqtyid);
        if (hasAmount) {
            if (sumSenderAmount.getDirection().getIndex() == this.getAccountDC(varAccount.getId()).intValue()) {
                diffAmountAddToSender = true;
                diffAmount = sumRecvAmount.getAmount().subtract(sumSenderAmount.getAmount());
            } else {
                diffAmountAddToSender = false;
                diffAmount = sumSenderAmount.getAmount().subtract(sumRecvAmount.getAmount());
            }
        }
        if (hasAmount && !BigDecimal.ZERO.equals(diffAmount)) {
            detail = null;
            detail = diffAmountAddToSender ? this.getDetails().stream().filter(d -> d.getSource() == OffsetSourceEnum.SENDER).findFirst().get() : this.getDetails().stream().filter(d -> d.getSource() == OffsetSourceEnum.RECEIVER).findFirst().get();
            if (detail != null) {
                this.addDetail(detail.getMyorgid(), detail.getInterorgid(), varAccount.getId(), varAccount.getDatasetId(), diffAmountAddToSender ? OffsetSourceEnum.SENDER : OffsetSourceEnum.RECEIVER, diffAmount, null);
            }
        }
        if (hasQty && sumSenderAmountQty != null && sumRecvAmountQty != null) {
            if (sumSenderAmountQty.compareTo(sumRecvAmountQty) < 0) {
                diffQtyAddToSender = true;
                diffAmountQty = sumRecvAmountQty.subtract(sumSenderAmountQty);
            } else {
                diffQtyAddToSender = false;
                diffAmountQty = sumSenderAmountQty.subtract(sumRecvAmountQty);
            }
        }
        if (hasQty && !BigDecimal.ZERO.equals(diffAmountQty)) {
            detail = null;
            detail = diffQtyAddToSender ? this.getDetails().stream().filter(d -> d.getSource() == OffsetSourceEnum.SENDER).findFirst().get() : this.getDetails().stream().filter(d -> d.getSource() == OffsetSourceEnum.RECEIVER).findFirst().get();
            if (detail != null) {
                this.addDetail(detail.getMyorgid(), detail.getInterorgid(), varAccount.getId(), varAccount.getDatasetId(), diffQtyAddToSender ? OffsetSourceEnum.SENDER : OffsetSourceEnum.RECEIVER, null, diffAmountQty);
            }
        }
    }

    public void printDetails() {
        this.getDetails().forEach(e -> log.info("\u7ec4\u7ec7ID=" + e.getMyorgid() + "\uff0c\u5f80\u6765\u7ec4\u7ec7ID=" + e.getInterorgid() + "\uff0c\u79d1\u76ee=" + e.getAccountid() + "\uff0c\u91d1\u989d=" + e.getAmount() + "\uff0c\u6570\u91cf=" + e.getAmountqty()));
    }

    public boolean hasSenderDetail() {
        for (Detail d : this.getDetails()) {
            if (OffsetSourceEnum.SENDER != d.getSource()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRecvDetail() {
        for (Detail d : this.getDetails()) {
            if (OffsetSourceEnum.RECEIVER != d.getSource()) continue;
            return true;
        }
        return false;
    }

    public Detail getDetailByAccount(Long accountid) {
        if (this.getDetails() != null && accountid != null) {
            for (Detail detail : this.getDetails()) {
                if (!accountid.equals(detail.getAccountid())) continue;
                return detail;
            }
        }
        return null;
    }

    public void setAccountDCMap(Map<Long, Integer> accountDCMap) {
        this.accountDCMap = accountDCMap;
    }

    public Integer getAccountDC(Long accountId) {
        DynamicObject dynamicObject;
        if (this.accountDCMap != null && this.accountDCMap.containsKey(accountId)) {
            return this.accountDCMap.get(accountId);
        }
        if (this.accountDCMap == null) {
            this.accountDCMap = new HashMap<Long, Integer>(16);
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)SysDimensionEnum.Account.getMemberTreemodel(), (String)"drcrdirect")) != null) {
            int direct = dynamicObject.getInt("drcrdirect");
            this.accountDCMap.put(accountId, direct);
            return direct;
        }
        return AccountDirectionEnum.NONE.getIndex();
    }

    public Map<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(Map<String, String> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public VarhandleEnum getVarhandle() {
        DynamicObject dynamicObject;
        if (this.varhandle == null && IDUtils.isNotNull((Long)this.offsetruleid) && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)this.offsetruleid, (String)"eb_offsetrule", (String)"varhandle")) != null) {
            this.varhandle = VarhandleEnum.valueOf((int)dynamicObject.getInt("varhandle"));
        }
        return this.varhandle;
    }

    public void setVarhandle(VarhandleEnum varhandle) {
        this.varhandle = varhandle;
    }

    public AccountMember getVaraccount() {
        DynamicObject ruleObject;
        if (this.varaccount == null && (ruleObject = BusinessDataServiceHelper.loadSingleFromCache((Object)this.offsetruleid, (String)"eb_offsetrule")) != null) {
            this.varaccount = new AccountMember();
            Dimension dimension = new Dimension();
            dimension.setNumber(SysDimensionEnum.Account.getNumber());
            this.varaccount.setId(Long.valueOf(ruleObject.getLong("varaccount.id")));
            this.varaccount.setDimension(dimension);
            this.varaccount.setNumber(ruleObject.getString("varaccount.number"));
            this.varaccount.setName(ruleObject.getString("varaccount.name"));
            this.varaccount.setDirection(ruleObject.getInt("varaccount.drcrdirect"));
            this.varaccount.setDatasetId(Long.valueOf(ruleObject.getLong("varaccount.dataset.id")));
        }
        return this.varaccount;
    }

    public void setVaraccount(AccountMember varaccount) {
        this.varaccount = varaccount;
    }

    public void setUnilateral(boolean unilateral) {
        this.unilateral = unilateral;
    }

    public boolean isUnilateral() {
        return this.unilateral;
    }

    public static class Detail {
        private Long myorgid;
        private Long interorgid;
        private Long accountid;
        private OffsetSourceEnum source;
        private BigDecimal amount = BigDecimal.ZERO;
        private BigDecimal amountqty = BigDecimal.ZERO;
        private Long datasetid;

        public Detail() {
        }

        public Detail(Long myorgid, Long interorgid, Long accountid, OffsetSourceEnum source, BigDecimal amount, BigDecimal amountqty, Long datasetid) {
            this.myorgid = myorgid;
            this.interorgid = interorgid;
            this.accountid = accountid;
            this.source = source;
            this.amount = amount;
            this.amountqty = amountqty;
            this.datasetid = datasetid;
        }

        public Long getMyorgid() {
            return this.myorgid;
        }

        public void setMyorgid(Long myorgid) {
            this.myorgid = myorgid;
        }

        public Long getInterorgid() {
            return this.interorgid;
        }

        public void setInterorgid(Long interorgid) {
            this.interorgid = interorgid;
        }

        public Long getAccountid() {
            return this.accountid;
        }

        public void setAccountid(Long accountid) {
            this.accountid = accountid;
        }

        public OffsetSourceEnum getSource() {
            return this.source;
        }

        public void setSource(OffsetSourceEnum source) {
            this.source = source;
        }

        public Long getDatasetid() {
            return this.datasetid;
        }

        public void setDatasetid(Long datasetid) {
            this.datasetid = datasetid;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public BigDecimal getAmount(boolean isMoneyMetric) {
            if (isMoneyMetric) {
                return this.amount;
            }
            return this.amountqty;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getAmountqty() {
            return this.amountqty;
        }

        public void setAmountqty(BigDecimal amountqty) {
            this.amountqty = amountqty;
        }

        public void setAmount(BigDecimal amount, Boolean isMonyMetric) {
            if (isMonyMetric.booleanValue()) {
                this.amount = amount;
            } else {
                this.amountqty = amount;
            }
        }
    }
}

