/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.combinoffset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.combinoffset.OffsetExecuteParam;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.AccountMember;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.QFBuilder;

public class OffsetExecuteContext {
    private OffsetExecuteParam param;
    private DynamicObject busModelObject = null;
    private Map<String, Pair<String, String[]>> scopes = new HashMap<String, Pair<String, String[]>>(16);
    private Map<String, Map<String, Long>> numberIdMapped = new HashMap<String, Map<String, Long>>(16);
    private Map<Long, String> id2NumberMap = new HashMap<Long, String>(16);
    private List<String> userDefineDims = new ArrayList<String>(16);
    private Map<String, String> fieldMapped = new HashMap<String, String>(16);
    private Set<AccountMember> allAccounts = new HashSet<AccountMember>(16);
    private Map<Long, Integer> accountDCMap = null;
    private Map<String, Long> dimemsionViews = null;
    private Map<String, String> orgNum2LongNum = new HashMap<String, String>();
    private Map<String, String> org2InterOrgMap = new HashMap<String, String>(16);
    private Set<String> leafOrgNumbers = new HashSet<String>(16);

    public OffsetExecuteContext(OffsetExecuteParam param) {
        this.param = param;
    }

    public void cacheMemb(String dimNumber, String membNumber, Long id) {
        Map<Object, Object> map;
        if (this.numberIdMapped.containsKey(dimNumber)) {
            map = this.numberIdMapped.get(dimNumber);
        } else {
            map = new HashMap(16);
            this.numberIdMapped.put(dimNumber, map);
        }
        this.id2NumberMap.put(id, membNumber);
        map.put(membNumber, id);
    }

    public Long getMembIdFromCache(String dimNumber, String membNumber) {
        if (membNumber == null || membNumber.isEmpty()) {
            return null;
        }
        Map<String, Long> numberIdMapped = this.getNumberIdMapped().get(dimNumber);
        if (numberIdMapped == null) {
            numberIdMapped = new HashMap<String, Long>();
            this.getNumberIdMapped().put(dimNumber, numberIdMapped);
        }
        if (numberIdMapped.containsKey(membNumber)) {
            return numberIdMapped.get(membNumber);
        }
        List<Pair<String, Long>> pairs = this.queryMemberInfo(this.param.getModelID(), dimNumber, new String[]{membNumber});
        if (pairs != null && pairs.size() == 1) {
            numberIdMapped.put((String)pairs.get((int)0).p1, (Long)pairs.get((int)0).p2);
            this.getId2NumberMap().put((Long)pairs.get((int)0).p2, (String)pairs.get((int)0).p1);
            return (Long)pairs.get((int)0).p2;
        }
        return null;
    }

    public List<Pair<String, Long>> queryMemberInfo(Long modelId, String dimNumber, String[] membNumber) {
        String selectFields = "id, number";
        QFBuilder qfbuilder = new QFBuilder();
        qfbuilder.add("model.id", "=", (Object)modelId);
        qfbuilder.add("number", "in", (Object)membNumber);
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qfbuilder.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        }
        String entity = "";
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            entity = "epm_accountmembertree";
        } else if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            entity = "epm_entitymembertree";
        } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
            entity = "epm_bperiodmembertree";
        } else if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
            entity = "epm_changetypemembertree";
        } else if (SysDimensionEnum.Currency.getNumber().equals(dimNumber)) {
            entity = "epm_currencymembertree";
        } else if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
            entity = "epm_audittrialmembertree";
        } else if (SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber)) {
            entity = "epm_icmembertree";
        } else if (SysDimensionEnum.DataType.getNumber().equals(dimNumber)) {
            entity = "epm_datatypemembertree";
        } else if (SysDimensionEnum.Version.getNumber().equals(dimNumber)) {
            entity = "epm_versionmembertree";
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            entity = "epm_metricmembertree";
        } else {
            entity = "epm_userdefinedmembertree";
            qfbuilder.add("dimension.number", "=", (Object)dimNumber);
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])qfbuilder.toArray());
        ArrayList<Pair<String, Long>> pairs = new ArrayList<Pair<String, Long>>(16);
        doc.forEach(e -> pairs.add(Pair.onePair((Object)e.getString("number"), (Object)e.getLong("id"))));
        return pairs;
    }

    public String id2Number(Long id) {
        return this.id2NumberMap.get(id);
    }

    public Map<String, Map<String, Long>> getNumberIdMapped() {
        return this.numberIdMapped;
    }

    public Map<Long, String> getId2NumberMap() {
        return this.id2NumberMap;
    }

    public OffsetExecuteParam getParam() {
        return this.param;
    }

    public Set<AccountMember> getAllAccounts() {
        return this.allAccounts;
    }

    public Map<Long, Integer> getAccountDCMap() {
        if (this.accountDCMap == null) {
            this.accountDCMap = new HashMap<Long, Integer>(this.allAccounts.size());
            for (AccountMember accountMember : this.allAccounts) {
                this.accountDCMap.put(accountMember.getId(), accountMember.getDirection());
            }
        }
        return this.accountDCMap;
    }

    public Map<String, String> getFieldMapped() {
        return this.fieldMapped;
    }

    public void setFieldMapped(Map<String, String> fieldMapped) {
        this.fieldMapped = fieldMapped;
    }

    public List<String> getUserDefineDims() {
        return this.userDefineDims;
    }

    public void setUserDefineDims(List<String> userDefineDims) {
        this.userDefineDims = userDefineDims;
    }

    public Map<String, String> getOrgNum2LongNum() {
        return this.orgNum2LongNum;
    }

    public Map<String, String> getOrg2InterOrgMap() {
        return this.org2InterOrgMap;
    }

    public Set<String> getLeafOrgNumbers() {
        return this.leafOrgNumbers;
    }

    public void setLeafOrgNumbers(Set<String> leafOrgNumbers) {
        this.leafOrgNumbers = leafOrgNumbers;
    }

    public Map<String, Long> getDimemsionViews() {
        if (this.dimemsionViews == null) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.param.getModelID());
            this.dimemsionViews = modelCache.getViewsByBusModel(this.param.getBusmodelID());
        }
        return this.dimemsionViews;
    }

    public void addScope(String dimNum, Pair<String, String[]> scope) {
        this.scopes.put(dimNum, scope);
    }

    public Map<String, Pair<String, String[]>> getScopes() {
        return this.scopes;
    }

    public DynamicObject getBusModelObject() {
        if (this.busModelObject == null) {
            this.busModelObject = BusinessDataServiceHelper.loadSingleFromCache((Object)this.param.getBusmodelID(), (String)"eb_businessmodel");
        }
        return this.busModelObject;
    }
}

