/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.combinoffset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OffsetExecuteParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long modelID;
    private Long busmodelID;
    private String datatype;
    private String version;
    private Date startDate;
    private Date endDate;
    private Long viewId;
    private List<String> orgs;
    private Map<String, List<String>> yearPeriodMap = new HashMap<String, List<String>>(16);

    public OffsetExecuteParam() {
    }

    public OffsetExecuteParam(Long modelID, String datatype, String version, Date startDate, Date endDate, Long viewId, List<String> orgs) {
        this.modelID = modelID;
        this.datatype = datatype;
        this.version = version;
        this.startDate = startDate;
        this.endDate = endDate;
        this.viewId = viewId;
        this.orgs = orgs;
        this.initYearPeriod();
    }

    public OffsetExecuteParam(Long modelID, Long busmodelID, String datatype, String version, Date startDate, Date endDate, Long viewId, List<String> orgs) {
        this.modelID = modelID;
        this.busmodelID = busmodelID;
        this.datatype = datatype;
        this.version = version;
        this.startDate = startDate;
        this.endDate = endDate;
        this.viewId = viewId;
        this.orgs = orgs;
        this.initYearPeriod();
    }

    public Long getModelID() {
        return this.modelID;
    }

    public void setModelID(Long modelID) {
        this.modelID = modelID;
    }

    public Long getBusmodelID() {
        return this.busmodelID;
    }

    public void setBusmodelID(Long busmodelID) {
        this.busmodelID = busmodelID;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getViewId() {
        return this.viewId;
    }

    public void setViewId(Long viewId) {
        this.viewId = viewId;
    }

    public List<String> getOrgs() {
        return this.orgs;
    }

    public void setOrgs(List<String> orgs) {
        this.orgs = orgs;
    }

    public Map<String, List<String>> getYearPeriodMap() {
        return this.yearPeriodMap;
    }

    public void setYearPeriodMap(Map<String, List<String>> yearPeriodMap) {
        this.yearPeriodMap = yearPeriodMap;
    }

    public final void initYearPeriod() {
        ArrayList allPeriods = new ArrayList();
        QFilter modelqfilter = new QFilter("model", "=", (Object)this.modelID);
        QFilter isLeafFilter = new QFilter("isleaf", "=", (Object)"1");
        QFilter startDateFilter = new QFilter("startdate", ">=", (Object)this.startDate);
        QFilter endDateFilter = new QFilter("enddate", "<=", (Object)new Date(this.endDate.getTime() + 86400000L));
        DynamicObjectCollection allperiodsCol = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id, number, name, longnumber", (QFilter[])new QFilter[]{modelqfilter, isLeafFilter, startDateFilter, endDateFilter}, (String)"longnumber");
        if (allperiodsCol != null) {
            allperiodsCol.forEach(p -> allPeriods.add(p.getString("number")));
        }
        if (allPeriods.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u65e5\u671f\u8303\u56f4\u5185\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u8d22\u5e74\u671f\u95f4\u3002", (String)"OffsetExecuteParam_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.yearPeriodMap.clear();
        this.yearPeriodMap.put("budgetPeriod", allPeriods);
    }
}

