/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.combinoffset;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.epm.eb.business.combinoffset.OffsetEntry;
import kd.epm.eb.business.combinoffset.OffsetExecuteContext;
import kd.epm.eb.business.combinoffset.OffsetExecuteParam;
import kd.epm.eb.business.combinoffset.OffsetHelper;
import kd.epm.eb.business.combinoffset.OffsetRule;
import kd.epm.eb.business.combinoffset.ReportData;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.AccountMember;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.AccountDirectionEnum;
import kd.epm.eb.common.enums.OffsetEntryStatusEnum;
import kd.epm.eb.common.enums.OffsetExecuteStatusEnum;
import kd.epm.eb.common.enums.OffsetSourceEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.VarhandleEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.BgAccountUtils;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections.CollectionUtils;

public class OffsetExecutor {
    protected static final Log log = LogFactory.getLog(OffsetExecutor.class);
    private final OffsetExecuteParam param;
    private final List<OffsetRule> offsetRules;
    private final Map<Long, OffsetExecuteContext> contextMap;
    private final Map<Long, List<ReportData>> dataMap;
    private final Map<Long, List<OffsetEntry>> offsetEntryMap;
    private Map<String, Object> executeResult = new HashMap<String, Object>(16);
    private String pageId = null;
    private final String traceId;
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    public static final String CACHEKEY_MSG = "msg";
    private final IModelCacheHelper modelCacheHelper;
    private int misMatchCnt = 0;
    private int unMatchCnt = 0;
    private final List<DynamicObject> logEntrys = new ArrayList<DynamicObject>();
    private Map<Long, Set<String>> allCslOrgMap = null;

    public OffsetExecutor(OffsetExecuteParam param, String pageId, String traceId) {
        this.param = param;
        this.pageId = pageId;
        this.traceId = traceId;
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)param.getModelID());
        this.contextMap = new HashMap<Long, OffsetExecuteContext>(16);
        this.offsetRules = new ArrayList<OffsetRule>(16);
        this.dataMap = new HashMap<Long, List<ReportData>>(16);
        this.offsetEntryMap = new HashMap<Long, List<OffsetEntry>>(16);
    }

    public void execute() {
        try {
            this.beforeExecute();
            this.doExecute();
            this.afterExecute();
        }
        catch (Exception e) {
            log.error(e.getMessage() + " [traceId: " + this.traceId + "]", (Throwable)e);
            this.getExecuteResult().put("status", OffsetExecuteStatusEnum.FAILED.getIndex());
            this.putInPageCache("status", OffsetExecuteStatusEnum.FAILED.getIndex());
            if (e instanceof KDBizException) {
                this.addResultMsg(e.getMessage());
                this.putInPageCache(CACHEKEY_MSG, e.getMessage());
            } else {
                this.addResultMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                this.putInPageCache(CACHEKEY_MSG, ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u6267\u884c\u65e5\u5fd7\u3002", (String)"OffsetExecutor_0", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            this.putInPageCache(CACHEKEY_PROGRESS, "100");
        }
        finally {
            this.saveExecuteLog();
        }
    }

    public void beforeExecute() {
        if (this.param == null || this.param.getModelID() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6267\u884c\u53c2\u6570\u3002", (String)"OffsetExecutor_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (this.isStop()) {
            return;
        }
        if (!BusinessModelServiceHelper.checkExistDim((IModelCacheHelper)this.modelCacheHelper, (Long)this.param.getBusmodelID(), (String)"InternalCompany")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u6a21\u578b\u6ca1\u6709\u5173\u8054\u5f80\u6765\u7ec4\u7ec7\u7ef4\u5ea6\uff0c\u8bf7\u5728\u4e1a\u52a1\u6a21\u578b\u5173\u8054\u5f80\u6765\u7ec4\u7ec7\u7ef4\u5ea6\u3002", (String)"OffsetExecutor_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.initOffsetRules();
        for (OffsetRule offsetRule : this.offsetRules) {
            Long ruleId = offsetRule.getId();
            this.initDim(ruleId);
            this.initScope(offsetRule);
            try {
                this.loadAllDataFromOLAP(offsetRule);
            }
            catch (KDBizException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            this.filterByYearPeriod(ruleId);
        }
        this.putInPageCache(CACHEKEY_PROGRESS, "20");
    }

    public void doExecute() {
        for (OffsetRule rule : this.offsetRules) {
            this.offsetEntryMap.put(rule.getId(), this.executeOneRule(rule));
        }
        this.putInPageCache(CACHEKEY_PROGRESS, "60");
    }

    public void afterExecute() {
        List<DynamicObject> list;
        List<BgData> manualBgdata;
        Set ruleIds;
        if (this.isStop()) {
            return;
        }
        ArrayList<BgData> bgDataToSave = new ArrayList<BgData>(16);
        HashSet oldOffsetEntries = new HashSet(16);
        LinkedList allOffsetEntries = Lists.newLinkedList();
        int unilateralRuleSize = 0;
        int unilateralAllEntrySize = 0;
        int unilateralEntrySize = 0;
        int entrySize = 0;
        QFilter qFilter = this.getQFilterFromParam();
        Map sysGenOffsetEntries_old = BusinessDataServiceHelper.loadFromCache((String)"eb_offsetentry", (QFilter[])new QFilter[]{qFilter, new QFilter("offsetrule", "in", ruleIds = this.offsetRules.stream().map(OffsetRule::getId).collect(Collectors.toSet()))});
        if (sysGenOffsetEntries_old != null && !sysGenOffsetEntries_old.isEmpty()) {
            try {
                List<BgData> sysGenBgdata_old = OffsetHelper.getBgDataFromOffsetEntryObjects(sysGenOffsetEntries_old.values(), this.modelCacheHelper);
                if (sysGenBgdata_old != null) {
                    log.info("sysGenBgdata_old:" + OffsetHelper.getInfo(sysGenBgdata_old));
                    sysGenBgdata_old.forEach(bgData -> bgData.setValue(null));
                    bgDataToSave.addAll(sysGenBgdata_old);
                    oldOffsetEntries.addAll(sysGenOffsetEntries_old.values().stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        for (OffsetRule rule : this.offsetRules) {
            Long ruleId = rule.getId();
            List<OffsetEntry> offsetEntries = this.offsetEntryMap.get(ruleId);
            if (offsetEntries == null) continue;
            List<BgData> sysGenBgdata_new = OffsetHelper.getBgDataFromOffsetEntries(offsetEntries, this.modelCacheHelper);
            log.info("sysGenBgdata_new" + OffsetHelper.getInfo(sysGenBgdata_new));
            bgDataToSave.addAll(sysGenBgdata_new);
            allOffsetEntries.addAll(offsetEntries);
            if (rule.isUnilateral()) {
                ++unilateralRuleSize;
                for (OffsetEntry offsetEntry : offsetEntries) {
                    if (!offsetEntry.isUnilateral()) continue;
                    ++unilateralEntrySize;
                }
                unilateralAllEntrySize += offsetEntries.size();
                continue;
            }
            entrySize += offsetEntries.size();
        }
        Map manualOffsetEntries = BusinessDataServiceHelper.loadFromCache((String)"eb_offsetentry", (QFilter[])new QFilter[]{qFilter, new QFilter("status", "=", (Object)OffsetEntryStatusEnum.INPUT.getIndex())});
        if (manualOffsetEntries != null && !manualOffsetEntries.isEmpty() && (manualBgdata = OffsetHelper.getBgDataFromOffsetEntryObjects(manualOffsetEntries.values(), this.modelCacheHelper)) != null) {
            log.info("manualBgdata" + OffsetHelper.getInfo(manualBgdata));
            bgDataToSave.addAll(manualBgdata);
        }
        List<BgData> mergeBgdatas = OffsetHelper.mergeBgdatas(bgDataToSave, this.modelCacheHelper);
        log.info("mergeBgdatas" + OffsetHelper.getInfo(bgDataToSave));
        Map<String, Set<String>> noPermDimMems = OffsetHelper.validatePermission(bgDataToSave, DimMembPermType.WRITE, this.modelCacheHelper);
        if (!noPermDimMems.isEmpty()) {
            StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u65e0\u4ee5\u4e0b\u7ef4\u5ea6\u6210\u5458\u7684\u5199\u5165\u6743\u9650\uff1a", (String)"OffsetExecutor_37", (String)"epm-eb-business", (Object[])new Object[0]));
            String DIM_NUM = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\uff1a", (String)"OffsetExecutor_35", (String)"epm-eb-business", (Object[])new Object[0]);
            String MEM_NUM = ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801\uff1a", (String)"OffsetExecutor_36", (String)"epm-eb-business", (Object[])new Object[0]);
            for (Map.Entry<String, Set<String>> entry : noPermDimMems.entrySet()) {
                sb.append(DIM_NUM).append(entry.getKey()).append("\uff0c").append(MEM_NUM).append(entry.getValue()).append("\uff1b");
            }
            throw new KDBizException(sb.toString());
        }
        String numberStr = this.offsetRules.stream().map(OffsetRule::getNumber).collect(Collectors.joining(","));
        OffsetHelper.saveBgdataToOlap(mergeBgdatas, this.modelCacheHelper, numberStr);
        this.putInPageCache(CACHEKEY_PROGRESS, "80");
        if (CollectionUtils.isNotEmpty(oldOffsetEntries)) {
            DeleteServiceHelper.delete((String)"eb_offsetentry", (QFilter[])new QFilter[]{new QFilter("id", "in", oldOffsetEntries)});
        }
        if (CollectionUtils.isNotEmpty((Collection)allOffsetEntries) && (list = this.buildOffsetEntryDynamicObject(allOffsetEntries)) != null && !list.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        this.getExecuteResult().put("status", OffsetExecuteStatusEnum.SUCCESS.getIndex());
        this.putInPageCache("status", OffsetExecuteStatusEnum.SUCCESS.getIndex());
        this.addResultMsg(ResManager.loadResFormat((String)"\u4e00\u5171\u6267\u884c%1\u6761\u62b5\u9500\u89c4\u5219\uff0c%2\u6761\u62b5\u9500\u89c4\u5219\u5f00\u542f\u4e86\u5355\u8fb9\u62b5\u9500\uff0c\u4ea7\u751f%3\u6761\u62b5\u9500\u5206\u5f55\uff0c%4\u6761\u4ea4\u6613/\u5f80\u6765\u6570\u636e\u6570\u636e\u4e3a\u7a7a/0\uff1b%5\u6761\u62b5\u9500\u89c4\u5219\u672a\u5f00\u542f\u5355\u8fb9\u62b5\u9500\uff0c\u4ea7\u751f%6\u6761\u62b5\u9500\u5206\u5f55\uff0c%7\u6761\u4ea4\u6613/\u5f80\u6765\u6570\u636e\u56e0\u5bf9\u65b9\u6570\u636e\u4e3a\u7a7a\u62160\u3002", (String)"OffsetExecutor_2", (String)"epm-eb-business", (Object[])new Object[]{this.offsetRules.size(), unilateralRuleSize, unilateralAllEntrySize, unilateralEntrySize, this.offsetRules.size() - unilateralRuleSize, entrySize, this.misMatchCnt}));
        this.putInPageCache(CACHEKEY_PROGRESS, "100");
        this.putInPageCache(CACHEKEY_MSG, (String)this.getExecuteResult().get(CACHEKEY_MSG));
    }

    private QFilter getQFilterFromParam() {
        HashSet cslorgids = new HashSet(16);
        HashSet periodids = new HashSet(16);
        this.param.getOrgs().forEach(e -> this.offsetRules.forEach(rule -> cslorgids.add(this.getContext(rule.getId()).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), (String)e))));
        this.param.getYearPeriodMap().values().forEach(e -> this.offsetRules.forEach(rule -> e.forEach(p -> periodids.add(this.getContext(rule.getId()).getMembIdFromCache(SysDimensionEnum.BudgetPeriod.getNumber(), (String)p)))));
        Set versionIds = this.offsetRules.stream().map(rule -> this.getContext(rule.getId()).getMembIdFromCache(SysDimensionEnum.Version.getNumber(), this.param.getVersion())).collect(Collectors.toSet());
        Set dataTypeIds = this.offsetRules.stream().map(rule -> this.getContext(rule.getId()).getMembIdFromCache(SysDimensionEnum.DataType.getNumber(), this.param.getDatatype())).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("model", "=", (Object)this.param.getModelID());
        qFilter.and("busmodel", "=", (Object)this.param.getBusmodelID());
        qFilter.and("version", "in", versionIds);
        qFilter.and("datatype", "in", dataTypeIds);
        qFilter.and("cslorg", "in", cslorgids);
        qFilter.and("period", "in", periodids);
        return qFilter;
    }

    private void saveExecuteLog() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_offsetexecutelog");
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        StringBuilder msg = new StringBuilder((String)this.getExecuteResult().get(CACHEKEY_MSG));
        dynamicObject.set("createdate", (Object)now);
        dynamicObject.set("creater", (Object)userId);
        dynamicObject.set("model", (Object)this.param.getModelID());
        dynamicObject.set("parameterdata", (Object)JSON.toJSONString((Object)this.param));
        dynamicObject.set("status", this.getExecuteResult().get("status"));
        dynamicObject.set(CACHEKEY_MSG, (Object)msg.toString());
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        if (this.misMatchCnt > 0) {
            this.logEntrys.forEach(e -> e.set("offsetexelog", (Object)((DynamicObject)save[0]).getLong("id")));
            SaveServiceHelper.save((DynamicObject[])this.logEntrys.toArray(new DynamicObject[0]));
            this.putInPageCache("logEntryId", ((DynamicObject)save[0]).getString("id"));
        }
    }

    private void initScope(OffsetRule offsetRule) {
        if (this.param == null) {
            return;
        }
        Long ruleId = offsetRule.getId();
        this.getContext(ruleId).addScope(SysDimensionEnum.BudgetPeriod.getNumber(), this.queryAllPeriods(ruleId));
        this.getContext(ruleId).addScope(SysDimensionEnum.Currency.getNumber(), this.queryAllCurrencies(ruleId));
        this.getContext(ruleId).addScope(SysDimensionEnum.AuditTrail.getNumber(), this.queryAllAudittrails(ruleId));
        this.getContext(ruleId).addScope(SysDimensionEnum.DataType.getNumber(), this.queryAndCacheMember(ruleId, "epm_datatypemembertree", SysDimensionEnum.DataType.getNumber(), this.toStringArray(this.param.getDatatype())));
        this.getContext(ruleId).addScope(SysDimensionEnum.Version.getNumber(), this.queryAndCacheMember(ruleId, "epm_versionmembertree", SysDimensionEnum.Version.getNumber(), this.toStringArray(this.param.getVersion())));
        this.getContext(ruleId).addScope(SysDimensionEnum.ChangeType.getNumber(), this.queryAllChangeTypes(ruleId));
        this.getContext(ruleId).addScope(SysDimensionEnum.Entity.getNumber(), (Pair<String, String[]>)Pair.onePair((Object)SysDimensionEnum.Entity.getNumber(), (Object)this.queryChildOrgs(offsetRule)));
        this.getContext(ruleId).addScope(SysDimensionEnum.InternalCompany.getNumber(), (Pair<String, String[]>)Pair.onePair((Object)SysDimensionEnum.InternalCompany.getNumber(), (Object)this.queryChildInterOrgs(offsetRule)));
        this.getContext(ruleId).addScope(SysDimensionEnum.Account.getNumber(), this.queryAllAccounts(ruleId));
        this.getContext(ruleId).addScope(SysDimensionEnum.Metric.getNumber(), this.queryAllMetrics(ruleId));
        this.addScopeUserDefined(ruleId);
    }

    private void loadAllDataFromOLAP(OffsetRule offsetRule) {
        long ruleId = offsetRule.getId();
        List datas = this.dataMap.computeIfAbsent(ruleId, k -> new ArrayList(16));
        Set dataSetIds = this.getContext(ruleId).getAllAccounts().stream().map(Member::getDatasetId).collect(Collectors.toSet());
        if (!dataSetIds.isEmpty()) {
            for (Long datasetId : dataSetIds) {
                String[] dims = this.modelCacheHelper.getDimensionNums(datasetId);
                Set dsDimNumbers = Arrays.stream(dims).collect(Collectors.toSet());
                if (!dsDimNumbers.contains(SysDimensionEnum.InternalCompany.getNumber())) continue;
                HashMap memberInfo = new HashMap(dims.length);
                this.getContext(ruleId).getScopes().values().forEach(e -> {
                    if (dsDimNumbers.contains(e.p1)) {
                        if (e.p2 == null || ((String[])e.p2).length == 0) {
                            this.addResultMsg(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\u3002", (String)"OffsetExecutor_41", (String)"epm-eb-business", (Object[])new Object[]{e.p1}));
                            return;
                        }
                        if (SysDimensionEnum.Account.getNumber().equals(e.p1) && dataSetIds.size() > 1) {
                            memberInfo.put(e.p1, this.getContext(ruleId).getAllAccounts().stream().filter(accountMember -> datasetId.equals(accountMember.getDatasetId())).map(BaseCache::getNumber).collect(Collectors.toSet()));
                        } else {
                            memberInfo.put(e.p1, Arrays.stream((Object[])e.p2).collect(Collectors.toSet()));
                        }
                    }
                });
                Map viewMap = this.modelCacheHelper.getViewsByDataSet(datasetId);
                viewMap.put(SysDimensionEnum.Entity.getNumber(), this.param.getViewId());
                QueryRequest queryRequest = new QueryRequest();
                queryRequest.setModelId(this.param.getModelID());
                queryRequest.setDatasetId(datasetId);
                queryRequest.setMemberInfo(memberInfo);
                queryRequest.setOptions(new Options());
                log.info("--loaddataFromOlap: datasetId=" + datasetId + ", query=" + queryRequest);
                List bgCellList = OlapManager.getInstance().queryList(queryRequest);
                if (!CollectionUtils.isNotEmpty((Collection)bgCellList)) continue;
                bgCellList.stream().filter(c -> c.getValue() != null && ConvertUtils.toDecimal((Object)c.getValue()).compareTo(BigDecimal.ZERO) != 0).forEach(cell -> {
                    ReportData reportData = this.buildReportData((BGCell)cell, offsetRule);
                    if (reportData != null) {
                        datas.add(reportData);
                    }
                });
            }
        }
        log.info("--loadAllDataFromOLAP--datas.size()=" + datas.size());
    }

    private void filterByYearPeriod(long ruleId) {
        List<ReportData> datas = this.dataMap.get(ruleId);
        if (datas != null && !datas.isEmpty() && this.param.getYearPeriodMap() != null) {
            ArrayList filteredData = new ArrayList(16);
            this.param.getYearPeriodMap().forEach((key, value) -> filteredData.addAll(datas.parallelStream().filter(d -> value.contains(d.getPeriod()) && !d.getEntity().equals(d.getInternalcompany())).collect(Collectors.toList())));
            this.dataMap.put(ruleId, filteredData);
        }
    }

    private String[] toStringArray(String ... s) {
        return s;
    }

    private Pair<String, String[]> queryAndCacheMember(long ruleId, String entity, String dimNumber, String ... membNumber) {
        if (membNumber == null || membNumber.length == 0) {
            return null;
        }
        List<Pair<String, Long>> pairs = this.queryMember(entity, dimNumber, membNumber);
        for (Pair<String, Long> pair : pairs) {
            this.getContext(ruleId).cacheMemb(dimNumber, (String)pair.p1, (Long)pair.p2);
        }
        ArrayList membNumbers = new ArrayList(16);
        pairs.forEach(e -> membNumbers.add(e.p1));
        return Pair.onePair((Object)dimNumber, (Object)membNumbers.toArray(new String[0]));
    }

    private Pair<String, String[]> queryAllPeriods(long ruleId) {
        String dim = SysDimensionEnum.BudgetPeriod.getNumber();
        HashSet periodSet = new HashSet();
        this.param.getYearPeriodMap().values().forEach(periodSet::addAll);
        String[] periods = periodSet.toArray(new String[0]);
        this.queryAndCacheMember(ruleId, "epm_bperiodmembertree", SysDimensionEnum.BudgetPeriod.getNumber(), periods);
        return Pair.onePair((Object)dim, (Object)periods);
    }

    private List<Pair<String, Long>> queryMember(String entity, String dim, String ... memb) {
        QFBuilder qfbuilder = new QFBuilder();
        qfbuilder.add("model", "=", (Object)this.param.getModelID());
        if (memb.length == 1) {
            qfbuilder.add("number", "=", (Object)memb[0]);
        } else {
            qfbuilder.add("number", "in", (Object)memb);
        }
        qfbuilder.add("isleaf", "=", (Object)true);
        DynamicObjectCollection col = QueryServiceHelper.query((String)entity, (String)"id, number", (QFilter[])qfbuilder.toArray());
        ArrayList<Pair<String, Long>> membs = new ArrayList<Pair<String, Long>>(col.size());
        col.forEach(e -> membs.add(Pair.onePair((Object)e.getString("number"), (Object)e.getLong("id"))));
        return membs;
    }

    private Pair<String, String[]> queryAllCurrencies(long ruleId) {
        Set<String> allCurrencies = this.offsetRules.stream().map(OffsetRule::getCurrency).collect(Collectors.toSet());
        this.queryAndCacheMember(ruleId, "epm_currencymembertree", SysDimensionEnum.Currency.getNumber(), allCurrencies.toArray(new String[0]));
        return Pair.onePair((Object)SysDimensionEnum.Currency.getNumber(), (Object)allCurrencies.toArray(new String[0]));
    }

    private Pair<String, String[]> queryAllMetrics(long ruleId) {
        HashSet allMetrics = new HashSet(16);
        this.offsetRules.forEach(r -> {
            if (StringUtils.isNotEmpty((String)r.getMetric())) {
                allMetrics.add(r.getMetric());
            }
            if (StringUtils.isNotEmpty((String)r.getMetricqty())) {
                allMetrics.add(r.getMetricqty());
            }
        });
        this.queryAndCacheMember(ruleId, "epm_metricmembertree", SysDimensionEnum.Metric.getNumber(), allMetrics.toArray(new String[0]));
        return Pair.onePair((Object)SysDimensionEnum.Metric.getNumber(), (Object)allMetrics.toArray(new String[0]));
    }

    private Pair<String, String[]> queryAllAudittrails(long ruleId) {
        Set<String> allAuditTrails = this.offsetRules.stream().map(OffsetRule::getAudittrail).collect(Collectors.toSet());
        this.queryAndCacheMember(ruleId, "epm_audittrialmembertree", SysDimensionEnum.AuditTrail.getNumber(), allAuditTrails.toArray(new String[0]));
        return Pair.onePair((Object)SysDimensionEnum.AuditTrail.getNumber(), (Object)allAuditTrails.toArray(new String[0]));
    }

    private Pair<String, String[]> queryAllChangeTypes(long ruleId) {
        String dimNum = SysDimensionEnum.ChangeType.getNumber();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.param.getModelID());
        List viewIds = modelCache.getViewGroupViewsByBusModelAndDimNumber(this.param.getBusmodelID(), dimNum);
        HashSet memNumbers = new HashSet(16);
        viewIds.forEach(viewId -> {
            List members = modelCache.getMembers(viewId, dimNum);
            Set<Member> memSet = members.stream().filter(Member::isLeaf).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(memSet)) {
                memSet.forEach(m -> {
                    memNumbers.add(m.getNumber());
                    this.getContext(ruleId).cacheMemb(dimNum, m.getNumber(), m.getId());
                });
            }
        });
        return Pair.onePair((Object)SysDimensionEnum.ChangeType.getNumber(), (Object)memNumbers.toArray(new String[0]));
    }

    private String[] queryChildOrgs(OffsetRule offsetRule) {
        Long ruleId = offsetRule.getId();
        String dim = SysDimensionEnum.Entity.getNumber();
        Long viewId = offsetRule.getEntityViewId();
        StringBuilder sql = new StringBuilder();
        sql.append(" select fmemberid as fid, fnumber, flongnumber, fisinnerorg, fisleaf, fisoffsetentry from t_eb_viewmember");
        sql.append(" where fmodelid = ").append(this.param.getModelID());
        sql.append(" and fviewId in (").append(viewId).append(")");
        sql.append(" and (");
        int i = 0;
        HashSet<String> allOrgs = new HashSet<String>(16);
        allOrgs.addAll(offsetRule.getOrgs());
        int size = allOrgs.size();
        for (String number : allOrgs) {
            sql.append(" flongnumber like '").append(this.getContext(ruleId).getOrgNum2LongNum().get(number)).append("!%'");
            if (i < size - 1) {
                sql.append(" or ");
            }
            ++i;
        }
        sql.append(")");
        try (DataSet ds = DB.queryDataSet((String)"queryChildOrgs", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String number = row.getString("fnumber");
                    if (number.endsWith("offsetentry")) continue;
                    if (row.getBoolean("fisleaf").booleanValue()) {
                        this.getContext(ruleId).getLeafOrgNumbers().add(number);
                    }
                    this.getContext(ruleId).cacheMemb(dim, number, row.getLong("fid"));
                    this.getContext(ruleId).getOrgNum2LongNum().put(number, row.getString("flongnumber"));
                }
            }
        }
        return this.getContext(ruleId).getLeafOrgNumbers().toArray(new String[0]);
    }

    private String[] queryChildInterOrgs(OffsetRule offsetRule) {
        Object rootMember;
        Long ruleId = offsetRule.getId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.param.getModelID());
        List viewIds = modelCache.getViewGroupViewsByBusModelAndDimNumber(this.param.getBusmodelID(), SysDimensionEnum.InternalCompany.getNumber());
        String dim = SysDimensionEnum.InternalCompany.getNumber();
        HashSet<String> interOrgNumbers = new HashSet<String>(16);
        HashSet<String> longNumberSet = new HashSet<String>(16);
        StringBuilder sql = new StringBuilder();
        sql.append(" select fmemberid as fid, fnumber, flongnumber from t_eb_viewmember");
        sql.append(" where fmodelid = ");
        sql.append(this.param.getModelID());
        sql.append(" and fviewid in (");
        sql.append(viewIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        sql.append(")");
        sql.append(" and fenable = '1' ");
        sql.append(" and fisleaf = '1' ");
        sql.append(" and fdisable = '0' ");
        sql.append(" and (");
        for (int i = 0; i < viewIds.size(); ++i) {
            Long viewId = (Long)viewIds.get(i);
            rootMember = modelCache.getRootMember(SysDimensionEnum.InternalCompany.getNumber(), viewId);
            if (rootMember == null) continue;
            if (i > 0) {
                sql.append(" or ");
            }
            sql.append(" flongnumber like '").append(rootMember.getNumber()).append("!ICTotal!ICEntity!%'");
        }
        sql.append(")");
        HashMap<String, String> orgLongNum2Num = new HashMap<String, String>(16);
        DataSet ds = DB.queryDataSet((String)"queryChildInterOrgs", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);
        rootMember = null;
        try {
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String number = row.getString("fnumber");
                    if ("ICNone".equals(number)) continue;
                    interOrgNumbers.add(number);
                    String orgLongNumber = this.getContext(ruleId).getOrgNum2LongNum().get(number);
                    if (orgLongNumber != null) {
                        longNumberSet.add(orgLongNumber);
                        orgLongNum2Num.put(orgLongNumber, number);
                    }
                    this.getContext(ruleId).cacheMemb(dim, number, row.getLong("fid"));
                }
            }
        }
        catch (Throwable row) {
            rootMember = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (rootMember != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)rootMember).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        block11: for (String orgNum : this.getContext(ruleId).getLeafOrgNumbers()) {
            if (interOrgNumbers.contains(orgNum)) {
                this.getContext(ruleId).getOrg2InterOrgMap().put(orgNum, orgNum);
                continue;
            }
            String longNum = this.getContext(ruleId).getOrgNum2LongNum().get(orgNum);
            if (longNum == null) continue;
            String[] longNumSplit = longNum.split("!");
            for (int i = longNumSplit.length - 1; i > 0; --i) {
                if (!interOrgNumbers.contains(longNumSplit[i])) continue;
                this.getContext(ruleId).getOrg2InterOrgMap().put(orgNum, longNumSplit[i]);
                continue block11;
            }
        }
        if (!longNumberSet.isEmpty()) {
            Map checkResult = MemberServiceHelper.checkEntityMembersPathInnerOrg((Long)this.param.getModelID(), (String)"eb_viewmember", longNumberSet);
            Set invalidOrgs = checkResult.entrySet().stream().filter(e -> Boolean.TRUE.equals(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (!invalidOrgs.isEmpty()) {
                Object[] objectArray = new Object[2];
                objectArray[0] = offsetRule.getNumber();
                objectArray[1] = invalidOrgs.stream().map(orgLongNum2Num::get).collect(Collectors.toSet());
                throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%1\uff0c\u5185\u90e8\u5f80\u6765\u7ec4\u7ec7\u5b58\u5728\u51b2\u7a81\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4e0b\u7ea7\u7ec4\u7ec7\u540c\u65f6\u8bbe\u7f6e\u5f80\u6765\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u5220\u9664\u5b58\u5728\u51b2\u7a81\u7684\u5185\u90e8\u5f80\u6765\u7ec4\u7ec7\uff1a%2", (String)"OffsetExecutor_34", (String)"epm-eb-business", (Object[])objectArray));
            }
        } else {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6240\u9009\u5408\u5e76\u8303\u56f4\u4e0b\u65e0\u4efb\u4f55\u5185\u90e8\u5f80\u6765\u7ec4\u7ec7\u3002\u89c4\u5219\uff1a%1", (String)"OffsetExecutor_38", (String)"epm-eb-business", (Object[])new Object[]{offsetRule.getNumber()}));
        }
        return interOrgNumbers.toArray(new String[0]);
    }

    private String getCslOrg(long ruleId, List<String> clsOrgs, Long clsOrgViewId, String org1Num, String org2Num) {
        String org1LongNum = this.getContext(ruleId).getOrgNum2LongNum().get(org1Num);
        String org2LongNum = this.getContext(ruleId).getOrgNum2LongNum().get(org2Num);
        log.info("getCslOrg org1LongNum=" + org1LongNum + ", org2LongNum=" + org2LongNum);
        if (org1LongNum == null || org2LongNum == null || clsOrgs == null) {
            return null;
        }
        String[] org1LongNumSplit = org1LongNum.split("!");
        String[] org2LongNumSplit = org2LongNum.split("!");
        int length = Math.min(org1LongNumSplit.length, org2LongNumSplit.length);
        int index = 0;
        for (int i = 0; i < length; ++i) {
            if (!org1LongNumSplit[i].equals(org2LongNumSplit[i])) continue;
            index = i;
        }
        String foundCslOrgNum = null;
        if (index > 0) {
            Set<String> allCslOrgs = this.getAllCslOrgs(clsOrgViewId);
            for (int i = index; i > 0; --i) {
                if (!allCslOrgs.contains(org1LongNumSplit[i])) continue;
                foundCslOrgNum = org1LongNumSplit[i];
                log.info("foundCslOrgNum=" + foundCslOrgNum);
                break;
            }
        }
        if (this.param.getOrgs().contains(foundCslOrgNum) && clsOrgs.contains(foundCslOrgNum)) {
            return foundCslOrgNum;
        }
        log.info("foundCslOrgNum not in param.getOrgs() and rule.getOrgs()");
        return null;
    }

    private Set<String> getAllCslOrgs(Long viewId) {
        if (this.allCslOrgMap == null) {
            this.allCslOrgMap = new HashMap<Long, Set<String>>(16);
        }
        return this.allCslOrgMap.computeIfAbsent(viewId, k -> {
            HashSet<String> allCslOrgs = new HashSet<String>(16);
            String sql = " select fnumber from t_eb_viewmember where fmodelid = " + this.param.getModelID() + " and fmergernode = '1'  and fviewId = " + viewId;
            try (DataSet ds = DB.queryDataSet((String)"getAllCslOrgs", (DBRoute)DBRoute.of((String)"epm"), (String)sql, null);){
                if (ds != null) {
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        allCslOrgs.add(row.getString("fnumber"));
                    }
                }
            }
            return allCslOrgs;
        });
    }

    private Pair<String, String[]> queryAllAccounts(long ruleId) {
        Set<String> accountNumbers = this.getContext(ruleId).getAllAccounts().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        this.queryAndCacheMember(ruleId, "epm_accountmembertree", SysDimensionEnum.Account.getNumber(), accountNumbers.toArray(new String[0]));
        return Pair.onePair((Object)SysDimensionEnum.Account.getNumber(), (Object)accountNumbers.toArray(new String[0]));
    }

    private void addScopeUserDefined(long ruleId) {
        List<String> userDefineDims = this.getContext(ruleId).getUserDefineDims();
        if (userDefineDims != null && !userDefineDims.isEmpty()) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.param.getModelID());
            Map viewGroupViews = modelCache.getViewGroupViewsByBusModel(this.param.getBusmodelID());
            HashMap<String, List> userDefineMemberMap = new HashMap<String, List>(16);
            HashSet<String> viewUD = new HashSet<String>(16);
            HashSet viewIds = new HashSet(16);
            for (String ud : userDefineDims) {
                viewUD.add(ud);
                viewIds.addAll((Collection)viewGroupViews.get(ud));
            }
            QFilter q1 = new QFilter("model", "=", (Object)this.param.getModelID());
            QFilter q2 = new QFilter("isleaf", "=", (Object)true);
            DynamicObjectCollection dimMems = new DynamicObjectCollection();
            if (!viewUD.isEmpty()) {
                QFilter q3 = new QFilter("dimension.number", "in", viewUD).and(new QFilter("view", "in", viewIds));
                dimMems.addAll((Collection)QueryServiceHelper.query((String)"eb_viewmember", (String)"id, memberid, number, dimension.number", (QFilter[])new QFilter[]{q1, q2, q3}));
            }
            for (DynamicObject dmem : dimMems) {
                String dimNumber = dmem.getString("dimension.number");
                String memNumber = dmem.getString("number");
                if (!viewUD.contains(dimNumber)) continue;
                this.getContext(ruleId).cacheMemb(dimNumber, memNumber, dmem.getLong("memberid"));
                List memNumbers = userDefineMemberMap.computeIfAbsent(dimNumber, k -> new ArrayList(16));
                memNumbers.add(memNumber);
            }
            for (Map.Entry udm : userDefineMemberMap.entrySet()) {
                this.getContext(ruleId).addScope((String)udm.getKey(), (Pair<String, String[]>)Pair.onePair(udm.getKey(), (Object)((List)udm.getValue()).toArray(new String[0])));
            }
        }
    }

    private void initDim(long ruleId) {
        List dims = this.modelCacheHelper.getDimensionListByBusModel(this.param.getBusmodelID()).stream().sorted(Comparator.comparingInt(d -> d.getSeq())).collect(Collectors.toList());
        DynamicObject offsetRuleCatalog = BusinessDataServiceHelper.loadSingle((String)"eb_offsetrulecatalog", (String)"id,number,assistdim", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.param.getModelID()), new QFilter("number", "=", (Object)this.getContext(ruleId).getBusModelObject().getString("number"))});
        HashSet<String> assistdimsSet = new HashSet<String>(16);
        String assistdim = offsetRuleCatalog.getString("assistdim");
        if (assistdim != null) {
            String[] assistdimSplit;
            for (String d2 : assistdimSplit = assistdim.split(",")) {
                if (!StringUtils.isNotEmpty((String)d2)) continue;
                assistdimsSet.add(d2);
            }
        }
        int userDefinedIndex = 1;
        for (Dimension d3 : dims) {
            String dimNumber = d3.getNumber();
            if (d3.isPreset()) continue;
            this.getContext(ruleId).getUserDefineDims().add(dimNumber);
            if (!assistdimsSet.contains(dimNumber)) continue;
            this.getContext(ruleId).getFieldMapped().put("dim" + userDefinedIndex, dimNumber);
            this.getContext(ruleId).getFieldMapped().put(dimNumber, "dim" + userDefinedIndex);
            ++userDefinedIndex;
        }
    }

    public Map<String, String> getFieldMapped(long ruleId) {
        return this.getContext(ruleId).getFieldMapped();
    }

    public void initOffsetRules() {
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)this.param.getModelID());
        qb.add("busmodel", "=", (Object)this.param.getBusmodelID());
        qb.add("enable", "=", (Object)Boolean.TRUE);
        Map rules = BusinessDataServiceHelper.loadFromCache((String)"eb_offsetrule", (QFilter[])qb.toArray());
        HashSet<String> destAudittrails = new HashSet<String>(16);
        if (rules != null && !rules.isEmpty()) {
            Dimension accountDimension = this.modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
            for (DynamicObject ruleObject : rules.values()) {
                long ruleId = ruleObject.getLong("id");
                DynamicObjectCollection orgsCol = ruleObject.getDynamicObjectCollection("orgs");
                Long orgViewId = this.param.getViewId();
                if (IDUtils.isEmptyLong((Long)orgViewId).booleanValue()) {
                    orgViewId = this.modelCacheHelper.getViewByBusModelAndDimNumber(this.param.getBusmodelID(), SysDimensionEnum.Entity.getNumber());
                }
                HashSet orgNumbers = new HashSet(16);
                orgsCol.forEach(dynamicObject -> orgNumbers.add(dynamicObject.getString("org.number")));
                orgsCol = QueryServiceHelper.query((String)"eb_viewmember", (String)"number as org.number, longnumber as org.longnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.param.getModelID()), new QFilter("view", "=", (Object)orgViewId), new QFilter("number", "in", orgNumbers)});
                ArrayList<String> orgs = new ArrayList<String>(16);
                for (DynamicObject org : orgsCol) {
                    orgs.add(org.getString("org.number"));
                    this.getContext(ruleId).getOrgNum2LongNum().put(org.getString("org.number"), org.getString("org.longnumber"));
                }
                if (orgs.isEmpty()) {
                    this.addResultMsg(ResManager.loadResFormat((String)"%1\u62b5\u6d88\u89c4\u5219\u4e2d\u542f\u7528\u7684\u5408\u5e76\u8303\u56f4\u4e0d\u5728\u6b64\u6b21\u6267\u884c\u8303\u56f4\u5185\uff0c\u5df2\u8df3\u8fc7\u6b64\u89c4\u5219\u3002", (String)"OffsetExecutor_32", (String)"epm-eb-business", (Object[])new Object[]{ruleObject.getString("name")}));
                    continue;
                }
                OffsetRule rule = new OffsetRule();
                rule.setOrgs(orgs);
                rule.setId(ruleId);
                rule.setModelID(this.param.getModelID());
                rule.setNumber(ruleObject.getString("number"));
                rule.setName(ruleObject.getString("name"));
                rule.setCatalogID(ruleObject.getLong("offsetrulecatalog.id"));
                rule.setBusmodelID(ruleObject.getLong("busmodel.id"));
                rule.setAudittrailID(ruleObject.getLong("audittrail.id"));
                rule.setAudittrail(ruleObject.getString("audittrail.number"));
                rule.setDestaudittrailID(ruleObject.getLong("destaudittrail.id"));
                rule.setDestaudittrail(ruleObject.getString("destaudittrail.number"));
                if (StringUtils.isEmpty((String)rule.getDestaudittrail())) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u62b5\u9500\u89c4\u5219:%1\u672a\u8bbe\u7f6e\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u3002", (String)"OffsetExecutor_29", (String)"epm-eb-business", (Object[])new Object[]{rule.getName()}));
                }
                rule.setCurrencyID(ruleObject.getLong("currency.id"));
                rule.setCurrency(ruleObject.getString("currency.number"));
                rule.setMetricID(ruleObject.getLong("metric.id"));
                rule.setMetric(ruleObject.getString("metric.number"));
                rule.setMetricqtyID(ruleObject.getLong("metricqty.id"));
                rule.setMetricqty(ruleObject.getString("metricqty.number"));
                rule.setEntityViewId(orgViewId);
                destAudittrails.add(rule.getDestaudittrail());
                String assistDimStr = ruleObject.getString("assistdim");
                if (!StringUtils.isEmpty((String)assistDimStr)) {
                    String[] ad = assistDimStr.split(",");
                    ArrayList<String> assistDims = new ArrayList<String>(16);
                    for (String s : ad) {
                        if (!StringUtils.isNotEmpty((String)s)) continue;
                        assistDims.add(s);
                    }
                    rule.setAssistdims(assistDims);
                }
                rule.setVarhandle(VarhandleEnum.valueOf((int)ruleObject.getInt("varhandle")));
                rule.setVarhandleAccountID(ruleObject.getLong("varaccount.id"));
                rule.setVarhandleAccountNumber(ruleObject.getString("varaccount.number"));
                if (VarhandleEnum.SPECIFYACCOUNT.getIndex().equals(rule.getVarhandle().getIndex()) && rule.getVarhandleAccountID() != null) {
                    AccountMember va = new AccountMember();
                    va.setDimension(accountDimension);
                    va.setId(rule.getVarhandleAccountID());
                    va.setNumber(ruleObject.getString("varaccount.number"));
                    va.setName(ruleObject.getString("varaccount.name"));
                    va.setDirection(ruleObject.getInt("varaccount.drcrdirect"));
                    va.setDatasetId(Long.valueOf(ruleObject.getLong("varaccount.dataset.id")));
                    rule.setVarhandleAccount(va);
                    this.getContext(ruleId).getAllAccounts().add(va);
                }
                log.info("offset-open-unilateral.");
                rule.setUnilateral(StringUtils.equals((String)VarhandleEnum.USEBIG.getIndex(), (String)ruleObject.getString("unilateral")));
                DynamicObjectCollection accounts = ruleObject.getDynamicObjectCollection("accounts");
                HashSet senderAccounts = new HashSet(16);
                HashSet recvAccounts = new HashSet(16);
                accounts.forEach(e -> {
                    if (e.get("senderaccount").equals(Boolean.TRUE)) {
                        senderAccounts.add(e.getString("account.number"));
                    } else {
                        recvAccounts.add(e.getString("account.number"));
                    }
                });
                int shareType = Integer.parseInt(StorageTypeEnum.SHARE.getOIndex());
                DynamicObjectCollection col = BgAccountUtils.queryLeafAccounts((Long)this.modelCacheHelper.getModelobj().getId(), senderAccounts);
                ArrayList<AccountMember> sendAccountMembers = new ArrayList<AccountMember>(16);
                col.forEach(e -> {
                    if (shareType != e.getInt("storagetype")) {
                        AccountMember member = new AccountMember();
                        member.setDimension(accountDimension);
                        member.setId(Long.valueOf(e.getLong("id")));
                        member.setNumber(e.getString("number"));
                        member.setName(e.getString("name"));
                        member.setLongNumber(e.getString("longnumber"));
                        member.setDirection(e.getInt("drcrdirect"));
                        member.setDatasetId(Long.valueOf(e.getLong("dataset")));
                        if (rule.getMetric() != null && member.getDirection() != 5 && member.getDirection() != 6) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u79d1\u76ee\u201c%1\u201d\u7684\u501f\u8d37\u65b9\u5411\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"OffsetExecutor_8", (String)"epm-eb-business", (Object[])new Object[]{member.getName()}));
                        }
                        sendAccountMembers.add(member);
                    }
                });
                rule.setSenderAccounts(sendAccountMembers);
                col = BgAccountUtils.queryLeafAccounts((Long)this.modelCacheHelper.getModelobj().getId(), recvAccounts);
                ArrayList<AccountMember> recvAccountMembers = new ArrayList<AccountMember>(16);
                col.forEach(e -> {
                    if (shareType != e.getInt("storagetype")) {
                        AccountMember member = new AccountMember();
                        member.setDimension(accountDimension);
                        member.setId(Long.valueOf(e.getLong("id")));
                        member.setNumber(e.getString("number"));
                        member.setName(e.getString("name"));
                        member.setLongNumber(e.getString("longnumber"));
                        member.setDirection(e.getInt("drcrdirect"));
                        member.setDatasetId(Long.valueOf(e.getLong("dataset")));
                        if (rule.getMetric() != null && member.getDirection() != 5 && member.getDirection() != 6) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u79d1\u76ee\u201c%1\u201d\u7684\u501f\u8d37\u65b9\u5411\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"OffsetExecutor_8", (String)"epm-eb-business", (Object[])new Object[]{member.getName()}));
                        }
                        recvAccountMembers.add(member);
                    }
                });
                rule.setRecvAccounts(recvAccountMembers);
                rule.getSenderAccounts().forEach(a -> this.getContext(ruleId).getAllAccounts().add((AccountMember)a));
                rule.getRecvAccounts().forEach(a -> this.getContext(ruleId).getAllAccounts().add((AccountMember)a));
                if (ruleObject.getString("offsetrulecatalog.longnumber") != null) {
                    rule.setOffsetCatalog(ruleObject.getString("offsetrulecatalog.longnumber").split("\\.")[2]);
                }
                if (OffsetHelper.validateRule(rule)) {
                    this.offsetRules.add(rule);
                } else {
                    this.addResultMsg(ResManager.loadResFormat((String)"%1\u62b5\u6d88\u89c4\u5219\u542b\u65e0\u6548\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u6b64\u89c4\u5219\u3002\u672c\u6b21\u6267\u884c\u5df2\u8df3\u8fc7\u6b64\u89c4\u5219\u3002", (String)"OffsetExecutor_40", (String)"epm-eb-business", (Object[])new Object[]{rule.getName()}));
                }
                if (destAudittrails.isEmpty()) continue;
                this.queryAndCacheMember(ruleId, "epm_audittrialmembertree", SysDimensionEnum.AuditTrail.getNumber(), destAudittrails.toArray(new String[0]));
            }
        }
        if (this.offsetRules.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u53ef\u6267\u884c\u7684\u62b5\u9500\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u53c2\u6570\u4ee5\u53ca\u62b5\u9500\u89c4\u5219\u8bbe\u7f6e\u3002", (String)"OffsetExecutor_30", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public List<OffsetEntry> executeOneRule(OffsetRule rule) {
        ArrayList<OffsetEntry> offsetEntries = new ArrayList<OffsetEntry>(16);
        if (rule == null || this.isStop()) {
            return offsetEntries;
        }
        log.info("******begin executeOneRule******");
        log.info(rule.toString());
        HashSet ruleAccounts = new HashSet(16);
        rule.getSenderAccounts().forEach(e -> ruleAccounts.add(e.getNumber()));
        rule.getRecvAccounts().forEach(e -> ruleAccounts.add(e.getNumber()));
        HashSet<String> ruleMetircs = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)rule.getMetric())) {
            ruleMetircs.add(rule.getMetric());
        }
        if (StringUtils.isNotEmpty((String)rule.getMetricqty())) {
            ruleMetircs.add(rule.getMetricqty());
        }
        Long ruleId = rule.getId();
        List<ReportData> datas = this.dataMap.get(ruleId);
        List ruleData = datas.parallelStream().filter(e -> e.getCurrency().equals(rule.getCurrency()) && e.getAudittrail().equals(rule.getAudittrail()) && ruleAccounts.contains(e.getAccount()) && ruleMetircs.contains(e.getMetric())).collect(Collectors.toList());
        Map<String, List<ReportData>> orgBetweenData = ruleData.parallelStream().filter(e -> this.getContext(ruleId).getOrg2InterOrgMap().get(e.getEntity()) != null).collect(Collectors.groupingBy(e -> {
            String internalcompany;
            String entity = this.getContext(ruleId).getOrg2InterOrgMap().get(e.getEntity());
            return entity.compareTo(internalcompany = e.getInternalcompany()) <= 0 ? entity + "<->" + internalcompany : internalcompany + "<->" + entity;
        }));
        Set<String> groupByKeys = this.getGroupByKeys(rule);
        for (Map.Entry<String, List<ReportData>> entry : orgBetweenData.entrySet()) {
            String[] btworgs = entry.getKey().split("<->");
            List<ReportData> listData = entry.getValue();
            Map<String, List<ReportData>> sameDimdataMap = listData.parallelStream().collect(Collectors.groupingBy(e -> e.getGroupByKey(groupByKeys)));
            for (Map.Entry<String, List<ReportData>> commonentry : sameDimdataMap.entrySet()) {
                List<ReportData> sameDimData = commonentry.getValue();
                if (sameDimData == null || sameDimData.isEmpty()) continue;
                List<ReportData> aSenderData = sameDimData.parallelStream().filter(e -> this.getContext(ruleId).getOrg2InterOrgMap().get(e.getEntity()).equals(btworgs[0]) && e.getInternalcompany().equals(btworgs[1]) && rule.getSenderAccountNumbers().contains(e.getAccount())).collect(Collectors.toList());
                List aSenderData1 = sameDimData.parallelStream().filter(e -> this.getContext(ruleId).getOrg2InterOrgMap().get(e.getEntity()).equals(btworgs[1]) && e.getInternalcompany().equals(btworgs[0]) && rule.getRecvAccountNumbers().contains(e.getAccount())).collect(Collectors.toList());
                aSenderData.addAll(aSenderData1);
                OffsetEntry offsetEntry = this.generateOffsetEntry(rule, aSenderData);
                if (offsetEntry != null && offsetEntry.getDetails() != null && this.checkOffsetEntryDetail(rule, offsetEntry)) {
                    offsetEntries.add(offsetEntry);
                }
                List<ReportData> bSenderData = sameDimData.parallelStream().filter(e -> this.getContext(ruleId).getOrg2InterOrgMap().get(e.getEntity()).equals(btworgs[1]) && e.getInternalcompany().equals(btworgs[0]) && rule.getSenderAccountNumbers().contains(e.getAccount())).collect(Collectors.toList());
                List bSenderData1 = sameDimData.parallelStream().filter(e -> this.getContext(ruleId).getOrg2InterOrgMap().get(e.getEntity()).equals(btworgs[0]) && e.getInternalcompany().equals(btworgs[1]) && rule.getRecvAccountNumbers().contains(e.getAccount())).collect(Collectors.toList());
                bSenderData.addAll(bSenderData1);
                offsetEntry = this.generateOffsetEntry(rule, bSenderData);
                if (offsetEntry == null || offsetEntry.getDetails() == null || !this.checkOffsetEntryDetail(rule, offsetEntry)) continue;
                offsetEntries.add(offsetEntry);
            }
        }
        if (rule.isUnilateral()) {
            ArrayList<OffsetEntry> remove = new ArrayList<OffsetEntry>();
            for (OffsetEntry entry : offsetEntries) {
                if (!entry.isUnilateral()) continue;
                boolean hasZero = true;
                BigDecimal sender = null;
                BigDecimal rece = null;
                if (StringUtils.isNotEmpty((String)rule.getMetric())) {
                    for (OffsetEntry.Detail detail : entry.getDetails()) {
                        if (detail.getSource() == OffsetSourceEnum.SENDER) {
                            if (sender == null) {
                                sender = detail.getAmount();
                                continue;
                            }
                            sender = sender.add(detail.getAmount());
                            continue;
                        }
                        if (rece == null) {
                            rece = detail.getAmount();
                            continue;
                        }
                        rece = rece.add(detail.getAmount());
                    }
                } else if (StringUtils.isNotEmpty((String)rule.getMetricqty())) {
                    for (OffsetEntry.Detail detail : entry.getDetails()) {
                        if (detail.getSource() == OffsetSourceEnum.SENDER) {
                            if (sender == null) {
                                sender = detail.getAmountqty();
                                continue;
                            }
                            sender = sender.add(detail.getAmountqty());
                            continue;
                        }
                        if (rece == null) {
                            rece = detail.getAmountqty();
                            continue;
                        }
                        rece = rece.add(detail.getAmountqty());
                    }
                }
                if (sender != null && sender.compareTo(BigDecimal.ZERO) > 0 || rece != null && rece.compareTo(BigDecimal.ZERO) > 0) {
                    hasZero = false;
                }
                if (!hasZero) continue;
                remove.add(entry);
            }
            if (!remove.isEmpty()) {
                remove.forEach(offsetEntries::remove);
            }
        }
        log.info("******end executeOneRule******");
        return offsetEntries;
    }

    private Set<String> getGroupByKeys(OffsetRule offsetRule) {
        HashSet<String> groupByKeys = new HashSet<String>();
        groupByKeys.add(SysDimensionEnum.BudgetPeriod.getNumber());
        groupByKeys.add(SysDimensionEnum.Version.getNumber());
        groupByKeys.add(SysDimensionEnum.DataType.getNumber());
        groupByKeys.add(SysDimensionEnum.Currency.getNumber());
        groupByKeys.add(SysDimensionEnum.AuditTrail.getNumber());
        groupByKeys.add(SysDimensionEnum.ChangeType.getNumber());
        if (offsetRule != null && offsetRule.getAssistdims() != null && !offsetRule.getAssistdims().isEmpty()) {
            offsetRule.getAssistdims().forEach(e -> groupByKeys.add(this.getContext(offsetRule.getId()).getFieldMapped().get(e)));
        }
        if (offsetRule != null && !offsetRule.isMultiMetrics()) {
            groupByKeys.add(SysDimensionEnum.Metric.getNumber());
        }
        return groupByKeys;
    }

    private OffsetEntry generateOffsetEntry(OffsetRule offsetRule, List<ReportData> reportDataList) {
        if (offsetRule == null || reportDataList == null) {
            return null;
        }
        log.info("******begin generateOffsetEntry on " + offsetRule.getNumber());
        reportDataList.forEach(e -> log.info(ResManager.loadResFormat((String)"\u62a5\u8868\u539f\u59cb\u6570\u636e:%1\u3002", (String)"OffsetExecutor_31", (String)"epm-eb-business", (Object[])new Object[]{e.toString()})));
        List<String> senderAccounts = offsetRule.getSenderAccountNumbers();
        List<String> recvAccounts = offsetRule.getRecvAccountNumbers();
        List<ReportData> senderData = null;
        List<ReportData> recvData = null;
        OffsetEntry offsetEntry = null;
        if (StringUtils.isNotEmpty((String)offsetRule.getMetric()) && (offsetEntry = this.generateOffsetEntryHeader(offsetRule, senderData = reportDataList.parallelStream().filter(e -> senderAccounts.contains(e.getAccount()) && offsetRule.getMetric().equals(e.getMetric())).collect(Collectors.toList()), recvData = reportDataList.parallelStream().filter(e -> recvAccounts.contains(e.getAccount()) && offsetRule.getMetric().equals(e.getMetric())).collect(Collectors.toList()))) != null) {
            this.generateDetailsForAmount(offsetEntry, offsetRule, senderData, recvData);
        }
        if (StringUtils.isNotEmpty((String)offsetRule.getMetricqty())) {
            senderData = reportDataList.parallelStream().filter(e -> senderAccounts.contains(e.getAccount()) && offsetRule.getMetricqty().equals(e.getMetric())).collect(Collectors.toList());
            recvData = reportDataList.parallelStream().filter(e -> recvAccounts.contains(e.getAccount()) && offsetRule.getMetricqty().equals(e.getMetric())).collect(Collectors.toList());
            if (offsetEntry == null) {
                offsetEntry = this.generateOffsetEntryHeader(offsetRule, senderData, recvData);
            }
            if (offsetEntry != null) {
                this.generateDetailsForAmountQty(offsetEntry, offsetRule, senderData, recvData);
            }
        }
        if (offsetEntry != null && offsetEntry.getDetails() != null && this.checkOffsetEntryDetail(offsetRule, offsetEntry)) {
            offsetEntry.setVarhandle(offsetRule.getVarhandle());
            offsetEntry.handleDiff();
            Long ruleId = offsetRule.getId();
            log.info(ResManager.loadResFormat((String)"\u62b5\u9500\u5206\u5f55\u4fe1\u606f\uff1a \u7248\u672c=%1, \u6570\u636e\u7c7b\u578b=%2, \u671f\u95f4=%3, \u53d8\u52a8\u7c7b\u578b=%4, \u5408\u5e76\u8303\u56f4=%5,dim1=%6,dim2=%7,dim3=%8,dim4=%9,dim5=%10,dim6=%11", (String)"OffsetExecutor_24", (String)"epm-eb-business", (Object[])new Object[]{this.getContext(ruleId).id2Number(offsetEntry.getVersionid()), this.getContext(ruleId).id2Number(offsetEntry.getDatatypeid()), this.getContext(ruleId).id2Number(offsetEntry.getPeriodid()), this.getContext(ruleId).id2Number(offsetEntry.getChangetypeid()), this.getContext(ruleId).id2Number(offsetEntry.getCslorgid()), this.getContext(ruleId).id2Number(offsetEntry.getSelfdim1id()), this.getContext(ruleId).id2Number(offsetEntry.getSelfdim2id()), this.getContext(ruleId).id2Number(offsetEntry.getSelfdim3id()), this.getContext(ruleId).id2Number(offsetEntry.getSelfdim4id()), this.getContext(ruleId).id2Number(offsetEntry.getSelfdim5id()), this.getContext(ruleId).id2Number(offsetEntry.getSelfdim6id())}));
            offsetEntry.printDetails();
        }
        log.info("end generateOffsetEntry");
        return offsetEntry;
    }

    protected boolean checkOffsetEntryDetail(OffsetRule offsetRule, OffsetEntry offsetEntry) {
        return offsetEntry.getDetails().size() > 1 || offsetRule.isUnilateral() && !offsetEntry.getDetails().isEmpty();
    }

    private OffsetEntry generateOffsetEntryHeader(OffsetRule offsetRule, List<ReportData> senderData, List<ReportData> recvData) {
        if (offsetRule == null || senderData == null || recvData == null || senderData.isEmpty() && recvData.isEmpty()) {
            return null;
        }
        Long ruleId = offsetRule.getId();
        OffsetEntry offsetEntry = new OffsetEntry(offsetRule);
        offsetEntry.setStatus(OffsetEntryStatusEnum.SYSGEN.getIndex());
        offsetEntry.setModelid(offsetRule.getModelID());
        offsetEntry.setAudittrailid(offsetRule.getDestaudittrailID());
        offsetEntry.setCurrencyid(offsetRule.getCurrencyID());
        offsetEntry.setMetricid(offsetRule.getMetricID());
        offsetEntry.setMetricqtyid(offsetRule.getMetricqtyID());
        offsetEntry.setOffsetruleid(ruleId);
        offsetEntry.setOffsetcatalog(offsetRule.getOffsetCatalog());
        offsetEntry.setBusmodelid(offsetRule.getBusmodelID());
        offsetEntry.setFieldMap(this.getFieldMapped(ruleId));
        ReportData d = senderData.size() > 0 ? senderData.get(0) : recvData.get(0);
        String cslOrgNum = this.getCslOrg(ruleId, offsetRule.getOrgs(), offsetRule.getEntityViewId(), d.getEntity(), d.getInternalcompany());
        if (cslOrgNum == null) {
            return null;
        }
        offsetEntry.setCslorgid(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), cslOrgNum));
        if (!this.param.getOrgs().contains(cslOrgNum)) {
            return null;
        }
        offsetEntry.setOffsetorgid(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), cslOrgNum + "offsetentry"));
        offsetEntry.setVersionid(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Version.getNumber(), d.getVersion()));
        offsetEntry.setDatatypeid(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.DataType.getNumber(), d.getDatatype()));
        offsetEntry.setPeriodid(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.BudgetPeriod.getNumber(), d.getPeriod()));
        offsetEntry.setChangetypeid(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.ChangeType.getNumber(), d.getChangetype()));
        List<String> userDefineDims = this.getContext(ruleId).getUserDefineDims();
        if (userDefineDims != null && !userDefineDims.isEmpty()) {
            userDefineDims.forEach(e -> {
                String dimIndex = this.getFieldMapped(ruleId).get(e);
                if ("dim1".equals(dimIndex)) {
                    if (offsetRule.getAssistdims() != null && offsetRule.getAssistdims().contains(e)) {
                        offsetEntry.setSelfdim1id(this.getContext(ruleId).getMembIdFromCache((String)e, d.getDim1()));
                    } else {
                        offsetEntry.setSelfdim1id(this.getContext(ruleId).getMembIdFromCache((String)e, this.modelCacheHelper.getDimension(e).getNoneNumber()));
                    }
                } else if ("dim2".equals(dimIndex)) {
                    if (offsetRule.getAssistdims() != null && offsetRule.getAssistdims().contains(e)) {
                        offsetEntry.setSelfdim2id(this.getContext(ruleId).getMembIdFromCache((String)e, d.getDim2()));
                    } else {
                        offsetEntry.setSelfdim2id(this.getContext(ruleId).getMembIdFromCache((String)e, this.modelCacheHelper.getDimension(e).getNoneNumber()));
                    }
                } else if ("dim3".equals(dimIndex)) {
                    if (offsetRule.getAssistdims() != null && offsetRule.getAssistdims().contains(e)) {
                        offsetEntry.setSelfdim3id(this.getContext(ruleId).getMembIdFromCache((String)e, d.getDim3()));
                    } else {
                        offsetEntry.setSelfdim3id(this.getContext(ruleId).getMembIdFromCache((String)e, this.modelCacheHelper.getDimension(e).getNoneNumber()));
                    }
                } else if ("dim4".equals(dimIndex)) {
                    if (offsetRule.getAssistdims() != null && offsetRule.getAssistdims().contains(e)) {
                        offsetEntry.setSelfdim4id(this.getContext(ruleId).getMembIdFromCache((String)e, d.getDim4()));
                    } else {
                        offsetEntry.setSelfdim4id(this.getContext(ruleId).getMembIdFromCache((String)e, this.modelCacheHelper.getDimension(e).getNoneNumber()));
                    }
                } else if ("dim5".equals(dimIndex)) {
                    if (offsetRule.getAssistdims() != null && offsetRule.getAssistdims().contains(e)) {
                        offsetEntry.setSelfdim5id(this.getContext(ruleId).getMembIdFromCache((String)e, d.getDim5()));
                    } else {
                        offsetEntry.setSelfdim5id(this.getContext(ruleId).getMembIdFromCache((String)e, this.modelCacheHelper.getDimension(e).getNoneNumber()));
                    }
                } else if ("dim6".equals(dimIndex)) {
                    if (offsetRule.getAssistdims() != null && offsetRule.getAssistdims().contains(e)) {
                        offsetEntry.setSelfdim6id(this.getContext(ruleId).getMembIdFromCache((String)e, d.getDim6()));
                    } else {
                        offsetEntry.setSelfdim6id(this.getContext(ruleId).getMembIdFromCache((String)e, this.modelCacheHelper.getDimension(e).getNoneNumber()));
                    }
                }
            });
        }
        return offsetEntry;
    }

    private void generateDetailsForAmount(OffsetEntry offsetEntry, OffsetRule offsetRule, List<ReportData> senderDatas, List<ReportData> recvDatas) {
        OffsetEntry.Detail _detail;
        if (this.isMisMatchCnt(offsetEntry, offsetRule, senderDatas, recvDatas)) {
            return;
        }
        ReportData sendData = null;
        ReportData recvData = null;
        Long ruleId = offsetRule.getId();
        OffsetExecuteContext context = this.getContext(ruleId);
        offsetEntry.setAccountDCMap(this.getContext(ruleId).getAccountDCMap());
        offsetEntry.setVarhandle(offsetRule.getVarhandle());
        offsetEntry.setVaraccount(offsetRule.getVarhandleAccount());
        for (ReportData reportData : senderDatas) {
            _detail = offsetEntry.addOrUpdateDetail(context.getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), reportData.getEntity()), context.getMembIdFromCache(SysDimensionEnum.InternalCompany.getNumber(), reportData.getInternalcompany()), context.getMembIdFromCache(SysDimensionEnum.Account.getNumber(), reportData.getAccount()), reportData.getDatasetID(), OffsetSourceEnum.SENDER, reportData.getValue(), null);
            if (_detail == null) continue;
            sendData = reportData;
        }
        for (ReportData reportData : recvDatas) {
            _detail = offsetEntry.addOrUpdateDetail(context.getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), reportData.getEntity()), context.getMembIdFromCache(SysDimensionEnum.InternalCompany.getNumber(), reportData.getInternalcompany()), context.getMembIdFromCache(SysDimensionEnum.Account.getNumber(), reportData.getAccount()), reportData.getDatasetID(), OffsetSourceEnum.RECEIVER, reportData.getValue(), null);
            if (_detail == null) continue;
            recvData = reportData;
        }
        if (offsetRule.isUnilateral()) {
            AccountMember account;
            boolean hasSendData = false;
            boolean hasRecvData = false;
            for (OffsetEntry.Detail detail : offsetEntry.getDetails()) {
                if (detail.getSource() == OffsetSourceEnum.SENDER) {
                    hasSendData = true;
                    continue;
                }
                if (detail.getSource() != OffsetSourceEnum.RECEIVER) continue;
                hasRecvData = true;
            }
            if (hasSendData && !hasRecvData && sendData != null && !offsetRule.getRecvAccounts().isEmpty()) {
                offsetEntry.setUnilateral(true);
                account = offsetRule.getRecvAccounts().get(0);
                offsetEntry.addOrUpdateDetail(context.getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), sendData.getInternalcompany()), this.getParentMemberByOrg(context, offsetRule, "InternalCompany", sendData.getEntity()), context.getMembIdFromCache(SysDimensionEnum.Account.getNumber(), account.getNumber()), account.getDatasetId(), OffsetSourceEnum.RECEIVER, BigDecimal.ZERO, null);
            }
            if (!hasSendData && hasRecvData && recvData != null && !offsetRule.getSenderAccounts().isEmpty()) {
                offsetEntry.setUnilateral(true);
                account = offsetRule.getSenderAccounts().get(0);
                offsetEntry.addOrUpdateDetail(context.getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), recvData.getInternalcompany()), this.getParentMemberByOrg(context, offsetRule, "InternalCompany", recvData.getEntity()), context.getMembIdFromCache(SysDimensionEnum.Account.getNumber(), account.getNumber()), account.getDatasetId(), OffsetSourceEnum.SENDER, BigDecimal.ZERO, null);
            }
        }
    }

    private Long getParentMemberByOrg(OffsetExecuteContext context, OffsetRule rule, String dimNumber, String memberNumber) {
        Long memberId = context.getMembIdFromCache(dimNumber, memberNumber);
        if (memberId == null && StringUtils.equals((String)"InternalCompany", (String)dimNumber)) {
            String longNumber;
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)rule.getModelID());
            builder.add("view", "=", (Object)rule.getEntityViewId());
            builder.add("number", "=", (Object)memberNumber);
            DynamicObject entity = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_viewmember", (String)"id,longnumber", (QFilter[])builder.toArray());
            if (entity != null && (longNumber = entity.getString("longnumber")) != null) {
                String[] parents = longNumber.split("!");
                for (int i = parents.length - 1; i >= 0 && (memberId = context.getMembIdFromCache(dimNumber, parents[i])) == null; --i) {
                }
            }
        }
        return memberId;
    }

    private void generateDetailsForAmountQty(OffsetEntry offsetEntry, OffsetRule offsetRule, List<ReportData> senderDatas, List<ReportData> recvDatas) {
        OffsetEntry.Detail _detail;
        if (this.isMisMatchCnt(offsetEntry, offsetRule, senderDatas, recvDatas)) {
            return;
        }
        ReportData sendData = null;
        ReportData recvData = null;
        Long ruleId = offsetRule.getId();
        for (ReportData reportData : senderDatas) {
            _detail = offsetEntry.addOrUpdateDetail(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), reportData.getEntity()), this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.InternalCompany.getNumber(), reportData.getInternalcompany()), this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Account.getNumber(), reportData.getAccount()), this.modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, reportData.getAccount()).getDatasetId(), OffsetSourceEnum.SENDER, null, reportData.getValue());
            if (_detail == null) continue;
            sendData = reportData;
        }
        for (ReportData reportData : recvDatas) {
            _detail = offsetEntry.addOrUpdateDetail(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), reportData.getEntity()), this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.InternalCompany.getNumber(), reportData.getInternalcompany()), this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Account.getNumber(), reportData.getAccount()), this.modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, reportData.getAccount()).getDatasetId(), OffsetSourceEnum.RECEIVER, null, reportData.getValue());
            if (_detail == null) continue;
            recvData = reportData;
        }
        if (offsetRule.isUnilateral()) {
            AccountMember account;
            boolean hasSendData = false;
            boolean hasRecvData = false;
            for (OffsetEntry.Detail detail : offsetEntry.getDetails()) {
                if (detail.getSource() == OffsetSourceEnum.SENDER) {
                    hasSendData = true;
                    continue;
                }
                if (detail.getSource() != OffsetSourceEnum.RECEIVER) continue;
                hasRecvData = true;
            }
            if (hasSendData && !hasRecvData && sendData != null && !offsetRule.getRecvAccounts().isEmpty()) {
                offsetEntry.setUnilateral(true);
                account = offsetRule.getRecvAccounts().get(0);
                offsetEntry.addOrUpdateDetail(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), sendData.getInternalcompany()), this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.InternalCompany.getNumber(), sendData.getEntity()), this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Account.getNumber(), account.getNumber()), account.getDatasetId(), OffsetSourceEnum.RECEIVER, BigDecimal.ZERO, null);
            }
            if (!hasSendData && hasRecvData && recvData != null && !offsetRule.getSenderAccounts().isEmpty()) {
                offsetEntry.setUnilateral(true);
                account = offsetRule.getSenderAccounts().get(0);
                offsetEntry.addOrUpdateDetail(this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), recvData.getInternalcompany()), this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.InternalCompany.getNumber(), recvData.getEntity()), this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Account.getNumber(), account.getNumber()), account.getDatasetId(), OffsetSourceEnum.SENDER, BigDecimal.ZERO, null);
            }
        }
    }

    private boolean isMisMatchCnt(OffsetEntry offsetEntry, OffsetRule offsetRule, List<ReportData> senderData, List<ReportData> recvData) {
        if (offsetEntry == null || offsetRule == null || senderData == null || recvData == null || senderData.isEmpty() && recvData.isEmpty()) {
            return true;
        }
        if (senderData.isEmpty() || recvData.isEmpty()) {
            if (offsetRule.isUnilateral() && this.checkDataValue(senderData, recvData)) {
                return false;
            }
            if (!senderData.isEmpty()) {
                this.setLogEntrys(offsetEntry, offsetRule, senderData);
            } else {
                this.setLogEntrys(offsetEntry, offsetRule, recvData);
            }
            ++this.misMatchCnt;
            return !offsetRule.isUnilateral();
        }
        return false;
    }

    protected boolean checkDataValue(List<ReportData> senderData, List<ReportData> recvData) {
        BigDecimal value = BigDecimal.ZERO;
        if (!senderData.isEmpty()) {
            for (ReportData data : senderData) {
                value = value.add(data.getValue());
            }
        }
        if (!recvData.isEmpty()) {
            for (ReportData data : recvData) {
                value = value.add(data.getValue());
            }
        }
        return value.compareTo(BigDecimal.ZERO) > 0;
    }

    private void setLogEntrys(OffsetEntry offsetEntry, OffsetRule offsetRule, List<ReportData> recvData) {
        Long ruleId = offsetRule.getId();
        for (ReportData reportData : recvData) {
            Long myaccount = this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Account.getNumber(), reportData.getAccount());
            List<AccountMember> interAccounts = offsetRule.getRecvAccounts().stream().map(BaseCache::getId).anyMatch(e -> IDUtils.equals((Object)e, (Object)myaccount)) ? offsetRule.getSenderAccounts() : offsetRule.getRecvAccounts();
            for (AccountMember accountMember : interAccounts) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_offsetexelogentry");
                dynamicObject.set("offsetrule", (Object)ruleId);
                dynamicObject.set("cslorg", (Object)offsetEntry.getCslorgid());
                dynamicObject.set("period", (Object)offsetEntry.getPeriodid());
                dynamicObject.set("myorg", (Object)this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), reportData.getEntity()));
                dynamicObject.set("myaccount", (Object)myaccount);
                dynamicObject.set("myamount", (Object)reportData.getValue());
                if ("Money".equals(reportData.getMetric())) {
                    int accountDirection = this.getContext(ruleId).getAccountDCMap().get(dynamicObject.getLong("myaccount"));
                    if (AccountDirectionEnum.DEBIT.getIndex() == accountDirection) {
                        dynamicObject.set("amountd", (Object)reportData.getValue());
                    } else if (AccountDirectionEnum.CREDIT.getIndex() == accountDirection) {
                        dynamicObject.set("amountc", (Object)reportData.getValue());
                    }
                } else if ("Amount".equals(reportData.getMetric())) {
                    dynamicObject.set("amountqty", (Object)reportData.getValue());
                }
                dynamicObject.set("metric", (Object)offsetEntry.getMetricid());
                dynamicObject.set("interorg", (Object)this.getContext(ruleId).getMembIdFromCache(SysDimensionEnum.Entity.getNumber(), reportData.getInternalcompany()));
                dynamicObject.set("interaccount", (Object)accountMember.getId());
                dynamicObject.set("selfdim1", (Object)offsetEntry.getSelfdim1id());
                dynamicObject.set("selfdim2", (Object)offsetEntry.getSelfdim2id());
                dynamicObject.set("selfdim3", (Object)offsetEntry.getSelfdim3id());
                dynamicObject.set("selfdim4", (Object)offsetEntry.getSelfdim4id());
                dynamicObject.set("selfdim5", (Object)offsetEntry.getSelfdim5id());
                dynamicObject.set("selfdim6", (Object)offsetEntry.getSelfdim6id());
                this.logEntrys.add(dynamicObject);
            }
        }
    }

    private ReportData buildReportData(BGCell bgCell, OffsetRule offsetRule) {
        if (bgCell == null) {
            return null;
        }
        Map memberMap = bgCell.getMemberMap();
        ReportData data = new ReportData();
        data.setEntity((String)memberMap.get(SysDimensionEnum.Entity.getNumber()));
        data.setAccount((String)memberMap.get(SysDimensionEnum.Account.getNumber()));
        data.setPeriod((String)memberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()));
        data.setCurrency((String)memberMap.get(SysDimensionEnum.Currency.getNumber()));
        data.setAudittrail((String)memberMap.get(SysDimensionEnum.AuditTrail.getNumber()));
        data.setChangetype((String)memberMap.get(SysDimensionEnum.ChangeType.getNumber()));
        data.setInternalcompany((String)memberMap.get(SysDimensionEnum.InternalCompany.getNumber()));
        data.setMetric((String)memberMap.get(SysDimensionEnum.Metric.getNumber()));
        data.setVersion((String)memberMap.get(SysDimensionEnum.Version.getNumber()));
        data.setDatatype((String)memberMap.get(SysDimensionEnum.DataType.getNumber()));
        List<String> userDefineDims = this.getContext(offsetRule.getId()).getUserDefineDims();
        if (userDefineDims == null) {
            userDefineDims = Collections.emptyList();
        }
        Map<String, String> assisDimMapped = this.getContext(offsetRule.getId()).getFieldMapped();
        ArrayList<String> assisDimList = new ArrayList<String>(6);
        for (String userDim : userDefineDims) {
            if (!assisDimMapped.containsKey(userDim)) continue;
            assisDimList.add(userDim);
        }
        for (int i = 0; i < 6; ++i) {
            if (i < assisDimList.size()) continue;
            assisDimList.add("");
        }
        data.setDim1((String)memberMap.get(assisDimList.get(0)));
        data.setDim2((String)memberMap.get(assisDimList.get(1)));
        data.setDim3((String)memberMap.get(assisDimList.get(2)));
        data.setDim4((String)memberMap.get(assisDimList.get(3)));
        data.setDim5((String)memberMap.get(assisDimList.get(4)));
        data.setDim6((String)memberMap.get(assisDimList.get(5)));
        if (bgCell.getValue() != null) {
            data.setValue(ConvertUtils.toDecimal((Object)bgCell.getValue()));
        }
        return data;
    }

    public List<DynamicObject> buildOffsetEntryDynamicObject(List<OffsetEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(entries.size());
        for (OffsetEntry offsetEntry : entries) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_offsetentry");
            dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynamicObject.set("number", (Object)("S-" + dynamicObject.get("id")));
            dynamicObject.set("model", (Object)offsetEntry.getModelid());
            dynamicObject.set("version", (Object)offsetEntry.getVersionid());
            dynamicObject.set("datatype", (Object)offsetEntry.getDatatypeid());
            dynamicObject.set("cslorg", (Object)offsetEntry.getCslorgid());
            dynamicObject.set("offsetorg", (Object)offsetEntry.getOffsetorgid());
            dynamicObject.set("period", (Object)offsetEntry.getPeriodid());
            dynamicObject.set("audittrail", (Object)offsetEntry.getAudittrailid());
            dynamicObject.set("changetype", (Object)offsetEntry.getChangetypeid());
            dynamicObject.set("currency", (Object)offsetEntry.getCurrencyid());
            dynamicObject.set("metric", (Object)offsetEntry.getMetricid());
            dynamicObject.set("metricqty", (Object)offsetEntry.getMetricqtyid());
            dynamicObject.set("selfdim1", (Object)offsetEntry.getSelfdim1id());
            dynamicObject.set("selfdim2", (Object)offsetEntry.getSelfdim2id());
            dynamicObject.set("selfdim3", (Object)offsetEntry.getSelfdim3id());
            dynamicObject.set("selfdim4", (Object)offsetEntry.getSelfdim4id());
            dynamicObject.set("selfdim5", (Object)offsetEntry.getSelfdim5id());
            dynamicObject.set("selfdim6", (Object)offsetEntry.getSelfdim6id());
            dynamicObject.set("offsetrule", (Object)offsetEntry.getOffsetruleid());
            dynamicObject.set("offsetcatalog", (Object)offsetEntry.getOffsetcatalog());
            dynamicObject.set("busmodel", (Object)offsetEntry.getBusmodelid());
            dynamicObject.set("status", (Object)OffsetEntryStatusEnum.SYSGEN.getIndex());
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("modifytime", (Object)now);
            dynamicObject.set("creator", (Object)userId);
            dynamicObject.set("createtime", (Object)now);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            int seq = 0;
            for (OffsetEntry.Detail e : offsetEntry.getDetails()) {
                DynamicObject d = new DynamicObject(entryentity.getDynamicObjectType());
                d.set("seq", (Object)seq++);
                d.set("myorg", (Object)e.getMyorgid());
                d.set("interorg", (Object)e.getInterorgid());
                d.set("account", (Object)e.getAccountid());
                d.set("source", (Object)e.getSource().getIndex());
                d.set("amount", (Object)e.getAmount());
                if (AccountDirectionEnum.DEBIT.getIndex() == offsetEntry.getAccountDC(e.getAccountid()).intValue()) {
                    d.set("amountd", (Object)e.getAmount());
                } else if (AccountDirectionEnum.CREDIT.getIndex() == offsetEntry.getAccountDC(e.getAccountid()).intValue()) {
                    d.set("amountc", (Object)e.getAmount());
                }
                d.set("amountqty", (Object)e.getAmountqty());
                entryentity.add((Object)d);
            }
            result.add(dynamicObject);
        }
        return result;
    }

    public Map<String, Object> getExecuteResult() {
        return this.executeResult;
    }

    private void addResultMsg(String msg) {
        String m = (String)this.getExecuteResult().get(CACHEKEY_MSG);
        if (m == null) {
            this.getExecuteResult().put(CACHEKEY_MSG, msg);
        } else {
            this.getExecuteResult().put(CACHEKEY_MSG, m + msg);
        }
    }

    public void setExecuteResult(Map<String, Object> executeResult) {
        this.executeResult = executeResult;
    }

    private boolean isStop() {
        String startProgress = new PageCache(this.pageId).get(CACHEKEY_STARTPROPGRESS);
        return StringUtils.isNotEmpty((String)startProgress) && startProgress.equals("false");
    }

    private void putInPageCache(String key, String value) {
        new PageCache(this.pageId).put(key, value);
    }

    public OffsetExecuteContext getContext(long ruleId) {
        return this.contextMap.computeIfAbsent(ruleId, k -> new OffsetExecuteContext(this.param));
    }
}

