/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.combinoffset;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.combinoffset.OffsetEntry;
import kd.epm.eb.business.combinoffset.OffsetRule;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.AccountMember;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.AccountDirectionEnum;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.VarhandleEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class OffsetHelper {
    public static List getAssistDims(Long modelId, Long busModelId) {
        String assistdim;
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)busModelId).booleanValue()) {
            return null;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("busmodel", "=", (Object)busModelId));
        qFilters.add(new QFilter("level", "=", (Object)2));
        DynamicObject offsetRuleCatalog = BusinessDataServiceHelper.loadSingle((String)"eb_offsetrulecatalog", (String)"id,parent,number,longnumber,level,ispreset,assistdim", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        String string = assistdim = offsetRuleCatalog == null ? null : offsetRuleCatalog.getString("assistdim");
        if (assistdim != null) {
            String[] assistdimSplit;
            ArrayList<String> assistdims = new ArrayList<String>(16);
            for (String d : assistdimSplit = assistdim.split(",")) {
                if (!StringUtils.isNotEmpty((String)d) || assistdims.contains(d)) continue;
                assistdims.add(d);
            }
            return assistdims;
        }
        return null;
    }

    public static void accomplishMembers(BgData bgdata, List<kd.epm.eb.common.model.Dimension> dimensions) {
        if (bgdata == null || dimensions == null || dimensions.isEmpty()) {
            return;
        }
        Map memberMap = bgdata.getMemberMap();
        if (dimensions != null && memberMap != null && dimensions.size() != memberMap.size()) {
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                if (memberMap.get(dimension.getNumber()) != null) continue;
                bgdata.setMember(dimension.getNumber(), dimension.getShortNumber() + "None");
            }
        }
    }

    public static void accomplishMembers(BgData bgdata, Set<String> dimensions, IModelCacheHelper modelCacheHelper) {
        if (bgdata == null || dimensions == null || dimensions.isEmpty()) {
            return;
        }
        Map memberMap = bgdata.getMemberMap();
        if (dimensions != null && memberMap != null && dimensions.size() != memberMap.size()) {
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)bgdata.getModelId());
            }
            for (String dimension : dimensions) {
                if (memberMap.get(dimension) != null) continue;
                bgdata.setMember(dimension, modelCacheHelper.getDimension(dimension).getShortNumber() + "None");
            }
        }
    }

    public static List<BgData> getBgDataFromOffsetEntries(Collection<OffsetEntry> offsetEntries, IModelCacheHelper modelCacheHelper) {
        ArrayList<BgData> bgdatas = new ArrayList<BgData>(16);
        if (offsetEntries != null) {
            for (OffsetEntry offsetEntry : offsetEntries) {
                if (offsetEntry == null || offsetEntry.getDetails() == null || offsetEntry.getDetails().isEmpty()) continue;
                if (modelCacheHelper == null) {
                    modelCacheHelper = ModelCacheContext.getOrCreate((Long)offsetEntry.getModelid());
                }
                Map<String, String> fieldMap = offsetEntry.getFieldMap();
                String versionNumber = modelCacheHelper.getDimension(SysDimensionEnum.Version.getNumber()).getStructOfMember(offsetEntry.getVersionid()).getNumber();
                String dataTypeNumber = modelCacheHelper.getDimension(SysDimensionEnum.DataType.getNumber()).getStructOfMember(offsetEntry.getDatatypeid()).getNumber();
                String periodNumber = modelCacheHelper.getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getStructOfMember(offsetEntry.getPeriodid()).getNumber();
                String auditTrailNumber = modelCacheHelper.getDimension(SysDimensionEnum.AuditTrail.getNumber()).getStructOfMember(offsetEntry.getAudittrailid()).getNumber();
                String currencyNumber = modelCacheHelper.getDimension(SysDimensionEnum.Currency.getNumber()).getStructOfMember(offsetEntry.getCurrencyid()).getNumber();
                String metricNumber = IDUtils.isNull((Long)offsetEntry.getMetricid()) ? null : modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber()).getStructOfMember(offsetEntry.getMetricid()).getNumber();
                String metricQtyNumber = IDUtils.isNull((Long)offsetEntry.getMetricqtyid()) ? null : modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber()).getStructOfMember(offsetEntry.getMetricqtyid()).getNumber();
                String changeTypeNumber = modelCacheHelper.getDimension(SysDimensionEnum.ChangeType.getNumber()).getStructOfMember(offsetEntry.getChangetypeid()).getNumber();
                String entityNumber = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber()).getStructOfMember(offsetEntry.getOffsetorgid()).getNumber();
                String internalCompanyNumber = "ICNone";
                String dim1Number = null;
                String dim2Number = null;
                String dim3Number = null;
                String dim4Number = null;
                String dim5Number = null;
                String dim6Number = null;
                if (fieldMap != null) {
                    if (offsetEntry.getSelfdim1id() != null && fieldMap.get("dim1") != null) {
                        dim1Number = modelCacheHelper.getDimension(fieldMap.get("dim1")).getStructOfMember(offsetEntry.getSelfdim1id()).getNumber();
                    }
                    if (offsetEntry.getSelfdim2id() != null && fieldMap.get("dim2") != null) {
                        dim2Number = modelCacheHelper.getDimension(fieldMap.get("dim2")).getStructOfMember(offsetEntry.getSelfdim2id()).getNumber();
                    }
                    if (offsetEntry.getSelfdim3id() != null && fieldMap.get("dim3") != null) {
                        dim3Number = modelCacheHelper.getDimension(fieldMap.get("dim3")).getStructOfMember(offsetEntry.getSelfdim3id()).getNumber();
                    }
                    if (offsetEntry.getSelfdim4id() != null && fieldMap.get("dim4") != null) {
                        dim4Number = modelCacheHelper.getDimension(fieldMap.get("dim4")).getStructOfMember(offsetEntry.getSelfdim4id()).getNumber();
                    }
                    if (offsetEntry.getSelfdim5id() != null && fieldMap.get("dim5") != null) {
                        dim5Number = modelCacheHelper.getDimension(fieldMap.get("dim5")).getStructOfMember(offsetEntry.getSelfdim5id()).getNumber();
                    }
                    if (offsetEntry.getSelfdim6id() != null && fieldMap.get("dim6") != null) {
                        dim6Number = modelCacheHelper.getDimension(fieldMap.get("dim6")).getStructOfMember(offsetEntry.getSelfdim6id()).getNumber();
                    }
                }
                for (OffsetEntry.Detail e : offsetEntry.getDetails()) {
                    BgData bgData = new BgData(offsetEntry.getModelid());
                    bgData.setMember(SysDimensionEnum.Version.getNumber(), versionNumber);
                    bgData.setMember(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
                    bgData.setMember(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
                    bgData.setMember(SysDimensionEnum.AuditTrail.getNumber(), auditTrailNumber);
                    bgData.setMember(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                    bgData.setMember(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
                    if (dim1Number != null) {
                        bgData.setMember(fieldMap.get("dim1"), dim1Number);
                    }
                    if (dim2Number != null) {
                        bgData.setMember(fieldMap.get("dim2"), dim2Number);
                    }
                    if (dim3Number != null) {
                        bgData.setMember(fieldMap.get("dim3"), dim3Number);
                    }
                    if (dim4Number != null) {
                        bgData.setMember(fieldMap.get("dim4"), dim4Number);
                    }
                    if (dim5Number != null) {
                        bgData.setMember(fieldMap.get("dim5"), dim5Number);
                    }
                    if (dim6Number != null) {
                        bgData.setMember(fieldMap.get("dim6"), dim6Number);
                    }
                    bgData.setMember(SysDimensionEnum.Entity.getNumber(), entityNumber);
                    bgData.setMember(SysDimensionEnum.InternalCompany.getNumber(), internalCompanyNumber);
                    Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), e.getAccountid());
                    if (accountMember == null) continue;
                    bgData.setMember(SysDimensionEnum.Account.getNumber(), accountMember.getNumber());
                    bgData.setDatasetId(accountMember.getDatasetId());
                    OffsetHelper.accomplishMembers(bgData, modelCacheHelper.getDimensionList(accountMember.getDatasetId()).stream().map(dim -> kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)dim)).collect(Collectors.toList()));
                    if (metricNumber != null && metricQtyNumber != null) {
                        bgData.setMember(SysDimensionEnum.Metric.getNumber(), metricNumber);
                        bgData.setValue(e.getAmount() != null ? e.getAmount().negate() : null);
                        if (!BigDecimal.ZERO.equals(e.getAmount())) {
                            bgdatas.add(bgData);
                        }
                        if (BigDecimal.ZERO.equals(e.getAmountqty())) continue;
                        BgData bgDataQty = bgData.clone();
                        bgDataQty.setMember(SysDimensionEnum.Metric.getNumber(), metricQtyNumber);
                        bgDataQty.setValue(e.getAmountqty() != null ? e.getAmountqty().negate() : null);
                        bgdatas.add(bgDataQty);
                        continue;
                    }
                    if (metricNumber != null) {
                        bgData.setMember(SysDimensionEnum.Metric.getNumber(), metricNumber);
                        bgData.setValue(e.getAmount() != null ? e.getAmount().negate() : null);
                        bgdatas.add(bgData);
                    }
                    if (metricQtyNumber == null) continue;
                    bgData.setMember(SysDimensionEnum.Metric.getNumber(), metricQtyNumber);
                    bgData.setValue(e.getAmountqty() != null ? e.getAmountqty().negate() : null);
                    bgdatas.add(bgData);
                }
            }
        }
        return bgdatas;
    }

    public static List<BgData> getBgDataFromOffsetEntryObjects(Collection<DynamicObject> offsetEntryObjects, IModelCacheHelper modelCacheHelper) {
        if (offsetEntryObjects == null || offsetEntryObjects.isEmpty()) {
            return null;
        }
        ArrayList<BgData> bgdatas = new ArrayList<BgData>(16);
        HashMap dataSetDims = new HashMap(16);
        for (DynamicObject offset : offsetEntryObjects) {
            Long modelid = offset.getLong("model.id");
            String versionNumber = offset.getString("version.number");
            String dataTypeNumber = offset.getString("datatype.number");
            String periodNumber = offset.getString("period.number");
            String auditTrailNumber = offset.getString("audittrail.number");
            String currencyNumber = offset.getString("currency.number");
            String changeTypeNumber = offset.getString("changetype.number");
            String entityNumber = offset.getString("offsetorg.number");
            String internalCompanyNumber = "ICNone";
            DynamicObjectCollection details = offset.getDynamicObjectCollection("entryentity");
            details.forEach(e -> {
                BgData bgData = new BgData(modelid);
                bgData.setMember(SysDimensionEnum.Version.getNumber(), versionNumber);
                bgData.setMember(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
                bgData.setMember(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
                bgData.setMember(SysDimensionEnum.AuditTrail.getNumber(), auditTrailNumber);
                bgData.setMember(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                bgData.setMember(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
                bgData.setMember(SysDimensionEnum.Entity.getNumber(), entityNumber);
                bgData.setMember(SysDimensionEnum.InternalCompany.getNumber(), internalCompanyNumber);
                bgData.setMember(SysDimensionEnum.Account.getNumber(), e.getString("account.number"));
                bgData.setDatasetId(Long.valueOf(e.getLong("account.dataset.id")));
                Set dimNumbers = dataSetDims.computeIfAbsent(bgData.getDatasetId(), f -> modelCacheHelper.getDimensionList(bgData.getDatasetId()).stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                if (offset.getString("selfdim1") != null && dimNumbers.contains(offset.getString("selfdim1.dimension.number"))) {
                    bgData.setMember(offset.getString("selfdim1.dimension.number"), offset.getString("selfdim1.number"));
                }
                if (offset.getString("selfdim2") != null && dimNumbers.contains(offset.getString("selfdim2.dimension.number"))) {
                    bgData.setMember(offset.getString("selfdim2.dimension.number"), offset.getString("selfdim2.number"));
                }
                if (offset.getString("selfdim3") != null && dimNumbers.contains(offset.getString("selfdim3.dimension.number"))) {
                    bgData.setMember(offset.getString("selfdim3.dimension.number"), offset.getString("selfdim3.number"));
                }
                if (offset.getString("selfdim4") != null && dimNumbers.contains(offset.getString("selfdim4.dimension.number"))) {
                    bgData.setMember(offset.getString("selfdim4.dimension.number"), offset.getString("selfdim4.number"));
                }
                if (offset.getString("selfdim5") != null && dimNumbers.contains(offset.getString("selfdim5.dimension.number"))) {
                    bgData.setMember(offset.getString("selfdim5.dimension.number"), offset.getString("selfdim5.number"));
                }
                if (offset.getString("selfdim6") != null && dimNumbers.contains(offset.getString("selfdim6.dimension.number"))) {
                    bgData.setMember(offset.getString("selfdim6.dimension.number"), offset.getString("selfdim6.number"));
                }
                if (StringUtils.isNotEmpty((String)offset.getString("metric.number")) && StringUtils.isNotEmpty((String)offset.getString("metricqty.number"))) {
                    if (e.getBigDecimal("amount") != null) {
                        bgData.setMember(SysDimensionEnum.Metric.getNumber(), offset.getString("metric.number"));
                        bgData.setValue(e.getBigDecimal("amount").negate());
                        bgdatas.add(bgData);
                    }
                    if (e.getBigDecimal("amountqty") != null) {
                        BgData bgDataQty = bgData.clone();
                        bgDataQty.setMember(SysDimensionEnum.Metric.getNumber(), offset.getString("metricqty.number"));
                        bgDataQty.setValue(e.getBigDecimal("amountqty").negate());
                        bgdatas.add(bgDataQty);
                    }
                } else {
                    if (StringUtils.isNotEmpty((String)offset.getString("metric.number"))) {
                        bgData.setMember(SysDimensionEnum.Metric.getNumber(), offset.getString("metric.number"));
                        bgData.setValue(e.getBigDecimal("amount").negate());
                        bgdatas.add(bgData);
                    }
                    if (StringUtils.isNotEmpty((String)offset.getString("metricqty.number"))) {
                        bgData.setMember(SysDimensionEnum.Metric.getNumber(), offset.getString("metricqty.number"));
                        bgData.setValue(e.getBigDecimal("amountqty").negate());
                        bgdatas.add(bgData);
                    }
                }
            });
        }
        return bgdatas;
    }

    public static List<BgData> accomplishMembers(List<BgData> bgdatas, IModelCacheHelper modelCacheHelper) {
        if (bgdatas != null && !bgdatas.isEmpty()) {
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)bgdatas.get(0).getModelId());
            }
            Map<Long, List<BgData>> datasetDatas = bgdatas.parallelStream().collect(Collectors.groupingBy(bgData -> bgData.getDatasetId()));
            Long datasetId = null;
            for (Map.Entry<Long, List<BgData>> entry : datasetDatas.entrySet()) {
                datasetId = entry.getKey();
                List dimensions = modelCacheHelper.getDimensionList(datasetId);
                int dimSize = dimensions.size();
                for (BgData bgData2 : entry.getValue()) {
                    if (bgData2.getMemberMap().size() >= dimSize) continue;
                    for (Dimension dim : dimensions) {
                        bgData2.getMemberMap().computeIfAbsent(dim.getNumber(), mem -> dim.getNoneNumber());
                    }
                }
            }
        }
        return bgdatas;
    }

    public static List<BgData> mergeBgdatas(List<BgData> bgDatas, IModelCacheHelper modelCacheHelper) {
        if (CollectionUtils.isEmpty(bgDatas)) {
            return bgDatas;
        }
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)bgDatas.get(0).getModelId());
        }
        ArrayList<BgData> mergeBgdatas = new ArrayList<BgData>(16);
        OffsetHelper.accomplishMembers(bgDatas, modelCacheHelper);
        Map<Long, List<BgData>> datasetDatas = bgDatas.parallelStream().collect(Collectors.groupingBy(BgData::getDatasetId));
        for (Map.Entry<Long, List<BgData>> entry : datasetDatas.entrySet()) {
            Long datasetId = entry.getKey();
            List<BgData> dataList = entry.getValue();
            String[] dimsInOrder = modelCacheHelper.getDimensionNums(datasetId);
            Map<String, List<BgData>> grouppedDatas = dataList.parallelStream().collect(Collectors.groupingBy(e -> {
                StringBuilder sb = new StringBuilder(String.valueOf(e.getDatasetId()));
                for (String dimNumber : dimsInOrder) {
                    sb.append("#").append((String)e.getMemberMap().get(dimNumber));
                }
                return sb.toString();
            }));
            for (Map.Entry<String, List<BgData>> groupData : grouppedDatas.entrySet()) {
                if (groupData.getValue().size() > 1) {
                    BgData merged = groupData.getValue().get(0).clone();
                    BigDecimal sumVal = null;
                    for (BgData bgData : groupData.getValue()) {
                        if (bgData.getValue() == null) continue;
                        if (sumVal == null) {
                            sumVal = bgData.getValue();
                            continue;
                        }
                        sumVal = sumVal.add(bgData.getValue());
                    }
                    merged.setValue(sumVal);
                    mergeBgdatas.add(merged);
                    continue;
                }
                mergeBgdatas.add(groupData.getValue().get(0));
            }
        }
        return mergeBgdatas;
    }

    public static Map<String, Set<String>> validatePermission(List<BgData> bgdatas, DimMembPermType dataPermType, IModelCacheHelper modelCacheHelper) {
        HashMap<String, Set<String>> noPermMemberMap = new HashMap<String, Set<String>>(16);
        if (bgdatas != null && !bgdatas.isEmpty()) {
            Long modelId = bgdatas.get(0).getModelId();
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            }
            Long busModelId = modelCacheHelper.getBusModelByDataSet(bgdatas.get(0).getDatasetId());
            Map dimensionViews = modelCacheHelper.getViewsByBusModel(busModelId);
            HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>(16);
            for (BgData bgData : bgdatas) {
                if (bgData == null) continue;
                OffsetHelper.mergeMap(bgData.getMemberMap(), memberMap);
            }
            for (Map.Entry entry : memberMap.entrySet()) {
                String dimNumber = (String)entry.getKey();
                Set memNumbers = (Set)entry.getValue();
                Long viewId = (Long)dimensionViews.get(dimNumber);
                Set noPermMems = DimMembPermHelper.getPermMembNumbers((String)dimNumber, (Long)modelId, (Long)busModelId, (Long)viewId, (DimMembPermType)dataPermType, (boolean)false);
                if (noPermMems == null || noPermMems.size() <= 0) continue;
                memNumbers.retainAll(noPermMems);
                if (memNumbers.isEmpty()) continue;
                noPermMemberMap.put(dimNumber, memNumbers);
            }
        }
        return noPermMemberMap;
    }

    public static void mergeMap(Map<String, String> source, Map<String, Set<String>> target) {
        if (target != null && source != null) {
            for (Map.Entry<String, String> entry : source.entrySet()) {
                Set<String> values = target.get(entry.getKey());
                if (values == null) {
                    values = new HashSet<String>(16);
                    target.put(entry.getKey(), values);
                }
                values.add(entry.getValue());
            }
        }
    }

    public static void saveBgdataToOlap(List<BgData> bgdatas, IModelCacheHelper modelCacheHelper, String numberStr) {
        if (bgdatas != null && bgdatas.size() > 0) {
            Map<Long, List<BgData>> datasetDatas = bgdatas.parallelStream().collect(Collectors.groupingBy(bgData -> bgData.getDatasetId()));
            HashMap<Long, List> datasetCells = new HashMap<Long, List>(16);
            HashMap<Long, String[]> datasetDimensions = new HashMap<Long, String[]>(16);
            Long modelId = bgdatas.get(0).getModelId();
            Long datasetId = null;
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            }
            for (Map.Entry<Long, List<BgData>> entry : datasetDatas.entrySet()) {
                datasetId = entry.getKey();
                if (datasetId == null) continue;
                String[] dimensions = (String[])datasetDimensions.get(datasetId);
                if (dimensions == null) {
                    dimensions = modelCacheHelper.getDimensionNums(datasetId);
                    datasetDimensions.put(datasetId, dimensions);
                }
                List cells = datasetCells.computeIfAbsent(datasetId, v -> new ArrayList(16));
                if (entry.getValue() == null) continue;
                for (BgData bgData2 : entry.getValue()) {
                    if (bgData2 == null) continue;
                    cells.add(KDCell.of((BgData)bgData2, (Object)bgData2.getValue(), (String[])dimensions));
                }
            }
            if (!datasetCells.isEmpty()) {
                IModelCacheHelper modelCache = modelCacheHelper;
                OlapTraceServiceHelper.setTraceOpInfo((String)numberStr);
                OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.OffsetExecute));
                for (Map.Entry entry : datasetCells.entrySet()) {
                    datasetId = (Long)entry.getKey();
                    List dimensionList = modelCacheHelper.getDimensionList(datasetId);
                    List bgCellList = ((List)entry.getValue()).stream().map(kdCell -> AlgoCalcUtils.toBGCell((IKDCell)kdCell, (IModelCacheHelper)modelCache, (List)dimensionList)).collect(Collectors.toList());
                    OlapTraceServiceHelper.setTraceOpInfo((String)numberStr);
                    OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.OffsetExecute));
                    OlapManager.getInstance().saveList(new SaveRequest(modelId, datasetId, bgCellList));
                }
            }
        }
    }

    public static void mergeBgdatasAndSaveToOlap(List<BgData> bgdatas, IModelCacheHelper modelCacheHelper, String numberStr) {
        OffsetHelper.saveBgdataToOlap(OffsetHelper.mergeBgdatas(bgdatas, modelCacheHelper), modelCacheHelper, numberStr);
    }

    public static List<String> getInfo(List<BgData> bgdatas) {
        if (bgdatas != null && bgdatas.size() > 0) {
            return bgdatas.parallelStream().map(d -> d == null ? "null" : d.getMemberMap() + (d.getValue() == null ? "null" : d.getValue().toPlainString())).collect(Collectors.toList());
        }
        return null;
    }

    public static boolean validateRule(OffsetRule offsetRule) {
        if (offsetRule != null) {
            List<AccountMember> senderAccounts = offsetRule.getSenderAccounts();
            List<AccountMember> recvAccounts = offsetRule.getRecvAccounts();
            if (senderAccounts == null || recvAccounts == null) {
                return false;
            }
            int sumDC = AccountDirectionEnum.DEBIT.getIndex() + AccountDirectionEnum.CREDIT.getIndex();
            if (VarhandleEnum.USEBIG == offsetRule.getVarhandle() || VarhandleEnum.USESMALL == offsetRule.getVarhandle()) {
                if (senderAccounts.size() != 1 || recvAccounts.size() != 1 || senderAccounts.get(0) == null || recvAccounts.get(0) == null) {
                    return false;
                }
                if (senderAccounts.get(0).getDirection() + recvAccounts.get(0).getDirection() != sumDC) {
                    return false;
                }
            } else if (VarhandleEnum.SPECIFYACCOUNT == offsetRule.getVarhandle()) {
                int senderVarHandle = -1;
                List senderDirection = senderAccounts.stream().map(AccountMember::getDirection).distinct().collect(Collectors.toList());
                List recvDirection = recvAccounts.stream().map(AccountMember::getDirection).distinct().collect(Collectors.toList());
                if (senderDirection.size() != 1 || recvDirection.size() != 1) {
                    return false;
                }
                if ((Integer)senderDirection.get(0) + (Integer)recvDirection.get(0) != sumDC) {
                    return false;
                }
            } else {
                throw new KDBizException("Invalid Varhandle " + offsetRule.getVarhandle() + " in OffsetRule " + offsetRule.getNumber());
            }
        }
        return true;
    }
}

