/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.control;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.control.domain.BgmdControlParam;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;

public class BgmdControlParamQueryService {
    private static BgmdControlParamQueryService instance = new BgmdControlParamQueryService();

    public static BgmdControlParamQueryService getInstance() {
        return instance;
    }

    private BgmdControlParamQueryService() {
    }

    public Map<String, BgmdControlParam> getControlDimsByModel(long modelId) {
        HashMap<String, BgmdControlParam> map = new HashMap<String, BgmdControlParam>(16);
        if (modelId == 0L) {
            return map;
        }
        String fields = "id,model.id,businessmodel.id,businessmodel.number,entryentity.id,entryentity.dimensionid";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        Map all = BusinessDataServiceHelper.loadFromCache((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])qFilter.toArray());
        if (all == null || all.size() == 0) {
            return map;
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        for (DynamicObject value : all.values()) {
            BgmdControlParam param = new BgmdControlParam();
            param.setModelId(modelId);
            param.setBusinessmodelid(value.getLong("businessmodel.id"));
            DynamicObjectCollection entries = value.getDynamicObjectCollection("entryentity");
            if (entries != null) {
                ArrayList dims = Lists.newArrayListWithCapacity((int)entries.size());
                for (DynamicObject entry : entries) {
                    long dimid = entry.getLong("dimensionid");
                    Dimension dimension = orCreate.getDimension(Long.valueOf(dimid));
                    if (dimension == null || dimension.isPreset() && !"Entity".equals(dimension.getNumber())) continue;
                    dims.add(dimid);
                }
                param.setControlDimension(dims);
            }
            map.put(value.getString("businessmodel.number"), param);
        }
        return map;
    }
}

