/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.control;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.DataRule;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.business.control.MenuCache;
import kd.epm.eb.business.control.MenuModel;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;

public class BillPreOpenCheckUtil {
    private static final BillPreOpenCheckUtil instance = new BillPreOpenCheckUtil();
    private static final Log log = LogFactory.getLog(BillPreOpenCheckUtil.class);

    public static BillPreOpenCheckUtil getInstance() {
        return instance;
    }

    public String checkViewPerm(String billType, Object billId, IFormView view) {
        QFilter filter;
        DynamicObject[] orgObject;
        try {
            ISimpleProperty primaryKey = BusinessDataServiceHelper.newDynamicObject((String)billType).getDynamicObjectType().getPrimaryKey();
            if (primaryKey instanceof LongProp || primaryKey instanceof BasedataProp || primaryKey instanceof IntegerProp) {
                billId = IDUtils.toLong((Object)billId);
            }
        }
        catch (Exception e) {
            log.info("checkViewPerm:" + e.toString());
        }
        QFilter qb = new QFilter("number", "=", (Object)billType);
        String selectFields = "id,number,name,type,masterid,parentid,bizappid,enabled,basedatafield";
        DynamicObjectCollection entitys = QueryServiceHelper.query((String)"bos_formmeta", (String)selectFields, (QFilter[])qb.toArray());
        DynamicObject bill = null;
        String appId = null;
        HashMap<String, String> masterIdMap = new HashMap<String, String>(10);
        boolean hasPermisson = false;
        Long orgId = null;
        Long extOrgId = null;
        String noDataRuleName = null;
        LicenseCheckResult result = null;
        LicenseCheckResult noLicense = null;
        boolean hasOneLicense = false;
        if (entitys != null && !entitys.isEmpty()) {
            HashSet<String> appIds = new HashSet<String>(10);
            LinkedHashMap<String, Set> entityAppIds = new LinkedHashMap<String, Set>(10);
            bill = (DynamicObject)entitys.get(0);
            String _number = ((DynamicObject)entitys.get(0)).getString("number");
            String _appId = ((DynamicObject)entitys.get(0)).getString("bizappid");
            if (StringUtils.isNotEmpty((String)((DynamicObject)entitys.get(0)).getString("masterid"))) {
                masterIdMap.put(_number, ((DynamicObject)entitys.get(0)).getString("masterid"));
            }
            appIds.add(_appId);
            entityAppIds.computeIfAbsent(_number, f -> new LinkedHashSet(10)).add(_appId);
            String _id = ((DynamicObject)entitys.get(0)).getString("id");
            qb = new QFilter("masterid", "=", (Object)_id);
            entitys = QueryServiceHelper.query((String)"bos_formmeta", (String)selectFields, (QFilter[])qb.toArray());
            for (Object entity : entitys) {
                if (!Boolean.TRUE.equals(entity.getBoolean("enabled"))) continue;
                _number = entity.getString("number");
                _appId = entity.getString("bizappid");
                appIds.add(_appId);
                entityAppIds.computeIfAbsent(_number, f -> new LinkedHashSet(10)).add(_appId);
                if (!StringUtils.isNotEmpty((String)entity.getString("masterid"))) continue;
                masterIdMap.put(_number, entity.getString("masterid"));
            }
            qb = new QFilter("id", "in", appIds);
            entitys = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])qb.toArray());
            HashMap<String, String> idNumber = new HashMap<String, String>(entitys.size());
            for (Object entity : entitys) {
                idNumber.put(entity.getString("id"), entity.getString("number"));
            }
            LinkedHashSet ids = new LinkedHashSet(10);
            for (Map.Entry entry : entityAppIds.entrySet()) {
                ids.clear();
                ids.addAll((Collection)entry.getValue());
                ((Set)entry.getValue()).clear();
                for (String id : ids) {
                    if (!idNumber.containsKey(id)) continue;
                    ((Set)entry.getValue()).add(idNumber.get(id));
                }
            }
            StringBuilder sql = new StringBuilder("select fformid, fappid from t_meta_menuruntime where fformid in(").append(SqlBatchUtils.getBatchParamsSql((int)entityAppIds.size())).append(")");
            DataSet dataSet = DB.queryDataSet((String)"queryMenuruntime", (DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])entityAppIds.keySet().toArray(new String[0]));
            Iterator iterator = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    entityAppIds.computeIfAbsent(row.getString("fformid"), f -> new LinkedHashSet(10)).add(row.getString("fappid"));
                }
            }
            catch (Throwable row) {
                iterator = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (iterator != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)((Object)iterator)).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            for (String entitynumber : entityAppIds.keySet()) {
                List<MenuModel> menus = BillPreOpenCheckUtil.getEntityListMenu(entitynumber, false);
                if (menus == null) continue;
                for (MenuModel menu : menus) {
                    if (menu == null || !StringUtils.isNotEmpty((String)menu.getAppNumber())) continue;
                    entityAppIds.computeIfAbsent(entitynumber, f -> new LinkedHashSet(10)).add(menu.getAppNumber());
                }
            }
            String string = RequestContext.get().getUserId();
            for (Map.Entry entry : entityAppIds.entrySet()) {
                try {
                    DynamicObject org;
                    String entityKey = (String)entry.getKey();
                    if (masterIdMap.containsKey(entry.getKey())) {
                        entityKey = EntityMetadataCache.getDataEntityTypeById((String)((String)masterIdMap.get(entry.getKey()))).getName();
                    }
                    String orgField = PermCommonUtil.getCheckPermOrg((String)entityKey);
                    String extOrgField = PermCommonUtil.getCheckPermOrg((String)entityKey, (String)"2");
                    if (StringUtils.isEmpty((String)orgField)) {
                        try {
                            String entityNumber = FormMetadataCache.getFormConfig((String)entityKey).getEntityTypeId();
                            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
                            orgField = type.getMainOrg();
                        }
                        catch (Throwable ex) {
                            log.info("getMainOrg-error:", (Object)ex);
                        }
                    }
                    DynamicObject billObject = null;
                    if (StringUtils.isNotEmpty((String)orgField) || StringUtils.isNotEmpty((String)extOrgField)) {
                        String field = "";
                        if (StringUtils.isNotEmpty((String)orgField)) {
                            field = orgField;
                        }
                        if (StringUtils.isNotEmpty((String)extOrgField)) {
                            field = field + "," + extOrgField;
                        }
                        billObject = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)entityKey, (String)field);
                    } else {
                        billObject = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)entityKey);
                    }
                    if (billObject == null) {
                        log.info("no-found-bill:" + (String)entry.getKey());
                        continue;
                    }
                    orgId = null;
                    extOrgId = null;
                    Object orgObject2 = null;
                    Object extOrgObject = null;
                    if (StringUtils.isNotEmpty((String)orgField)) {
                        orgObject2 = billObject.get(orgField);
                    }
                    if (StringUtils.isNotEmpty((String)extOrgField)) {
                        extOrgObject = billObject.get(extOrgField);
                    }
                    if (orgObject2 instanceof Long) {
                        orgId = (Long)orgObject2;
                    } else if (orgObject2 instanceof DynamicObject && (org = (DynamicObject)orgObject2).containsProperty("id")) {
                        orgId = org.getLong("id");
                    }
                    if (extOrgObject instanceof Long) {
                        extOrgId = (Long)orgObject2;
                    } else if (extOrgObject instanceof DynamicObject && (org = (DynamicObject)extOrgObject).containsProperty("id")) {
                        extOrgId = org.getLong("id");
                    }
                    StringBuilder sbNotMatchTips = new StringBuilder();
                    for (String _appid : (Set)entry.getValue()) {
                        QFilter filter2;
                        result = LicenseServiceHelper.checkLicenseRight((Long)Long.parseLong(string), (String)AppMetadataCache.getAppInfo((String)_appid).getId(), (String)entityKey);
                        if (result != null && !Boolean.TRUE.equals(result.getHasLicense())) {
                            noLicense = result;
                            log.info("checkLicenseRight-appid-nolicense=" + _appid);
                            continue;
                        }
                        hasOneLicense = true;
                        log.info("checkLicenseRight-appid-haslicense=" + _appid);
                        if (1 != PermissionServiceHelper.checkPermission((Long)Long.parseLong(string), (Long)orgId, (String)_appid, (String)entityKey, (String)view.getFormShowParameter().getPermissionItemId()) && (extOrgId == null || 1 != PermissionServiceHelper.checkPermission((Long)Long.parseLong(string), (Long)extOrgId, (String)_appid, (String)entityKey, (String)view.getFormShowParameter().getPermissionItemId()))) continue;
                        hasPermisson = true;
                        boolean noRule = false;
                        DataRule rule = PermissionServiceHelper.getOperationRule((String)_appid, (String)entityKey, (String)"view");
                        if (rule != null && (filter2 = PermissionServiceHelper.getOperationRuleFilter((Long)Long.parseLong(string), (String)_appid, (String)entityKey, (String)"view", (StringBuilder)sbNotMatchTips)) != null) {
                            filter2.and("id", "=", billId);
                            DynamicObject[] objects = BusinessDataServiceHelper.load((String)entityKey, (String)"id", (QFilter[])filter2.toArray());
                            if (objects == null || objects.length == 0 || objects[0] == null) {
                                noRule = true;
                            }
                            noDataRuleName = rule.getName();
                        }
                        if (noRule) continue;
                        appId = _appid;
                        break;
                    }
                }
                catch (Throwable e) {
                    log.info("hasViewPermission", (Object)e);
                }
                if (appId == null) continue;
                break;
            }
        }
        if (appId != null) {
            return appId;
        }
        if (!hasOneLicense && noLicense != null) {
            log.info("no-checkRightAppId-noLicense:" + billType);
            throw new KDBizException(noLicense.getMsg());
        }
        String msg = null;
        String org = "";
        if (orgId != null && (orgObject = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"id, org.number, org.name, name, number", (QFilter[])(filter = new QFilter("org", "=", orgId)).toArray())) != null && orgObject.length > 0) {
            org = orgObject[0].getString("org.number") + "-" + orgObject[0].getString("org.name");
        }
        if (bill != null) {
            msg = !hasPermisson || noDataRuleName == null ? ResManager.loadResFormat((String)"\u7528\u6237\u6ca1\u6709%1%2\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"BillPreOpenCheckUtil_2", (String)"epm-eb-business", (Object[])new Object[]{org, bill.getString("name")}) : ResManager.loadResFormat((String)"%1\u542f\u7528\u4e86\u540d\u79f0\u4e3a%2\u7684\u7279\u6b8a\u6570\u636e\u6743\u9650\uff0c\u65e0\u6cd5\u67e5\u770b\u5f53\u524d\u5355\u636e\u3002", (String)"BillPreOpenCheckUtil_3", (String)"epm-eb-business", (Object[])new Object[]{bill.getString("name"), noDataRuleName});
        }
        log.info("no-checkRightAppId:" + billType);
        throw new KDBizException(msg);
    }

    private static List<MenuModel> getEntityListMenu(String entityNumber, boolean reload) {
        try {
            return MenuCache.getEntityListMenu(entityNumber, reload);
        }
        catch (Throwable ex) {
            log.info("getEntityListMenu-error");
            log.error(ex);
            return null;
        }
    }
}

