/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.controlprocess;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.controlprocess.ParaInfo;
import kd.epm.eb.common.enums.BgBillTreeTypeEnum;
import kd.epm.eb.common.enums.BillFieldTypeEmum;

public class ControlProcessParasUtil {
    public static DynamicObjectCollection queryBills() {
        QFilter levelqfilter = new QFilter("billtype", "=", (Object)BgBillTreeTypeEnum.BILL.getNumber());
        String selectFields = "id, name, number,isfromouter,parent.id,parent.name,parent.number,parent.isfromouter";
        DynamicObjectCollection dc = QueryServiceHelper.query((String)"eb_structofbill", (String)selectFields, (QFilter[])new QFilter[]{levelqfilter});
        return dc;
    }

    public static Map<Long, Map<String, List<ParaInfo>>> getAllRegBills() {
        DynamicObjectCollection bills = ControlProcessParasUtil.queryBills();
        ArrayList<Long> billids = new ArrayList<Long>(16);
        for (DynamicObject bill : bills) {
            billids.add(bill.getLong("id"));
        }
        QFilter bizidqfilter = new QFilter("bizUnitId", "in", billids);
        ArrayList types = Lists.newArrayList((Object[])new String[]{BillFieldTypeEmum.CONTROLVALUE.getNumber(), BillFieldTypeEmum.TAKEOPERATION.getNumber(), BillFieldTypeEmum.RUNOPERATION.getNumber(), BillFieldTypeEmum.RETURNOPERATION.getNumber(), BillFieldTypeEmum.CLEAROPERATION.getNumber(), BillFieldTypeEmum.WRITEOFFFIELD.getNumber()});
        QFilter typeqfilter = new QFilter("type", "in", (Object)types);
        String selectfields = "id, bizUnitId, type, name, number";
        DynamicObjectCollection regbills = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)selectfields, (QFilter[])new QFilter[]{bizidqfilter, typeqfilter});
        HashMap<Long, Map<String, List<ParaInfo>>> maps = new HashMap<Long, Map<String, List<ParaInfo>>>(16);
        for (DynamicObject regbill : regbills) {
            ArrayList<ParaInfo> regbillinfo;
            Map regtypes;
            Long bizUnitId = regbill.getLong("bizUnitId");
            if (maps.get(bizUnitId) == null) {
                regtypes = new HashMap(16);
                regbillinfo = new ArrayList<ParaInfo>(16);
                regbillinfo.add(new ParaInfo(regbill.getString("name"), regbill.getString("number"), regbill.getLong("id"), regbill.getString("type")));
                regtypes.put(regbill.getString("type"), regbillinfo);
                maps.put(bizUnitId, regtypes);
                continue;
            }
            regtypes = (Map)maps.get(bizUnitId);
            if (regtypes.get(regbill.getString("type")) == null) {
                regbillinfo = new ArrayList(16);
                regbillinfo.add(new ParaInfo(regbill.getString("name"), regbill.getString("number"), regbill.getLong("id"), regbill.getString("type")));
                regtypes.put(regbill.getString("type"), regbillinfo);
            } else {
                ((List)regtypes.get(regbill.getString("type"))).add(new ParaInfo(regbill.getString("name"), regbill.getString("number"), regbill.getLong("id"), regbill.getString("type")));
            }
            maps.put(bizUnitId, regtypes);
        }
        return maps;
    }

    public static Map<Long, Map<String, List<ParaInfo>>> getRegBillsFromCache(IPageCache pagecache) {
        return ControlProcessParasUtil.getAllRegBills();
    }
}

