/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.currencyConvert;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.currencyConvert.CurrencyConvertScheme;
import kd.epm.eb.business.currencyConvert.CurrencyConvertSchemeVo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.currencyConvert.CurrencyConvertCache;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CurrencyConvertSchemeServiceImpl {
    private static final CurrencyConvertSchemeServiceImpl instance = new CurrencyConvertSchemeServiceImpl();
    public static final String jiantou = " \u2192 ";
    private CurrencyConvertCache cache = CurrencyConvertCache.getInstance();
    private static volatile Map<Integer, Map<Integer, String>> dataCache = new ConcurrentHashMap<Integer, Map<Integer, String>>(16);

    private CurrencyConvertSchemeServiceImpl() {
    }

    public static CurrencyConvertSchemeServiceImpl getInstance() {
        return instance;
    }

    public Map<String, Map<String, List<CurrencyConvertScheme>>> getSchemeByModelIdAndEntityCollection(Long modelId, Collection<String> entitys) {
        if (modelId == null || modelId == 0L || CollectionUtils.isEmpty(entitys)) {
            return Collections.emptyMap();
        }
        Map entitySchemeMap = this.cache.getSchemeIdFromCacheByModelIdAndCollection(modelId, entitys);
        HashSet<String> schemeIds = new HashSet<String>(16);
        entitySchemeMap.forEach((k, v) -> schemeIds.addAll((Collection<String>)v));
        List<CurrencyConvertScheme> schemeByIds = this.getSchemeByIds(schemeIds);
        Map<String, CurrencyConvertScheme> collect = schemeByIds.stream().collect(Collectors.toMap(CurrencyConvertScheme::getId, v -> v));
        HashMap<String, Map<String, List<CurrencyConvertScheme>>> returnmap = new HashMap<String, Map<String, List<CurrencyConvertScheme>>>(16);
        for (Map.Entry entry : entitySchemeMap.entrySet()) {
            String key = (String)entry.getKey();
            HashMap<String, List> value = new HashMap<String, List>(((Set)entry.getValue()).size());
            for (String schemeid : (Set)entry.getValue()) {
                CurrencyConvertScheme scheme = collect.get(schemeid);
                List currencyConvertSchemes = value.computeIfAbsent(scheme.getSourceCurrency(), v -> new ArrayList(16));
                currencyConvertSchemes.add(scheme);
            }
            returnmap.put(key, value);
        }
        return returnmap;
    }

    public void createOrUpdateSchemeUpdateLog(long modelId, boolean enable, Long schemeId) {
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilter.and("status", "=", (Object)"0");
        qFilter.and("model", "=", (Object)modelId);
        DynamicObject dynamicObject = null;
        IModelCacheHelper model = ModelCacheContext.getOrCreate((Long)modelId);
        dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_currconvertupdate");
        dynamicObject.set("model", (Object)modelId);
        dynamicObject.set("scheme", (Object)schemeId);
        dynamicObject.set("entitys", (Object)this.getEntitysString(schemeId, model));
        dynamicObject.set("status", (Object)"0");
        dynamicObject.set("creater", (Object)UserUtils.getUserId());
        dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.requiresNew((String)"deleteScheme");){
            try {
                DeleteServiceHelper.delete((String)"eb_currconvertupdate", (QFilter[])qFilter.toArray());
                if (enable) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private String getEntitysString(Long schemeId, IModelCacheHelper model) {
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_currencyconvertschem", (String)"entityrang_tag", (QFilter[])qFilter.toArray());
        String entityrang = dynamicObject.getString("entityrang_tag");
        List schemeEntityRange = this.cache.getSchemeEntityRange(model, entityrang);
        if (schemeEntityRange.isEmpty()) {
            return "";
        }
        Set collect = schemeEntityRange.stream().map(Member::getName).collect(Collectors.toSet());
        return String.join((CharSequence)",", collect);
    }

    public List<CurrencyConvertSchemeVo> getSchemeVoByIds(Collection<String> schemeIds) {
        if (schemeIds == null || CollectionUtils.isEmpty(schemeIds)) {
            return Collections.emptyList();
        }
        List collect = schemeIds.stream().map(Long::valueOf).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", collect);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_currencyconvertschem", (QFilter[])qFilter.toArray());
        if (objectMap == null || objectMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CurrencyConvertSchemeVo> schemeVos = new ArrayList<CurrencyConvertSchemeVo>(objectMap.size());
        for (DynamicObject doj : objectMap.values()) {
            CurrencyConvertSchemeVo vo = new CurrencyConvertSchemeVo();
            vo.setId(doj.getLong("id"));
            String name1 = doj.getString("currencyraw.name");
            String name2 = doj.getString("currencyrate.name");
            vo.setName(name1 + jiantou + name2);
            vo.setCreator(doj.getString("creator.name"));
            vo.setCreatedate(doj.getDate("createtime"));
            schemeVos.add(vo);
        }
        return schemeVos;
    }

    public List<CurrencyConvertScheme> getSchemeByIds(Collection<String> schemeIds) {
        if (CollectionUtils.isEmpty(schemeIds)) {
            return Collections.emptyList();
        }
        List collect = schemeIds.stream().map(Long::valueOf).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", collect);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_currencyconvertschem", (QFilter[])qFilter.toArray());
        if (objectMap == null || objectMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CurrencyConvertScheme> returncoll = new ArrayList<CurrencyConvertScheme>(objectMap.size());
        Calendar calendar = Calendar.getInstance();
        for (DynamicObject doj : objectMap.values()) {
            DynamicObjectCollection entryentity = doj.getDynamicObjectCollection("entryentity");
            entryentity.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    Date budgetdate1 = o1.getDate("budgetdate");
                    Date budgetdate2 = o2.getDate("budgetdate");
                    return budgetdate1.compareTo(budgetdate2);
                }
            });
            if (entryentity == null || entryentity.isEmpty()) continue;
            CurrencyConvertScheme dao = new CurrencyConvertScheme();
            dao.setId(doj.getString("id"));
            dao.setName(doj.getString("name"));
            dao.setNumber(doj.getString("number"));
            dao.setEntityrang(doj.getString("entityrang_tag"));
            dao.setBack(doj.getBoolean("paritiesoverturn"));
            dao.setScale(doj.getString("paritiesprecision"));
            dao.setSourceCurrency(doj.getString("currencyraw.number"));
            dao.setTargetCurrency(doj.getString("currencyrate.number"));
            BigDecimal averageRate = null;
            BigDecimal totalAverageRate = null;
            BigDecimal closingRate = null;
            HashMap<String, BigDecimal> averageRates = new HashMap<String, BigDecimal>(16);
            HashMap<String, BigDecimal> totalAverageRates = new HashMap<String, BigDecimal>(16);
            HashMap<String, BigDecimal> closingRates = new HashMap<String, BigDecimal>(16);
            HashMap<String, Map<String, BigDecimal>> rates = new HashMap<String, Map<String, BigDecimal>>(16);
            rates.put(CurrencyConvertScheme.RateEnum.AverageRate.getKey(), averageRates);
            rates.put(CurrencyConvertScheme.RateEnum.totalAverageRate.getKey(), totalAverageRates);
            rates.put(CurrencyConvertScheme.RateEnum.closingRate.getKey(), closingRates);
            HashSet allPeriodNumbers = Sets.newHashSetWithExpectedSize((int)entryentity.size());
            for (DynamicObject dynamicObject : entryentity) {
                BigDecimal _closingRate;
                BigDecimal _totalAverageRate;
                Date date = dynamicObject.getDate("budgetdate");
                calendar.setTime(date);
                int year = calendar.get(1);
                int month = calendar.get(2) + 1;
                String periodNumber = this.getPeriodNumberFromCache(year, month);
                allPeriodNumbers.add(periodNumber);
                BigDecimal _averageRate = dynamicObject.getBigDecimal("meanparities");
                if (!this.isZero(_averageRate)) {
                    averageRate = _averageRate;
                }
                if (!this.isZero(_totalAverageRate = dynamicObject.getBigDecimal("addmeanparities"))) {
                    totalAverageRate = _totalAverageRate;
                }
                if (!this.isZero(_closingRate = dynamicObject.getBigDecimal("endparities"))) {
                    closingRate = _closingRate;
                }
                if (!this.isZero(averageRate)) {
                    averageRates.put(periodNumber, averageRate);
                }
                if (!this.isZero(totalAverageRate)) {
                    totalAverageRates.put(periodNumber, totalAverageRate);
                }
                if (this.isZero(closingRate)) continue;
                closingRates.put(periodNumber, closingRate);
            }
            dao.setAllPeriodNumbers(allPeriodNumbers);
            dao.setRates(rates);
            returncoll.add(dao);
        }
        return returncoll;
    }

    public List<Member> getSchemeRangeById(IModelCacheHelper modelCache, Long schemeId) {
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_currencyconvertschem");
        List entityrang_tag = this.cache.getSchemeEntityRange(modelCache, doj.getString("entityrang_tag"));
        return entityrang_tag;
    }

    private boolean isZero(BigDecimal _averageRate) {
        return _averageRate == null || _averageRate.compareTo(BigDecimal.ZERO) == 0;
    }

    private String getPeriodNumberFromCache(int year, int month) {
        return this.getCache().computeIfAbsent(year, v -> new HashMap(16)).computeIfAbsent(month, v -> {
            if (month < 10) {
                return "FY" + year + ".M0" + month;
            }
            return "FY" + year + ".M" + month;
        });
    }

    private Map<Integer, Map<Integer, String>> getCache() {
        return dataCache;
    }
}

