/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.currencyConvert;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.epm.eb.business.currencyConvert.CurrencyConvertException;
import kd.epm.eb.business.currencyConvert.CurrencyConvertScheme;
import kd.epm.eb.business.currencyConvert.CurrencyConvertSchemeServiceImpl;
import kd.epm.eb.business.currencyConvert.CurrentConvertEntityThread;
import kd.epm.eb.business.currencyConvert.CurrentConvertExecuteThread;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class CurrencyConvertServiceImpl {
    public static final long USERID = 555555555555555555L;
    private static final CurrencyConvertServiceImpl instance = new CurrencyConvertServiceImpl();
    private static final Log log = LogFactory.getLog(CurrencyConvertServiceImpl.class);
    private CurrencyConvertSchemeServiceImpl currencyConvertSchemeService = CurrencyConvertSchemeServiceImpl.getInstance();

    private CurrencyConvertServiceImpl() {
    }

    public static CurrencyConvertServiceImpl getInstance() {
        return instance;
    }

    public boolean executeConvertByScheme(Long modelId, Long schemeId) {
        if (modelId == null || modelId == 0L || schemeId == null || schemeId == 0L) {
            return false;
        }
        LogStats stats = new LogStats("bg-currency-convert-log : ");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        stats.addInfo("begin currencyConvert.  modelName : " + modelCache.getModelobj().getName());
        List<CurrencyConvertScheme> schemes = this.currencyConvertSchemeService.getSchemeByIds(Collections.singletonList(schemeId.toString()));
        if (schemes.isEmpty()) {
            return false;
        }
        CurrencyConvertScheme currencyConvertScheme = schemes.get(0);
        HashMap<String, List<CurrencyConvertScheme>> schemeMap = new HashMap<String, List<CurrencyConvertScheme>>(4);
        schemeMap.put(currencyConvertScheme.getSourceCurrency(), schemes);
        Set currencySet = schemeMap.keySet();
        HashMap<String, Set<String>> otherFilter = new HashMap<String, Set<String>>(16);
        otherFilter.put(SysDimensionEnum.Currency.getNumber(), currencySet);
        List<Member> schemeEntityRange = this.currencyConvertSchemeService.getSchemeRangeById(modelCache, schemeId);
        HashMap<String, Map<String, List<CurrencyConvertScheme>>> entitySchemeMap = new HashMap<String, Map<String, List<CurrencyConvertScheme>>>(schemeEntityRange.size());
        for (Member entity : schemeEntityRange) {
            entitySchemeMap.put(entity.getNumber(), schemeMap);
        }
        stats.addInfo("schemeName : " + currencyConvertScheme.getName());
        stats.add("end load scheme");
        Set<String> entitySet = entitySchemeMap.keySet();
        List allDatasets = DatasetServiceHelper.getAllDatasets((Long)modelId);
        ArrayList tasks = Lists.newArrayListWithCapacity((int)allDatasets.size());
        for (Dataset dataset : allDatasets) {
            CurrentConvertEntityThread task = new CurrentConvertEntityThread(dataset.getId(), modelCache, entitySet, otherFilter, entitySchemeMap);
            tasks.add(task);
        }
        DynamicObject savelog = this.createLog(null, modelId, 2, entitySet);
        this.executeTask(stats, savelog, tasks);
        return true;
    }

    public boolean executeConvertByEntity(Long modelId, Long datasetid, String templateNumber, Set<String> versionSet, Set<String> entitySet) {
        if (modelId == null || modelId == 0L || CollectionUtils.isEmpty(entitySet)) {
            return false;
        }
        LogStats stats = new LogStats("bg-currency-convert-log : ");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        stats.addInfo("begin currencyConvert.  modelName : " + modelCache.getModelobj().getName());
        Map<String, Map<String, List<CurrencyConvertScheme>>> entitySchemeMap = this.currencyConvertSchemeService.getSchemeByModelIdAndEntityCollection(modelId, entitySet);
        if (entitySchemeMap.isEmpty()) {
            throw new CurrencyConvertException(ResManager.loadKDString((String)"\u65e0\u6298\u7b97\u65b9\u6848", (String)"CurrencyConvertServiceImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        stats.add("end load scheme");
        entitySet = entitySchemeMap.keySet();
        Map viewIds = modelCache.getViewsByDataSet(datasetid);
        Set<String> entityName = this.getEntityName(modelCache, viewIds, entitySet);
        Set<String> currencySet = this.getCurrencySet(entitySchemeMap);
        HashMap<String, Set<String>> otherFilter = new HashMap<String, Set<String>>(1);
        otherFilter.put(SysDimensionEnum.Currency.getNumber(), currencySet);
        otherFilter.put(SysDimensionEnum.Version.getNumber(), versionSet);
        stats.addInfo(",versionNumber" + versionSet + ",currencys : " + currencySet);
        Long busModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)datasetid);
        List allDataSetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(busModelId);
        DynamicObject savelog = this.createLog(templateNumber, modelId, 0, entitySet);
        ArrayList tasks = Lists.newArrayListWithCapacity((int)allDataSetIds.size());
        for (Long dataSetId : allDataSetIds) {
            CurrentConvertEntityThread task = new CurrentConvertEntityThread(dataSetId, modelCache, entitySet, otherFilter, entitySchemeMap);
            tasks.add(task);
        }
        stats.add("end createThread");
        this.executeTask(stats, savelog, tasks);
        return true;
    }

    public boolean executeConvertByRange(Long modelId, Long dataSetId, String templateNumber, Map<String, Set<String>> range) {
        if (modelId == null || modelId == 0L || MapUtils.isEmpty(range)) {
            return false;
        }
        LogStats stats = new LogStats("bg-currency-convert-log : ");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        stats.addInfo("begin currencyConvert.modelName : " + modelCache.getModelobj().getName() + ",temolateNumber = " + templateNumber);
        stats.addInfo("template range:" + range);
        this.chackRange(modelId, dataSetId, range);
        Set<String> entitySet = range.get(SysDimensionEnum.Entity.getNumber());
        HashMap entitySchemeMap = this.currencyConvertSchemeService.getSchemeByModelIdAndEntityCollection(modelId, entitySet);
        if (entitySchemeMap.isEmpty()) {
            throw new CurrencyConvertException(ResManager.loadKDString((String)"\u65e0\u6298\u7b97\u65b9\u6848", (String)"CurrencyConvertServiceImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        Set<String> currSet = range.get(SysDimensionEnum.Currency.getNumber());
        Set<String> periodSet = range.get(SysDimensionEnum.BudgetPeriod.getNumber());
        HashMap newEntrySchemeMap = Maps.newHashMapWithExpectedSize((int)entitySchemeMap.size());
        for (Map.Entry<String, Map<String, List<CurrencyConvertScheme>>> entry : entitySchemeMap.entrySet()) {
            Map<String, List<CurrencyConvertScheme>> value = entry.getValue();
            HashMap newSchemeMap = Maps.newHashMapWithExpectedSize((int)value.size());
            for (Map.Entry<String, List<CurrencyConvertScheme>> entry2 : value.entrySet()) {
                String currencyNumber = entry2.getKey();
                if (!currSet.contains(currencyNumber)) continue;
                List<CurrencyConvertScheme> schemes = entry2.getValue();
                ArrayList newSchemes = Lists.newArrayListWithExpectedSize((int)schemes.size());
                for (CurrencyConvertScheme scheme : schemes) {
                    Set<String> allPeriodNumbers = scheme.getAllPeriodNumbers();
                    if (!allPeriodNumbers.stream().anyMatch(periodSet::contains)) continue;
                    newSchemes.add(scheme);
                }
                if (!CollectionUtils.isNotEmpty((Collection)newSchemes)) continue;
                newSchemeMap.put(currencyNumber, newSchemes);
            }
            if (newSchemeMap.isEmpty()) continue;
            newEntrySchemeMap.put(entry.getKey(), newSchemeMap);
        }
        if (newEntrySchemeMap.isEmpty()) {
            throw new CurrencyConvertException(ResManager.loadKDString((String)"\u65e0\u6298\u7b97\u65b9\u6848", (String)"CurrencyConvertServiceImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        entitySchemeMap = newEntrySchemeMap;
        HashSet containsCurrency = new HashSet(16);
        for (Map entry : entitySchemeMap.values()) {
            containsCurrency.addAll(entry.keySet());
        }
        currSet.retainAll(containsCurrency);
        stats.add("end load scheme");
        range.put(SysDimensionEnum.Entity.getNumber(), entitySchemeMap.keySet());
        DynamicObject dynamicObject = this.createLog(templateNumber, modelId, 1, entitySchemeMap.keySet());
        ArrayList<Callable> tasks = new ArrayList<Callable>(10);
        Set<String> versionSet = range.get(SysDimensionEnum.Version.getNumber());
        range.put(SysDimensionEnum.Version.getNumber(), null);
        for (String versionNumber : versionSet) {
            Member versionMember = modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, versionNumber);
            CurrentConvertExecuteThread task = new CurrentConvertExecuteThread(entitySchemeMap, range, modelCache, dataSetId, versionMember.getId());
            tasks.add(task);
        }
        this.executeTask(stats, dynamicObject, tasks);
        return true;
    }

    private void chackRange(Long modelId, Long dataSetId, Map<String, Set<String>> range) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(dataSetId);
        for (Dimension dimension : dimensionList) {
            if (!CollectionUtils.isEmpty((Collection)range.get(dimension.getNumber()))) continue;
            throw new CurrencyConvertException(ResManager.loadResFormat((String)"\u6267\u884c\u8303\u56f4\u4e2d\u5b58\u5728\u4e0d\u5b58\u5728\u7684\u7ef4\u5ea6%1", (String)"CurrencyConvertServiceImpl_10", (String)"epm-eb-business", (Object[])new Object[]{dimension.getNumber()}));
        }
    }

    private Set<String> getCurrencySet(Map<String, Map<String, List<CurrencyConvertScheme>>> entitySchemeMap) {
        HashSet<String> currencys = new HashSet<String>(16);
        for (Map<String, List<CurrencyConvertScheme>> value : entitySchemeMap.values()) {
            currencys.addAll(value.keySet());
        }
        return currencys;
    }

    private Set<String> getEntityName(IModelCacheHelper modelCache, Map<String, Long> viewIds, Set<String> entitySet) {
        HashSet<String> entityName = new HashSet<String>();
        entitySet.forEach(entityNumber -> entityName.add(modelCache.getMember("Entity", (Long)viewIds.get("Entity"), entityNumber).getName()));
        return entityName;
    }

    private DynamicObject createLog(String templateNumber, Long modelId, int converttype, Set<String> entitySet) {
        DynamicObject dojLog = BusinessDataServiceHelper.newDynamicObject((String)"eb_currencyconvertlog");
        dojLog.set("executor", (Object)UserUtils.getUserId());
        dojLog.set("executedate", (Object)TimeServiceHelper.now());
        if (converttype == 0) {
            dojLog.set("converttype", (Object)ResManager.loadKDString((String)"\u6309\u7ec4\u7ec7\u8303\u56f4", (String)"CurrencyConvertServiceImpl_1", (String)"epm-eb-business", (Object[])new Object[0]));
            dojLog.set("convertrange", (Object)ResManager.loadResFormat((String)"\u6a21\u677f\u7f16\u7801\uff1a%1,\u7ec4\u7ec7\u7f16\u7801\u8303\u56f4\uff1a%2", (String)"CurrencyConvertServiceImpl_2", (String)"epm-eb-business", (Object[])new Object[]{templateNumber, entitySet}));
        } else if (converttype == 1) {
            dojLog.set("converttype", (Object)ResManager.loadKDString((String)"\u6309\u6a21\u677f\u8303\u56f4", (String)"CurrencyConvertServiceImpl_4", (String)"epm-eb-business", (Object[])new Object[0]));
            dojLog.set("convertrange", (Object)ResManager.loadResFormat((String)"\u6a21\u677f\u7f16\u7801\uff1a%1,\u7ec4\u7ec7\u7f16\u7801\u8303\u56f4\uff1a%2", (String)"CurrencyConvertServiceImpl_2", (String)"epm-eb-business", (Object[])new Object[]{templateNumber, entitySet}));
        } else if (converttype == 2) {
            dojLog.set("converttype", (Object)ResManager.loadKDString((String)"\u6309\u65b9\u6848", (String)"CurrencyConvertServiceImpl_5", (String)"epm-eb-business", (Object[])new Object[0]));
            dojLog.set("convertrange", (Object)ResManager.loadResFormat((String)"\u7ec4\u7ec7\u7f16\u7801\u8303\u56f4\uff1a%1", (String)"CurrencyConvertServiceImpl_6", (String)"epm-eb-business", (Object[])new Object[]{entitySet}));
        }
        dojLog.set("status", (Object)ResManager.loadKDString((String)"\u6298\u7b97\u4e2d", (String)"CurrencyConvertServiceImpl_7", (String)"epm-eb-business", (Object[])new Object[0]));
        dojLog.set("model", (Object)modelId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dojLog});
        return dojLog;
    }

    private void executeTask(LogStats stats, DynamicObject savelog, List<Callable> tasks) {
        try {
            ArrayList submits = Lists.newArrayListWithExpectedSize((int)tasks.size());
            for (Callable task : tasks) {
                submits.add(EpmThreadPools.CommPools.submit(task));
            }
            for (Future submit : submits) {
                stats.addInfo((String)submit.get());
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                log.error("\u6298\u7b97\u5931\u8d25", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)e)));
                stats.addInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)e)));
            }
            this.printlog(stats, savelog, ResManager.loadKDString((String)"\u6298\u7b97\u5931\u8d25", (String)"CurrencyConvertServiceImpl_8", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.printlog(stats, savelog, ResManager.loadKDString((String)"\u6298\u7b97\u6210\u529f", (String)"CurrencyConvertServiceImpl_9", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    private void printlog(LogStats stats, DynamicObject savelog, String staus) {
        stats.addInfo("end currencyConvert");
        String statLog = stats.toString();
        log.info(statLog);
        savelog.set("status", (Object)staus);
        savelog.set("convertlog", (Object)statLog);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{savelog});
    }
}

