/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.currencyConvert;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.currencyConvert.CurrencyConvertScheme;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CurrentConvertEntityThread
implements Callable<String> {
    private Map<String, Map<String, List<CurrencyConvertScheme>>> entitySchemeMap;
    private Set<String> entitySet;
    private Map<String, Set<String>> otherFilter;
    private IModelCacheHelper modelCache;
    private Long datasetId;
    private Long bizmodelId;
    private int totalSize;
    private StringBuilder log = new StringBuilder();
    private long start;
    private String loginIP;
    private List<IKDCell> saveCells = new ArrayList<IKDCell>(1024);
    private List<Dimension> dimensionList;
    private SelectCommandInfo query = new SelectCommandInfo();
    private Map<String, Integer> dimension2Index;

    public CurrentConvertEntityThread(Long datasetId, IModelCacheHelper modelCache, Set<String> entitySet, Map<String, Set<String>> otherFilter, Map<String, Map<String, List<CurrencyConvertScheme>>> entitySchemeMap) {
        this.datasetId = datasetId;
        this.modelCache = modelCache;
        this.entitySet = entitySet;
        this.otherFilter = otherFilter;
        this.entitySchemeMap = entitySchemeMap;
        if (datasetId != null && datasetId != 0L) {
            this.bizmodelId = DatasetServiceHelper.getInstance().getBizModelIdByDataSetId(datasetId);
        }
        this.loginIP = RequestContext.getOrCreate().getLoginIP();
    }

    @Override
    public String call() {
        RequestContext.getOrCreate().setLoginIP(this.loginIP);
        this.start = System.nanoTime();
        this.preData();
        this.appendLog("end preSql");
        String entityDimensionNumber = SysDimensionEnum.Entity.getNumber();
        String currencyDimensionNumber = SysDimensionEnum.Currency.getNumber();
        String periodDimensionNumber = SysDimensionEnum.BudgetPeriod.getNumber();
        String accountDimensionNumber = SysDimensionEnum.Account.getNumber();
        String metricDimensionNumber = SysDimensionEnum.Metric.getNumber();
        LogStats stats = new LogStats("currencyConvert");
        DynamicObject datasetDoj = BusinessDataServiceHelper.loadSingle((Object)this.datasetId, (String)"eb_dataset");
        ArrayList<Object[]> allValues = new ArrayList<Object[]>(1024);
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReaderByExcludeDynamicCalc((Model)this.modelCache.getModelobj(), (Dataset)Dataset.of((DynamicObject)datasetDoj), (SelectCommandInfo)this.query, (LogStats)stats);){
            while (reader.hasNext()) {
                allValues.add(reader.next());
            }
        }
        for (Object[] values : allValues) {
            List<CurrencyConvertScheme> schemes;
            Integer index;
            String number;
            Map<String, List<CurrencyConvertScheme>> firstMap;
            if (values == null || values[0] == null || MapUtils.isEmpty(firstMap = this.entitySchemeMap.get(number = Convert.toStr((Object)values[index = this.dimension2Index.get(entityDimensionNumber)]))) || (schemes = firstMap.get(number = Convert.toStr((Object)values[index = this.dimension2Index.get(currencyDimensionNumber)]))) == null) continue;
            index = this.dimension2Index.get(periodDimensionNumber);
            number = Convert.toStr((Object)values[index]);
            String accountNumber = Convert.toStr((Object)values[this.dimension2Index.get(accountDimensionNumber)]);
            String metricNumber = Convert.toStr((Object)values[this.dimension2Index.get(metricDimensionNumber)]);
            for (CurrencyConvertScheme scheme : schemes) {
                BigDecimal value;
                BigDecimal rate;
                Map<String, Map<String, BigDecimal>> rates = scheme.getRates();
                if (rates == null || rates.isEmpty() || (rate = this.getRateByAccountAndMetricAndPeriodNumber(rates, accountNumber, metricNumber, number)) == null || (value = Convert.toBigDecimal((Object)values[0])) == null) continue;
                value = value.multiply(rate);
                this.buildCell(values, scheme, value);
            }
            if (this.saveCells.size() < 8000) continue;
            String numberStr = schemes.stream().map(CurrencyConvertScheme::getNumber).collect(Collectors.joining(","));
            this.saveCell(numberStr);
        }
        this.saveCell(null);
        this.appendLog("end convert thread.  datasetid = " + this.datasetId + " total size = " + this.totalSize);
        return this.log.toString();
    }

    private void appendLog(String logS) {
        long end = System.nanoTime();
        this.log.append(logS).append("; use = ").append(LogUtils.use((long)this.start, (long)end)).append("ms.").append("\r\n");
        this.start = end;
    }

    private void saveCell(String numberStr) {
        if (this.saveCells.size() < 1) {
            return;
        }
        OlapTraceServiceHelper.setTraceOpInfo((String)numberStr);
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.CurrencyConvert));
        IKDOlapRequest saveRequest = KDOlapRequestUtils.of((Long)555555555555555555L, (Long)this.modelCache.getModelobj().getId(), (Long)this.bizmodelId, (Long)this.datasetId, this.saveCells);
        saveRequest.getProperties().setPropertyValue("IGNORE_PERM_SAVE", KDValue.TRUE);
        saveRequest.getProperties().setPropertyValue("IGNORE_DATA_LOCK", KDValue.TRUE);
        saveRequest.getProperties().setPropertyValue("IGNORE_SAVE_COMPARE_VALUE", KDValue.TRUE);
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapService", (String)"save", (Object[])new Object[]{saveRequest});
        this.totalSize += this.saveCells.size();
        this.saveCells.clear();
    }

    private void buildCell(Object[] oldValues, CurrencyConvertScheme scheme, BigDecimal newValue) {
        String[] metas = new String[this.dimensionList.size()];
        System.arraycopy(oldValues, 1, metas, 0, metas.length);
        metas[this.dimension2Index.get((Object)SysDimensionEnum.Currency.getNumber()).intValue() - 1] = scheme.getTargetCurrency();
        IKDCell cell = KDCell.of((String[])metas, (BigDecimal)newValue);
        if (cell != null) {
            cell.setDetail(true);
            this.saveCells.add(cell);
        }
    }

    private BigDecimal getRateByAccountAndMetricAndPeriodNumber(Map<String, Map<String, BigDecimal>> rates, String accountNumber, String metricNumber, String periodNumber) {
        Member metricMember = this.modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber);
        if (metricMember == null) {
            return null;
        }
        if ("2".equals(metricMember.getDatatype())) {
            return BigDecimal.ONE;
        }
        Member accountMember = this.modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
        if (accountMember == null) {
            return null;
        }
        Map memberRate = this.modelCache.getMemberRate(SysDimensionEnum.Account.getNumber(), accountMember.getId());
        if (memberRate == null) {
            return null;
        }
        String rateKey = (String)memberRate.get(metricMember.getId());
        if (StringUtils.isEmpty((String)rateKey)) {
            return null;
        }
        Map<String, BigDecimal> periodRateMap = rates.get(rateKey);
        if (periodRateMap == null) {
            return null;
        }
        return periodRateMap.get(periodNumber);
    }

    private void preData() {
        String[] dimensionNums;
        if (this.datasetId == null || this.datasetId == 0L) {
            this.dimensionList = this.modelCache.getDimensionList();
            dimensionNums = this.modelCache.getDimensionNums();
        } else {
            this.dimensionList = this.modelCache.getDimensionList(this.datasetId);
            dimensionNums = this.modelCache.getDimensionNums(this.datasetId);
        }
        this.dimension2Index = Maps.newHashMapWithExpectedSize((int)dimensionNums.length);
        for (int i = 0; i < dimensionNums.length; ++i) {
            this.dimension2Index.put(dimensionNums[i], i + 1);
        }
        this.query.addDims(dimensionNums);
        this.query.addMeasures(new String[]{"FMONEY"});
        Dimension dimension = this.modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        Map viewsByDataSet = this.modelCache.getViewsByDataSet(this.datasetId);
        Long viewId = (Long)viewsByDataSet.get(SysDimensionEnum.Entity.getNumber());
        Dimension abstractTree = viewId == null ? dimension : dimension.getView(viewId);
        List allMembers = abstractTree.getAllMembers();
        Set collect = allMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        Collection intersection = CollectionUtils.intersection(collect, this.entitySet);
        this.query.addFilter(SysDimensionEnum.Entity.getNumber(), intersection.toArray(new String[0]));
        if (this.otherFilter != null) {
            for (Map.Entry<String, Set<String>> dim : this.otherFilter.entrySet()) {
                if (dim.getValue() == null || dim.getValue().isEmpty()) continue;
                this.query.addFilter(dim.getKey(), dim.getValue().toArray(new String[0]));
            }
        }
    }
}

