/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.currencyConvert;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.currencyConvert.CurrencyConvertScheme;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import org.apache.commons.collections4.MapUtils;

public class CurrentConvertExecuteThread
implements Callable<String> {
    private static final Log log = LogFactory.getLog(CurrentConvertExecuteThread.class);
    private Map<String, Map<String, List<CurrencyConvertScheme>>> entitySchemeMap;
    private Map<String, Set<String>> numberRange;
    private IModelCacheHelper modelCache;
    private Long dataSetId;
    private Long bizmodelId;
    private Long versionId;
    private int totalSize;
    private StringBuilder sblog = new StringBuilder();
    private long start;
    private final String loginIP;
    private List<BGCell> saveCells;
    private Map<String, Map<String, String>> rates = new HashMap<String, Map<String, String>>(16);

    public CurrentConvertExecuteThread(Map<String, Map<String, List<CurrencyConvertScheme>>> entitySchemeMap, Map<String, Set<String>> numberRange, IModelCacheHelper modelCache, Long dataSetId, Long versionId) {
        this.entitySchemeMap = entitySchemeMap;
        this.numberRange = numberRange;
        this.modelCache = modelCache;
        this.dataSetId = dataSetId;
        this.versionId = versionId;
        if (dataSetId != null && dataSetId != 0L) {
            this.bizmodelId = DatasetServiceHelper.getInstance().getBizModelIdByDataSetId(dataSetId);
        }
        this.loginIP = RequestContext.getOrCreate().getLoginIP();
    }

    @Override
    public String call() {
        RequestContext.getOrCreate().setLoginIP(this.loginIP);
        this.start = System.nanoTime();
        Member member = this.modelCache.getMember(SysDimensionEnum.Version.getNumber(), Long.valueOf(0L), this.versionId);
        this.numberRange.put(SysDimensionEnum.Version.getNumber(), Sets.newHashSet((Object[])new String[]{member.getNumber()}));
        QueryRequest req = new QueryRequest(this.modelCache.getModelobj().getId(), this.dataSetId, this.numberRange);
        List cells = OlapCommService.getInstance().queryList(req);
        this.saveCells = cells.size() > 8192 ? new ArrayList<BGCell>(8192) : new ArrayList<BGCell>(cells.size() / 2);
        this.appendLog("end queryData allCellSize = " + cells.size());
        for (BGCell cell : cells) {
            BigDecimal value;
            List<CurrencyConvertScheme> schemes;
            String entityNumber = (String)cell.getMemberMap().get(SysDimensionEnum.Entity.getNumber());
            String currencyNumber = (String)cell.getMemberMap().get(SysDimensionEnum.Currency.getNumber());
            String periodNumber = (String)cell.getMemberMap().get(SysDimensionEnum.BudgetPeriod.getNumber());
            String metricNumber = (String)cell.getMemberMap().get(SysDimensionEnum.Metric.getNumber());
            String accountNumber = (String)cell.getMemberMap().get(SysDimensionEnum.Account.getNumber());
            Map<String, List<CurrencyConvertScheme>> firstMap = this.entitySchemeMap.get(entityNumber);
            if (MapUtils.isEmpty(firstMap) || (schemes = firstMap.get(currencyNumber)) == null || (value = ConvertUtils.toDecimal((Object)cell.getValue())) == null) continue;
            for (CurrencyConvertScheme scheme : schemes) {
                BigDecimal rateDecimal;
                Map<String, Map<String, BigDecimal>> rates = scheme.getRates();
                if (MapUtils.isEmpty(rates) || (rateDecimal = this.getRateKeyByaccountAndMetricAndPeriod(rates, accountNumber, metricNumber, periodNumber)) == null) continue;
                BigDecimal newValue = value.multiply(rateDecimal);
                cell.getMemberMap().put(SysDimensionEnum.Currency.getNumber(), scheme.getTargetCurrency());
                cell.setValue((Object)newValue);
                this.saveCells.add(cell);
            }
            if (this.saveCells.size() < 8000) continue;
            this.saveCell();
        }
        this.saveCell();
        this.appendLog("end convert thread.  datasetid = " + this.dataSetId + ", versionid = " + this.versionId + " total size = " + this.totalSize);
        return this.sblog.toString();
    }

    private void saveCell() {
        if (this.saveCells.size() < 1) {
            return;
        }
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.CurrencyConvert));
        OlapManager.getInstance().saveList(new SaveRequest(this.modelCache.getModelobj().getId(), this.dataSetId, this.saveCells));
        this.totalSize += this.saveCells.size();
        this.saveCells.clear();
    }

    private BigDecimal getRateKeyByaccountAndMetricAndPeriod(Map<String, Map<String, BigDecimal>> rates, String accountNumber, String metricNumber, String periodNumber) {
        Member metricMember = this.modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber);
        if ("2".equals(metricMember.getDatatype())) {
            return BigDecimal.ONE;
        }
        String rateEnum = this.getRateKeyByaccountAndMetric(accountNumber, metricNumber);
        if (rateEnum == null) {
            return null;
        }
        Map<String, BigDecimal> periodRateMap = rates.get(rateEnum);
        if (periodRateMap == null) {
            return null;
        }
        return periodRateMap.get(periodNumber);
    }

    private String getRateKeyByaccountAndMetric(String accountNumber, String metricNumber) {
        return (String)this.rates.computeIfAbsent(accountNumber, value -> {
            Member accountMember = this.modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
            Map memberRate = this.modelCache.getMemberRate(SysDimensionEnum.Account.getNumber(), accountMember.getId());
            if (memberRate != null) {
                HashMap rates = new HashMap(memberRate.size());
                for (Map.Entry entry : memberRate.entrySet()) {
                    Member metricMember = this.modelCache.getMember(SysDimensionEnum.Metric.getNumber(), Long.valueOf(0L), (Long)entry.getKey());
                    rates.put(metricMember.getNumber(), entry.getValue());
                }
                return rates;
            }
            return Collections.emptyMap();
        }).get(metricNumber);
    }

    private void appendLog(String logS) {
        long end = System.nanoTime();
        this.sblog.append(logS).append("; use = ").append(LogUtils.use((long)this.start, (long)end)).append("ms.").append("\r\n");
        this.start = end;
    }
}

