/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.db;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.dataGather.entity.DataGatherDataSetEntity;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;

public class DataGatherSum {
    private static final Log log = LogFactory.getLog(DataGatherSum.class);
    private static DataGatherSum instance = new DataGatherSum();

    public static DataGatherSum getInstance() {
        return instance;
    }

    private DataGatherSum() {
    }

    public void loadSumData(DataGatherExecuteScheme excuteSchemeInfo, List<DataGatherDataSetEntity> list, DBRoute epm) {
        String sql = "SELECT ds.febdim,ds.fvalue fvalue FROM t_eb_datagatherdataentry ds INNER JOIN t_eb_datagatherdata r ON ds.fid=r.fid WHERE ds.fissuc='1' and r.fexcutescheme = ? ";
        DataGatherCommon.doLogWithTime(0L, "sql_no_groupby" + excuteSchemeInfo.getID(), log);
        HashMap<String, BigDecimal> tmpMap = new HashMap<String, BigDecimal>(16);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)epm, (String)sql, (Object[])new Object[]{excuteSchemeInfo.getID()});
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String febdim = row.getString("febdim");
            BigDecimal value = (BigDecimal)tmpMap.get(febdim);
            BigDecimal fvalue = row.getBigDecimal("fvalue");
            value = value == null ? fvalue : value.add(fvalue);
            tmpMap.put(febdim, value);
        }
        for (Map.Entry entry : tmpMap.entrySet()) {
            DataGatherDataSetEntity entity = new DataGatherDataSetEntity((String)entry.getKey(), (BigDecimal)entry.getValue());
            list.add(entity);
        }
        tmpMap.clear();
    }
}

