/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.QFBuilder;

public class DataCollectionService {
    public static final String FIELDS = "id,model,creator,createtime,appname,appnumber,cloudname,cloudnumber,dseq";
    public static final String EXECUTE = "id,status,executeplan,startdate,enddate,supervisors,remind,lastdate,timefield,settleddate,effday,expday,datetimefield,jobid,scheduleid";

    public static Map<String, String> timeTransformDate(Integer time) {
        int hour = time / 3600;
        int minute = time % 3600 / 60;
        int second = time % 3600 % 60;
        LinkedHashMap<String, String> timeMap = new LinkedHashMap<String, String>(3);
        timeMap.put("hour", String.valueOf(hour));
        timeMap.put("minute", String.valueOf(minute));
        timeMap.put("second", String.valueOf(second));
        return timeMap;
    }

    public static DynamicObjectCollection getQueryDataRecord(Long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"eb_collectionrecord", (String)FIELDS, (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObjectCollection getQueryCollectionProject(Long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"eb_collectionconfig", (String)"id,name,number,status,apprecord", (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObject[] getQueryExecuteProject(List<Long> ids) {
        QFBuilder qfBuilder = new QFBuilder("id", "in", ids);
        return BusinessDataServiceHelper.load((String)"eb_collectionexecute", (String)EXECUTE, (QFilter[])qfBuilder.toArray());
    }

    public static DynamicObject getQueryExecuteProject(String number) {
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)number);
        return BusinessDataServiceHelper.loadSingle((String)"eb_collectionexecute", (String)EXECUTE, (QFilter[])qfBuilder.toArray());
    }

    public static List<String> getEntityRang(String entity, long modelId) {
        if (!entity.isEmpty()) {
            ArrayList<String> accountIds = new ArrayList<String>(16);
            List serialize = SerializationUtils.fromJsonStringToList((String)entity, Map.class);
            IModelCacheHelper model = ModelCacheContext.getOrCreate((Long)modelId);
            for (Map stringMap : serialize) {
                List members = ModelCacheServiceHelper.getMember((Model)model.getModelobj(), (String)SysDimensionEnum.Entity.getNumber(), (String)((String)stringMap.get("number")), (int)Integer.parseInt((String)stringMap.get("scope")));
                for (Member member : members) {
                    accountIds.add(String.valueOf(member.getNumber()));
                }
            }
            return accountIds;
        }
        return new ArrayList<String>();
    }

    public static List<Long> getExecuteProjectByEntity(Long modelId, Long executeId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add(new QFilter("id", "=", (Object)executeId));
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"eb_collectionexecute", (String)"id,name,number,entryentity.project", (QFilter[])qfBuilder.toArray());
        if (dynamicObject.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f53\u524d\u65b9\u6848\u3002", (String)"DataCollectionUtil_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList projectId = new ArrayList(16);
        dynamicObject.forEach(e -> projectId.add(e.getLong("entryentity.project")));
        QFBuilder qf = new QFBuilder("id", "in", projectId);
        qf.add(new QFilter("status", "=", (Object)true));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_collectionconfig", (String)"id,entityrang", (QFilter[])qf.toArray());
        ArrayList<Long> memberId = new ArrayList<Long>(16);
        for (DynamicObject object : dynamicObjects) {
            String entityrang = object.getString("entityrang");
            List entityrangList = SerializationUtils.fromJsonStringToList((String)entityrang, Map.class);
            IModelCacheHelper model = ModelCacheContext.getOrCreate((Long)modelId);
            for (Map stringMap : entityrangList) {
                List members = ModelCacheServiceHelper.getMember((Model)model.getModelobj(), (String)SysDimensionEnum.Entity.getNumber(), (Long)0L, (String)((String)stringMap.get("number")), (int)Integer.parseInt((String)stringMap.get("scope")));
                members.forEach(d -> memberId.add(d.getId()));
            }
        }
        if (memberId.size() == 0) {
            return new ArrayList<Long>(1);
        }
        Set perm = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)0L, (Long)0L, (boolean)true);
        if (perm == null) {
            return memberId;
        }
        if (perm.size() == 0) {
            return new ArrayList<Long>(1);
        }
        return perm.stream().filter(memberId::contains).collect(Collectors.toList());
    }
}

