/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherGL;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDim;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDimEntry;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingMember;
import kd.epm.eb.business.dataGather.service.DataCollectionService;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherMappingDimService;
import kd.epm.eb.business.dataGather.service.DataGatherMappingMemberService;
import kd.epm.eb.business.dataGather.service.DataGatherRunService;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;

public class DataGatherCollectSchemeService {
    private static final Log log = LogFactory.getLog(DataGatherCollectSchemeService.class);
    private boolean isBgm = false;

    public static DataGatherCollectSchemeService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherCollectSchemeService() {
    }

    private void initVal(DataGatherHandCallParam param) {
        this.isBgm = DataGatherRunService.checkAppNum(param, ApplicationTypeEnum.BGM);
    }

    public List<DataGatherCollectScheme> getDataTransCollectScheme(Long modelID, List<Long> collectSchemeIds, DataGatherHandCallParam param) {
        this.initVal(param);
        if (collectSchemeIds == null || collectSchemeIds.size() == 0) {
            DataGatherCommon.doLogWithTime(0L, "collectSchemeIds is null or 0 ", log);
            throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65b9\u6848\u4e3a\u7a7a\uff01", (String)"DataGatherCollectSchemeService_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        List<DataGatherCollectScheme> dataScheme = this.queryCollectSchemes(modelID, collectSchemeIds, param);
        DataGatherCommon.doLogWithTime(0L, "begin getMemberMappingIDs: " + collectSchemeIds.toString(), log);
        Set<Long> memberMappingIDs = this.getMemberMappingIDs(dataScheme);
        List<DataGatherMappingMember> memberMappings = DataGatherMappingMemberService.getInstance().getDataGatherMappingMember(memberMappingIDs);
        DataGatherCommon.doLogWithTime(0L, "begin setMemberMapping: " + collectSchemeIds.toString(), log);
        this.setMemberMapping(dataScheme, memberMappings);
        return dataScheme;
    }

    public void setExcuteAndCollectOrgMix(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo) {
        HashSet<String> mixOrgs = new HashSet<String>(collectSchemeInfo.getSuitOrgs());
        DataGatherCommon.doLogWithTime(0L, " collectSchemeInfo.OrgNums: " + collectSchemeInfo.getSuitOrgs().toString(), log);
        DataGatherHandCallParam handCalParam = excuteSchemeInfo.getHandCallParam();
        if (handCalParam != null) {
            DataGatherCommon.doLogWithTime(0L, " handCalParam.OrgNums: " + handCalParam.getOrgNums().toString(), log);
            mixOrgs.retainAll(handCalParam.getOrgNums());
        }
        DataGatherCommon.doLogWithTime(0L, " mixOrgs.OrgNums: " + ((Object)mixOrgs).toString(), log);
        collectSchemeInfo.setMixOrgs(mixOrgs);
    }

    private List<DataGatherCollectScheme> queryCollectSchemes(Long modelID, List<Long> collectSchemeIds, DataGatherHandCallParam param) {
        String selectFields = "id,number,name,model,entityrang,currency,periodtype,status,entitydimmap.dimnumber,entitydimmap.dimname,entitydimmap.fieldtable,entitydimmap.fieldid,entitydimmap.fieldname,entitydimmap.dimmap,entitydimmap.dimassign,entityyearmap.budgetyear,entityyearmap.accyearid,entityperiodmap.accperiod,entityperiodmap.budgetperiod,entityperiodmap.fiscalyear,businessentry,standard,accountform,booktype ";
        if (this.isBgm) {
            selectFields = String.join((CharSequence)",", selectFields, "dataset");
        }
        QFilter qFilter = new QFilter("id", "in", collectSchemeIds);
        qFilter.and(new QFilter("model", "=", (Object)modelID));
        qFilter.and(new QFilter("status", "=", (Object)"1"));
        String formID = "eb_collectionconfig";
        ArrayList<DataGatherCollectScheme> returns = new ArrayList<DataGatherCollectScheme>(DataGatherCommon.initSize);
        DynamicObject[] dataRows = BusinessDataServiceHelper.load((String)formID, (String)selectFields, (QFilter[])qFilter.toArray());
        if (dataRows == null || dataRows.length == 0) {
            DataGatherCommon.doLogWithTime(0L, " queryCollectSchemes: null or 0", log);
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u91c7\u96c6\u65b9\u6848\uff01", (String)"DataGatherCollectSchemeService_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        DataGatherCommon.doLogWithTime(0L, " queryCollectSchemes:" + collectSchemeIds.size(), log);
        for (DynamicObject dataRow : dataRows) {
            if (!dataRow.getBoolean("status")) continue;
            DataGatherCollectScheme collectScheme = new DataGatherCollectScheme();
            collectScheme.setGatherApp("GL");
            collectScheme.setModelID(modelID);
            collectScheme.setModelNumber(dataRow.getString("model.shownumber"));
            collectScheme.setModelName(dataRow.getString("model.name"));
            collectScheme.setID(dataRow.getLong("id"));
            collectScheme.setNumber(dataRow.getString("number"));
            collectScheme.setName(dataRow.getString("name"));
            collectScheme.setStatus(dataRow.getBoolean("status"));
            collectScheme.setTargetCurrencyID(dataRow.getLong("currency.id"));
            collectScheme.setTargetCurrencyNumber(dataRow.getString("currency.number"));
            collectScheme.setTargetCurrencyName(dataRow.getString("currency.name"));
            this.setSuitOrgs(modelID, collectScheme, dataRow.getString("entityrang"));
            this.setGlGather(collectScheme, dataRow);
            this.setDimMpping(collectScheme, dataRow, param);
            if (this.isBgm) {
                collectScheme.setDatasetId(dataRow.getLong("dataset.id"));
            }
            returns.add(collectScheme);
        }
        return returns;
    }

    private void setMemberMapping(List<DataGatherCollectScheme> colSchemes, List<DataGatherMappingMember> memberMappings) {
        if (memberMappings == null || memberMappings.size() == 0) {
            return;
        }
        if (colSchemes == null || colSchemes.size() == 0) {
            return;
        }
        for (DataGatherCollectScheme colScheme : colSchemes) {
            if (colScheme.getDimMpping() == null && colScheme.getDimMpping().getDimMemberMapping() == null) continue;
            this.getMemberMapping(colScheme.getDimMpping().getDimMemberMapping(), memberMappings);
        }
    }

    private void getMemberMapping(List<DataGatherMappingDimEntry> mappingDimEntrys, List<DataGatherMappingMember> memberMappings) {
        if (memberMappings == null || memberMappings.size() == 0) {
            return;
        }
        if (mappingDimEntrys == null || mappingDimEntrys.size() == 0) {
            return;
        }
        block0: for (DataGatherMappingDimEntry mappingDimEntry : mappingDimEntrys) {
            Long mappingID = mappingDimEntry.getDimMappingID();
            if (mappingID == 0L) continue;
            for (DataGatherMappingMember memberMapping : memberMappings) {
                if (!memberMapping.getFID().equals(mappingID)) continue;
                mappingDimEntry.setMemberMapping(memberMapping);
                continue block0;
            }
        }
    }

    private Set<Long> getMemberMappingIDs(List<DataGatherCollectScheme> colSchemes) {
        if (colSchemes == null || colSchemes.size() == 0) {
            return null;
        }
        HashSet<Long> returns = new HashSet<Long>(DataGatherCommon.initSize);
        for (DataGatherCollectScheme colScheme : colSchemes) {
            List<DataGatherMappingDimEntry> dimEntryMappings = colScheme.getDimMpping().getDimMemberMapping();
            if (dimEntryMappings == null || dimEntryMappings.size() == 0) continue;
            for (DataGatherMappingDimEntry entry : dimEntryMappings) {
                Long mappingID = entry.getDimMappingID();
                if (mappingID <= 0L) continue;
                returns.add(entry.getDimMappingID());
            }
        }
        return returns;
    }

    private void setSuitOrgs(Long modelID, DataGatherCollectScheme collectScheme, String suitOrgJson) {
        List<String> suitOrgs = DataCollectionService.getEntityRang(suitOrgJson, modelID);
        collectScheme.setSuitOrgs(suitOrgs);
    }

    private void setGlGather(DataGatherCollectScheme collectScheme, DynamicObject dataRow) {
        DataGatherGL glGather = new DataGatherGL();
        if (dataRow != null) {
            DynamicObject accounttable = (DynamicObject)dataRow.get("accountform");
            DynamicObjectCollection orgs = (DynamicObjectCollection)dataRow.get("businessentry");
            DynamicObject basecurrency = (DynamicObject)dataRow.get("standard");
            DynamicObject periodtype = (DynamicObject)dataRow.get("periodtype");
            DynamicObject bookstype = (DynamicObject)dataRow.get("booktype");
            if (bookstype == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u603b\u8d26\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u8d26\u7c3f\u7c7b\u578b\uff01", (String)"DataGatherCollectSchemeService_1", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            ArrayList<DataGatherGLMember> glOrgs = new ArrayList<DataGatherGLMember>(DataGatherCommon.initSize);
            for (DynamicObject org : orgs) {
                DataGatherGLMember glMember = new DataGatherGLMember();
                glMember.setId(org.getLong("fbasedataid.id"));
                glMember.setNumber(org.getString("fbasedataid.number"));
                glMember.setName(org.getString("fbasedataid.name"));
                glOrgs.add(glMember);
            }
            glGather.setGlOrgs(glOrgs);
            glGather.setPeriodTypeID(periodtype.getLong("id"));
            glGather.setPeriodTypeNumber(periodtype.getString("number"));
            glGather.setPeriodTypeName(periodtype.getString("name"));
            glGather.setBookType(bookstype.getLong("id"));
            glGather.setBookTypeNumber(bookstype.getString("number"));
            glGather.setBookTypeName(bookstype.getString("name"));
            glGather.setCurrencyID(basecurrency.getLong("id"));
            glGather.setCurrencyNumber(basecurrency.getString("number"));
            glGather.setCurrencyName(basecurrency.getString("name"));
            glGather.setAccountTableID(accounttable.getLong("id"));
            glGather.setAccountTableNumber(accounttable.getString("number"));
            glGather.setAccountTableName(accounttable.getString("name"));
        }
        collectScheme.setGlGather(glGather);
    }

    private void setDimMpping(DataGatherCollectScheme collectScheme, DynamicObject dataRow, DataGatherHandCallParam param) {
        DataGatherMappingDim dimMpping = new DataGatherMappingDim();
        DataGatherMappingDimService.getInstance().getDataGatherMappingDim(dimMpping, dataRow, param);
        collectScheme.setDimMpping(dimMpping);
    }

    private static class InnerClass {
        private static DataGatherCollectSchemeService instance = new DataGatherCollectSchemeService();

        private InnerClass() {
        }
    }
}

