/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.epm.eb.business.dataGather.entity.DataGatherGL;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;

public class DataGatherCommon {
    public static final String LOGINFO = "DataGather:";
    public static final Integer initSize = 16;
    public static final Integer sqlBatch = 8000;
    public static final String EB_COLLECTIONCONFIG = "eb_collectionconfig";
    public static final String EB_EBDIMMEMBERMAP = "eb_ebdimmembermap";
    public static final String EB_GLGATHERDATA = "eb_datagatherdata";
    public static final String PERIOD_FIX = "M_M";
    public static final String YEAR_FIX = "FY";
    public static final String CON_INFO_SPLIT = "--";
    public static final String CON_FORM_GLORG = "gl_org";
    public static final String NOMATCHINFO = "ERR!";
    public static final ThreadLocal<Map<String, List<Integer>>> INDEX_LIST = new ThreadLocal();
    public static final ThreadLocal<String> GL_TYPE_KEY = new ThreadLocal();
    public static final ThreadLocal<List<Long>> MEMBER_ID_LIST = new ThreadLocal();
    public static final ThreadLocal<Set<String>> GL_SUB_MEMBERS = new ThreadLocal();

    public static void doLogWithTime(long beginTime, String info, Log log) {
        String logInfo = StringUtils.join((Object[])new String[]{LOGINFO, RequestContext.get().getUserName(), CON_INFO_SPLIT, info});
        if (beginTime > 0L) {
            logInfo = StringUtils.join((Object[])new Serializable[]{info, CON_INFO_SPLIT, Long.valueOf(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginTime))});
        }
        log.info(logInfo);
    }

    public static String getDefaultDimNumber(String dimKey) {
        String returns = "";
        switch (dimKey) {
            case "InternalCompany": {
                returns = "ICNone";
                break;
            }
            case "ChangeType": {
                returns = "DataIntegration";
                break;
            }
            case "Version": {
                returns = "ACTUAL";
                break;
            }
            case "AuditTrail": {
                returns = "EntityInput";
                break;
            }
            case "DataType": {
                returns = "Actual";
                break;
            }
            case "Process": {
                returns = "IRpt";
                break;
            }
            case "Scenario": {
                returns = "NoScenario";
            }
        }
        return returns;
    }

    public static LinkedHashMap<String, String> getDimValuesLinkedHashMap(List<String> allDimKey, Map<String, String> ebDimMap) {
        if (ebDimMap == null || ebDimMap.size() == 0) {
            return null;
        }
        LinkedHashMap<String, String> returns = new LinkedHashMap<String, String>(ebDimMap.size());
        for (String dimKey : allDimKey) {
            returns.put(dimKey, ebDimMap.get(dimKey));
        }
        return returns;
    }

    public static String conform2Str(LinkedHashMap<String, String> ebDims) {
        return ObjectSerialUtil.toJson(ebDims);
    }

    public static String[] getDimValueByDimOrd(List<String> allDimKey, Map<String, String> ebDimMap) {
        if (ebDimMap == null || ebDimMap.size() == 0) {
            return null;
        }
        String[] returns = new String[ebDimMap.size()];
        int i = 0;
        for (String dimKey : allDimKey) {
            returns[i] = ebDimMap.get(dimKey);
            ++i;
        }
        return returns;
    }

    public static long[] getGlOrgIds(DataGatherGL glParams) {
        if (glParams == null || glParams.getGlOrgs() == null) {
            return null;
        }
        Collection<DataGatherGLMember> glOrgCols = glParams.getGlOrgs();
        long[] glOrgs = new long[glOrgCols.size()];
        int i = 0;
        for (DataGatherGLMember glOrgCol : glOrgCols) {
            glOrgs[i] = glOrgCol.getId();
            ++i;
        }
        return glOrgs;
    }

    public static Set<String> getGlOrgNameOrNums(DataGatherGL glParams, boolean isShowNum) {
        if (glParams == null || glParams.getGlOrgs() == null) {
            return null;
        }
        Collection<DataGatherGLMember> glOrgCols = glParams.getGlOrgs();
        HashSet<String> glOrgs = new HashSet<String>(glOrgCols.size());
        for (DataGatherGLMember glOrgCol : glOrgCols) {
            if (isShowNum) {
                glOrgs.add(glOrgCol.getNumber());
                continue;
            }
            glOrgs.add(glOrgCol.getName());
        }
        return glOrgs;
    }

    public static String getNoMatchInfo(String info) {
        return NOMATCHINFO + info;
    }
}

