/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherGL;
import kd.epm.eb.business.dataGather.entity.DataGatherGLTypeRange;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDimEntry;
import kd.epm.eb.business.dataGather.entity.DataGatherMiddleTable;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherDoMemberMapping;
import kd.epm.eb.business.dataGather.service.DataGatherDoSourceFieldMapping;
import kd.epm.eb.business.dataGather.service.DataGatherPeriodsBGM;
import kd.epm.eb.business.dataGather.service.DataGatherPeriodsEB;
import kd.epm.eb.business.dataGather.service.DataGatherRunService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class DataGatherDoMapping {
    private static final Set<String> DEFAULTDIMSMAP = Sets.newHashSet((Object[])new String[]{"Process", "Scenario", "DataType", "InternalCompany", "ChangeType", "Version", "AuditTrail"});
    private static final Set<String> DEFAULTDIMSMAP_BGM = Sets.newHashSet((Object[])new String[]{"Version", "AuditTrail", "ChangeType", "InternalCompany", "DataType", "Metric"});
    private static final Set<String> SCHEMADIMSMAP = Sets.newHashSet((Object[])new String[]{"Year", "Period", "Currency"});
    private static final Set<String> SCHEMADIMSMAP_BGM = Sets.newHashSet((Object[])new String[]{"BudgetPeriod", "Currency"});
    private Map<String, DataGatherGLTypeRange> acctTypeValues_out;
    private Map<String, Set<String>> ebTypeValues_out;
    private IModelCacheHelper modelcache;

    public static DataGatherDoMapping getInstance() {
        return InnerClass.instance;
    }

    private DataGatherDoMapping() {
    }

    public boolean getMappingDims(IModelCacheHelper modelcache, DataGatherCollectScheme collectSchemeInfo, List<DataGatherMiddleTable> GlDataTableDatas, List<String> allDimKey, DataGatherHandCallParam param) {
        if (GlDataTableDatas == null || GlDataTableDatas.size() == 0) {
            return true;
        }
        this.modelcache = modelcache;
        return this.getSingleMappingDimsLoop(collectSchemeInfo, GlDataTableDatas, allDimKey, param);
    }

    private boolean getSingleMappingDimsLoop(DataGatherCollectScheme collectSchemeInfo, List<DataGatherMiddleTable> GlDataTableDatas, List<String> allDimKey, DataGatherHandCallParam param) {
        if (GlDataTableDatas == null || GlDataTableDatas.size() == 0) {
            return true;
        }
        HashMap<String, String> ebDimMap = null;
        this.acctTypeValues_out = new HashMap<String, DataGatherGLTypeRange>(DataGatherCommon.initSize);
        this.ebTypeValues_out = new HashMap<String, Set<String>>(DataGatherCommon.initSize);
        boolean returns = false;
        for (DataGatherMiddleTable GLDataTableData : GlDataTableDatas) {
            ebDimMap = new HashMap<String, String>(DataGatherCommon.initSize);
            Double value = null;
            switch (GLDataTableData.getDc()) {
                case "-1": {
                    value = (Double)GLDataTableData.getCreditfor() - (Double)GLDataTableData.getDebitfor();
                    break;
                }
                case "1": {
                    value = (Double)GLDataTableData.getDebitfor() - (Double)GLDataTableData.getCreditfor();
                }
            }
            String dimNumber = this.getDimMapTransfer(collectSchemeInfo, ebDimMap, allDimKey, GLDataTableData, param);
            if (dimNumber.startsWith("ERR!")) {
                GLDataTableData.setEbDimInfo(StringUtils.join((Object[])new String[]{dimNumber.split("!")[1], ebDimMap.size() > 0 ? ((Object)ebDimMap).toString() : ""}));
                GLDataTableData.setIsSuc("0");
                continue;
            }
            LinkedHashMap<String, String> ebDimMapSort = DataGatherCommon.getDimValuesLinkedHashMap(allDimKey, ebDimMap);
            GLDataTableData.setEbDimMap(ebDimMapSort);
            GLDataTableData.setEbDimInfo(DataGatherCommon.conform2Str(ebDimMapSort));
            GLDataTableData.setIsSuc("1");
            GLDataTableData.setValue(value);
            returns = true;
        }
        return returns;
    }

    private String getDimMapTransfer(DataGatherCollectScheme collectSchemeInfo, Map<String, String> ebDimMap, List<String> allDimKey, DataGatherMiddleTable GLDataTableData, DataGatherHandCallParam param) {
        if (collectSchemeInfo == null || collectSchemeInfo.getDimMpping() == null) {
            return DataGatherCommon.getNoMatchInfo(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u91c7\u96c6\u65b9\u6848\u6216\u91c7\u96c6\u65b9\u6848\u672a\u8bbe\u7f6e\u6620\u5c04\u3002", (String)"DataGatherDoMapping_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        List<DataGatherMappingDimEntry> dimMappings = collectSchemeInfo.getDimMpping().getDimMemberMapping();
        if (dimMappings == null || dimMappings.size() == 0) {
            return DataGatherCommon.getNoMatchInfo(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6e90\u5b57\u6bb5", (String)"DataGatherDoMapping_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        for (String dimKey : allDimKey) {
            String dimNumber = "";
            dimNumber = this.isContainsDefaultDims(dimKey, param) ? DataGatherCommon.getDefaultDimNumber(dimKey) : (this.isContainsDimsInSchema(dimKey, param) ? this.getDimNumberFromSchema(dimKey, collectSchemeInfo, Long.valueOf(GLDataTableData.getGlPeriod().toString()), param) : this.getDimNumberByMap(dimKey, dimMappings, GLDataTableData, collectSchemeInfo.getGlGather()));
            if (!dimNumber.startsWith("ERR!") && dimKey.equalsIgnoreCase(SysDimensionEnum.Entity.getNumber()) && !collectSchemeInfo.getMixOrgs().contains(dimNumber)) {
                dimNumber = DataGatherCommon.getNoMatchInfo(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u6620\u5c04\u6210\u201c%1\u201d\u540e\u4e0d\u5728\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"DataGatherDoMapping_2", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
            if (dimNumber.startsWith("ERR!")) {
                return dimNumber;
            }
            ebDimMap.put(dimKey, dimNumber);
        }
        return ebDimMap.toString();
    }

    private boolean isContainsDimsInSchema(String dimKey, DataGatherHandCallParam param) {
        if (DataGatherRunService.checkAppNum(param, ApplicationTypeEnum.BGM)) {
            return SCHEMADIMSMAP_BGM.contains(dimKey);
        }
        return SCHEMADIMSMAP.contains(dimKey);
    }

    private boolean isContainsDefaultDims(String dimKey, DataGatherHandCallParam param) {
        if (DataGatherRunService.checkAppNum(param, ApplicationTypeEnum.BGM)) {
            return DEFAULTDIMSMAP_BGM.contains(dimKey);
        }
        return DEFAULTDIMSMAP.contains(dimKey);
    }

    private String getDimNumberByMap(String dimKey, List<DataGatherMappingDimEntry> dimMappings, DataGatherMiddleTable GLDataTableData, DataGatherGL glGather) {
        if (dimMappings == null || dimMappings.size() == 0) {
            return DataGatherCommon.getNoMatchInfo(SysDimensionEnum.getEnumByNumber((String)dimKey) == null ? dimKey : ResManager.loadResFormat((String)"\u201c%1\u201d\u6ca1\u6709\u8bbe\u7f6e\u6e90\u5b57\u6bb5\u3002", (String)"DataGatherDoMapping_3", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.getEnumByNumber((String)dimKey).getChineseName()}));
        }
        if (GLDataTableData == null || GLDataTableData.getGlRowMembers() == null) {
            return DataGatherCommon.getNoMatchInfo(SysDimensionEnum.getEnumByNumber((String)dimKey) == null ? dimKey : ResManager.loadResFormat((String)"%1\u603b\u8d26", (String)"DataGatherDoMapping_5", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.getEnumByNumber((String)dimKey).getChineseName()}));
        }
        String returns = "";
        for (DataGatherMappingDimEntry dimMapping : dimMappings) {
            if (!dimKey.equalsIgnoreCase(dimMapping.getDimKeyNumber())) continue;
            if (dimMapping.getDimMappingID().compareTo(0L) > 0) {
                returns = DataGatherDoMemberMapping.getInstance().getMappingNumberByMemberMapping(dimMapping.getMemberMapping(), GLDataTableData.getGlRowMembers(), this.acctTypeValues_out);
            }
            if ((StringUtils.isEmpty((CharSequence)returns) || returns.startsWith("ERR!")) && !StringUtils.isEmpty((CharSequence)dimMapping.getSourceFieldTable())) {
                returns = DataGatherDoSourceFieldMapping.getInstance().getDimNumberBySourceField(this.modelcache, dimMapping, GLDataTableData, glGather, this.acctTypeValues_out, this.ebTypeValues_out);
            }
            if (!StringUtils.isEmpty((CharSequence)returns) && !returns.startsWith("ERR!") || dimMapping.getDimDefaultID().compareTo(0L) <= 0) continue;
            returns = dimMapping.getDimDefaultNumber();
        }
        if (!StringUtils.isEmpty((CharSequence)returns)) {
            return returns;
        }
        if (SysDimensionEnum.getEnumByNumber((String)dimKey) == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6[%1]\u6ca1\u6709\u6620\u5c04\uff0c\u8bf7\u65b0\u5efa[\u91c7\u96c6\u914d\u7f6e\u65b9\u6848]\u540e\u91cd\u8bd5\u3002", (String)"DataGatherDoMapping_13", (String)"epm-eb-business", (Object[])new Object[]{dimKey}));
        }
        String dimMappingFailedMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6[%1]\u6620\u5c04\u5931\u8d25\u3002", (String)"DataGatherDoMapping_6", (String)"epm-eb-business", (Object[])new Object[]{dimKey});
        String mappingFailedMsg = ResManager.loadResFormat((String)"\u201c%1\u201d\u6620\u5c04\u8bbe\u7f6e\u7684\u6e90\u5b57\u6bb5\u4e0d\u5339\u914d\u3002", (String)"DataGatherDoMapping_4", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.getEnumByNumber((String)dimKey).getChineseName()});
        return DataGatherCommon.getNoMatchInfo(SysDimensionEnum.getEnumByNumber((String)dimKey) == null ? dimMappingFailedMsg : mappingFailedMsg);
    }

    private String getDimNumberFromSchema(String dimKey, DataGatherCollectScheme collectSchemeInfo, Long GLPeriod, DataGatherHandCallParam param) {
        String returns = "";
        if (DataGatherRunService.checkAppNum(param, ApplicationTypeEnum.EB)) {
            returns = DataGatherPeriodsEB.getInstance().getDimNumberFromSchema(dimKey, collectSchemeInfo, GLPeriod);
        }
        if (DataGatherRunService.checkAppNum(param, ApplicationTypeEnum.BGM)) {
            returns = DataGatherPeriodsBGM.getInstance().getDimNumberFromSchema(dimKey, collectSchemeInfo, GLPeriod);
        }
        return returns;
    }

    private static class InnerClass {
        private static DataGatherDoMapping instance = new DataGatherDoMapping();

        private InnerClass() {
        }
    }
}

