/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMemberRange;
import kd.epm.eb.business.dataGather.entity.DataGatherGLTypeRange;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingMember;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingMemberEntry;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherGLTypeRangeUtils;
import kd.epm.eb.common.enums.RangeEnum;

public class DataGatherDoMemberMapping {
    private static final Log LOG = LogFactory.getLog(DataGatherDoMemberMapping.class);
    private static final Integer initSize = 16;
    private static final String NOMATCHINFO = "ERR!";
    private static Map<String, String> formMapings;

    public static DataGatherDoMemberMapping getInstance() {
        return InnerClass.instance;
    }

    private DataGatherDoMemberMapping() {
        formMapings = new HashMap<String, String>(initSize);
        formMapings.put("bos_assistantdata_detail", "bd_asstacttype");
    }

    public String getMappingNumberByMemberMapping(DataGatherMappingMember dimMemberMapping, List<DataGatherGLTypeRange> glDataRowMembers, Map<String, DataGatherGLTypeRange> acctTypeValues_out) {
        String returns = "";
        if (glDataRowMembers == null || glDataRowMembers.size() == 0) {
            return "";
        }
        List<DataGatherMappingMemberEntry> memberMappingEntrys = dimMemberMapping.getMemberMappingEntry();
        List<DataGatherMappingMemberEntry> memberMappingEntrys_First = dimMemberMapping.getMemberMappingEntryFirst();
        List<DataGatherMappingMemberEntry> memberMappingEntrys_Last = dimMemberMapping.getMemberMappingEntryLast();
        if (!(memberMappingEntrys != null && memberMappingEntrys.size() != 0 || memberMappingEntrys_First != null && memberMappingEntrys_First.size() != 0 || memberMappingEntrys_Last != null && memberMappingEntrys_Last.size() != 0)) {
            return DataGatherCommon.getNoMatchInfo(ResManager.loadResFormat((String)"%1\u6ca1\u6709\u8bbe\u7f6e\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u660e\u7ec6", (String)"DataGatherDoMapping_10", (String)"epm-eb-business", (Object[])new Object[]{dimMemberMapping.getDimKeyName()}));
        }
        returns = this.doLoopMappingEntry(memberMappingEntrys_First, dimMemberMapping, glDataRowMembers, acctTypeValues_out);
        if (StringUtils.isEmpty((CharSequence)returns) || returns.startsWith(NOMATCHINFO)) {
            returns = this.doLoopMappingEntry(memberMappingEntrys, dimMemberMapping, glDataRowMembers, acctTypeValues_out);
        }
        if (StringUtils.isEmpty((CharSequence)returns) || returns.startsWith(NOMATCHINFO)) {
            returns = this.doLoopMappingEntry(memberMappingEntrys_Last, dimMemberMapping, glDataRowMembers, acctTypeValues_out);
        }
        if (!StringUtils.isEmpty((CharSequence)returns) && !returns.startsWith(NOMATCHINFO)) {
            return returns;
        }
        return DataGatherCommon.getNoMatchInfo(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u6ca1\u6709\u5339\u914d\u4e0a", (String)"DataGatherDoMapping_8", (String)"epm-eb-business", (Object[])new Object[]{dimMemberMapping.getDimKeyName()}));
    }

    private String doLoopMappingEntry(List<DataGatherMappingMemberEntry> memberMappingEntrys, DataGatherMappingMember dimMemberMapping, List<DataGatherGLTypeRange> glDataRowMembers, Map<String, DataGatherGLTypeRange> acctTypeValues_out) {
        if (memberMappingEntrys != null) {
            ArrayList longList = new ArrayList(initSize);
            longList.addAll(memberMappingEntrys.stream().filter(member -> member != null).map(member -> member.getBusinessMemberID()).collect(Collectors.toList()));
            DataGatherCommon.MEMBER_ID_LIST.set(longList);
            for (DataGatherMappingMemberEntry memberMappingEntry : memberMappingEntrys) {
                if (memberMappingEntry == null || !this.isMatchedMember(memberMappingEntry, dimMemberMapping, glDataRowMembers, acctTypeValues_out)) continue;
                return memberMappingEntry.getDimMemberNumber();
            }
            DataGatherCommon.MEMBER_ID_LIST.get().clear();
        }
        return DataGatherCommon.getNoMatchInfo(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u6ca1\u6709\u5339\u914d\u4e0a", (String)"DataGatherDoMapping_8", (String)"epm-eb-business", (Object[])new Object[]{dimMemberMapping.getDimKeyName()}));
    }

    private boolean isMatchedMember(DataGatherMappingMemberEntry memberMappingEntry, DataGatherMappingMember dimMemberMapping, List<DataGatherGLTypeRange> glDataRowMembers, Map<String, DataGatherGLTypeRange> acctTypeValues_out) {
        for (DataGatherGLTypeRange glDataRowMember : glDataRowMembers) {
            if (!this.isMatchMemberIncludeRange(memberMappingEntry, dimMemberMapping, glDataRowMember, acctTypeValues_out)) continue;
            return this.isMatchedAss(memberMappingEntry, dimMemberMapping, glDataRowMembers);
        }
        return false;
    }

    private boolean isMatchMemberIncludeRange(DataGatherMappingMemberEntry memberMappingEntry, DataGatherMappingMember dimMemberMapping, DataGatherGLTypeRange glDataRowMember, Map<String, DataGatherGLTypeRange> acctTypeValues_out) {
        String businessBaseData = this.getBusinessBaseData(memberMappingEntry, dimMemberMapping);
        if (StringUtils.isBlank((CharSequence)businessBaseData) || !businessBaseData.equalsIgnoreCase(glDataRowMember.getTypeFormId())) {
            return false;
        }
        if (memberMappingEntry.getScope().intValue() != RangeEnum.ONLY.getIndex()) {
            DataGatherGLMemberRange rangeMembers = this.doRange(businessBaseData, memberMappingEntry, acctTypeValues_out);
            if (rangeMembers == null) {
                return false;
            }
            Set<String> glRangeObjs = DataGatherCommon.GL_SUB_MEMBERS.get();
            if (glRangeObjs == null) {
                DataGatherCommon.GL_SUB_MEMBERS.set(new HashSet(16));
                glRangeObjs = DataGatherCommon.GL_SUB_MEMBERS.get();
            }
            glRangeObjs.add(memberMappingEntry.getBusinessMemberNumber());
            Collection<DataGatherGLMember> glMembers = glDataRowMember.getSubMembers();
            if (glMembers == null || glMembers.size() == 0) {
                return false;
            }
            for (DataGatherGLMember glMember : glMembers) {
                if (!glRangeObjs.contains(glMember.getNumber())) continue;
                glRangeObjs.clear();
                return true;
            }
            glRangeObjs.clear();
        } else {
            Collection<DataGatherGLMember> glMembers = glDataRowMember.getSubMembers();
            if (glMembers == null || glMembers.size() == 0) {
                return false;
            }
            for (DataGatherGLMember glMember : glMembers) {
                if (!memberMappingEntry.getBusinessMemberNumber().equals(glMember.getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private DataGatherGLMemberRange doRange(String businessBaseData, DataGatherMappingMemberEntry memberMappingEntry, Map<String, DataGatherGLTypeRange> acctTypeValues_out) {
        String glTypeKey = DataGatherGLTypeRangeUtils.getInstance().getGLTypeKey(businessBaseData, 0L);
        DataGatherCommon.GL_TYPE_KEY.set(glTypeKey);
        DataGatherGLTypeRangeUtils.getInstance().getGLTypeRange(glTypeKey, businessBaseData, null, acctTypeValues_out);
        DataGatherGLTypeRange curTypeRange = DataGatherGLTypeRangeUtils.getInstance().findGLTypeRange(glTypeKey, acctTypeValues_out);
        if (curTypeRange == null) {
            return null;
        }
        DataGatherGLMemberRange curMemberRange = this.setGLMemberRangeObj(memberMappingEntry, curTypeRange);
        this.resolveRange(memberMappingEntry.getScope(), curMemberRange, curTypeRange.getSubMembers());
        return curMemberRange;
    }

    private DataGatherGLMemberRange setGLMemberRangeObj(DataGatherMappingMemberEntry memberMappingEntry, DataGatherGLTypeRange curTypeRange) {
        DataGatherGLMemberRange returns = new DataGatherGLMemberRange();
        returns.setGlTypeRange(curTypeRange);
        DataGatherGLMember glMember = new DataGatherGLMember();
        glMember.setId(memberMappingEntry.getBusinessMemberID());
        glMember.setNumber(memberMappingEntry.getBusinessMemberNumber());
        glMember.setName(memberMappingEntry.getBusinessMemberName());
        returns.setGlMember(glMember);
        returns.setRange(memberMappingEntry.getScope());
        return returns;
    }

    private void resolveRange(int scope, DataGatherGLMemberRange curMemberRange, Collection<DataGatherGLMember> allRangeMembers) {
        if (curMemberRange == null || allRangeMembers == null) {
            return;
        }
        if (scope == RangeEnum.ALL.getIndex()) {
            curMemberRange.setSubMembers(this.getAllSubMembers(curMemberRange, allRangeMembers));
        }
    }

    private Collection<DataGatherGLMember> getAllSubMembers(DataGatherGLMemberRange curRangeMembers, Collection<DataGatherGLMember> allRangeMembers) {
        ArrayList<DataGatherGLMember> returns = new ArrayList<DataGatherGLMember>(initSize);
        if (allRangeMembers == null) {
            return returns;
        }
        if (allRangeMembers instanceof List) {
            List<Integer> indexList;
            List tmpList = (List)allRangeMembers;
            Long glMemberId = curRangeMembers.getGlMember().getId();
            String glTypeKey = DataGatherCommon.GL_TYPE_KEY.get();
            if (glTypeKey == null) {
                LOG.error((Throwable)new KDBizException("Thread variable read failed."));
                glTypeKey = "";
            }
            String join = String.join((CharSequence)"_", glTypeKey, String.valueOf(glMemberId));
            Map<String, List<Integer>> indexVar = DataGatherCommon.INDEX_LIST.get();
            if (indexVar == null) {
                DataGatherCommon.INDEX_LIST.set(new HashMap(16));
                indexVar = DataGatherCommon.INDEX_LIST.get();
            }
            if ((indexList = indexVar.get(join)) == null) {
                return returns;
            }
            Set<String> subMembers = DataGatherCommon.GL_SUB_MEMBERS.get();
            if (subMembers == null) {
                DataGatherCommon.GL_SUB_MEMBERS.set(new HashSet(16));
                subMembers = DataGatherCommon.GL_SUB_MEMBERS.get();
            }
            for (Integer index : indexList) {
                DataGatherGLMember dataGatherGLMember = (DataGatherGLMember)tmpList.get(index);
                if (dataGatherGLMember == null) continue;
                subMembers.add(dataGatherGLMember.getNumber());
                returns.add(dataGatherGLMember);
            }
        }
        return returns;
    }

    private String getBusinessBaseData(DataGatherMappingMemberEntry memberMappingEntry, DataGatherMappingMember dimMemberMapping) {
        String returns = dimMemberMapping.getBusinessBaseData();
        if (dimMemberMapping.getUseMoreBussData().booleanValue()) {
            returns = memberMappingEntry.getBusinessBaseData() == null ? "" : memberMappingEntry.getBusinessBaseData();
        }
        return formMapings.get(returns.toLowerCase(Locale.getDefault())) == null ? returns : formMapings.get(returns);
    }

    private boolean isMatchedAss(DataGatherMappingMemberEntry memberMappingEntry, DataGatherMappingMember dimMemberMapping, List<DataGatherGLTypeRange> glDataRowMembers) {
        if (dimMemberMapping.getUseAssistData().booleanValue()) {
            return this.isMatchAssNumber2(memberMappingEntry, dimMemberMapping, glDataRowMembers);
        }
        return true;
    }

    private boolean isMatchEmptyAssist(List<DataGatherGLTypeRange> glDataRowMembers) {
        if (glDataRowMembers == null || glDataRowMembers.size() == 0) {
            return true;
        }
        for (DataGatherGLTypeRange glDataRowMember : glDataRowMembers) {
            if (DataGatherGLTypeRangeUtils.getInstance().getAccountFormId("bd_accountview").equalsIgnoreCase(glDataRowMember.getTypeFormId()) || "gl_org".equalsIgnoreCase(glDataRowMember.getTypeFormId())) continue;
            return false;
        }
        return true;
    }

    private boolean isMatchNoEmptyAssist(DataGatherMappingMemberEntry memberMappingEntry, DataGatherMappingMember dimMemberMapping, List<DataGatherGLTypeRange> glDataRowMembers) {
        if (glDataRowMembers == null || glDataRowMembers.size() == 0) {
            return false;
        }
        for (DataGatherGLTypeRange glDataRowMember : glDataRowMembers) {
            if (!dimMemberMapping.getBusinessBaseDataExt().equalsIgnoreCase(glDataRowMember.getTypeNumber())) continue;
            Collection<DataGatherGLMember> glMembers = glDataRowMember.getSubMembers();
            if (glMembers == null || glMembers.size() == 0) {
                return false;
            }
            for (DataGatherGLMember glMember : glMembers) {
                if (!memberMappingEntry.getBusinessMemberNumberExt().equals(glMember.getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMatchAssNumber2(DataGatherMappingMemberEntry memberMappingEntry, DataGatherMappingMember dimMemberMapping, List<DataGatherGLTypeRange> glDataRowMembers) {
        if (memberMappingEntry.getBusinessMemberNumberExt().isEmpty()) {
            return this.isMatchEmptyAssist(glDataRowMembers);
        }
        return this.isMatchNoEmptyAssist(memberMappingEntry, dimMemberMapping, glDataRowMembers);
    }

    private static class InnerClass {
        private static DataGatherDoMemberMapping instance = new DataGatherDoMemberMapping();

        private InnerClass() {
        }
    }
}

