/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.dataGather.entity.DataGatherGL;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.business.dataGather.entity.DataGatherGLTypeRange;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDimEntry;
import kd.epm.eb.business.dataGather.entity.DataGatherMiddleTable;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherDoMapping;
import kd.epm.eb.business.dataGather.service.DataGatherGLTypeRangeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class DataGatherDoSourceFieldMapping {
    private static final Log log = LogFactory.getLog(DataGatherDoMapping.class);
    private Map<String, DataGatherGLTypeRange> acctTypeValues_out;

    public static DataGatherDoSourceFieldMapping getInstance() {
        return InnerClass.instance;
    }

    private DataGatherDoSourceFieldMapping() {
    }

    public String getDimNumberBySourceField(IModelCacheHelper modelcache, DataGatherMappingDimEntry dimMapping, DataGatherMiddleTable GLDataTableData, DataGatherGL glGather, Map<String, DataGatherGLTypeRange> acctTypeValues_out, Map<String, Set<String>> ebTypeValues_out) {
        Set<String> GLMembers;
        this.acctTypeValues_out = acctTypeValues_out;
        Set<String> ebMembers = null;
        ebMembers = "gl_org".equalsIgnoreCase(dimMapping.getSourceFieldTable()) ? this.getEbMembers(modelcache, "Entity", ebTypeValues_out) : this.getEbMembers(modelcache, dimMapping.getDimKeyNumber(), ebTypeValues_out);
        Set<String> sameNumbers = this.getMixMembers(ebMembers, GLMembers = this.getGlTypeMembers(dimMapping, glGather));
        if (sameNumbers == null || sameNumbers.size() == 0) {
            return DataGatherCommon.getNoMatchInfo(ResManager.loadResFormat((String)"%1\u6ca1\u6709\u76f8\u540c\u7684\u7f16\u7801", (String)"DataGatherDoMapping_7", (String)"epm-eb-business", (Object[])new Object[]{dimMapping.getDimKeyName()}));
        }
        return this.matchSameNumber(dimMapping, sameNumbers, GLDataTableData);
    }

    private Set<String> getEbMembers(IModelCacheHelper modelcache, String ebDimKey, Map<String, Set<String>> ebTypeValues_out) {
        Set<String> dimMembers = ebTypeValues_out.get(ebDimKey);
        if (dimMembers == null) {
            dimMembers = this.getEBDimLeafs(modelcache, ebDimKey);
            ebTypeValues_out.put(ebDimKey, dimMembers);
        }
        return dimMembers;
    }

    private Set<String> getMixMembers(Set<String> mainSets, Set<String> secondSets) {
        if (mainSets == null || mainSets.size() == 0 || secondSets == null || secondSets.size() == 0) {
            return null;
        }
        HashSet<String> mixOrgs = new HashSet<String>(16);
        mixOrgs.addAll(mainSets);
        mixOrgs.retainAll(secondSets);
        return mixOrgs;
    }

    private Set<String> getEBDimLeafs(IModelCacheHelper modelCache, String dimKey) {
        List members = new ArrayList(DataGatherCommon.initSize);
        switch (dimKey) {
            case "Entity": {
                members = modelCache.getLeaf(modelCache.getMember(SysDimensionEnum.Entity.getNumber(), null, "Entity"));
                break;
            }
            case "Account": {
                members = modelCache.getLeaf(modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, "Account"));
                break;
            }
            default: {
                members = modelCache.getLeaf(modelCache.getMember(SysDimensionEnum.Project.getNumber(), null, dimKey));
            }
        }
        return members.stream().map(member -> member.getNumber()).collect(Collectors.toSet());
    }

    private String matchSameNumber(DataGatherMappingDimEntry dimMapping, Set<String> sameNumbers, DataGatherMiddleTable GLDataTableData) {
        if (dimMapping.getSourceFieldTable().equalsIgnoreCase("gl_org")) {
            return this.matchSameNumberGLOrg(dimMapping, sameNumbers, GLDataTableData);
        }
        DataGatherGLTypeRange obj = DataGatherGLTypeRangeUtils.getInstance().findGLTypeRange(DataGatherGLTypeRangeUtils.getInstance().getGLTypeKey(dimMapping), this.acctTypeValues_out);
        if (obj == null) {
            return DataGatherCommon.getNoMatchInfo(ResManager.loadResFormat((String)"%1\u6ca1\u6709\u83b7\u53d6\u5230\u7c7b\u578b\u4e3a%2\u7684\u6570\u636e\u3002", (String)"DataGatherDoMapping_12", (String)"epm-eb-business", (Object[])new Object[]{dimMapping.getDimKeyName(), dimMapping.getSourceFieldName()}));
        }
        List<DataGatherGLTypeRange> glRowDataMembers = GLDataTableData.getGlRowMembers();
        for (DataGatherGLTypeRange glRowDataMember : glRowDataMembers) {
            String returnNumber;
            if (!DataGatherGLTypeRangeUtils.getInstance().getAccountFormId(dimMapping.getSourceFieldTable()).equalsIgnoreCase(glRowDataMember.getTypeFormId()) || (obj.getFlexField() != null || glRowDataMember.getFlexField() != null) && !obj.getFlexField().equalsIgnoreCase(glRowDataMember.getFlexField()) || StringUtils.isEmpty((CharSequence)(returnNumber = this.getSameMember(dimMapping, sameNumbers, glRowDataMember)))) continue;
            return returnNumber;
        }
        return DataGatherCommon.getNoMatchInfo(ResManager.loadResFormat((String)"%1\u901a\u8fc7\u76f8\u540c\u7684\u7f16\u7801\u6ca1\u6709\u5339\u914d\u4e0a", (String)"DataGatherDoMapping_9", (String)"epm-eb-business", (Object[])new Object[]{dimMapping.getDimKeyName()}));
    }

    private String matchSameNumberGLOrg(DataGatherMappingDimEntry dimMapping, Set<String> sameNumbers, DataGatherMiddleTable GLDataTableData) {
        List<DataGatherGLTypeRange> glRowDataMembers = GLDataTableData.getGlRowMembers();
        for (DataGatherGLTypeRange glRowDataMember : glRowDataMembers) {
            String returnNumber;
            if (!dimMapping.getSourceFieldTable().equalsIgnoreCase(glRowDataMember.getTypeFormId()) || StringUtils.isEmpty((CharSequence)(returnNumber = this.getSameMember(dimMapping, sameNumbers, glRowDataMember)))) continue;
            return returnNumber;
        }
        return DataGatherCommon.getNoMatchInfo(ResManager.loadResFormat((String)"\u6838\u7b97\u7ec4\u7ec7%1\u5728\u660e\u7ec6\u9884\u7b97\u7ec4\u7ec7\u4e2d\u6ca1\u6709\u76f8\u540c\u7684\u7f16\u7801\u3002", (String)"DataGatherDoMapping_11", (String)"epm-eb-business", (Object[])new Object[]{GLDataTableData.getGlOrgNumber()}));
    }

    private String getSameMember(DataGatherMappingDimEntry dimMapping, Set<String> sameNumbers, DataGatherGLTypeRange glRowDataMember) {
        Set<String> GLMembers = DataGatherGLTypeRangeUtils.getInstance().getGLMembersFromGLRangeObj(glRowDataMember.getSubMembers());
        if (GLMembers == null || GLMembers.size() == 0) {
            return null;
        }
        Set<String> mixMembers = this.getMixMembers(sameNumbers, GLMembers);
        if (mixMembers != null && mixMembers.size() > 0) {
            return mixMembers.iterator().next();
        }
        mixMembers = this.getParentMixMembers(dimMapping, sameNumbers, glRowDataMember);
        if (mixMembers != null && mixMembers.size() > 0) {
            return mixMembers.iterator().next();
        }
        return "";
    }

    private Set<String> getParentMixMembers(DataGatherMappingDimEntry dimMapping, Set<String> sameNumbers, DataGatherGLTypeRange glRowDataMember) {
        Collection<DataGatherGLMember> glMembers = glRowDataMember.getSubMembers();
        if (glMembers == null || glMembers.size() == 0) {
            return null;
        }
        DataGatherGLTypeRange GLRange = this.getGLTypeRange(dimMapping);
        DataGatherGLTypeRangeUtils.getInstance().setParentMembers(glRowDataMember.getSubMembers(), GLRange.getSubMembers());
        for (DataGatherGLMember glMember : glMembers) {
            Collection<DataGatherGLMember> parents = glMember.getParentMembers();
            Set<String> parentNumbers = DataGatherGLTypeRangeUtils.getInstance().getGLMembersFromGLRangeObj(parents);
            Set<String> mixMembers = this.getMixMembers(sameNumbers, parentNumbers);
            if (mixMembers == null || mixMembers.size() <= 0) continue;
            return mixMembers;
        }
        return null;
    }

    private Set<String> getGlTypeMembers(DataGatherMappingDimEntry dimMapping, DataGatherGL glGather) {
        HashSet<String> GLTypeMembers = new HashSet(DataGatherCommon.initSize);
        if (dimMapping.getSourceFieldTable().equalsIgnoreCase("gl_org")) {
            return DataGatherCommon.getGlOrgNameOrNums(glGather, true);
        }
        DataGatherGLTypeRange GLTypeRange = this.getGLTypeRange(dimMapping);
        GLTypeMembers = DataGatherGLTypeRangeUtils.getInstance().getGLMembersFromGLRangeObj(GLTypeRange.getSubMembers());
        return GLTypeMembers;
    }

    private DataGatherGLTypeRange getGLTypeRange(DataGatherMappingDimEntry dimMapping) {
        String glTypeKey = DataGatherGLTypeRangeUtils.getInstance().getGLTypeKey(dimMapping);
        DataGatherGLTypeRangeUtils.getInstance().getGLTypeRange(glTypeKey, dimMapping.getSourceFieldTable(), dimMapping.getSourceFieldID(), this.acctTypeValues_out);
        return DataGatherGLTypeRangeUtils.getInstance().findGLTypeRange(glTypeKey, this.acctTypeValues_out);
    }

    private static class InnerClass {
        private static DataGatherDoSourceFieldMapping instance = new DataGatherDoSourceFieldMapping();

        private InnerClass() {
        }
    }
}

