/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.service.DataGatherCollectSchemeService;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherGLDATAQueryService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.datagather.GlobalVar;

public class DataGatherExecuteSchemeService {
    private static final Log log = LogFactory.getLog(DataGatherExecuteSchemeService.class);

    public static DataGatherExecuteSchemeService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherExecuteSchemeService() {
    }

    public List<DataGatherExecuteScheme> getDataTransExcuteScheme(Long modelID, List<Long> excuteSchemeIds, DataGatherHandCallParam param) {
        if (excuteSchemeIds == null || excuteSchemeIds.size() == 0) {
            return null;
        }
        DataGatherCommon.doLogWithTime(0L, "begin queryExcuteSchemes:" + excuteSchemeIds.toString(), log);
        List<DataGatherExecuteScheme> excuteSchemes = this.queryExcuteSchemes(modelID, excuteSchemeIds);
        DataGatherCommon.doLogWithTime(0L, "begin getAllCollectSchemeIDs:" + excuteSchemeIds.toString(), log);
        List<Long> allCollectSchemeIDs = this.getAllCollectSchemeIDs(excuteSchemes);
        DataGatherCommon.doLogWithTime(0L, "begin getDataTransCollectScheme:" + excuteSchemeIds.toString(), log);
        List<DataGatherCollectScheme> collectionSchemes = DataGatherCollectSchemeService.getInstance().getDataTransCollectScheme(modelID, allCollectSchemeIDs, param);
        this.getHandOrgsLevel(modelID, param);
        DataGatherCommon.doLogWithTime(0L, "begin setCollectSchemes:" + excuteSchemeIds.toString(), log);
        this.setCollectSchemes(excuteSchemes, collectionSchemes, param);
        return excuteSchemes;
    }

    private void getHandOrgsLevel(Long modelID, DataGatherHandCallParam param) {
        if (param == null || param.getOrgNums() == null || param.getOrgNums().size() == 0) {
            return;
        }
        Set<String> orgs = param.getOrgNums();
        HashSet<String> allOrgs = new HashSet<String>(DataGatherCommon.initSize);
        IModelCacheHelper model = ModelCacheContext.getOrCreate((Long)modelID);
        for (String org : orgs) {
            List members = ModelCacheServiceHelper.getMember((Model)model.getModelobj(), (String)SysDimensionEnum.Entity.getNumber(), (String)org, (int)RangeEnum.ALL.getIndex());
            for (Member member : members) {
                allOrgs.add(member.getNumber());
            }
        }
        param.setOrgNums(allOrgs);
    }

    private List<DataGatherExecuteScheme> queryExcuteSchemes(Long modelID, List<Long> excuteSchemeIds) {
        String selectFields = "id,number,name,model,startdate,enddate,executeplan,status,fetch,remind,entryentity.project,entryentity.order";
        QFilter qFilter = new QFilter("id", "in", excuteSchemeIds);
        qFilter.and(new QFilter("model", "=", (Object)modelID));
        String formID = "eb_collectionexecute";
        ArrayList<DataGatherExecuteScheme> returns = new ArrayList<DataGatherExecuteScheme>(DataGatherCommon.initSize);
        DynamicObject[] dataRows = BusinessDataServiceHelper.load((String)formID, (String)selectFields, (QFilter[])qFilter.toArray());
        if (dataRows == null || dataRows.length == 0) {
            DataGatherCommon.doLogWithTime(0L, " queryExcuteSchemes: null or 0" + excuteSchemeIds.toString(), log);
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6267\u884c\u65b9\u6848\uff01", (String)"DataGatherExecuteSchemeService_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        DataGatherCommon.doLogWithTime(0L, " queryExcuteSchemes.size:" + dataRows.length, log);
        Integer fetch = (Integer)GlobalVar.fetch.get();
        for (DynamicObject dataRow : dataRows) {
            if (!dataRow.getBoolean("status")) continue;
            DataGatherExecuteScheme scheme = new DataGatherExecuteScheme();
            scheme.setModelID(modelID);
            scheme.setModelShowNumber(dataRow.getString("model.shownumber"));
            scheme.setModelNumber(dataRow.getString("model.number"));
            scheme.setModelName(dataRow.getString("model.name"));
            scheme.setID(dataRow.getLong("id"));
            scheme.setNumber(dataRow.getString("number"));
            scheme.setName(dataRow.getString("name"));
            scheme.setStatus(dataRow.getBoolean("status"));
            scheme.setStartDate(dataRow.getDate("startdate"));
            scheme.setEndDate(dataRow.getDate("enddate"));
            scheme.setFetchPeriod(fetch != null ? fetch.intValue() : dataRow.getInt("fetch"));
            scheme.setRemindNote(dataRow.getBoolean("remind"));
            scheme.setExecutePlan(dataRow.getString("executeplan"));
            List<Long> colSchemes = this.getCollectionSchemeIDsBySingleExcute(dataRow);
            if (colSchemes == null || colSchemes.size() == 0) continue;
            scheme.setCollectSchemeIDs(colSchemes);
            returns.add(scheme);
        }
        return returns;
    }

    private List<Long> getCollectionSchemeIDsBySingleExcute(DynamicObject dataRow) {
        if (dataRow == null) {
            return null;
        }
        DynamicObjectCollection dt = (DynamicObjectCollection)dataRow.get("entryentity");
        if (dt == null) {
            return null;
        }
        ArrayList<Long> returns = new ArrayList<Long>(DataGatherCommon.initSize);
        for (int i = 0; i < dt.size(); ++i) {
            Long collectionSchemeID = ((DynamicObject)dt.get(i)).getLong("project.id");
            returns.add(collectionSchemeID);
        }
        return returns;
    }

    private void setCollectSchemes(List<DataGatherExecuteScheme> excuteSchemes, List<DataGatherCollectScheme> collectionSchemes, DataGatherHandCallParam param) {
        if (excuteSchemes == null || excuteSchemes.size() == 0) {
            DataGatherCommon.doLogWithTime(0L, "excuteSchemes or 0 ", log);
            return;
        }
        if (collectionSchemes == null || collectionSchemes.size() == 0) {
            DataGatherCommon.doLogWithTime(0L, "collectionSchemes\uff1anull or 0 ", log);
            return;
        }
        DataGatherCommon.doLogWithTime(0L, "collectionSchemes.size: " + collectionSchemes.size(), log);
        for (DataGatherExecuteScheme excuteScheme : excuteSchemes) {
            excuteScheme.setHandCallParam(param);
            List<Long> collectSchemeIds = excuteScheme.getCollectSchemeIDs();
            if (collectSchemeIds == null || collectSchemeIds.size() == 0) continue;
            excuteScheme.setCollectSchemeInfos(this.getcollectSchemeInfos(excuteScheme, collectSchemeIds, collectionSchemes, param));
        }
    }

    private List<DataGatherCollectScheme> getcollectSchemeInfos(DataGatherExecuteScheme excuteScheme, List<Long> collectSchemeIds, List<DataGatherCollectScheme> collectionSchemes, DataGatherHandCallParam param) {
        if (collectSchemeIds == null || collectSchemeIds.size() == 0) {
            return null;
        }
        if (collectionSchemes == null || collectionSchemes.size() == 0) {
            return null;
        }
        ArrayList<DataGatherCollectScheme> returns = new ArrayList<DataGatherCollectScheme>(DataGatherCommon.initSize);
        for (Long collectSchemeId : collectSchemeIds) {
            for (DataGatherCollectScheme collectionScheme : collectionSchemes) {
                if (!collectionScheme.getID().equals(collectSchemeId)) continue;
                DataGatherGLDATAQueryService.getInstance().setGlGatherPeriods(excuteScheme, collectionScheme, param);
                DataGatherCollectSchemeService.getInstance().setExcuteAndCollectOrgMix(excuteScheme, collectionScheme);
                returns.add(collectionScheme);
            }
        }
        return returns;
    }

    private List<Long> getAllCollectSchemeIDs(List<DataGatherExecuteScheme> excuteSchemes) {
        if (excuteSchemes == null || excuteSchemes.size() == 0) {
            return null;
        }
        ArrayList<Long> returns = new ArrayList<Long>(DataGatherCommon.initSize);
        for (DataGatherExecuteScheme colScheme : excuteSchemes) {
            List<Long> singleScheme = colScheme.getCollectSchemeIDs();
            if (singleScheme == null || singleScheme.size() == 0) continue;
            returns.addAll(singleScheme);
        }
        return returns;
    }

    private static class InnerClass {
        private static DataGatherExecuteSchemeService instance = new DataGatherExecuteSchemeService();

        private InnerClass() {
        }
    }
}

