/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherGL;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMiddleTable;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherPeriodsBGM;
import kd.epm.eb.business.dataGather.service.DataGatherPeriodsEB;
import kd.epm.eb.business.dataGather.service.SyncLoadDataForGlService;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.ebBusiness.model.BalanceQueryParam;

public class DataGatherGLDATAQueryService {
    private static final Log log = LogFactory.getLog(DataGatherGLDATAQueryService.class);

    public static DataGatherGLDATAQueryService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherGLDATAQueryService() {
    }

    public List<DataGatherMiddleTable> getGLDatasAndAssembly(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo, Map<Long, String> tableAccounts, DataGatherHandCallParam param) {
        long beginTime = System.nanoTime();
        this.doLogWithSchemeInfo(0L, "begin DataGatherGLDATAQueryService_querry GLdata. ", excuteSchemeInfo, collectSchemeInfo);
        if (collectSchemeInfo.getMixOrgs() == null || collectSchemeInfo.getMixOrgs().size() == 0) {
            this.doLogWithSchemeInfo(0L, "no mixOrgs. ", excuteSchemeInfo, collectSchemeInfo);
            return null;
        }
        List<BalanceQueryParam> balanceQueryParams = this.buildGLQueryParams(collectSchemeInfo.getGlGather());
        this.doLogWithSchemeInfo(0L, "begin doQueryGLData,balanceQueryParams.size = " + (balanceQueryParams == null ? 0 : balanceQueryParams.size()), excuteSchemeInfo, collectSchemeInfo);
        List<DataGatherMiddleTable> returns = SyncLoadDataForGlService.getInstance().doQueryGLDataAndAssembly(excuteSchemeInfo, collectSchemeInfo, balanceQueryParams, tableAccounts, param);
        this.doLogWithSchemeInfo(beginTime, "end querry GLdata,GLDatas.size =  " + (returns == null ? 0 : returns.size()), excuteSchemeInfo, collectSchemeInfo);
        return returns;
    }

    public void setGlGatherAccountParams(DataGatherGL glGatherParam, Set<Long> tableAccounts) {
        if (glGatherParam == null) {
            return;
        }
        if (tableAccounts == null || tableAccounts.size() == 0) {
            return;
        }
        HashMap<Long, List<Map<String, Long>>> accountAssgrp = new HashMap<Long, List<Map<String, Long>>>(tableAccounts.size());
        for (Long tableAccount : tableAccounts) {
            accountAssgrp.put(tableAccount, null);
        }
        glGatherParam.setAccountAssgrp(accountAssgrp);
    }

    public void setGlGatherPeriods(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectionScheme, DataGatherHandCallParam param) {
        if (param.getAppNum().equalsIgnoreCase(ApplicationTypeEnum.EB.getAppnum())) {
            DataGatherPeriodsEB.getInstance().setGlGatherPeriods(excuteSchemeInfo, collectionScheme, param);
        }
        if (param.getAppNum().equalsIgnoreCase(ApplicationTypeEnum.BGM.getAppnum())) {
            DataGatherPeriodsBGM.getInstance().setGlGatherPeriods(excuteSchemeInfo, collectionScheme, param);
        }
    }

    private void doLogWithSchemeInfo(long beginTime, String logInfo, DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo) {
        DataGatherCommon.doLogWithTime(beginTime, logInfo + "--" + excuteSchemeInfo.getNumber() + "--" + collectSchemeInfo.getNumber(), log);
    }

    private List<BalanceQueryParam> buildGLQueryParams(DataGatherGL glParams) {
        return this.buildParamsByPeriods(glParams);
    }

    private List<BalanceQueryParam> buildParamsByPeriods(DataGatherGL glParams) {
        Collection<Long> periods = glParams.getPeriodIds();
        if (!this.periodIsValiad(periods)) {
            DataGatherCommon.doLogWithTime(0L, "no period to get GLData ", log);
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u6ca1\u6709\u5339\u914d\u4e0a\u3002", (String)"DataGatherGLDATAQueryService_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        ArrayList<BalanceQueryParam> returns = new ArrayList<BalanceQueryParam>(DataGatherCommon.initSize);
        for (Long period : periods) {
            if (period == 0L) continue;
            BalanceQueryParam param = new BalanceQueryParam();
            this.setFixParams(param, glParams);
            param.setPeriodId(period.longValue());
            returns.add(param);
        }
        return returns;
    }

    private boolean periodIsValiad(Collection<Long> periods) {
        if (periods == null || periods.size() == 0) {
            return false;
        }
        for (Long period : periods) {
            if (period <= 0L) continue;
            return true;
        }
        return false;
    }

    private void setFixParams(BalanceQueryParam param, DataGatherGL glParams) {
        param.setAccountTableId(glParams.getAccountTableID().longValue());
        param.setOrgIds(DataGatherCommon.getGlOrgIds(glParams));
        param.setCurrencyId(glParams.getCurrencyID().longValue());
        param.setBookTypeId(glParams.getBookType().longValue());
        param.setSubstractPL(true);
        this.setAccountAssgrpParams(param, glParams);
        param.addSelector("org");
        param.addSelector("account");
        param.addSelector("assgrp");
        param.addSelector("debitfor");
        param.addSelector("creditfor");
        param.addSelector("debitlocal");
        param.addSelector("creditlocal");
        param.addGroupBy("org");
        param.addGroupBy("account");
        param.addGroupBy("assgrp");
    }

    private void setAccountAssgrpParams(BalanceQueryParam param, DataGatherGL glParams) {
        if (glParams == null || glParams.getAccountAssgrp() == null) {
            return;
        }
        if (param == null) {
            return;
        }
        Map<Long, List<Map<String, Long>>> accountAssgrps = glParams.getAccountAssgrp();
        for (Map.Entry<Long, List<Map<String, Long>>> accountAssgrp : accountAssgrps.entrySet()) {
            param.setAccountAssgrp(accountAssgrp.getKey(), accountAssgrp.getValue());
        }
    }

    private static class InnerClass {
        private static DataGatherGLDATAQueryService instance = new DataGatherGLDATAQueryService();

        private InnerClass() {
        }
    }
}

