/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherGL;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.business.dataGather.entity.DataGatherGLTypeRange;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMiddleTable;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherGLAssInfoService;
import kd.epm.eb.business.dataGather.service.DataGatherGLTypeRangeUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.model.BalanceQueryParam;

public class DataGatherGLMiddleTableService {
    private static final Log log = LogFactory.getLog(DataGatherGLMiddleTableService.class);

    public static DataGatherGLMiddleTableService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherGLMiddleTableService() {
    }

    public void saveDataToMiddleTable(DataGatherExecuteScheme excuteSchemeInfo, List<DataGatherMiddleTable> DataGatherMiddleTables, String status) {
        List<DynamicObject> saveDataObjs = this.getSaveDataObjs(excuteSchemeInfo, DataGatherMiddleTables, status);
        if (saveDataObjs == null || saveDataObjs.size() == 0) {
            DataGatherCommon.doLogWithTime(0L, "saveDataObjs is null or 0 " + excuteSchemeInfo.getNumber(), log);
            return;
        }
        DataGatherCommon.doLogWithTime(0L, "saveDataObjs.size: " + saveDataObjs.size() + ":" + excuteSchemeInfo.getNumber(), log);
        SaveServiceHelper.save((IDataEntityType)saveDataObjs.get(0).getDataEntityType(), (Object[])saveDataObjs.toArray());
    }

    public void deleteDataFromMiddleTable(List<Long> excuteSchemeIds) {
        if (excuteSchemeIds != null && excuteSchemeIds.size() > 0) {
            QFBuilder qFilters = new QFBuilder().add("excutescheme", "in", excuteSchemeIds);
            DeleteServiceHelper.delete((String)"eb_datagatherdata", (QFilter[])qFilters.toArray());
        }
    }

    public List<DataGatherMiddleTable> assemblyData(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo, List<Map<String, Object>> datas, Map<Long, String> tableAccounts, BalanceQueryParam balanceQueryParam, DataGatherHandCallParam param) {
        this.doLogWithSchemeInfo(0L, "begin assemblyData,datas.size = " + (datas == null ? 0 : datas.size()), excuteSchemeInfo, collectSchemeInfo);
        ArrayList<DataGatherMiddleTable> DataGatherMiddleTables = new ArrayList<DataGatherMiddleTable>(DataGatherCommon.initSize);
        if (datas == null || datas.size() == 0) {
            return DataGatherMiddleTables;
        }
        this.doLogWithSchemeInfo(0L, "begin assemblyData Loop: " + (datas == null ? 0 : datas.size()), excuteSchemeInfo, collectSchemeInfo);
        long glPeriod = balanceQueryParam.getPeriodId();
        for (Map<String, Object> dataMap : datas) {
            DataGatherMiddleTable middleDataSingle = new DataGatherMiddleTable();
            this.assemblySchemeInfo(excuteSchemeInfo, collectSchemeInfo, middleDataSingle);
            this.assemblyEntryOtherFields(dataMap, middleDataSingle, glPeriod);
            DataGatherMiddleTables.add(middleDataSingle);
        }
        this.doLogWithSchemeInfo(0L, "begin assemblyData, setGlAccountNumber: ", excuteSchemeInfo, collectSchemeInfo);
        this.setGlOrgAccountNumberAndDC(tableAccounts, DataGatherMiddleTables, collectSchemeInfo.getGlGather());
        this.doLogWithSchemeInfo(0L, "begin assemblyData, getAssInfos: ", excuteSchemeInfo, collectSchemeInfo);
        this.getAssInfos(DataGatherMiddleTables, param);
        this.doLogWithSchemeInfo(0L, "end assemblyData Loop, DataGatherMiddleTables.size = " + DataGatherMiddleTables.size(), excuteSchemeInfo, collectSchemeInfo);
        return DataGatherMiddleTables;
    }

    private DataGatherGLMember findGatherGLMember(DataGatherGL glGather, Long orgId) {
        if (glGather == null || glGather.getGlOrgs() == null) {
            return null;
        }
        Collection<DataGatherGLMember> gatherGLMembers = glGather.getGlOrgs();
        for (DataGatherGLMember gatherGLMember : gatherGLMembers) {
            if (orgId.compareTo(gatherGLMember.getId()) != 0) continue;
            return gatherGLMember;
        }
        return null;
    }

    private void setGlOrgAccountNumberAndDC(Map<Long, String> tableAccounts, List<DataGatherMiddleTable> GlDataTableDatas, DataGatherGL glGather) {
        if (tableAccounts == null || tableAccounts.size() == 0) {
            return;
        }
        if (GlDataTableDatas == null || GlDataTableDatas.size() == 0) {
            return;
        }
        Iterator<DataGatherMiddleTable> iterator = GlDataTableDatas.iterator();
        while (iterator.hasNext()) {
            DataGatherMiddleTable GlDataTableData;
            String glAccountNumberAndDC = tableAccounts.get((GlDataTableData = iterator.next()).getGlAccount());
            GlDataTableData.setGlAccountNumber(glAccountNumberAndDC == null ? null : glAccountNumberAndDC.split("!")[0]);
            GlDataTableData.setDc(glAccountNumberAndDC == null ? null : glAccountNumberAndDC.split("!")[1]);
            DataGatherGLMember gatherGLMember = this.findGatherGLMember(glGather, Long.valueOf(GlDataTableData.getGlOrg().toString()));
            GlDataTableData.setGlOrgNumber(gatherGLMember == null ? null : gatherGLMember.getNumber());
            GlDataTableData.setGlOrgName(gatherGLMember == null ? null : gatherGLMember.getName());
        }
    }

    private void getAssInfos(List<DataGatherMiddleTable> DataGatherDatas, DataGatherHandCallParam param) {
        DataGatherCommon.doLogWithTime(0L, "getAssInfos begin", log);
        List<Long> assZuHeIds = this.getAssIds(DataGatherDatas);
        Collection<DataGatherGLTypeRange> assInfos = null;
        HashMap<String, List> assInfoMaps = null;
        if (assZuHeIds != null && assZuHeIds.size() != 0) {
            assInfos = DataGatherGLAssInfoService.getInstance().queryAssInfos(param.getSqlBatch(), assZuHeIds);
            DataGatherCommon.doLogWithTime(0L, "getAssInfos after query", log);
            if (assInfos != null && assInfos.size() > 0) {
                assInfoMaps = new HashMap<String, List>(assInfos.size() * 2 + 1);
                Iterator<DataGatherGLTypeRange> iterator = assInfos.iterator();
                while (iterator.hasNext()) {
                    DataGatherGLTypeRange next = iterator.next();
                    if (next == null) {
                        iterator.remove();
                        continue;
                    }
                    Long typeId = next.getTypeId();
                    if (typeId == null) {
                        iterator.remove();
                        continue;
                    }
                    List assInfoLsts = assInfoMaps.computeIfAbsent(typeId.toString(), k -> new ArrayList(16));
                    assInfoLsts.add(next);
                    assInfoMaps.put(typeId.toString(), assInfoLsts);
                    iterator.remove();
                }
            }
        }
        DataGatherCommon.doLogWithTime(0L, "getAssInfos end", log);
        this.setAssInfos(DataGatherDatas, assInfoMaps);
    }

    private void setAssInfos(List<DataGatherMiddleTable> DataGatherDatas, Map<String, List<DataGatherGLTypeRange>> assInfos) {
        DataGatherCommon.doLogWithTime(0L, "setAssInfos " + DataGatherDatas.size(), log);
        for (DataGatherMiddleTable DataGatherData : DataGatherDatas) {
            DataGatherData.setGlRowMembers(assInfos == null || assInfos.size() == 0 ? this.getAccountAndGLOrgToRangeObj(DataGatherData) : this.getMatchedAssInfos(assInfos, DataGatherData));
        }
    }

    private List<DataGatherGLTypeRange> getMatchedAssInfos(Map<String, List<DataGatherGLTypeRange>> assInfos, DataGatherMiddleTable DataGatherData) {
        List<DataGatherGLTypeRange> accountObj;
        if (assInfos == null || assInfos.size() == 0) {
            return null;
        }
        ArrayList<DataGatherGLTypeRange> returns = new ArrayList<DataGatherGLTypeRange>(DataGatherCommon.initSize);
        String assZuHeId = DataGatherData.getAssZuHeID().toString();
        List<DataGatherGLTypeRange> dataGatherGLTypeRanges = assInfos.get(assZuHeId);
        if (dataGatherGLTypeRanges != null && dataGatherGLTypeRanges.size() > 0) {
            returns.addAll(dataGatherGLTypeRanges);
        }
        if ((accountObj = this.getAccountAndGLOrgToRangeObj(DataGatherData)) != null) {
            returns.addAll(accountObj);
        }
        return returns;
    }

    private List<DataGatherGLTypeRange> getAccountAndGLOrgToRangeObj(DataGatherMiddleTable DataGatherData) {
        ArrayList<DataGatherGLTypeRange> objs = new ArrayList<DataGatherGLTypeRange>(DataGatherCommon.initSize);
        objs.addAll(this.getAccountToRangeObj(DataGatherData));
        objs.addAll(this.getGLOrgToRangeObj(DataGatherData));
        return objs;
    }

    private List<DataGatherGLTypeRange> getAccountToRangeObj(DataGatherMiddleTable DataGatherData) {
        ArrayList<DataGatherGLTypeRange> objs = new ArrayList<DataGatherGLTypeRange>(DataGatherCommon.initSize);
        DataGatherGLTypeRange glTypeRange = new DataGatherGLTypeRange();
        glTypeRange.setTypeFormId(DataGatherGLTypeRangeUtils.getInstance().getAccountFormId("bd_accountview"));
        ArrayList<DataGatherGLMember> glMembers = new ArrayList<DataGatherGLMember>(DataGatherCommon.initSize);
        DataGatherGLMember glMember = new DataGatherGLMember();
        glMember.setId(DataGatherData.getGlAccount() == null ? Long.valueOf(0L) : Long.valueOf(DataGatherData.getGlAccount().toString()));
        glMember.setNumber(DataGatherData.getGlAccountNumber());
        glMember.setName(DataGatherData.getGlAccountName());
        glMembers.add(glMember);
        glTypeRange.setSubMembers(glMembers);
        objs.add(glTypeRange);
        return objs;
    }

    private List<DataGatherGLTypeRange> getGLOrgToRangeObj(DataGatherMiddleTable DataGatherData) {
        ArrayList<DataGatherGLTypeRange> objs = new ArrayList<DataGatherGLTypeRange>(DataGatherCommon.initSize);
        DataGatherGLTypeRange glTypeRange = new DataGatherGLTypeRange();
        glTypeRange.setTypeFormId("gl_org");
        ArrayList<DataGatherGLMember> glMembers = new ArrayList<DataGatherGLMember>(DataGatherCommon.initSize);
        DataGatherGLMember glMember = new DataGatherGLMember();
        glMember.setId(DataGatherData.getGlOrg() == null ? Long.valueOf(0L) : Long.valueOf(DataGatherData.getGlOrg().toString()));
        glMember.setNumber(DataGatherData.getGlOrgNumber());
        glMember.setName(DataGatherData.getGlOrgName());
        glMembers.add(glMember);
        glTypeRange.setSubMembers(glMembers);
        objs.add(glTypeRange);
        return objs;
    }

    private List<Long> getAssIds(List<DataGatherMiddleTable> DataGatherDatas) {
        if (DataGatherDatas == null || DataGatherDatas.size() == 0) {
            return null;
        }
        ArrayList<Long> returns = new ArrayList<Long>(DataGatherCommon.initSize);
        for (DataGatherMiddleTable DataGatherData : DataGatherDatas) {
            returns.add(Long.parseLong(DataGatherData.getAssZuHeID().toString()));
        }
        return returns;
    }

    private List<DynamicObject> getSaveDataObjs(DataGatherExecuteScheme excuteSchemeInfo, List<DataGatherMiddleTable> saveDataObjs, String status) {
        DataGatherCommon.doLogWithTime(0L, "begin getSaveDataObjs: " + (saveDataObjs == null ? 0 : saveDataObjs.size()), log);
        if (saveDataObjs == null) {
            return null;
        }
        ArrayList<DynamicObject> returns = new ArrayList<DynamicObject>(saveDataObjs.size());
        DynamicObject billData = BusinessDataServiceHelper.newDynamicObject((String)"eb_datagatherdata");
        billData.set("model", (Object)excuteSchemeInfo.getModelID());
        billData.set("excutescheme", (Object)excuteSchemeInfo.getID());
        billData.set("middletable", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        billData.set("excutedate", (Object)TimeServiceHelper.now());
        billData.set("excuter", (Object)UserUtils.getUserId());
        billData.set("status", (Object)(saveDataObjs == null || saveDataObjs.size() == 0 ? "1" : status));
        DataGatherCommon.doLogWithTime(0L, "begin getSaveDataObjs: data.size = " + (saveDataObjs == null ? 0 : saveDataObjs.size()), log);
        DynamicObjectCollection entryCollect = billData.getDynamicObjectCollection("entryentity");
        for (DataGatherMiddleTable saveDataObjEntry : saveDataObjs) {
            DynamicObject entry = entryCollect.addNew();
            entry.set("collectscheme", (Object)saveDataObjEntry.getCollectschemeId());
            entry.set("glaccount", saveDataObjEntry.getGlAccount());
            entry.set("debitfor", saveDataObjEntry.getDebitfor());
            entry.set("creditfor", saveDataObjEntry.getCreditfor());
            entry.set("glperiod", saveDataObjEntry.getGlPeriod());
            entry.set("asstinfo", (Object)this.getAssInfoString(saveDataObjEntry.getGlRowMembers()));
            entry.set("ebdim", (Object)this.getEbDimInfoString(saveDataObjEntry));
            entry.set("issuc", (Object)saveDataObjEntry.getIsSuc());
            entry.set("value", saveDataObjEntry.getValue());
            entry.set("glorg", saveDataObjEntry.getGlOrg());
        }
        returns.add(billData);
        return returns;
    }

    private String getEbDimInfoString(DataGatherMiddleTable saveDataObj) {
        return saveDataObj.getEbDimInfo();
    }

    private String getAssInfoString(List<DataGatherGLTypeRange> assObjs) {
        if (assObjs == null || assObjs.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (DataGatherGLTypeRange assObj : assObjs) {
            if ("bd_accountview".equalsIgnoreCase(assObj.getTypeFormId()) || "gl_org".equalsIgnoreCase(assObj.getTypeFormId())) continue;
            switch (assObj.getValueType()) {
                case 1: 
                case 2: 
                case 3: {
                    str.append(assObj.getTypeName()).append("--").append(this.linkAssInfo(assObj.getSubMembers()));
                    break;
                }
            }
        }
        return str.toString();
    }

    private String linkAssInfo(Collection<DataGatherGLMember> subMembers) {
        if (subMembers == null || subMembers.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (DataGatherGLMember subMember : subMembers) {
            str.append("(").append(subMember.getName()).append(")").append(":").append(subMember.getNumber()).append(";");
        }
        return str.toString();
    }

    private void doLogWithSchemeInfo(long beginTime, String logInfo, DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo) {
        DataGatherCommon.doLogWithTime(beginTime, logInfo + "--" + excuteSchemeInfo.getNumber() + "--" + collectSchemeInfo.getNumber(), log);
    }

    private void assemblySchemeInfo(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo, DataGatherMiddleTable middleDataSingle) {
        middleDataSingle.setModel(excuteSchemeInfo.getModelID());
        middleDataSingle.setExcuteschemeId(excuteSchemeInfo.getID());
        middleDataSingle.setCollectschemeId(collectSchemeInfo.getID());
    }

    private void assemblyEntryOtherFields(Map<String, Object> dataMap, DataGatherMiddleTable middleDataSingle, long glPeriod) {
        if (dataMap == null || dataMap.size() == 0) {
            return;
        }
        middleDataSingle.setGlAccount(dataMap.get("account"));
        middleDataSingle.setDebitfor(dataMap.get("debitfor"));
        middleDataSingle.setCreditfor(dataMap.get("creditfor"));
        middleDataSingle.setGlPeriod(glPeriod);
        middleDataSingle.setAssZuHeID(dataMap.get("assgrp"));
        middleDataSingle.setGlOrg(dataMap.get("org"));
    }

    private static class InnerClass {
        private static DataGatherGLMiddleTableService instance = new DataGatherGLMiddleTableService();

        private InnerClass() {
        }
    }
}

